/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.menus.context;

import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.menus.context.ContextMenuListener;
import edu.uthscsa.ric.roi.mask.buffers.AbstractROIBuffer;
import edu.uthscsa.ric.roi.mask.manager.Solid;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;

public class ROIContextMenuActions
extends AbstractAction {
    private final ContextMenuListener listener;
    private final SliceViewer viewer;
    private final int color;
    private static final long serialVersionUID = 1L;
    public static final String ACTION_ANALYZE = "Analyze";
    public static final String ACTION_CONVEX_HULL = "Convex Hull";
    public static final String ACTION_DELETE = "Delete";
    public static final String ACTION_DILATE = "Dilate";
    public static final String ACTION_EDIT_LABEL = "Edit Label...";
    public static final String ACTION_ERODE = "Erode";
    public static final String ACTION_MOVE = "Move...";
    public static final String ACTION_SHRINK_WRAP = "Shrink Wrap";
    public static final int DEFAULT_KERNEL_SIZE = 3;
    private static final long[] MASKS = AbstractROIBuffer.getMasks();

    protected ROIContextMenuActions(SliceViewer viewer, ContextMenuListener listener, int color, String actionName) {
        super(actionName);
        this.viewer = viewer;
        this.listener = listener;
        this.color = color;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        if (actionCommand.equals(ACTION_ANALYZE)) {
            this.doAnalyze();
        } else if (actionCommand.equals(ACTION_DELETE)) {
            this.doDelete();
        } else if (actionCommand.equals(ACTION_EDIT_LABEL)) {
            this.doEditLabel();
        } else if (actionCommand.equals(ACTION_DILATE)) {
            this.doDilate();
        } else if (actionCommand.equals(ACTION_ERODE)) {
            this.doErode();
        } else if (actionCommand.equals(ACTION_SHRINK_WRAP)) {
            this.doShrinkWrap();
        } else if (actionCommand.equals(ACTION_CONVEX_HULL)) {
            this.doConvexHull();
        } else if (actionCommand.equals(ACTION_MOVE)) {
            this.doMove();
        }
    }

    private void doMove() {
        Solid solid = this.viewer.getROIManager().getSolid(this.color);
        this.viewer.selectCoordinate();
        this.viewer.setRoiColor(this.color);
        this.viewer.getROIManager().clear(MASKS[this.color], false, true);
        this.viewer.doActionAddShapeROI(solid.getSize(), !solid.isRound(), solid.isRound());
    }

    private void doAnalyze() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIContextMenuActions.this.viewer.runStat(ROIContextMenuActions.this.viewer.getROIManager().getROI(ROIContextMenuActions.this.color));
            }
        });
        workThread.start();
        this.notifyListener();
    }

    private void doConvexHull() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ROIContextMenuActions.this.viewer.doConvexHull(ROIContextMenuActions.this.viewer.getROIManager().getROI(ROIContextMenuActions.this.color), false);
            }
        });
        workThread.start();
        this.notifyListener();
    }

    private void doDelete() {
        this.viewer.doDeleteROI(this.viewer.getROIManager().getROI(this.color), false);
        this.notifyListener();
    }

    private void doDilate() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (ROIContextMenuActions.this.viewer.isMultiSliceMode()) {
                    ROIContextMenuActions.this.viewer.doDilate3D(3, MASKS[ROIContextMenuActions.this.color]);
                } else {
                    int statsDirection = ROIContextMenuActions.this.viewer.getMainSliceDirection();
                    int statsCurrentSlice = ROIContextMenuActions.this.viewer.getMainSliceNumber();
                    ROIContextMenuActions.this.viewer.doDilate2D(statsCurrentSlice, statsDirection, 3, MASKS[ROIContextMenuActions.this.color]);
                }
            }
        });
        workThread.start();
        this.notifyListener();
    }

    private void doEditLabel() {
        String name;
        String currentName = this.viewer.getROIManager().getLabel(this.color, null);
        if (StringUtils.isBlank((CharSequence)currentName)) {
            currentName = "";
        }
        if ((name = (String)JOptionPane.showInputDialog(this.viewer.getViewerContainer(), "Enter New Label", "", -1, null, null, currentName)) != null) {
            this.viewer.setLabel(this.viewer.getROIManager().getROI(this.color), name);
            this.viewer.labelChanged();
        }
        this.notifyListener();
    }

    private void doErode() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (ROIContextMenuActions.this.viewer.isMultiSliceMode()) {
                    ROIContextMenuActions.this.viewer.doErode3D(3, MASKS[ROIContextMenuActions.this.color]);
                } else {
                    int statsDirection = ROIContextMenuActions.this.viewer.getMainSliceDirection();
                    int statsCurrentSlice = ROIContextMenuActions.this.viewer.getMainSliceNumber();
                    ROIContextMenuActions.this.viewer.doErode2D(statsCurrentSlice, statsDirection, 3, MASKS[ROIContextMenuActions.this.color]);
                }
            }
        });
        workThread.start();
        this.notifyListener();
    }

    private void doShrinkWrap() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (ROIContextMenuActions.this.viewer.isMultiSliceMode()) {
                    ROIContextMenuActions.this.viewer.doShrinkWrap3D(ROIContextMenuActions.this.viewer.getCurrentScreenVolume().getScreenMin(), MASKS[ROIContextMenuActions.this.color], ROIContextMenuActions.this.color, false);
                } else {
                    int statsDirection = ROIContextMenuActions.this.viewer.getMainSliceDirection();
                    int statsCurrentSlice = ROIContextMenuActions.this.viewer.getMainSliceNumber();
                    ROIContextMenuActions.this.viewer.doShrinkWrap2D(statsDirection, statsCurrentSlice, ROIContextMenuActions.this.viewer.getCurrentScreenVolume().getScreenMin(), MASKS[ROIContextMenuActions.this.color], ROIContextMenuActions.this.color, false);
                }
            }
        });
        workThread.start();
        this.notifyListener();
    }

    private void notifyListener() {
        if (this.listener != null) {
            this.listener.contextMenuItemSelected();
        }
    }
}

