/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.menus.context;

import edu.uthscsa.ric.mango.components.MangoColorIcon;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.menus.context.ContextMenuListener;
import edu.uthscsa.ric.mango.viewerslice.menus.context.ROIContextMenuActions;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.roi.ROIDefaultLabels;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public final class ROIContextMenu
extends JPopupMenu {
    private final ContextMenuListener listener;
    private final SliceViewer viewer;
    private final int color;
    private static ROIContextMenu menu;
    private static final long serialVersionUID = 1L;
    public static final Font FONT;
    public static final int ICON_SIZE = 14;

    public static void doPop(SliceViewer viewer, ContextMenuListener listener, int color, Component comp, Point loc) {
        menu = new ROIContextMenu(viewer, listener, color);
        menu.show(comp, loc.x, loc.y);
    }

    private ROIContextMenu(SliceViewer viewer, ContextMenuListener listener, int color) {
        this.viewer = viewer;
        this.listener = listener;
        this.color = color;
        JLabel title = new JLabel(new MangoColorIcon(ROIColor.getColor(color), 14), 0);
        title.setPreferredSize(new Dimension(14, 14));
        title.setMaximumSize(title.getPreferredSize());
        title.setMinimumSize(title.getPreferredSize());
        title.setToolTipText(viewer.getROIManager().getLabel(color, ROIDefaultLabels.getDefaultLabelBitPlaneOrder(color, viewer.getROIManager().getBuffer().getMaximumColors())));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        titlePanel.add(Box.createHorizontalGlue());
        titlePanel.add(title);
        titlePanel.add(Box.createHorizontalGlue());
        this.add(titlePanel);
        this.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.add(this.makeMenuItem("Analyze"));
        this.add(new JToolBar.Separator(new Dimension(0, 6)));
        this.add(this.makeMenuItem("Dilate"));
        this.add(this.makeMenuItem("Erode"));
        if (viewer.getROIManager().isSolidShape(color)) {
            this.add(this.makeMenuItem("Move..."));
        }
        this.add(this.makeMenuItem("Shrink Wrap"));
        this.add(this.makeMenuItem("Convex Hull"));
        this.add(this.makeMenuItem("Edit Label..."));
        this.add(new JToolBar.Separator(new Dimension(0, 6)));
        this.add(this.makeMenuItem("Delete"));
    }

    private JMenuItem makeMenuItem(String actionName) {
        JMenuItem menuItem = new JMenuItem(new ROIContextMenuActions(this.viewer, this.listener, this.color, actionName));
        menuItem.setFont(FONT);
        return menuItem;
    }

    static {
        FONT = new Font("SansSerif", 0, 11);
    }
}

