/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.menus.context;

import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.menus.context.ContextMenuListener;
import edu.uthscsa.ric.roi.lines.display.LOIShape;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;

public class LineContextMenuActions
extends AbstractAction {
    private final ContextMenuListener listener;
    private final LOIShape line;
    private final SliceViewer viewer;
    private static final long serialVersionUID = 1L;
    public static final String ACTION_ANALYZE = "Analyze";
    public static final String ACTION_CONVEX = "Convex Hull";
    public static final String ACTION_DELETE = "Delete";
    public static final String ACTION_EDIT_LABEL = "Edit Label...";
    public static final String ACTION_SMOOTH = "Smooth";

    protected LineContextMenuActions(SliceViewer viewer, ContextMenuListener listener, LOIShape line, String actionName) {
        super(actionName);
        this.viewer = viewer;
        this.listener = listener;
        this.line = line;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        if (actionCommand.equals(ACTION_ANALYZE)) {
            this.doAnalyze();
        } else if (actionCommand.equals(ACTION_DELETE)) {
            this.doDelete();
        } else if (actionCommand.equals(ACTION_SMOOTH)) {
            this.doSmooth();
        } else if (actionCommand.equals(ACTION_EDIT_LABEL)) {
            this.doEditLabel();
        } else if (actionCommand.equals(ACTION_CONVEX)) {
            this.doConvexHull();
        }
    }

    private void doAnalyze() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                LineContextMenuActions.this.viewer.runStat(LineContextMenuActions.this.line);
            }
        });
        workThread.start();
        this.notifyListener();
    }

    private void doConvexHull() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                LineContextMenuActions.this.viewer.runConvexHull(LineContextMenuActions.this.line);
            }
        });
        workThread.start();
        this.notifyListener();
    }

    private void doDelete() {
        this.viewer.doDeleteROI(this.line, true);
        this.notifyListener();
    }

    private void doEditLabel() {
        String name;
        String currentName = this.line.getName();
        if (StringUtils.isBlank((CharSequence)currentName)) {
            currentName = "";
        }
        if ((name = (String)JOptionPane.showInputDialog(this.viewer.getViewerContainer(), "Enter New Label", "", -1, null, null, currentName)) != null) {
            this.viewer.setLabel(this.line, name);
        }
        this.notifyListener();
    }

    private void doSmooth() {
        this.viewer.runSmooth(this.line);
        this.notifyListener();
    }

    private void notifyListener() {
        if (this.listener != null) {
            this.listener.contextMenuItemSelected();
        }
    }
}

