/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.menus.context;

import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPane;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.menus.context.ContextMenuListener;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.operations.OperationBuilder;
import edu.uthscsa.ric.volume.operations.stats.PointStatROIOp;
import edu.uthscsa.ric.volume.operations.stats.VolumeStatOp;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTextField;

public class ImageContextMenuActions
extends AbstractAction {
    private final ContextMenuListener listener;
    private final SliceViewer viewer;
    private final Coordinate4D coordinate;
    private static final long serialVersionUID = 1L;
    public static final String ACTION_ADD_POINT = "Bookmark...";
    public static final String ACTION_ANALYZE = "Analyze";
    public static final String ACTION_GOTO = "Go To...";
    public static final String ACTION_DELETE = "Delete";
    public static final String ACTION_DELETE_ALL = "Delete All";
    public static final String ACTION_GOTO_LOGGED = "GoTo ";

    protected ImageContextMenuActions(SliceViewer viewer, ContextMenuListener listener, Coordinate4D coordinate, String actionName) {
        super(actionName);
        this.viewer = viewer;
        this.listener = listener;
        this.coordinate = coordinate;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        if (actionCommand.equals(ACTION_ADD_POINT)) {
            this.doAddPoint();
        } else if (actionCommand.equals(ACTION_ANALYZE)) {
            this.doAnalyze();
        } else if (actionCommand.equals(ACTION_GOTO)) {
            this.viewer.selectCoordinate();
        } else if (actionCommand.equals(ACTION_DELETE_ALL)) {
            this.viewer.getVolume().clearLoggedPoints();
            this.viewer.updateWindowTitle();
        } else if (actionCommand.startsWith(ACTION_GOTO_LOGGED)) {
            int hash = Integer.parseInt(actionCommand.substring(ACTION_GOTO_LOGGED.length()));
            Coordinate coord = this.viewer.getVolume().findLoggedPointByHash(hash);
            this.viewer.setCurrentIndex(coord);
            this.viewer.updateSync();
            this.viewer.updateWindowTitle();
        } else if (actionCommand.equals(ACTION_DELETE) && !this.viewer.getVolume().removeBookmarkAtCoordinate(this.viewer.getCurrentIndex())) {
            this.viewer.showWarningDialog("Could not find a bookmark at that location!", "Bookmark Error");
        }
        this.notifyListener();
    }

    private String getDescription() {
        JTextField text = new JTextField("Bookmark");
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.viewer.getFrame(), (Object)text, "Edit Label", -1);
        int selection = jopf.show();
        if (selection == 0) {
            return text.getText();
        }
        return null;
    }

    private void doAddPoint() {
        String des = this.getDescription();
        if (des != null) {
            this.viewer.getVolume().addBookmark(this.viewer.getCurrentIndex(), des);
        }
    }

    private void notifyListener() {
        if (this.listener != null) {
            this.listener.contextMenuItemSelected();
        }
    }

    private void doAnalyze() {
        VolumeStatOp op = new VolumeStatOp(this.viewer, this.findSelectedVolume());
        OperationBuilder<Analysis> builder = new OperationBuilder<Analysis>(this.viewer, op);
        builder.runAsynchronously(this.viewer);
    }

    private Volume findSelectedVolume() {
        ScreenVolume[] overlays = this.viewer.getOverlayManager().getAllOverlays();
        Volume volume = null;
        for (int ctr = overlays.length - 1; ctr >= 0; --ctr) {
            if (overlays[ctr] == null) continue;
            Volume vol = overlays[ctr].getVolume();
            double threshold = overlays[ctr].getScreenMin();
            PointStatROIOp op = new PointStatROIOp(this.viewer, vol, this.viewer.getROIManager().getBuffer());
            double result = op.process(this.coordinate, vol.getCurrentTimepoint());
            if (!(result >= threshold)) continue;
            volume = vol;
            break;
        }
        if (volume == null) {
            volume = this.viewer.getBaseVolume();
        }
        return volume;
    }
}

