/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.keyboard;

import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.keyboard.KeyboardAction;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public final class KeyboardMap {
    public static final int MODIFIER_NONE = 0;
    public static final int MODIFIER_DEFAULT = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    public static final int MODIFIER_ALT = 512;
    public static final int MODIFIER_CONTROL = 128;
    public static final int MODIFIER_SHIFT = 64;
    public static final int MODIFIER_META = 256;
    public static final boolean PRESSED = false;
    public static final boolean RELEASED = true;

    private KeyboardMap() {
    }

    public static void createKeyboardMap(JComponent comp, SliceViewer viewer) {
        KeyboardMap.createAction(comp, viewer, "ACTION_ROI_SMALLER_TOOL_PRESSED", 82, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_ROI_SMALLER_TOOL_RELEASED", 82, 0, true);
        KeyboardMap.createAction(comp, viewer, "ACTION_ROI_DELETE", 8, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_ROI_COMPLETE_LINE", 10, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_ROI_TRANSLATE_UP", 38, 64, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_ROI_TRANSLATE_DOWN", 40, 64, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_ROI_TRANSLATE_LEFT", 37, 64, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_ROI_TRANSLATE_RIGHT", 39, 64, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_ROI_DECREMENT_TOOL_SIZE", 45, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_ROI_INCREMENT_TOOL_SIZE", 61, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_ROI_QUICK_KEY", 70, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_ROI_RECENT_TOOL", 70, 64, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_ROI_QUICK_COLOR_KEY", 68, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_ROI_QUICK_VISIBLE_KEY", 83, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_ROI_QUICK_CROSSHAIRS_KEY", 65, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_ROI_QUICK_THRESHOLD_OUTSIDE_KEY", 48, MODIFIER_DEFAULT, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_ROI_QUICK_THRESHOLD_INSIDE_KEY", 48, MODIFIER_DEFAULT | 0x40, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_NAV_COORDINATE", 27, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_NAV_ORIGIN", 79, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_NAV_CENTER", 67, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_NAV_AXIAL_DECREMENT", new int[]{33, 222}, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_NAV_AXIAL_INCREMENT", new int[]{34, 47}, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_NAV_CORONAL_DECREMENT", 38, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_NAV_CORONAL_INCREMENT", 40, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_NAV_SAGITTAL_DECREMENT", 37, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_NAV_SAGITTAL_INCREMENT", 39, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_NAV_SERIES_DECREMENT", new int[]{44, 153}, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_NAV_SERIES_INCREMENT", new int[]{46, 160}, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_NAV_ROTATE_VIEWS_CW", 32, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_NAV_ROTATE_VIEWS_CCW", 32, 64, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_NAV_SLICE_INCREMENT", 71, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_NAV_SLICE_DECREMENT", 86, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_NAV_ZOOM_TOGGLE", 90, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_NAV_NEXT_BOOKMARK", 66, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_MISC_TOOLBOX", 84, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_MISC_TAKE_PICTURE", 80, MODIFIER_DEFAULT, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_MISC_PIXEL_MODE_PRESSED", 80, 0, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_MISC_PIXEL_MODE_RELEASED", 80, 0, true);
        KeyboardMap.createAction(comp, viewer, "ACTION_MISC_SHIFT_MODE_ON", 16, 64, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_MISC_SHIFT_MODE_OFF", 16, 0, true);
        KeyboardMap.createAction(comp, viewer, "ACTION_MISC_META_MODE_ON", 157, 256, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_MISC_META_MODE_OFF", 157, 0, true);
        KeyboardMap.createAction(comp, viewer, "ACTION_MISC_ALT_MODE_ON", 18, 512, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_MISC_ALT_MODE_OFF", 18, 0, true);
        KeyboardMap.createAction(comp, viewer, "ACTION_MISC_ALTSHIFT_MODE_ON", 18, 576, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_MISC_ALTSHIFT_MODE_ON", 16, 576, false);
        KeyboardMap.createAction(comp, viewer, "ACTION_MISC_ALTSHIFT_MODE_OFF", 18, 0, true);
    }

    public static void createAction(JComponent comp, SliceViewer viewer, String name, int[] keyCodes, int modifiers, boolean onRelease) {
        for (int keyCode : keyCodes) {
            KeyboardMap.createAction(comp, viewer, name, keyCode, modifiers, onRelease);
        }
    }

    public static void createAction(JComponent comp, SliceViewer viewer, String name, int keyCode, int modifiers, boolean onRelease) {
        comp.getInputMap(2).put(KeyStroke.getKeyStroke(keyCode, modifiers, onRelease), name);
        comp.getActionMap().put(name, new KeyboardAction(viewer, name));
    }

    public static void createActionByPlatform(JComponent comp, SliceViewer viewer, String name, int keyCode, int modifiers, boolean onRelease, boolean mac, boolean windows, boolean unix) {
        if (mac && Platform.MAC) {
            KeyboardMap.createAction(comp, viewer, name, keyCode, modifiers, onRelease);
        } else if (windows && Platform.WINDOWS) {
            KeyboardMap.createAction(comp, viewer, name, keyCode, modifiers, onRelease);
        } else if (unix && Platform.UNIX) {
            KeyboardMap.createAction(comp, viewer, name, keyCode, modifiers, onRelease);
        }
    }
}

