/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.keyboard;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.utilities.DesktopUtilities;
import edu.uthscsa.ric.volume.Bookmark;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class KeyboardAction
extends AbstractAction {
    private final SliceViewer viewer;
    private final String actionName;
    public static final String ACTION_ROI = "ACTION_ROI";
    public static final String ACTION_ROI_SMALLER_TOOL_PRESSED = "ACTION_ROI_SMALLER_TOOL_PRESSED";
    public static final String ACTION_ROI_SMALLER_TOOL_RELEASED = "ACTION_ROI_SMALLER_TOOL_RELEASED";
    public static final String ACTION_ROI_DELETE = "ACTION_ROI_DELETE";
    public static final String ACTION_ROI_COMPLETE_LINE = "ACTION_ROI_COMPLETE_LINE";
    public static final String ACTION_ROI_TRANSLATE_UP = "ACTION_ROI_TRANSLATE_UP";
    public static final String ACTION_ROI_TRANSLATE_DOWN = "ACTION_ROI_TRANSLATE_DOWN";
    public static final String ACTION_ROI_TRANSLATE_LEFT = "ACTION_ROI_TRANSLATE_LEFT";
    public static final String ACTION_ROI_TRANSLATE_RIGHT = "ACTION_ROI_TRANSLATE_RIGHT";
    public static final String ACTION_ROI_DECREMENT_TOOL_SIZE = "ACTION_ROI_DECREMENT_TOOL_SIZE";
    public static final String ACTION_ROI_INCREMENT_TOOL_SIZE = "ACTION_ROI_INCREMENT_TOOL_SIZE";
    public static final String ACTION_ROI_QUICK_TOOL_KEY = "ACTION_ROI_QUICK_KEY";
    public static final String ACTION_ROI_RECENT_TOOL = "ACTION_ROI_RECENT_TOOL";
    public static final String ACTION_ROI_QUICK_COLOR_KEY = "ACTION_ROI_QUICK_COLOR_KEY";
    public static final String ACTION_ROI_QUICK_VISIBLE_KEY = "ACTION_ROI_QUICK_VISIBLE_KEY";
    public static final String ACTION_ROI_QUICK_CROSSHAIRS_KEY = "ACTION_ROI_QUICK_CROSSHAIRS_KEY";
    public static final String ACTION_ROI_QUICK_THRESHOLD_OUTSIDE_KEY = "ACTION_ROI_QUICK_THRESHOLD_OUTSIDE_KEY";
    public static final String ACTION_ROI_QUICK_THRESHOLD_INSIDE_KEY = "ACTION_ROI_QUICK_THRESHOLD_INSIDE_KEY";
    public static final String ACTION_NAV = "ACTION_NAV";
    public static final String ACTION_NAV_COORDINATE = "ACTION_NAV_COORDINATE";
    public static final String ACTION_NAV_ORIGIN = "ACTION_NAV_ORIGIN";
    public static final String ACTION_NAV_CENTER = "ACTION_NAV_CENTER";
    public static final String ACTION_NAV_AXIAL_INCREMENT = "ACTION_NAV_AXIAL_INCREMENT";
    public static final String ACTION_NAV_AXIAL_DECREMENT = "ACTION_NAV_AXIAL_DECREMENT";
    public static final String ACTION_NAV_CORONAL_INCREMENT = "ACTION_NAV_CORONAL_INCREMENT";
    public static final String ACTION_NAV_CORONAL_DECREMENT = "ACTION_NAV_CORONAL_DECREMENT";
    public static final String ACTION_NAV_SAGITTAL_INCREMENT = "ACTION_NAV_SAGITTAL_INCREMENT";
    public static final String ACTION_NAV_SAGITTAL_DECREMENT = "ACTION_NAV_SAGITTAL_DECREMENT";
    public static final String ACTION_NAV_SERIES_DECREMENT = "ACTION_NAV_SERIES_DECREMENT";
    public static final String ACTION_NAV_SERIES_INCREMENT = "ACTION_NAV_SERIES_INCREMENT";
    public static final String ACTION_NAV_ROTATE_VIEWS_CW = "ACTION_NAV_ROTATE_VIEWS_CW";
    public static final String ACTION_NAV_ROTATE_VIEWS_CCW = "ACTION_NAV_ROTATE_VIEWS_CCW";
    public static final String ACTION_NAV_SLICE_INCREMENT = "ACTION_NAV_SLICE_INCREMENT";
    public static final String ACTION_NAV_SLICE_DECREMENT = "ACTION_NAV_SLICE_DECREMENT";
    public static final String ACTION_NAV_ZOOM_TOGGLE = "ACTION_NAV_ZOOM_TOGGLE";
    public static final String ACTION_NAV_NEXT_BOOKMARK = "ACTION_NAV_NEXT_BOOKMARK";
    public static final String ACTION_MISC = "ACTION_MISC";
    public static final String ACTION_MISC_TOOLBOX = "ACTION_MISC_TOOLBOX";
    public static final String ACTION_MISC_TAKE_PICTURE = "ACTION_MISC_TAKE_PICTURE";
    public static final String ACTION_MISC_PIXEL_MODE_PRESSED = "ACTION_MISC_PIXEL_MODE_PRESSED";
    public static final String ACTION_MISC_PIXEL_MODE_RELEASED = "ACTION_MISC_PIXEL_MODE_RELEASED";
    public static final String ACTION_MISC_HELP = "ACTION_MISC_HELP";
    public static final String ACTION_MISC_SHIFT_MODE_ON = "ACTION_MISC_SHIFT_MODE_ON";
    public static final String ACTION_MISC_SHIFT_MODE_OFF = "ACTION_MISC_SHIFT_MODE_OFF";
    public static final String ACTION_MISC_META_MODE_ON = "ACTION_MISC_META_MODE_ON";
    public static final String ACTION_MISC_META_MODE_OFF = "ACTION_MISC_META_MODE_OFF";
    public static final String ACTION_MISC_ALT_MODE_ON = "ACTION_MISC_ALT_MODE_ON";
    public static final String ACTION_MISC_ALT_MODE_OFF = "ACTION_MISC_ALT_MODE_OFF";
    public static final String ACTION_MISC_ALTSHIFT_MODE_ON = "ACTION_MISC_ALTSHIFT_MODE_ON";
    public static final String ACTION_MISC_ALTSHIFT_MODE_OFF = "ACTION_MISC_ALTSHIFT_MODE_OFF";
    private static final long serialVersionUID = 1L;

    public KeyboardAction(SliceViewer viewer, String actionName) {
        this.viewer = viewer;
        this.actionName = actionName;
    }

    private void actionPerformedNav() {
        Bookmark bookmark;
        if (this.actionName.equals(ACTION_NAV_COORDINATE)) {
            this.viewer.selectCoordinate();
        } else if (this.actionName.equals(ACTION_NAV_ORIGIN)) {
            this.viewer.moveToOrigin();
        } else if (this.actionName.equals(ACTION_NAV_CENTER)) {
            this.viewer.moveToCenter();
        } else if (this.actionName.equals(ACTION_NAV_AXIAL_DECREMENT)) {
            this.viewer.decrementSlice(0);
        } else if (this.actionName.equals(ACTION_NAV_AXIAL_INCREMENT)) {
            this.viewer.incrementSlice(0);
        } else if (this.actionName.equals(ACTION_NAV_CORONAL_INCREMENT)) {
            this.viewer.incrementSlice(1);
        } else if (this.actionName.equals(ACTION_NAV_CORONAL_DECREMENT)) {
            this.viewer.decrementSlice(1);
        } else if (this.actionName.equals(ACTION_NAV_SAGITTAL_INCREMENT)) {
            if (Mango.getInstance().isRadiologicalMode()) {
                this.viewer.decrementSlice(2);
            } else {
                this.viewer.incrementSlice(2);
            }
        } else if (this.actionName.equals(ACTION_NAV_SAGITTAL_DECREMENT)) {
            if (Mango.getInstance().isRadiologicalMode()) {
                this.viewer.incrementSlice(2);
            } else {
                this.viewer.decrementSlice(2);
            }
        } else if (this.actionName.equals(ACTION_NAV_SERIES_DECREMENT)) {
            this.viewer.decrementSlice(3);
        } else if (this.actionName.equals(ACTION_NAV_SERIES_INCREMENT)) {
            this.viewer.incrementSlice(3);
        } else if (this.actionName.equals(ACTION_NAV_ROTATE_VIEWS_CW)) {
            this.viewer.toggleSliceViews(false);
        } else if (this.actionName.equals(ACTION_NAV_ROTATE_VIEWS_CCW)) {
            this.viewer.toggleSliceViews(true);
        } else if (this.actionName.equals(ACTION_NAV_SLICE_INCREMENT)) {
            this.viewer.incrementSlice(-1);
        } else if (this.actionName.equals(ACTION_NAV_SLICE_DECREMENT)) {
            this.viewer.decrementSlice(-1);
        } else if (this.actionName.equals(ACTION_NAV_ZOOM_TOGGLE)) {
            this.viewer.zoomToggle();
        } else if (this.actionName.equals(ACTION_NAV_NEXT_BOOKMARK) && (bookmark = this.viewer.getVolume().getNextBookmark()) != null) {
            this.viewer.setCurrentIndex(bookmark.getCoordinate());
            this.viewer.updateWindowTitle();
        }
    }

    private void actionPerformedROI() {
        if (this.actionName.equals(ACTION_ROI_DELETE)) {
            this.viewer.deleteAction(false);
        } else if (this.actionName.equals(ACTION_ROI_QUICK_THRESHOLD_OUTSIDE_KEY)) {
            this.viewer.quickThresholdKeyPressed(false);
        } else if (this.actionName.equals(ACTION_ROI_QUICK_THRESHOLD_INSIDE_KEY)) {
            this.viewer.quickThresholdKeyPressed(true);
        } else {
            this.viewer.recordAction("pauseScriptForUserInput");
            if (this.actionName.equals(ACTION_ROI_SMALLER_TOOL_PRESSED)) {
                this.viewer.setSmallROIToolSize(true);
            } else if (this.actionName.equals(ACTION_ROI_SMALLER_TOOL_RELEASED)) {
                this.viewer.setSmallROIToolSize(false);
            } else if (this.actionName.equals(ACTION_ROI_COMPLETE_LINE)) {
                this.viewer.getMainScreenSlice().makeLOI();
            } else if (this.actionName.equals(ACTION_ROI_TRANSLATE_UP)) {
                this.viewer.translate(0, -1);
            } else if (this.actionName.equals(ACTION_ROI_TRANSLATE_DOWN)) {
                this.viewer.translate(0, 1);
            } else if (this.actionName.equals(ACTION_ROI_TRANSLATE_LEFT)) {
                if (Mango.getInstance().isRadiologicalMode() && this.viewer.getMainScreenSlice().isRadiologicalSensitive()) {
                    this.viewer.translate(1, 0);
                } else {
                    this.viewer.translate(-1, 0);
                }
            } else if (this.actionName.equals(ACTION_ROI_TRANSLATE_RIGHT)) {
                if (Mango.getInstance().isRadiologicalMode() && this.viewer.getMainScreenSlice().isRadiologicalSensitive()) {
                    this.viewer.translate(-1, 0);
                } else {
                    this.viewer.translate(1, 0);
                }
            } else if (this.actionName.equals(ACTION_ROI_DECREMENT_TOOL_SIZE)) {
                if (this.viewer.isROIToolMode()) {
                    this.viewer.decrementROIToolSize();
                }
            } else if (this.actionName.equals(ACTION_ROI_INCREMENT_TOOL_SIZE)) {
                if (this.viewer.isROIToolMode()) {
                    this.viewer.incrementROIToolSize();
                }
            } else if (this.actionName.equals(ACTION_ROI_QUICK_TOOL_KEY)) {
                this.viewer.quickROIToolKeyPressed(false);
            } else if (this.actionName.equals(ACTION_ROI_RECENT_TOOL)) {
                this.viewer.quickROIToolKeyPressed(true);
            } else if (this.actionName.equals(ACTION_ROI_QUICK_COLOR_KEY)) {
                this.viewer.quickROIColorKeyPressed();
            } else if (this.actionName.equals(ACTION_ROI_QUICK_VISIBLE_KEY)) {
                this.viewer.quickROIVisibleKeyPressed();
            } else if (this.actionName.equals(ACTION_ROI_QUICK_CROSSHAIRS_KEY)) {
                this.viewer.setShowMainCrosshairs(!this.viewer.isShowingMainCrosshairs());
            }
        }
    }

    private void actionPerformedMisc() {
        if (this.actionName.equals(ACTION_MISC_TAKE_PICTURE)) {
            Mango.getInstance().getToolBox().takePicture();
        } else if (this.actionName.equals(ACTION_MISC_SHIFT_MODE_ON)) {
            this.viewer.setShiftKeyMode(true);
        } else if (this.actionName.equals(ACTION_MISC_SHIFT_MODE_OFF)) {
            this.viewer.setShiftKeyMode(false);
        } else if (this.actionName.equals(ACTION_MISC_META_MODE_ON)) {
            this.viewer.setMetaKeyMode(true);
        } else if (this.actionName.equals(ACTION_MISC_META_MODE_OFF)) {
            this.viewer.setMetaKeyMode(false);
        } else if (this.actionName.equals(ACTION_MISC_ALT_MODE_ON)) {
            this.viewer.setAltKeyMode(true);
        } else if (this.actionName.equals(ACTION_MISC_ALT_MODE_OFF)) {
            this.viewer.setAltKeyMode(false);
        } else if (this.actionName.equals(ACTION_MISC_ALTSHIFT_MODE_ON)) {
            this.viewer.setAltShiftKeyMode(true);
        } else if (this.actionName.equals(ACTION_MISC_ALTSHIFT_MODE_OFF)) {
            this.viewer.setAltShiftKeyMode(false);
        } else if (this.actionName.equals(ACTION_MISC_TOOLBOX)) {
            Mango.getInstance().getToolBox().toFront();
        } else if (this.actionName.equals(ACTION_MISC_PIXEL_MODE_PRESSED)) {
            this.viewer.setPixelMode(true);
        } else if (this.actionName.equals(ACTION_MISC_PIXEL_MODE_RELEASED)) {
            this.viewer.setPixelMode(false);
        } else if (this.actionName.equals(ACTION_MISC_HELP)) {
            DesktopUtilities.openURL((String)"http://rii.uthscsa.edu/mango//userguide.html");
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.viewer.clearKeyboardMode();
        if (Mango.getInstance().getToolBox().isTextFieldMinTouched()) {
            return;
        }
        if (Mango.getInstance().getToolBox().isTextFieldMinTouched()) {
            return;
        }
        if (!Mango.getInstance().isApplet() && this.viewer.getViewerFrame().isShowingLabelSeriesEditor()) {
            return;
        }
        if (this.actionName.startsWith(ACTION_ROI)) {
            this.actionPerformedROI();
        } else if (this.actionName.startsWith(ACTION_NAV)) {
            this.actionPerformedNav();
        } else if (this.actionName.startsWith(ACTION_MISC)) {
            this.actionPerformedMisc();
        }
    }
}

