/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.webpage;

import edu.uthscsa.ric.mango.Atlas;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.components.MangoPlaceholderTextField;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPane;
import edu.uthscsa.ric.mango.dialogs.modal.file.SaveFileDialog;
import edu.uthscsa.ric.mango.dialogs.script.ScriptUtils;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.plugin.atlases.atlasfsl.AtlasFSL;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.mango.viewerslice.dialogs.webpage.ImagePanel;
import edu.uthscsa.ric.mango.viewerslice.dialogs.webpage.SurfacePanel;
import edu.uthscsa.ric.mango.viewerslice.dialogs.webpage.WebpageImage;
import edu.uthscsa.ric.mango.viewerslice.dialogs.webpage.WebpageSurface;
import edu.uthscsa.ric.mango.viewerslice.screen.OverlayManager;
import edu.uthscsa.ric.mango.viewerslice.screen.OverlayManagerListener;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LookupTableManager;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.core.CompositeSurface;
import edu.uthscsa.ric.mango.viewersurface.operations.io.formats.gifti.GiftiFormat;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.DesktopUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormatException;
import edu.uthscsa.ric.visualization.surface.primitives.Surface;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeIOException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class Webpage
extends JFrame
implements ActionListener,
OverlayManagerListener {
    private ImagePanel baseImagePanel;
    private JButton createButton;
    private JButton moreOptionsButton;
    private JButton openButton;
    private JButton showFileButton;
    private JCheckBox atlasBox;
    private JCheckBox coordinateBox;
    private JCheckBox expandableBox;
    private JCheckBox kioskBox;
    private JCheckBox localBox;
    private JCheckBox orientationBox;
    private JCheckBox overlaysBox;
    private JCheckBox surfaceBox;
    private JCheckBox paddingBox;
    private JCheckBox singleFileBox;
    private JCheckBox singleSliceOnlyBox;
    private JCheckBox smallImageBox;
    private JCheckBox smoothDisplayBox;
    private JCheckBox worldSpaceBox;
    private JCheckBox radiologicalBox;
    private JCheckBox showRulerBox;
    private JCheckBox showControlsBox;
    private JCheckBox showControlBarBox;
    private JCheckBox combineParametricBox;
    private JComboBox<Atlas> atlasSelectBox;
    private JLabel bestForInfoLabel;
    private JLabel outputFileLabel;
    private JPanel atlasPanel;
    private JPanel optionsPanel;
    private JPanel overlayPanel;
    private JPanel surfacePanel;
    private JRadioButton bestForSharingButton;
    private JTextField titleText;
    private JTextField footnoteText;
    private JTextField webpageText;
    private Vector<ImagePanel> overlayImagePanels;
    private Vector<SurfacePanel> surfacePanels;
    private final SliceViewer viewer;
    private static boolean unpackedFiles;
    private static final long serialVersionUID = 1L;
    public static final String ACTION_ATLAS = "ACTION_ATLAS";
    public static final String ACTION_BEST_SERVER = "ACTION_BEST_SERVER";
    public static final String ACTION_BEST_SHARING = "ACTION_BEST_SHARING";
    public static final String ACTION_CREATE = "ACTION_CREATE";
    public static final String ACTION_OPTIONS = "ACTION_OPTIONS";
    public static final String ACTION_OVERLAYS = "ACTION_OVERLAYS";
    public static final String ACTION_SURFACES = "ACTION_SURFACES";
    public static final String ACTION_PLAY = "ACTION_PLAY";
    public static final String ACTION_SELECT_FILE = "ACTION_SELECT_FILE";
    public static final String ACTION_SHOW = "ACTION_SHOW";
    public static final String ACTION_SINGLE_FILE = "ACTION_SINGLE_FILE";
    public static final String DEFAULT_ATLAS_NAME = "Talairach (Nearest Grey Matter)";
    public static final String BEST_FOR_WEB_TEXT = "Creates files designed for a web server (will not work locally).";
    public static final String BEST_FOR_SHARING_TEXT = "Creates a file that can be opened locally on a computer.";
    public static final String EXTENSION = ".html";
    public static final String LIB_RESOURCE_DIR = "lib/";
    public static final String NAME = "Create Webpage";
    public static final String TEXT_FALSE = "false";
    public static final String TEXT_TRUE = "true";
    public static final int BUFFER_SIZE = 4096;
    public static final int PADDING = 8;

    private static String removeNiftiExtensions(String strVal) {
        String str = strVal;
        if (str.endsWith(".gz")) {
            str = str.substring(0, str.indexOf(".gz"));
        }
        if (str.endsWith(".nii")) {
            str = str.substring(0, str.indexOf(".nii"));
        }
        return str;
    }

    private static String removeGiftiExtensions(String strVal) {
        String str = strVal;
        if (str.endsWith(".gii")) {
            str = str.substring(0, str.indexOf(".gii"));
        }
        if (str.endsWith(".surf")) {
            str = str.substring(0, str.indexOf(".surf"));
        }
        return str;
    }

    private static String replaceNonAlphanumericCharacters(String strVal) {
        String str = strVal;
        if (Character.isDigit((str = str.replaceAll("[^A-Za-z0-9]", "_")).charAt(0)) || str.charAt(0) == '_') {
            str = "x" + str;
        }
        return str;
    }

    public Webpage(SliceViewer viewer) {
        this.viewer = viewer;
        this.createUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals(ACTION_SELECT_FILE)) {
            this.editSaveFile();
            this.updateEnabled();
        } else if (command.equals(ACTION_PLAY)) {
            this.play();
        } else if (command.equals(ACTION_SHOW)) {
            this.showFile();
        } else if (command.equals(ACTION_CREATE)) {
            this.create();
        } else if (command.equals(ACTION_OPTIONS)) {
            this.updateOptions();
        } else if (command.equals(ACTION_BEST_SHARING)) {
            this.singleFileBox.setSelected(true);
            this.localBox.setSelected(true);
            this.updateSingleFile();
            this.updateOutputFileText();
            this.updateEnabled();
            this.bestForInfoLabel.setText(BEST_FOR_SHARING_TEXT);
        } else if (command.equals(ACTION_BEST_SERVER)) {
            this.singleFileBox.setSelected(false);
            this.localBox.setSelected(false);
            this.updateSingleFile();
            this.updateOutputFileText();
            this.updateEnabled();
            this.bestForInfoLabel.setText(BEST_FOR_WEB_TEXT);
        } else if (command.equals(ACTION_SINGLE_FILE)) {
            this.updateSingleFile();
            this.updateOutputFileText();
            this.updateEnabled();
        } else if (command.equals(ACTION_OVERLAYS)) {
            this.updateOverlays();
        } else if (command.equals(ACTION_SURFACES)) {
            this.updateSurfaces();
        } else if (command.equals(ACTION_ATLAS)) {
            this.updateAtlas();
        } else {
            this.updateEnabled();
        }
    }

    @Override
    public void overlayAdded(ScreenVolume vol) {
        this.updateOverlays();
    }

    @Override
    public void overlayRemoved(ScreenVolume vol) {
        this.updateOverlays();
    }

    private void create() {
        if (new File(this.webpageText.getText()).exists()) {
            MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this, (Object)"<html>This file already exists and will be overwritten.</html>", "Warning: File Exists", 2, null, 2, (Object[])new String[]{"Continue", "Cancel"}, (Object)"Cancel");
            jopf.show();
            String returnValue = jopf.getReturnOption();
            if (returnValue.equals("Cancel")) {
                return;
            }
        }
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Webpage.this.doCreate();
            }
        });
        workThread.start();
    }

    private JCheckBox makeCheckBox(String name) {
        JCheckBox cb = new JCheckBox(name);
        cb.setFont(cb.getFont().deriveFont(cb.getFont().getSize2D() - 1.0f));
        return cb;
    }

    private void createUI() {
        this.atlasBox = this.makeCheckBox("Include atlas");
        this.atlasBox.setSelected((this.viewer.getToolBox().getCoordinateType() & 8) != 0);
        this.atlasBox.addActionListener(this);
        this.atlasBox.setActionCommand(ACTION_ATLAS);
        this.overlaysBox = this.makeCheckBox("Include overlays");
        this.overlaysBox.setSelected(this.viewer.hasOverlays());
        this.overlaysBox.addActionListener(this);
        this.overlaysBox.setActionCommand(ACTION_OVERLAYS);
        this.surfaceBox = this.makeCheckBox("Include surfaces");
        this.surfaceBox.setSelected(this.viewer.getSurfaceRender() != null);
        this.surfaceBox.addActionListener(this);
        this.surfaceBox.setActionCommand(ACTION_SURFACES);
        this.moreOptionsButton = new JButton("More Options...");
        this.moreOptionsButton.addActionListener(this);
        this.moreOptionsButton.setActionCommand(ACTION_OPTIONS);
        this.moreOptionsButton.setToolTipText("Lots more options...");
        JPanel basicOptionsPanel = new JPanel();
        basicOptionsPanel.setLayout(new BoxLayout(basicOptionsPanel, 0));
        basicOptionsPanel.add(this.atlasBox);
        basicOptionsPanel.add(this.overlaysBox);
        basicOptionsPanel.add(this.surfaceBox);
        basicOptionsPanel.add(Box.createHorizontalGlue());
        basicOptionsPanel.add(this.moreOptionsButton);
        this.singleFileBox = this.makeCheckBox("Single File");
        this.singleFileBox.addActionListener(this);
        this.singleFileBox.setActionCommand(ACTION_SINGLE_FILE);
        this.localBox = this.makeCheckBox("Encode Image Data");
        this.smallImageBox = this.makeCheckBox("Reduce Image Size");
        this.bestForSharingButton = new JRadioButton("Best For Sharing");
        this.bestForSharingButton.addActionListener(this);
        this.bestForSharingButton.setActionCommand(ACTION_BEST_SHARING);
        JRadioButton bestForServerButton = new JRadioButton("Best For Web");
        bestForServerButton.addActionListener(this);
        bestForServerButton.setActionCommand(ACTION_BEST_SERVER);
        ButtonGroup group = new ButtonGroup();
        group.add(bestForServerButton);
        group.add(this.bestForSharingButton);
        this.bestForInfoLabel = new JLabel();
        this.bestForInfoLabel.setForeground(Color.GRAY);
        JPanel bestForInfoPanel = new JPanel();
        bestForInfoPanel.setLayout(new BoxLayout(bestForInfoPanel, 0));
        bestForInfoPanel.add(Box.createHorizontalGlue());
        bestForInfoPanel.add(this.bestForInfoLabel);
        bestForInfoPanel.add(Box.createHorizontalGlue());
        JPanel outputOptionsPanel = new JPanel();
        outputOptionsPanel.setLayout(new BoxLayout(outputOptionsPanel, 0));
        outputOptionsPanel.add(Box.createHorizontalGlue());
        outputOptionsPanel.add(this.singleFileBox);
        outputOptionsPanel.add(Box.createHorizontalGlue());
        outputOptionsPanel.add(this.localBox);
        outputOptionsPanel.add(Box.createHorizontalGlue());
        outputOptionsPanel.add(this.smallImageBox);
        outputOptionsPanel.add(Box.createHorizontalGlue());
        JPanel outputBestPanel = new JPanel();
        outputBestPanel.setLayout(new BoxLayout(outputBestPanel, 0));
        outputBestPanel.add(Box.createHorizontalGlue());
        outputBestPanel.add(this.bestForSharingButton);
        outputBestPanel.add(Box.createHorizontalGlue());
        outputBestPanel.add(bestForServerButton);
        outputBestPanel.add(Box.createHorizontalGlue());
        JPanel outputPanel = new JPanel();
        outputPanel.setLayout(new BoxLayout(outputPanel, 1));
        outputPanel.add(outputOptionsPanel);
        outputPanel.add(outputBestPanel);
        outputPanel.add(Box.createVerticalStrut(8));
        outputPanel.add(bestForInfoPanel);
        outputPanel.add(Box.createVerticalStrut(8));
        outputPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Output Options"));
        this.smoothDisplayBox = this.makeCheckBox("Smooth Display");
        this.smoothDisplayBox.setToolTipText("If selected, linear interpolation is used when displaying images.");
        this.orientationBox = this.makeCheckBox("Show Orientation");
        this.orientationBox.setToolTipText("If selected, automatically turn on orientation markers.");
        this.worldSpaceBox = this.makeCheckBox("World Space");
        this.worldSpaceBox.setToolTipText("If selected, automatically use world space mode.");
        this.coordinateBox = this.makeCheckBox("Load At Current Coordinate");
        this.coordinateBox.setToolTipText("If selected, viewer will load and goto the currently selected coordinate");
        this.singleSliceOnlyBox = this.makeCheckBox("Main View Only");
        this.singleSliceOnlyBox.setToolTipText("If selected, only the main view slice direction will be displayed.");
        this.radiologicalBox = this.makeCheckBox("Radiological Display");
        this.radiologicalBox.setToolTipText("If selected, automatically use radiological display mode.");
        this.showRulerBox = this.makeCheckBox("Show Ruler");
        this.showRulerBox.setToolTipText("If selected, the ruler will automatically be displayed.");
        JPanel displayOptionsPanel1 = new JPanel();
        displayOptionsPanel1.setLayout(new BoxLayout(displayOptionsPanel1, 0));
        displayOptionsPanel1.add(Box.createHorizontalGlue());
        displayOptionsPanel1.add(this.worldSpaceBox);
        displayOptionsPanel1.add(Box.createHorizontalGlue());
        displayOptionsPanel1.add(this.orientationBox);
        displayOptionsPanel1.add(Box.createHorizontalGlue());
        displayOptionsPanel1.add(this.smoothDisplayBox);
        displayOptionsPanel1.add(Box.createHorizontalGlue());
        JPanel displayOptionsPanel2 = new JPanel();
        displayOptionsPanel2.setLayout(new BoxLayout(displayOptionsPanel2, 0));
        displayOptionsPanel2.add(Box.createHorizontalGlue());
        displayOptionsPanel2.add(this.coordinateBox);
        displayOptionsPanel2.add(Box.createHorizontalGlue());
        displayOptionsPanel2.add(this.singleSliceOnlyBox);
        displayOptionsPanel2.add(Box.createHorizontalGlue());
        JPanel displayOptionsPanel3 = new JPanel();
        displayOptionsPanel3.setLayout(new BoxLayout(displayOptionsPanel3, 0));
        displayOptionsPanel3.add(Box.createHorizontalGlue());
        displayOptionsPanel3.add(this.showRulerBox);
        displayOptionsPanel3.add(Box.createHorizontalGlue());
        displayOptionsPanel3.add(this.radiologicalBox);
        displayOptionsPanel3.add(Box.createHorizontalGlue());
        JPanel displayOptionsPanel = new JPanel();
        displayOptionsPanel.setLayout(new BoxLayout(displayOptionsPanel, 1));
        displayOptionsPanel.add(displayOptionsPanel1);
        displayOptionsPanel.add(displayOptionsPanel2);
        displayOptionsPanel.add(displayOptionsPanel3);
        displayOptionsPanel.add(Box.createVerticalStrut(8));
        displayOptionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Display Options"));
        this.kioskBox = this.makeCheckBox("Kiosk Mode");
        this.kioskBox.addActionListener(this);
        this.kioskBox.setToolTipText("If selected, the menu bar will be hidden.");
        this.expandableBox = this.makeCheckBox("Show Expand Button");
        this.expandableBox.setToolTipText("If selected, an expand/collapse button will appear in the menu bar.");
        this.paddingBox = this.makeCheckBox("Show Margins");
        this.paddingBox.setToolTipText("If selected, padding is added to the viewer.");
        this.showControlsBox = this.makeCheckBox("Show Controls");
        this.showControlsBox.addActionListener(this);
        this.showControlsBox.setToolTipText("If selected, increment/decrement and goto buttons will be displayed on the main slice view.");
        this.showControlBarBox = this.makeCheckBox("Show Control Bar");
        this.showControlBarBox.setToolTipText("If selected, control buttons will be displayed as a bar beneath the viewer.");
        this.combineParametricBox = this.makeCheckBox("Combine +/- Overlays");
        this.combineParametricBox.setToolTipText("If selected, parametric overlays will be combined into a single button/menu.");
        JPanel miscOptionsPanel1 = new JPanel();
        miscOptionsPanel1.setLayout(new BoxLayout(miscOptionsPanel1, 0));
        miscOptionsPanel1.add(Box.createHorizontalGlue());
        miscOptionsPanel1.add(this.kioskBox);
        miscOptionsPanel1.add(Box.createHorizontalGlue());
        miscOptionsPanel1.add(this.expandableBox);
        miscOptionsPanel1.add(Box.createHorizontalGlue());
        miscOptionsPanel1.add(this.paddingBox);
        miscOptionsPanel1.add(Box.createHorizontalGlue());
        JPanel miscOptionsPanel2 = new JPanel();
        miscOptionsPanel2.setLayout(new BoxLayout(miscOptionsPanel2, 0));
        miscOptionsPanel2.add(Box.createHorizontalGlue());
        miscOptionsPanel2.add(this.showControlsBox);
        miscOptionsPanel2.add(Box.createHorizontalGlue());
        miscOptionsPanel2.add(this.showControlBarBox);
        miscOptionsPanel2.add(Box.createHorizontalGlue());
        miscOptionsPanel2.add(this.combineParametricBox);
        miscOptionsPanel2.add(Box.createHorizontalGlue());
        JPanel miscOptionsPanel = new JPanel();
        miscOptionsPanel.setLayout(new BoxLayout(miscOptionsPanel, 1));
        miscOptionsPanel.add(miscOptionsPanel1);
        miscOptionsPanel.add(miscOptionsPanel2);
        miscOptionsPanel.add(Box.createVerticalStrut(8));
        miscOptionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Layout Options"));
        this.baseImagePanel = new ImagePanel(this.viewer.getLoadedFile(), this.viewer.getBaseScreenVolume(), Mango.getInstance().getToolBox().getBaseImageIcon());
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new BoxLayout(basePanel, 1));
        basePanel.add(this.baseImagePanel);
        basePanel.add(Box.createVerticalStrut(8));
        basePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Image"));
        this.overlayPanel = new JPanel();
        this.overlayPanel.setLayout(new BoxLayout(this.overlayPanel, 1));
        this.overlayPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Overlays"));
        this.overlayPanel.setVisible(this.overlaysBox.isSelected());
        this.overlayImagePanels = new Vector();
        this.updateOverlayPanel();
        this.surfacePanel = new JPanel();
        this.surfacePanel.setLayout(new BoxLayout(this.surfacePanel, 1));
        this.surfacePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Surfaces"));
        this.surfacePanel.setVisible(this.surfaceBox.isSelected());
        this.surfacePanels = new Vector();
        this.updateSurfacesPanel();
        Atlas[] atlases = this.viewer.getToolBox().getAllAtlases();
        this.atlasSelectBox = new MangoComboBox<Atlas>((T[])atlases);
        this.updateAtlasPanel();
        this.atlasPanel = new JPanel();
        this.atlasPanel.setLayout(new BoxLayout(this.atlasPanel, 0));
        this.atlasPanel.add(Box.createHorizontalStrut(8));
        this.atlasPanel.add(this.atlasSelectBox);
        this.atlasPanel.add(Box.createHorizontalStrut(8));
        this.atlasPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Atlas"));
        this.atlasPanel.setVisible(this.atlasBox.isSelected());
        this.titleText = new MangoPlaceholderTextField("Enter Title Here", 26);
        this.titleText.setMinimumSize(this.titleText.getPreferredSize());
        this.titleText.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.titleText.getPreferredSize().height));
        this.footnoteText = new MangoPlaceholderTextField("Enter Footnote Here", 26);
        this.footnoteText.setMinimumSize(this.footnoteText.getPreferredSize());
        this.footnoteText.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.footnoteText.getPreferredSize().height));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        titlePanel.add(this.titleText);
        JPanel footnotePanel = new JPanel();
        footnotePanel.setLayout(new BoxLayout(footnotePanel, 0));
        footnotePanel.add(this.footnoteText);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        textPanel.add(titlePanel);
        textPanel.add(footnotePanel);
        textPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Title & Footnote"));
        this.optionsPanel = new JPanel();
        this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
        this.optionsPanel.add(basePanel);
        this.optionsPanel.add(Box.createVerticalStrut(8));
        this.optionsPanel.add(this.overlayPanel);
        this.optionsPanel.add(Box.createVerticalStrut(8));
        this.optionsPanel.add(this.surfacePanel);
        this.optionsPanel.add(Box.createVerticalStrut(8));
        this.optionsPanel.add(this.atlasPanel);
        this.optionsPanel.add(Box.createVerticalStrut(8));
        this.optionsPanel.add(displayOptionsPanel);
        this.optionsPanel.add(Box.createVerticalStrut(8));
        this.optionsPanel.add(miscOptionsPanel);
        this.optionsPanel.add(Box.createVerticalStrut(8));
        this.optionsPanel.add(outputPanel);
        this.optionsPanel.add(Box.createVerticalStrut(8));
        this.optionsPanel.add(textPanel);
        this.optionsPanel.setVisible(false);
        this.outputFileLabel = new JLabel("File: ");
        KeyAdapter kl = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                Webpage.this.updateEnabled();
            }
        };
        this.webpageText = new MangoTextField("", 26, kl, false, true);
        this.webpageText.setMinimumSize(this.webpageText.getPreferredSize());
        this.webpageText.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.webpageText.getPreferredSize().height));
        JButton webpageTextSelectButton = new JButton("Select...");
        webpageTextSelectButton.setActionCommand(ACTION_SELECT_FILE);
        webpageTextSelectButton.addActionListener(this);
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BoxLayout(filePanel, 0));
        filePanel.add(this.outputFileLabel);
        filePanel.add(this.webpageText);
        filePanel.add(Box.createHorizontalStrut(8));
        filePanel.add(webpageTextSelectButton);
        this.openButton = new JButton("Open Webpage");
        this.openButton.setActionCommand(ACTION_PLAY);
        this.openButton.addActionListener(this);
        this.showFileButton = new JButton("Show File");
        this.showFileButton.setActionCommand(ACTION_SHOW);
        this.showFileButton.addActionListener(this);
        this.createButton = new JButton("Create");
        this.createButton.addActionListener(this);
        this.createButton.setActionCommand(ACTION_CREATE);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(this.openButton);
        buttonPanel.add(this.showFileButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.createButton);
        JLabel infoLabel = new JLabel("<html><center>Creates a dynamic webpage with an interactive viewer<br>using Papaya. <a href=\"#\">Learn more about Papaya</a>.</center></html>", 0);
        infoLabel.setForeground(Color.GRAY);
        infoLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                DesktopUtilities.openURL((String)"http://rii-mango.github.io/Papaya/");
            }
        });
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 0));
        infoPanel.add(infoLabel);
        this.viewer.getOverlayManager().addListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent we) {
                if (!Webpage.this.viewer.isClosing()) {
                    Webpage.this.viewer.getOverlayManager().removeListener(Webpage.this);
                }
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        mainPanel.add(basicOptionsPanel);
        mainPanel.add(Box.createVerticalStrut(8));
        mainPanel.add(this.optionsPanel);
        mainPanel.add(Box.createVerticalStrut(8));
        mainPanel.add(filePanel);
        mainPanel.add(Box.createVerticalStrut(8));
        mainPanel.add(buttonPanel);
        mainPanel.add(Box.createVerticalStrut(8));
        mainPanel.add(infoPanel);
        mainPanel.add(Box.createVerticalStrut(8));
        this.getContentPane().add((Component)mainPanel, "Center");
        this.setTitle("Create Webpage: " + this.viewer.getImageTitle());
        this.viewer.associatePluginWindow(NAME, this);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocation(this.viewer.findGoodPluginWindowLocation(this.getSize()));
        this.setResizable(false);
        this.setVisible(true);
        this.createButton.requestFocusInWindow();
        this.makeDefaultOptions();
        this.updateOutputFileText();
        this.updateEnabled();
    }

    private void createWebpage() {
        Webpage.doCreateWebpage(this.viewer, this.webpageText.getText(), this.baseImagePanel, this.overlayImagePanels, this.surfacePanels, this.localBox.isSelected(), this.overlaysBox.isSelected(), this.surfaceBox.isSelected(), this.worldSpaceBox.isSelected(), this.orientationBox.isSelected(), this.smoothDisplayBox.isSelected(), this.coordinateBox.isSelected(), this.singleSliceOnlyBox.isSelected(), this.kioskBox.isSelected(), this.expandableBox.isSelected(), this.paddingBox.isSelected(), this.singleFileBox.isSelected(), this.titleText.getText(), this.footnoteText.getText(), this.atlasBox.isSelected(), (Atlas)this.atlasSelectBox.getSelectedItem(), this.smallImageBox.isSelected(), this.showRulerBox.isSelected(), this.radiologicalBox.isSelected(), this.showControlsBox.isSelected(), this.showControlBarBox.isSelected(), this.combineParametricBox.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doCreateWebpage(VolumeManager viewer, String saveLocation, WebpageImage baseImagePanel, Vector<? extends WebpageImage> overlayImagePanels, Vector<? extends WebpageSurface> surfacePanels, boolean local, boolean useOverlays, boolean useSurfaces, boolean worldSpace, boolean orientation, boolean smoothDisplay, boolean coordinate, boolean singleSlice, boolean kiosk, boolean expandable, boolean padding, boolean singleFile, String title, String footnote, boolean useAtlas, Atlas atlas, boolean smallImage, boolean showRuler, boolean radiological, boolean showControls, boolean showControlBar, boolean combineParametric) {
        FileUtilities.mkdirs((File)Platform.getTempDir());
        Webpage.unpackPapaya();
        File paramsFile = Webpage.writeParametersFile(viewer, baseImagePanel, overlayImagePanels, surfacePanels, local, useOverlays, useSurfaces, worldSpace, orientation, smoothDisplay, coordinate, singleSlice, kiosk, expandable, padding, showRuler, radiological, showControls, showControlBar, combineParametric);
        Object[] command = Webpage.makeCommands(paramsFile, viewer, title, footnote, local, singleFile, useAtlas, atlas, overlayImagePanels, surfacePanels, smallImage);
        try {
            AppLogger.info((String)("Papaya Builder Command: " + Arrays.toString(command)));
            AppLogger.info((String)("Papaya Builder Parameters: " + FileUtils.readFileToString((File)paramsFile)));
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        BufferedReader brOut = null;
        BufferedReader brErr = null;
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder((String[])command);
            processBuilder.directory(new File(Platform.getTempDir() + "/papaya"));
            Process process = processBuilder.start();
            int returnVal = process.waitFor();
            if (returnVal != 0) {
                AppLogger.warn((String)("Papaya returned a non-zero value: " + returnVal));
            }
            brErr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = brErr.readLine()) != null) {
                AppLogger.error((String)line);
            }
            brOut = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = brOut.readLine()) != null) {
                AppLogger.info((String)line);
            }
            File outputFile = null;
            if (singleFile) {
                outputFile = new File(Platform.getTempDir() + "/papaya/build/index.html");
                File webpageFile = new File(saveLocation);
                FileUtils.copyFile((File)outputFile, (File)webpageFile);
                if (viewer instanceof SliceViewer) {
                    ((SliceViewer)viewer).recordAction("createWebpage", new String[]{viewer.getScriptObjectName() + ".makeFilename(\".html\")", ScriptUtils.convertString(title), ScriptUtils.convertBoolean(useOverlays), ScriptUtils.convertBoolean(useAtlas), ScriptUtils.convertBoolean(useSurfaces), ScriptUtils.convertBoolean(kiosk), ScriptUtils.convertBoolean(singleFile)}, true);
                }
            } else {
                outputFile = new File(Platform.getTempDir() + "/papaya/build");
                File webpageFile = new File(saveLocation);
                FileUtils.copyDirectory((File)outputFile, (File)webpageFile);
                if (viewer instanceof SliceViewer) {
                    ((SliceViewer)viewer).recordAction("createWebpage", new String[]{viewer.getScriptObjectName() + ".makeFilename(\"\")", ScriptUtils.convertString(title), ScriptUtils.convertBoolean(useOverlays), ScriptUtils.convertBoolean(useAtlas), ScriptUtils.convertBoolean(useSurfaces), ScriptUtils.convertBoolean(kiosk), ScriptUtils.convertBoolean(singleFile)}, true);
                }
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (InterruptedException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            if (brOut != null) {
                try {
                    brOut.close();
                }
                catch (IOException ex) {
                    AppLogger.error((Throwable)ex);
                }
            }
            if (brErr != null) {
                try {
                    brErr.close();
                }
                catch (IOException ex) {
                    AppLogger.error((Throwable)ex);
                }
            }
        }
    }

    private void doCreate() {
        this.viewer.startIndeterminateProgressBar();
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                Webpage.this.createButton.setText("Creating...");
                Webpage.this.createButton.setEnabled(false);
            }
        });
        Webpage.unpackPapaya();
        this.createWebpage();
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                Webpage.this.updateEnabled();
                Webpage.this.createButton.setText("Create");
                Webpage.this.createButton.setEnabled(true);
                Webpage.this.viewer.endIndeterminateProgressBar();
            }
        });
    }

    private void editSaveFile() {
        File snapshotFile = new File(this.webpageText.getText());
        File saveFile = null;
        saveFile = this.singleFileBox.isSelected() ? SaveFileDialog.showSaveFileChooser(this, snapshotFile.getParent(), snapshotFile.getName()) : SaveFileDialog.showSaveFolderChooser(this, snapshotFile.getParent());
        if (saveFile != null) {
            this.webpageText.setText(saveFile.toString());
        }
        this.updateEnabled();
    }

    public static ScreenVolume findParametricPartner(ScreenVolume[] overlays, ScreenVolume screenVol) {
        for (ScreenVolume overlay : overlays) {
            if (overlay == null || overlay == screenVol || overlay.getVolume() != screenVol.getVolume()) continue;
            return overlay;
        }
        return null;
    }

    private static String[] makeCommands(File paramsFile, VolumeManager viewer, String title, String footnote, boolean local, boolean singleFile, boolean useAtlas, Atlas atlas, Vector<? extends WebpageImage> overlayImagePanels, Vector<? extends WebpageSurface> surfacePanels, boolean smallImage) {
        Vector<String> command = new Vector<String>();
        if (Platform.WINDOWS) {
            command.add(System.getProperty("java.home") + "/bin/java.exe");
        } else {
            command.add(System.getProperty("java.home") + "/bin/java");
        }
        if (Platform.JAVA64BIT_DETECTED) {
            command.add("-Xmx2000M");
        } else {
            command.add("-Xmx512M");
        }
        command.add("-jar");
        command.add(Platform.getTempDir() + "/papaya/lib/papaya-builder.jar");
        if (StringUtils.isNotBlank((CharSequence)title)) {
            command.add("-title");
            command.add("\"" + title + "\"");
        }
        if (StringUtils.isNotBlank((CharSequence)footnote)) {
            command.add("-footnote");
            command.add("\"" + footnote + "\"");
        }
        command.add("-parameterfile");
        command.add("\"" + paramsFile.getAbsolutePath() + "\"");
        if (local) {
            command.add("-local");
        }
        if (singleFile) {
            command.add("-singlefile");
        }
        if (useAtlas) {
            command.add("-atlas");
            if (atlas != null && atlas instanceof AtlasFSL) {
                command.add("\"" + new File(((AtlasFSL)atlas).getXmlPath()).getAbsolutePath() + "\"");
            }
        }
        command.add("-images");
        if (local) {
            command.add(Webpage.makeImageFile(viewer.getLoadedURI(viewer.getBaseVolume()), (Volume)viewer.getBaseVolume(), Webpage.replaceNonAlphanumericCharacters(Webpage.removeNiftiExtensions(FileUtilities.getName((URI)viewer.getLoadedURI()))), smallImage).getAbsolutePath());
        } else {
            command.add("\"" + Webpage.makeImageFile(viewer.getLoadedURI(viewer.getBaseVolume()), (Volume)viewer.getBaseVolume(), Webpage.makeNiftiFilename(FileUtilities.getName((URI)viewer.getLoadedURI())), smallImage).getAbsolutePath() + "\"");
        }
        for (WebpageImage webpageImage : overlayImagePanels) {
            if (local) {
                command.add(Webpage.makeImageFile(webpageImage.getScreenVol().getURI(), webpageImage.getScreenVol().getVolume(), Webpage.replaceNonAlphanumericCharacters(Webpage.removeNiftiExtensions(webpageImage.getFile().getName())), smallImage).getAbsolutePath());
                continue;
            }
            command.add("\"" + Webpage.makeImageFile(webpageImage.getScreenVol().getURI(), webpageImage.getScreenVol().getVolume(), Webpage.makeNiftiFilename(webpageImage.getFile().getName()), smallImage).getAbsolutePath() + "\"");
        }
        if (surfacePanels != null && surfacePanels.size() > 0) {
            command.add("-surfaces");
            for (WebpageSurface webpageSurface : surfacePanels) {
                if (local) {
                    File file = Webpage.makeSurfaceFile((CompositeSurface)webpageSurface.getSurface(), viewer, Webpage.replaceNonAlphanumericCharacters(Webpage.removeGiftiExtensions(webpageSurface.getSurfaceName())), webpageSurface.isUsingColors());
                    command.add(file.getAbsolutePath());
                    continue;
                }
                String surfaceName = Webpage.replaceNonAlphanumericCharacters(Webpage.removeGiftiExtensions(webpageSurface.getSurfaceName())) + ".surf.gii";
                File file = Webpage.makeSurfaceFile((CompositeSurface)webpageSurface.getSurface(), viewer, surfaceName, webpageSurface.isUsingColors());
                command.add("\"" + file.getAbsolutePath() + "\"");
            }
        }
        return command.toArray(new String[command.size()]);
    }

    private void makeDefaultOptions() {
        this.worldSpaceBox.setSelected(this.viewer.getToolBox().isWorldMode());
        this.orientationBox.setSelected(this.viewer.isShowingOrientation());
        this.smoothDisplayBox.setSelected(!Mango.isVoxelDisplay());
        this.coordinateBox.setSelected(true);
        this.singleSliceOnlyBox.setSelected(this.viewer.isSingleSliceMode());
        this.showRulerBox.setSelected(this.viewer.isShowingRuler());
        this.radiologicalBox.setSelected(this.viewer.isRadiologicalMode());
        this.kioskBox.setSelected(true);
        this.expandableBox.setSelected(false);
        this.paddingBox.setSelected(true);
        this.showControlsBox.setSelected(true);
        this.showControlBarBox.setSelected(true);
        this.combineParametricBox.setSelected(false);
        this.singleFileBox.setSelected(true);
        this.localBox.setSelected(true);
        this.bestForSharingButton.setSelected(true);
        this.smallImageBox.setSelected(true);
        this.bestForInfoLabel.setText(BEST_FOR_SHARING_TEXT);
    }

    private static File makeImageFile(URI uri, Volume volume, String name, boolean smallImage) {
        File file = null;
        boolean isFile = FileUtilities.uriIsFile((URI)uri);
        boolean isNIFTI = volume.isNIFTI();
        boolean isDirty = volume.isDirty();
        boolean is8Bit = volume.getImageType().getNumBytesPerVoxel() == 1;
        boolean isSmallImage = smallImage;
        if (!isFile || isDirty || !isNIFTI || isSmallImage && !is8Bit) {
            file = new File(Platform.getTempDir(), name);
            Webpage.writeTempFile(volume, file, isSmallImage);
        } else {
            file = new File(uri);
        }
        return file;
    }

    private static File makeSurfaceFile(CompositeSurface surface, VolumeManager viewer, String name, boolean includeColors) {
        File file = new File(Platform.getTempDir(), name);
        Webpage.writeTempSurfaceFile(surface, viewer, file, includeColors);
        return file;
    }

    private static String makeNiftiFilename(String baseNameVal) {
        String baseName = baseNameVal;
        if (baseName.endsWith(".nii.gz") || baseName.endsWith(".nii")) {
            return baseName;
        }
        baseName = FileUtilities.removeExtension((String)baseName);
        return baseName + ".nii.gz";
    }

    private File makeOutputFile() {
        if (this.singleFileBox.isSelected()) {
            String filename = Webpage.replaceNonAlphanumericCharacters(this.viewer.getImageTitle()) + EXTENSION;
            File imageDir = this.viewer.getLoadedFile().getParentFile();
            File file = new File(this.viewer.getMango().getCapturableLocation(imageDir), filename);
            return FileUtilities.findUniqueFilename((File)file);
        }
        return new File(this.viewer.getMango().getCapturableLocation(this.viewer.getLoadedFile().getParentFile()) + "/" + Webpage.replaceNonAlphanumericCharacters(this.viewer.getImageTitle()));
    }

    private void play() {
        if (this.singleFileBox.isSelected()) {
            DesktopUtilities.openFile((File)new File(this.webpageText.getText()));
        } else {
            DesktopUtilities.openFile((File)new File(this.webpageText.getText(), "index.html"));
        }
    }

    private void showFile() {
        DesktopUtilities.revealAndSelect((File)new File(this.webpageText.getText()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean unpackPapaya() {
        boolean success = false;
        if (unpackedFiles) {
            success = true;
        } else {
            BufferedInputStream fileRead = null;
            FilterOutputStream fileWrite = null;
            File papayaZipFile = new File(Platform.getTempDir(), "papaya.zip");
            try {
                if (papayaZipFile.exists()) {
                    FileUtilities.delete((File)papayaZipFile);
                }
                fileRead = new BufferedInputStream(Mango.class.getResourceAsStream("lib/papaya.zip"));
                fileWrite = new BufferedOutputStream(new FileOutputStream(papayaZipFile));
                byte[] buffer = new byte[4096];
                int bytesRead = fileRead.read(buffer);
                while (bytesRead != -1) {
                    ((BufferedOutputStream)fileWrite).write(buffer, 0, bytesRead);
                    bytesRead = fileRead.read(buffer);
                }
                unpackedFiles = true;
                success = true;
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
            finally {
                try {
                    if (fileRead != null) {
                        fileRead.close();
                    }
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
                try {
                    if (fileWrite != null) {
                        fileWrite.close();
                    }
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
            FileUtilities.unzipFileToFolder((File)papayaZipFile, (File)Platform.getTempDir());
        }
        return success;
    }

    private void updateAtlas() {
        this.updateAtlasPanel();
        this.atlasPanel.setVisible(this.atlasBox.isSelected());
        this.validate();
        this.pack();
    }

    private void updateAtlasPanel() {
        Atlas[] atlases = this.viewer.getToolBox().getAllAtlases();
        Atlas currentAtlas = this.viewer.getToolBox().getCurrentAtlas();
        if (currentAtlas != null) {
            this.atlasSelectBox.setSelectedItem(currentAtlas);
        } else {
            for (Atlas atlas : atlases) {
                if (!atlas.getPluginName().equals(DEFAULT_ATLAS_NAME)) continue;
                this.atlasSelectBox.setSelectedItem(atlas);
                break;
            }
        }
    }

    private void updateEnabled() {
        File snapshotFile = new File(this.webpageText.getText());
        this.openButton.setEnabled(snapshotFile.exists());
        this.showFileButton.setEnabled(snapshotFile.exists());
        if (this.kioskBox.isSelected()) {
            this.expandableBox.setSelected(false);
        }
        this.expandableBox.setEnabled(!this.kioskBox.isSelected());
        if (this.singleFileBox.isSelected()) {
            this.localBox.setSelected(true);
        }
        this.showControlBarBox.setEnabled(this.showControlsBox.isSelected());
        if (!this.showControlsBox.isSelected()) {
            this.showControlBarBox.setSelected(false);
        }
        this.localBox.setEnabled(!this.singleFileBox.isSelected());
    }

    private void updateOptions() {
        this.optionsPanel.setVisible(!this.optionsPanel.isVisible());
        this.moreOptionsButton.setText(this.optionsPanel.isVisible() ? "Hide Options" : "More Options...");
        this.validate();
        this.pack();
    }

    private void updateOutputFileText() {
        this.webpageText.setText(this.makeOutputFile().toString());
    }

    private void updateOverlayPanel() {
        this.overlayImagePanels.clear();
        this.overlayPanel.removeAll();
        OverlayManager overlayManager = this.viewer.getOverlayManager();
        int numOverlays = overlayManager.getNumInStack();
        if (numOverlays > 0) {
            ScreenVolume[] overlays = overlayManager.getAllOverlays();
            for (int ctr = 0; ctr < overlays.length; ++ctr) {
                if (overlays[ctr] == null) continue;
                boolean parametric = overlays[ctr].isParametric();
                boolean negative = overlays[ctr].isNegative();
                if (parametric && negative) continue;
                ScreenVolume parametricPartner = Webpage.findParametricPartner(overlays, overlays[ctr]);
                ImagePanel ip = new ImagePanel(new File(overlays[ctr].getURI()), overlays[ctr], Mango.getInstance().getToolBox().getOverlayImageIcons()[ctr], parametricPartner, Mango.getInstance().getToolBox().getOverlayImageIcons()[overlayManager.getIndex(parametricPartner)]);
                this.overlayImagePanels.add(ip);
            }
            for (ImagePanel imagePanel : this.overlayImagePanels) {
                this.overlayPanel.add(imagePanel);
            }
        } else {
            JPanel dummyPanel = new JPanel();
            dummyPanel.setLayout(new BoxLayout(dummyPanel, 0));
            dummyPanel.add(Box.createHorizontalGlue());
            dummyPanel.add(new JLabel("No overlays added."));
            dummyPanel.add(Box.createHorizontalGlue());
            this.overlayPanel.add(dummyPanel);
        }
        this.overlayPanel.add(Box.createVerticalStrut(8));
        this.overlayPanel.revalidate();
    }

    private void updateSurfacesPanel() {
        this.surfacePanels.clear();
        this.surfacePanel.removeAll();
        SurfaceViewer renderer = this.viewer.getSurfaceRenderer();
        if (renderer != null && renderer.getSurfaces().length > 0) {
            Surface[] surfaces;
            for (Surface surface : surfaces = renderer.getSurfaces()) {
                SurfacePanel surfacePanel = new SurfacePanel((CompositeSurface)surface);
                this.surfacePanels.add(surfacePanel);
            }
            for (SurfacePanel imagePanel : this.surfacePanels) {
                this.surfacePanel.add(imagePanel);
            }
        } else {
            JPanel dummyPanel = new JPanel();
            dummyPanel.setLayout(new BoxLayout(dummyPanel, 0));
            dummyPanel.add(Box.createHorizontalGlue());
            dummyPanel.add(new JLabel("No surfaces added."));
            dummyPanel.add(Box.createHorizontalGlue());
            this.surfacePanel.add(dummyPanel);
        }
        this.surfacePanel.add(Box.createVerticalStrut(8));
        this.surfacePanel.revalidate();
    }

    private void updateOverlays() {
        this.updateOverlayPanel();
        this.overlayPanel.setVisible(this.overlaysBox.isSelected());
        this.validate();
        this.pack();
    }

    private void updateSurfaces() {
        this.updateSurfacesPanel();
        this.surfacePanel.setVisible(this.surfaceBox.isSelected());
        this.validate();
        this.pack();
    }

    private void updateSingleFile() {
        if (this.singleFileBox.isSelected()) {
            this.outputFileLabel.setText("File:");
        } else {
            this.outputFileLabel.setText("Dir:");
        }
    }

    private static File writeParametersFile(VolumeManager viewer, WebpageImage baseImagePanel, Vector<? extends WebpageImage> overlayImagePanels, Vector<? extends WebpageSurface> surfacePanels, boolean local, boolean useOverlays, boolean useSurfaces, boolean worldSpace, boolean orientation, boolean smoothDisplay, boolean coordinate, boolean singleSlice, boolean kiosk, boolean expandable, boolean padding, boolean showRuler, boolean radiological, boolean showControls, boolean showControlBar, boolean combineParametric) {
        String overlayName;
        StringBuilder sb = new StringBuilder(256);
        sb.append('{');
        String baseImageName = null;
        if (local) {
            baseImageName = Webpage.replaceNonAlphanumericCharacters(Webpage.removeNiftiExtensions(FileUtilities.getName((URI)viewer.getLoadedURI())));
            sb.append("encodedImages:[\"" + baseImageName + "\"");
            if (useOverlays) {
                for (WebpageImage webpageImage : overlayImagePanels) {
                    File file = webpageImage.getFile();
                    overlayName = Webpage.replaceNonAlphanumericCharacters(Webpage.removeNiftiExtensions(file.getName()));
                    sb.append(",\"" + overlayName + "\"");
                }
            }
            sb.append(']');
        } else {
            baseImageName = Webpage.makeNiftiFilename(FileUtilities.getName((URI)viewer.getLoadedURI()));
            sb.append("images:[\"data/" + baseImageName + "\"");
            if (useOverlays) {
                for (WebpageImage webpageImage : overlayImagePanels) {
                    File file = webpageImage.getFile();
                    overlayName = file.getName();
                    sb.append(",\"data/" + Webpage.makeNiftiFilename(overlayName) + "\"");
                }
            }
            sb.append(']');
        }
        sb.append(",\"" + baseImageName + "\":{min:" + baseImagePanel.getMin() + ",max:" + baseImagePanel.getMax() + ",lut:\"" + baseImagePanel.getColorTable() + "\"}");
        Vector<String> customLUTs = new Vector<String>();
        if (!LookupTableManager.NAMES_PAPAYA_COMPATIBLE.contains(baseImagePanel.getColorTableName())) {
            customLUTs.add(baseImagePanel.getColorTable().makePapayaLUT());
        }
        if (useOverlays) {
            for (WebpageImage webpageImage : overlayImagePanels) {
                ScreenVolume parametricPartner;
                File file2 = webpageImage.getFile();
                String overlayFilename = file2.getName();
                String overlayName2 = null;
                overlayName2 = local ? "\"" + Webpage.replaceNonAlphanumericCharacters(Webpage.removeNiftiExtensions(overlayFilename)) + "\"" : "\"" + Webpage.makeNiftiFilename(file2.getName()) + "\"";
                sb.append(',');
                sb.append(overlayName2 + ":{min:" + webpageImage.getMin() + ",max:" + webpageImage.getMax() + ",lut:\"" + webpageImage.getColorTableName() + "\",alpha:" + webpageImage.getAlpha());
                if (!LookupTableManager.NAMES_PAPAYA_COMPATIBLE.contains(webpageImage.getColorTableName())) {
                    customLUTs.add(webpageImage.getColorTable().makePapayaLUT());
                }
                if ((parametricPartner = webpageImage.getParametricPartner()) != null) {
                    sb.append(",parametric:true,symmetric:true,negative_lut:\"" + webpageImage.getColorTableNameParametric() + "\"");
                    if (!LookupTableManager.NAMES_PAPAYA_COMPATIBLE.contains(webpageImage.getColorTableNameParametric())) {
                        customLUTs.add(webpageImage.getColorTableParametric().makePapayaLUT());
                    }
                }
                sb.append('}');
            }
        }
        if (useSurfaces) {
            float[] components;
            Color color;
            String surfaceName;
            if (local) {
                sb.append(",encodedSurfaces:[");
                for (WebpageSurface webpageSurface : surfacePanels) {
                    surfaceName = Webpage.replaceNonAlphanumericCharacters(Webpage.removeGiftiExtensions(webpageSurface.getSurfaceName()));
                    sb.append("\"" + surfaceName + "\",");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append(']');
                for (WebpageSurface webpageSurface : surfacePanels) {
                    if (!webpageSurface.isUsingColors() || !CollectionUtilities.isEmpty((Object)webpageSurface.getSurface().getOverlays())) continue;
                    surfaceName = "\"" + Webpage.replaceNonAlphanumericCharacters(Webpage.removeGiftiExtensions(webpageSurface.getSurfaceName())) + "\"";
                    color = ((CompositeSurface)webpageSurface.getSurface()).getMaterial().getColor();
                    components = color.getColorComponents(null);
                    sb.append(',' + surfaceName + ":{color:[" + components[0] + "," + components[1] + "," + components[2] + "]}");
                }
            } else {
                sb.append(",surfaces:[");
                for (WebpageSurface webpageSurface : surfacePanels) {
                    surfaceName = Webpage.replaceNonAlphanumericCharacters(Webpage.removeGiftiExtensions(webpageSurface.getSurfaceName())) + ".surf.gii";
                    sb.append("\"data/" + surfaceName + "\",");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append(']');
                for (WebpageSurface webpageSurface : surfacePanels) {
                    if (!webpageSurface.isUsingColors() || !CollectionUtilities.isEmpty((Object)webpageSurface.getSurface().getOverlays())) continue;
                    surfaceName = "\"" + Webpage.replaceNonAlphanumericCharacters(Webpage.removeGiftiExtensions(webpageSurface.getSurfaceName())) + ".surf.gii\"";
                    color = ((CompositeSurface)webpageSurface.getSurface()).getMaterial().getColor();
                    components = color.getColorComponents(null);
                    sb.append(',' + surfaceName + ":{color:[" + components[0] + "," + components[1] + "," + components[2] + "]}");
                }
            }
            sb.append(",surfaceLink:true");
        }
        if (customLUTs.size() > 0) {
            sb.append(",luts:[");
            for (String string : customLUTs) {
                if (customLUTs.indexOf(string) > 0) {
                    sb.append(',');
                }
                sb.append(string);
            }
            sb.append(']');
        }
        sb.append(",worldSpace:" + (worldSpace ? TEXT_TRUE : TEXT_FALSE));
        sb.append(",showOrientation:" + (orientation ? TEXT_TRUE : TEXT_FALSE));
        sb.append(",showRuler:" + (showRuler ? TEXT_TRUE : TEXT_FALSE));
        sb.append(",radiological:" + (radiological ? TEXT_TRUE : TEXT_FALSE));
        sb.append(",smoothDisplay:" + (smoothDisplay ? TEXT_TRUE : TEXT_FALSE));
        sb.append(",showControls:" + (showControls ? TEXT_TRUE : TEXT_FALSE));
        sb.append(",showControlBar:" + (showControlBar ? TEXT_TRUE : TEXT_FALSE));
        sb.append(",combineParametric:" + (combineParametric ? TEXT_TRUE : TEXT_FALSE));
        if (coordinate) {
            sb.append(',');
            if (worldSpace) {
                Coordinate coordinate2 = viewer.getCurrentWorldPosition();
                sb.append("coordinate:[" + coordinate2.xDbl + "," + coordinate2.yDbl + "," + coordinate2.zDbl + "]");
            } else {
                Coordinate coordinate3 = viewer.getCurrentPosition();
                sb.append("coordinate:[" + coordinate3.xInt + "," + coordinate3.yInt + "," + coordinate3.zInt + "]");
            }
        }
        if (singleSlice) {
            sb.append(",orthogonal:false,");
            int n = viewer.getSliceDirection();
            if (n == 0) {
                sb.append("mainView:\"axial\"");
            } else if (n == 1) {
                sb.append("mainView:\"coronal\"");
            } else if (n == 2) {
                sb.append("mainView:\"sagittal\"");
            }
        } else {
            sb.append(",orthogonalDynamic:true");
        }
        sb.append(",kioskMode:" + (kiosk ? TEXT_TRUE : TEXT_FALSE));
        sb.append(",expandable:" + (expandable ? TEXT_TRUE : TEXT_FALSE));
        sb.append(",fullScreenPadding:" + (padding ? TEXT_TRUE : TEXT_FALSE));
        sb.append('}');
        File paramsFile = new File(Platform.getTempDir(), "params");
        if (paramsFile.exists()) {
            FileUtilities.delete((File)paramsFile);
        }
        try {
            FileUtils.writeStringToFile((File)paramsFile, (String)sb.toString());
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        return paramsFile;
    }

    private static void writeTempFile(Volume volume, File file, boolean smallImage) {
        try {
            volume.updateMaxMin(null, volume.findRangeSeries());
            volume.writeAsNiftiFast(file, smallImage);
            AppLogger.info((String)("Wrote temp file to " + file.toString()));
        }
        catch (VolumeIOException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (CloneNotSupportedException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    private static void writeTempSurfaceFile(CompositeSurface surface, VolumeManager viewer, File file, boolean includeColors) {
        try {
            String options = "";
            GiftiFormat surfaceWriter = new GiftiFormat();
            Surface[] surfaces = new Surface[]{surface};
            surfaceWriter.getOptionsPanel(surfaces, null, viewer);
            if (includeColors && CollectionUtilities.isNotEmpty((Object)surface.getOverlays())) {
                options = options + "Include RGB data=true,";
            }
            options = options + "Include normals=true";
            surfaceWriter.setOptions(options);
            surfaceWriter.writeSurfaceFile(file, surfaces, null, viewer);
            AppLogger.info((String)("Wrote temp file to " + file.toString()));
        }
        catch (SurfaceFormatException ex) {
            AppLogger.error((Throwable)ex);
        }
    }
}

