/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.webpage;

import edu.uthscsa.ric.mango.viewerslice.dialogs.webpage.WebpageSurface;
import edu.uthscsa.ric.mango.viewersurface.core.CompositeSurface;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.visualization.surface.primitives.Surface;
import java.awt.Color;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SurfacePanel
extends JPanel
implements WebpageSurface {
    private JCheckBox surfaceColors;
    private final CompositeSurface surface;
    private static final long serialVersionUID = 1L;

    public SurfacePanel(CompositeSurface surface) {
        this.surface = surface;
        this.createUI();
    }

    @Override
    public Surface getSurface() {
        return this.surface;
    }

    @Override
    public String getSurfaceName() {
        return this.surface.getName() + "_surf.surf.gii";
    }

    @Override
    public boolean isUsingColors() {
        return this.surfaceColors.isSelected();
    }

    private void createUI() {
        JLabel nameLabel = new JLabel(this.surface.getName());
        this.surfaceColors = new JCheckBox("Include Colors");
        this.surfaceColors.setSelected(CollectionUtilities.isNotEmpty((Object)this.surface.getOverlays()) || !this.surface.getMaterial().getColor().equals(Color.WHITE));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalStrut(4));
        panel.add(nameLabel);
        panel.add(Box.createHorizontalStrut(4));
        panel.add(this.surfaceColors);
        panel.add(Box.createHorizontalStrut(4));
        panel.add(Box.createHorizontalGlue());
        this.setLayout(new BoxLayout(this, 1));
        this.add(panel);
    }
}

