/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.webpage;

import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.components.transparencyslider.MangoTransparencySlider;
import edu.uthscsa.ric.mango.components.transparencyslider.MangoTransparencySliderUser;
import edu.uthscsa.ric.mango.viewerslice.dialogs.webpage.WebpageImage;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LUT;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LookupTableManager;
import edu.uthscsa.ric.utilities.AppLogger;
import java.awt.Dimension;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ImagePanel
extends JPanel
implements MangoTransparencySliderUser,
WebpageImage {
    private static final long serialVersionUID = 1L;
    private final File file;
    private final ScreenVolume screenVol;
    private JTextField minText;
    private JTextField maxText;
    private JComboBox<String> lutBox;
    private JComboBox<String> lutParametricBox;
    private MangoTransparencySlider slider;
    private final ImageIcon icon;
    private ImageIcon iconPartner;
    private ScreenVolume parametricPartner;
    public static final MangoNumberFormatter FORMATTER_NUMBER = new MangoNumberFormatter();

    public ImagePanel(File file, ScreenVolume screenVol, ImageIcon icon) {
        this.file = file;
        this.screenVol = screenVol;
        this.icon = icon;
        this.createUI();
    }

    public ImagePanel(File file, ScreenVolume screenVol, ImageIcon icon, ScreenVolume parametricPartner, ImageIcon iconPartner) {
        this.file = file;
        this.screenVol = screenVol;
        this.icon = icon;
        this.parametricPartner = parametricPartner;
        this.iconPartner = iconPartner;
        this.createUI();
    }

    private void createUI() {
        boolean isBaseImage = this.screenVol.isBaseImage();
        JLabel imageIconLabel = new JLabel(this.icon);
        this.minText = new MangoTextField(FORMATTER_NUMBER.format(this.screenVol.getScreenMin()), 4);
        this.maxText = new MangoTextField(FORMATTER_NUMBER.format(this.screenVol.getScreenMax()), 4);
        this.lutBox = new MangoComboBox<String>((T[])LookupTableManager.getAllLUTNames());
        this.lutBox.setSelectedItem(this.screenVol.getLookupTableManager().getName());
        this.lutBox.setMinimumSize(this.lutBox.getPreferredSize());
        this.lutBox.setMaximumSize(this.lutBox.getPreferredSize());
        if (!isBaseImage) {
            this.slider = new MangoTransparencySlider(0, 0, 255, 255 - this.screenVol.getAlphaInteger(), this, false);
            this.slider.setPreferredSize(new Dimension(80, 30));
            this.slider.setMaximumSize(new Dimension(80, 30));
            this.slider.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalGlue());
        panel.add(Box.createHorizontalStrut(4));
        panel.add(imageIconLabel);
        panel.add(Box.createHorizontalStrut(4));
        panel.add(Box.createHorizontalGlue());
        panel.add(Box.createHorizontalStrut(4));
        panel.add(new JLabel("Min: "));
        panel.add(this.minText);
        panel.add(Box.createHorizontalStrut(4));
        panel.add(Box.createHorizontalGlue());
        panel.add(Box.createHorizontalStrut(4));
        panel.add(new JLabel("Max: "));
        panel.add(this.maxText);
        panel.add(Box.createHorizontalStrut(4));
        if (this.slider != null) {
            panel.add(Box.createHorizontalGlue());
            panel.add(Box.createHorizontalStrut(4));
            panel.add(this.slider);
            panel.add(Box.createHorizontalStrut(4));
        }
        panel.add(Box.createHorizontalGlue());
        panel.add(Box.createHorizontalStrut(4));
        panel.add(this.lutBox);
        panel.add(Box.createHorizontalStrut(4));
        panel.add(Box.createHorizontalGlue());
        JPanel parametricPanel = null;
        if (this.parametricPartner != null) {
            JLabel imageIconLabelPartner = new JLabel(this.iconPartner);
            this.lutParametricBox = new MangoComboBox<String>((T[])LookupTableManager.getAllLUTNames());
            this.lutParametricBox.setSelectedItem(this.parametricPartner.getLookupTableManager().getName());
            this.lutParametricBox.setMinimumSize(this.lutParametricBox.getPreferredSize());
            this.lutParametricBox.setMaximumSize(this.lutParametricBox.getPreferredSize());
            parametricPanel = new JPanel();
            parametricPanel.setLayout(new BoxLayout(parametricPanel, 0));
            parametricPanel.add(Box.createHorizontalStrut(4));
            parametricPanel.add(imageIconLabelPartner);
            parametricPanel.add(Box.createHorizontalGlue());
            parametricPanel.add(new JLabel("(Parametric)"));
            parametricPanel.add(Box.createHorizontalGlue());
            parametricPanel.add(this.lutParametricBox);
            parametricPanel.add(Box.createHorizontalStrut(4));
        }
        this.setLayout(new BoxLayout(this, 1));
        this.add(panel);
        if (parametricPanel != null) {
            this.add(parametricPanel);
        }
    }

    @Override
    public boolean canEnable(MangoTransparencySlider slider) {
        return true;
    }

    @Override
    public void sliderChanged(MangoTransparencySlider slider) {
    }

    @Override
    public void sliderControlReleased(MangoTransparencySlider slider) {
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public double getMin() {
        double min = this.parametricPartner != null ? this.parametricPartner.getScreenMin() : this.screenVol.getScreenMin();
        try {
            min = Double.parseDouble(this.minText.getText());
        }
        catch (NumberFormatException ex) {
            AppLogger.warn((Throwable)ex);
        }
        return min;
    }

    @Override
    public double getMax() {
        double max = this.parametricPartner != null ? this.parametricPartner.getScreenMax() : this.screenVol.getScreenMax();
        try {
            max = Double.parseDouble(this.maxText.getText());
        }
        catch (NumberFormatException ex) {
            AppLogger.warn((Throwable)ex);
        }
        return max;
    }

    @Override
    public String getColorTableName() {
        return this.lutBox.getSelectedItem().toString();
    }

    @Override
    public LookupTableManager getColorTable() {
        LUT[] luts;
        for (LUT lut : luts = LookupTableManager.getAllLUTs()) {
            if (!lut.getName().equals(this.lutBox.getSelectedItem().toString())) continue;
            LookupTableManager ltm = new LookupTableManager(lut.getName(), this.screenVol.isBaseImage(), lut.getKnots());
            ltm.setExpression(lut.getExpression());
            return ltm;
        }
        return null;
    }

    @Override
    public String getColorTableNameParametric() {
        return this.lutParametricBox.getSelectedItem().toString();
    }

    @Override
    public LookupTableManager getColorTableParametric() {
        LUT[] luts;
        for (LUT lut : luts = LookupTableManager.getAllLUTs()) {
            if (!lut.getName().equals(this.lutParametricBox.getSelectedItem().toString())) continue;
            LookupTableManager ltm = new LookupTableManager(lut.getName(), this.parametricPartner.isBaseImage(), lut.getKnots());
            ltm.setExpression(lut.getExpression());
            return ltm;
        }
        return null;
    }

    @Override
    public double getAlpha() {
        return (double)(255 - this.slider.getValue()) / 255.0;
    }

    @Override
    public ScreenVolume getParametricPartner() {
        return this.parametricPartner;
    }

    @Override
    public ScreenVolume getScreenVol() {
        return this.screenVol;
    }
}

