/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.transform;

import Jama.Matrix;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPane;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.TransformOptionsDialog;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Transform;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;

public class EditTransformTool
extends JFrame
implements ActionListener,
ChangeListener,
ViewerAssociated,
PopupMenuListener {
    private JButton optionsButton;
    private JLabel xLabel;
    private JLabel yLabel;
    private JLabel zLabel;
    private JLabel[][] parameterLabels;
    private JLabel[][] transformLabels;
    private JPanel infoPanel;
    private JPopupMenu popup;
    private JRadioButton imageRadioButton;
    private JRadioButton worldRadioButton;
    private JSlider sliderX;
    private JSlider sliderY;
    private JSlider sliderZ;
    private JTextField textFieldX;
    private JTextField textFieldY;
    private JTextField textFieldZ;
    private JToggleButton inverseButton;
    private JToggleButton rotButton;
    private JToggleButton scaleButton;
    private JToggleButton skewButton;
    private JToggleButton transButton;
    private Transform currentTransform;
    private boolean frozenState;
    private boolean isImageTransformType;
    private boolean isInverse;
    private boolean isRot;
    private boolean isScale;
    private boolean isSkew;
    private boolean isTrans;
    private double xRot;
    private double xScale;
    private double xSkew;
    private double xSliderRotValue;
    private double xSliderScaleValue;
    private double xSliderTransValue;
    private double xTrans;
    private double xySliderSkewValue;
    private double xzSliderSkewValue;
    private double yRot;
    private double yScale;
    private double ySkew;
    private double ySliderRotValue;
    private double ySliderScaleValue;
    private double ySliderTransValue;
    private double yTrans;
    private double yzSliderSkewValue;
    private double zRot;
    private double zScale;
    private double zSkew;
    private double zSliderRotValue;
    private double zSliderScaleValue;
    private double zSliderTransValue;
    private double zTrans;
    private double[][] transform;
    private long popupTimeCanceled;
    private final Mango mango;
    private final SliceViewer viewer;
    private final Matrix sizeThis;
    private final Vector<Matrix> steps = new Vector();
    private final double spatialUnitMultiplier;
    private final double xSize;
    private final double ySize;
    private final double zSize;
    private final double[][] center;
    private final double[][] centerInverse;
    private final double[][] lastStep;
    private final double[][] rotationX;
    private final double[][] rotationY;
    private final double[][] rotationZ;
    private final double[][] scale;
    private final double[][] size;
    private final double[][] sizeInverse;
    private final double[][] skew;
    private final double[][] sliderTransform;
    private final double[][] transformTemp2;
    private final double[][] transformTemp;
    private final double[][] translation;
    private final double[][] worldTypeTransform;
    private final int xImageDim;
    private final int yImageDim;
    private final int zImageDim;
    private static final Font FONT = MangoStyle.FONT_REGULAR;
    private static final Font FONT_SMALL = MangoStyle.FONT_SMALL;
    private static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(3, false);
    private static final String[] OPTIONS = new String[]{"Transform MNI to Talairach", "Transform Talairach to MNI", "Change Center of Rotation"};
    private static final double EPSILON = 1.0E-5;
    private static final double[][] IDENTITY = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
    private static final long serialVersionUID = 1L;
    public static final Dimension START_SIZE = new Dimension(800, 140);
    public static final String TITLE = "Transform";
    public static final double SCALE_MAX = 10000.0;
    public static final double SCALE_MIN = 1.0E-6;
    public static final int ROTATE_MAX = 180;

    public EditTransformTool(Mango mango, SliceViewer viewer) {
        this.mango = mango;
        this.viewer = viewer;
        this.isImageTransformType = true;
        this.xSize = viewer.getVolume().getXSize();
        this.ySize = viewer.getVolume().getYSize();
        this.zSize = viewer.getVolume().getZSize();
        this.xImageDim = viewer.getVolume().getXDim();
        this.yImageDim = viewer.getVolume().getYDim();
        this.zImageDim = viewer.getVolume().getZDim();
        this.spatialUnitMultiplier = viewer.getVolume().getVoxelDimensions().getSpatialUnitMultiplier();
        double[][] sizeThisArray = new double[4][4];
        sizeThisArray[0][0] = 1.0 / this.xSize;
        sizeThisArray[1][1] = 1.0 / this.ySize;
        sizeThisArray[2][2] = 1.0 / this.zSize;
        sizeThisArray[3][3] = 1.0;
        this.sizeThis = new Matrix(sizeThisArray);
        this.rotationX = new double[4][4];
        this.rotationY = new double[4][4];
        this.rotationZ = new double[4][4];
        this.transformTemp = new double[4][4];
        this.transformTemp2 = new double[4][4];
        this.translation = new double[4][4];
        this.scale = new double[4][4];
        this.skew = new double[4][4];
        this.center = new double[4][4];
        this.centerInverse = new double[4][4];
        this.sliderTransform = new double[4][4];
        this.worldTypeTransform = new double[4][4];
        this.size = new double[4][4];
        this.sizeInverse = new double[4][4];
        this.isInverse = true;
        this.updateCenterTransforms();
        this.makeSizeTransform();
        this.lastStep = new double[4][4];
        this.resetSliderValues();
        this.createUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String action = ae.getActionCommand();
        if (action.equals("translate")) {
            if (this.isTrans) {
                this.zSliderTransValue = 0.0;
                this.ySliderTransValue = 0.0;
                this.xSliderTransValue = 0.0;
                for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
                    for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                        this.transform[ctrOut][ctrIn] = this.lastStep[ctrOut][ctrIn];
                    }
                }
                this.updateCenterTransforms();
                this.updateTransformFromSliders();
                this.updateTransform();
                this.updateViewer(false);
            } else {
                this.isTrans = true;
                this.isSkew = false;
                this.isScale = false;
                this.isRot = false;
            }
            this.updateToggleButton();
            this.resetTextfieldX();
            this.resetTextfieldY();
            this.resetTextfieldZ();
            this.updateTranslateSlider();
            this.updateSkewLabelButtons();
        } else if (action.equals("rotate")) {
            if (this.isRot) {
                this.zSliderRotValue = 0.0;
                this.ySliderRotValue = 0.0;
                this.xSliderRotValue = 0.0;
                for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
                    for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                        this.transform[ctrOut][ctrIn] = this.lastStep[ctrOut][ctrIn];
                    }
                }
                this.updateCenterTransforms();
                this.updateTransformFromSliders();
                this.updateTransform();
                this.updateViewer(false);
            } else {
                this.isRot = true;
                this.isSkew = false;
                this.isScale = false;
                this.isTrans = false;
            }
            this.updateToggleButton();
            this.resetTextfieldX();
            this.resetTextfieldY();
            this.resetTextfieldZ();
            this.updateRotateSlider();
            this.updateSkewLabelButtons();
        } else if (action.equals("scale")) {
            if (this.isScale) {
                this.zSliderScaleValue = 1.0;
                this.ySliderScaleValue = 1.0;
                this.xSliderScaleValue = 1.0;
                this.updateCenterTransforms();
                this.updateTransformFromSliders();
                this.updateTransform();
                this.updateViewer(false);
            } else {
                this.isScale = true;
                this.isSkew = false;
                this.isRot = false;
                this.isTrans = false;
            }
            this.updateToggleButton();
            this.resetTextfieldX();
            this.resetTextfieldY();
            this.resetTextfieldZ();
            this.updateScaleSlider();
            this.updateSkewLabelButtons();
        } else if (action.equals("skew")) {
            if (this.isSkew) {
                this.xzSliderSkewValue = 0.0;
                this.yzSliderSkewValue = 0.0;
                this.xySliderSkewValue = 0.0;
                for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
                    for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                        this.transform[ctrOut][ctrIn] = this.lastStep[ctrOut][ctrIn];
                    }
                }
                this.updateCenterTransforms();
                this.updateTransformFromSliders();
                this.updateTransform();
                this.updateViewer(false);
            } else {
                this.isSkew = true;
                this.isTrans = false;
                this.isScale = false;
                this.isRot = false;
            }
            this.updateToggleButton();
            this.resetTextfieldX();
            this.resetTextfieldY();
            this.resetTextfieldZ();
            this.updateSkewSlider();
            this.updateSkewLabelButtons();
        } else if (action.equals("Show Parameters")) {
            this.showParametersPanel();
        } else if (action.equals("Show Matrix")) {
            this.showMatrixPanel();
        } else if (action.equals("save")) {
            this.saveStep();
        } else if (action.equals("textFieldX")) {
            double tempValue = 0.0;
            try {
                tempValue = Double.parseDouble(this.textFieldX.getText());
            }
            catch (NumberFormatException ex) {
                AppLogger.info((Throwable)ex);
                this.resetTextfieldX();
                return;
            }
            if (this.isTrans) {
                this.xSliderTransValue = tempValue;
            } else if (this.isRot) {
                if (tempValue < -180.0) {
                    tempValue = -180.0;
                } else if (tempValue > 180.0) {
                    tempValue = 180.0;
                }
                this.xSliderRotValue = tempValue;
            } else if (this.isScale) {
                if (tempValue < 1.0E-6) {
                    tempValue = 1.0E-6;
                } else if (tempValue > 10000.0) {
                    tempValue = 10000.0;
                }
                this.xSliderScaleValue = tempValue;
            } else if (this.isSkew) {
                this.yzSliderSkewValue = tempValue;
            }
            this.resetTextfieldX();
            this.updateSliderFromTextBox();
            this.updateTransformFromSliders();
            this.updateTransform();
            this.updateViewer(false);
        } else if (action.equals("textFieldY")) {
            double tempValue = 0.0;
            try {
                tempValue = Double.parseDouble(this.textFieldY.getText());
            }
            catch (NumberFormatException ex) {
                AppLogger.info((Throwable)ex);
                this.resetTextfieldY();
                return;
            }
            if (this.isTrans) {
                this.ySliderTransValue = tempValue;
            } else if (this.isRot) {
                if (tempValue < -180.0) {
                    tempValue = -180.0;
                } else if (tempValue > 180.0) {
                    tempValue = 180.0;
                }
                this.ySliderRotValue = tempValue;
            } else if (this.isScale) {
                if (tempValue < 1.0E-6) {
                    tempValue = 1.0E-6;
                } else if (tempValue > 10000.0) {
                    tempValue = 10000.0;
                }
                this.ySliderScaleValue = tempValue;
            } else if (this.isSkew) {
                this.xzSliderSkewValue = tempValue;
            }
            this.resetTextfieldY();
            this.updateSliderFromTextBox();
            this.updateTransformFromSliders();
            this.updateTransform();
            this.updateViewer(false);
        } else if (action.equals("textFieldZ")) {
            double tempValue = 0.0;
            try {
                tempValue = Double.parseDouble(this.textFieldZ.getText());
            }
            catch (NumberFormatException ex) {
                AppLogger.info((Throwable)ex);
                this.resetTextfieldZ();
                return;
            }
            if (this.isTrans) {
                this.zSliderTransValue = tempValue;
            } else if (this.isRot) {
                if (tempValue < -180.0) {
                    tempValue = -180.0;
                } else if (tempValue > 180.0) {
                    tempValue = 180.0;
                }
                this.zSliderRotValue = tempValue;
            } else if (this.isScale) {
                if (tempValue < 1.0E-6) {
                    tempValue = 1.0E-6;
                } else if (tempValue > 10000.0) {
                    tempValue = 10000.0;
                }
                this.zSliderScaleValue = tempValue;
            } else if (this.isSkew) {
                this.xySliderSkewValue = tempValue;
            }
            this.resetTextfieldZ();
            this.updateSliderFromTextBox();
            this.updateTransformFromSliders();
            this.updateTransform();
            this.updateViewer(false);
        } else if (action.startsWith("reset")) {
            this.undoStep();
        } else if (action.equals("Image Space")) {
            this.toggleTransformType();
        } else if (action.equals("World Space")) {
            this.toggleTransformType();
        } else if (action.equals("invert")) {
            this.updateInverse();
        } else if (action.equals("Load...")) {
            this.doLoad();
        } else if (action.equals("Save...")) {
            this.doSave();
        } else if (action.equals("show options")) {
            long timeSinceCancel = new Date().getTime() - this.popupTimeCanceled;
            if (timeSinceCancel > 250L) {
                this.popup.show(this.optionsButton, 2, 25);
            }
        } else if (action.equals(OPTIONS[0])) {
            this.doChangeMNIToTalairach();
            this.saveStep();
        } else if (action.equals(OPTIONS[1])) {
            this.doChangeTalairachToMNI();
            this.saveStep();
        } else if (action.equals(OPTIONS[2])) {
            this.doChangeCenterOfRotation();
        }
        this.viewer.updateSurfaceTextures(true);
        this.viewer.updateSurface();
    }

    @Override
    public String getDescription() {
        return TITLE;
    }

    @Override
    public SliceViewer getViewer() {
        return this.viewer;
    }

    @Override
    public JFrame getWindow() {
        return this;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent pme) {
        if (pme.getSource() == this.popup) {
            this.popupTimeCanceled = new Date().getTime();
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
    }

    public final void reconcileWithViewerTransformState() {
        this.currentTransform = this.viewer.getCurrentTransform();
        if (this.currentTransform != null) {
            double[][] mat = this.sizeThis.inverse().times(new Matrix(this.currentTransform.getMatrixCopy())).times(this.sizeThis).getArrayCopy();
            this.clearTransforms();
            this.resetSliderValues();
            this.resetTextfieldX();
            this.resetTextfieldY();
            this.resetTextfieldZ();
            this.updateTranslateSlider();
            this.updateRotateSlider();
            this.updateScaleSlider();
            this.updateSkewSlider();
            this.updateLastStep();
            for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.transform[ctrOut][ctrIn] = mat[ctrOut][ctrIn];
                }
            }
            this.updateCenterTransforms();
            this.updateTransform();
        }
    }

    public void resetSliderTextFields() {
        if (this.isTrans || this.isRot || this.isSkew) {
            this.textFieldX.setText("0");
            this.textFieldY.setText("0");
            this.textFieldZ.setText("0");
        } else if (this.isScale) {
            this.textFieldX.setText("1");
            this.textFieldY.setText("1");
            this.textFieldZ.setText("1");
        }
        this.requestFocus();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.frozenState) {
            return;
        }
        JSlider source = (JSlider)e.getSource();
        if (this.isTrans) {
            if (source == this.sliderX) {
                this.textFieldX.setText(String.valueOf(this.sliderX.getValue()));
            } else if (source == this.sliderY) {
                this.textFieldY.setText(String.valueOf(this.sliderY.getValue()));
            } else if (source == this.sliderZ) {
                this.textFieldZ.setText(String.valueOf(this.sliderZ.getValue()));
            }
            if (source == this.sliderX) {
                this.xSliderTransValue = this.sliderX.getValue();
            } else if (source == this.sliderY) {
                this.ySliderTransValue = this.sliderY.getValue();
            } else if (source == this.sliderZ) {
                this.zSliderTransValue = this.sliderZ.getValue();
            }
        } else if (this.isRot) {
            if (source == this.sliderX) {
                this.textFieldX.setText(String.valueOf(this.sliderX.getValue()));
            } else if (source == this.sliderY) {
                this.textFieldY.setText(String.valueOf(this.sliderY.getValue()));
            } else if (source == this.sliderZ) {
                this.textFieldZ.setText(String.valueOf(this.sliderZ.getValue()));
            }
            if (source == this.sliderX) {
                this.xSliderRotValue = this.sliderX.getValue();
            } else if (source == this.sliderY) {
                this.ySliderRotValue = this.sliderY.getValue();
            } else if (source == this.sliderZ) {
                this.zSliderRotValue = this.sliderZ.getValue();
            }
        } else if (this.isScale) {
            if (source == this.sliderX) {
                this.xSliderScaleValue = (double)(100 + this.sliderX.getValue()) / 100.0;
            } else if (source == this.sliderY) {
                this.ySliderScaleValue = (double)(100 + this.sliderY.getValue()) / 100.0;
            } else if (source == this.sliderZ) {
                this.zSliderScaleValue = (double)(100 + this.sliderZ.getValue()) / 100.0;
            }
            if (source == this.sliderX) {
                this.textFieldX.setText(String.valueOf(this.xSliderScaleValue));
            } else if (source == this.sliderY) {
                this.textFieldY.setText(String.valueOf(this.ySliderScaleValue));
            } else if (source == this.sliderZ) {
                this.textFieldZ.setText(String.valueOf(this.zSliderScaleValue));
            }
        } else if (this.isSkew) {
            if (source == this.sliderX) {
                this.yzSliderSkewValue = (double)this.sliderX.getValue() / 100.0;
            } else if (source == this.sliderY) {
                this.xzSliderSkewValue = (double)this.sliderY.getValue() / 100.0;
            } else if (source == this.sliderZ) {
                this.xySliderSkewValue = (double)this.sliderZ.getValue() / 100.0;
            }
            if (source == this.sliderX) {
                this.textFieldX.setText(String.valueOf(this.yzSliderSkewValue));
            } else if (source == this.sliderY) {
                this.textFieldY.setText(String.valueOf(this.xzSliderSkewValue));
            } else if (source == this.sliderZ) {
                this.textFieldZ.setText(String.valueOf(this.xySliderSkewValue));
            }
        }
        this.updateTransformFromSliders();
        this.updateTransform();
        this.updateViewer(true);
    }

    public void updateViewer(boolean forceNN) {
        double[][] aTransform = null;
        aTransform = this.isInverse ? this.transform : new Matrix(this.transform).inverse().getArray();
        this.viewer.forceImageUpdate();
        if (this.currentTransform != null) {
            if (!forceNN) {
                this.recordTransform();
            }
            this.currentTransform.setTemporaryDisableNotify(true);
            double[][] mat = this.sizeThis.times(new Matrix(aTransform)).times(this.sizeThis.inverse()).getArrayCopy();
            this.currentTransform.updateTransform(mat);
            this.currentTransform.setTemporaryDisableNotify(false);
        }
    }

    private void addStep(Matrix tempMat) {
        this.steps.add(tempMat);
    }

    private void clearTransforms() {
        for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                if (ctrOut == ctrIn) {
                    this.skew[ctrOut][ctrIn] = 1.0;
                    this.rotationZ[ctrOut][ctrIn] = 1.0;
                    this.rotationY[ctrOut][ctrIn] = 1.0;
                    this.rotationX[ctrOut][ctrIn] = 1.0;
                    this.scale[ctrOut][ctrIn] = 1.0;
                    this.translation[ctrOut][ctrIn] = 1.0;
                    this.worldTypeTransform[ctrOut][ctrIn] = 1.0;
                    continue;
                }
                this.skew[ctrOut][ctrIn] = 0.0;
                this.rotationZ[ctrOut][ctrIn] = 0.0;
                this.rotationY[ctrOut][ctrIn] = 0.0;
                this.rotationX[ctrOut][ctrIn] = 0.0;
                this.scale[ctrOut][ctrIn] = 0.0;
                this.translation[ctrOut][ctrIn] = 0.0;
                this.worldTypeTransform[ctrOut][ctrIn] = 0.0;
            }
        }
    }

    private void createUI() {
        JButton loadTransformButton = new JButton("Load...");
        loadTransformButton.addActionListener(this);
        loadTransformButton.setEnabled(!this.mango.isApplet());
        JButton saveTransformButton = new JButton("Save...");
        saveTransformButton.addActionListener(this);
        saveTransformButton.setEnabled(!this.mango.isApplet());
        this.optionsButton = new JButton("Options...");
        this.optionsButton.setActionCommand("show options");
        this.optionsButton.addActionListener(this);
        this.makePopupMenu();
        JPanel leftFirstRowPanel = new JPanel();
        leftFirstRowPanel.setLayout(new BoxLayout(leftFirstRowPanel, 0));
        leftFirstRowPanel.add(Box.createHorizontalGlue());
        leftFirstRowPanel.add(loadTransformButton);
        leftFirstRowPanel.add(Box.createHorizontalGlue());
        leftFirstRowPanel.add(saveTransformButton);
        leftFirstRowPanel.add(Box.createHorizontalGlue());
        leftFirstRowPanel.add(this.optionsButton);
        leftFirstRowPanel.add(Box.createHorizontalGlue());
        JButton concatButton = new JButton("Concatenate");
        concatButton.setActionCommand("save");
        concatButton.addActionListener(this);
        concatButton.setFont(FONT_SMALL);
        JButton undoButton = new JButton("Undo");
        undoButton.setActionCommand("reset");
        undoButton.addActionListener(this);
        undoButton.setFont(FONT_SMALL);
        this.inverseButton = new JToggleButton("Forward");
        this.inverseButton.setActionCommand("invert");
        this.inverseButton.addActionListener(this);
        this.inverseButton.setFont(FONT_SMALL);
        JPanel leftSecondRowPanel = new JPanel();
        leftSecondRowPanel.setLayout(new BoxLayout(leftSecondRowPanel, 0));
        leftSecondRowPanel.add(Box.createHorizontalGlue());
        leftSecondRowPanel.add(this.inverseButton);
        leftSecondRowPanel.add(Box.createHorizontalGlue());
        leftSecondRowPanel.add(concatButton);
        leftSecondRowPanel.add(Box.createHorizontalGlue());
        leftSecondRowPanel.add(undoButton);
        leftSecondRowPanel.add(Box.createHorizontalGlue());
        JRadioButton paramsRadioButton = new JRadioButton("Show Parameters");
        paramsRadioButton.setFont(FONT);
        paramsRadioButton.addActionListener(this);
        JRadioButton xformRadioButton = new JRadioButton("Show Matrix");
        xformRadioButton.setFont(FONT);
        xformRadioButton.addActionListener(this);
        ButtonGroup bg = new ButtonGroup();
        bg.add(paramsRadioButton);
        bg.add(xformRadioButton);
        xformRadioButton.setSelected(true);
        JPanel leftThirdRowPanel = new JPanel();
        leftThirdRowPanel.setLayout(new BoxLayout(leftThirdRowPanel, 0));
        leftThirdRowPanel.add(Box.createHorizontalGlue());
        leftThirdRowPanel.add(xformRadioButton);
        leftThirdRowPanel.add(Box.createHorizontalGlue());
        leftThirdRowPanel.add(paramsRadioButton);
        leftThirdRowPanel.add(Box.createHorizontalGlue());
        this.imageRadioButton = new JRadioButton("Image Space");
        this.imageRadioButton.setFont(FONT);
        this.imageRadioButton.addActionListener(this);
        this.worldRadioButton = new JRadioButton("World Space");
        this.worldRadioButton.setFont(FONT);
        this.worldRadioButton.addActionListener(this);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.imageRadioButton);
        bg2.add(this.worldRadioButton);
        this.imageRadioButton.setSelected(true);
        JPanel leftFourthRowPanel = new JPanel();
        leftFourthRowPanel.setLayout(new BoxLayout(leftFourthRowPanel, 0));
        leftFourthRowPanel.add(Box.createHorizontalGlue());
        leftFourthRowPanel.add(this.imageRadioButton);
        leftFourthRowPanel.add(Box.createHorizontalGlue());
        leftFourthRowPanel.add(this.worldRadioButton);
        leftFourthRowPanel.add(Box.createHorizontalGlue());
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        leftPanel.add(Box.createVerticalGlue());
        leftPanel.add(leftFirstRowPanel);
        leftPanel.add(Box.createVerticalGlue());
        leftPanel.add(leftSecondRowPanel);
        leftPanel.add(Box.createVerticalGlue());
        leftPanel.add(Box.createVerticalGlue());
        leftPanel.add(leftThirdRowPanel);
        leftPanel.add(leftFourthRowPanel);
        leftPanel.add(Box.createVerticalGlue());
        leftPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JLabel prototypeLabel = new JLabel("-0.0000E0");
        Dimension prototypeSize = prototypeLabel.getPreferredSize();
        this.infoPanel = new JPanel();
        this.infoPanel.setLayout(new CardLayout());
        JPanel parametersPanel = new JPanel();
        GridLayout parametersPanelLayout = new GridLayout(4, 4);
        parametersPanel.setLayout(parametersPanelLayout);
        parametersPanelLayout.setHgap(8);
        parametersPanelLayout.setVgap(8);
        this.parameterLabels = new JLabel[4][4];
        for (int ctrOut = 3; ctrOut >= 0; --ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.parameterLabels[ctrOut][ctrIn] = new JLabel();
                this.parameterLabels[ctrOut][ctrIn].setPreferredSize(prototypeSize);
                this.parameterLabels[ctrOut][ctrIn].setMinimumSize(prototypeSize);
                this.parameterLabels[ctrOut][ctrIn].setMaximumSize(prototypeSize);
                parametersPanel.add(this.parameterLabels[ctrOut][ctrIn], ctrOut, ctrIn);
            }
        }
        JPanel transformPanel = new JPanel();
        GridLayout transformPanelLayout = new GridLayout(4, 4);
        transformPanel.setLayout(transformPanelLayout);
        transformPanelLayout.setHgap(8);
        transformPanelLayout.setVgap(8);
        this.transform = new double[4][4];
        this.transformLabels = new JLabel[4][4];
        for (int ctrOut = 3; ctrOut >= 0; --ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.transformLabels[ctrOut][ctrIn] = new JLabel();
                this.transformLabels[ctrOut][ctrIn].setPreferredSize(prototypeSize);
                this.transformLabels[ctrOut][ctrIn].setMinimumSize(prototypeSize);
                this.transformLabels[ctrOut][ctrIn].setMaximumSize(prototypeSize);
                transformPanel.add(this.transformLabels[ctrOut][ctrIn], ctrOut, ctrIn);
            }
        }
        this.updateTransform(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        this.updateParameters(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0);
        this.infoPanel.add((Component)transformPanel, "transformPanel");
        this.infoPanel.add((Component)parametersPanel, "parametersPanel");
        JPanel middlePanel = new JPanel();
        middlePanel.setLayout(new BoxLayout(middlePanel, 0));
        middlePanel.add(Box.createHorizontalGlue());
        middlePanel.add(this.infoPanel);
        middlePanel.add(Box.createHorizontalGlue());
        middlePanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 0));
        this.transButton = new JToggleButton("Translate");
        this.transButton.setFocusable(false);
        this.transButton.setActionCommand("translate");
        this.transButton.addActionListener(this);
        this.transButton.setFont(FONT_SMALL);
        this.transButton.setBackground(Color.WHITE);
        this.transButton.setPreferredSize(new Dimension(65, 25));
        this.transButton.setMaximumSize(this.transButton.getPreferredSize());
        this.transButton.setMinimumSize(this.transButton.getPreferredSize());
        this.rotButton = new JToggleButton("Rotate");
        this.rotButton.setFocusable(false);
        this.rotButton.setActionCommand("rotate");
        this.rotButton.addActionListener(this);
        this.rotButton.setFont(FONT_SMALL);
        this.rotButton.setBackground(Color.WHITE);
        this.rotButton.setPreferredSize(new Dimension(65, 25));
        this.rotButton.setMaximumSize(this.transButton.getPreferredSize());
        this.rotButton.setMinimumSize(this.transButton.getPreferredSize());
        this.scaleButton = new JToggleButton("Scale");
        this.scaleButton.setFocusable(false);
        this.scaleButton.setActionCommand("scale");
        this.scaleButton.addActionListener(this);
        this.scaleButton.setFont(FONT_SMALL);
        this.scaleButton.setBackground(Color.WHITE);
        this.scaleButton.setPreferredSize(new Dimension(65, 25));
        this.scaleButton.setMaximumSize(this.transButton.getPreferredSize());
        this.scaleButton.setMinimumSize(this.transButton.getPreferredSize());
        this.skewButton = new JToggleButton("Skew");
        this.skewButton.setFocusable(false);
        this.skewButton.setActionCommand("skew");
        this.skewButton.addActionListener(this);
        this.skewButton.setFont(FONT_SMALL);
        this.skewButton.setBackground(Color.WHITE);
        this.skewButton.setPreferredSize(new Dimension(65, 25));
        this.skewButton.setMaximumSize(this.transButton.getPreferredSize());
        this.skewButton.setMinimumSize(this.transButton.getPreferredSize());
        ButtonGroup group = new ButtonGroup();
        group.add(this.transButton);
        group.add(this.rotButton);
        group.add(this.scaleButton);
        group.add(this.skewButton);
        this.transButton.setSelected(true);
        this.isTrans = true;
        JPanel rightButtonPanel = new JPanel();
        rightButtonPanel.setLayout(new BoxLayout(rightButtonPanel, 0));
        rightButtonPanel.add(this.transButton);
        rightButtonPanel.add(this.rotButton);
        rightButtonPanel.add(this.scaleButton);
        rightButtonPanel.add(this.skewButton);
        this.xLabel = new JLabel("X");
        this.xLabel.setFont(FONT);
        this.xLabel.setPreferredSize(new Dimension(20, 25));
        this.xLabel.setMaximumSize(this.xLabel.getPreferredSize());
        this.xLabel.setMinimumSize(this.xLabel.getPreferredSize());
        this.sliderX = new JSlider(0, -50, 50, 0);
        this.sliderX.setFocusable(false);
        this.sliderX.setPreferredSize(new Dimension(150, 35));
        this.sliderX.setPaintTicks(true);
        this.sliderX.setMajorTickSpacing(10);
        this.sliderX.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (Mango.isVoxelDisplay()) {
                    EditTransformTool.this.currentTransform.setTemporaryForceNearestNeighbor(true);
                }
                EditTransformTool.this.updateCenterTransforms(me.isShiftDown());
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (Mango.isVoxelDisplay()) {
                    EditTransformTool.this.currentTransform.setTemporaryForceNearestNeighbor(false);
                }
                EditTransformTool.this.updateViewer(false);
                double[][] aTransform = null;
                aTransform = EditTransformTool.this.isInverse ? EditTransformTool.this.transform : new Matrix(EditTransformTool.this.transform).inverse().getArray();
                double[][] mat = EditTransformTool.this.sizeThis.times(new Matrix(aTransform)).times(EditTransformTool.this.sizeThis.inverse()).getArrayCopy();
                EditTransformTool.this.viewer.recordAction("transform", new String[]{EditTransformTool.this.viewer.getScriptObjectName() + ".baseVolume", String.valueOf(mat[0][0]), String.valueOf(mat[0][1]), String.valueOf(mat[0][2]), String.valueOf(mat[0][3]), String.valueOf(mat[1][0]), String.valueOf(mat[1][1]), String.valueOf(mat[1][2]), String.valueOf(mat[1][3]), String.valueOf(mat[2][0]), String.valueOf(mat[2][1]), String.valueOf(mat[2][2]), String.valueOf(mat[2][3]), String.valueOf(mat[3][0]), String.valueOf(mat[3][1]), String.valueOf(mat[3][2]), String.valueOf(mat[3][3])});
                EditTransformTool.this.viewer.updateSurface();
            }
        });
        this.sliderX.addChangeListener(this);
        this.textFieldX = new MangoTextField("0", 3);
        this.textFieldX.setActionCommand("textFieldX");
        this.textFieldX.addActionListener(this);
        this.textFieldX.setFont(FONT_SMALL);
        this.textFieldX.setMaximumSize(this.textFieldX.getPreferredSize());
        this.textFieldX.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
            }

            @Override
            public void focusLost(FocusEvent fe) {
                EditTransformTool.this.resetTextfieldX();
            }
        });
        JPanel xPanel = new JPanel();
        xPanel.setLayout(new BoxLayout(xPanel, 0));
        xPanel.add(this.xLabel);
        xPanel.add(this.sliderX);
        xPanel.add(this.textFieldX);
        xPanel.add(Box.createHorizontalStrut(4));
        this.yLabel = new JLabel("Y");
        this.yLabel.setFont(FONT);
        this.yLabel.setPreferredSize(new Dimension(20, 25));
        this.yLabel.setMaximumSize(this.yLabel.getPreferredSize());
        this.yLabel.setMinimumSize(this.yLabel.getPreferredSize());
        this.sliderY = new JSlider(0, -50, 50, 0);
        this.sliderY.setFocusable(false);
        this.sliderY.setPreferredSize(new Dimension(150, 35));
        this.sliderY.setPaintTicks(true);
        this.sliderY.setMajorTickSpacing(10);
        this.sliderY.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (Mango.isVoxelDisplay()) {
                    EditTransformTool.this.currentTransform.setTemporaryForceNearestNeighbor(true);
                }
                EditTransformTool.this.updateCenterTransforms(me.isShiftDown());
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (Mango.isVoxelDisplay()) {
                    EditTransformTool.this.currentTransform.setTemporaryForceNearestNeighbor(false);
                }
                EditTransformTool.this.updateViewer(false);
                EditTransformTool.this.viewer.updateSurface();
            }
        });
        this.sliderY.addChangeListener(this);
        this.textFieldY = new MangoTextField("0", 3);
        this.textFieldY.setActionCommand("textFieldY");
        this.textFieldY.addActionListener(this);
        this.textFieldY.setFont(FONT_SMALL);
        this.textFieldY.setMaximumSize(this.textFieldY.getPreferredSize());
        this.textFieldY.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
            }

            @Override
            public void focusLost(FocusEvent fe) {
                EditTransformTool.this.resetTextfieldY();
            }
        });
        JPanel yPanel = new JPanel();
        yPanel.setLayout(new BoxLayout(yPanel, 0));
        yPanel.add(this.yLabel);
        yPanel.add(this.sliderY);
        yPanel.add(this.textFieldY);
        yPanel.add(Box.createHorizontalStrut(4));
        this.zLabel = new JLabel("Z");
        this.zLabel.setFont(FONT);
        this.zLabel.setPreferredSize(new Dimension(20, 25));
        this.zLabel.setMaximumSize(this.zLabel.getPreferredSize());
        this.zLabel.setMinimumSize(this.zLabel.getPreferredSize());
        this.sliderZ = new JSlider(0, -50, 50, 0);
        this.sliderZ.setFocusable(false);
        this.sliderZ.setPreferredSize(new Dimension(150, 35));
        this.sliderZ.setPaintTicks(true);
        this.sliderZ.setMajorTickSpacing(10);
        this.sliderZ.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (Mango.isVoxelDisplay()) {
                    EditTransformTool.this.currentTransform.setTemporaryForceNearestNeighbor(true);
                }
                EditTransformTool.this.updateCenterTransforms(me.isShiftDown());
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (Mango.isVoxelDisplay()) {
                    EditTransformTool.this.currentTransform.setTemporaryForceNearestNeighbor(false);
                }
                EditTransformTool.this.updateViewer(false);
                EditTransformTool.this.viewer.updateSurface();
            }
        });
        this.sliderZ.addChangeListener(this);
        this.textFieldZ = new MangoTextField("0", 3);
        this.textFieldZ.setActionCommand("textFieldZ");
        this.textFieldZ.addActionListener(this);
        this.textFieldZ.setFont(FONT_SMALL);
        this.textFieldZ.setMaximumSize(this.textFieldZ.getPreferredSize());
        this.textFieldZ.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
            }

            @Override
            public void focusLost(FocusEvent fe) {
                EditTransformTool.this.resetTextfieldZ();
            }
        });
        JPanel zPanel = new JPanel();
        zPanel.setLayout(new BoxLayout(zPanel, 0));
        zPanel.add(this.zLabel);
        zPanel.add(this.sliderZ);
        zPanel.add(this.textFieldZ);
        zPanel.add(Box.createHorizontalStrut(4));
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new GridLayout(4, 1));
        rightPanel.add(zPanel, 0, 0);
        rightPanel.add(yPanel, 1, 0);
        rightPanel.add(xPanel, 2, 0);
        rightPanel.add(rightButtonPanel, 3, 0);
        rightPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 8, 8));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        mainPanel.add(leftPanel);
        mainPanel.add(middlePanel);
        mainPanel.add(rightPanel);
        this.updateToggleButton();
        this.clearTransforms();
        this.reconcileWithViewerTransformState();
        this.viewer.associateWindow(this);
        this.setTitle("Transform: " + this.viewer.getImageTitle());
        this.setContentPane(mainPanel);
        this.pack();
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.setLocation(DisplayUtils.getCenterDialogLocation(this.viewer.getViewerContainer(), START_SIZE));
        this.setIconImage(MangoStyle.ICON_APP.getImage());
        this.setVisible(true);
        this.requestFocus();
        this.toFront();
    }

    private void recordTransform() {
        double[][] aTransform = null;
        aTransform = this.isInverse ? this.transform : new Matrix(this.transform).inverse().getArray();
        double[][] mat = this.sizeThis.times(new Matrix(aTransform)).times(this.sizeThis.inverse()).getArrayCopy();
        this.viewer.recordAction("transform", new String[]{this.viewer.getScriptObjectName() + ".baseVolume", String.valueOf(mat[0][0]), String.valueOf(mat[0][1]), String.valueOf(mat[0][2]), String.valueOf(mat[0][3]), String.valueOf(mat[1][0]), String.valueOf(mat[1][1]), String.valueOf(mat[1][2]), String.valueOf(mat[1][3]), String.valueOf(mat[2][0]), String.valueOf(mat[2][1]), String.valueOf(mat[2][2]), String.valueOf(mat[2][3]), String.valueOf(mat[3][0]), String.valueOf(mat[3][1]), String.valueOf(mat[3][2]), String.valueOf(mat[3][3])});
    }

    private void decompose() {
        int i;
        int i2;
        double[][] aTransform = new Matrix(this.transform).inverse().getArray();
        if (!this.isImageTransformType) {
            int ctrIn;
            int ctrOut;
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.transformTemp[ctrOut][ctrIn] = this.center[ctrOut][0] * aTransform[0][ctrIn] + this.center[ctrOut][1] * aTransform[1][ctrIn] + this.center[ctrOut][2] * aTransform[2][ctrIn] + this.center[ctrOut][3] * aTransform[3][ctrIn];
                }
            }
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    aTransform[ctrOut][ctrIn] = this.transformTemp[ctrOut][0] * this.centerInverse[0][ctrIn] + this.transformTemp[ctrOut][1] * this.centerInverse[1][ctrIn] + this.transformTemp[ctrOut][2] * this.centerInverse[2][ctrIn] + this.transformTemp[ctrOut][3] * this.centerInverse[3][ctrIn];
                }
            }
        }
        double[][] locmat = new double[4][4];
        locmat = this.transpose4x4(aTransform);
        if (locmat[3][3] == 0.0) {
            return;
        }
        double[][] pmat = new double[4][4];
        for (i2 = 0; i2 < 4; ++i2) {
            int j = 0;
            while (j < 4) {
                double[] dArray = locmat[i2];
                int n = j++;
                dArray[n] = dArray[n] / locmat[3][3];
            }
        }
        for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                pmat[ctrIn][ctrOut] = locmat[ctrIn][ctrOut];
            }
        }
        for (i2 = 0; i2 < 3; ++i2) {
            pmat[i2][3] = 0.0;
        }
        pmat[3][3] = 1.0;
        if (new Matrix(this.transpose4x4(pmat)).det() == 0.0) {
            return;
        }
        double[] tran = new double[16];
        Point3d[] row = new Point3d[]{new Point3d(), new Point3d(), new Point3d()};
        Point3d pdum3 = new Point3d();
        Point4d prhs = new Point4d();
        Point4d psol = new Point4d();
        double[][] tinvpmat = new double[4][4];
        if (locmat[0][3] != 0.0 || locmat[1][3] != 0.0 || locmat[2][3] != 0.0) {
            prhs.x = locmat[0][3];
            prhs.y = locmat[1][3];
            prhs.z = locmat[2][3];
            prhs.w = locmat[3][3];
            Matrix pmatInv = new Matrix(this.transpose4x4(pmat)).inverse();
            double[][] invpmat = this.transpose4x4(pmatInv.getArray());
            this.transposeMatrix4(invpmat, tinvpmat);
            this.v4MulPointByMatrix(prhs, tinvpmat, psol);
            tran[PARAMS.U_PERSPX.ordinal()] = psol.x;
            tran[PARAMS.U_PERSPY.ordinal()] = psol.y;
            tran[PARAMS.U_PERSPZ.ordinal()] = psol.z;
            tran[PARAMS.U_PERSPW.ordinal()] = psol.w;
            locmat[2][3] = 0.0;
            locmat[1][3] = 0.0;
            locmat[0][3] = 0.0;
            locmat[3][3] = 1.0;
        } else {
            tran[PARAMS.U_PERSPW.ordinal()] = 0.0;
            tran[PARAMS.U_PERSPZ.ordinal()] = 0.0;
            tran[PARAMS.U_PERSPY.ordinal()] = 0.0;
            tran[PARAMS.U_PERSPX.ordinal()] = 0.0;
        }
        for (i = 0; i < 3; ++i) {
            tran[PARAMS.U_TRANSX.ordinal() + i] = locmat[3][i];
            locmat[3][i] = 0.0;
        }
        for (i = 0; i < 3; ++i) {
            row[i].x = locmat[i][0];
            row[i].y = locmat[i][1];
            row[i].z = locmat[i][2];
        }
        tran[PARAMS.U_SCALEX.ordinal()] = this.v3Length(row[0]);
        row[0] = this.v3Scale(row[0], 1.0);
        tran[PARAMS.U_SHEARXY.ordinal()] = this.v3Dot(row[0], row[1]);
        row[1] = this.v3Combine(row[1], row[0], 1.0, -tran[PARAMS.U_SHEARXY.ordinal()]);
        tran[PARAMS.U_SCALEY.ordinal()] = this.v3Length(row[1]);
        row[1] = this.v3Scale(row[1], 1.0);
        int n = PARAMS.U_SHEARXY.ordinal();
        tran[n] = tran[n] / tran[PARAMS.U_SCALEY.ordinal()];
        tran[PARAMS.U_SHEARXZ.ordinal()] = this.v3Dot(row[0], row[2]);
        row[2] = this.v3Combine(row[2], row[0], 1.0, -tran[PARAMS.U_SHEARXZ.ordinal()]);
        tran[PARAMS.U_SHEARYZ.ordinal()] = this.v3Dot(row[1], row[2]);
        row[2] = this.v3Combine(row[2], row[1], 1.0, -tran[PARAMS.U_SHEARYZ.ordinal()]);
        tran[PARAMS.U_SCALEZ.ordinal()] = this.v3Length(row[2]);
        row[2] = this.v3Scale(row[2], 1.0);
        int n2 = PARAMS.U_SHEARXZ.ordinal();
        tran[n2] = tran[n2] / tran[PARAMS.U_SCALEZ.ordinal()];
        int n3 = PARAMS.U_SHEARYZ.ordinal();
        tran[n3] = tran[n3] / tran[PARAMS.U_SCALEZ.ordinal()];
        if (this.v3Dot(row[0], this.v3Cross(row[1], row[2], pdum3)) < 0.0) {
            for (i = 0; i < 3; ++i) {
                int n4 = PARAMS.U_SCALEX.ordinal() + i;
                tran[n4] = tran[n4] * -1.0;
                row[i].x *= -1.0;
                row[i].y *= -1.0;
                row[i].z *= -1.0;
            }
        }
        tran[PARAMS.U_ROTATEY.ordinal()] = Math.asin(-row[0].z);
        if (Math.cos(tran[PARAMS.U_ROTATEY.ordinal()]) != 0.0) {
            tran[PARAMS.U_ROTATEX.ordinal()] = Math.atan2(row[1].z, row[2].z);
            tran[PARAMS.U_ROTATEZ.ordinal()] = Math.atan2(row[0].y, row[0].x);
        } else {
            tran[PARAMS.U_ROTATEX.ordinal()] = Math.atan2(-row[2].x, row[1].y);
            tran[PARAMS.U_ROTATEZ.ordinal()] = 0.0;
        }
        this.xTrans = tran[PARAMS.U_TRANSX.ordinal()];
        this.yTrans = tran[PARAMS.U_TRANSY.ordinal()];
        this.zTrans = tran[PARAMS.U_TRANSZ.ordinal()];
        this.xRot = tran[PARAMS.U_ROTATEX.ordinal()];
        this.yRot = tran[PARAMS.U_ROTATEY.ordinal()];
        this.zRot = tran[PARAMS.U_ROTATEZ.ordinal()];
        this.xScale = tran[PARAMS.U_SCALEX.ordinal()];
        this.yScale = tran[PARAMS.U_SCALEY.ordinal()];
        this.zScale = tran[PARAMS.U_SCALEZ.ordinal()];
        this.xSkew = tran[PARAMS.U_SHEARYZ.ordinal()];
        this.ySkew = tran[PARAMS.U_SHEARXZ.ordinal()];
        this.zSkew = tran[PARAMS.U_SHEARXY.ordinal()];
        this.xRot *= 57.29577951308232;
        this.yRot *= 57.29577951308232;
        this.zRot *= 57.29577951308232;
        if (!this.isInverse) {
            this.xTrans *= -1.0;
            this.yTrans *= -1.0;
            this.zTrans *= -1.0;
            this.xRot *= -1.0;
            this.yRot *= -1.0;
            this.zRot *= -1.0;
            this.xScale = 1.0 / this.xScale;
            this.yScale = 1.0 / this.yScale;
            this.zScale = 1.0 / this.zScale;
            this.xSkew *= -1.0;
            this.ySkew *= -1.0;
            this.zSkew *= -1.0;
        }
        this.xTrans = this.validateZero(this.xTrans);
        this.yTrans = this.validateZero(this.yTrans);
        this.zTrans = this.validateZero(this.zTrans);
        this.xRot = this.validateZero(this.xRot);
        this.yRot = this.validateZero(this.yRot);
        this.zRot = this.validateZero(this.zRot);
        this.xSkew = this.validateZero(this.xSkew);
        this.ySkew = this.validateZero(this.ySkew);
        this.zSkew = this.validateZero(this.zSkew);
    }

    private void doChangeCenterOfRotation() {
        TransformOptionsDialog dialog = new TransformOptionsDialog(this.currentTransform.getPreferredPointOfRotation());
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.viewer.getManualTransformPanel(), dialog, "Change Center of Rotation", -1, null);
        int selection = jopf.show();
        if (selection == 0) {
            if (dialog.useOrigin()) {
                this.currentTransform.setPreferredPointOfRotation(1);
                Coordinate origin = this.viewer.getOrigin();
                this.currentTransform.setPreferredPointOfRotationCoordinate(origin.xDbl, origin.yDbl, origin.zDbl);
            } else if (dialog.useCurrent()) {
                this.currentTransform.setPreferredPointOfRotation(2);
                Coordinate current = this.viewer.getCurrentIndex(null);
                this.currentTransform.setPreferredPointOfRotationCoordinate(current.xDbl, current.yDbl, current.zDbl);
            } else {
                this.currentTransform.setPreferredPointOfRotation(0);
            }
            this.updateViewer(false);
        }
    }

    private void doChangeMNIToTalairach() {
        this.viewer.getBaseScreenVolume().setTransformToMNI();
        this.viewer.addTransformPost();
        this.viewer.updateViewer();
    }

    private void doChangeTalairachToMNI() {
        this.viewer.getBaseScreenVolume().setTransformToTalairach();
        this.viewer.addTransformPost();
        this.viewer.updateViewer();
    }

    private void doLoad() {
        this.viewer.addTransform();
        this.removeAllSteps();
        this.saveStep();
    }

    private void doSave() {
        double[][] aTransform = null;
        aTransform = this.isInverse ? new Matrix(this.transform).inverse().getArray() : this.transform;
        if (!this.isImageTransformType) {
            int ctrIn;
            int ctrOut;
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.transformTemp[ctrOut][ctrIn] = this.center[ctrOut][0] * aTransform[0][ctrIn] + this.center[ctrOut][1] * aTransform[1][ctrIn] + this.center[ctrOut][2] * aTransform[2][ctrIn] + this.center[ctrOut][3] * aTransform[3][ctrIn];
                }
            }
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    aTransform[ctrOut][ctrIn] = this.validateZero(this.transformTemp[ctrOut][0] * this.centerInverse[0][ctrIn] + this.transformTemp[ctrOut][1] * this.centerInverse[1][ctrIn] + this.transformTemp[ctrOut][2] * this.centerInverse[2][ctrIn] + this.transformTemp[ctrOut][3] * this.centerInverse[3][ctrIn]);
                }
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                sb.append(aTransform[ctrOut][ctrIn]);
                sb.append(' ');
            }
            sb.append('\n');
        }
        this.viewer.saveFile(sb.toString(), ".xform");
    }

    private int getNumSteps() {
        return this.steps.size();
    }

    private Matrix getStep() {
        return this.steps.lastElement();
    }

    private void makePopupMenu() {
        this.popup = new JPopupMenu();
        for (String element : OPTIONS) {
            JMenuItem mi = new JMenuItem(element);
            mi.addActionListener(this);
            this.popup.add(mi);
        }
        this.popup.addPopupMenuListener(this);
    }

    private void makeSizeTransform() {
        this.size[0][0] = 1.0;
        this.size[1][1] = 1.0;
        this.size[2][2] = 1.0;
        this.size[3][3] = 1.0;
        this.sizeInverse[0][0] = 1.0;
        this.sizeInverse[1][1] = 1.0;
        this.sizeInverse[2][2] = 1.0;
        this.sizeInverse[3][3] = 1.0;
    }

    private void removeAllSteps() {
        this.steps.removeAllElements();
    }

    private void removeStep() {
        if (this.steps.size() > 0) {
            this.steps.remove(this.steps.size() - 1);
        }
    }

    private void resetSliderValues() {
        this.zSliderTransValue = 0.0;
        this.ySliderTransValue = 0.0;
        this.xSliderTransValue = 0.0;
        this.zSliderRotValue = 0.0;
        this.ySliderRotValue = 0.0;
        this.xSliderRotValue = 0.0;
        this.zSliderScaleValue = 1.0;
        this.ySliderScaleValue = 1.0;
        this.xSliderScaleValue = 1.0;
        this.xzSliderSkewValue = 0.0;
        this.yzSliderSkewValue = 0.0;
        this.xySliderSkewValue = 0.0;
    }

    private void resetTextfieldX() {
        if (this.isTrans) {
            this.textFieldX.setText(String.valueOf(this.xSliderTransValue));
        } else if (this.isRot) {
            this.textFieldX.setText(String.valueOf(this.xSliderRotValue));
        } else if (this.isScale) {
            this.textFieldX.setText(String.valueOf(this.xSliderScaleValue));
        } else if (this.isSkew) {
            this.textFieldX.setText(String.valueOf(this.yzSliderSkewValue));
        }
    }

    private void resetTextfieldY() {
        if (this.isTrans) {
            this.textFieldY.setText(String.valueOf(this.ySliderTransValue));
        } else if (this.isRot) {
            this.textFieldY.setText(String.valueOf(this.ySliderRotValue));
        } else if (this.isScale) {
            this.textFieldY.setText(String.valueOf(this.ySliderScaleValue));
        } else if (this.isSkew) {
            this.textFieldY.setText(String.valueOf(this.xzSliderSkewValue));
        }
    }

    private void resetTextfieldZ() {
        if (this.isTrans) {
            this.textFieldZ.setText(String.valueOf(this.zSliderTransValue));
        } else if (this.isRot) {
            this.textFieldZ.setText(String.valueOf(this.zSliderRotValue));
        } else if (this.isScale) {
            this.textFieldZ.setText(String.valueOf(this.zSliderScaleValue));
        } else if (this.isSkew) {
            this.textFieldZ.setText(String.valueOf(this.xySliderSkewValue));
        }
    }

    private void saveStep() {
        double[][] savingStep = new double[4][4];
        for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                savingStep[ctrOut][ctrIn] = this.transform[ctrOut][ctrIn];
            }
        }
        this.addStep(new Matrix(savingStep));
        this.updateLastStep();
        this.resetSliderValues();
        if (this.isTrans) {
            this.updateTranslateSlider();
        } else if (this.isRot) {
            this.updateRotateSlider();
        } else if (this.isScale) {
            this.updateScaleSlider();
        } else if (this.isSkew) {
            this.updateSkewSlider();
        }
        this.resetTextfieldX();
        this.resetTextfieldY();
        this.resetTextfieldZ();
        this.clearTransforms();
        this.updateTransformFromSliders();
        this.updateTransform();
        this.updateViewer(false);
    }

    private void showMatrixPanel() {
        ((CardLayout)this.infoPanel.getLayout()).show(this.infoPanel, "transformPanel");
    }

    private void showParametersPanel() {
        ((CardLayout)this.infoPanel.getLayout()).show(this.infoPanel, "parametersPanel");
    }

    private void toggleTransformType() {
        boolean bl = this.isImageTransformType = !this.isImageTransformType;
        if (this.isImageTransformType) {
            this.imageRadioButton.setSelected(true);
        } else {
            this.worldRadioButton.setSelected(true);
        }
        this.updateTransform();
    }

    private double[][] transpose4x4(double[][] mat) {
        double[][] output = new double[4][4];
        for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                output[ctrIn][ctrOut] = mat[ctrOut][ctrIn];
            }
        }
        return output;
    }

    private double[][] transposeMatrix4(double[][] a, double[][] b) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                b[i][j] = a[j][i];
            }
        }
        return b;
    }

    private void undoStep() {
        int ctrIn;
        int ctrOut;
        boolean isSame = true;
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                isSame &= this.transform[ctrOut][ctrIn] == this.lastStep[ctrOut][ctrIn];
            }
        }
        if (isSame) {
            this.removeStep();
        }
        this.resetSliderValues();
        this.resetTextfieldX();
        this.resetTextfieldY();
        this.resetTextfieldZ();
        if (this.isTrans) {
            this.updateTranslateSlider();
        } else if (this.isRot) {
            this.updateRotateSlider();
        } else if (this.isScale) {
            this.updateScaleSlider();
        } else if (this.isSkew) {
            this.updateSkewSlider();
        }
        this.clearTransforms();
        this.updateLastStep();
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.transform[ctrOut][ctrIn] = this.lastStep[ctrOut][ctrIn];
            }
        }
        this.updateTransform();
        this.updateViewer(false);
    }

    private void updateCenterTransforms() {
        this.updateCenterTransforms(false);
    }

    private void updateCenterTransforms(boolean rotateCrosshairs) {
        double sagittalPos;
        double coronalPos;
        double axialPos;
        if (rotateCrosshairs) {
            axialPos = this.viewer.getAxialSliceNumber();
            coronalPos = this.viewer.getCoronalSliceNumber();
            sagittalPos = this.viewer.getSagittalSliceNumber();
        } else if (this.currentTransform != null && this.currentTransform.getPreferredPointOfRotation() != 0) {
            Coordinate coor = this.currentTransform.getPreferredPointOfRotationCoordinate();
            axialPos = coor.zDbl;
            coronalPos = coor.yDbl;
            sagittalPos = coor.xDbl;
        } else {
            axialPos = (double)this.zImageDim / 2.0;
            coronalPos = (double)this.yImageDim / 2.0;
            sagittalPos = (double)this.xImageDim / 2.0;
        }
        this.center[3][3] = 1.0;
        this.center[2][2] = 1.0;
        this.center[1][1] = 1.0;
        this.center[0][0] = 1.0;
        this.center[0][3] = -1.0 * sagittalPos * this.xSize;
        this.center[1][3] = -1.0 * coronalPos * this.ySize;
        this.center[2][3] = -1.0 * axialPos * this.zSize;
        this.centerInverse[3][3] = 1.0;
        this.centerInverse[2][2] = 1.0;
        this.centerInverse[1][1] = 1.0;
        this.centerInverse[0][0] = 1.0;
        this.centerInverse[0][3] = sagittalPos * this.xSize;
        this.centerInverse[1][3] = coronalPos * this.ySize;
        this.centerInverse[2][3] = axialPos * this.zSize;
    }

    private void updateInverse() {
        boolean bl = this.isInverse = !this.inverseButton.isSelected();
        if (this.inverseButton.isSelected()) {
            this.inverseButton.setText("Inverse");
        } else {
            this.inverseButton.setText("Forward");
        }
        this.updateTransform();
        this.updateViewer(false);
    }

    private void updateLastStep() {
        double[][] tempStep = null;
        tempStep = this.getNumSteps() > 0 ? this.getStep().getArray() : IDENTITY;
        for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.lastStep[ctrOut][ctrIn] = tempStep[ctrOut][ctrIn];
            }
        }
    }

    private void updateParameters() {
        this.parameterLabels[0][0].setText("Trans:");
        this.parameterLabels[0][1].setText(FORMATTER.format(this.xTrans));
        this.parameterLabels[0][2].setText(FORMATTER.format(this.yTrans));
        this.parameterLabels[0][3].setText(FORMATTER.format(this.zTrans));
        this.parameterLabels[1][0].setText("Rot:");
        this.parameterLabels[1][1].setText(FORMATTER.format(this.xRot));
        this.parameterLabels[1][2].setText(FORMATTER.format(this.yRot));
        this.parameterLabels[1][3].setText(FORMATTER.format(this.zRot));
        this.parameterLabels[2][0].setText("Scale:");
        this.parameterLabels[2][1].setText(FORMATTER.format(this.xScale));
        this.parameterLabels[2][2].setText(FORMATTER.format(this.yScale));
        this.parameterLabels[2][3].setText(FORMATTER.format(this.zScale));
        this.parameterLabels[3][0].setText("Skew:");
        this.parameterLabels[3][1].setText(FORMATTER.format(this.xSkew));
        this.parameterLabels[3][2].setText(FORMATTER.format(this.ySkew));
        this.parameterLabels[3][3].setText(FORMATTER.format(this.zSkew));
    }

    private void updateParameters(double transX, double transY, double transZ, double rotX, double rotY, double rotZ, double scaleX, double scaleY, double scaleZ, double skewX, double skewY, double skewZ) {
        this.xTrans = transX;
        this.yTrans = transY;
        this.zTrans = transZ;
        this.xRot = rotX;
        this.yRot = rotY;
        this.zRot = rotZ;
        this.xScale = scaleX;
        this.yScale = scaleY;
        this.zScale = scaleZ;
        this.xSkew = skewX;
        this.ySkew = skewY;
        this.zSkew = skewZ;
        this.updateParameters();
    }

    private void updateRotateSlider() {
        this.frozenState = true;
        this.sliderX.setMinimum(-45);
        this.sliderX.setMaximum(45);
        this.sliderX.setValue((int)Math.round(this.xSliderRotValue));
        this.sliderY.setMinimum(-45);
        this.sliderY.setMaximum(45);
        this.sliderY.setValue((int)Math.round(this.ySliderRotValue));
        this.sliderZ.setMinimum(-45);
        this.sliderZ.setMaximum(45);
        this.sliderZ.setValue((int)Math.round(this.zSliderRotValue));
        this.frozenState = false;
    }

    private void updateScaleSlider() {
        this.frozenState = true;
        this.sliderX.setMinimum(-25);
        this.sliderX.setMaximum(25);
        this.sliderX.setValue((int)Math.round(this.xSliderScaleValue * 100.0 - 100.0));
        this.sliderY.setMinimum(-25);
        this.sliderY.setMaximum(25);
        this.sliderY.setValue((int)Math.round(this.ySliderScaleValue * 100.0 - 100.0));
        this.sliderZ.setMinimum(-25);
        this.sliderZ.setMaximum(25);
        this.sliderZ.setValue((int)Math.round(this.zSliderScaleValue * 100.0 - 100.0));
        this.frozenState = false;
    }

    private void updateSkewLabelButtons() {
        if (this.isSkew) {
            this.xLabel.setText("YZ");
            this.yLabel.setText("XZ");
            this.zLabel.setText("XY");
        } else {
            this.xLabel.setText("X");
            this.yLabel.setText("Y");
            this.zLabel.setText("Z");
            this.xLabel.setBorder(null);
            this.yLabel.setBorder(null);
            this.zLabel.setBorder(null);
        }
    }

    private void updateSkewSlider() {
        this.frozenState = true;
        this.sliderX.setMinimum(-50);
        this.sliderX.setMaximum(50);
        this.sliderX.setValue((int)Math.round(this.yzSliderSkewValue * 100.0));
        this.sliderY.setMinimum(-50);
        this.sliderY.setMaximum(50);
        this.sliderY.setValue((int)Math.round(this.xzSliderSkewValue * 100.0));
        this.sliderZ.setMinimum(-50);
        this.sliderZ.setMaximum(50);
        this.sliderZ.setValue((int)Math.round(this.xySliderSkewValue * 100.0));
        this.frozenState = false;
    }

    private void updateSliderFromTextBox() {
        if (this.isTrans) {
            this.updateTranslateSlider();
        } else if (this.isRot) {
            this.updateRotateSlider();
        } else if (this.isScale) {
            this.updateScaleSlider();
        } else if (this.isSkew) {
            this.updateSkewSlider();
        }
    }

    private void updateToggleButton() {
        if (this.isTrans) {
            this.transButton.setOpaque(false);
            this.transButton.setBorder(BorderFactory.createLoweredBevelBorder());
        } else {
            this.transButton.setOpaque(true);
            this.transButton.setBorder(BorderFactory.createRaisedBevelBorder());
        }
        if (this.isRot) {
            this.rotButton.setOpaque(false);
            this.rotButton.setBorder(BorderFactory.createLoweredBevelBorder());
        } else {
            this.rotButton.setOpaque(true);
            this.rotButton.setBorder(BorderFactory.createRaisedBevelBorder());
        }
        if (this.isScale) {
            this.scaleButton.setOpaque(false);
            this.scaleButton.setBorder(BorderFactory.createLoweredBevelBorder());
        } else {
            this.scaleButton.setOpaque(true);
            this.scaleButton.setBorder(BorderFactory.createRaisedBevelBorder());
        }
        if (this.isSkew) {
            this.skewButton.setOpaque(false);
            this.skewButton.setBorder(BorderFactory.createLoweredBevelBorder());
        } else {
            this.skewButton.setOpaque(true);
            this.skewButton.setBorder(BorderFactory.createRaisedBevelBorder());
        }
    }

    private void updateTransform() {
        double[][] aTransform = null;
        aTransform = this.isInverse ? new Matrix(this.transform).inverse().getArray() : this.transform;
        if (!this.isImageTransformType) {
            int ctrIn;
            int ctrOut;
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.transformTemp[ctrOut][ctrIn] = this.center[ctrOut][0] * aTransform[0][ctrIn] + this.center[ctrOut][1] * aTransform[1][ctrIn] + this.center[ctrOut][2] * aTransform[2][ctrIn] + this.center[ctrOut][3] * aTransform[3][ctrIn];
                }
            }
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    aTransform[ctrOut][ctrIn] = this.validateZero(this.transformTemp[ctrOut][0] * this.centerInverse[0][ctrIn] + this.transformTemp[ctrOut][1] * this.centerInverse[1][ctrIn] + this.transformTemp[ctrOut][2] * this.centerInverse[2][ctrIn] + this.transformTemp[ctrOut][3] * this.centerInverse[3][ctrIn]);
                }
            }
        }
        this.transformLabels[0][0].setText(FORMATTER.format(aTransform[0][0]));
        this.transformLabels[0][1].setText(FORMATTER.format(aTransform[0][1]));
        this.transformLabels[0][2].setText(FORMATTER.format(aTransform[0][2]));
        this.transformLabels[0][3].setText(FORMATTER.format(aTransform[0][3]));
        this.transformLabels[1][0].setText(FORMATTER.format(aTransform[1][0]));
        this.transformLabels[1][1].setText(FORMATTER.format(aTransform[1][1]));
        this.transformLabels[1][2].setText(FORMATTER.format(aTransform[1][2]));
        this.transformLabels[1][3].setText(FORMATTER.format(aTransform[1][3]));
        this.transformLabels[2][0].setText(FORMATTER.format(aTransform[2][0]));
        this.transformLabels[2][1].setText(FORMATTER.format(aTransform[2][1]));
        this.transformLabels[2][2].setText(FORMATTER.format(aTransform[2][2]));
        this.transformLabels[2][3].setText(FORMATTER.format(aTransform[2][3]));
        this.transformLabels[3][0].setText(FORMATTER.format(aTransform[3][0]));
        this.transformLabels[3][1].setText(FORMATTER.format(aTransform[3][1]));
        this.transformLabels[3][2].setText(FORMATTER.format(aTransform[3][2]));
        this.transformLabels[3][3].setText(FORMATTER.format(aTransform[3][3]));
        this.decompose();
        this.updateParameters();
    }

    private void updateTransform(double x00, double x01, double x02, double x03, double x10, double x11, double x12, double x13, double x20, double x21, double x22, double x23, double x30, double x31, double x32, double x33) {
        this.transform[0][0] = x00;
        this.transform[0][1] = x01;
        this.transform[0][2] = x02;
        this.transform[0][3] = x03;
        this.transform[1][0] = x10;
        this.transform[1][1] = x11;
        this.transform[1][2] = x12;
        this.transform[1][3] = x13;
        this.transform[2][0] = x20;
        this.transform[2][1] = x21;
        this.transform[2][2] = x22;
        this.transform[2][3] = x23;
        this.transform[3][0] = x30;
        this.transform[3][1] = x31;
        this.transform[3][2] = x32;
        this.transform[3][3] = x33;
        this.updateTransform();
    }

    private void updateTransformFromSliders() {
        int ctrIn;
        int ctrOut;
        if (this.isTrans) {
            this.translation[0][3] = -1.0 * this.xSliderTransValue * this.spatialUnitMultiplier;
            this.translation[1][3] = -1.0 * this.ySliderTransValue * this.spatialUnitMultiplier;
            this.translation[2][3] = -1.0 * this.zSliderTransValue * this.spatialUnitMultiplier;
        }
        if (this.isRot) {
            double theta = this.xSliderRotValue * Math.PI / 180.0;
            double cosTheta = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            this.rotationX[1][1] = cosTheta;
            this.rotationX[1][2] = sinTheta;
            this.rotationX[2][1] = -1.0 * sinTheta;
            this.rotationX[2][2] = cosTheta;
            theta = this.ySliderRotValue * Math.PI / 180.0;
            cosTheta = Math.cos(theta);
            sinTheta = Math.sin(theta);
            this.rotationY[0][0] = cosTheta;
            this.rotationY[0][2] = -1.0 * sinTheta;
            this.rotationY[2][0] = sinTheta;
            this.rotationY[2][2] = cosTheta;
            theta = this.zSliderRotValue * Math.PI / 180.0;
            cosTheta = Math.cos(theta);
            sinTheta = Math.sin(theta);
            this.rotationZ[0][0] = cosTheta;
            this.rotationZ[0][1] = sinTheta;
            this.rotationZ[1][0] = -1.0 * sinTheta;
            this.rotationZ[1][1] = cosTheta;
        }
        if (this.isScale) {
            this.scale[0][0] = 1.0 / this.xSliderScaleValue;
            this.scale[1][1] = 1.0 / this.ySliderScaleValue;
            this.scale[2][2] = 1.0 / this.zSliderScaleValue;
        }
        if (this.isSkew) {
            this.skew[0][1] = -this.xySliderSkewValue;
            this.skew[1][2] = -this.yzSliderSkewValue;
            this.skew[2][0] = -this.xzSliderSkewValue;
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.transformTemp[ctrOut][ctrIn] = this.rotationX[ctrOut][0] * this.rotationY[0][ctrIn] + this.rotationX[ctrOut][1] * this.rotationY[1][ctrIn] + this.rotationX[ctrOut][2] * this.rotationY[2][ctrIn] + this.rotationX[ctrOut][3] * this.rotationY[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.transformTemp2[ctrOut][ctrIn] = this.transformTemp[ctrOut][0] * this.rotationZ[0][ctrIn] + this.transformTemp[ctrOut][1] * this.rotationZ[1][ctrIn] + this.transformTemp[ctrOut][2] * this.rotationZ[2][ctrIn] + this.transformTemp[ctrOut][3] * this.rotationZ[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.transformTemp[ctrOut][ctrIn] = this.transformTemp2[ctrOut][0] * this.scale[0][ctrIn] + this.transformTemp2[ctrOut][1] * this.scale[1][ctrIn] + this.transformTemp2[ctrOut][2] * this.scale[2][ctrIn] + this.transformTemp2[ctrOut][3] * this.scale[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.transformTemp2[ctrOut][ctrIn] = this.transformTemp[ctrOut][0] * this.skew[0][ctrIn] + this.transformTemp[ctrOut][1] * this.skew[1][ctrIn] + this.transformTemp[ctrOut][2] * this.skew[2][ctrIn] + this.transformTemp[ctrOut][3] * this.skew[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.worldTypeTransform[ctrOut][ctrIn] = this.transformTemp2[ctrOut][0] * this.translation[0][ctrIn] + this.transformTemp2[ctrOut][1] * this.translation[1][ctrIn] + this.transformTemp2[ctrOut][2] * this.translation[2][ctrIn] + this.transformTemp2[ctrOut][3] * this.translation[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.transformTemp[ctrOut][ctrIn] = this.centerInverse[ctrOut][0] * this.worldTypeTransform[0][ctrIn] + this.centerInverse[ctrOut][1] * this.worldTypeTransform[1][ctrIn] + this.centerInverse[ctrOut][2] * this.worldTypeTransform[2][ctrIn] + this.centerInverse[ctrOut][3] * this.worldTypeTransform[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.sliderTransform[ctrOut][ctrIn] = this.transformTemp[ctrOut][0] * this.center[0][ctrIn] + this.transformTemp[ctrOut][1] * this.center[1][ctrIn] + this.transformTemp[ctrOut][2] * this.center[2][ctrIn] + this.transformTemp[ctrOut][3] * this.center[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.transform[ctrOut][ctrIn] = this.lastStep[ctrOut][0] * this.sliderTransform[0][ctrIn] + this.lastStep[ctrOut][1] * this.sliderTransform[1][ctrIn] + this.lastStep[ctrOut][2] * this.sliderTransform[2][ctrIn] + this.lastStep[ctrOut][3] * this.sliderTransform[3][ctrIn];
            }
        }
    }

    private void updateTranslateSlider() {
        this.frozenState = true;
        this.sliderX.setMinimum(-50);
        this.sliderX.setMaximum(50);
        this.sliderX.setValue((int)Math.round(this.xSliderTransValue));
        this.sliderY.setMinimum(-50);
        this.sliderY.setMaximum(50);
        this.sliderY.setValue((int)Math.round(this.ySliderTransValue));
        this.sliderZ.setMinimum(-50);
        this.sliderZ.setMaximum(50);
        this.sliderZ.setValue((int)Math.round(this.zSliderTransValue));
        this.frozenState = false;
    }

    private Point3d v3Combine(Point3d a, Point3d b, double ascl, double bscl) {
        Point3d result = new Point3d();
        result.x = ascl * a.x + bscl * b.x;
        result.y = ascl * a.y + bscl * b.y;
        result.z = ascl * a.z + bscl * b.z;
        return result;
    }

    private Point3d v3Cross(Point3d a, Point3d b, Point3d c) {
        c.x = a.y * b.z - a.z * b.y;
        c.y = a.z * b.x - a.x * b.z;
        c.z = a.x * b.y - a.y * b.x;
        return c;
    }

    private double v3Dot(Point3d a, Point3d b) {
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    private double v3Length(Point3d a) {
        return Math.sqrt(a.x * a.x + a.y * a.y + a.z * a.z);
    }

    private Point3d v3Scale(Point3d v, double newlen) {
        double len = this.v3Length(v);
        if (len != 0.0) {
            v.x *= newlen / len;
            v.y *= newlen / len;
            v.z *= newlen / len;
        }
        return v;
    }

    private Point4d v4MulPointByMatrix(Point4d pin, double[][] m, Point4d pout) {
        pout.x = pin.x * m[0][0] + pin.y * m[1][0] + pin.z * m[2][0] + pin.w * m[3][0];
        pout.y = pin.x * m[0][1] + pin.y * m[1][1] + pin.z * m[2][1] + pin.w * m[3][1];
        pout.z = pin.x * m[0][2] + pin.y * m[1][2] + pin.z * m[2][2] + pin.w * m[3][2];
        pout.w = pin.x * m[0][3] + pin.y * m[1][3] + pin.z * m[2][3] + pin.w * m[3][3];
        return pout;
    }

    private double validateZero(double num) {
        if (Math.abs(num) < 1.0E-5) {
            return 0.0;
        }
        return num;
    }

    static enum PARAMS {
        U_PERSPW,
        U_PERSPX,
        U_PERSPY,
        U_PERSPZ,
        U_ROTATEX,
        U_ROTATEY,
        U_ROTATEZ,
        U_SCALEX,
        U_SCALEY,
        U_SCALEZ,
        U_SHEARXY,
        U_SHEARXZ,
        U_SHEARYZ,
        U_TRANSX,
        U_TRANSY,
        U_TRANSZ;

    }
}

