/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.series;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoSquareButton;
import edu.uthscsa.ric.mango.dialogs.modal.file.SaveFileDialog;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.mango.viewerslice.dialogs.series.Timeseries;
import edu.uthscsa.ric.roi.ROI;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;

public class TimeseriesTool
extends JFrame
implements ActionListener,
ViewerAssociated {
    private JButton clearButton;
    private JButton keepButton;
    private JButton nextButton;
    private JButton previousButton;
    private JComboBox<String> showBox;
    private JComboBox<String> statsBox;
    private Timeseries timeseries;
    private final Mango mango;
    private final SliceViewer viewer;
    private static final long serialVersionUID = 1L;
    public static final Dimension CROSSSECTION_SIZE = new Dimension(400, 250);
    public static final String DESCRIPTION = "Series";
    public static final int MINIMUM_HEIGHT = 375;
    public static final int MINIMUM_WIDTH = 500;

    public TimeseriesTool(Mango mango, SliceViewer viewer) {
        this.mango = mango;
        this.viewer = viewer;
        this.createUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals("next")) {
            this.updateViewerLocation(this.timeseries.nextPoint());
            this.viewer.repaint();
        } else if (command.equals("prev")) {
            this.updateViewerLocation(this.timeseries.prevPoint());
            this.viewer.repaint();
        } else if (command.equals("keep")) {
            this.timeseries.keep();
        } else if (command.equals("clear")) {
            this.timeseries.clear();
        } else if (command.equals("show box")) {
            int selectedIndex = this.showBox.getSelectedIndex();
            if (selectedIndex == 0) {
                this.timeseries.setAsDataMode();
            } else if (selectedIndex == 1) {
                this.timeseries.setAsDerivativesMode();
            } else if (selectedIndex == 2) {
                this.timeseries.setAsCumulativesMode();
            }
        } else if (command.equals("stats box")) {
            int selectedIndex = this.statsBox.getSelectedIndex();
            this.timeseries.setDatatype(selectedIndex);
        } else if (ae.getActionCommand().equals("cameraButton")) {
            boolean isShiftDown = (ae.getModifiers() & 1) != 0;
            this.mango.doCapture(isShiftDown, this.timeseries);
        } else if (ae.getActionCommand().equals("export")) {
            this.export();
        } else if (command.equals("Indices")) {
            this.timeseries.setShowAsTime(false);
            this.timeseries.repaint();
        } else if (command.equals("Time")) {
            this.timeseries.setShowAsTime(true);
            this.timeseries.repaint();
        }
        this.updateButtons();
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public SliceViewer getViewer() {
        return this.viewer;
    }

    @Override
    public JFrame getWindow() {
        return this;
    }

    public void roiChanged(ROI aROI) {
        this.timeseries.updateROI(aROI);
    }

    public final void selectionChanged() {
        this.updateViewerLocation(this.timeseries.setROIs(this.viewer.getAllSelectedROIs()));
        this.updateButtons();
    }

    public void updateFocusState() {
    }

    private void createUI() {
        this.timeseries = this.viewer.getTimeseries();
        this.timeseries.setParentFrame(this);
        this.clearButton = new JButton("Clear Copies");
        this.clearButton.setActionCommand("clear");
        this.clearButton.addActionListener(this);
        this.clearButton.setPreferredSize(new Dimension(120, this.clearButton.getPreferredSize().height));
        this.previousButton = new JButton("Prev");
        this.previousButton.setActionCommand("prev");
        this.previousButton.addActionListener(this);
        this.nextButton = new JButton("Next ROI");
        this.nextButton.setActionCommand("next");
        this.nextButton.addActionListener(this);
        this.nextButton.setPreferredSize(new Dimension(120, this.clearButton.getPreferredSize().height));
        this.keepButton = new JButton("Store Copy");
        this.keepButton.setActionCommand("keep");
        this.keepButton.addActionListener(this);
        this.keepButton.setPreferredSize(new Dimension(120, this.clearButton.getPreferredSize().height));
        MangoSquareButton exportButton = new MangoSquareButton(MangoStyle.ICON_EXPORT, false, this.mango);
        exportButton.setActionCommand("export");
        exportButton.addActionListener(this);
        JPanel exportButtonPanel = new JPanel();
        exportButtonPanel.setLayout(new BoxLayout(exportButtonPanel, 0));
        exportButtonPanel.add(exportButton);
        JButton variableTimeButton = new JButton("Time File...");
        variableTimeButton.setActionCommand("time");
        variableTimeButton.addActionListener(this);
        JRadioButton indexButton = new JRadioButton("Indices");
        indexButton.addActionListener(this);
        indexButton.setActionCommand("Indices");
        JRadioButton timeButton = new JRadioButton("Time");
        timeButton.addActionListener(this);
        timeButton.setActionCommand("Time");
        ButtonGroup bg = new ButtonGroup();
        bg.add(indexButton);
        bg.add(timeButton);
        if (this.viewer.getToolBox().isWorldMode() && !this.viewer.getBaseScreenVolume().getVolume().isForceDisplayIndex() || this.viewer.getBaseScreenVolume().getVolume().isForceDisplayWorld()) {
            timeButton.setSelected(true);
        } else {
            indexButton.setSelected(true);
        }
        this.timeseries.setShowAsTime(timeButton.isSelected());
        this.statsBox = new JComboBox<String>(new String[]{"Mean", "Max", "Min", "SD", "Sum", "Volume"});
        this.statsBox.setActionCommand("stats box");
        this.statsBox.addActionListener(this);
        this.statsBox.setEditable(false);
        this.statsBox.setPrototypeDisplayValue("Volume");
        this.statsBox.setMaximumSize(this.statsBox.getPreferredSize());
        this.showBox = new JComboBox<String>(new String[]{"Data", "Rate", "Cumulative"});
        this.showBox.setActionCommand("show box");
        this.showBox.addActionListener(this);
        this.showBox.setEditable(false);
        this.showBox.setPrototypeDisplayValue("Cumulative");
        this.showBox.setMaximumSize(this.showBox.getPreferredSize());
        MangoSquareButton cameraButton = new MangoSquareButton(MangoStyle.ICON_CAMERA.get(0), false, this.mango);
        cameraButton.setActionCommand("cameraButton");
        cameraButton.addActionListener(this);
        cameraButton.setPressedIcon(MangoStyle.ICON_CAMERA.get(1));
        JPanel cameraPanel = new JPanel();
        cameraPanel.setLayout(new BoxLayout(cameraPanel, 0));
        cameraPanel.add(cameraButton);
        JPanel upperPanel = new JPanel();
        upperPanel.setLayout(new BoxLayout(upperPanel, 0));
        upperPanel.add(Box.createHorizontalGlue());
        upperPanel.add(this.nextButton);
        upperPanel.add(Box.createHorizontalGlue());
        upperPanel.add(this.keepButton);
        upperPanel.add(Box.createHorizontalGlue());
        upperPanel.add(this.clearButton);
        upperPanel.add(Box.createHorizontalGlue());
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new BoxLayout(lowerPanel, 0));
        lowerPanel.add(Box.createHorizontalGlue());
        lowerPanel.add(indexButton);
        lowerPanel.add(timeButton);
        lowerPanel.add(Box.createHorizontalGlue());
        lowerPanel.add(this.statsBox);
        lowerPanel.add(Box.createHorizontalGlue());
        lowerPanel.add(this.showBox);
        lowerPanel.add(Box.createHorizontalGlue());
        if (!this.mango.isApplet()) {
            lowerPanel.add(exportButtonPanel);
            lowerPanel.add(cameraPanel);
            lowerPanel.add(Box.createHorizontalGlue());
        }
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.add(Box.createVerticalStrut(4));
        optionsPanel.add(upperPanel);
        optionsPanel.add(lowerPanel);
        optionsPanel.add(Box.createVerticalStrut(4));
        optionsPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 75));
        SwingWidgetUtilities.colorBackgroundOfAllComponents((Container)optionsPanel, (Color)this.mango.getPanelOutsideColor(), (Class[])new Class[]{JTextField.class});
        cameraPanel.setBackground(Color.WHITE);
        exportButtonPanel.setBackground(Color.WHITE);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        mainPanel.add(this.timeseries);
        mainPanel.add(optionsPanel);
        JPanel mainPanelOut = new JPanel(new BorderLayout());
        mainPanelOut.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        mainPanelOut.add((Component)mainPanel, "Center");
        mainPanelOut.setBackground(this.mango.getPanelOutsideColor());
        this.setTitle("Series: " + this.viewer.getImageTitle());
        this.getContentPane().add((Component)mainPanelOut, "Center");
        this.setBackground(this.mango.getPanelOutsideColor());
        this.pack();
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent ce) {
                Dimension dim = TimeseriesTool.this.getSize();
                if (dim.width < 500 && dim.height >= 375) {
                    TimeseriesTool.this.setSize(500, dim.height);
                } else if (dim.width >= 500 && dim.height < 375) {
                    TimeseriesTool.this.setSize(dim.width, 375);
                } else if (dim.width < 500 && dim.height < 375) {
                    TimeseriesTool.this.setSize(500, 375);
                }
            }
        });
        this.setLocation(DisplayUtils.getNextWindowLocation(this.viewer.getViewerContainer(), new Dimension(500, 375), null, this.mango.isApplet()));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent we) {
                if (TimeseriesTool.this.isVisible()) {
                    TimeseriesTool.this.timeseries.setParentFrame(null);
                    TimeseriesTool.this.timeseries.clearCurrent();
                    TimeseriesTool.this.timeseries.updateHighlighting(true);
                    TimeseriesTool.this.viewer.repaint();
                }
            }

            @Override
            public void windowClosing(WindowEvent we) {
                if (TimeseriesTool.this.isVisible()) {
                    TimeseriesTool.this.timeseries.setParentFrame(null);
                    TimeseriesTool.this.timeseries.clearCurrent();
                    TimeseriesTool.this.timeseries.updateHighlighting(true);
                    TimeseriesTool.this.viewer.repaint();
                }
            }

            @Override
            public void windowOpened(WindowEvent we) {
            }
        });
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent we) {
                TimeseriesTool.this.timeseries.setIsPressedState(false);
                TimeseriesTool.this.viewer.repaint();
            }
        });
        this.viewer.associateWindow(this);
        this.selectionChanged();
        this.setIconImage(MangoStyle.ICON_APP.getImage());
        this.setVisible(true);
        this.validate();
        this.requestFocus();
        this.toFront();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export() {
        if (!this.timeseries.canKeep()) {
            return;
        }
        int stat = this.statsBox.getSelectedIndex();
        int showType = this.showBox.getSelectedIndex();
        File oldFile = this.viewer.getLoadedFile();
        String fileName = oldFile.getName();
        File selectedFile = null;
        File startFile = null;
        startFile = fileName.indexOf(46) != -1 ? new File(oldFile.getParent(), fileName.substring(0, fileName.indexOf(46)) + "_series.csv") : new File(oldFile.getParent(), fileName + "_series.csv");
        selectedFile = SaveFileDialog.showSaveFileChooser(this, this.viewer.getSaveDirectory(), startFile.getName());
        if (selectedFile != null) {
            try (PrintWriter writer = null;){
                writer = new PrintWriter(new BufferedWriter(new FileWriter(selectedFile)));
                ROI[] rois = this.timeseries.getROIs();
                int timepoints = this.viewer.getCurrentScreenVolume().getVolume().getImageDimensions().getTimepoints();
                double[][] data = new double[rois.length][timepoints];
                for (int ctrT = 0; ctrT < data.length; ++ctrT) {
                    double previous = 0.0;
                    for (int ctr = 0; ctr < timepoints; ++ctr) {
                        AnalysisImpl sh = (AnalysisImpl)rois[ctrT].getStats(ctr);
                        double value = 0.0;
                        if (stat == 0) {
                            value = sh.getMean();
                        } else if (stat == 1) {
                            value = sh.getMaxValue();
                        } else if (stat == 2) {
                            value = sh.getMinValue();
                        } else if (stat == 3) {
                            value = sh.getStandardDev();
                        } else if (stat == 4) {
                            value = sh.getSum();
                        }
                        if (showType == 0) {
                            data[ctrT][ctr] = value;
                            continue;
                        }
                        if (showType == 1) {
                            data[ctrT][ctr] = ctr == 0 ? 0.0 : value - previous;
                            previous = value;
                            continue;
                        }
                        if (showType != 2) continue;
                        data[ctrT][ctr] = ctr == 0 ? value : value + data[ctrT][ctr - 1];
                    }
                }
                String units = this.timeseries.getTrUnits();
                if (units == null) {
                    units = "s";
                }
                StringBuffer sbLabels = new StringBuffer(DESCRIPTION);
                for (int ctrT = 0; ctrT < data.length; ++ctrT) {
                    sbLabels.append(",\"" + rois[ctrT].getLabel(true) + "\"");
                }
                writer.println(sbLabels.toString());
                for (int ctr = 0; ctr < timepoints; ++ctr) {
                    String label = this.viewer.getCurrentVolume().getLabel(ctr, null);
                    if (StringUtils.isBlank((CharSequence)label)) {
                        label = this.timeseries.isShowAsTime() ? this.viewer.getCurrentScreenVolume().getVolume().getRealTimeOffset(ctr) + " " + units : String.valueOf(ctr + 1);
                    }
                    StringBuffer sb = new StringBuffer(label);
                    for (double[] element : data) {
                        sb.append(',');
                        sb.append(element[ctr]);
                    }
                    writer.println(sb.toString());
                }
            }
        }
    }

    private void updateButtons() {
        this.nextButton.setEnabled(this.timeseries.hasNextROI());
        this.previousButton.setEnabled(this.timeseries.hasPrevROI());
        this.keepButton.setEnabled(this.timeseries.canKeep());
        this.clearButton.setEnabled(this.timeseries.hasKeptValues());
    }

    private void updateViewerLocation(ROI roi) {
        if (roi != null) {
            ImageBounds ib = roi.getROIBounds(true);
            int sliceDirection = this.viewer.getMainSliceDirection();
            int sliceNum = this.viewer.getMainSliceNumber();
            if (ib.getMinX() == -1 && ib.getMaxX() == -1 && ib.getMinY() == -1 && ib.getMaxY() == -1) {
                this.viewer.setMainSliceDirection(0);
                this.viewer.setMainSliceNumber(ib.getMinZ());
            } else if (ib.getMinX() == -1 && ib.getMaxX() == -1 && ib.getMinZ() == -1 && ib.getMaxZ() == -1) {
                this.viewer.setMainSliceDirection(1);
                this.viewer.setMainSliceNumber(ib.getMinY());
            } else if (ib.getMinY() == -1 && ib.getMaxY() == -1 && ib.getMinZ() == -1 && ib.getMaxZ() == -1) {
                this.viewer.setMainSliceDirection(2);
                this.viewer.setMainSliceNumber(ib.getMinX());
            } else if (ib.getMinX() == ib.getMaxX() && ib.getMinY() == ib.getMaxY() && ib.getMinZ() == ib.getMaxZ()) {
                if (sliceDirection == 0) {
                    this.viewer.setMainSliceNumber(ib.getMinZ());
                } else if (sliceDirection == 1) {
                    this.viewer.setMainSliceNumber(ib.getMinY());
                } else {
                    this.viewer.setMainSliceNumber(ib.getMinX());
                }
            } else if (sliceDirection == 0) {
                if (sliceNum < ib.getMinZ() || sliceNum > ib.getMaxZ()) {
                    this.viewer.setMainSliceNumber(ib.getMinZ());
                }
            } else if (sliceDirection == 1) {
                if (sliceNum < ib.getMinY() || sliceNum > ib.getMaxY()) {
                    this.viewer.setMainSliceNumber(ib.getMinY());
                }
            } else if (sliceNum < ib.getMinX() || sliceNum > ib.getMaxX()) {
                this.viewer.setMainSliceNumber(ib.getMinX());
            }
        }
    }
}

