/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.series;

import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPane;
import edu.uthscsa.ric.mango.core.Capturable;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.dialogs.series.AxisPanel;
import edu.uthscsa.ric.mango.viewerslice.dialogs.series.TimeseriesTool;
import edu.uthscsa.ric.roi.ROI;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.apache.commons.lang3.StringUtils;

public class Timeseries
extends JComponent
implements MouseListener,
MouseMotionListener,
Capturable {
    private AnalysisImpl[] stats;
    private ROI currentROI;
    private ROI[] rois;
    private TimeseriesTool dialog;
    private Vector<ROI> allPoints;
    private boolean isCumulativesMode;
    private boolean isDataMode;
    private boolean isDerivativesMode;
    private boolean isPressed;
    private boolean manualAxisRange;
    private boolean mouseIsInside;
    private boolean updating;
    private boolean yAxisSelected;
    private boolean showAsTime;
    private double highest;
    private double lowest;
    private double mean;
    private double[] cumulatives;
    private double[] derivatives;
    private double[] values;
    private int currentIndex;
    private int datatype;
    private int longest;
    private int numPoints;
    private final Ellipse2D.Double marker = new Ellipse2D.Double();
    private final SliceViewer viewer;
    private final Vector<double[]> keepValues = new Vector();
    private static final Stroke STROKE_DASH = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
    private static final long serialVersionUID = 1L;
    public static final Color AXIS_COLOR_SELECTED_Y = new Color(200, 200, 200);
    public static final Color AXIS_COLOR_Y = new Color(200, 200, 200, 128);
    public static final Color DATA_COLOR = new Color(0, 0, 0, 175);
    public static final Font FONT = new Font("SansSerif", 1, 10);
    public static final Font FONT_LABEL = new Font("SansSerif", 0, 14);
    public static final Font FONT_LARGE = new Font("SansSerif", 0, 40);
    public static final Font FONT_MEDIUM = new Font("SansSerif", 1, 14);
    public static final Font FONT_MEDIUM2 = new Font("SansSerif", 0, 14);
    public static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(0);
    public static final MangoNumberFormatter FORMATTER_LARGE = new MangoNumberFormatter(1);
    public static final String UPDATING = "Updating...";
    public static final Stroke STROKE = new BasicStroke(2.0f);
    public static final Stroke STROKE_STORED = new BasicStroke(3.0f);
    public static final int INSETS_BOTTOM = 30;
    public static final int INSETS_LEFT = 60;
    public static final int INSETS_RIGHT = 25;
    public static final int INSETS_TOP = 15;
    public static final int TYPE_MAX = 1;
    public static final int TYPE_MEAN = 0;
    public static final int TYPE_MIN = 2;
    public static final int TYPE_SD = 3;
    public static final int TYPE_SUM = 4;
    public static final int TYPE_VOLUME = 5;

    public Timeseries(SliceViewer aViewer) {
        this.viewer = aViewer;
        this.currentIndex = -1;
        this.isDataMode = true;
        this.datatype = 0;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setMinimumSize(TimeseriesTool.CROSSSECTION_SIZE);
        this.setPreferredSize(TimeseriesTool.CROSSSECTION_SIZE);
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    @Override
    public BufferedImage captureImage() {
        BufferedImage bi = new BufferedImage(this.getSize().width, this.getSize().height, 2);
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        g2d.setClip(0, 0, this.getSize().width, this.getSize().height);
        this.doPaint(g2d, this.getSize().width, this.getSize().height);
        return bi;
    }

    public void clear() {
        this.keepValues.clear();
        this.updateHighestAndLongest();
        this.repaint();
    }

    @Override
    public File getCaptureDir() {
        return this.viewer.getLoadedFile().getParentFile();
    }

    @Override
    public String getCaptureName() {
        String name = this.viewer.getLoadedFile().getName();
        if (name.indexOf(46) != -1) {
            name = name.substring(0, name.indexOf(46));
        }
        name = name + "_series";
        return name;
    }

    public ROI getCurrentROI() {
        return this.currentROI;
    }

    public Vector<double[]> getKeepValues() {
        return this.keepValues;
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public JFrame getParentFrame() {
        return this.dialog;
    }

    public ROI[] getROIs() {
        return this.rois;
    }

    public String getTrUnits() {
        return this.viewer.getCurrentScreenVolume().getVolume().getTimeUnitString();
    }

    public double[] getValues() {
        double[] drawValues = null;
        if (this.isDataMode) {
            drawValues = this.values;
        } else if (this.isDerivativesMode) {
            drawValues = this.derivatives;
        } else if (this.isCumulativesMode) {
            drawValues = this.cumulatives;
        }
        return drawValues;
    }

    public Volume getVolume() {
        return this.viewer.getVolume();
    }

    public Coordinate getWorldOrigin() {
        return this.viewer.getOrigin();
    }

    public boolean isWorldMode() {
        return this.viewer.getToolBox().isWorldMode();
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        double[] drawValues = null;
        if (this.isDataMode) {
            drawValues = this.values;
        } else if (this.isDerivativesMode) {
            drawValues = this.derivatives;
        } else if (this.isCumulativesMode) {
            drawValues = this.cumulatives;
        }
        if (drawValues != null && drawValues.length > 0 && this.updateSelectedPoint(me.getPoint())) {
            if (this.currentIndex != -1) {
                this.viewer.setCurrentTimepoint(this.currentIndex, this.viewer.getCurrentVolume());
            }
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        double[] drawValues = null;
        this.mouseIsInside = true;
        if (this.isDataMode) {
            drawValues = this.values;
        } else if (this.isDerivativesMode) {
            drawValues = this.derivatives;
        } else if (this.isCumulativesMode) {
            drawValues = this.cumulatives;
        }
        if (drawValues != null && drawValues.length > 0) {
            this.updateSelectedPoint(me.getPoint());
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.currentIndex = -1;
        this.mouseIsInside = false;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        double[] drawValues = null;
        this.mouseIsInside = true;
        if (this.isDataMode) {
            drawValues = this.values;
        } else if (this.isDerivativesMode) {
            drawValues = this.derivatives;
        } else if (this.isCumulativesMode) {
            drawValues = this.cumulatives;
        }
        if (drawValues != null && drawValues.length > 0 && this.updateSelectedPoint(me.getPoint())) {
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        double[] drawValues = null;
        if (this.isDataMode) {
            drawValues = this.values;
        } else if (this.isDerivativesMode) {
            drawValues = this.derivatives;
        } else if (this.isCumulativesMode) {
            drawValues = this.cumulatives;
        }
        if (drawValues != null && drawValues.length > 0) {
            this.updateSelectedPoint(me.getPoint());
            this.isPressed = true;
            if (me.getClickCount() == 2) {
                this.yAxisSelected = true;
                this.repaint();
                Volume currentVolume = this.viewer.getCurrentVolume();
                AxisPanel dialogPanel = new AxisPanel(this.lowest, this.highest, this.manualAxisRange, currentVolume.getImageMin(), currentVolume.getImageMax());
                MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.dialog, (Object)dialogPanel, "Set Y-Axis", -1);
                int selection = jopf.show();
                if (selection == 0) {
                    this.manualAxisRange = dialogPanel.isGlobalAxisMode();
                    if (this.manualAxisRange) {
                        this.lowest = dialogPanel.getMin();
                        this.highest = dialogPanel.getMax();
                    } else {
                        this.updateHighestAndLongest();
                    }
                }
                this.mouseIsInside = false;
                this.yAxisSelected = false;
            } else if (this.currentIndex != -1) {
                this.viewer.setCurrentTimepoint(this.currentIndex, this.viewer.getCurrentVolume());
            }
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.isPressed = false;
        this.repaint();
        this.dialog.requestFocus();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        this.doPaint(g2d, this.getSize().width, this.getSize().height);
    }

    public void setCurrentIndex(int val) {
        this.currentIndex = val;
        this.repaint();
    }

    public void setIsPressedState(boolean bool) {
        if (this.currentROI != null) {
            this.isPressed = bool;
            if (this.isPressed) {
                if (this.currentIndex == -1) {
                    this.currentIndex = 0;
                }
                this.viewer.setCurrentTimepoint(this.currentIndex, this.viewer.getCurrentVolume());
            }
        }
        this.repaint();
    }

    public void setParentFrame(TimeseriesTool aFrame) {
        this.dialog = aFrame;
    }

    public void updateTimeseries() {
        if (this.currentROI != null) {
            int numTimepoints = this.viewer.getCurrentScreenVolume().getVolume().getNumTimepoints();
            this.stats = new AnalysisImpl[numTimepoints];
            this.allPoints = new Vector();
            this.allPoints.add(this.currentROI);
            for (int ctr = 0; ctr < numTimepoints; ++ctr) {
                this.stats[ctr] = (AnalysisImpl)this.currentROI.getStats(ctr);
            }
            this.updateStats();
        } else {
            this.clearCurrent();
            this.updateHighestAndLongest();
        }
        this.repaint();
        this.updating = false;
    }

    protected boolean canKeep() {
        return this.currentROI != null;
    }

    protected void clearCurrent() {
        this.currentROI = null;
        this.highest = 0.0;
        this.values = null;
        this.derivatives = null;
        this.cumulatives = null;
        this.stats = null;
    }

    protected void decrementSelectedPoint() {
        double[] drawValues = null;
        if (this.isDataMode) {
            drawValues = this.values;
        } else if (this.isDerivativesMode) {
            drawValues = this.derivatives;
        } else if (this.isCumulativesMode) {
            drawValues = this.cumulatives;
        }
        if (drawValues != null && drawValues.length > 0) {
            --this.currentIndex;
            if (this.currentIndex < 0 || this.currentIndex >= drawValues.length) {
                this.currentIndex = drawValues.length - 1;
            }
            if (this.currentIndex != -1) {
                this.viewer.setCurrentTimepoint(this.currentIndex, this.viewer.getCurrentVolume());
            }
            this.repaint();
        }
    }

    protected boolean hasKeptValues() {
        return this.keepValues.size() > 0;
    }

    protected boolean hasNextROI() {
        return this.rois != null && this.rois.length > 0;
    }

    protected boolean hasPrevROI() {
        int currentIndex = this.getCurrentIndex();
        return this.rois != null && this.rois.length > 0 && currentIndex > 0;
    }

    protected void incrementSelectedPoint() {
        double[] drawValues = null;
        if (this.isDataMode) {
            drawValues = this.values;
        } else if (this.isDerivativesMode) {
            drawValues = this.derivatives;
        } else if (this.isCumulativesMode) {
            drawValues = this.cumulatives;
        }
        if (drawValues != null && drawValues.length > 0) {
            ++this.currentIndex;
            if (this.currentIndex < 0 || this.currentIndex >= drawValues.length) {
                this.currentIndex = -1;
            }
            if (this.currentIndex != -1) {
                this.viewer.setCurrentTimepoint(this.currentIndex, this.viewer.getCurrentVolume());
            }
            this.repaint();
        }
    }

    protected void keep() {
        double[] drawValues = null;
        if (this.isDataMode) {
            drawValues = this.values;
        } else if (this.isDerivativesMode) {
            drawValues = this.derivatives;
        } else if (this.isCumulativesMode) {
            drawValues = this.cumulatives;
        }
        if (drawValues != null && drawValues.length > 0) {
            this.keepValues.add(drawValues);
        }
        this.repaint();
    }

    protected ROI nextPoint() {
        int currentIndex = this.getCurrentIndex();
        ++currentIndex;
        this.currentROI = this.rois[currentIndex %= this.rois.length];
        this.updateHighlighting(false);
        this.viewer.recordAction("runSeriesROI", new String[]{this.viewer.getScriptObjectName() + ".roiData.selectedROIs"}, true);
        this.updateTimeseries();
        return this.currentROI;
    }

    public void setCurrentROI(ROI roi) {
        int index = -1;
        if (this.rois != null) {
            for (int ctr = 0; ctr < this.rois.length; ++ctr) {
                if (this.rois[ctr] != roi) continue;
                index = ctr;
                break;
            }
            if (index != -1) {
                this.currentIndex = index;
                this.currentROI = roi;
                this.updateHighlighting(false);
                this.updateTimeseries();
            }
        }
    }

    protected ROI prevPoint() {
        int currentIndex = this.getCurrentIndex();
        this.currentROI = this.rois[currentIndex - 1];
        this.updateHighlighting(false);
        this.viewer.recordAction("runSeriesROI", new String[]{this.viewer.getScriptObjectName() + ".roiData.selectedROIs"}, true);
        this.updateTimeseries();
        return this.currentROI;
    }

    protected void setAsCumulativesMode() {
        this.isDataMode = false;
        this.isDerivativesMode = false;
        this.isCumulativesMode = true;
        this.clear();
        this.updateTimeseries();
    }

    protected void setAsDataMode() {
        this.isDataMode = true;
        this.isDerivativesMode = false;
        this.isCumulativesMode = false;
        this.clear();
        this.updateTimeseries();
    }

    protected void setAsDerivativesMode() {
        this.isDataMode = false;
        this.isDerivativesMode = true;
        this.isCumulativesMode = false;
        this.clear();
        this.updateTimeseries();
    }

    protected void setDatatype(int datatype) {
        this.datatype = datatype;
        if (this.currentROI != null) {
            this.clear();
            this.updateStats();
            this.repaint();
        }
    }

    protected ROI setROIs(List<ROI> someROIs) {
        this.updateHighlighting(true);
        this.rois = someROIs.toArray(new ROI[someROIs.size()]);
        ROI oldCurrentROI = this.currentROI;
        if (this.rois != null && this.rois.length > 0) {
            if (oldCurrentROI != null) {
                int currentPointIndex = 0;
                for (int ctr = 0; ctr < this.rois.length; ++ctr) {
                    if (!this.rois[ctr].getLabel(true).equals(oldCurrentROI.getLabel(true))) continue;
                    currentPointIndex = ctr;
                }
                this.currentROI = this.rois[currentPointIndex];
            } else {
                this.currentROI = this.rois[0];
            }
        } else {
            this.currentROI = null;
        }
        this.updateHighlighting(false);
        if (oldCurrentROI != this.currentROI) {
            this.viewer.recordAction("runSeriesROI", new String[]{this.viewer.getScriptObjectName() + ".roiData.selectedROIs"}, true);
            this.updateTimeseries();
        }
        return this.currentROI;
    }

    protected void updateHighlighting(boolean clearOnly) {
        if (this.rois != null) {
            for (ROI roi : this.rois) {
                roi.setHighlighted(false);
            }
            if (!clearOnly && this.currentROI != null) {
                this.currentROI.setHighlighted(true);
            }
        }
    }

    protected void updateROI(ROI aROI) {
        if (this.currentROI == aROI) {
            this.updateTimeseries();
        }
    }

    private void doPaint(Graphics2D g2d, int sizeWidth, int sizeHeight) {
        int width = sizeWidth - 85;
        int height = sizeHeight - 45;
        int keepIndex = 0;
        Stroke oldStroke = g2d.getStroke();
        g2d.setFont(FONT);
        g2d.setColor(Color.GRAY);
        g2d.fill(g2d.getClip());
        g2d.setColor(Color.WHITE);
        g2d.drawLine(60, height + 15, width + 60, height + 15);
        g2d.drawLine(60, 15, 60, height + 15);
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.setStroke(STROKE);
        if (this.currentIndex != -1) {
            g2d.drawLine((int)(60.0 + (double)width * ((double)this.viewer.getCurrentScreenVolume().getVolume().getCurrentTimepoint() / ((double)this.longest - 1.0))), 15, (int)(60.0 + (double)width * ((double)this.viewer.getCurrentScreenVolume().getVolume().getCurrentTimepoint() / ((double)this.longest - 1.0))), height + 15);
        }
        g2d.setStroke(oldStroke);
        g2d.setColor(Color.WHITE);
        double[] drawValues = null;
        if (this.isDataMode) {
            drawValues = this.values;
        } else if (this.isDerivativesMode) {
            drawValues = this.derivatives;
        } else if (this.isCumulativesMode) {
            drawValues = this.cumulatives;
        }
        if (drawValues != null && drawValues.length > 0 || this.keepValues.size() > 0) {
            TextLayout textLayout;
            int ctr;
            for (ctr = 0; ctr < 5; ++ctr) {
                double temp = ((double)this.longest * (this.showAsTime ? this.viewer.getVolume().getTimeframe() : 1.0) - 1.0) * (0.25 * (double)ctr) + (double)(!this.showAsTime ? 1 : 0);
                String string = FORMATTER.format(temp);
                TextLayout textLayout2 = new TextLayout(string, FONT, g2d.getFontRenderContext());
                int textLayoutWidth = (int)textLayout2.getBounds().getWidth();
                int startX = (int)((double)width * (0.25 * (double)ctr)) + 60;
                g2d.drawLine(startX, height + 15, startX, height + 15 + 2);
                g2d.drawString(string, startX - textLayoutWidth / 2, height + 30);
            }
            for (ctr = 0; ctr < 5; ++ctr) {
                String string = FORMATTER_LARGE.format((this.highest - this.lowest) * (0.25 * (double)(4 - ctr)) + this.lowest);
                textLayout = new TextLayout(string, FONT, g2d.getFontRenderContext());
                int textLayoutWidth = (int)textLayout.getBounds().getWidth();
                int startY = (int)((double)height * (0.25 * (double)ctr)) + 15 + 5;
                g2d.drawLine(58, startY - 5, 60, startY - 5);
                g2d.drawString(string, 30 - textLayoutWidth / 2, startY);
            }
            g2d.setStroke(STROKE_STORED);
            g2d.setColor(Color.DARK_GRAY);
            Enumeration<double[]> en = this.keepValues.elements();
            while (en.hasMoreElements()) {
                double[] someValues = en.nextElement();
                if (someValues == drawValues) continue;
                g2d.setColor(ROIColor.getTransparentColor(keepIndex++));
                g2d.draw(this.getLineGraph(someValues));
                keepIndex %= 64;
            }
            g2d.setStroke(STROKE);
            if (this.updating) {
                g2d.setFont(FONT_MEDIUM);
                TextLayout textLayout3 = new TextLayout(UPDATING, FONT_MEDIUM, g2d.getFontRenderContext());
                int textLayoutWidth = (int)textLayout3.getBounds().getWidth();
                int textLayoutHeight = (int)textLayout3.getBounds().getHeight();
                g2d.drawString(UPDATING, width / 2 - textLayoutWidth / 2 + 60, height / 2 - textLayoutHeight / 2);
            } else {
                if (drawValues != null && drawValues.length > 0) {
                    g2d.setColor(Color.WHITE);
                    g2d.draw(this.getLineGraph(drawValues));
                    if (this.currentIndex != -1) {
                        g2d.setColor(DATA_COLOR);
                        this.marker.setFrame((int)(60.0 + (double)width * ((double)this.currentIndex / ((double)this.longest - 1.0))) - 2, (int)((double)(height + 15) - (double)height * ((drawValues[this.currentIndex] - this.lowest) / (this.highest - this.lowest))) - 2, 5.0, 5.0);
                        g2d.draw(this.marker);
                        g2d.setFont(FONT_LARGE);
                        String valueText = FORMATTER_LARGE.format(drawValues[this.currentIndex]);
                        textLayout = new TextLayout(valueText, FONT_LARGE, g2d.getFontRenderContext());
                        int textLayoutWidth = (int)textLayout.getBounds().getWidth();
                        int textLayoutHeight = (int)textLayout.getBounds().getHeight();
                        g2d.drawString(valueText, width / 2 - textLayoutWidth / 2 + 60, height / 2 + textLayoutHeight / 2);
                        g2d.setFont(FONT_MEDIUM);
                        String pointText = this.viewer.getCurrentVolume().getLabel(this.currentIndex, null);
                        if (StringUtils.isBlank((CharSequence)pointText)) {
                            pointText = this.showAsTime ? "(Time = " + FORMATTER.format(this.viewer.getCurrentScreenVolume().getVolume().getRealTimeOffset(this.currentIndex)) + this.viewer.getCurrentScreenVolume().getVolume().getTimeUnitString() + ")" : "(Index = " + (this.currentIndex + 1) + ")";
                        }
                        textLayout = new TextLayout(pointText, FONT_MEDIUM, g2d.getFontRenderContext());
                        textLayoutWidth = (int)textLayout.getBounds().getWidth();
                        int textLayoutHeight2 = (int)textLayout.getBounds().getHeight();
                        int stringLoc = height / 2 + textLayoutHeight / 2 + textLayoutHeight2 / 2 + 10;
                        g2d.drawString(pointText, width / 2 - textLayoutWidth / 2 + 60, stringLoc);
                        String label = this.currentROI.getLabel(true);
                        if (StringUtils.isNotBlank((CharSequence)label)) {
                            g2d.setFont(FONT_LABEL);
                            int labelTextWidth = (int)new TextLayout(label, FONT_LABEL, g2d.getFontRenderContext()).getBounds().getWidth();
                            int labelTextHeight = (int)new TextLayout(label, FONT_LABEL, g2d.getFontRenderContext()).getBounds().getHeight();
                            g2d.setColor(ROIColor.getColor(this.currentROI.getColor()));
                            g2d.drawString(label, width / 2 - labelTextWidth / 2 + 60, stringLoc + (int)((double)labelTextHeight * 1.5));
                        }
                    } else if (this.mouseIsInside) {
                        g2d.setStroke(STROKE_DASH);
                        if (this.yAxisSelected) {
                            g2d.setColor(AXIS_COLOR_SELECTED_Y);
                        } else {
                            g2d.setColor(AXIS_COLOR_Y);
                        }
                        g2d.drawRect(4, 4, 52, height + 30 - 8);
                    }
                }
                if (this.isDataMode && this.currentIndex != -1) {
                    g2d.setFont(FONT);
                    g2d.setStroke(oldStroke);
                    String meanString = FORMATTER_LARGE.format(this.mean);
                    int startY = (int)((this.highest - this.mean) / (this.highest - this.lowest) * (double)height + 15.0 + 5.0);
                    g2d.setColor(Color.BLACK);
                    g2d.drawLine(58, startY - 5, 60, startY - 5);
                    g2d.drawString(meanString, 64, startY);
                }
            }
        } else {
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.setFont(FONT_MEDIUM2);
            String valueText = "Select a point, line, or mask to begin.";
            TextLayout textLayout = new TextLayout("Select a point, line, or mask to begin.", FONT_MEDIUM, g2d.getFontRenderContext());
            int textLayoutWidth = (int)textLayout.getBounds().getWidth();
            int textLayoutHeight = (int)textLayout.getBounds().getHeight();
            g2d.drawString("Select a point, line, or mask to begin.", width / 2 - textLayoutWidth / 2 + 60, height / 2 + textLayoutHeight / 2 + 10);
        }
    }

    private int getCurrentIndex() {
        int currentIndex = 0;
        if (this.currentROI != null) {
            for (int ctr = 0; ctr < this.rois.length; ++ctr) {
                if (this.currentROI != this.rois[ctr]) continue;
                currentIndex = ctr;
            }
        }
        return currentIndex;
    }

    private Shape getLineGraph(double[] someValues) {
        GeneralPath path = null;
        int width = (int)(this.getSize().getWidth() - 85.0);
        int height = (int)(this.getSize().getHeight() - 45.0);
        if (someValues != null && someValues.length > 0) {
            path = new GeneralPath();
            path.moveTo(60.0f, (int)((double)(height + 15) - (double)height * ((someValues[0] - this.lowest) / (this.highest - this.lowest))));
            for (int ctr = 1; ctr < someValues.length; ++ctr) {
                path.lineTo((int)(60.0 + (double)width * ((double)ctr / ((double)this.longest - 1.0))), (int)((double)(height + 15) - (double)height * ((someValues[ctr] - this.lowest) / (this.highest - this.lowest))));
            }
        }
        return path;
    }

    private void updateHighestAndLongest() {
        if (this.manualAxisRange) {
            return;
        }
        this.lowest = Double.MAX_VALUE;
        this.highest = Double.MIN_VALUE;
        this.longest = 0;
        double[] drawValues = null;
        if (this.isDataMode) {
            drawValues = this.values;
        } else if (this.isDerivativesMode) {
            drawValues = this.derivatives;
        } else if (this.isCumulativesMode) {
            drawValues = this.cumulatives;
        }
        if (drawValues != null && drawValues.length > 0) {
            for (double drawValue : drawValues) {
                if (drawValue > this.highest) {
                    this.highest = drawValue;
                }
                if (!(drawValue < this.lowest)) continue;
                this.lowest = drawValue;
            }
            this.longest = drawValues.length;
        }
        if (this.keepValues.size() > 0) {
            Enumeration<double[]> en = this.keepValues.elements();
            while (en.hasMoreElements()) {
                double[] someValues = en.nextElement();
                if (someValues == this.values) continue;
                if (this.longest < someValues.length) {
                    this.longest = someValues.length;
                }
                for (double someValue : someValues) {
                    if (someValue > this.highest) {
                        this.highest = someValue;
                    }
                    if (!(someValue < this.lowest)) continue;
                    this.lowest = someValue;
                }
            }
        }
    }

    private boolean updateSelectedPoint(Point aPoint) {
        double[] drawValues = null;
        if (this.isDataMode) {
            drawValues = this.values;
        } else if (this.isDerivativesMode) {
            drawValues = this.derivatives;
        } else if (this.isCumulativesMode) {
            drawValues = this.cumulatives;
        }
        int oldCurrentIndex = this.currentIndex;
        int width = (int)(this.getSize().getWidth() - 85.0);
        if (((double)aPoint.x - 60.0) / (double)width * ((double)this.longest - 1.0) < 0.0) {
            this.currentIndex = -1;
        } else {
            this.currentIndex = (int)(((double)aPoint.x - 60.0) / (double)width * ((double)this.longest - 1.0) + 0.5);
            if (drawValues != null && drawValues.length > 0 && (this.currentIndex < 0 || this.currentIndex >= drawValues.length)) {
                this.currentIndex = -1;
            }
        }
        return oldCurrentIndex != this.currentIndex;
    }

    private void updateStats() {
        this.mean = 0.0;
        int numTimepoints = this.viewer.getCurrentScreenVolume().getVolume().getNumTimepoints();
        this.values = new double[numTimepoints];
        this.derivatives = new double[numTimepoints];
        this.cumulatives = new double[numTimepoints];
        for (int ctr = 0; ctr < numTimepoints; ++ctr) {
            double value = 0.0;
            if (this.datatype == 0) {
                value = this.stats[ctr].getMean();
            } else if (this.datatype == 2) {
                value = this.stats[ctr].getMinValue();
            } else if (this.datatype == 1) {
                value = this.stats[ctr].getMaxValue();
            } else if (this.datatype == 4) {
                value = this.stats[ctr].getSum();
            } else if (this.datatype == 3) {
                value = this.stats[ctr].getStandardDev();
            } else if (this.datatype == 5) {
                value = this.stats[ctr].getCount();
            }
            this.values[ctr] = value;
            this.mean += this.values[ctr];
            if (ctr == 0) {
                this.derivatives[0] = 0.0;
            } else {
                this.derivatives[ctr] = this.values[ctr] - this.values[ctr - 1];
            }
            if (ctr == 0) {
                this.cumulatives[0] = this.values[0];
                continue;
            }
            this.cumulatives[ctr] = this.values[ctr] + this.cumulatives[ctr - 1];
        }
        if (this.values != null && this.values.length > 0) {
            this.mean /= (double)this.values.length;
        }
        this.updateHighestAndLongest();
    }

    @Override
    public String getCaptureType() {
        return "series";
    }

    @Override
    public void recordAction(String name, String[] argValues, boolean forceNeedsUserInput) {
    }

    public boolean isShowAsTime() {
        return this.showAsTime;
    }

    public void setShowAsTime(boolean showAsTime) {
        this.showAsTime = showAsTime;
    }
}

