/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.series;

import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.utilities.AppLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class AxisPanel
extends JPanel
implements ActionListener {
    private JLabel minLabel;
    private JLabel maxLabel;
    private JTextField maxText;
    private JTextField minText;
    private final boolean globalAxisMode;
    private JRadioButton globalRadioButton;
    private final double highest;
    private final double lowest;
    private final double imageMin;
    private final double imageMax;
    public static final String ACTION_GLOBAL = "ACTION_GLOBAL";
    private static final long serialVersionUID = 1L;
    public static final int PADDING = 4;
    public static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(0);

    public AxisPanel(double lowest, double highest, boolean globalAxisMode, double imageMin, double imageMax) {
        this.lowest = lowest;
        this.highest = highest;
        this.globalAxisMode = globalAxisMode;
        this.imageMin = imageMin;
        this.imageMax = imageMax;
        this.createUI();
    }

    public double getMax() {
        double value = this.highest;
        try {
            value = Double.parseDouble(this.maxText.getText());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        return value;
    }

    public double getMin() {
        double value = this.lowest;
        try {
            value = Double.parseDouble(this.minText.getText());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        return value;
    }

    public boolean isGlobalAxisMode() {
        return this.globalRadioButton.isSelected();
    }

    private void createUI() {
        this.globalRadioButton = new JRadioButton("Use Global Range");
        this.globalRadioButton.addActionListener(this);
        this.globalRadioButton.setActionCommand(ACTION_GLOBAL);
        JRadioButton dynamicRadioButton = new JRadioButton("Use Dynamic Range");
        dynamicRadioButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.globalRadioButton);
        buttonGroup.add(dynamicRadioButton);
        if (this.globalAxisMode) {
            this.globalRadioButton.setSelected(true);
        } else {
            dynamicRadioButton.setSelected(true);
        }
        JPanel optionPanel = new JPanel();
        optionPanel.setLayout(new BoxLayout(optionPanel, 0));
        optionPanel.add(dynamicRadioButton);
        optionPanel.add(this.globalRadioButton);
        this.minLabel = new JLabel("Min ");
        this.minText = new MangoTextField(FORMATTER.format(this.lowest), 3);
        this.maxLabel = new JLabel("Max ");
        this.maxText = new MangoTextField(FORMATTER.format(this.highest), 3);
        JPanel globalPanel = new JPanel();
        globalPanel.setLayout(new BoxLayout(globalPanel, 0));
        globalPanel.add(this.minLabel);
        globalPanel.add(this.minText);
        globalPanel.add(Box.createHorizontalStrut(8));
        globalPanel.add(this.maxLabel);
        globalPanel.add(this.maxText);
        this.setLayout(new BoxLayout(this, 1));
        this.add(optionPanel);
        this.add(Box.createVerticalStrut(4));
        this.add(globalPanel);
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        boolean globalSelected = this.globalRadioButton.isSelected();
        this.minLabel.setEnabled(globalSelected);
        this.minText.setEnabled(globalSelected);
        this.maxLabel.setEnabled(globalSelected);
        this.maxText.setEnabled(globalSelected);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals(ACTION_GLOBAL)) {
            this.minText.setText(FORMATTER.format(this.imageMin));
            this.maxText.setText(FORMATTER.format(this.imageMax));
        }
        this.updateEnabledState();
    }
}

