/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.roiinspector;

import edu.uthscsa.ric.mango.components.MangoColorIconPanel;
import edu.uthscsa.ric.mango.components.MangoColorSelectedListener;
import edu.uthscsa.ric.roi.ColorManager;
import edu.uthscsa.ric.roi.ROIColor;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ROIInspectorPanel
extends JPanel {
    private JLabel countLabel;
    private MangoColorIconPanel colorPanel;
    private String colorName;
    private final ColorManager manager;
    private final MangoColorSelectedListener listener;
    private final ROIColor color;
    private static final long serialVersionUID = 1L;
    public static final int SIZE = 25;

    protected ROIInspectorPanel(ColorManager manager, MangoColorSelectedListener listener, ROIColor color, String colorName) {
        this.manager = manager;
        this.listener = listener;
        this.color = color;
        this.colorName = colorName;
        this.createUI();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.color.getColor());
        g.fillRect(0, 0, 25, 25);
    }

    public void setCount(int count) {
        this.countLabel.setText(String.valueOf(count));
    }

    public void setLabel(String colorName) {
        this.colorName = colorName;
        this.colorPanel.setColorName(colorName);
    }

    private void createUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.colorPanel = new MangoColorIconPanel(this.manager, this.listener, this.color, this.colorName, false);
        this.colorPanel.setUseButtonBorder(true);
        this.add(this.colorPanel);
        this.add(Box.createHorizontalStrut(2));
        this.countLabel = new JLabel("");
        this.add(this.countLabel);
        this.setPreferredSize(new Dimension(50, 25));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
    }
}

