/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.modal;

import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.volume.Volume;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class TimeseriesStatsDialog
extends JPanel {
    private JRadioButton maxB;
    private JRadioButton meanB;
    private JRadioButton minB;
    private JRadioButton stdevB;
    private JRadioButton sumB;
    private JTextField endT;
    private JTextField groupT;
    private JTextField startT;
    private final Volume volume;
    private static final long serialVersionUID = 1L;

    public TimeseriesStatsDialog(Volume volume) {
        this.volume = volume;
        this.createUI();
    }

    public String getEnd() {
        return this.endT.getText();
    }

    public String getGroup() {
        return this.groupT.getText();
    }

    public String getStart() {
        return this.startT.getText();
    }

    public boolean isMax() {
        return this.maxB.isSelected();
    }

    public boolean isMean() {
        return this.meanB.isSelected();
    }

    public boolean isMin() {
        return this.minB.isSelected();
    }

    public boolean isStdev() {
        return this.stdevB.isSelected();
    }

    public boolean isSum() {
        return this.sumB.isSelected();
    }

    private void createUI() {
        this.sumB = new JRadioButton("Sum");
        this.sumB.setFocusable(false);
        this.meanB = new JRadioButton("Mean");
        this.meanB.setFocusable(false);
        this.maxB = new JRadioButton("Max");
        this.maxB.setFocusable(false);
        this.minB = new JRadioButton("Min");
        this.minB.setFocusable(false);
        this.stdevB = new JRadioButton("SD");
        this.stdevB.setFocusable(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.sumB);
        group.add(this.meanB);
        group.add(this.maxB);
        group.add(this.minB);
        group.add(this.stdevB);
        this.meanB.setSelected(true);
        JLabel startLabel = new JLabel("Start");
        this.startT = new MangoTextField(String.valueOf(1), 4);
        JPanel startPanel = new JPanel();
        startPanel.add(startLabel);
        startPanel.add(this.startT);
        JLabel endLabel = new JLabel("End");
        this.endT = new MangoTextField(String.valueOf(this.volume.getNumTimepoints()), 4);
        JPanel endPanel = new JPanel();
        endPanel.add(endLabel);
        endPanel.add(this.endT);
        endPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        JLabel groupLabel = new JLabel("Group");
        this.groupT = new MangoTextField(String.valueOf(this.volume.getNumTimepoints()), 4);
        JPanel groupPanel = new JPanel();
        groupPanel.add(groupLabel);
        groupPanel.add(this.groupT);
        groupPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        JPanel rangePanel = new JPanel();
        rangePanel.add(startPanel);
        rangePanel.add(endPanel);
        rangePanel.add(groupPanel);
        JPanel optionsPanel = new JPanel();
        optionsPanel.add(this.meanB);
        optionsPanel.add(this.maxB);
        optionsPanel.add(this.minB);
        optionsPanel.add(this.stdevB);
        optionsPanel.add(this.sumB);
        this.setLayout(new BoxLayout(this, 1));
        this.add(rangePanel);
        this.add(optionsPanel);
    }
}

