/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.modal;

import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.utilities.AppLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TimepointSelectionDialog
extends JPanel
implements ActionListener {
    private final JLabel displayLabel;
    private final JLabel toLabel;
    private final JRadioButton allBox;
    private final JRadioButton anyBox;
    private final JRadioButton displayIndex;
    private final JRadioButton displayWorld;
    private final JRadioButton firstBox;
    private final JRadioButton lastBox;
    private final JRadioButton middleBox;
    private final JRadioButton rangeBox;
    private final MangoTextField anyText;
    private final MangoTextField rangeMaxText;
    private final MangoTextField rangeMinText;
    private final int numTimepoints;
    private static final long serialVersionUID = 1L;

    public TimepointSelectionDialog(int numTimepoints) {
        this.numTimepoints = numTimepoints;
        this.firstBox = new JRadioButton("First");
        this.firstBox.addActionListener(this);
        this.middleBox = new JRadioButton("Middle");
        this.middleBox.addActionListener(this);
        this.lastBox = new JRadioButton("Last");
        this.lastBox.addActionListener(this);
        this.anyBox = new JRadioButton("");
        this.firstBox.addActionListener(this);
        this.middleBox.addActionListener(this);
        this.lastBox.addActionListener(this);
        this.anyBox.addActionListener(this);
        this.anyText = new MangoTextField("1", 4);
        this.anyText.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                TimepointSelectionDialog.this.anyBox.setSelected(true);
                TimepointSelectionDialog.this.updateEnabledState();
            }
        });
        this.anyText.setMinimumSize(this.anyText.getPreferredSize());
        this.anyText.setMaximumSize(this.anyText.getPreferredSize());
        this.anyText.setEnabled(false);
        JPanel singlePointPanel = new JPanel();
        singlePointPanel.setLayout(new BoxLayout(singlePointPanel, 0));
        singlePointPanel.add(this.firstBox);
        singlePointPanel.add(this.middleBox);
        singlePointPanel.add(this.lastBox);
        singlePointPanel.add(this.anyBox);
        singlePointPanel.add(this.anyText);
        this.allBox = new JRadioButton("All");
        this.rangeBox = new JRadioButton("Range");
        this.allBox.addActionListener(this);
        this.rangeBox.addActionListener(this);
        this.rangeMinText = new MangoTextField("1", 4);
        this.rangeMinText.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                TimepointSelectionDialog.this.rangeBox.setSelected(true);
                TimepointSelectionDialog.this.updateEnabledState();
            }
        });
        this.rangeMinText.setMinimumSize(this.rangeMinText.getPreferredSize());
        this.rangeMinText.setMaximumSize(this.rangeMinText.getPreferredSize());
        this.rangeMinText.setEnabled(false);
        this.rangeMaxText = new MangoTextField(String.valueOf(numTimepoints), 4);
        this.rangeMaxText.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                TimepointSelectionDialog.this.rangeBox.setSelected(true);
                TimepointSelectionDialog.this.updateEnabledState();
            }
        });
        this.rangeMaxText.setMinimumSize(this.rangeMaxText.getPreferredSize());
        this.rangeMaxText.setMaximumSize(this.rangeMaxText.getPreferredSize());
        this.rangeMaxText.setEnabled(false);
        this.toLabel = new JLabel("to");
        this.toLabel.setEnabled(false);
        JPanel multiplePointPanel = new JPanel();
        multiplePointPanel.setLayout(new BoxLayout(multiplePointPanel, 0));
        multiplePointPanel.add(this.allBox);
        multiplePointPanel.add(this.rangeBox);
        multiplePointPanel.add(this.rangeMinText);
        multiplePointPanel.add(Box.createHorizontalStrut(4));
        multiplePointPanel.add(this.toLabel);
        multiplePointPanel.add(Box.createHorizontalStrut(4));
        multiplePointPanel.add(this.rangeMaxText);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.firstBox);
        bg.add(this.middleBox);
        bg.add(this.lastBox);
        bg.add(this.anyBox);
        bg.add(this.allBox);
        bg.add(this.rangeBox);
        this.firstBox.setSelected(true);
        JLabel singleLabel = new JLabel("Load a Single Volume");
        JPanel singleLabelPanel = new JPanel();
        singleLabelPanel.setLayout(new BoxLayout(singleLabelPanel, 0));
        singleLabelPanel.add(Box.createHorizontalGlue());
        singleLabelPanel.add(singleLabel);
        singleLabelPanel.add(Box.createHorizontalGlue());
        JLabel multipleLabel = new JLabel("Load Multiple Volumes");
        JPanel multipleLabelPanel = new JPanel();
        multipleLabelPanel.setLayout(new BoxLayout(multipleLabelPanel, 0));
        multipleLabelPanel.add(Box.createHorizontalGlue());
        multipleLabelPanel.add(multipleLabel);
        multipleLabelPanel.add(Box.createHorizontalGlue());
        this.displayIndex = new JRadioButton("As Index");
        this.displayWorld = new JRadioButton("As Time");
        JPanel displayPanel1 = new JPanel();
        displayPanel1.setLayout(new BoxLayout(displayPanel1, 0));
        displayPanel1.add(this.displayIndex);
        displayPanel1.add(this.displayWorld);
        ButtonGroup displayGroup = new ButtonGroup();
        displayGroup.add(this.displayIndex);
        displayGroup.add(this.displayWorld);
        this.displayIndex.setSelected(true);
        this.displayLabel = new JLabel("Display Volume Position");
        JPanel displayLabelPanel = new JPanel();
        displayLabelPanel.setLayout(new BoxLayout(displayLabelPanel, 0));
        displayLabelPanel.add(Box.createHorizontalGlue());
        displayLabelPanel.add(this.displayLabel);
        displayLabelPanel.add(Box.createHorizontalGlue());
        JPanel displayPanel = new JPanel();
        displayPanel.setLayout(new BoxLayout(displayPanel, 1));
        displayPanel.add(displayLabelPanel);
        displayPanel.add(Box.createVerticalStrut(2));
        displayPanel.add(displayPanel1);
        singleLabel.setFont(singleLabel.getFont().deriveFont(1));
        multipleLabel.setFont(multipleLabel.getFont().deriveFont(1));
        this.displayLabel.setFont(multipleLabel.getFont().deriveFont(1));
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalStrut(8));
        this.add(singleLabelPanel);
        this.add(singlePointPanel);
        this.add(Box.createVerticalStrut(20));
        this.add(multipleLabelPanel);
        this.add(multiplePointPanel);
        this.add(Box.createVerticalStrut(30));
        this.add(displayPanel);
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals("First")) {
            this.anyText.setText("1");
        } else if (command.equals("Middle")) {
            this.anyText.setText(String.valueOf(this.numTimepoints / 2 + 1));
        } else if (command.equals("Last")) {
            this.anyText.setText(String.valueOf(this.numTimepoints));
        }
        this.updateEnabledState();
    }

    public int getSingleTimepoint() {
        if (this.firstBox.isSelected()) {
            return 0;
        }
        if (this.middleBox.isSelected()) {
            return this.numTimepoints / 2;
        }
        if (this.lastBox.isSelected()) {
            return this.numTimepoints - 1;
        }
        if (this.anyBox.isSelected()) {
            int val = 0;
            try {
                val = (int)Double.parseDouble(this.anyText.getText().trim()) - 1;
            }
            catch (Exception ex) {
                AppLogger.info((Throwable)ex);
            }
            if (val < 0) {
                val = 0;
            } else if (val >= this.numTimepoints) {
                val = this.numTimepoints - 1;
            }
            return val;
        }
        return -1;
    }

    public int getTimepointMax() {
        int maxVal = this.numTimepoints - 1;
        if (this.rangeBox.isSelected()) {
            try {
                maxVal = (int)Double.parseDouble(this.rangeMaxText.getText().trim()) - 1;
            }
            catch (Exception ex) {
                AppLogger.info((Throwable)ex);
            }
            if (maxVal < 0) {
                maxVal = 0;
            } else if (maxVal >= this.numTimepoints) {
                maxVal = this.numTimepoints - 1;
            }
        }
        return maxVal;
    }

    public int getTimepointMin() {
        int minVal = 0;
        if (this.rangeBox.isSelected()) {
            try {
                minVal = (int)Double.parseDouble(this.rangeMinText.getText().trim()) - 1;
            }
            catch (Exception ex) {
                AppLogger.info((Throwable)ex);
            }
            if (minVal < 0) {
                minVal = 0;
            } else if (minVal >= this.numTimepoints) {
                minVal = this.numTimepoints - 1;
            }
        }
        return minVal;
    }

    public boolean isForceDisplayIndex() {
        return this.displayIndex.isSelected();
    }

    public boolean isForceDisplayWorld() {
        return this.displayWorld.isSelected();
    }

    public boolean isMultipleSelection() {
        return this.allBox.isSelected() || this.rangeBox.isSelected();
    }

    public boolean isSingleSelection() {
        return this.firstBox.isSelected() || this.middleBox.isSelected() || this.lastBox.isSelected() || this.anyBox.isSelected();
    }

    private void updateEnabledState() {
        this.anyText.setEnabled(this.anyBox.isSelected());
        this.rangeMinText.setEnabled(this.rangeBox.isSelected());
        this.rangeMaxText.setEnabled(this.rangeBox.isSelected());
        this.toLabel.setEnabled(this.rangeBox.isSelected());
        this.displayIndex.setEnabled(this.allBox.isSelected() || this.rangeBox.isSelected());
        this.displayWorld.setEnabled(this.allBox.isSelected() || this.rangeBox.isSelected());
        this.displayLabel.setEnabled(this.allBox.isSelected() || this.rangeBox.isSelected());
    }
}

