/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.modal;

import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPaneItem;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.operations.OperationBuilder;
import edu.uthscsa.ric.volume.operations.OperationListener;
import edu.uthscsa.ric.volume.operations.range.Range;
import edu.uthscsa.ric.volume.operations.range.SeriesRangeOp;
import edu.uthscsa.ric.volume.operations.range.VolumeRangeOp;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ShrinkWrapDialog
extends JPanel
implements ActionListener,
MangoFocusableOptionPaneItem {
    private JCheckBox percentMax;
    private JCheckBox thresholdBox;
    private JLabel minLabel;
    private JRadioButton wrap3D;
    private JRadioButton wrapAxial;
    private JRadioButton wrapCoronal;
    private JRadioButton wrapSagittal;
    private MangoTextField minText;
    private boolean percentMaxRun;
    private JRadioButton percentMaxDynamic;
    private JRadioButton percentMaxSeries;
    private final boolean isSeries;
    private final SliceViewer viewer;
    private final String defaultMin;
    private static final long serialVersionUID = 1L;
    public static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(1, false);
    public static final String PLACEHOLDER_TEXT = "Enter an optional label for this ROI";

    public ShrinkWrapDialog(SliceViewer viewer, String defaultMin) {
        this.viewer = viewer;
        this.defaultMin = defaultMin;
        this.isSeries = viewer.getROIManager().isUsing4dROI();
        this.createUI();
    }

    public boolean isDynamicThreshold() {
        return this.percentMaxDynamic.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        if (actionCommand.equals("Threshold")) {
            this.updateThresholdOptions();
            this.updatePercentMaxOptions();
            this.updateShrinkWrapOptions();
        } else if (actionCommand.equals("% Max")) {
            if (this.percentMax.isSelected()) {
                if (this.percentMaxRun) {
                    this.doPercentMax();
                } else {
                    this.percentMaxRun = true;
                    if (this.viewer.getCurrentVolume().getNumTimepoints() > 1) {
                        this.updateSeriesVolumeRange();
                    } else {
                        this.updateCurrentVolumeRange();
                    }
                }
            } else {
                this.doPercentMax();
            }
        }
    }

    @Override
    public void doFocus() {
        this.minText.requestFocusInWindow();
        this.minText.requestFocus();
    }

    public String getMin() {
        return this.minText.getText();
    }

    public int getSliceDirection() {
        if (this.wrapAxial.isSelected()) {
            return 0;
        }
        if (this.wrapCoronal.isSelected()) {
            return 1;
        }
        if (this.wrapSagittal.isSelected()) {
            return 2;
        }
        return -1;
    }

    public boolean isPercentMax() {
        return this.percentMax.isSelected();
    }

    public boolean isThreshold() {
        return this.thresholdBox.isSelected();
    }

    private void createUI() {
        this.thresholdBox = new JCheckBox("Threshold ");
        this.thresholdBox.setActionCommand("Threshold");
        this.thresholdBox.addActionListener(this);
        this.minText = new MangoTextField(this.defaultMin, 6);
        this.minLabel = new JLabel("Min");
        this.percentMax = new JCheckBox("% Max");
        this.percentMax.addActionListener(this);
        JPanel minPanel = new JPanel();
        minPanel.add(this.minLabel);
        minPanel.add(this.minText);
        boolean isVOIMode = this.viewer.isMultiSliceMode();
        this.wrapAxial = new JRadioButton("Axial");
        this.wrapAxial.setEnabled(isVOIMode);
        this.wrapCoronal = new JRadioButton("Coronal");
        this.wrapCoronal.setEnabled(isVOIMode);
        this.wrapSagittal = new JRadioButton("Sagittal");
        this.wrapSagittal.setEnabled(isVOIMode);
        this.wrap3D = new JRadioButton("3D");
        this.wrap3D.setEnabled(isVOIMode);
        ButtonGroup group = new ButtonGroup();
        group.add(this.wrapAxial);
        group.add(this.wrapCoronal);
        group.add(this.wrapSagittal);
        group.add(this.wrap3D);
        int sliceDirection = this.viewer.getMainSliceDirection();
        if (sliceDirection == 0) {
            this.wrapAxial.setSelected(true);
        } else if (sliceDirection == 1) {
            this.wrapCoronal.setSelected(true);
        } else if (sliceDirection == 2) {
            this.wrapSagittal.setSelected(true);
        }
        JPanel wrapOptionsPanel = new JPanel();
        wrapOptionsPanel.add(this.wrapAxial);
        wrapOptionsPanel.add(this.wrapCoronal);
        wrapOptionsPanel.add(this.wrapSagittal);
        wrapOptionsPanel.add(this.wrap3D);
        this.setLayout(new BoxLayout(this, 1));
        this.add(wrapOptionsPanel);
        JPanel rangePanel = new JPanel();
        rangePanel.setLayout(new BoxLayout(rangePanel, 0));
        rangePanel.add(this.thresholdBox);
        rangePanel.add(minPanel);
        rangePanel.add(this.percentMax);
        this.add(rangePanel);
        this.percentMaxSeries = new JRadioButton("% Series Max");
        this.percentMaxDynamic = new JRadioButton("% Max Dynamic");
        ButtonGroup percentGroup = new ButtonGroup();
        percentGroup.add(this.percentMaxSeries);
        percentGroup.add(this.percentMaxDynamic);
        this.percentMaxSeries.setSelected(true);
        JPanel percentPanel = new JPanel();
        percentPanel.setLayout(new BoxLayout(percentPanel, 0));
        percentPanel.add(this.percentMaxSeries);
        percentPanel.add(this.percentMaxDynamic);
        if (this.viewer.getCurrentScreenVolume().getVolume().getNumTimepoints() > 1) {
            this.add(percentPanel);
        }
        this.updateThresholdOptions();
        this.updatePercentMaxOptions();
    }

    private void updatePercentMaxOptions() {
        this.percentMaxSeries.setEnabled(this.thresholdBox.isSelected() && this.percentMax.isSelected());
        this.percentMaxDynamic.setEnabled(this.thresholdBox.isSelected() && this.percentMax.isSelected() && this.isSeries);
        if (!this.percentMaxSeries.isEnabled()) {
            this.percentMaxSeries.setSelected(false);
        }
        if (this.percentMaxDynamic.isEnabled()) {
            this.percentMaxDynamic.setSelected(true);
        } else {
            this.percentMaxSeries.setSelected(true);
        }
    }

    private void doPercentMax() {
        double imageMax = this.viewer.getCurrentVolume().getImageMax();
        try {
            if (this.percentMax.isSelected()) {
                double minNum = Double.parseDouble(this.minText.getText());
                this.minText.setText(FORMATTER.format(minNum / imageMax * 100.0));
            } else {
                double minNum = Double.parseDouble(this.minText.getText());
                this.minText.setText(FORMATTER.format(minNum / 100.0 * imageMax));
            }
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        this.updatePercentMaxOptions();
    }

    private void updateThresholdOptions() {
        boolean isThreshold = this.thresholdBox.isSelected();
        this.minText.setEnabled(isThreshold);
        this.minLabel.setEnabled(isThreshold);
        this.percentMax.setEnabled(isThreshold);
        this.percentMaxDynamic.setEnabled(isThreshold);
        this.percentMaxSeries.setEnabled(isThreshold);
    }

    private void updateSeriesVolumeRange() {
        final Volume vol = this.viewer.getCurrentVolume();
        SeriesRangeOp op = new SeriesRangeOp(this.viewer, vol);
        OperationBuilder<Range> builder = new OperationBuilder<Range>(this.viewer, op);
        builder.runAsynchronously(new OperationListener(){

            @Override
            public void operationFinished(Object result, ImageVolume volume) {
                vol.updateMaxMin((Range)result);
                SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ShrinkWrapDialog.this.doPercentMax();
                    }
                });
            }
        });
    }

    private void updateCurrentVolumeRange() {
        final Volume vol = this.viewer.getCurrentVolume();
        VolumeRangeOp op = new VolumeRangeOp(this.viewer, vol);
        OperationBuilder<Range> builder = new OperationBuilder<Range>(this.viewer, op);
        builder.runAsynchronously(new OperationListener(){

            @Override
            public void operationFinished(Object result, ImageVolume volume) {
                vol.updateMaxMin((Range)result);
                SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ShrinkWrapDialog.this.doPercentMax();
                    }
                });
            }
        });
    }

    private void updateShrinkWrapOptions() {
        boolean isVOIMode = this.viewer.isMultiSliceMode();
        this.wrapAxial.setEnabled(isVOIMode);
        this.wrapCoronal.setEnabled(isVOIMode);
        this.wrapSagittal.setEnabled(isVOIMode);
        this.wrap3D.setEnabled(isVOIMode);
    }
}

