/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.modal;

import edu.uthscsa.ric.mango.components.MangoColorButton;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SaveROIPanel
extends JPanel
implements ActionListener {
    private JRadioButton allButton;
    private MangoColorButton colorButton;
    private JLabel selectLabel;
    private JRadioButton singleButton;
    private final SliceViewer viewer;
    private static final long serialVersionUID = 1L;

    public SaveROIPanel(SliceViewer viewer) {
        this.viewer = viewer;
        this.createUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.updateEnabled();
    }

    public int getColor() {
        if (this.allButton.isSelected()) {
            return -1;
        }
        return this.colorButton.getColor();
    }

    private void createUI() {
        this.allButton = new JRadioButton("All Colors");
        this.allButton.addActionListener(this);
        JPanel allPanel = new JPanel();
        allPanel.setLayout(new BoxLayout(allPanel, 0));
        allPanel.add(Box.createHorizontalGlue());
        allPanel.add(this.allButton);
        allPanel.add(Box.createHorizontalGlue());
        this.singleButton = new JRadioButton("Single Color");
        this.singleButton.addActionListener(this);
        JPanel singlePanel = new JPanel();
        singlePanel.setLayout(new BoxLayout(singlePanel, 0));
        singlePanel.add(Box.createHorizontalGlue());
        singlePanel.add(this.singleButton);
        singlePanel.add(Box.createHorizontalGlue());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.allButton);
        bg.add(this.singleButton);
        this.allButton.setSelected(true);
        this.colorButton = new MangoColorButton(this.viewer, null, true);
        this.selectLabel = new JLabel("Select:");
        JPanel selectPanel = new JPanel();
        selectPanel.setLayout(new BoxLayout(selectPanel, 0));
        selectPanel.add(Box.createHorizontalGlue());
        selectPanel.add(this.selectLabel);
        selectPanel.add(Box.createHorizontalStrut(4));
        selectPanel.add(this.colorButton);
        selectPanel.add(Box.createHorizontalGlue());
        JLabel titleLabel = new JLabel("Colors to Save");
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        titlePanel.add(Box.createHorizontalGlue());
        titlePanel.add(titleLabel);
        titlePanel.add(Box.createHorizontalGlue());
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add(Box.createVerticalStrut(8));
        this.add(titlePanel);
        this.add(Box.createVerticalStrut(8));
        this.add(allPanel);
        this.add(singlePanel);
        this.add(selectPanel);
        this.add(Box.createVerticalGlue());
        this.updateEnabled();
    }

    private void updateEnabled() {
        this.selectLabel.setEnabled(this.singleButton.isSelected());
        this.colorButton.setEnabled(this.singleButton.isSelected());
        this.colorButton.closeColorPickerPopup();
    }
}

