/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.modal;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.utilities.AppLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ROISmartToolsDialog
extends JPanel
implements ActionListener {
    private final JCheckBox allValues;
    private final JCheckBox maxPercent;
    private final JCheckBox minPercent;
    private final JCheckBox useShift;
    private final JLabel maxLabel;
    private final JLabel minLabel;
    private final JTextField max;
    private final JTextField min;
    private final Mango mango;
    private static boolean maxPercentIsSelected;
    private static boolean minPercentIsSelected;
    private static final MangoNumberFormatter FORMATTER;
    private static final long serialVersionUID = 1L;

    public ROISmartToolsDialog(Mango mango) {
        this.mango = mango;
        double aMin = mango.getSmartToolsRangeMin();
        double aMax = mango.getSmartToolsRangeMax();
        this.max = new MangoTextField(FORMATTER.format(aMax), 6);
        this.min = new MangoTextField(FORMATTER.format(aMin), 6);
        this.maxLabel = new JLabel("Max");
        this.maxLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        this.minLabel = new JLabel("Min");
        this.minLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        this.minPercent = new JCheckBox("% Max");
        this.minPercent.setFocusable(false);
        this.minPercent.setSelected(minPercentIsSelected);
        this.minPercent.setActionCommand("min percent max");
        this.minPercent.addActionListener(this);
        JPanel minPanel = new JPanel();
        minPanel.add(this.minLabel);
        minPanel.add(this.min);
        this.maxPercent = new JCheckBox("% Max");
        this.maxPercent.setFocusable(false);
        this.maxPercent.setSelected(maxPercentIsSelected);
        this.maxPercent.setActionCommand("max percent max");
        this.maxPercent.addActionListener(this);
        JPanel maxPanel = new JPanel();
        maxPanel.add(this.maxLabel);
        maxPanel.add(this.max);
        this.allValues = new JCheckBox("All Values");
        this.allValues.setFocusable(false);
        this.allValues.setSelected(minPercentIsSelected);
        this.allValues.setActionCommand("allValues");
        this.allValues.addActionListener(this);
        this.allValues.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        this.useShift = new JCheckBox("Enable when pressing shift key");
        this.useShift.setFocusable(false);
        this.useShift.setSelected(mango.isUsingSmartToolsToggle());
        if (!mango.isUsingSmartTools()) {
            this.allValues.setSelected(true);
            this.minLabel.setEnabled(!this.allValues.isSelected());
            this.maxLabel.setEnabled(!this.allValues.isSelected());
            this.minPercent.setEnabled(!this.allValues.isSelected());
            this.maxPercent.setEnabled(!this.allValues.isSelected());
            this.min.setEnabled(!this.allValues.isSelected());
            this.max.setEnabled(!this.allValues.isSelected());
            this.useShift.setEnabled(false);
        }
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.allValues);
        this.add(this.useShift);
        this.add(minPanel);
        this.add(maxPanel);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("allValues")) {
            this.minLabel.setEnabled(!this.allValues.isSelected());
            this.maxLabel.setEnabled(!this.allValues.isSelected());
            this.minPercent.setEnabled(!this.allValues.isSelected());
            this.maxPercent.setEnabled(!this.allValues.isSelected());
            this.min.setEnabled(!this.allValues.isSelected());
            this.max.setEnabled(!this.allValues.isSelected());
            this.useShift.setEnabled(!this.allValues.isSelected());
            if (!this.useShift.isEnabled()) {
                this.useShift.setSelected(false);
            }
        }
    }

    public double getMax() {
        double maxVal = this.mango.getSmartToolsRangeMax();
        try {
            maxVal = Double.parseDouble(this.max.getText());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        return maxVal;
    }

    public double getMin() {
        double minVal = this.mango.getSmartToolsRangeMin();
        try {
            minVal = Double.parseDouble(this.min.getText());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        return minVal;
    }

    public boolean isUsingAllValues() {
        return this.allValues.isSelected();
    }

    public boolean isUsingToggle() {
        return this.useShift.isSelected();
    }

    static {
        FORMATTER = new MangoNumberFormatter();
    }
}

