/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.modal;

import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.utilities.AppLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PropagateROIDialog
extends JPanel
implements ActionListener {
    private final JCheckBox all;
    private final JLabel aboveLabel;
    private final JLabel belowLabel;
    private final JTextField aboveNum;
    private final JTextField belowNum;
    private final int numSlices;
    private final int sliceIndex;
    private static final String[][] DIRECTION_NAMES = new String[][]{{"Above", "Below"}, {"Front", "Back"}, {"Left", "Right"}};
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_SLICES = 5;

    public PropagateROIDialog(int slices, int index, int sliceDirection) {
        this.numSlices = slices;
        this.sliceIndex = index;
        int aboveStart = Math.min(5, index);
        int belowStart = Math.min(5, slices - index);
        this.all = new JCheckBox("All Slices");
        this.all.setFocusable(false);
        this.all.setActionCommand("All");
        this.all.addActionListener(this);
        this.aboveLabel = new JLabel(DIRECTION_NAMES[sliceDirection][0]);
        this.aboveNum = new MangoTextField(String.valueOf(aboveStart), 4);
        JPanel abovePanel = new JPanel();
        abovePanel.add(this.aboveLabel);
        abovePanel.add(this.aboveNum);
        this.belowLabel = new JLabel(DIRECTION_NAMES[sliceDirection][1]);
        this.belowNum = new MangoTextField(String.valueOf(belowStart), 4);
        JPanel belowPanel = new JPanel();
        belowPanel.add(this.belowLabel);
        belowPanel.add(this.belowNum);
        this.setLayout(new BoxLayout(this, 1));
        this.add(abovePanel);
        this.add(belowPanel);
        this.add(this.all);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals("All")) {
            this.aboveLabel.setEnabled(!this.all.isSelected());
            this.belowLabel.setEnabled(!this.all.isSelected());
            this.aboveNum.setEnabled(!this.all.isSelected());
            this.belowNum.setEnabled(!this.all.isSelected());
        }
    }

    public int getEndSlice() {
        if (this.all.isSelected()) {
            return this.numSlices - 1;
        }
        int endSlice = Integer.MIN_VALUE;
        try {
            endSlice = this.sliceIndex + Integer.parseInt(this.belowNum.getText());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        if (endSlice >= this.numSlices) {
            endSlice = this.numSlices - 1;
        }
        return endSlice;
    }

    public int getStartSlice() {
        if (this.all.isSelected()) {
            return 0;
        }
        int startSlice = Integer.MAX_VALUE;
        try {
            startSlice = this.sliceIndex - Integer.parseInt(this.aboveNum.getText());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        if (startSlice < 0) {
            startSlice = 0;
        }
        return startSlice;
    }
}

