/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.modal;

import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LookupTableManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OverlayOntoDialog
extends JPanel
implements ActionListener {
    private final JCheckBox closeButton;
    private final MangoComboBox<SliceViewer> compatibleBox;
    private final MangoComboBox<String> lutBox;
    private final SliceViewer viewer;
    private final boolean isWorldMode;
    private static final long serialVersionUID = 1L;
    public static final int COMBO_BOX_WIDTH = 200;

    public OverlayOntoDialog(SliceViewer current, SliceViewer[] compatible) {
        this.viewer = current;
        SliceViewer[] viewers = compatible;
        this.compatibleBox = new MangoComboBox<SliceViewer>((T[])viewers);
        this.compatibleBox.setMaximumRowCount(20);
        this.compatibleBox.setActionCommand("Viewer Selected");
        this.compatibleBox.addActionListener(this);
        this.compatibleBox.setPreferredSize(new Dimension(200, this.compatibleBox.getPreferredSize().height));
        this.compatibleBox.setMaximumSize(this.compatibleBox.getPreferredSize());
        this.compatibleBox.setMinimumSize(this.compatibleBox.getPreferredSize());
        JLabel compatibleLabel = new JLabel("Viewers:");
        JPanel compatiblePanel = new JPanel();
        compatiblePanel.setLayout(new BoxLayout(compatiblePanel, 0));
        compatiblePanel.add(compatibleLabel);
        compatiblePanel.add(Box.createHorizontalGlue());
        compatiblePanel.add(this.compatibleBox);
        this.lutBox = new MangoComboBox<String>((T[])LookupTableManager.getAllLUTNames());
        this.lutBox.setSelectedItem(((SliceViewer)this.compatibleBox.getSelectedItem()).getOverlayManager().getNextLUTType());
        this.lutBox.setMaximumRowCount(20);
        this.lutBox.setPreferredSize(new Dimension(200, this.lutBox.getPreferredSize().height));
        this.lutBox.setMaximumSize(this.lutBox.getPreferredSize());
        this.lutBox.setMinimumSize(this.lutBox.getPreferredSize());
        JLabel lutLabel = new JLabel("Colors:");
        JPanel lutPanel = new JPanel();
        lutPanel.setLayout(new BoxLayout(lutPanel, 0));
        lutPanel.add(lutLabel);
        lutPanel.add(Box.createHorizontalGlue());
        lutPanel.add(this.lutBox);
        this.closeButton = new JCheckBox("Close this viewer after overlay");
        JPanel closePanel = new JPanel();
        closePanel.setLayout(new BoxLayout(closePanel, 0));
        closePanel.add(Box.createHorizontalGlue());
        closePanel.add(this.closeButton);
        closePanel.add(Box.createHorizontalGlue());
        this.updateCloseButtonState();
        this.isWorldMode = this.viewer.isWorldMode();
        JPanel overlayPanel = new JPanel();
        overlayPanel.setLayout(new BoxLayout(overlayPanel, 1));
        overlayPanel.add(compatiblePanel);
        overlayPanel.add(lutPanel);
        overlayPanel.add(Box.createVerticalStrut(4));
        overlayPanel.add(closePanel);
        this.add((Component)overlayPanel, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("Viewer Selected")) {
            SliceViewer selectedViewer = (SliceViewer)this.compatibleBox.getSelectedItem();
            if (selectedViewer == null) {
                selectedViewer = (SliceViewer)this.compatibleBox.getItemAt(0);
            }
            this.lutBox.setSelectedItem(selectedViewer.getOverlayManager().getNextLUTType());
            this.updateCloseButtonState();
        }
    }

    public String getLookupTable() {
        return (String)this.lutBox.getSelectedItem();
    }

    public SliceViewer getViewer() {
        return (SliceViewer)this.compatibleBox.getSelectedItem();
    }

    public boolean isCloseViewerSelected() {
        return this.closeButton.isSelected();
    }

    public boolean isWorldMode() {
        return this.isWorldMode;
    }

    private void updateCloseButtonState() {
        if ((SliceViewer)this.compatibleBox.getSelectedItem() == this.viewer) {
            this.closeButton.setEnabled(false);
        } else {
            this.closeButton.setEnabled(true);
        }
    }
}

