/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.modal;

import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.volume.operations.calculation.ImageOperationTreeNode;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ExpressionEditorDialog
extends JPanel
implements ActionListener,
PopupMenuListener,
KeyListener {
    private JButton add;
    private JButton algebraicFunctions;
    private JButton clear;
    private JButton decimal;
    private JButton divide;
    private JButton logicFunctions;
    private JButton miscFunctions;
    private JButton multiply;
    private JButton otherImage;
    private JButton outputButton;
    private JButton parenClose;
    private JButton parenOpen;
    private JButton statsFunctions;
    private JButton subtract;
    private JButton thisImage;
    private JButton[] allButtons;
    private JCheckBox onlyROISlices;
    private JCheckBox useTimeseries;
    private JPopupMenu popup;
    private JPopupMenu popupAlgebraic;
    private JPopupMenu popupDimensions;
    private JPopupMenu popupLogic;
    private JPopupMenu popupMisc;
    private JPopupMenu popupOutput;
    private JPopupMenu popupStats;
    private JRadioButton insideROIButton;
    private JRadioButton outsideROIButton;
    private JRadioButton sliceButton;
    private JRadioButton useDataScale;
    private JRadioButton volumeButton;
    private JTextArea textArea;
    private SliceViewer viewer;
    private boolean hasDefaultDataScales;
    private boolean hasGlobalDataScales;
    private boolean hasSelectedROIs;
    private boolean isNewOutput;
    private boolean isVOIMode;
    private int lastAreaSelection;
    private long popupAlgTimeCanceled;
    private long popupDimsTimeCanceled;
    private long popupLogTimeCanceled;
    private long popupMiscTimeCanceled;
    private long popupOutputTimeCanceled;
    private long popupTimeCanceled;
    private long popupTrigTimeCanceled;
    private final boolean isLUT;
    private static AtomicReference<String> lastOperation = new AtomicReference();
    private static final String TEXT_ROI = "ROI(";
    private static final long serialVersionUID = 1L;
    public static final List<String> DIMENSIONS = CollectionUtilities.immutable((String[])new String[]{"col", "row", "slice", "time"});
    public static final String TEXT_SELF = "self";
    public static final int ROI_INSIDE = 2;
    public static final int ROI_OUTSIDE = 3;
    public static final int SLICE = 1;
    public static final int VOLUME = 0;

    public ExpressionEditorDialog() {
        this(false);
    }

    public ExpressionEditorDialog(boolean isLUT) {
        this.isLUT = isLUT;
        this.createUI();
        this.makeDimensionsPopupMenu();
        this.makeAlgebraicPopupMenu();
        this.makeLogicPopupMenu();
        this.makeMiscPopupMenu();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        StringBuffer stringBuf;
        int selectionEnd;
        this.textArea.grabFocus();
        if (ae.getActionCommand().equals("clear")) {
            this.textArea.setText("");
            return;
        }
        if (ae.getActionCommand().equals("other")) {
            long timeSinceCancel = new Date().getTime() - this.popupTimeCanceled;
            if (this.popup.getComponentCount() > 0 && timeSinceCancel > 250L) {
                this.popup.show(this.otherImage, 2, 35);
            }
            return;
        }
        if (ae.getActionCommand().equals("dims")) {
            long timeSinceCancel = new Date().getTime() - this.popupDimsTimeCanceled;
            if (this.popupDimensions.getComponentCount() > 0 && timeSinceCancel > 250L) {
                this.popupDimensions.show(this.allButtons[20], 2, 35);
            }
            return;
        }
        if (ae.getActionCommand().equals("output")) {
            long timeSinceCancel = new Date().getTime() - this.popupOutputTimeCanceled;
            if (this.popupOutput.getComponentCount() > 0 && timeSinceCancel > 250L) {
                this.popupOutput.show(this.outputButton, 2, 35);
            }
            return;
        }
        if (ae.getActionCommand().equals("stats")) {
            long timeSinceCancel = new Date().getTime() - this.popupTrigTimeCanceled;
            if (this.popupStats.getComponentCount() > 0 && timeSinceCancel > 250L) {
                this.popupStats.show(this.statsFunctions, 2, 35);
            }
            return;
        }
        if (ae.getActionCommand().equals("math")) {
            long timeSinceCancel = new Date().getTime() - this.popupAlgTimeCanceled;
            if (this.popupAlgebraic.getComponentCount() > 0 && timeSinceCancel > 250L) {
                this.popupAlgebraic.show(this.algebraicFunctions, 2, 35);
            }
            return;
        }
        if (ae.getActionCommand().equals("bool")) {
            long timeSinceCancel = new Date().getTime() - this.popupLogTimeCanceled;
            if (this.popupLogic.getComponentCount() > 0 && timeSinceCancel > 250L) {
                this.popupLogic.show(this.logicFunctions, 2, 35);
            }
            return;
        }
        if (ae.getActionCommand().equals("misc")) {
            long timeSinceCancel = new Date().getTime() - this.popupMiscTimeCanceled;
            if (this.popupMisc.getComponentCount() > 0 && timeSinceCancel > 250L) {
                this.popupMisc.show(this.miscFunctions, 2, 35);
            }
            return;
        }
        if (ae.getActionCommand().equals("new output")) {
            this.isNewOutput = true;
            this.outputButton.setText("new");
            return;
        }
        if (ae.getActionCommand().equals("this output")) {
            this.isNewOutput = false;
            this.outputButton.setText("this");
            return;
        }
        if (ae.getActionCommand().equals("Update DataScale")) {
            if (this.hasDefaultDataScales) {
                this.useDataScale.setSelected(false);
                this.useDataScale.setEnabled(false);
            } else if (this.volumeButton.isSelected() || (this.insideROIButton.isSelected() || this.outsideROIButton.isSelected()) && this.isVOIMode) {
                this.useDataScale.setEnabled(true);
                if (this.hasGlobalDataScales) {
                    this.useDataScale.setSelected(false);
                } else {
                    this.useDataScale.setSelected(true);
                }
            } else if (this.sliceButton.isSelected() || (this.insideROIButton.isSelected() || this.outsideROIButton.isSelected()) && !this.isVOIMode) {
                this.useDataScale.setSelected(false);
                this.useDataScale.setEnabled(false);
            }
            if (this.hasSelectedROIs && this.isVOIMode && this.outsideROIButton.isSelected()) {
                this.onlyROISlices.setEnabled(true);
            } else {
                this.onlyROISlices.setSelected(false);
                this.onlyROISlices.setEnabled(false);
            }
            return;
        }
        if (ae.getActionCommand().equals("Only ROI Slices")) {
            return;
        }
        String text = "";
        int position = this.textArea.getCaretPosition();
        int selectionStart = this.textArea.getSelectionStart();
        if (selectionStart != (selectionEnd = this.textArea.getSelectionEnd())) {
            text = ae.getActionCommand().equals(TEXT_SELF) ? ((JButton)ae.getSource()).getText() : (ae.getActionCommand().indexOf("other") != -1 ? ae.getActionCommand().substring(0, 9).trim() : ae.getActionCommand());
            if (text.indexOf("start") != -1 && text.indexOf("end") != -1) {
                text = text.substring(0, text.indexOf(40)) + "(1, " + this.viewer.getVolume().getNumTimepoints() + ")";
            } else if (text.indexOf(TEXT_ROI) != -1) {
                text = text.substring(0, text.indexOf(TEXT_ROI) + 4) + "color)";
            } else if (text.indexOf("volume") != -1) {
                int currentTimepoint = this.viewer.getCurrentTimepoint() + 1;
                text = "volume(" + currentTimepoint + ")";
            }
            stringBuf = new StringBuffer(this.textArea.getText());
            stringBuf.replace(selectionStart, selectionEnd, text);
            this.textArea.setText(stringBuf.toString());
            this.textArea.setCaretPosition(selectionStart);
            position = this.textArea.getCaretPosition();
        } else {
            text = ae.getActionCommand().equals(TEXT_SELF) ? ((JButton)ae.getSource()).getText() : (ae.getActionCommand().indexOf("other") != -1 ? ae.getActionCommand().substring(0, 9).trim() : ae.getActionCommand());
            if (text.indexOf("start") != -1 && text.indexOf("end") != -1) {
                text = text.substring(0, text.indexOf(40)) + "(1, " + this.viewer.getVolume().getNumTimepoints() + ")";
            } else if (text.indexOf(TEXT_ROI) != -1) {
                text = text.substring(0, text.indexOf(TEXT_ROI) + 4) + "color)";
            } else if (text.indexOf("volume") != -1) {
                int currentTimepoint = this.viewer.getCurrentTimepoint() + 1;
                text = "volume(" + currentTimepoint + ")";
            }
            stringBuf = new StringBuffer(this.textArea.getText());
            stringBuf.insert(position, text);
            this.textArea.setText(stringBuf.toString());
        }
        if (text.indexOf(40) != -1) {
            int conPos = this.textArea.getText().indexOf("condition", position);
            int valPos = this.textArea.getText().indexOf("value", position);
            int dimPos = this.textArea.getText().indexOf("dim", position);
            if (!(conPos == -1 || conPos >= valPos && valPos != -1 || conPos >= dimPos && dimPos != -1)) {
                this.textArea.select(conPos, conPos + 3);
            } else if (!(valPos == -1 || valPos >= conPos && conPos != -1 || valPos >= dimPos && dimPos != -1)) {
                this.textArea.select(valPos, valPos + 3);
            } else if (!(dimPos == -1 || dimPos >= valPos && valPos != -1 || dimPos >= conPos && conPos != -1)) {
                this.textArea.select(dimPos, dimPos + 3);
            }
        } else {
            this.textArea.setCaretPosition(position + text.length());
        }
    }

    public int getImageAreaSelection() {
        this.lastAreaSelection = this.sliceButton.isSelected() ? 1 : (this.insideROIButton.isSelected() ? 2 : (this.outsideROIButton.isSelected() ? 3 : 0));
        return this.lastAreaSelection;
    }

    public String getResults() {
        lastOperation.set(this.textArea.getText());
        return lastOperation.get();
    }

    public boolean isAllTimepoints() {
        return this.useTimeseries.isSelected();
    }

    public boolean isApplyDataScale() {
        return this.useDataScale.isSelected();
    }

    public boolean isOutputToNewImage() {
        return this.isNewOutput;
    }

    public boolean isROISliceOnly() {
        return this.onlyROISlices.isSelected() && this.hasSelectedROIs && this.isVOIMode && this.outsideROIButton.isSelected();
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        int keyCode = ke.getKeyCode();
        if (keyCode == 40) {
            this.textArea.setCaretPosition(this.textArea.getText().length());
        } else if (keyCode == 38) {
            this.textArea.setCaretPosition(0);
        } else if (keyCode == 10) {
            this.getRootPane().getDefaultButton().doClick();
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent pme) {
        if (pme.getSource() == this.popup) {
            this.popupTimeCanceled = new Date().getTime();
        } else if (pme.getSource() == this.popupStats) {
            this.popupTrigTimeCanceled = new Date().getTime();
        } else if (pme.getSource() == this.popupAlgebraic) {
            this.popupAlgTimeCanceled = new Date().getTime();
        } else if (pme.getSource() == this.popupLogic) {
            this.popupLogTimeCanceled = new Date().getTime();
        } else if (pme.getSource() == this.popupMisc) {
            this.popupMiscTimeCanceled = new Date().getTime();
        } else if (pme.getSource() == this.popupDimensions) {
            this.popupDimsTimeCanceled = new Date().getTime();
        } else if (pme.getSource() == this.popupOutput) {
            this.popupOutputTimeCanceled = new Date().getTime();
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
    }

    public synchronized void setResultsText(String string) {
        this.textArea.setText(string);
        lastOperation.set(string);
    }

    private final void createUI() {
        this.allButtons = new JButton[28];
        this.allButtons[0] = this.clear = new JButton("clear");
        this.clear.setActionCommand("clear");
        this.allButtons[1] = this.thisImage = new JButton("");
        this.allButtons[1].setEnabled(false);
        this.allButtons[2] = this.otherImage = new JButton("");
        this.allButtons[2].setEnabled(false);
        JButton[] nums = new JButton[10];
        for (int ctr = 0; ctr < 10; ++ctr) {
            this.allButtons[3 + ctr] = nums[ctr] = new JButton(String.valueOf(ctr));
            nums[ctr].setActionCommand(TEXT_SELF);
        }
        String decimalString = Platform.MAC ? "\u2219" : ".";
        this.allButtons[13] = this.decimal = new JButton(decimalString);
        this.decimal.setActionCommand(".");
        this.allButtons[14] = this.parenOpen = new JButton("(");
        this.parenOpen.setActionCommand(TEXT_SELF);
        this.allButtons[15] = this.parenClose = new JButton(")");
        this.parenOpen.setActionCommand(TEXT_SELF);
        this.allButtons[16] = this.multiply = new JButton("\u00d7");
        this.multiply.setActionCommand("*");
        this.allButtons[17] = this.divide = new JButton("\u00f7");
        this.divide.setActionCommand("/");
        this.allButtons[18] = this.add = new JButton("+");
        this.add.setActionCommand("+");
        this.allButtons[19] = this.subtract = new JButton("-");
        this.subtract.setActionCommand("-");
        this.allButtons[20] = this.isLUT ? (this.statsFunctions = new JButton("value")) : (this.statsFunctions = new JButton("dims"));
        this.allButtons[21] = this.algebraicFunctions = new JButton("math");
        this.allButtons[22] = this.logicFunctions = new JButton("bool");
        this.allButtons[23] = this.miscFunctions = new JButton("misc");
        JPanel buttonPanelBottom = new JPanel(new GridLayout(2, 4));
        buttonPanelBottom.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        buttonPanelBottom.add(this.algebraicFunctions, 0, 0);
        buttonPanelBottom.add(this.logicFunctions, 0, 1);
        buttonPanelBottom.add(this.statsFunctions, 0, 2);
        buttonPanelBottom.add(this.miscFunctions, 0, 3);
        buttonPanelBottom.add(this.multiply, 1, 0);
        buttonPanelBottom.add(this.divide, 1, 1);
        buttonPanelBottom.add(this.add, 1, 2);
        buttonPanelBottom.add(this.subtract, 1, 3);
        JPanel buttonPanelTop = new JPanel(new GridLayout(4, 4));
        buttonPanelTop.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        buttonPanelTop.add(nums[0], 0, 0);
        buttonPanelTop.add(this.decimal, 0, 1);
        buttonPanelTop.add(this.clear, 0, 2);
        buttonPanelTop.add(this.parenClose, 0, 3);
        buttonPanelTop.add(nums[1], 1, 0);
        buttonPanelTop.add(nums[2], 1, 1);
        buttonPanelTop.add(nums[3], 1, 2);
        buttonPanelTop.add(this.parenOpen, 1, 3);
        buttonPanelTop.add(nums[4], 2, 0);
        buttonPanelTop.add(nums[5], 2, 1);
        buttonPanelTop.add(nums[6], 2, 2);
        buttonPanelTop.add(this.otherImage, 2, 3);
        buttonPanelTop.add(nums[7], 3, 0);
        buttonPanelTop.add(nums[8], 3, 1);
        buttonPanelTop.add(nums[9], 3, 2);
        buttonPanelTop.add(this.thisImage, 3, 3);
        JPanel buttonPanel = new JPanel();
        BoxLayout layoutButtonPanel = new BoxLayout(buttonPanel, 1);
        buttonPanel.setLayout(layoutButtonPanel);
        buttonPanel.add(buttonPanelTop);
        buttonPanel.add(buttonPanelBottom);
        for (JButton allButton : this.allButtons) {
            if (allButton == null) continue;
            allButton.setFocusable(false);
            allButton.addActionListener(this);
        }
        this.textArea = new JTextArea(5, 22);
        this.textArea.addKeyListener(this);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        if (lastOperation.get() != null) {
            this.textArea.setText(lastOperation.get().trim());
        }
        JScrollPane textAreaScroller = new JScrollPane(this.textArea, 20, 31);
        JLabel thisLabel = new JLabel("= ");
        this.outputButton = new JButton(this.isNewOutput ? "new" : "this");
        this.outputButton.setFocusable(false);
        this.outputButton.setActionCommand("output");
        this.outputButton.addActionListener(this);
        this.makeOutputPopupMenu();
        JPanel outputPanel = new JPanel();
        outputPanel.add(this.outputButton);
        outputPanel.add(thisLabel);
        JPanel textPanel = new JPanel();
        textPanel.add(textAreaScroller);
        this.setLayout(new BoxLayout(this, 1));
        this.add(buttonPanel);
        this.add(textPanel);
    }

    private void makeAlgebraicPopupMenu() {
        JMenuItem mi;
        this.popupAlgebraic = new JPopupMenu();
        for (int ctr = 0; ctr < ImageOperationTreeNode.ALGEBRAIC_FUNCTION_NAMES.size(); ++ctr) {
            String name = ImageOperationTreeNode.ALGEBRAIC_FUNCTION_NAMES.get(ctr);
            name = ctr == 6 ? name + "(value, value)" : name + "(value)";
            mi = new JMenuItem(name);
            mi.setActionCommand(mi.getText());
            mi.addActionListener(this);
            this.popupAlgebraic.add(mi);
        }
        for (String element : ImageOperationTreeNode.TRIG_FUNCTION_NAMES) {
            mi = new JMenuItem(element + "(value)");
            mi.setActionCommand(mi.getText());
            mi.addActionListener(this);
            this.popupAlgebraic.add(mi);
        }
        JMenuItem mi2 = new JMenuItem("\u03c0");
        mi2.setActionCommand(mi2.getText());
        mi2.addActionListener(this);
        this.popupAlgebraic.add(mi2);
        this.popupAlgebraic.addPopupMenuListener(this);
    }

    private void makeDimensionsPopupMenu() {
        this.popupDimensions = new JPopupMenu();
        for (String name : DIMENSIONS) {
            JMenuItem mi = new JMenuItem(name);
            mi.setActionCommand(mi.getText());
            mi.addActionListener(this);
            this.popupDimensions.add(mi);
        }
        this.popupDimensions.addPopupMenuListener(this);
    }

    private void makeLogicPopupMenu() {
        this.popupLogic = new JPopupMenu();
        for (int ctr = 0; ctr < ImageOperationTreeNode.LOGIC_FUNCTION_NAMES.size(); ++ctr) {
            String name = ImageOperationTreeNode.LOGIC_FUNCTION_NAMES.get(ctr);
            if (ctr == 3) {
                name = name + "(condition)";
            } else if (ctr == 4) {
                name = name + "(condition, value else value)";
            }
            JMenuItem mi = new JMenuItem(name);
            mi.setActionCommand(mi.getText());
            mi.addActionListener(this);
            this.popupLogic.add(mi);
        }
        JMenuItem mi = new JMenuItem("true");
        mi.setActionCommand(mi.getText());
        mi.addActionListener(this);
        this.popupLogic.add(mi);
        mi = new JMenuItem("false");
        mi.setActionCommand(mi.getText());
        mi.addActionListener(this);
        this.popupLogic.add(mi);
        this.popupLogic.addPopupMenuListener(this);
    }

    private void makeMiscPopupMenu() {
        this.popupMisc = new JPopupMenu();
        for (int ctr = 5; ctr < ImageOperationTreeNode.MISC_FUNCTION_NAMES.size(); ++ctr) {
            String name = ImageOperationTreeNode.MISC_FUNCTION_NAMES.get(ctr);
            if (ctr == 0 || ctr == 7 || ctr == 8 || ctr == 9) {
                name = name + "(value)";
            } else if (ctr == 5 || ctr == 6 || ctr == 10 || ctr == 12) {
                name = name + "(value, value)";
            } else if (ctr == 11) {
                name = name + "(condition)";
            }
            JMenuItem mi = new JMenuItem(name);
            mi.setActionCommand(mi.getText());
            mi.addActionListener(this);
            this.popupMisc.add(mi);
        }
        this.popupMisc.addPopupMenuListener(this);
    }

    private void makeOutputPopupMenu() {
        this.popupOutput = new JPopupMenu();
        JMenuItem mi = new JMenuItem("this");
        mi.setActionCommand("this output");
        mi.addActionListener(this);
        this.popupOutput.add(mi);
        mi = new JMenuItem("new");
        mi.setActionCommand("new output");
        mi.addActionListener(this);
        this.popupOutput.add(mi);
        this.popupOutput.addPopupMenuListener(this);
    }
}

