/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.modal;

import edu.uthscsa.ric.mango.components.MangoTextField;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class EditOriginDialog
extends JPanel
implements ActionListener {
    private final JLabel changeDescription;
    private final JRadioButton imageRadioButton;
    private final JRadioButton worldRadioButton;
    private final JTextField xField;
    private final JTextField yField;
    private final JTextField zField;
    private final String[] oldImage;
    private final String[] oldWorld;
    private static final long serialVersionUID = 1L;
    public static final int TEXTFIELD_SIZE = 6;

    public EditOriginDialog(boolean isEditingWorldOrigin, String[] oldImageVals, String[] oldWorldVals, String[] newVals) {
        this.oldImage = oldImageVals;
        this.oldWorld = oldWorldVals;
        this.xField = new MangoTextField(newVals[0], 6);
        this.yField = new MangoTextField(newVals[1], 6);
        this.zField = new MangoTextField(newVals[2], 6);
        JLabel xLabel = new JLabel("X");
        JLabel yLabel = new JLabel("Y");
        JLabel zLabel = new JLabel("Z");
        JPanel fieldPanel = new JPanel();
        GridLayout fieldPanelLayout = new GridLayout(2, 3);
        fieldPanelLayout.setHgap(6);
        fieldPanel.setLayout(fieldPanelLayout);
        fieldPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        fieldPanel.add(this.xField, 0, 0);
        fieldPanel.add(this.yField, 0, 1);
        fieldPanel.add(this.zField, 0, 2);
        fieldPanel.add(xLabel, 1, 0);
        fieldPanel.add(yLabel, 1, 1);
        fieldPanel.add(zLabel, 1, 2);
        this.imageRadioButton = new JRadioButton("Image Space");
        this.imageRadioButton.addActionListener(this);
        this.imageRadioButton.setActionCommand("image");
        this.imageRadioButton.setSelected(!isEditingWorldOrigin);
        this.imageRadioButton.setFocusable(false);
        this.worldRadioButton = new JRadioButton("World Space");
        this.worldRadioButton.addActionListener(this);
        this.worldRadioButton.setActionCommand("world");
        this.worldRadioButton.setSelected(isEditingWorldOrigin);
        this.worldRadioButton.setFocusable(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.imageRadioButton);
        group.add(this.worldRadioButton);
        JPanel radioButtonPanel = new JPanel(new GridLayout(1, 2));
        radioButtonPanel.add(this.imageRadioButton, 0, 0);
        radioButtonPanel.add(this.worldRadioButton, 0, 1);
        radioButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 14, 0));
        this.changeDescription = new JLabel();
        JPanel desPanel = new JPanel(new GridLayout(1, 1));
        desPanel.add(this.changeDescription, 0, 0);
        desPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        this.updateChangeDescription();
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(6, 20, 6, 20));
        this.add(desPanel);
        this.add(fieldPanel);
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        if (actionCommand.equals("image") || actionCommand.equals("world")) {
            this.updateChangeDescription();
        }
    }

    public String[] getResult() {
        return new String[]{this.xField.getText(), this.yField.getText(), this.zField.getText()};
    }

    public boolean isEditingWorldOrigin() {
        return this.worldRadioButton.isSelected();
    }

    private void updateChangeDescription() {
        if (this.imageRadioButton.isSelected()) {
            this.changeDescription.setText("Change origin from (" + this.oldImage[0] + ", " + this.oldImage[1] + ", " + this.oldImage[2] + ") to... ");
        } else {
            this.changeDescription.setText("Change origin from (" + this.oldWorld[0] + ", " + this.oldWorld[1] + ", " + this.oldWorld[2] + ") to... ");
        }
    }
}

