/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.layout;

import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerslice.dialogs.layout.Layout;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class MarkupPanel
extends JPanel
implements ActionListener {
    private Color backgroundColor;
    private Color barsColor;
    private Color currentColor;
    private Color footnoteColor;
    private Color orientColor;
    private Color slicesColor;
    private Color titleColor = DEFAULT_COLOR_TITLE;
    private JColorChooser colorChooser;
    private final JComboBox<String> footnoteBox;
    private final JComboBox<String> footnoteFontBox;
    private final JComboBox<String> titleBox;
    private final JComboBox<String> titleFontBox;
    private final JRadioButton allButton;
    private final JRadioButton firstButton;
    private final JRadioButton otherButton;
    private final JTextField otherText;
    private static final long serialVersionUID = 1L;
    public static final Color DEFAULT_COLOR_BACKGROUND = new Color(Color.BLACK.getRGB());
    public static final Color DEFAULT_COLOR_BARS = new Color(Color.WHITE.getRGB());
    public static final Color DEFAULT_COLOR_FOOTNOTE = new Color(Layout.COLOR_DEFAULT2.getRGB());
    public static final Color DEFAULT_COLOR_ORIENT = new Color(Layout.COLOR_DEFAULT2.getRGB());
    public static final Color DEFAULT_COLOR_SLICES = new Color(Color.WHITE.getRGB());
    public static final Color DEFAULT_COLOR_TITLE = new Color(Layout.COLOR_DEFAULT2.getRGB());
    public static final List<String> LOC_CHOICES = CollectionUtilities.immutable((String[])new String[]{"Center", "Left", "Right"});
    public static final String TEXT_COLORS = "Colors";
    public static final String ACTION_UPDATE_TEXT = "update text";

    public MarkupPanel() {
        JButton titleColorButton = new JButton("Title...");
        titleColorButton.setFocusable(false);
        titleColorButton.setActionCommand("title color");
        titleColorButton.addActionListener(this);
        JPanel titleSwatchPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(new Color(MarkupPanel.this.titleColor.getRed(), MarkupPanel.this.titleColor.getGreen(), MarkupPanel.this.titleColor.getBlue()));
                g.fillRect(0, 0, 21, 21);
                g.setColor(Color.DARK_GRAY);
                g.drawRect(0, 0, 21, 21);
            }
        };
        titleSwatchPanel.setPreferredSize(new Dimension(22, 22));
        titleSwatchPanel.setMaximumSize(titleSwatchPanel.getPreferredSize());
        titleSwatchPanel.setMinimumSize(titleSwatchPanel.getPreferredSize());
        JPanel titleColorPanel = new JPanel();
        titleColorPanel.setLayout(new BoxLayout(titleColorPanel, 0));
        titleColorPanel.add(titleColorButton);
        titleColorPanel.add(Box.createHorizontalStrut(2));
        titleColorPanel.add(titleSwatchPanel);
        this.footnoteColor = DEFAULT_COLOR_FOOTNOTE;
        JButton footnoteColorButton = new JButton("Footnote...");
        footnoteColorButton.setFocusable(false);
        footnoteColorButton.setActionCommand("footnote color");
        footnoteColorButton.addActionListener(this);
        JPanel footnoteSwatchPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(new Color(MarkupPanel.this.footnoteColor.getRed(), MarkupPanel.this.footnoteColor.getGreen(), MarkupPanel.this.footnoteColor.getBlue()));
                g.fillRect(0, 0, 21, 21);
                g.setColor(Color.DARK_GRAY);
                g.drawRect(0, 0, 21, 21);
            }
        };
        footnoteSwatchPanel.setPreferredSize(new Dimension(22, 22));
        footnoteSwatchPanel.setMaximumSize(footnoteSwatchPanel.getPreferredSize());
        footnoteSwatchPanel.setMinimumSize(footnoteSwatchPanel.getPreferredSize());
        JPanel footnoteColorPanel = new JPanel();
        footnoteColorPanel.setLayout(new BoxLayout(footnoteColorPanel, 0));
        footnoteColorPanel.add(footnoteColorButton);
        footnoteColorPanel.add(Box.createHorizontalStrut(2));
        footnoteColorPanel.add(footnoteSwatchPanel);
        this.slicesColor = DEFAULT_COLOR_SLICES;
        JButton slicesColorButton = new JButton("Slice Labels...");
        slicesColorButton.setFocusable(false);
        slicesColorButton.setActionCommand("slices color");
        slicesColorButton.addActionListener(this);
        JPanel slicesSwatchPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(new Color(MarkupPanel.this.slicesColor.getRed(), MarkupPanel.this.slicesColor.getGreen(), MarkupPanel.this.slicesColor.getBlue()));
                g.fillRect(0, 0, 21, 21);
                g.setColor(Color.DARK_GRAY);
                g.drawRect(0, 0, 21, 21);
            }
        };
        slicesSwatchPanel.setPreferredSize(new Dimension(22, 22));
        slicesSwatchPanel.setMaximumSize(slicesSwatchPanel.getPreferredSize());
        slicesSwatchPanel.setMinimumSize(slicesSwatchPanel.getPreferredSize());
        JPanel slicesColorPanel = new JPanel();
        slicesColorPanel.setLayout(new BoxLayout(slicesColorPanel, 0));
        slicesColorPanel.add(slicesColorButton);
        slicesColorPanel.add(Box.createHorizontalStrut(2));
        slicesColorPanel.add(slicesSwatchPanel);
        this.orientColor = DEFAULT_COLOR_ORIENT;
        JButton orientColorButton = new JButton("L-R Label...");
        orientColorButton.setFocusable(false);
        orientColorButton.setActionCommand("orient color");
        orientColorButton.addActionListener(this);
        JPanel orientSwatchPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(new Color(MarkupPanel.this.orientColor.getRed(), MarkupPanel.this.orientColor.getGreen(), MarkupPanel.this.orientColor.getBlue()));
                g.fillRect(0, 0, 21, 21);
                g.setColor(Color.DARK_GRAY);
                g.drawRect(0, 0, 21, 21);
            }
        };
        orientSwatchPanel.setPreferredSize(new Dimension(22, 22));
        orientSwatchPanel.setMaximumSize(orientSwatchPanel.getPreferredSize());
        orientSwatchPanel.setMinimumSize(orientSwatchPanel.getPreferredSize());
        JPanel orientColorPanel = new JPanel();
        orientColorPanel.setLayout(new BoxLayout(orientColorPanel, 0));
        orientColorPanel.add(orientColorButton);
        orientColorPanel.add(Box.createHorizontalStrut(2));
        orientColorPanel.add(orientSwatchPanel);
        this.barsColor = DEFAULT_COLOR_BARS;
        JButton barsColorButton = new JButton("Color Bar Labels...");
        barsColorButton.setFocusable(false);
        barsColorButton.setActionCommand("bars color");
        barsColorButton.addActionListener(this);
        JPanel barsSwatchPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(new Color(MarkupPanel.this.barsColor.getRed(), MarkupPanel.this.barsColor.getGreen(), MarkupPanel.this.barsColor.getBlue()));
                g.fillRect(0, 0, 21, 21);
                g.setColor(Color.DARK_GRAY);
                g.drawRect(0, 0, 21, 21);
            }
        };
        barsSwatchPanel.setPreferredSize(new Dimension(22, 22));
        barsSwatchPanel.setMaximumSize(barsSwatchPanel.getPreferredSize());
        barsSwatchPanel.setMinimumSize(barsSwatchPanel.getPreferredSize());
        JPanel barsColorPanel = new JPanel();
        barsColorPanel.setLayout(new BoxLayout(barsColorPanel, 0));
        barsColorPanel.add(barsColorButton);
        barsColorPanel.add(Box.createHorizontalStrut(2));
        barsColorPanel.add(barsSwatchPanel);
        this.backgroundColor = DEFAULT_COLOR_BACKGROUND;
        JButton backgroundColorButton = new JButton("Background...");
        backgroundColorButton.setFocusable(false);
        backgroundColorButton.setActionCommand("background color");
        backgroundColorButton.addActionListener(this);
        JPanel backgroundSwatchPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(new Color(MarkupPanel.this.backgroundColor.getRed(), MarkupPanel.this.backgroundColor.getGreen(), MarkupPanel.this.backgroundColor.getBlue()));
                g.fillRect(0, 0, 21, 21);
                g.setColor(Color.DARK_GRAY);
                g.drawRect(0, 0, 21, 21);
            }
        };
        backgroundSwatchPanel.setPreferredSize(new Dimension(22, 22));
        backgroundSwatchPanel.setMaximumSize(backgroundSwatchPanel.getPreferredSize());
        backgroundSwatchPanel.setMinimumSize(backgroundSwatchPanel.getPreferredSize());
        JPanel backgroundColorPanel = new JPanel();
        backgroundColorPanel.setLayout(new BoxLayout(backgroundColorPanel, 0));
        backgroundColorPanel.add(backgroundColorButton);
        backgroundColorPanel.add(Box.createHorizontalStrut(2));
        backgroundColorPanel.add(backgroundSwatchPanel);
        this.allButton = new JRadioButton("All");
        this.allButton.setFocusable(false);
        this.allButton.setActionCommand(ACTION_UPDATE_TEXT);
        this.allButton.addActionListener(this);
        this.firstButton = new JRadioButton("Partial");
        this.firstButton.setFocusable(false);
        this.firstButton.setActionCommand(ACTION_UPDATE_TEXT);
        this.firstButton.addActionListener(this);
        this.otherButton = new JRadioButton("Custom");
        this.otherButton.setFocusable(false);
        this.otherButton.setActionCommand(ACTION_UPDATE_TEXT);
        this.otherButton.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.allButton);
        group.add(this.firstButton);
        group.add(this.otherButton);
        this.firstButton.setSelected(true);
        this.otherText = new JTextField("", 18);
        this.otherText.setEnabled(false);
        this.otherText.setMaximumSize(this.otherText.getPreferredSize());
        JPanel sliceLabelsPanel = new JPanel();
        sliceLabelsPanel.setLayout(new BoxLayout(sliceLabelsPanel, 0));
        sliceLabelsPanel.add(Box.createHorizontalGlue());
        sliceLabelsPanel.add(this.allButton);
        sliceLabelsPanel.add(this.firstButton);
        sliceLabelsPanel.add(this.otherButton);
        sliceLabelsPanel.add(this.otherText);
        sliceLabelsPanel.add(Box.createHorizontalGlue());
        sliceLabelsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Slice Labels"));
        JLabel titleBoxLabel = new JLabel("Title:");
        this.titleBox = new JComboBox<String>(CollectionUtilities.array(LOC_CHOICES));
        this.titleBox.setFocusable(false);
        this.titleBox.setSelectedItem(LOC_CHOICES.get(0));
        this.titleBox.setPrototypeDisplayValue(LOC_CHOICES.get(0));
        this.titleBox.setMaximumSize(this.titleBox.getPreferredSize());
        this.titleBox.setMinimumSize(this.titleBox.getPreferredSize());
        if (Platform.WINDOWS) {
            this.titleBox.setBackground(Color.WHITE);
        }
        JPanel titleBoxPanel = new JPanel();
        titleBoxPanel.setLayout(new BoxLayout(titleBoxPanel, 0));
        titleBoxPanel.add(titleBoxLabel);
        titleBoxPanel.add(Box.createHorizontalStrut(2));
        titleBoxPanel.add(this.titleBox);
        JLabel footnoteBoxLabel = new JLabel("Footnote:");
        this.footnoteBox = new JComboBox<String>(CollectionUtilities.array(LOC_CHOICES));
        this.footnoteBox.setFocusable(false);
        this.footnoteBox.setSelectedItem(LOC_CHOICES.get(0));
        this.footnoteBox.setPrototypeDisplayValue(LOC_CHOICES.get(0));
        this.footnoteBox.setMaximumSize(this.footnoteBox.getPreferredSize());
        this.footnoteBox.setMinimumSize(this.footnoteBox.getPreferredSize());
        if (Platform.WINDOWS) {
            this.footnoteBox.setBackground(Color.WHITE);
        }
        JPanel footnoteBoxPanel = new JPanel();
        footnoteBoxPanel.setLayout(new BoxLayout(footnoteBoxPanel, 0));
        footnoteBoxPanel.add(footnoteBoxLabel);
        footnoteBoxPanel.add(Box.createHorizontalStrut(2));
        footnoteBoxPanel.add(this.footnoteBox);
        JPanel positionPanel = new JPanel();
        positionPanel.setLayout(new BoxLayout(positionPanel, 1));
        positionPanel.add(titleBoxPanel);
        positionPanel.add(footnoteBoxPanel);
        JPanel positionPanelOut = new JPanel();
        positionPanelOut.setLayout(new BoxLayout(positionPanelOut, 0));
        positionPanelOut.add(Box.createHorizontalGlue());
        positionPanelOut.add(positionPanel);
        positionPanelOut.add(Box.createHorizontalGlue());
        positionPanelOut.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Positions"));
        JLabel titleBoxLabel2 = new JLabel("Title:");
        this.titleFontBox = new JComboBox<String>(CollectionUtilities.array(Layout.FONTS));
        this.titleFontBox.setFocusable(false);
        this.titleFontBox.setSelectedItem(Layout.FONTS.get(7));
        this.titleFontBox.setPrototypeDisplayValue(Layout.FONTS.get(7));
        this.titleFontBox.setMaximumSize(this.titleFontBox.getPreferredSize());
        this.titleFontBox.setMinimumSize(this.titleFontBox.getPreferredSize());
        if (Platform.WINDOWS) {
            this.titleFontBox.setBackground(Color.WHITE);
        }
        JPanel titleFontBoxPanel = new JPanel();
        titleFontBoxPanel.setLayout(new BoxLayout(titleFontBoxPanel, 0));
        titleFontBoxPanel.add(titleBoxLabel2);
        titleFontBoxPanel.add(Box.createHorizontalStrut(2));
        titleFontBoxPanel.add(this.titleFontBox);
        JLabel footnoteBoxLabel2 = new JLabel("Footnote:");
        this.footnoteFontBox = new JComboBox<String>(CollectionUtilities.array(Layout.FONTS));
        this.footnoteFontBox.setFocusable(false);
        this.footnoteFontBox.setSelectedItem(Layout.FONTS.get(7));
        this.footnoteFontBox.setPrototypeDisplayValue(Layout.FONTS.get(7));
        this.footnoteFontBox.setMaximumSize(this.footnoteFontBox.getPreferredSize());
        this.footnoteFontBox.setMinimumSize(this.footnoteFontBox.getPreferredSize());
        if (Platform.WINDOWS) {
            this.footnoteFontBox.setBackground(Color.WHITE);
        }
        JPanel footnoteFontBoxPanel = new JPanel();
        footnoteFontBoxPanel.setLayout(new BoxLayout(footnoteFontBoxPanel, 0));
        footnoteFontBoxPanel.add(footnoteBoxLabel2);
        footnoteFontBoxPanel.add(Box.createHorizontalStrut(2));
        footnoteFontBoxPanel.add(this.footnoteFontBox);
        JPanel fontPanel = new JPanel();
        fontPanel.setLayout(new BoxLayout(fontPanel, 1));
        fontPanel.add(titleFontBoxPanel);
        fontPanel.add(footnoteFontBoxPanel);
        JPanel fontPanelOut = new JPanel();
        fontPanelOut.setLayout(new BoxLayout(fontPanelOut, 0));
        fontPanelOut.add(Box.createHorizontalGlue());
        fontPanelOut.add(fontPanel);
        fontPanelOut.add(Box.createHorizontalGlue());
        fontPanelOut.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Fonts"));
        JPanel firstRowPanel = new JPanel();
        firstRowPanel.setLayout(new BoxLayout(firstRowPanel, 0));
        firstRowPanel.add(Box.createHorizontalGlue());
        firstRowPanel.add(titleColorPanel);
        firstRowPanel.add(Box.createHorizontalGlue());
        firstRowPanel.add(footnoteColorPanel);
        firstRowPanel.add(Box.createHorizontalGlue());
        JPanel secondRowPanel = new JPanel();
        secondRowPanel.setLayout(new BoxLayout(secondRowPanel, 0));
        secondRowPanel.add(Box.createHorizontalGlue());
        secondRowPanel.add(slicesColorPanel);
        secondRowPanel.add(Box.createHorizontalGlue());
        secondRowPanel.add(barsColorPanel);
        secondRowPanel.add(Box.createHorizontalGlue());
        JPanel thirdRowPanel = new JPanel();
        thirdRowPanel.setLayout(new BoxLayout(thirdRowPanel, 0));
        thirdRowPanel.add(Box.createHorizontalGlue());
        thirdRowPanel.add(orientColorPanel);
        thirdRowPanel.add(Box.createHorizontalGlue());
        thirdRowPanel.add(backgroundColorPanel);
        thirdRowPanel.add(Box.createHorizontalGlue());
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new BoxLayout(colorPanel, 1));
        colorPanel.add(firstRowPanel);
        colorPanel.add(secondRowPanel);
        colorPanel.add(thirdRowPanel);
        colorPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TEXT_COLORS));
        JPanel middleRowPanel = new JPanel();
        middleRowPanel.setLayout(new BoxLayout(middleRowPanel, 0));
        middleRowPanel.add(positionPanelOut);
        middleRowPanel.add(fontPanelOut);
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalGlue());
        this.add(colorPanel);
        this.add(Box.createVerticalGlue());
        this.add(middleRowPanel);
        this.add(Box.createVerticalGlue());
        this.add(sliceLabelsPanel);
        this.add(Box.createVerticalGlue());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals(ACTION_UPDATE_TEXT)) {
            this.otherText.setEnabled(this.otherButton.isSelected());
        } else if (command.equals("title color")) {
            this.currentColor = this.titleColor;
            this.colorChooser = new JColorChooser(this.currentColor);
            JDialog dialog = JColorChooser.createDialog(this, TEXT_COLORS, true, this.colorChooser, this, this);
            dialog.setVisible(true);
        } else if (command.equals("footnote color")) {
            this.currentColor = this.footnoteColor;
            this.colorChooser = new JColorChooser(this.currentColor);
            JDialog dialog = JColorChooser.createDialog(this, TEXT_COLORS, true, this.colorChooser, this, this);
            dialog.setVisible(true);
        } else if (command.equals("slices color")) {
            this.currentColor = this.slicesColor;
            this.colorChooser = new JColorChooser(this.currentColor);
            JDialog dialog = JColorChooser.createDialog(this, TEXT_COLORS, true, this.colorChooser, this, this);
            dialog.setVisible(true);
        } else if (command.equals("orient color")) {
            this.currentColor = this.orientColor;
            this.colorChooser = new JColorChooser(this.currentColor);
            JDialog dialog = JColorChooser.createDialog(this, TEXT_COLORS, true, this.colorChooser, this, this);
            dialog.setVisible(true);
        } else if (command.equals("bars color")) {
            this.currentColor = this.barsColor;
            this.colorChooser = new JColorChooser(this.currentColor);
            JDialog dialog = JColorChooser.createDialog(this, TEXT_COLORS, true, this.colorChooser, this, this);
            dialog.setVisible(true);
        } else if (command.equals("background color")) {
            this.currentColor = this.backgroundColor;
            this.colorChooser = new JColorChooser(this.currentColor);
            JDialog dialog = JColorChooser.createDialog(this, TEXT_COLORS, true, this.colorChooser, this, this);
            dialog.setVisible(true);
        } else if (command.equals("OK")) {
            if (this.currentColor == this.titleColor) {
                this.titleColor = this.colorChooser.getColor();
            } else if (this.currentColor == this.footnoteColor) {
                this.footnoteColor = this.colorChooser.getColor();
            } else if (this.currentColor == this.slicesColor) {
                this.slicesColor = this.colorChooser.getColor();
            } else if (this.currentColor == this.orientColor) {
                this.orientColor = this.colorChooser.getColor();
            } else if (this.currentColor == this.barsColor) {
                this.barsColor = this.colorChooser.getColor();
            } else if (this.currentColor == this.backgroundColor) {
                this.backgroundColor = this.colorChooser.getColor();
            }
            this.repaint();
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getBarsColor() {
        return this.barsColor;
    }

    public Color getFootnoteColor() {
        return this.footnoteColor;
    }

    public int getFootnoteFontCode() {
        return this.footnoteFontBox.getSelectedIndex();
    }

    public int getFootnoteLocation() {
        return this.footnoteBox.getSelectedIndex();
    }

    public Color getOrientColor() {
        return this.orientColor;
    }

    public int getShowSlicesType() {
        if (this.allButton.isSelected()) {
            return 0;
        }
        if (this.firstButton.isSelected()) {
            return 1;
        }
        return 2;
    }

    public Color getSlicesColor() {
        return this.slicesColor;
    }

    public String getSliceText() {
        return this.otherText.getText();
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public int getTitleFontCode() {
        return this.titleFontBox.getSelectedIndex();
    }

    public int getTitleLocation() {
        return this.titleBox.getSelectedIndex();
    }

    public boolean isOtherSliceText() {
        return this.otherButton.isSelected();
    }

    public void setAllSliceLabels(boolean bool) {
        this.allButton.setSelected(bool);
    }

    public void setPartialSliceLabels(boolean bool) {
        this.firstButton.setSelected(bool);
    }

    public void updateSlicesText(final String string) {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                if (string != null && !MarkupPanel.this.otherButton.isSelected()) {
                    MarkupPanel.this.otherText.setText(string);
                }
            }
        });
    }
}

