/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.imageinfo;

import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.dialogs.imageinfo.ImageInfoDialog;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.formats.nifti.NIFTI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class SummaryPanel
extends JPanel {
    private JTextArea message;
    private final MangoNumberFormatter formatter = new MangoNumberFormatter();
    private final URI uriLoaded;
    private final SliceViewer viewer;
    private final Volume volume;
    private static final long serialVersionUID = 1L;
    public static final Font HELP_FONT = new Font("SansSerif", 0, 12);
    public static final int NUM_COLS = 0;
    public static final String TEXT_TO = " x ";

    protected SummaryPanel(SliceViewer viewer, URI uriLoaded, Volume volume) {
        this.viewer = viewer;
        this.volume = volume;
        this.uriLoaded = uriLoaded;
        this.createPanel();
    }

    public JTextArea getTextArea() {
        return this.message;
    }

    private void createPanel() {
        boolean isFile;
        URI[] uris;
        boolean isSameFile;
        boolean currentSlice = false;
        URI uri = this.uriLoaded;
        URI uriImage = this.volume.getImageFile();
        boolean isMultiFile = this.volume.getMultiImageFiles() != null;
        boolean bl = isSameFile = uri == null || uri.equals(uriImage);
        if (isMultiFile && (uris = this.volume.getMultiImageFiles()) != null && uris.length > 0 && uris[0] != null) {
            uriImage = uris[0];
            for (URI uri2 : uris) {
                if (!uri.equals(uri2)) continue;
                isSameFile = true;
                uri = uriImage;
                break;
            }
        }
        boolean fileExists = (isFile = FileUtilities.uriIsFile((URI)uri)) && FileUtilities.exists((URI)uri);
        boolean isRawImageOpen = this.volume.getLoadedHeaderType() == null && fileExists;
        boolean isTempImage = this.viewer.isTempImage();
        boolean isVariableSpacing = this.viewer.getVolume().isVariableSliceSpacing();
        boolean isVariableTiming = this.viewer.getVolume().isVariableVolumeTiming();
        byte[] hdrExt = this.viewer.getVolume().getExtension();
        boolean hasExtension = hdrExt != null;
        this.message = new JTextArea();
        this.message.setLineWrap(true);
        this.message.setColumns(0);
        this.message.setEditable(false);
        this.message.setFont(HELP_FONT);
        this.message.setSize(ImageInfoDialog.START_SIZE.width - 50, ImageInfoDialog.START_SIZE.height - 50);
        long imageFileSize = 0L;
        if (fileExists) {
            imageFileSize = new File(uriImage.getPath()).length();
        }
        if (isTempImage && !isRawImageOpen) {
            this.message.append("Name: (No loaded file.)\n");
        } else {
            if (isRawImageOpen) {
                this.message.append("Header Filename: (No loaded header.)\n");
                this.message.append("Image Filename: " + FileUtilities.getName((URI)uriImage) + "\n");
            } else if (isSameFile) {
                this.message.append("Filename: " + FileUtilities.getName((URI)uri) + "\n");
            } else {
                this.message.append("Header Filename: " + FileUtilities.getName((URI)uri) + "\n");
                this.message.append("Image Filename: " + FileUtilities.getName((URI)uriImage) + "\n");
            }
            if (isFile && !this.viewer.getMango().isApplet()) {
                this.message.append("Working Directory: " + FileUtilities.getParent((URI)uri) + "\n");
                this.message.append("File Privileges: " + (FileUtilities.canRead((URI)uri) ? "READ " : "") + (FileUtilities.canWrite((URI)uri) && !this.volume.cannotBeOverwritten() ? "WRITE " : "") + "\n");
            } else {
                this.message.append("Location: " + FileUtilities.getParent((URI)uri) + "\n");
                this.message.append("File Privileges: READ\n");
            }
        }
        if (!isMultiFile && imageFileSize > 0L) {
            String imageFileSizeString = StringUtilities.makeNiceFileSizeString((long)imageFileSize);
            this.message.append("File Size: " + imageFileSizeString + "\n");
        }
        this.message.append("\n");
        String orientationStr = this.volume.getOrientationString().substring(0, 3);
        ImageDimensions id = this.volume.getImageDimensions();
        this.message.append("Image Dimensions (" + orientationStr.charAt(0) + ", " + orientationStr.charAt(1) + ", " + orientationStr.charAt(2) + "): " + id.getCols() + TEXT_TO + id.getRows() + TEXT_TO + id.getSlices() + (isVariableSpacing ? " (resized)\n" : "\n"));
        VoxelDimensions vd = this.volume.getVoxelDimensions();
        String spaceSizeStr = NIFTI.getNiftiUnitString(this.volume.getVoxelDimensions().getSpatialUnit());
        if (spaceSizeStr.equals(VoxelDimensions.UNIT_STRING[0])) {
            spaceSizeStr = "(Unit Unknown)";
        }
        if (this.volume.isLoadedSeriesAsSinglePoint()) {
            this.message.append("Series Length: " + this.volume.getSeriesOffsetOriginalRange() + " (Loaded " + (this.volume.getSeriesOffset() + 1) + " to " + (this.volume.getSeriesOffset() + 1) + ")\n\n");
        } else if (this.volume.isLoadedSeriesAsSubset()) {
            this.message.append("Series Length: " + this.volume.getSeriesOffsetOriginalRange() + " (Loaded " + (this.volume.getSeriesOffset() + 1) + " to " + (this.volume.getSeriesOffset() + 1 + this.volume.getSeriesOffsetRange() - 1) + ")\n\n");
        } else {
            this.message.append("Series Length: " + this.volume.getNumTimepoints() + "\n");
        }
        this.message.append("Voxel Dimensions (" + orientationStr.charAt(0) + ", " + orientationStr.charAt(1) + ", " + orientationStr.charAt(2) + "): " + this.formatter.format(vd.getColSize(true)) + TEXT_TO + this.formatter.format(vd.getRowSize(true)) + TEXT_TO + this.formatter.format(vd.getSliceThickness(true)) + " " + spaceSizeStr + (isVariableSpacing ? "(variable)\n" : "\n"));
        String timeSizeStr = NIFTI.getNiftiUnitString(this.volume.getVoxelDimensions().getTemporalUnit());
        if (timeSizeStr.equals(NIFTI.getNiftiUnitString(0))) {
            timeSizeStr = "(Unit Unknown)";
        }
        this.message.append("Size of Series Point: " + (isVariableTiming ? "(variable)" : this.formatter.format(this.volume.getVoxelDimensions().getTR())) + " " + timeSizeStr + "\n\n");
        ImageType it = this.volume.getImageType();
        if (it.getNativeType() != null) {
            it = it.getNativeType();
        }
        this.message.append("Byte Type: " + it.getNumBytesPerVoxel() + "-Byte " + it.getByteTypeString() + "\n");
        if (it.getNumBytesPerVoxel() > 1) {
            this.message.append("Byte Order: " + (it.isLittleEndian() ? "Little Endian" : "Big Endian") + "\n");
        }
        this.message.append("Compression: " + (this.volume.isCompressed() ? it.getCompressionTypeString() : "None") + "\n");
        this.message.append("\n");
        this.message.append("Data Orientation: " + this.volume.getOrientationDescription() + "\n");
        this.message.append("\n");
        this.message.append("Image ID: " + this.volume.getAllImageID(this.viewer.getSliceNumberInSliceDirection()) + "\n");
        this.message.append("Image Date: " + this.volume.getAllImageTime(this.viewer.getSliceNumberInSliceDirection()) + "\n");
        this.message.append("Notes: " + this.volume.getImageDescription(this.viewer.getSliceNumberInSliceDirection()) + "\n");
        if (hasExtension) {
            this.message.append("This image contains extension data.\n");
        }
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setBackground(Color.WHITE);
        this.add((Component)this.message, "Center");
    }
}

