/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.imageinfo;

import edu.uthscsa.ric.utilities.AppLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;

public class Search
implements Callable<List<Integer>> {
    private List<Integer> dataOffsets;
    private final Document document;
    private final String searchString;

    protected Search(Document document, String searchString) {
        this.document = document;
        this.searchString = searchString.toLowerCase();
    }

    @Override
    public List<Integer> call() {
        this.search();
        return this.dataOffsets;
    }

    private void search() {
        ArrayList<Integer> lineOffsets = new ArrayList<Integer>();
        this.dataOffsets = new ArrayList<Integer>();
        Element element = this.document.getDefaultRootElement();
        int elementCount = element.getElementCount();
        for (int i = 0; i < elementCount; ++i) {
            lineOffsets.add(element.getElement(i).getStartOffset());
        }
        lineOffsets.add(element.getElement(element.getElementCount() - 1).getEndOffset());
        int count = 0;
        while (count < lineOffsets.size() - 1) {
            int lsOffset = (Integer)lineOffsets.get(count);
            int leOffset = (Integer)lineOffsets.get(count + 1);
            ++count;
            Segment seg = new Segment();
            try {
                this.document.getText(lsOffset, leOffset - lsOffset, seg);
            }
            catch (BadLocationException ex) {
                AppLogger.warn((Throwable)ex);
            }
            String line = seg.toString().toLowerCase();
            int mark = 0;
            while ((mark = line.indexOf(this.searchString, mark)) > -1) {
                this.dataOffsets.add(lsOffset + mark);
                mark += this.searchString.length();
            }
        }
    }
}

