/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.imageinfo;

import edu.uthscsa.ric.mango.SliceListener;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.dialogs.imageinfo.ImageInfoDialog;
import edu.uthscsa.ric.mango.viewerslice.dialogs.imageinfo.Search;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.volume.Volume;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import org.apache.commons.lang3.StringUtils;

public class HeaderPanel
extends JPanel
implements ActionListener,
SliceListener {
    private JScrollPane scrollerFormat;
    private JTextArea messageFormat;
    private JTextField searchText;
    private final SliceViewer viewer;
    private final Volume volume;
    private boolean hasBeenViewed;
    private int lastFound;
    private static final long serialVersionUID = 1L;
    public static final DefaultHighlighter.DefaultHighlightPainter PAINTER_YELLOW = new DefaultHighlighter.DefaultHighlightPainter(new Color(255, 255, 0, 128));
    public static final DefaultHighlighter.DefaultHighlightPainter PAINTER_YELLOW_CURRENT = new DefaultHighlighter.DefaultHighlightPainter(Color.RED);
    public static final Font HELP_FONT = new Font("SansSerif", 0, 12);
    public static final int NUM_COLS = 0;
    public static final String ACTION_FIND = "Find";
    public static final String ACTION_EDIT = "Edit...";

    protected HeaderPanel(SliceViewer viewer, Volume volume) {
        this.viewer = viewer;
        this.volume = volume;
        viewer.addSliceListener(this, viewer.getNativeSliceDirection());
        this.createPanel();
        this.updateInfo();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals(ACTION_FIND)) {
            JTextArea textArea = this.messageFormat;
            Cursor startCursor = textArea.getCursor();
            Cursor waitCursor = new Cursor(3);
            Highlighter highlighter = textArea.getHighlighter();
            String searchStr = this.searchText.getText();
            if (searchStr.length() > 0) {
                Search search = new Search(textArea.getDocument(), searchStr);
                textArea.setCursor(waitCursor);
                this.removeAllHighlights();
                ExecutorService service = Executors.newSingleThreadExecutor();
                Future<List<Integer>> offsets = service.submit(search);
                try {
                    Rectangle firstRect = null;
                    int firstFound = 0;
                    Rectangle currentRect = null;
                    for (Integer start : offsets.get()) {
                        Rectangle rect = textArea.getUI().modelToView(textArea, start);
                        if (firstRect == null) {
                            firstRect = rect;
                            firstFound = start;
                        }
                        if (currentRect == null && start > this.lastFound) {
                            currentRect = rect;
                            this.lastFound = start;
                        }
                        highlighter.addHighlight(start, start + searchStr.length(), PAINTER_YELLOW);
                    }
                    if (currentRect != null) {
                        textArea.scrollRectToVisible(currentRect);
                        highlighter.addHighlight(this.lastFound, this.lastFound + searchStr.length(), PAINTER_YELLOW_CURRENT);
                    } else if (firstRect != null) {
                        textArea.scrollRectToVisible(firstRect);
                        this.lastFound = firstFound;
                        highlighter.addHighlight(this.lastFound, this.lastFound + searchStr.length(), PAINTER_YELLOW_CURRENT);
                    }
                }
                catch (Exception ex) {
                    AppLogger.error((Throwable)ex);
                }
                textArea.setCursor(startCursor);
            }
        } else if (command.equals(ACTION_EDIT)) {
            this.viewer.getMango().openHeaderEditor(this.viewer.getLoadedFile(), this.viewer);
        }
    }

    public JScrollPane getScrollPane() {
        return this.scrollerFormat;
    }

    public JTextArea getTextArea() {
        return this.messageFormat;
    }

    public void setHasBeenViewed(boolean hasBeenViewed) {
        this.hasBeenViewed = hasBeenViewed;
    }

    public void sliceChanged(int slicePos, int sliceDirection, boolean isMain) {
        this.updateInfo();
    }

    private void createPanel() {
        JPanel formatPanel = new JPanel();
        formatPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        formatPanel.setBackground(Color.WHITE);
        this.messageFormat = new JTextArea();
        this.messageFormat.setLineWrap(true);
        this.messageFormat.setColumns(0);
        this.messageFormat.setFont(HELP_FONT);
        this.messageFormat.setEditable(false);
        this.messageFormat.setSize(ImageInfoDialog.START_SIZE.width - 50, ImageInfoDialog.START_SIZE.height - 50);
        ((DefaultCaret)this.messageFormat.getCaret()).setUpdatePolicy(1);
        formatPanel.add((Component)this.messageFormat, "Center");
        this.scrollerFormat = new JScrollPane(formatPanel);
        this.scrollerFormat.getVerticalScrollBar().setUnitIncrement(20);
        this.scrollerFormat.setHorizontalScrollBarPolicy(31);
        this.searchText = new JTextField("", 14);
        this.searchText.addActionListener(this);
        this.searchText.setActionCommand(ACTION_FIND);
        this.searchText.setMinimumSize(this.searchText.getPreferredSize());
        this.searchText.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.searchText.getPreferredSize().height));
        JButton searchButton = new JButton(ACTION_FIND);
        searchButton.setActionCommand(ACTION_FIND);
        searchButton.addActionListener(this);
        JButton editButton = new JButton(ACTION_EDIT);
        editButton.setActionCommand(ACTION_EDIT);
        editButton.addActionListener(this);
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new BoxLayout(searchPanel, 0));
        searchPanel.add(Box.createHorizontalStrut(8));
        searchPanel.add(this.searchText);
        searchPanel.add(Box.createHorizontalStrut(2));
        searchPanel.add(searchButton);
        searchPanel.add(Box.createHorizontalStrut(2));
        searchPanel.add(editButton);
        searchPanel.add(Box.createHorizontalStrut(8));
        searchPanel.setMinimumSize(searchPanel.getPreferredSize());
        searchPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, searchPanel.getPreferredSize().height));
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.scrollerFormat);
        this.add(Box.createVerticalStrut(3));
        this.add(searchPanel);
        this.add(Box.createVerticalStrut(2));
    }

    private void removeAllHighlights() {
        this.messageFormat.getHighlighter().removeAllHighlights();
    }

    private void updateInfo() {
        int timepoint = this.viewer.getCurrentTimepoint();
        int slice = this.viewer.getCurrentSliceNativeOrder();
        String headerInfo = this.volume.getSliceMetadata(slice, timepoint);
        if (StringUtils.isBlank((CharSequence)headerInfo)) {
            headerInfo = this.volume.getFormatSpecificInfo();
        }
        if (StringUtils.isBlank((CharSequence)headerInfo)) {
            headerInfo = "No header available.";
        }
        StringBuffer sb = new StringBuffer(32);
        sb.append("File Format: ").append(this.volume.getLoadedHeaderType()).append("\n-----\n").append(headerInfo.trim()).append("\n-----\n");
        this.messageFormat.setText(sb.toString());
    }

    protected boolean hasBeenViewed() {
        return this.hasBeenViewed;
    }

    protected void resetLastFound() {
        this.lastFound = 0;
    }
}

