/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.crosssection;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoSquareButton;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.dialogs.modal.file.SaveFileDialog;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.mango.viewerslice.dialogs.crosssection.Crosssection;
import edu.uthscsa.ric.roi.Line;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CrosssectionTool
extends JFrame
implements ActionListener,
ViewerAssociated {
    private Crosssection crosssection;
    private JButton clearButton;
    private JButton keepButton;
    private JButton nextButton;
    private JButton previousButton;
    private JComboBox<String> showBox;
    private JLabel multiplierLabel;
    private JRadioButton mmButton;
    private JTextField multiplier;
    private final Mango mango;
    private final SliceViewer viewer;
    private static final long serialVersionUID = 1L;
    public static final Dimension CROSSSECTION_SIZE = new Dimension(425, 210);
    public static final String DESCRIPTION = "Cross-section";
    public static final String ACTION_TYPE = "Type";
    public static final int MINIMUM_HEIGHT = 375;
    public static final int MINIMUM_WIDTH = 500;

    public CrosssectionTool(Mango mango, SliceViewer viewer) {
        this.mango = mango;
        this.viewer = viewer;
        this.createUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals("next")) {
            this.crosssection.nextShape();
            this.crosssection.navigateViewerToCurrentShape();
            this.viewer.repaint();
        } else if (command.equals("prev")) {
            this.crosssection.prevShape();
            this.viewer.repaint();
        } else if (command.equals("keep")) {
            this.crosssection.keep();
        } else if (command.equals("clear")) {
            this.crosssection.resetYAxis();
            this.crosssection.clear();
        } else if (command.equals("show box")) {
            int selectedIndex = this.showBox.getSelectedIndex();
            this.crosssection.resetYAxis();
            if (selectedIndex == 0) {
                this.crosssection.setAsDataMode();
            } else if (selectedIndex == 1) {
                this.crosssection.setAsDerivativesMode();
            } else if (selectedIndex == 2) {
                this.crosssection.setAsCumulativesMode();
            }
        } else if (ae.getActionCommand().equals("cameraButton")) {
            boolean isShiftDown = (ae.getModifiers() & 1) != 0;
            this.mango.doCapture(isShiftDown, this.crosssection);
        } else if (ae.getActionCommand().equals("export")) {
            if (!this.crosssection.canKeep()) {
                return;
            }
            File oldFile = this.viewer.getLoadedFile();
            String fileName = oldFile.getName();
            File selectedFile = null;
            File startFile = null;
            startFile = fileName.indexOf(46) != -1 ? new File(oldFile.getParent(), fileName.substring(0, fileName.indexOf(46)) + "_crosssection.csv") : new File(oldFile.getParent(), fileName + "_crosssection.csv");
            selectedFile = SaveFileDialog.showSaveFileChooser(this, this.viewer.getSaveDirectory(), startFile.getName());
            if (selectedFile != null) {
                try (PrintWriter writer = null;){
                    writer = new PrintWriter(new BufferedWriter(new FileWriter(selectedFile)));
                    double[][] data = this.crosssection.getAllData();
                    Line[] shapes = this.crosssection.getShapes();
                    StringBuffer labels = new StringBuffer("\"" + shapes[0].getLabel(true) + "\"");
                    for (int ctrS = 1; ctrS < data.length; ++ctrS) {
                        labels.append(",\"" + shapes[ctrS].getLabel(true) + "\"");
                    }
                    writer.println(labels.toString());
                    int longest = data[0].length;
                    for (int ctrS = 1; ctrS < data.length; ++ctrS) {
                        if (data[ctrS].length <= longest) continue;
                        longest = data[ctrS].length;
                    }
                    for (int ctr = 0; ctr < longest; ++ctr) {
                        StringBuffer sb = new StringBuffer();
                        if (ctr < data[0].length) {
                            sb.append(data[0][ctr]);
                        }
                        for (int ctrS = 1; ctrS < data.length; ++ctrS) {
                            if (ctr < data[ctrS].length) {
                                sb.append(',');
                                sb.append(data[ctrS][ctr]);
                                continue;
                            }
                            sb.append(',');
                        }
                        writer.println(sb.toString());
                    }
                }
            }
        } else if (ae.getActionCommand().equals(ACTION_TYPE)) {
            this.crosssection.clear();
            this.updateMillimeterMode();
            this.updateMultiplier();
            this.crosssection.updateCrosssection();
            this.viewer.repaint();
            this.requestFocus();
        }
        this.updateButtons();
    }

    public void setCurrentState(boolean millimeterMode) {
        this.mmButton.setSelected(millimeterMode);
        this.updateMillimeterMode();
    }

    public void setCurrentState(boolean millimeterMode, double mul) {
        this.mmButton.setSelected(millimeterMode);
        this.updateMillimeterMode();
        this.multiplier.setText(String.valueOf(mul));
        this.updateMultiplier();
    }

    private void updateMillimeterMode() {
        this.crosssection.setMillimeterMode(this.mmButton.isSelected());
    }

    private void updateMultiplier() {
        this.multiplier.setEnabled(this.mmButton.isSelected());
        this.multiplierLabel.setEnabled(this.mmButton.isSelected());
        double mul = 1.0;
        try {
            mul = Double.parseDouble(this.multiplier.getText());
            if (mul == 0.0) {
                mul = this.crosssection.getMultiplier();
            }
        }
        catch (NumberFormatException ex) {
            AppLogger.warn((Throwable)ex);
            mul = this.crosssection.getMultiplier();
        }
        this.crosssection.setMultiplier(mul);
        this.multiplier.setText(String.valueOf(mul));
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public SliceViewer getViewer() {
        return this.viewer;
    }

    @Override
    public JFrame getWindow() {
        return this;
    }

    protected void selectionChanged() {
        this.updateButtons();
    }

    private void createUI() {
        this.crosssection = this.viewer.getCrosssection();
        this.crosssection.setParentFrame(this);
        JRadioButton useROIButton = new JRadioButton("ROI");
        useROIButton.setActionCommand("roi");
        useROIButton.addActionListener(this);
        useROIButton.setVerticalTextPosition(0);
        useROIButton.setHorizontalTextPosition(4);
        JPanel useROIPanel = new JPanel();
        useROIPanel.add(useROIButton);
        this.clearButton = new JButton("Clear Copies");
        this.clearButton.setActionCommand("clear");
        this.clearButton.addActionListener(this);
        this.clearButton.setPreferredSize(new Dimension(120, this.clearButton.getPreferredSize().height));
        this.previousButton = new JButton("Previous");
        this.previousButton.setActionCommand("prev");
        this.previousButton.addActionListener(this);
        this.previousButton.setPreferredSize(new Dimension(120, this.clearButton.getPreferredSize().height));
        this.nextButton = new JButton("Next Line");
        this.nextButton.setActionCommand("next");
        this.nextButton.addActionListener(this);
        this.nextButton.setPreferredSize(new Dimension(120, this.clearButton.getPreferredSize().height));
        this.keepButton = new JButton("Store Copy");
        this.keepButton.setActionCommand("keep");
        this.keepButton.addActionListener(this);
        this.keepButton.setPreferredSize(new Dimension(120, this.clearButton.getPreferredSize().height));
        MangoSquareButton exportButton = new MangoSquareButton(MangoStyle.ICON_EXPORT, false, this.mango);
        exportButton.setActionCommand("export");
        exportButton.addActionListener(this);
        JPanel exportButtonPanel = new JPanel();
        exportButtonPanel.setLayout(new BoxLayout(exportButtonPanel, 0));
        exportButtonPanel.add(exportButton);
        MangoSquareButton cameraButton = new MangoSquareButton(MangoStyle.ICON_CAMERA.get(0), false, this.mango);
        cameraButton.setActionCommand("cameraButton");
        cameraButton.addActionListener(this);
        cameraButton.setPressedIcon(MangoStyle.ICON_CAMERA.get(1));
        JPanel cameraPanel = new JPanel();
        cameraPanel.setLayout(new BoxLayout(cameraPanel, 0));
        cameraPanel.add(cameraButton);
        this.showBox = new JComboBox<String>(new String[]{"Data", "Rate", "Cumulative"});
        this.showBox.setActionCommand("show box");
        this.showBox.addActionListener(this);
        this.showBox.setEditable(false);
        this.showBox.setPrototypeDisplayValue(" Cumulative ");
        this.showBox.setMaximumSize(this.showBox.getPreferredSize());
        JRadioButton voxelsButton = new JRadioButton("Voxels");
        voxelsButton.setActionCommand(ACTION_TYPE);
        voxelsButton.addActionListener(this);
        this.mmButton = new JRadioButton("");
        this.mmButton.setActionCommand(ACTION_TYPE);
        this.mmButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(voxelsButton);
        buttonGroup.add(this.mmButton);
        voxelsButton.setSelected(true);
        this.multiplier = new MangoTextField("1.0", 2);
        this.multiplier.setEnabled(false);
        this.multiplier.setActionCommand(ACTION_TYPE);
        this.multiplier.addActionListener(this);
        this.multiplier.setMaximumSize(this.multiplier.getPreferredSize());
        this.multiplierLabel = new JLabel("Millimeters");
        this.multiplierLabel.setEnabled(false);
        JPanel optionsAPanel = new JPanel();
        optionsAPanel.setLayout(new BoxLayout(optionsAPanel, 0));
        optionsAPanel.add(voxelsButton);
        optionsAPanel.add(this.mmButton);
        optionsAPanel.add(this.multiplier);
        optionsAPanel.add(this.multiplierLabel);
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 0));
        optionsPanel.add(Box.createHorizontalGlue());
        optionsPanel.add(optionsAPanel);
        optionsPanel.add(Box.createHorizontalGlue());
        optionsPanel.add(this.showBox);
        optionsPanel.add(Box.createHorizontalGlue());
        if (!this.mango.isApplet()) {
            optionsPanel.add(exportButtonPanel);
            optionsPanel.add(cameraPanel);
            optionsPanel.add(Box.createHorizontalGlue());
        }
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new BoxLayout(lowerPanel, 0));
        lowerPanel.add(Box.createHorizontalGlue());
        lowerPanel.add(this.nextButton);
        lowerPanel.add(Box.createHorizontalGlue());
        lowerPanel.add(this.keepButton);
        lowerPanel.add(Box.createHorizontalGlue());
        lowerPanel.add(this.clearButton);
        lowerPanel.add(Box.createHorizontalGlue());
        JPanel allOptionsPanel = new JPanel();
        allOptionsPanel.setLayout(new BoxLayout(allOptionsPanel, 1));
        allOptionsPanel.add(Box.createVerticalStrut(4));
        allOptionsPanel.add(lowerPanel);
        allOptionsPanel.add(optionsPanel);
        allOptionsPanel.add(Box.createVerticalStrut(4));
        allOptionsPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 75));
        SwingWidgetUtilities.colorBackgroundOfAllComponents((Container)allOptionsPanel, (Color)this.mango.getPanelOutsideColor(), (Class[])new Class[]{JTextField.class});
        cameraPanel.setBackground(Color.WHITE);
        exportButtonPanel.setBackground(Color.WHITE);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        mainPanel.add(this.crosssection);
        mainPanel.add(allOptionsPanel);
        JPanel mainPanelOut = new JPanel(new BorderLayout());
        mainPanelOut.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        mainPanelOut.add((Component)mainPanel, "Center");
        mainPanelOut.setBackground(this.mango.getPanelOutsideColor());
        this.setTitle("Cross-section: " + this.viewer.getImageTitle());
        this.getContentPane().add((Component)mainPanelOut, "Center");
        this.setBackground(this.mango.getPanelOutsideColor());
        this.pack();
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.setLocation(DisplayUtils.getNextWindowLocation(this.viewer.getViewerContainer(), new Dimension(500, 375), null, this.mango.isApplet()));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent ce) {
                Dimension dim = CrosssectionTool.this.getSize();
                if (dim.width < 500 && dim.height >= 375) {
                    CrosssectionTool.this.setSize(500, dim.height);
                } else if (dim.width >= 500 && dim.height < 375) {
                    CrosssectionTool.this.setSize(dim.width, 375);
                } else if (dim.width < 500 && dim.height < 375) {
                    CrosssectionTool.this.setSize(500, 375);
                }
                if (CrosssectionTool.this.getSize().width < 600) {
                    CrosssectionTool.this.multiplierLabel.setText("MM");
                } else {
                    CrosssectionTool.this.multiplierLabel.setText("Millimeters");
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent we) {
                if (CrosssectionTool.this.isVisible()) {
                    CrosssectionTool.this.crosssection.setParentFrame(null);
                    CrosssectionTool.this.crosssection.clearCurrent();
                    CrosssectionTool.this.viewer.repaint();
                }
            }

            @Override
            public void windowClosing(WindowEvent we) {
                if (CrosssectionTool.this.isVisible()) {
                    CrosssectionTool.this.crosssection.setParentFrame(null);
                    CrosssectionTool.this.crosssection.clearCurrent();
                    CrosssectionTool.this.viewer.repaint();
                }
            }

            @Override
            public void windowOpened(WindowEvent we) {
            }
        });
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent we) {
                CrosssectionTool.this.crosssection.setIsPressedState(false);
                CrosssectionTool.this.viewer.repaint();
            }
        });
        this.crosssection.shapeSelectionChanged();
        this.viewer.associateWindow(this);
        this.updateButtons();
        this.setIconImage(MangoStyle.ICON_APP.getImage());
        this.setVisible(true);
        this.validate();
        this.requestFocus();
        this.toFront();
        this.repaint();
    }

    private void updateButtons() {
        this.nextButton.setEnabled(this.crosssection.hasNextShape());
        this.previousButton.setEnabled(this.crosssection.hasPrevShape());
        this.keepButton.setEnabled(this.crosssection.canKeep());
        this.clearButton.setEnabled(this.crosssection.hasKeptValues());
    }
}

