/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.roi;

import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.ClusterRejectionData;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.ClusterStat;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.operations.ClusterOperations;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.roi.ClusterROIManager;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.roi.mask.buffers.AbstractROIBuffer;
import edu.uthscsa.ric.roi.mask.manager.ROIManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import java.awt.Color;
import java.awt.Container;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class ClusterROIAnalysisPanel
extends JPanel
implements ActionListener {
    private JLabel countLabel;
    private JLabel sizeLabel;
    private JSlider countSlider;
    private MangoTextField countText;
    private MangoTextField sizeText;
    private boolean findingClusters;
    private int countSliderLastValue;
    private int roiColor;
    private final ClusterROIManager clusterManager;
    private final MangoNumberFormatter formatter = new MangoNumberFormatter();
    private final SliceViewer viewer;
    private final ROIManager roiManager;
    private static final long serialVersionUID = 1L;
    public static final Color ACTIVE_BACKGROUND = new Color(225, 225, 225);
    public static final Color HIDDEN_BACKGROUND = new Color(175, 175, 175);
    public static final String ACTION_CREATE = "Create stats of clusters";
    public static final String ACTION_DELETE = "Delete filtered clusters";
    public static final String ACTION_FIND = "Find next cluster";
    public static final String ACTION_REMOVE = "Remove filter";
    public static final String ACTION_SPLIT = "Split clusters into ROIs";
    public static final int DEFAULT_CLUSTER_COUNT = 8;
    public static final int HEIGHT = 85;
    public static final int WIDTH = 390;
    private static final long[] MASKS = AbstractROIBuffer.getMasks();

    protected ClusterROIAnalysisPanel(SliceViewer viewer, ClusterROIManager clusterManager) {
        this.viewer = viewer;
        this.roiManager = viewer.getROIManager();
        this.clusterManager = clusterManager;
        this.roiColor = -1;
        this.createUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals("Find Clusters")) {
            this.findClusters(null);
        } else if (command.equals("Size")) {
            this.updateClusterBySize();
        } else if (command.equals("Count")) {
            try {
                int clusterCount = Integer.parseInt(this.countText.getText());
                this.updateClustersByCount(clusterCount);
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
                this.sizeText.setText("0");
                this.countSlider.setValue(0);
            }
        } else if (command.equals(ACTION_CREATE)) {
            this.analyzeClusters(true);
        } else if (command.equals(ACTION_FIND)) {
            this.findNextCluster();
        } else if (command.equals("Disable")) {
            this.disableClusterFilter();
        } else if (command.equals("Enable")) {
            this.enableClusterFilter();
        } else if (command.equals(ACTION_REMOVE)) {
            this.removeClusterFilter();
        } else if (command.equals(ACTION_DELETE)) {
            this.filterROI();
        } else if (command.equals(ACTION_SPLIT)) {
            this.makeROIs();
        }
    }

    public int getNumVisibleComponents() {
        return this.countSlider.getValue();
    }

    public boolean isFiltering() {
        return this.countSlider.getValue() < this.countSlider.getMaximum();
    }

    public int getROIColor() {
        return this.roiColor;
    }

    public void setROIColor(int roiColor) {
        this.roiColor = roiColor;
    }

    protected void analyzeClusters(boolean analyzeAll) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ScreenVolume screenVol = ClusterROIAnalysisPanel.this.viewer.getCurrentScreenVolume();
                Vector<ClusterStat> clusterVec = ClusterOperations.analyzeClusters(ClusterROIAnalysisPanel.this.viewer, screenVol.getVolume(), ClusterROIAnalysisPanel.this.roiManager.getClusterData(ClusterROIAnalysisPanel.this.roiColor));
                int numClustersToDisplay = 0;
                try {
                    numClustersToDisplay = Integer.parseInt(ClusterROIAnalysisPanel.this.countText.getText());
                }
                catch (Exception ex) {
                    AppLogger.info((Throwable)ex);
                }
                ClusterROIAnalysisPanel.printClusters(ClusterROIAnalysisPanel.this.viewer, screenVol, numClustersToDisplay, ClusterROIAnalysisPanel.this.roiColor, clusterVec);
            }
        }, "ClusterAnalysisPanel.analyzeClusters() Thread");
        workThread.start();
    }

    public static void printClusters(final SliceViewer viewer, final ScreenVolume overlay, int numClustersToDisplay, final int roiColor, final Vector<ClusterStat> clusterVec) {
        final int numClustersToDisplayF = numClustersToDisplay;
        if (clusterVec != null) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Iterator it = clusterVec.iterator();
                        int count = 0;
                        while (it.hasNext()) {
                            ClusterStat cluster = (ClusterStat)it.next();
                            if (count >= numClustersToDisplayF) continue;
                            AnalysisImpl analysis = cluster.makeAnalysis(overlay);
                            analysis.setColor(ROIColor.getColor(roiColor));
                            analysis.setUnitSize(viewer.getVolume().getVoxelVolume());
                            analysis.setDescription((viewer.getROIManager().getLabel(roiColor, "") + " " + "Cluster" + " " + (count + 1) + " of " + numClustersToDisplayF).trim());
                            viewer.getMango().getResultsManager().addStatistic(viewer, overlay.getVolume(), analysis);
                            ++count;
                        }
                    }
                });
            }
            catch (InterruptedException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    protected void findClusters(final ClusterROIManager cm) {
        if (this.findingClusters) {
            return;
        }
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ClusterROIAnalysisPanel.this.findingClusters = true;
                ClusterRejectionData crd = ClusterOperations.findClusterROI(ClusterROIAnalysisPanel.this.viewer, ClusterROIAnalysisPanel.this.roiColor);
                ClusterROIAnalysisPanel.this.updateClusterUI(cm, crd);
                ClusterROIAnalysisPanel.this.findingClusters = false;
            }
        }, "ClusterROIAnalysisPanel.findClusters() Thread");
        workThread.start();
    }

    protected void updateClusterUI(final ClusterROIManager cm, final ClusterRejectionData crd) {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                if (crd != null) {
                    int numClusters = crd.clusters.getNumNonZeroClusters();
                    ClusterROIAnalysisPanel.this.countSlider.setMaximum(numClusters);
                    ClusterROIAnalysisPanel.this.countSlider.setMajorTickSpacing(Math.max(numClusters / 10, 1));
                    ClusterROIAnalysisPanel.this.countSlider.setValue(8);
                    ClusterROIAnalysisPanel.this.updateClustersByCount();
                    if (cm != null) {
                        cm.finishedFindingClusters(numClusters);
                    }
                }
            }
        });
    }

    protected void makeROIs() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                double filterValue = 0.0;
                try {
                    filterValue = Double.parseDouble(ClusterROIAnalysisPanel.this.sizeText.getText());
                }
                catch (Exception ex) {
                    AppLogger.info((Throwable)ex);
                }
                double mmVol = ClusterROIAnalysisPanel.this.viewer.getVolume().getXSize() * ClusterROIAnalysisPanel.this.viewer.getVolume().getYSize() * ClusterROIAnalysisPanel.this.viewer.getVolume().getZSize();
                String label = (ClusterROIAnalysisPanel.this.viewer.getROIManager().getLabel(ClusterROIAnalysisPanel.this.roiColor, "") + " " + "Cluster").trim();
                int size = (int)Math.round(filterValue / mmVol);
                ClusterROIAnalysisPanel.this.viewer.recordAction("runComponentSplitROI", new String[]{String.valueOf(ClusterROIAnalysisPanel.this.roiColor), String.valueOf(size)}, true);
                ClusterOperations.makeROIOfCluster(ClusterROIAnalysisPanel.this.viewer.getROIManager(), ClusterROIAnalysisPanel.this.roiManager.getClusterData(ClusterROIAnalysisPanel.this.roiColor), size, MASKS[ClusterROIAnalysisPanel.this.roiColor], label);
                ClusterROIAnalysisPanel.this.clusterManager.finishedSplittingClusters();
            }
        }, "ClusterAnalysisPanel.makeROIs() Thread");
        workThread.start();
    }

    protected void removeClusterFilter() {
        ClusterRejectionData crd = this.roiManager.getClusterData(this.roiColor);
        if (crd != null) {
            crd.cleanup();
            this.roiManager.setClusterData(null, this.roiColor);
            this.viewer.updateROISlices();
            this.viewer.updateScreenSlices();
        }
    }

    protected void updateEnabledState(boolean forceDisable) {
        boolean enabled;
        ClusterRejectionData crd = this.roiManager.getClusterData(this.roiColor);
        boolean bl = enabled = !forceDisable && crd != null;
        if (crd != null) {
            enabled &= crd.clusters.getNumNonZeroClusters() > 1;
        }
        this.countSlider.setEnabled(enabled);
        this.countText.setEnabled(enabled);
        this.sizeText.setEnabled(enabled);
        SystemColor color = enabled ? SystemColor.textText : SystemColor.textInactiveText;
        this.sizeLabel.setForeground(color);
        this.countLabel.setForeground(color);
    }

    private void createUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.countSlider = new JSlider(1, 100, 1);
        this.countSlider.setFocusable(false);
        this.countSlider.setPaintTicks(true);
        this.countSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                int countSliderNewValue = ClusterROIAnalysisPanel.this.countSlider.getValue();
                if (countSliderNewValue != ClusterROIAnalysisPanel.this.countSliderLastValue) {
                    ClusterROIAnalysisPanel.this.countText.setText(String.valueOf(countSliderNewValue));
                    ClusterROIAnalysisPanel.this.updateClustersByCount(countSliderNewValue);
                    ClusterROIAnalysisPanel.this.countSliderLastValue = countSliderNewValue;
                }
            }
        });
        this.countSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                ClusterROIAnalysisPanel.this.updateClusterBySize();
            }
        });
        this.countText = new MangoTextField("", 4);
        this.countText.setFireActionWhenFocusLost(true);
        this.countText.setMinimumSize(this.countText.getPreferredSize());
        this.countText.setMaximumSize(this.countText.getPreferredSize());
        this.countText.addActionListener(this);
        this.countText.setActionCommand("Count");
        JPanel countTextPanel = new JPanel();
        countTextPanel.setLayout(new BoxLayout(countTextPanel, 0));
        countTextPanel.add(Box.createHorizontalGlue());
        countTextPanel.add(this.countText);
        countTextPanel.add(Box.createHorizontalGlue());
        this.countLabel = new JLabel("<html>Rank<sup> </sup></html>", 0);
        JPanel countLabelPanel = new JPanel();
        countLabelPanel.setLayout(new BoxLayout(countLabelPanel, 0));
        countLabelPanel.add(Box.createHorizontalGlue());
        countLabelPanel.add(this.countLabel);
        countLabelPanel.add(Box.createHorizontalGlue());
        JPanel countPanel = new JPanel();
        countPanel.setLayout(new BoxLayout(countPanel, 1));
        countPanel.add(Box.createVerticalGlue());
        countPanel.add(countLabelPanel);
        countPanel.add(countTextPanel);
        countPanel.add(Box.createVerticalGlue());
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new BoxLayout(filterPanel, 1));
        filterPanel.add(Box.createVerticalGlue());
        filterPanel.add(this.countSlider);
        filterPanel.add(Box.createVerticalGlue());
        this.sizeLabel = new JLabel("<html>Size (mm<sup>3</sup>)</html>", 0);
        JPanel sizeLabelPanel = new JPanel();
        sizeLabelPanel.setLayout(new BoxLayout(sizeLabelPanel, 0));
        sizeLabelPanel.add(Box.createHorizontalGlue());
        sizeLabelPanel.add(this.sizeLabel);
        sizeLabelPanel.add(Box.createHorizontalGlue());
        this.sizeText = new MangoTextField("", 6);
        this.sizeText.setFireActionWhenFocusLost(true);
        this.sizeText.setMinimumSize(this.sizeText.getPreferredSize());
        this.sizeText.setMaximumSize(this.sizeText.getPreferredSize());
        this.sizeText.addActionListener(this);
        this.sizeText.setActionCommand("Size");
        JPanel sizeTextPanel = new JPanel();
        sizeTextPanel.setLayout(new BoxLayout(sizeTextPanel, 0));
        sizeTextPanel.add(Box.createHorizontalGlue());
        sizeTextPanel.add(this.sizeText);
        sizeTextPanel.add(Box.createHorizontalGlue());
        JPanel sizePanel = new JPanel();
        sizePanel.setLayout(new BoxLayout(sizePanel, 1));
        sizePanel.add(sizeLabelPanel);
        sizePanel.add(Box.createVerticalStrut(2));
        sizePanel.add(sizeTextPanel);
        JPanel filterControlsPanel = new JPanel();
        filterControlsPanel.setLayout(new BoxLayout(filterControlsPanel, 0));
        filterControlsPanel.add(Box.createHorizontalGlue());
        filterControlsPanel.add(Box.createHorizontalStrut(2));
        filterControlsPanel.add(filterPanel);
        filterControlsPanel.add(Box.createHorizontalStrut(2));
        filterControlsPanel.add(countPanel);
        filterControlsPanel.add(Box.createHorizontalStrut(2));
        filterControlsPanel.add(sizePanel);
        filterControlsPanel.add(Box.createHorizontalStrut(2));
        filterControlsPanel.add(Box.createHorizontalGlue());
        this.add(filterControlsPanel);
        this.add(Box.createHorizontalGlue());
        this.updateEnabledState();
    }

    private void disableClusterFilter() {
        ClusterRejectionData crd = this.roiManager.getClusterData(this.roiColor);
        if (crd != null) {
            crd.hiding = true;
            SwingWidgetUtilities.colorBackgroundOfAllComponents((Container)this, (Color)HIDDEN_BACKGROUND, (Class[])new Class[]{JTextField.class});
            this.viewer.updateScreenSlices();
        }
    }

    private void enableClusterFilter() {
        ClusterRejectionData crd = this.roiManager.getClusterData(this.roiColor);
        if (crd != null) {
            crd.hiding = false;
            SwingWidgetUtilities.colorBackgroundOfAllComponents((Container)this, (Color)ACTIVE_BACKGROUND, (Class[])new Class[]{JTextField.class});
            this.viewer.updateScreenSlices();
        }
    }

    public void filterROI() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ClusterROIAnalysisPanel.this.roiManager.doFilterClusterROI(ClusterROIAnalysisPanel.this.roiManager.getClusterData(ClusterROIAnalysisPanel.this.roiColor), ClusterROIAnalysisPanel.this.roiColor);
                ClusterROIAnalysisPanel.this.clusterManager.finishedFilteringClusters();
            }
        }, "ClusterROIAnalysisPanel.filterROI() Thread");
        workThread.start();
    }

    private void findNextCluster() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                double filterValue = Double.parseDouble(ClusterROIAnalysisPanel.this.sizeText.getText());
                double mmVol = ClusterROIAnalysisPanel.this.viewer.getVolume().getXSize() * ClusterROIAnalysisPanel.this.viewer.getVolume().getYSize() * ClusterROIAnalysisPanel.this.viewer.getVolume().getZSize();
                final Coordinate coord = ClusterOperations.findNextCluster(ClusterROIAnalysisPanel.this.viewer, null, ClusterROIAnalysisPanel.this.roiManager.getClusterData(ClusterROIAnalysisPanel.this.roiColor), ClusterROIAnalysisPanel.this.viewer.getCurrentIndex(null), (int)Math.round(filterValue / mmVol));
                if (coord != null) {
                    SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ClusterROIAnalysisPanel.this.viewer.setCurrentCoordinate(coord, true, 0);
                        }
                    });
                }
            }
        }, "ClusterAnalysisPanel.findNextCluster() Thread");
        workThread.start();
    }

    private void updateClusterBySize() {
        double mmVol = this.viewer.getVolume().getXSize() * this.viewer.getVolume().getYSize() * this.viewer.getVolume().getZSize();
        try {
            double filterValue = Double.parseDouble(this.sizeText.getText());
            this.updateClustersBySize((int)Math.round(filterValue / mmVol), mmVol);
        }
        catch (Exception ex) {
            AppLogger.warn((Throwable)ex);
            this.sizeText.setText("0");
            this.countSlider.setValue(0);
        }
    }

    private void updateClustersByCount() {
        ClusterRejectionData crd = this.roiManager.getClusterData(this.roiColor);
        this.updateClustersByCount(Math.min(8, crd.clusters.getNumNonZeroClusters()));
    }

    private void updateClustersByCount(final int numClusters) {
        double mmVol = this.viewer.getVolume().getXSize() * this.viewer.getVolume().getYSize() * this.viewer.getVolume().getZSize();
        this.countText.setText(String.valueOf(numClusters));
        final ClusterRejectionData crd = this.roiManager.getClusterData(this.roiColor);
        if (crd != null && crd.clusters != null) {
            crd.contains = new boolean[crd.clusters.getNumClusters() + 1];
            double clusterSize = ROIManager.rejectSmallClusters(crd.contains, crd.clusters, numClusters);
            this.countSlider.setValue(numClusters);
            this.sizeText.setText(this.formatter.format(clusterSize * mmVol));
            SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (crd != null && crd.clusters != null) {
                        ClusterROIAnalysisPanel.this.clusterManager.numberOfVisibleClustersHasChanged(numClusters, crd.clusters.getNumNonZeroClusters());
                    }
                    ClusterROIAnalysisPanel.this.viewer.updateROISlices();
                    ClusterROIAnalysisPanel.this.viewer.updateScreenSlices();
                }
            });
        }
    }

    private void updateClustersBySize(int numVoxels, double voxelVolume) {
        this.sizeText.setText(this.formatter.format((double)numVoxels * voxelVolume));
        ClusterRejectionData crd = this.roiManager.getClusterData(this.roiColor);
        if (crd != null) {
            int numClusters;
            crd.contains = new boolean[crd.clusters.getNumClusters() + 1];
            crd.numClusters = numClusters = ROIManager.rejectSmallClusters(crd.contains, crd.clusters, (double)numVoxels);
            this.countText.setText(String.valueOf(numClusters));
            this.countSlider.setValue(numClusters);
            SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                @Override
                public void run() {
                    ClusterROIAnalysisPanel.this.viewer.updateScreenSlices();
                }
            });
        }
    }

    protected void updateEnabledState() {
        this.updateEnabledState(false);
    }
}

