/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.overlay;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.ClusterRejectionData;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.overlay.ClusterAnalysisPanel;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.overlay.ClusterManager;
import edu.uthscsa.ric.mango.viewerslice.screen.OverlayListener;
import edu.uthscsa.ric.mango.viewerslice.screen.OverlayManagerListener;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class ClusterAnalysisTool
extends JFrame
implements ViewerAssociated,
ActionListener,
OverlayListener,
OverlayManagerListener,
ClusterManager {
    private JPanel mainPanel;
    private boolean hasBeenDisplayed;
    private int findClustersIndex;
    private final BufferedImage[] overlayImagesFiltered;
    private final BufferedImage[] overlayImages;
    private final ImageIcon[] overlayImageIcons;
    private final Mango mango;
    private final SliceViewer viewer;
    private final Vector<ClusterAnalysisPanel> allPanels = new Vector();
    private final int xDim;
    private final int yDim;
    private final int[][] overlayData;
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_MESSAGE = "Add an overlay to begin.";
    public static final String LABEL_INFO = "Changes will be reflected dynamically in the viewer";
    public static final String NAME = "Find Clusters";
    public static final int ICON_SIZE = 30;
    public static final int PADDING = 8;

    public ClusterAnalysisTool(Mango mango, SliceViewer viewer) {
        this.mango = mango;
        this.viewer = viewer;
        this.xDim = viewer.getVolume().getXDim() + 1;
        this.yDim = viewer.getVolume().getYDim() + 1;
        viewer.getOverlayManager().addListener(this);
        this.overlayImages = new BufferedImage[8];
        this.overlayImagesFiltered = new BufferedImage[8];
        this.overlayData = new int[8][];
        this.overlayImageIcons = new ImageIcon[8];
        for (int ctr = 0; ctr < 8; ++ctr) {
            this.overlayImages[ctr] = new BufferedImage(30, 30, 2);
            this.overlayImagesFiltered[ctr] = new BufferedImage(30, 30, 2);
            this.overlayData[ctr] = ((DataBufferInt)this.overlayImages[ctr].getRaster().getDataBuffer()).getData();
            this.overlayImageIcons[ctr] = new ImageIcon(this.overlayImagesFiltered[ctr]);
        }
        this.initializeOverlayImageLUTImages();
        this.createUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals("Generate All")) {
            this.generateAllClusterFilters();
        } else if (command.equals("Disable All")) {
            this.disableAllClusterFilters();
        } else if (command.equals("Enable All")) {
            this.enableAllClusterFilters();
        } else if (command.equals("Remove All")) {
            this.removeAllClusterFilters();
        }
    }

    @Override
    public void finishedFindingClusters(int numClusters) {
        ++this.findClustersIndex;
        this.findNextClusters();
    }

    @Override
    public void generateAllClusterFilters() {
        this.findClustersIndex = 0;
        this.findNextClusters();
    }

    @Override
    public String getDescription() {
        return NAME;
    }

    @Override
    public SliceViewer getViewer() {
        return this.viewer;
    }

    @Override
    public JFrame getWindow() {
        return this;
    }

    public boolean isVoxelValid(int xLoc, int yLoc, int zLoc, int overlayIndex) {
        ScreenVolume sv = this.viewer.getOverlayManager().getOverlay(overlayIndex);
        ClusterRejectionData crd = sv.getClusterData();
        if (crd != null) {
            if (crd.hiding || crd.contains == null) {
                return true;
            }
            int index = zLoc * this.xDim * this.yDim + yLoc * this.xDim + xLoc;
            int value = crd.buffer.get(index);
            return crd.contains[value];
        }
        return true;
    }

    @Override
    public void overlayAdded(ScreenVolume vol) {
        if (this.isVisible()) {
            this.updateClusterPanels();
        }
    }

    @Override
    public void overlayChanged(Object overlay, boolean overlaySelected) {
        if (!overlaySelected) {
            ScreenVolume screenVol = (ScreenVolume)overlay;
            if (screenVol.getClusterData() != null) {
                screenVol.getClusterData().cleanup();
                screenVol.setClusterData(null);
            }
            this.updateClusterPanels();
        }
    }

    @Override
    public void overlayRemoved(Object overlay) {
    }

    @Override
    public void overlayRemoved(ScreenVolume vol) {
        if (this.isVisible()) {
            this.updateClusterPanels();
        }
    }

    public void overlayTimepointChanged() {
        this.removeAllClusterFilters();
    }

    @Override
    public void setVisible(boolean bool) {
        if (bool) {
            if (!this.hasBeenDisplayed) {
                this.setLocation(DisplayUtils.getNextWindowLocation(this.viewer.getViewerContainer(), this.getSize(), null, this.mango.isApplet()));
                this.hasBeenDisplayed = true;
            }
            this.enableAllClusterFilters();
            this.updateClusterPanels();
            this.updateClusterWindow();
        } else {
            this.disableAllClusterFilters();
        }
        super.setVisible(bool);
    }

    private void analyzeAll() {
        for (ClusterAnalysisPanel cap : this.allPanels) {
            cap.analyzeClusters(true);
        }
    }

    private JPanel createDefaultPanel() {
        JPanel defaultPanel = new JPanel();
        defaultPanel.setLayout(new BoxLayout(defaultPanel, 0));
        JLabel label = new JLabel(DEFAULT_MESSAGE);
        defaultPanel.add(Box.createHorizontalGlue());
        defaultPanel.add(label);
        defaultPanel.add(Box.createHorizontalGlue());
        defaultPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        defaultPanel.setPreferredSize(new Dimension(380, 60));
        defaultPanel.setMinimumSize(new Dimension(380, 60));
        defaultPanel.setMaximumSize(new Dimension(380, 60));
        return defaultPanel;
    }

    private void createUI() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        JPanel mainPanelOut = new JPanel(new BorderLayout());
        mainPanelOut.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        mainPanelOut.add((Component)this.mainPanel, "Center");
        JLabel infoLabel = new JLabel(LABEL_INFO, 0);
        infoLabel.setForeground(Color.GRAY);
        JPanel infoLabelPanel = new JPanel();
        infoLabelPanel.setLayout(new BoxLayout(infoLabelPanel, 0));
        infoLabelPanel.add(Box.createHorizontalGlue());
        infoLabelPanel.add(infoLabel);
        infoLabelPanel.add(Box.createHorizontalGlue());
        JButton addAllButton = new JButton("Generate All");
        addAllButton.addActionListener(this);
        addAllButton.setFocusable(false);
        JButton clearAllButton = new JButton("Remove All");
        clearAllButton.addActionListener(this);
        clearAllButton.setFocusable(false);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        controlPanel.add(Box.createHorizontalGlue());
        controlPanel.add(addAllButton);
        controlPanel.add(Box.createHorizontalGlue());
        controlPanel.add(clearAllButton);
        controlPanel.add(Box.createHorizontalGlue());
        JPanel controlPanelOut = new JPanel();
        controlPanelOut.setLayout(new BoxLayout(controlPanelOut, 1));
        controlPanelOut.add(Box.createVerticalStrut(8));
        controlPanelOut.add(infoLabelPanel);
        controlPanelOut.add(Box.createVerticalStrut(8));
        controlPanelOut.add(controlPanel);
        mainPanelOut.add((Component)controlPanelOut, "South");
        this.setTitle("Find Clusters: " + this.viewer.getImageTitle());
        this.getContentPane().add((Component)mainPanelOut, "Center");
        this.setBackground(this.mango.getPanelOutsideColor());
        this.pack();
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.setIconImage(MangoStyle.ICON_APP.getImage());
        this.setVisible(false);
    }

    private void disableAllClusterFilters() {
        Iterator<ClusterAnalysisPanel> it = this.allPanels.iterator();
        while (it.hasNext()) {
            it.next().disableClusterFilter();
        }
    }

    private void enableAllClusterFilters() {
        Iterator<ClusterAnalysisPanel> it = this.allPanels.iterator();
        while (it.hasNext()) {
            it.next().enableClusterFilter();
        }
    }

    private void findNextClusters() {
        if (this.findClustersIndex < this.allPanels.size()) {
            ClusterAnalysisPanel panel = this.allPanels.get(this.findClustersIndex);
            panel.findClusters(this);
        } else if (this.findClustersIndex > 0) {
            this.analyzeAll();
        }
    }

    private void initializeOverlayImageLUTImages() {
        double ratio = 8.5;
        int value = 0;
        for (int ctrOvly = 0; ctrOvly < 8; ++ctrOvly) {
            for (int ctr = 0; ctr < 30; ++ctr) {
                for (int ctrIn = 0; ctrIn < 30; ++ctrIn) {
                    value = (int)(8.5 * (double)ctrIn + 0.5);
                    this.overlayData[ctrOvly][ctr * 30 + ctrIn] = value | value << 8 | value << 16 | value << 24;
                }
            }
        }
    }

    private void removeAllClusterFilters() {
        Iterator<ClusterAnalysisPanel> it = this.allPanels.iterator();
        while (it.hasNext()) {
            it.next().removeClusterFilter();
        }
    }

    private void updateClusterPanels() {
        this.mainPanel.removeAll();
        this.allPanels.removeAllElements();
        this.updateOverlayButtonIcons();
        ScreenVolume[] overlays = this.viewer.getOverlayManager().getAllOverlays();
        for (int ctr = 0; ctr < overlays.length; ++ctr) {
            if (overlays[ctr] == null) continue;
            overlays[ctr].removeOverlayListener(this);
            overlays[ctr].addOverlayListener(this);
            ClusterAnalysisPanel panel = new ClusterAnalysisPanel(this.viewer, overlays[ctr], this.overlayImageIcons[ctr]);
            if (panel.hasClusterData()) {
                panel.updateClustersByCount();
            }
            this.allPanels.add(panel);
            this.mainPanel.add(panel);
        }
        if (this.allPanels.size() == 0) {
            this.mainPanel.add(this.createDefaultPanel());
        }
        this.pack();
    }

    private void updateClusterWindow() {
        boolean hasClusters = false;
        for (ClusterAnalysisPanel cap : this.allPanels) {
            hasClusters |= cap.hasClusterData();
        }
        if (!hasClusters) {
            this.generateAllClusterFilters();
        }
    }

    private void updateOverlayButtonIcons() {
        this.updateOverlayImageIconLUTImages();
        for (int ctr = 0; ctr < 8; ++ctr) {
            this.overlayImageIcons[ctr] = new ImageIcon(this.overlayImagesFiltered[ctr]);
        }
    }

    private void updateOverlayImageIconLUTImages() {
        ScreenVolume[] overlays = this.viewer.getOverlayManager().getAllOverlays();
        for (int ctr = 0; ctr < overlays.length; ++ctr) {
            if (overlays[ctr] == null) continue;
            overlays[ctr].getLookupTableManager().getOp().filter(this.overlayImages[ctr], this.overlayImagesFiltered[ctr]);
        }
    }
}

