/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.cine;

import edu.uthscsa.ric.cli.Manager;
import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.dialogs.cine.AbstractCine;
import edu.uthscsa.ric.mango.dialogs.cine.VideoCaptureManager;
import edu.uthscsa.ric.mango.dialogs.script.Recordable;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.core.SliceDirectionListener;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.JVMUtilities;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.volume.Volume;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.avi.AVIWriter;
import org.monte.media.math.Rational;
import org.monte.media.quicktime.QuickTimeWriter;

public class CineSlice
extends AbstractCine
implements SliceDirectionListener {
    private static final long serialVersionUID = 1L;

    public CineSlice(SliceViewer viewer, VideoCaptureManager videoCaptureManager) {
        this(viewer, videoCaptureManager, false);
    }

    public CineSlice(SliceViewer viewer, VideoCaptureManager videoCaptureManager, boolean silent) {
        super(viewer, videoCaptureManager, silent);
        viewer.addSliceDirectionListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent we) {
                if (!CineSlice.this.viewer.isClosing()) {
                    CineSlice.this.viewer.removeSliceDirectionListener(CineSlice.this);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startSilentFreeRecording(final Manager manager, int fps, int quality, int format, File file, boolean animate) {
        int animateStartIndex;
        int animateTotalSlices;
        Volume animatingSeriesVolume;
        boolean animatingSeries;
        final Vector frames = new Vector();
        if (manager.getCurrentVolume().getSeriesLength() > 1) {
            animatingSeries = true;
            animatingSeriesVolume = (Volume)manager.getCurrentVolume();
            animateTotalSlices = animatingSeriesVolume.getNumTimepoints();
            animateStartIndex = animatingSeriesVolume.getCurrentSeriesPoint();
        } else {
            animatingSeries = false;
            animatingSeriesVolume = null;
            animateTotalSlices = manager.getSliceDim(manager.getSliceDirection());
            animateStartIndex = manager.getSliceNumber();
        }
        for (int ctr = 0; ctr < animateTotalSlices; ++ctr) {
            final int index = ctr;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (animatingSeries) {
                            manager.setCurrentSeriesPoint(index);
                        } else {
                            manager.setSliceNumber(index);
                        }
                        frames.add(manager.getVideoImage());
                    }
                });
                continue;
            }
            catch (InterruptedException ex) {
                AppLogger.error((Throwable)ex);
                continue;
            }
            catch (InvocationTargetException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
        if (animateStartIndex != -1) {
            if (animatingSeries) {
                manager.setCurrentSeriesPoint(animateStartIndex);
            } else {
                manager.setSliceNumber(animateStartIndex);
            }
        }
        if (frames == null || frames.size() == 0) {
            return;
        }
        AVIWriter videoWriter = null;
        Format videoFormat = new Format(new Object[]{FormatKeys.EncodingKey, FORMATS.get(format), VideoFormatKeys.DepthKey, 24, VideoFormatKeys.QualityKey, QUALITY.get(quality), FormatKeys.FrameRateKey, new Rational((long)fps, 1L)});
        try {
            if (file.getName().endsWith(".avi")) {
                videoWriter = new AVIWriter(file);
            } else if (file.getName().endsWith(".mov")) {
                videoWriter = new QuickTimeWriter(file);
            } else {
                throw new UnsupportedOperationException("Only AVI and MOV containers are accepted.");
            }
            videoFormat = videoFormat.prepend(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.WidthKey, manager.getVideoCaptureSize(), VideoFormatKeys.HeightKey, manager.getVideoCaptureSize()});
            videoWriter.addTrack(videoFormat);
            videoWriter.setPalette(0, ((BufferedImage)frames.get(0)).getColorModel());
            Iterator it = frames.iterator();
            while (it.hasNext()) {
                videoWriter.write(0, (BufferedImage)it.next(), 1L);
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (UnsupportedOperationException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            try {
                if (videoWriter != null) {
                    videoWriter.close();
                }
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
        frames.clear();
        JVMUtilities.clearGarbage();
    }

    @Override
    public void animate() {
        this.viewer.setNavigationDisabled(true);
        this.storeRecordingParameters();
        this.recordButton.setEnabled(false);
        this.recordButton.setText("Animating");
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                CineSlice.this.doAnimate();
            }
        });
        workThread.start();
    }

    @Override
    public void animateSilently() {
        this.viewer.setNavigationDisabled(true);
        this.doAnimate();
    }

    private void doAnimate() {
        int animateStartIndex;
        int animateTotalSlices;
        Volume animatingSeriesVolume;
        boolean animatingSeries;
        final Vector<BufferedImage> frames = new Vector<BufferedImage>();
        if (this.viewer.getCurrentScreenVolume().getVolume().getNumTimepoints() > 1) {
            animatingSeries = true;
            animatingSeriesVolume = this.viewer.getCurrentScreenVolume().getVolume();
            animateTotalSlices = animatingSeriesVolume.getNumTimepoints();
            animateStartIndex = animatingSeriesVolume.getCurrentSeriesPoint();
        } else {
            animatingSeries = false;
            animatingSeriesVolume = null;
            animateTotalSlices = this.viewer.getMainScreenSlice().getNumSlices();
            animateStartIndex = this.viewer.getMainSliceNumber();
        }
        final ProgressMeter progressBar = this.viewer.makeProgressMeter();
        progressBar.setDescription("Recording Animation");
        progressBar.start(0, 0, animateTotalSlices);
        for (int ctr = 0; ctr < animateTotalSlices; ++ctr) {
            final int index = ctr;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (animatingSeries) {
                            CineSlice.this.viewer.setCurrentTimepoint(index, animatingSeriesVolume);
                        } else {
                            CineSlice.this.viewer.setMainSliceNumber(index);
                        }
                        frames.add(CineSlice.this.viewer.getMainScreenSlice().getVideoImage());
                        progressBar.setValue(index);
                    }
                });
                continue;
            }
            catch (InterruptedException ex) {
                AppLogger.error((Throwable)ex);
                continue;
            }
            catch (InvocationTargetException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
        if (animateStartIndex != -1) {
            if (animatingSeries) {
                this.viewer.setCurrentTimepoint(animateStartIndex, animatingSeriesVolume);
            } else {
                this.viewer.setMainSliceNumber(animateStartIndex);
            }
        }
        if (this.isSilent()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        progressBar.setValue(progressBar.getMax());
                        CineSlice.this.viewer.setNavigationDisabled(false);
                        CineSlice.this.viewer.updateViewer();
                    }
                });
            }
            catch (InterruptedException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                AppLogger.error((Throwable)ex);
            }
            this.stopSilently(frames);
        } else {
            SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                @Override
                public void run() {
                    progressBar.setValue(progressBar.getMax());
                    CineSlice.this.viewer.setNavigationDisabled(false);
                    CineSlice.this.viewer.updateViewer();
                    if (CineSlice.this.isSilent()) {
                        CineSlice.this.stopSilently(frames);
                    } else {
                        CineSlice.this.stop(frames);
                    }
                }
            });
        }
    }

    @Override
    public void updateLabels() {
        this.setVideoCaptureManager(this.viewer.getMainScreenSlice());
        String dir = (String)DIR_LABELS.get(this.viewer.getMainSliceDirection());
        if (this.viewer.getCurrentScreenVolume().getVolume().getNumTimepoints() > 1) {
            int numSeriesPoints = this.viewer.getCurrentScreenVolume().getVolume().getNumTimepoints();
            this.autoSlicesLabel.setText(numSeriesPoints + " series points of the " + dir + " slice");
        } else {
            int numSlices = this.viewer.getMainScreenSlice().getNumSlices();
            this.autoSlicesLabel.setText(numSlices + " " + dir + " slices");
        }
        this.recorderLabel.setText("Record " + dir + " view ");
        this.infoLabel.setText("<html><center>Creates a video of the main view either as an automated<br>animation or a freeform recording.</center></html>");
    }

    @Override
    public double getFrameRateAdjuster(boolean isAnimate) {
        return 1.0;
    }

    @Override
    public void sliceDirectionChanged(int sliceDirection) {
        if (this.isRecording()) {
            this.stop();
        }
        this.updateLabels();
    }

    @Override
    public Recordable getRecordable() {
        return this.viewer;
    }
}

