/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.calculator;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.components.MangoDropDownButton;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.operations.calculation.ImageOperationTreeNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang3.StringUtils;

public class ImageCalculatorTool
implements ActionListener,
PopupMenuListener,
KeyListener,
ViewerAssociated {
    private JButton algebraicFunctions;
    private JButton historyButton;
    private JButton logicFunctions;
    private JButton miscFunctions;
    private JButton otherImage;
    private JButton outputButton;
    private JButton statsFunctions;
    private JCheckBox applyTransformBox;
    private JCheckBox onlyROISlices;
    private JCheckBox useTimeseries;
    private JFrame frame;
    private JPopupMenu popup;
    private JPopupMenu popupAlgebraic;
    private JPopupMenu popupHistory;
    private JPopupMenu popupLogic;
    private JPopupMenu popupMisc;
    private JPopupMenu popupOutput;
    private JPopupMenu popupStats;
    private JRadioButton allVoxelsButton;
    private JRadioButton insideROIButton;
    private JRadioButton outsideROIButton;
    private JScrollPane textAreaScroller;
    private JTextArea textArea;
    private boolean hasSelectedROIs;
    private boolean isNewOutput;
    private boolean useAllTimepoints;
    private int expandedLevel;
    private int lastAreaSelection;
    private long popupAlgTimeCanceled;
    private long popupHistoryTimeCanceled;
    private long popupLogTimeCanceled;
    private long popupMiscTimeCanceled;
    private long popupOutputTimeCanceled;
    private long popupTimeCanceled;
    private long popupTrigTimeCanceled;
    private final Mango mango;
    private final SliceViewer viewer;
    private final VolumeManager[] openVolumesList;
    private final boolean isVOIMode;
    public static final String ACTION_BOOL = "ACTION_BOOL";
    public static final String ACTION_MATH = "ACTION_MATH";
    public static final String ACTION_MISC = "ACTION_MISC";
    public static final String ACTION_OTHER = "other";
    public static final String ACTION_SELF = "self";
    public static final String ACTION_STATS = "ACTION_STATS";
    public static final String ACTION_UPDATE_DATA_SCALE = "Update DataScale";
    public static final String DESCRIPTION = "Calculator";
    public static final String TEXT_ROI = "ROI(";
    public static final String TEXT_THIS = "this";
    public static final int LONG_EXPRESSION_THRESHOLD = 50;
    public static final int MAX_HISTORY_STRING_LENGTH = 25;
    public static final int NUM_COLS = 25;
    public static final int NUM_ROWS = 4;
    public static final int NUM_ROWS_EXPANDED = 8;
    public static final int VERY_LONG_EXPRESSION_THRESHOLD = 250;
    private static AtomicReference<String> lastOperation = new AtomicReference();

    public ImageCalculatorTool(Mango mango, SliceViewer viewer, VolumeManager[] vols) {
        this.mango = mango;
        this.viewer = viewer;
        this.openVolumesList = vols;
        this.isVOIMode = viewer.isMultiSliceMode();
        this.createUI();
        this.makeOtherPopupMenu();
        this.makeStatsPopupMenu();
        this.makeAlgebraicPopupMenu();
        this.makeLogicPopupMenu();
        this.makeMiscPopupMenu();
        this.makeHistoryButton();
        this.updateHistoryPopupMenu();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        StringBuffer stringBuf;
        int selectionEnd;
        this.textArea.grabFocus();
        if (ae.getActionCommand().equals("Run Calculation")) {
            if (this.viewer.isInWorkingState()) {
                return;
            }
            if (this.applyTransformBox.isSelected()) {
                if (this.viewer.isUsingTransform() && !this.viewer.getCurrentTransform().isIdentity()) {
                    this.applyTransform();
                } else if (this.viewer.getBaseVolume().isWorldSpaceOnly() && this.viewer.isWorldMode()) {
                    this.applyTransformWorld();
                }
            } else {
                this.runCalculation();
            }
            return;
        }
        if (ae.getActionCommand().equals("clear")) {
            this.textArea.setText("");
            return;
        }
        if (ae.getActionCommand().equals(ACTION_OTHER)) {
            long timeSinceCancel = new Date().getTime() - this.popupTimeCanceled;
            if (this.popup.getComponentCount() > 0 && timeSinceCancel > 250L) {
                this.popup.show(this.otherImage, 2, 35);
            }
            return;
        }
        if (ae.getActionCommand().equals("output")) {
            long timeSinceCancel = new Date().getTime() - this.popupOutputTimeCanceled;
            if (this.popupOutput.getComponentCount() > 0 && timeSinceCancel > 250L) {
                this.popupOutput.show(this.outputButton, 2, 35);
            }
            return;
        }
        if (ae.getActionCommand().equals(ACTION_STATS)) {
            long timeSinceCancel = new Date().getTime() - this.popupTrigTimeCanceled;
            if (this.popupStats.getComponentCount() > 0 && timeSinceCancel > 250L) {
                this.popupStats.show(this.statsFunctions, 2, 35);
            }
            return;
        }
        if (ae.getActionCommand().equals(ACTION_MATH)) {
            long timeSinceCancel = new Date().getTime() - this.popupAlgTimeCanceled;
            if (this.popupAlgebraic.getComponentCount() > 0 && timeSinceCancel > 250L) {
                this.popupAlgebraic.show(this.algebraicFunctions, 2, 35);
            }
            return;
        }
        if (ae.getActionCommand().equals("Show History")) {
            long timeSinceCancel = new Date().getTime() - this.popupHistoryTimeCanceled;
            if (this.popupHistory.getComponentCount() > 0 && timeSinceCancel > 250L) {
                this.updateHistoryPopupMenu();
                this.popupHistory.show(this.historyButton, 2, 35);
            }
            return;
        }
        if (ae.getActionCommand().startsWith("history")) {
            String string = ae.getActionCommand();
            if (!(string = string.substring(8)).equals("NONE")) {
                this.textArea.setText(string);
            }
            return;
        }
        if (ae.getActionCommand().equals(ACTION_BOOL)) {
            long timeSinceCancel = new Date().getTime() - this.popupLogTimeCanceled;
            if (this.popupLogic.getComponentCount() > 0 && timeSinceCancel > 250L) {
                this.popupLogic.show(this.logicFunctions, 2, 35);
            }
            return;
        }
        if (ae.getActionCommand().equals(ACTION_MISC)) {
            long timeSinceCancel = new Date().getTime() - this.popupMiscTimeCanceled;
            if (this.popupMisc.getComponentCount() > 0 && timeSinceCancel > 250L) {
                this.popupMisc.show(this.miscFunctions, 2, 35);
            }
            return;
        }
        if (ae.getActionCommand().equals("new output")) {
            this.isNewOutput = true;
            this.outputButton.setText("new");
            return;
        }
        if (ae.getActionCommand().equals("this output")) {
            this.isNewOutput = false;
            this.outputButton.setText(TEXT_THIS);
            return;
        }
        if (ae.getActionCommand().equals(ACTION_UPDATE_DATA_SCALE)) {
            if (this.hasSelectedROIs && this.isVOIMode && this.outsideROIButton.isSelected()) {
                this.onlyROISlices.setEnabled(true);
            } else {
                this.onlyROISlices.setSelected(false);
                this.onlyROISlices.setEnabled(false);
            }
            return;
        }
        if (ae.getActionCommand().equals("Only ROI Slices")) {
            return;
        }
        String text = "";
        int position = this.textArea.getCaretPosition();
        int selectionStart = this.textArea.getSelectionStart();
        if (selectionStart != (selectionEnd = this.textArea.getSelectionEnd())) {
            text = ae.getActionCommand().equals(ACTION_SELF) ? ((JButton)ae.getSource()).getText() : (ae.getActionCommand().indexOf(ACTION_OTHER) != -1 ? ae.getActionCommand().substring(0, 9).trim() : ae.getActionCommand());
            if (text.indexOf("start") != -1 && text.indexOf("end") != -1) {
                text = text.substring(0, text.indexOf(40)) + "(1, " + this.viewer.getVolume().getNumTimepoints() + ")";
            } else if (text.indexOf("index") != -1) {
                text = text.substring(0, text.indexOf(40)) + '(' + this.viewer.getROIManager().getCurrentROI() + ')';
            } else if (text.indexOf("volume") != -1) {
                int currentTimepoint = this.viewer.getCurrentTimepoint() + 1;
                text = "volume(" + currentTimepoint + ")";
            }
            stringBuf = new StringBuffer(this.textArea.getText());
            stringBuf.replace(selectionStart, selectionEnd, text);
            this.textArea.setText(stringBuf.toString());
            this.textArea.setCaretPosition(selectionStart);
            position = this.textArea.getCaretPosition();
        } else {
            text = ae.getActionCommand().equals(ACTION_SELF) ? ((JButton)ae.getSource()).getText() : (ae.getActionCommand().indexOf(ACTION_OTHER) != -1 ? ae.getActionCommand().substring(0, 9).trim() : ae.getActionCommand());
            if (text.indexOf("start") != -1 && text.indexOf("end") != -1) {
                text = text.substring(0, text.indexOf(40)) + "(1, " + this.viewer.getVolume().getNumTimepoints() + ")";
            } else if (text.indexOf("index") != -1) {
                text = text.substring(0, text.indexOf(40)) + '(' + this.viewer.getROIManager().getCurrentROI() + ')';
            } else if (text.indexOf("volume") != -1) {
                int currentTimepoint = this.viewer.getCurrentTimepoint() + 1;
                text = "volume(" + currentTimepoint + ")";
            }
            stringBuf = new StringBuffer(this.textArea.getText());
            stringBuf.insert(position, text);
            this.textArea.setText(stringBuf.toString());
        }
        if (text.indexOf(40) != -1) {
            int conPos = this.textArea.getText().indexOf("condition", position);
            int valPos = this.textArea.getText().indexOf("value", position);
            int dimPos = this.textArea.getText().indexOf("dim", position);
            if (!(conPos == -1 || conPos >= valPos && valPos != -1 || conPos >= dimPos && dimPos != -1)) {
                this.textArea.select(conPos, conPos + "condition".length());
            } else if (!(valPos == -1 || valPos >= conPos && conPos != -1 || valPos >= dimPos && dimPos != -1)) {
                this.textArea.select(valPos, valPos + "value".length());
            } else if (!(dimPos == -1 || dimPos >= valPos && valPos != -1 || dimPos >= conPos && conPos != -1)) {
                this.textArea.select(dimPos, dimPos + 3);
            }
        } else {
            this.textArea.setCaretPosition(position + text.length());
        }
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public int getImageAreaSelection() {
        this.lastAreaSelection = this.insideROIButton.isSelected() ? 2 : (this.outsideROIButton.isSelected() ? 3 : (this.mango.isMultisliceMode() ? 0 : 1));
        return this.lastAreaSelection;
    }

    public synchronized String getResults() {
        lastOperation.set(this.textArea.getText());
        return lastOperation.get();
    }

    @Override
    public SliceViewer getViewer() {
        return this.viewer;
    }

    @Override
    public JFrame getWindow() {
        return this.frame;
    }

    public boolean isAllTimepoints() {
        this.useAllTimepoints = this.useTimeseries.isSelected();
        return this.useAllTimepoints;
    }

    public boolean isOutputToNewImage() {
        return this.isNewOutput;
    }

    public boolean isROISliceOnly() {
        return this.onlyROISlices.isSelected() && this.hasSelectedROIs && this.isVOIMode && this.outsideROIButton.isSelected();
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        this.checkTextSize();
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent pme) {
        if (pme.getSource() == this.popup) {
            this.popupTimeCanceled = new Date().getTime();
        } else if (pme.getSource() == this.popupStats) {
            this.popupTrigTimeCanceled = new Date().getTime();
        } else if (pme.getSource() == this.popupAlgebraic) {
            this.popupAlgTimeCanceled = new Date().getTime();
        } else if (pme.getSource() == this.popupLogic) {
            this.popupLogTimeCanceled = new Date().getTime();
        } else if (pme.getSource() == this.popupMisc) {
            this.popupMiscTimeCanceled = new Date().getTime();
        } else if (pme.getSource() == this.popupOutput) {
            this.popupOutputTimeCanceled = new Date().getTime();
        } else if (pme.getSource() == this.popupHistory) {
            this.popupHistoryTimeCanceled = new Date().getTime();
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
    }

    public synchronized void setResultsText(String string) {
        this.textArea.setText(string);
        lastOperation.set(string);
    }

    public final void updateROIOptions() {
        this.hasSelectedROIs = this.viewer.hasSelectedROIs();
        this.allVoxelsButton.setEnabled(this.hasSelectedROIs);
        this.insideROIButton.setEnabled(this.hasSelectedROIs);
        this.outsideROIButton.setEnabled(this.hasSelectedROIs);
        this.onlyROISlices.setEnabled(this.hasSelectedROIs && this.outsideROIButton.isSelected());
        if (!this.hasSelectedROIs) {
            this.allVoxelsButton.setSelected(true);
            this.onlyROISlices.setSelected(false);
        }
    }

    private void checkTextSize() {
        int offset = 0;
        try {
            offset = this.textArea.getLineEndOffset(0);
        }
        catch (BadLocationException ex) {
            AppLogger.info((Throwable)ex);
        }
        if (this.expandedLevel == 0 && (offset > 50 || this.textArea.getLineCount() >= 4)) {
            this.increaseTextAreaSize();
        } else if (this.expandedLevel == 1 && (offset > 250 || this.textArea.getLineCount() >= 8)) {
            this.increaseTextAreaSize();
        }
    }

    private int countOpenVolumes() {
        int count = 0;
        for (VolumeManager element : this.openVolumesList) {
            if (element == null) continue;
            ++count;
        }
        return count;
    }

    private void createUI() {
        CalculatorButton clear = new CalculatorButton("AC");
        clear.setActionCommand("clear");
        CalculatorButton thisImage = new CalculatorButton(TEXT_THIS);
        thisImage.setActionCommand(TEXT_THIS);
        this.otherImage = new DropDownButton(ACTION_OTHER);
        this.otherImage.setActionCommand(ACTION_OTHER);
        this.otherImage.setEnabled(this.countOpenVolumes() > 1);
        JButton[] nums = new JButton[10];
        for (int ctr = 0; ctr < 10; ++ctr) {
            nums[ctr] = new CalculatorButton(String.valueOf(ctr));
            nums[ctr].setActionCommand(ACTION_SELF);
        }
        String decimalString = Platform.MAC ? "\u2219" : ".";
        CalculatorButton decimal = new CalculatorButton(decimalString);
        decimal.setActionCommand(".");
        CalculatorButton parenOpen = new CalculatorButton("(");
        parenOpen.setActionCommand(ACTION_SELF);
        CalculatorButton parenClose = new CalculatorButton(")");
        parenOpen.setActionCommand(ACTION_SELF);
        CalculatorButton multiply = new CalculatorButton("\u00d7");
        multiply.setActionCommand("*");
        CalculatorButton divide = new CalculatorButton("\u00f7");
        divide.setActionCommand("/");
        CalculatorButton add = new CalculatorButton("+");
        add.setActionCommand("+");
        CalculatorButton subtract = new CalculatorButton("-");
        subtract.setActionCommand("-");
        this.statsFunctions = new DropDownButton("Statistical");
        this.statsFunctions.setActionCommand(ACTION_STATS);
        this.statsFunctions.addActionListener(this);
        this.statsFunctions.setHorizontalTextPosition(2);
        this.algebraicFunctions = new DropDownButton("Mathematical");
        this.algebraicFunctions.setActionCommand(ACTION_MATH);
        this.algebraicFunctions.addActionListener(this);
        this.logicFunctions = new DropDownButton("Boolean");
        this.logicFunctions.setActionCommand(ACTION_BOOL);
        this.logicFunctions.addActionListener(this);
        this.miscFunctions = new DropDownButton("Miscellaneous");
        this.miscFunctions.setActionCommand(ACTION_MISC);
        this.miscFunctions.addActionListener(this);
        JPanel buttonPanelBottom = new JPanel(new GridLayout(2, 2));
        buttonPanelBottom.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Functions"));
        buttonPanelBottom.add(this.statsFunctions, 0, 0);
        buttonPanelBottom.add(this.miscFunctions, 0, 1);
        buttonPanelBottom.add(this.algebraicFunctions, 1, 0);
        buttonPanelBottom.add(this.logicFunctions, 1, 1);
        JPanel buttonPanelTop = new JPanel(new GridLayout(5, 4));
        buttonPanelTop.add(nums[0], 0, 0);
        buttonPanelTop.add(decimal, 0, 1);
        buttonPanelTop.add(clear, 0, 2);
        buttonPanelTop.add(add, 0, 3);
        buttonPanelTop.add(nums[1], 1, 0);
        buttonPanelTop.add(nums[2], 1, 1);
        buttonPanelTop.add(nums[3], 1, 2);
        buttonPanelTop.add(subtract, 1, 3);
        buttonPanelTop.add(nums[4], 2, 0);
        buttonPanelTop.add(nums[5], 2, 1);
        buttonPanelTop.add(nums[6], 2, 2);
        buttonPanelTop.add(multiply, 2, 3);
        buttonPanelTop.add(nums[7], 3, 0);
        buttonPanelTop.add(nums[8], 3, 1);
        buttonPanelTop.add(nums[9], 3, 2);
        buttonPanelTop.add(divide, 3, 3);
        buttonPanelTop.add(parenOpen, 4, 0);
        buttonPanelTop.add(parenClose, 4, 1);
        buttonPanelTop.add(this.otherImage, 4, 2);
        buttonPanelTop.add(thisImage, 4, 3);
        JPanel buttonPanel = new JPanel();
        BoxLayout layoutButtonPanel = new BoxLayout(buttonPanel, 1);
        buttonPanel.setLayout(layoutButtonPanel);
        buttonPanel.add(buttonPanelTop);
        buttonPanel.add(Box.createVerticalStrut(8));
        buttonPanel.add(buttonPanelBottom);
        this.hasSelectedROIs = this.viewer.hasSelectedROIs();
        this.allVoxelsButton = new JRadioButton("All Voxels");
        this.allVoxelsButton.setFocusable(false);
        this.allVoxelsButton.setEnabled(this.hasSelectedROIs);
        this.allVoxelsButton.setActionCommand(ACTION_UPDATE_DATA_SCALE);
        this.allVoxelsButton.addActionListener(this);
        this.insideROIButton = new JRadioButton("Inside ROI");
        this.insideROIButton.setFocusable(false);
        this.insideROIButton.setEnabled(this.hasSelectedROIs);
        this.insideROIButton.setActionCommand(ACTION_UPDATE_DATA_SCALE);
        this.insideROIButton.addActionListener(this);
        this.outsideROIButton = new JRadioButton("Outside ROI");
        this.outsideROIButton.setFocusable(false);
        this.outsideROIButton.setEnabled(this.hasSelectedROIs);
        this.outsideROIButton.setActionCommand(ACTION_UPDATE_DATA_SCALE);
        this.outsideROIButton.addActionListener(this);
        if (this.lastAreaSelection == 2 && this.insideROIButton.isEnabled()) {
            this.insideROIButton.setSelected(true);
        } else if (this.lastAreaSelection == 3 && this.outsideROIButton.isEnabled()) {
            this.outsideROIButton.setSelected(true);
        } else {
            this.allVoxelsButton.setSelected(true);
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.allVoxelsButton);
        group.add(this.insideROIButton);
        group.add(this.outsideROIButton);
        JPanel radioButtonPanelBottomInner = new JPanel();
        radioButtonPanelBottomInner.setLayout(new BoxLayout(radioButtonPanelBottomInner, 0));
        radioButtonPanelBottomInner.add(Box.createHorizontalGlue());
        radioButtonPanelBottomInner.add(this.allVoxelsButton);
        radioButtonPanelBottomInner.add(Box.createHorizontalGlue());
        radioButtonPanelBottomInner.add(this.insideROIButton);
        radioButtonPanelBottomInner.add(Box.createHorizontalGlue());
        radioButtonPanelBottomInner.add(this.outsideROIButton);
        radioButtonPanelBottomInner.add(Box.createHorizontalGlue());
        radioButtonPanelBottomInner.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Region"));
        JPanel radioButtonPanelBottom = new JPanel();
        radioButtonPanelBottom.setLayout(new BoxLayout(radioButtonPanelBottom, 1));
        radioButtonPanelBottom.add(radioButtonPanelBottomInner);
        this.onlyROISlices = new JCheckBox("Only apply to slices that contain ROI data");
        this.onlyROISlices.setFocusable(false);
        this.onlyROISlices.setEnabled(this.hasSelectedROIs && this.isVOIMode && this.outsideROIButton.isSelected());
        this.onlyROISlices.setActionCommand("Only ROI Slices");
        this.onlyROISlices.addActionListener(this);
        this.updateROIOptions();
        this.useTimeseries = new JCheckBox("Apply to all series points");
        this.useTimeseries.setFocusable(false);
        this.useTimeseries.setEnabled(this.viewer.getVolume().getNumTimepoints() > 1);
        this.useTimeseries.setSelected(this.useAllTimepoints && this.viewer.getVolume().getNumTimepoints() > 1);
        this.applyTransformBox = new JCheckBox("Apply transform before calculation");
        this.applyTransformBox.setFocusable(false);
        this.applyTransformBox.setEnabled(this.viewer.isUsingTransform() && !this.viewer.getCurrentTransform().isIdentity() || this.viewer.getBaseVolume().isWorldSpaceOnly() && this.viewer.isWorldMode());
        this.applyTransformBox.setSelected(this.applyTransformBox.isEnabled());
        JPanel onlyROISlicesPanel = new JPanel();
        onlyROISlicesPanel.setLayout(new BoxLayout(onlyROISlicesPanel, 0));
        onlyROISlicesPanel.add(Box.createHorizontalGlue());
        onlyROISlicesPanel.add(this.onlyROISlices);
        onlyROISlicesPanel.add(Box.createHorizontalGlue());
        JPanel useTimeseriesPanel = new JPanel();
        useTimeseriesPanel.setLayout(new BoxLayout(useTimeseriesPanel, 0));
        useTimeseriesPanel.add(Box.createHorizontalGlue());
        useTimeseriesPanel.add(this.useTimeseries);
        useTimeseriesPanel.add(Box.createHorizontalGlue());
        JPanel applyTransformPanel = new JPanel();
        applyTransformPanel.setLayout(new BoxLayout(applyTransformPanel, 0));
        applyTransformPanel.add(Box.createHorizontalGlue());
        applyTransformPanel.add(this.applyTransformBox);
        applyTransformPanel.add(Box.createHorizontalGlue());
        JPanel lowerRadioButtonPanel = new JPanel();
        lowerRadioButtonPanel.setLayout(new BoxLayout(lowerRadioButtonPanel, 1));
        lowerRadioButtonPanel.add(useTimeseriesPanel);
        lowerRadioButtonPanel.add(onlyROISlicesPanel);
        lowerRadioButtonPanel.add(applyTransformPanel);
        lowerRadioButtonPanel.add(Box.createVerticalStrut(4));
        lowerRadioButtonPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Options"));
        this.textArea = new JTextArea(4, 25);
        this.textArea.setText(TEXT_THIS);
        this.textArea.setMaximumSize(this.textArea.getPreferredSize());
        this.textArea.setMinimumSize(this.textArea.getPreferredSize());
        this.textArea.addKeyListener(this);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ImageCalculatorTool.this.checkTextSize();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ImageCalculatorTool.this.checkTextSize();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ImageCalculatorTool.this.checkTextSize();
            }
        });
        this.textAreaScroller = new JScrollPane(this.textArea, 20, 31);
        if (lastOperation.get() != null) {
            this.textArea.setText(lastOperation.get().trim());
        }
        JLabel thisLabel = new JLabel("= ");
        this.outputButton = new DropDownButton(this.isNewOutput ? "new" : TEXT_THIS);
        this.outputButton.setFocusable(false);
        if (!this.mango.isApplet()) {
            this.outputButton.setActionCommand("output");
            this.outputButton.addActionListener(this);
            this.makeOutputPopupMenu();
        } else {
            this.outputButton.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        }
        JPanel outputPanel = new JPanel();
        outputPanel.setLayout(new BoxLayout(outputPanel, 0));
        outputPanel.add(Box.createHorizontalStrut(4));
        outputPanel.add(this.outputButton);
        outputPanel.add(thisLabel);
        outputPanel.add(Box.createHorizontalStrut(4));
        JPanel outputPanel2 = new JPanel();
        outputPanel2.setLayout(new BoxLayout(outputPanel2, 1));
        outputPanel2.add(outputPanel);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BoxLayout(textPanel, 0));
        textPanel.add(outputPanel2);
        textPanel.add(this.textAreaScroller);
        textPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        JButton calculateButton = new JButton("Run Calculation");
        calculateButton.addActionListener(this);
        this.historyButton = new JButton("Show History");
        this.historyButton.addActionListener(this);
        JPanel lowerButtonPanel = new JPanel();
        lowerButtonPanel.setLayout(new BoxLayout(lowerButtonPanel, 0));
        lowerButtonPanel.add(Box.createHorizontalGlue());
        lowerButtonPanel.add(this.historyButton);
        lowerButtonPanel.add(calculateButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(buttonPanel);
        mainPanel.add(Box.createVerticalStrut(8));
        mainPanel.add(radioButtonPanelBottom);
        mainPanel.add(Box.createVerticalStrut(8));
        mainPanel.add(lowerRadioButtonPanel);
        mainPanel.add(Box.createVerticalStrut(8));
        mainPanel.add(textPanel);
        mainPanel.add(Box.createVerticalStrut(12));
        mainPanel.add(lowerButtonPanel);
        mainPanel.add(Box.createVerticalStrut(4));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.frame = new JFrame();
        this.frame.setTitle("Calculator: " + this.viewer.getImageTitle());
        this.frame.getContentPane().add((Component)mainPanel, "Center");
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setLocation(DisplayUtils.getCenterDialogLocationRelative(this.viewer.getViewerContainer(), this.frame.getSize()));
        this.frame.setIconImage(MangoStyle.ICON_APP.getImage());
        this.frame.setVisible(true);
        this.frame.validate();
        this.frame.repaint();
        this.textArea.requestFocus();
        this.textArea.selectAll();
        this.viewer.associateWindow(this);
    }

    private void increaseTextAreaSize() {
        ++this.expandedLevel;
        this.textAreaScroller.setPreferredSize(new Dimension((int)((double)this.textAreaScroller.getPreferredSize().width * 1.5), this.textAreaScroller.getPreferredSize().height * 2));
        this.textAreaScroller.setMinimumSize(this.textAreaScroller.getPreferredSize());
        this.textAreaScroller.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        if (this.frame != null) {
            this.frame.pack();
        }
    }

    private void makeAlgebraicPopupMenu() {
        int ctr;
        this.popupAlgebraic = new JPopupMenu();
        for (ctr = 0; ctr < ImageOperationTreeNode.ALGEBRAIC_FUNCTION_NAMES.size(); ++ctr) {
            String name = ImageOperationTreeNode.ALGEBRAIC_FUNCTION_NAMES.get(ctr);
            name = ctr == 6 ? name + "(value, value)" : name + "(value)";
            JMenuItem mi = new JMenuItem(name);
            mi.setActionCommand(mi.getText());
            mi.addActionListener(this);
            this.popupAlgebraic.add(mi);
        }
        for (ctr = 0; ctr < ImageOperationTreeNode.TRIG_FUNCTION_NAMES.size(); ++ctr) {
            JMenuItem mi = new JMenuItem(ImageOperationTreeNode.TRIG_FUNCTION_NAMES.get((ctr + 3) % 6) + "(value)");
            mi.setActionCommand(mi.getText());
            mi.addActionListener(this);
            this.popupAlgebraic.add(mi);
        }
        JMenuItem mi = new JMenuItem("NaN");
        mi.setActionCommand(mi.getText());
        mi.addActionListener(this);
        this.popupAlgebraic.add(mi);
        mi = new JMenuItem("\u03c0");
        mi.setActionCommand(mi.getText());
        mi.addActionListener(this);
        this.popupAlgebraic.add(mi);
        this.popupAlgebraic.addPopupMenuListener(this);
    }

    private void makeHistoryButton() {
        this.popupHistory = new JPopupMenu();
    }

    private void makeLogicPopupMenu() {
        this.popupLogic = new JPopupMenu();
        for (int ctr = 0; ctr < ImageOperationTreeNode.LOGIC_FUNCTION_NAMES.size(); ++ctr) {
            String name = ImageOperationTreeNode.LOGIC_FUNCTION_NAMES.get(ctr);
            if (ctr == 3) {
                name = name + "(condition)";
            } else if (ctr == 4) {
                name = name + "(condition, value else value)";
            }
            JMenuItem mi = new JMenuItem(name);
            mi.setActionCommand(mi.getText());
            mi.addActionListener(this);
            this.popupLogic.add(mi);
        }
        JMenuItem mi = new JMenuItem("true");
        mi.setActionCommand(mi.getText());
        mi.addActionListener(this);
        this.popupLogic.add(mi);
        mi = new JMenuItem("false");
        mi.setActionCommand(mi.getText());
        mi.addActionListener(this);
        this.popupLogic.add(mi);
        this.popupLogic.addPopupMenuListener(this);
    }

    private void makeMiscPopupMenu() {
        this.popupMisc = new JPopupMenu();
        for (int ctr = 0; ctr < ImageOperationTreeNode.MISC_FUNCTION_NAMES.size(); ++ctr) {
            String name = ImageOperationTreeNode.MISC_FUNCTION_NAMES.get(ctr);
            if (ctr == 0 || ctr == 7 || ctr == 8 || ctr == 9) {
                name = name + "(value)";
            } else if (ctr == 5 || ctr == 6 || ctr == 10 || ctr == 12) {
                name = name + "(value, value)";
            } else if (ctr == 11) {
                name = name + "(condition)";
            }
            JMenuItem mi = new JMenuItem(name);
            mi.setActionCommand(mi.getText());
            mi.addActionListener(this);
            this.popupMisc.add(mi);
        }
        this.popupMisc.addPopupMenuListener(this);
    }

    private void makeOtherPopupMenu() {
        this.popup = new JPopupMenu();
        for (int ctr = 1; ctr < this.openVolumesList.length; ++ctr) {
            if (this.openVolumesList[ctr] == null) continue;
            JMenuItem mi = new JMenuItem("other(" + ctr + ") = " + ((Volume)this.openVolumesList[ctr].getBaseVolume()).getImageFilename());
            mi.setActionCommand(mi.getText());
            mi.addActionListener(this);
            this.popup.add(mi);
        }
        this.popup.addPopupMenuListener(this);
    }

    private void makeOutputPopupMenu() {
        this.popupOutput = new JPopupMenu();
        JMenuItem mi = new JMenuItem(TEXT_THIS);
        mi.setActionCommand("this output");
        mi.addActionListener(this);
        this.popupOutput.add(mi);
        mi = new JMenuItem("new");
        mi.setActionCommand("new output");
        mi.addActionListener(this);
        this.popupOutput.add(mi);
        this.popupOutput.addPopupMenuListener(this);
    }

    private void makeStatsPopupMenu() {
        this.popupStats = new JPopupMenu();
        for (int ctr = 0; ctr < ImageOperationTreeNode.STATS_FUNCTION_NAMES.size(); ++ctr) {
            JMenuItem mi = null;
            mi = ctr < 5 ? new JMenuItem(ImageOperationTreeNode.STATS_FUNCTION_NAMES.get(ctr) + "(index)") : new JMenuItem(ImageOperationTreeNode.STATS_FUNCTION_NAMES.get(ctr) + "(start, end)");
            mi.setActionCommand(mi.getText());
            mi.addActionListener(this);
            this.popupStats.add(mi);
        }
        this.popupStats.addPopupMenuListener(this);
    }

    private void updateHistoryPopupMenu() {
        this.popupHistory.removeAll();
        LinkedList<String> list = this.mango.getCalculatorHistory();
        if (list == null || list.size() == 0) {
            JMenuItem mi = new JMenuItem("No history");
            mi.setActionCommand("history NONE");
            mi.addActionListener(this);
            this.popupHistory.add(mi);
        } else {
            ListIterator it = list.listIterator();
            while (it.hasNext()) {
                String item = (String)it.next();
                String command = item;
                if (command.length() > 25) {
                    command = command.substring(0, 25) + "...";
                }
                JMenuItem mi = new JMenuItem(command);
                mi.setActionCommand("history " + item);
                mi.addActionListener(this);
                this.popupHistory.add(mi);
            }
        }
        this.popupHistory.addPopupMenuListener(this);
    }

    private void runCalculation() {
        String input = this.getResults();
        this.mango.addToCalculatorList(input);
        if (StringUtils.isNotBlank((CharSequence)input)) {
            this.viewer.doActionCalculation(input, this.getImageAreaSelection(), this.isOutputToNewImage(), this.isAllTimepoints(), this.isROISliceOnly());
        }
    }

    private void applyTransform() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int ctrX;
                int ctrY;
                int ctrZ;
                Volume volume = ImageCalculatorTool.this.viewer.getBaseVolume();
                volume.makeTempBuffer();
                int xDim = volume.getXDim();
                int yDim = volume.getYDim();
                int zDim = volume.getZDim();
                ProgressMeter progressBar = ImageCalculatorTool.this.viewer.makeProgressMeter();
                progressBar.setDescription("Applying Transform");
                progressBar.start(0, 0, zDim);
                for (ctrZ = 0; ctrZ < zDim; ++ctrZ) {
                    progressBar.setValue(ctrZ);
                    for (ctrY = 0; ctrY < yDim; ++ctrY) {
                        for (ctrX = 0; ctrX < xDim; ++ctrX) {
                            volume.putRawVoxelValueAtIndexTemp(ctrX, ctrY, ctrZ, volume.getVoxelValueAtIndex(ctrX, ctrY, ctrZ, volume.getCurrentTimepoint(), true));
                        }
                    }
                }
                for (ctrZ = 0; ctrZ < zDim; ++ctrZ) {
                    progressBar.setValue(ctrZ);
                    for (ctrY = 0; ctrY < yDim; ++ctrY) {
                        for (ctrX = 0; ctrX < xDim; ++ctrX) {
                            volume.putVoxelValueAtIndex(ctrX, ctrY, ctrZ, volume.getVoxelValueAtIndexTemp(ctrX, ctrY, ctrZ, true));
                        }
                    }
                }
                progressBar.setValue(progressBar.getMax());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImageCalculatorTool.this.viewer.setTransformMode(false);
                        ImageCalculatorTool.this.viewer.updateViewer();
                        ImageCalculatorTool.this.runCalculation();
                    }
                });
            }
        });
        workThread.start();
    }

    private void applyTransformWorld() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int ctrX;
                int ctrY;
                int ctrZ;
                Volume volume = ImageCalculatorTool.this.viewer.getBaseVolume();
                volume.makeTempBuffer();
                int xDim = volume.getXDim();
                int yDim = volume.getYDim();
                int zDim = volume.getZDim();
                Coordinate origin = volume.getOrigin();
                double xSize = volume.getVoxelDimensions().getXSize();
                double ySize = volume.getVoxelDimensions().getYSize();
                double zSize = volume.getVoxelDimensions().getZSize();
                ProgressMeter progressBar = ImageCalculatorTool.this.viewer.makeProgressMeter();
                progressBar.setDescription("Applying Transform");
                progressBar.start(0, 0, zDim);
                for (ctrZ = 0; ctrZ < zDim; ++ctrZ) {
                    progressBar.setValue(ctrZ);
                    for (ctrY = 0; ctrY < yDim; ++ctrY) {
                        for (ctrX = 0; ctrX < xDim; ++ctrX) {
                            double worldX = (double)(ctrX - origin.xInt) * xSize;
                            double worldY = (double)(origin.yInt - ctrY) * ySize;
                            double worldZ = (double)(origin.zInt - ctrZ) * zSize;
                            volume.putRawVoxelValueAtIndexTemp(ctrX, ctrY, ctrZ, volume.getVoxelValueAtCoordinate(worldX, worldY, worldZ, volume.getCurrentTimepoint(), true));
                        }
                    }
                }
                for (ctrZ = 0; ctrZ < zDim; ++ctrZ) {
                    progressBar.setValue(ctrZ);
                    for (ctrY = 0; ctrY < yDim; ++ctrY) {
                        for (ctrX = 0; ctrX < xDim; ++ctrX) {
                            volume.putVoxelValueAtIndex(ctrX, ctrY, ctrZ, volume.getVoxelValueAtIndexTemp(ctrX, ctrY, ctrZ, true));
                        }
                    }
                }
                progressBar.setValue(progressBar.getMax());
                volume.resetTransforms(true);
                volume.setForceDisplayWorld(false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Mango.getInstance().setWorldMode(false);
                        ImageCalculatorTool.this.viewer.updateViewer();
                        ImageCalculatorTool.this.runCalculation();
                    }
                });
            }
        });
        workThread.start();
    }

    class DropDownButton
    extends MangoDropDownButton {
        private static final long serialVersionUID = 1L;

        public DropDownButton(String text) {
            super(text);
            this.addActionListener(ImageCalculatorTool.this);
        }
    }

    class CalculatorButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        public CalculatorButton(String text) {
            super(text);
            this.setFocusable(false);
            this.addActionListener(ImageCalculatorTool.this);
        }
    }
}

