/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.components.seriesmanager;

import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.volume.Volume;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SeriesManager
extends JPanel
implements ChangeListener {
    private final SliceViewer viewer;
    private ScreenVolume currentScreenVolume;
    private JSlider slider;
    private boolean initialized;
    private boolean freezeState;
    private static final long serialVersionUID = 1L;

    public SeriesManager(SliceViewer viewer) {
        this.viewer = viewer;
        this.createUI();
    }

    private void createUI() {
        this.slider = new JSlider();
        this.slider.setPaintTicks(true);
        this.slider.setSnapToTicks(true);
        this.slider.addChangeListener(this);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.slider);
    }

    public void updateSeriesManager() {
        this.freezeState = true;
        this.currentScreenVolume = this.viewer.getCurrentScreenVolume();
        Volume volume = this.currentScreenVolume.getVolume();
        int num = volume.getNumTimepoints();
        this.slider.setMaximum(num - 1);
        if (num > 25) {
            this.slider.setMajorTickSpacing(5);
            this.slider.setMinorTickSpacing(1);
        } else {
            this.slider.setMajorTickSpacing(1);
        }
        if (this.initialized) {
            this.slider.setValue(volume.getCurrentSeriesPoint());
        } else {
            this.initialized = true;
            this.slider.setValue(0);
        }
        this.freezeState = false;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (!this.freezeState && this.currentScreenVolume.getVolume().getCurrentTimepoint() != this.slider.getValue()) {
            this.viewer.setCurrentTimepoint(this.slider.getValue(), this.currentScreenVolume.getImageVolume());
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

