/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice;

import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.volume.Coordinate;

public class SliceViewerSyncer {
    private final SliceViewer[] viewers = new SliceViewer[64];
    private int type = 0;
    private boolean zoom;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_MAIN = 1;
    public static final int TYPE_VIEWER = 2;
    public static final int MAX_NUM = 64;

    public void addViewer(SliceViewer viewer) {
        for (int ctr = 0; ctr < 64; ++ctr) {
            if (this.viewers[ctr] != null) continue;
            this.viewers[ctr] = viewer;
            break;
        }
    }

    public void removeViewer(SliceViewer viewer) {
        for (int ctr = 0; ctr < 64; ++ctr) {
            if (this.viewers[ctr] != viewer) continue;
            this.viewers[ctr] = null;
        }
    }

    public void sync(SliceViewer viewer, Coordinate coor, int labelType) {
        for (int ctr = 0; ctr < 64; ++ctr) {
            if (this.viewers[ctr] == null || this.viewers[ctr] == viewer) continue;
            this.viewers[ctr].setCurrentCoordinate(coor, labelType);
            this.viewers[ctr].setMainSliceDirection(viewer.getMainSliceDirection());
        }
    }

    public void syncMain(SliceViewer viewer, int labelType) {
        int xLoc = viewer.getMainScreenSlice().getCurrentX();
        int yLoc = viewer.getMainScreenSlice().getCurrentY();
        double xPos = (double)xLoc * viewer.getMainScreenSlice().getXSize();
        double yPos = (double)yLoc * viewer.getMainScreenSlice().getYSize();
        for (int ctr = 0; ctr < 64; ++ctr) {
            if (this.viewers[ctr] == null || this.viewers[ctr] == viewer) continue;
            if (labelType == 0) {
                this.viewers[ctr].setMainCoordinate(xLoc, yLoc);
                continue;
            }
            this.viewers[ctr].setMainCoordinate(xPos, yPos);
        }
    }

    public void syncSeries(SliceViewer viewer, int seriesPoint) {
        for (int ctr = 0; ctr < 64; ++ctr) {
            if (this.viewers[ctr] == null || this.viewers[ctr] == viewer || this.viewers[ctr].hasOverlayTimeseries()) continue;
            this.viewers[ctr].getBaseVolume().setCurrentTimepoint(seriesPoint);
            this.viewers[ctr].updateViewer();
            this.viewers[ctr].updateWindowTitle();
        }
    }

    public void syncZoom(SliceViewer viewer) {
        double zoomFactor = viewer.getZoomFactor();
        for (int ctr = 0; ctr < 64; ++ctr) {
            if (this.viewers[ctr] == null || this.viewers[ctr] == viewer) continue;
            this.viewers[ctr].setZoomLocation();
            this.viewers[ctr].setZoomFactor(zoomFactor, false);
            this.viewers[ctr].setZoomFactorPrevious(zoomFactor);
        }
    }

    public void syncZoomLocation(SliceViewer viewer) {
        double zoomFactor = viewer.getZoomFactor();
        for (int ctr = 0; ctr < 64; ++ctr) {
            if (this.viewers[ctr] == null || this.viewers[ctr] == viewer) continue;
            this.viewers[ctr].setZoomFactor(zoomFactor, false);
            this.viewers[ctr].setZoomFactorPrevious(zoomFactor);
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isZoom() {
        return this.zoom;
    }

    public void setZoom(boolean zoom) {
        this.zoom = zoom;
    }
}

