/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice;

import Jama.Matrix;
import edu.uthscsa.ric.cli.ParameterNameAnnotation;
import edu.uthscsa.ric.cli.ScriptablePlugin;
import edu.uthscsa.ric.mango.Atlas;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoContext;
import edu.uthscsa.ric.mango.MangoData;
import edu.uthscsa.ric.mango.MangoImage;
import edu.uthscsa.ric.mango.MangoROI;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.ScreenImage;
import edu.uthscsa.ric.mango.SliceListener;
import edu.uthscsa.ric.mango.ViewerController;
import edu.uthscsa.ric.mango.components.MangoColorButton;
import edu.uthscsa.ric.mango.components.MangoColorSelectedListener;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPane;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPaneUser;
import edu.uthscsa.ric.mango.components.progressbar.ProgressBarListener;
import edu.uthscsa.ric.mango.core.Capturable;
import edu.uthscsa.ric.mango.core.LoadItem;
import edu.uthscsa.ric.mango.core.StringComparator;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.FileNode;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.NodesTransferable;
import edu.uthscsa.ric.mango.dialogs.modal.AddImageDialog;
import edu.uthscsa.ric.mango.dialogs.modal.SimpleDialog;
import edu.uthscsa.ric.mango.dialogs.modal.file.SaveFileDialog;
import edu.uthscsa.ric.mango.dialogs.script.Recordable;
import edu.uthscsa.ric.mango.dialogs.script.ScriptManager;
import edu.uthscsa.ric.mango.dialogs.script.ScriptUtils;
import edu.uthscsa.ric.mango.dialogs.snapshot.Snapshot;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerprojection.ProjectionManager;
import edu.uthscsa.ric.mango.viewerprojection.menus.ProjectionViewerMenu;
import edu.uthscsa.ric.mango.viewerprojection.operations.building.BuildProjectionParameters;
import edu.uthscsa.ric.mango.viewerprojection.window.ProjectionFrame;
import edu.uthscsa.ric.mango.viewerslice.SliceViewerSyncer;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.mango.viewerslice.components.labeleditor.SeriesLabelEditorUser;
import edu.uthscsa.ric.mango.viewerslice.core.CurrentVolumeListener;
import edu.uthscsa.ric.mango.viewerslice.core.OverlayLoadItem;
import edu.uthscsa.ric.mango.viewerslice.core.SliceDirectionListener;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerListener;
import edu.uthscsa.ric.mango.viewerslice.dialogs.calculator.ImageCalculatorTool;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cine.CineSlice;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.ClusterImpl;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.ClusterStat;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.operations.ClusterOperations;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.overlay.ClusterAnalysisPanel;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.overlay.ClusterAnalysisTool;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.roi.ClusterROIAnalysisPanel;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.roi.ClusterROIAnalysisTool;
import edu.uthscsa.ric.mango.viewerslice.dialogs.crosssection.Crosssection;
import edu.uthscsa.ric.mango.viewerslice.dialogs.crosssection.CrosssectionTool;
import edu.uthscsa.ric.mango.viewerslice.dialogs.histogram.HistogramPanel;
import edu.uthscsa.ric.mango.viewerslice.dialogs.histogram.HistogramTool;
import edu.uthscsa.ric.mango.viewerslice.dialogs.imageinfo.ImageInfoDialog;
import edu.uthscsa.ric.mango.viewerslice.dialogs.layout.Layout;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.Logical;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.LogicalAnalysisTool;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.operations.LogicalOpListener;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.operations.LogicalOperations;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.AddROIDialog;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.AddTransformDialog;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.EditOriginDialog;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.EditROILabelDialog;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.FileSaveAsChooser;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.OverlayOntoDialog;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.PropagateROIDialog;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.ROICalculatorDialog;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.RankFilterDialog;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.ReflectROIDialog;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.SaveROIPanel;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.SelectCoordinateDialog;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.ShrinkWrapDialog;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.ThresholdToROIDialog;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.TimepointSelectionDialog;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.TimeseriesStatsDialog;
import edu.uthscsa.ric.mango.viewerslice.dialogs.roiinspector.ROIInspectorTool;
import edu.uthscsa.ric.mango.viewerslice.dialogs.series.Timeseries;
import edu.uthscsa.ric.mango.viewerslice.dialogs.series.TimeseriesTool;
import edu.uthscsa.ric.mango.viewerslice.dialogs.transform.EditTransformTool;
import edu.uthscsa.ric.mango.viewerslice.dialogs.webpage.Webpage;
import edu.uthscsa.ric.mango.viewerslice.dialogs.webpage.WebpageImageImpl;
import edu.uthscsa.ric.mango.viewerslice.dialogs.webpage.WebpageSurfaceImpl;
import edu.uthscsa.ric.mango.viewerslice.keyboard.KeyboardMap;
import edu.uthscsa.ric.mango.viewerslice.menus.ViewerMenu;
import edu.uthscsa.ric.mango.viewerslice.operations.LineOps;
import edu.uthscsa.ric.mango.viewerslice.screen.OverlayManager;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenSlice;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LookupTableManager;
import edu.uthscsa.ric.mango.viewerslice.window.ViewerAssociatedWindow;
import edu.uthscsa.ric.mango.viewerslice.window.ViewerFrame;
import edu.uthscsa.ric.mango.viewerslice.window.ViewerWindowManager;
import edu.uthscsa.ric.mango.viewersurface.SurfaceManager;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.menus.SurfaceViewerMenu;
import edu.uthscsa.ric.mango.viewersurface.operations.building.SurfaceBuildParameters;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceIOListener;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceReader;
import edu.uthscsa.ric.mango.viewersurface.window.SurfaceFrame;
import edu.uthscsa.ric.mango.window.Toolbox;
import edu.uthscsa.ric.roi.Line;
import edu.uthscsa.ric.roi.Metadata;
import edu.uthscsa.ric.roi.MetadataUser;
import edu.uthscsa.ric.roi.PointsManager;
import edu.uthscsa.ric.roi.PointsSpecialManager;
import edu.uthscsa.ric.roi.ROI;
import edu.uthscsa.ric.roi.ROIData;
import edu.uthscsa.ric.roi.ROILabelUser;
import edu.uthscsa.ric.roi.ROIMaskManager;
import edu.uthscsa.ric.roi.ROIOperationTreeNode;
import edu.uthscsa.ric.roi.ShapesManager;
import edu.uthscsa.ric.roi.ShapesSpecialManager;
import edu.uthscsa.ric.roi.lines.LineListener;
import edu.uthscsa.ric.roi.lines.LineUser;
import edu.uthscsa.ric.roi.lines.display.LOIOrthogonal;
import edu.uthscsa.ric.roi.lines.display.LOIShape;
import edu.uthscsa.ric.roi.lines.manager.LOIManager;
import edu.uthscsa.ric.roi.lines.manager.LOISpecialManager;
import edu.uthscsa.ric.roi.mask.Mask;
import edu.uthscsa.ric.roi.mask.buffers.AbstractROIBuffer;
import edu.uthscsa.ric.roi.mask.clipboard.ROIClipboardUser;
import edu.uthscsa.ric.roi.mask.manager.ROIListener;
import edu.uthscsa.ric.roi.mask.manager.ROIManager;
import edu.uthscsa.ric.roi.mask.manager.ROIUser;
import edu.uthscsa.ric.roi.points.POI;
import edu.uthscsa.ric.roi.points.PointListener;
import edu.uthscsa.ric.roi.points.PointUser;
import edu.uthscsa.ric.roi.points.manager.POIManager;
import edu.uthscsa.ric.roi.points.manager.POISpecialManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.DesktopUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.JVMUtilities;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.utilities.ProgressBar;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.visualization.surface.primitives.Shape;
import edu.uthscsa.ric.visualization.surface.primitives.Surface;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.Cluster;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.Header;
import edu.uthscsa.ric.volume.Histogram;
import edu.uthscsa.ric.volume.Image;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageTransform;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.LabelListener;
import edu.uthscsa.ric.volume.LabelManager;
import edu.uthscsa.ric.volume.Orientation;
import edu.uthscsa.ric.volume.ReadableHeader;
import edu.uthscsa.ric.volume.Transform;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.VolumeIOException;
import edu.uthscsa.ric.volume.VolumeListener;
import edu.uthscsa.ric.volume.VolumeUser;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.WritableHeader;
import edu.uthscsa.ric.volume.formats.dicom.DICOM;
import edu.uthscsa.ric.volume.formats.nifti.NIFTI;
import edu.uthscsa.ric.volume.operations.OperationBuilder;
import edu.uthscsa.ric.volume.operations.OperationListener;
import edu.uthscsa.ric.volume.operations.calculation.CalcOp;
import edu.uthscsa.ric.volume.operations.calculation.CalcSeriesOp;
import edu.uthscsa.ric.volume.operations.calculation.ImageCalcExpression;
import edu.uthscsa.ric.volume.operations.calculation.ImageCalcExpressionImpl;
import edu.uthscsa.ric.volume.operations.filter.AbstractFilter;
import edu.uthscsa.ric.volume.operations.filter.AbstractFilterRank;
import edu.uthscsa.ric.volume.operations.filter.FilterBuffer;
import edu.uthscsa.ric.volume.operations.filter.FilterManager;
import edu.uthscsa.ric.volume.operations.filter.FilterOp;
import edu.uthscsa.ric.volume.operations.filter.FilterRankSlice;
import edu.uthscsa.ric.volume.operations.filter.FilterRankTime;
import edu.uthscsa.ric.volume.operations.filter.FilterRankVolume;
import edu.uthscsa.ric.volume.operations.range.Range;
import edu.uthscsa.ric.volume.operations.range.VolumeRangeOp;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import edu.uthscsa.ric.volume.operations.stats.LineStatROIOp;
import edu.uthscsa.ric.volume.operations.stats.PointStatROIOp;
import edu.uthscsa.ric.volume.operations.stats.SeriesStatOp;
import edu.uthscsa.ric.volume.operations.stats.SeriesStatROIOp;
import edu.uthscsa.ric.volume.operations.stats.SliceStatOp;
import edu.uthscsa.ric.volume.operations.stats.SliceStatROIOp;
import edu.uthscsa.ric.volume.operations.stats.VolumeStatOp;
import edu.uthscsa.ric.volume.operations.stats.VolumeStatROIOp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class SliceViewer
extends JPanel
implements Capturable,
DropTargetListener,
KeyListener,
LabelListener,
LineListener,
LineUser,
MetadataUser,
OperationListener,
PointListener,
PointUser,
ROIClipboardUser,
ROILabelUser,
ROIListener,
ROIUser,
Recordable,
SeriesLabelEditorUser,
LogicalOpListener,
SurfaceIOListener,
ViewerController,
VolumeListener,
VolumeManager,
VolumeUser {
    private CineSlice cine;
    private ClusterAnalysisTool clusterAnalysis;
    private ClusterROIAnalysisTool clusterROIAnalysis;
    private Crosssection crosssection;
    private Dimension startSize;
    private EditTransformTool transformManualPanel;
    private File roiFileGZIP;
    private FileSaveAsChooser saveAsAfterRangeUpdate;
    private FilterBuffer filterBuffer;
    private HistogramPanel histogram;
    private ImageCalcExpression startOperation;
    private ImageCalculatorTool imageCalc;
    private ImageInfoDialog imageInfo;
    private LOIManager loiManagerAxial;
    private LOIManager loiManagerCoronal;
    private LOIManager loiManagerSagittal;
    private LOIOrthogonal angleShape;
    private LOIOrthogonal rulerShape;
    private LOISpecialManager loiManagerAxialP;
    private LOISpecialManager loiManagerCoronalP;
    private LOISpecialManager loiManagerSagittalP;
    private Layout layout;
    private LogicalAnalysisTool logicalManager;
    private Mango mango;
    private Object scriptResult;
    private OverlayManager overlayManager;
    private POIManager poiManager;
    private POISpecialManager poiManagerSpecial;
    private Point startLocation;
    private edu.uthscsa.ric.mango.components.progressbar.ProgressBar pbIndeterminate;
    private ProjectionFrame projection;
    private ROIInspectorTool roiInspector;
    private ROIManager roiManager;
    private ScreenSlice axialImage;
    private ScreenSlice coronalImage;
    private ScreenSlice sagittalImage;
    private ScreenVolume baseScreenVolume;
    private ScreenVolume currentScreenVolume;
    private SliceViewerSyncer viewerSyncer;
    private String recordableName;
    private SurfaceViewer surfaceRender;
    private Timeseries timeseries;
    private Toolbox toolBox;
    private URI loadedURI;
    private Vector<ViewerListener> listeners;
    private Vector<WeakReference<SliceDirectionListener>> sliceDirectionListeners;
    private ViewerFrame frame;
    private ViewerWindowManager windowManager;
    private Volume volume;
    private VolumeData volData;
    private boolean checkRangeForBackgroundLoad;
    private boolean clearROIAfterCopy;
    private boolean closeOnSave;
    private boolean containsMouse;
    private boolean hideROI;
    private boolean imageLoaded;
    private boolean imageSaved;
    private boolean isCleared;
    private boolean isClosing;
    private boolean isDead;
    private boolean isEditingDisabled;
    private boolean isTempImage;
    private boolean loadNextAfterRevert;
    private boolean navigationDisabled;
    private boolean overlayWillBeSaved;
    private boolean revertingToSaved;
    private boolean roiManagerWillBeSaved;
    private boolean scriptWaiting;
    private boolean scrollwheelDirectionFlip;
    private boolean scrollwheelSlices;
    private boolean showAllOverlay;
    private boolean showCurrentOverlay;
    private boolean showDicomOverlay;
    private boolean showLabels;
    private boolean showLineAngle;
    private boolean showLineLength;
    private boolean showLowerCrosshairs;
    private boolean showMainCrosshairs;
    private boolean showOrientation;
    private boolean showROIEdge;
    private boolean showROIMask;
    private boolean showROISliceStats;
    private boolean specialNavFunctionPrimed;
    private boolean stopPainting;
    private boolean updatedPostLoadTimeseries;
    private boolean viewerInitialized;
    private boolean volumeWillBeReloaded;
    private boolean volumeWillBeSaved;
    private boolean voxelDisplayMode;
    private double longestDimSize;
    private double zoomFactor;
    private double zoomFactorPrevious;
    private double zoomStored;
    private int longestDim;
    private int orientationCertainty;
    private int panAmountX;
    private int panAmountY;
    private int panAmountZ;
    private int panLocX;
    private int panLocY;
    private int panLocZ;
    private int zoomLocX;
    private int zoomLocY;
    private int zoomLocZ;
    private final List<CurrentVolumeListener> currentVolumeListeners;
    private static final long serialVersionUID = 1L;
    protected boolean singleSliceMode;
    protected boolean orthoSliceMode;
    protected boolean orthoWide;
    protected ScreenSlice lowerImageLeft;
    protected ScreenSlice lowerImageRight;
    protected ScreenSlice mainImage;
    public static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter();
    public static final String ERROR_TITLE_OPERATION = "Image Operation Failed";
    public static final String ERROR_TITLE_SAVE = "Image Save Failed";
    public static final String PROBLEM_SAVING_IMAGE_FILE = "Problem saving image file!\n";
    public static final String TEXT_GO_TO_COORDINATE = "Go To Coordinate";
    public static final String TEXT_IMAGE_LOAD_FAILED = "Image Load Failed";
    public static final String TEXT_PROBLEM_LOADING_IMAGE_FILE = "Problem loading image file!\n\n";
    public static final String TEXT_RANK_FILTER = "Rank Filter";
    public static final String TEXT_ROI_OPERATION_FAILED = "ROI Operation Failed";
    public static final String TEXT_SIZE = "Size";
    public static final String TITLE_ROI_LOAD_FAILED = "ROI Load Failed";
    public static final String WINDOW_DOCUMENT_MODIFIED = "Window.documentModified";
    public static final double DEFAULT_HEIGHT_RATIO = 0.75;
    public static final double ZOOM_FACTOR_MAX = 10.0;
    public static final double ZOOM_FACTOR_MIN = 1.0;
    public static final int GAP = 2;
    public static final int MAXIMUM_WINDOW_TITLE_NAME_LENGTH = 25;

    public static int convertCoordinateOriginX(int xLoc, int xDim) {
        if ((Mango.getInstance().getImageIndexOrigin() & 1) == 1) {
            return xDim - xLoc - 1;
        }
        return xLoc;
    }

    public static int convertCoordinateOriginY(int yLoc, int yDim) {
        if ((Mango.getInstance().getImageIndexOrigin() & 2) == 2) {
            return yDim - yLoc - 1;
        }
        return yLoc;
    }

    public static int convertCoordinateOriginZ(int zLoc, int zDim) {
        if ((Mango.getInstance().getImageIndexOrigin() & 4) == 4) {
            return zDim - zLoc - 1;
        }
        return zLoc;
    }

    public SliceViewer(Mango mango, Point startLocation, Dimension startSize) {
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.showROIEdge = true;
        this.showROIMask = true;
        this.showROISliceStats = true;
        this.showLabels = true;
        this.showDicomOverlay = true;
        this.zoomFactor = 1.0;
        this.zoomFactorPrevious = 1.0;
        this.mango = mango;
        this.toolBox = mango.getToolBox();
        this.setStartLocation(startLocation);
        this.setStartSize(startSize);
        this.orthoSliceMode = true;
        this.singleSliceMode = false;
        this.listeners = new Vector();
        this.sliceDirectionListeners = new Vector();
        this.viewerSyncer = mango.getViewerSyncer();
        this.currentVolumeListeners = new ArrayList<CurrentVolumeListener>();
        this.zoomStored = 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCurrentVolumeListener(CurrentVolumeListener listener) {
        List<CurrentVolumeListener> list = this.currentVolumeListeners;
        synchronized (list) {
            this.currentVolumeListeners.add(listener);
        }
    }

    public LOIShape addLineFromSurface(Coordinate start, Coordinate end, int color, int dir) {
        GeneralPath path = new GeneralPath();
        LOIShape loi = null;
        if (dir == 0) {
            path.moveTo(start.xInt, start.yInt);
            path.lineTo(end.xInt, end.yInt);
            loi = new LOIShape(path.getPathIterator(null), start.zInt, color, this, this);
            this.loiManagerAxial.addLOI(loi);
        } else if (dir == 1) {
            path.moveTo(start.xInt, start.zInt);
            path.lineTo(end.xInt, end.zInt);
            loi = new LOIShape(path.getPathIterator(null), start.yInt, color, this, this);
            this.loiManagerCoronal.addLOI(loi);
        } else {
            path.moveTo(start.yInt, start.zInt);
            path.lineTo(end.yInt, end.zInt);
            loi = new LOIShape(path.getPathIterator(null), start.xInt, color, this, this);
            this.loiManagerSagittal.addLOI(loi);
        }
        if (loi != null) {
            loi.setListenerAndUser(this, this);
            this.shapeAdded(loi, false);
        }
        return loi;
    }

    public void addListener(ViewerListener aListener) {
        this.listeners.add(aListener);
    }

    public void addMoreROIColors() {
        this.roiManager.increaseColors();
    }

    public void addMouseListener(MouseListener ml, int sliceDir) {
        if (sliceDir == 0) {
            this.axialImage.addMouseListener(ml);
        } else if (sliceDir == 1) {
            this.coronalImage.addMouseListener(ml);
        } else if (sliceDir == 2) {
            this.sagittalImage.addMouseListener(ml);
        }
    }

    public void addMouseMotionListener(MouseMotionListener ml, int sliceDir) {
        if (sliceDir == 0) {
            this.axialImage.addMouseMotionListener(ml);
        } else if (sliceDir == 1) {
            this.coronalImage.addMouseMotionListener(ml);
        } else if (sliceDir == 2) {
            this.sagittalImage.addMouseMotionListener(ml);
        }
    }

    public ViewerController addNewImage(ImageDimensions id, VoxelDimensions vd, ImageRange ir, ByteBuffer[] bufs, String orientation, String name) {
        return this.mango.addViewer(id, vd, ir, bufs, orientation, name);
    }

    public ViewerController addNewImage(ImageDimensions id, VoxelDimensions vd, String orientation, String name) {
        return this.mango.addViewer(id, vd, orientation, name);
    }

    public void addOverlay(String openLocation, boolean parametric) {
        this.doLoadOverlay(new File(openLocation).toURI(), this.getOverlayManager().getNextLUTType(), parametric, true);
    }

    public void addOverlay(URI uri, ImageVolume imageVolume, String colorTable, double transparency) {
        Volume overlayVolume = (Volume)imageVolume;
        overlayVolume.addListener(this);
        overlayVolume.setProgressBarListener(this.toolBox);
        ScreenVolume overlay = new ScreenVolume(overlayVolume, null, colorTable != null ? colorTable : this.overlayManager.getNextLUTType(), false);
        overlay.setAlpha(1.0 - transparency);
        overlay.setURI(uri);
        overlay.setUsingTransform(true);
        if (overlayVolume.getImageMax() <= overlayVolume.getImageMin()) {
            overlayVolume.findRangeVolumeAsync(overlay);
        } else {
            this.initializeOverlay(overlay);
        }
    }

    public void addOverlayOnto(VolumeManager context, String colorTable) {
        SliceViewer baseViewer = (SliceViewer)context;
        baseViewer.frameToFront();
        baseViewer.loadOverlayScreenVolume(this.getVolume(), this.getLoadedURI(), colorTable, null, false, false);
    }

    public void addOverlayURL(String url) {
        try {
            this.doLoadOverlay(new URL(url).toURI(), this.getOverlayManager().getNextLUTType(), false, true);
        }
        catch (MalformedURLException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (URISyntaxException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    public POI addPointFromSurface(Coordinate coor, int color) {
        POI poi = new POI(coor.xInt, coor.yInt, coor.zInt, color);
        this.poiManager.addPOI(poi, true, false);
        this.pointAdded(poi, false);
        return poi;
    }

    public void addSliceDirectionListener(SliceDirectionListener sliceDirectionListener) {
        this.sliceDirectionListeners.add(new WeakReference<SliceDirectionListener>(sliceDirectionListener));
    }

    public void addSliceListener(SliceListener sl, int sliceDirection) {
        if (sliceDirection == 0) {
            this.axialImage.addSliceListener(sl);
        } else if (sliceDirection == 1) {
            this.coronalImage.addSliceListener(sl);
        } else if (sliceDirection == 2) {
            this.sagittalImage.addSliceListener(sl);
        }
    }

    public void addTransform() {
        AddTransformDialog dialog = new AddTransformDialog(this);
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.transformManualPanel, dialog, "Load Transform", -1, null);
        int selection = jopf.show();
        if (selection == 0) {
            double[][] transform = dialog.getTransform();
            if (transform != null) {
                if (dialog.isCoordinate()) {
                    int rotationCode = 0;
                    Coordinate rotationCoord = null;
                    if (dialog.isOriginAsCenter()) {
                        rotationCode = 1;
                        rotationCoord = this.volume.getOrigin();
                    } else if (dialog.isCurrentAsCenter()) {
                        rotationCode = 2;
                        rotationCoord = new Coordinate((double)this.getSagittalSliceNumber(), (double)this.getCoronalSliceNumber(), (double)this.getAxialSliceNumber());
                    }
                    transform = this.getVolume().convertFromCoordinateTransform(transform, dialog.isOriginAsCenter(), dialog.isCurrentAsCenter(), rotationCoord);
                    this.getVolume().loadTransform(new Matrix(transform), rotationCode, rotationCoord);
                } else if (dialog.isImage()) {
                    transform = this.getVolume().convertToIndexTransform(transform);
                    this.getVolume().loadTransform(new Matrix(transform), 0, null);
                }
                this.addTransformPost();
            } else {
                this.showErrorDialog("Problem reading that transform!", "Transform Load Failed");
            }
        }
    }

    @Deprecated
    public void addTransform(int type, double[][] mat, String name) {
        if (mat.length != 4) {
            return;
        }
        for (int ctr = 0; ctr < 4; ++ctr) {
            if (mat[ctr].length == 4) continue;
            return;
        }
        if (type != 0) {
            return;
        }
        this.volume.loadTransform(new Matrix(mat), 0, null);
        this.addTransformPost();
    }

    public void addTransformPost() {
        this.mango.getToolBox().updateTransformPopupMenu();
        this.getScreenVolume().setUsingTransform(true);
        this.updateTransformMode();
        this.updateTransformManualPanel();
        if (this.transformManualPanel != null) {
            this.transformManualPanel.resetSliderTextFields();
        }
        this.mango.getToolBox().updateCurrentState();
    }

    public void associatePluginWindow(String aDescription, JFrame aFrame) {
        ViewerAssociatedWindow vaw = new ViewerAssociatedWindow(this, aFrame, aDescription);
        this.associateWindow(vaw);
    }

    public void associateWindow(ViewerAssociated aWindow) {
        this.windowManager.associate(aWindow);
    }

    public void buildProjection(BuildProjectionParameters bpp) {
        this.recordAction("buildProjection", new String[]{String.valueOf(bpp.rankType), String.valueOf(bpp.planeOfProjection), String.valueOf(bpp.resX), String.valueOf(bpp.resY), String.valueOf(bpp.resZ), String.valueOf(bpp.axisOfRotation), String.valueOf(bpp.smoothness)}, true);
        ProjectionFrame pd = new ProjectionFrame(this.mango, this, bpp);
        this.setProjection(pd);
        pd.startBuild(false);
    }

    public ProjectionManager buildProjection(int rankType, int sliceDirection, double resX, double resY, double resZ, int rotationAxis, int projectionQuality) {
        BuildProjectionParameters bpp = new BuildProjectionParameters();
        bpp.axisOfRotation = rotationAxis;
        bpp.planeOfProjection = sliceDirection;
        bpp.smoothness = projectionQuality;
        bpp.resX = (float)resX;
        bpp.resY = (float)resY;
        bpp.resZ = (float)resZ;
        bpp.rankType = rankType;
        ProjectionFrame pd = new ProjectionFrame(this.mango, this, bpp);
        this.setProjection(pd);
        pd.startBuild(true);
        return pd.getProjectionView();
    }

    public void buildSurface() {
        SurfaceBuildParameters params = new SurfaceBuildParameters(this.volume);
        params.setThreshold((float)this.baseScreenVolume.getScreenMin());
        params.setFeatureError((float)((this.volume.getXSize() + this.volume.getYSize() + this.volume.getZSize()) / 3.0 * 0.2));
        this.buildSurface(params, false);
    }

    public SurfaceManager buildSurface(double threshold, boolean percentMax, boolean shrinkWrap, boolean maximum, boolean imageSmoothing, double width, int kernelSize, double resX, double resY, double resZ, boolean surfaceSmoothing, double pointError, double featureAngle, int iterations) {
        SurfaceBuildParameters params = new SurfaceBuildParameters(this.volume);
        params.setUseImageSmoothing(imageSmoothing);
        params.setUseSurfaceSmoothing(surfaceSmoothing);
        params.setSmoothingKernel(kernelSize);
        params.setSurfaceSmoothingIterations(iterations);
        params.setThreshold(percentMax ? (float)(threshold / 100.0 * this.getBaseVolume().getImageMax()) : (float)threshold);
        params.setUseNegative(maximum);
        params.setSmoothingWidth((float)width);
        params.setResX((float)resX);
        params.setResY((float)resY);
        params.setResZ((float)resZ);
        params.setFeatureError((float)pointError);
        params.setFeatureAngle((float)featureAngle);
        params.setUseShrinkWrap(shrinkWrap);
        this.buildSurface(params, true);
        return this.surfaceRender;
    }

    public Surface buildSurface(SurfaceBuildParameters params, boolean sameThread) {
        this.recordAction("buildSurface", new String[]{String.valueOf(params.getThreshold()), ScriptUtils.convertBoolean(params.isUsePercentMax()), ScriptUtils.convertBoolean(params.isUseShrinkWrap()), ScriptUtils.convertBoolean(params.isUseNegative()), ScriptUtils.convertBoolean(params.isUseImageSmoothing()), String.valueOf(params.getFilterFWHM()), String.valueOf(params.getFilterSize()), String.valueOf(params.getResX()), String.valueOf(params.getResY()), String.valueOf(params.getResZ()), ScriptUtils.convertBoolean(params.isUseSurfaceSmoothing()), String.valueOf(params.getFeatureError()), String.valueOf(params.getFeatureAngle()), String.valueOf(params.getNumSmoothingIterations())}, true);
        if (this.surfaceRender == null) {
            this.surfaceRender = new SurfaceViewer(this);
        }
        return this.surfaceRender.buildSurface(params, sameThread);
    }

    public void calculateScreenSliceTransforms() {
        if (this.orthoWide) {
            int width = this.getPreferredSize().height - 6;
            AffineTransform transform = new AffineTransform();
            this.getTransformParameters(this.mainImage, transform, width, false);
            double scaleMainX = transform.getScaleX();
            double scaleMainY = transform.getScaleY();
            double transMainX = transform.getTranslateX();
            double transMainY = transform.getTranslateY();
            this.getTransformParameters(this.lowerImageLeft, transform, width, true);
            double scaleLowerLeftX = transform.getScaleX();
            double scaleLowerLeftY = transform.getScaleY();
            double transLowerLeftX = transform.getTranslateX();
            double transLowerLeftY = transform.getTranslateY();
            this.getTransformParameters(this.lowerImageRight, transform, width, true);
            double scaleLowerRightX = transform.getScaleX();
            double scaleLowerRightY = transform.getScaleY();
            double transLowerRightX = transform.getTranslateX();
            double transLowerRightY = transform.getTranslateY();
            this.mainImage.setTransform(scaleMainX, 0.0, 0.0, scaleMainY, transMainX, transMainY);
            this.lowerImageLeft.setTransform(scaleLowerLeftX, 0.0, 0.0, scaleLowerLeftY, transLowerLeftX, transLowerLeftY);
            this.lowerImageRight.setTransform(scaleLowerRightX, 0.0, 0.0, scaleLowerRightY, transLowerRightX, transLowerRightY);
            this.mainImage.setBoundingBox(4, 2, width, width);
            this.lowerImageLeft.setBoundingBox(width + 6, width / 2 + 3, width / 2 - 1, width / 2 - 1);
            this.lowerImageRight.setBoundingBox(width + 6, 2, width / 2 - 1, width / 2 - 1);
        } else {
            int width = (int)this.getPreferredSize().getWidth() - 8;
            AffineTransform transform = new AffineTransform();
            this.getTransformParameters(this.mainImage, transform, width, false);
            double scaleMainX = transform.getScaleX();
            double scaleMainY = transform.getScaleY();
            double transMainX = transform.getTranslateX();
            double transMainY = transform.getTranslateY();
            this.getTransformParameters(this.lowerImageLeft, transform, width, true);
            double scaleLowerLeftX = transform.getScaleX();
            double scaleLowerLeftY = transform.getScaleY();
            double transLowerLeftX = transform.getTranslateX();
            double transLowerLeftY = transform.getTranslateY();
            this.getTransformParameters(this.lowerImageRight, transform, width, true);
            double scaleLowerRightX = transform.getScaleX();
            double scaleLowerRightY = transform.getScaleY();
            double transLowerRightX = transform.getTranslateX();
            double transLowerRightY = transform.getTranslateY();
            this.mainImage.setTransform(scaleMainX, 0.0, 0.0, scaleMainY, transMainX, transMainY);
            this.lowerImageLeft.setTransform(scaleLowerLeftX, 0.0, 0.0, scaleLowerLeftY, transLowerLeftX, transLowerLeftY);
            this.lowerImageRight.setTransform(scaleLowerRightX, 0.0, 0.0, scaleLowerRightY, transLowerRightX, transLowerRightY);
            this.mainImage.setBoundingBox(4, 4, width, width);
            this.lowerImageLeft.setBoundingBox(2, width + 8, width / 2, width / 2);
            this.lowerImageRight.setBoundingBox(width / 2 + 6, width + 8, width / 2, width / 2);
        }
    }

    public boolean canBeSaved() {
        return this.volume != null && !this.mango.isApplet() && !this.isRGB() && (this.volumeCanBeSaved() || this.overlayCanBeSaved() || this.roiCanBeSaved(false));
    }

    public boolean canPaste() {
        boolean canPastePOI = Mango.getClipboardPoi().canPaste();
        boolean canPasteLOI = Mango.getClipboardLoi().canPaste();
        boolean canPasteROI = Mango.getClipboardRoi().canPaste();
        return canPasteLOI || canPastePOI || canPasteROI;
    }

    public boolean canUpdateMenu() {
        return !this.revertingToSaved && !this.isVolumeWillBeReloaded();
    }

    @Override
    public BufferedImage captureImage() {
        BufferedImage img = null;
        img = this.projection != null && this.projection.isActive() ? this.projection.getProjectionView().captureImage() : (this.surfaceRender != null && this.surfaceRender.getFrame() != null && this.surfaceRender.getFrame().isActive() ? this.surfaceRender.captureImage() : this.getMainImage());
        return img;
    }

    public void captureLayout(final String saveLocation, final int rows, final int columns, final int startSlice, final int skipSlices, final boolean series, final boolean useLabels, final boolean useColorBars, final boolean useText, final String title, final String footnote) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.layout = new Layout(SliceViewer.this.mango, SliceViewer.this, true);
                SliceViewer.this.layout.setParametersAndSave(saveLocation, rows, columns, startSlice, skipSlices, series, useLabels, useColorBars, useText, title, footnote);
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void captureSnapshot(String location) {
        Snapshot.takeSnapshot(location, this);
    }

    public void captureVideoStart(String saveLocation, int videoFormat, int videoQuality, int fps, boolean animate) {
        this.cine = new CineSlice(this, this.mainImage, true);
        this.cine.startSilentFreeRecording(fps, videoQuality, videoFormat, new File(saveLocation), animate);
    }

    public void captureVideoStop() {
        if (this.cine != null) {
            this.cine.stopSilentRecording();
            this.cine = null;
        }
    }

    public void clearHistogram() {
        this.axialImage.clearHistogram();
        this.coronalImage.clearHistogram();
        this.sagittalImage.clearHistogram();
    }

    public void clearKeyboardMode() {
        this.toolBox.setSelectionMode(0);
        this.setSpecialNavFunctionPrimed(false);
    }

    public void clearOverlayData() {
        this.updateOverlaySensitiveData();
        this.axialImage.clearOverlayData();
        this.coronalImage.clearOverlayData();
        this.sagittalImage.clearOverlayData();
    }

    public void clearPolyLine() {
        if (!this.isEditingDisabled()) {
            this.mainImage.clearPolyLine();
            this.mainImage.repaint();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean close() {
        this.recordAction("disposeVolumeManager");
        if (this.isClosing()) return true;
        this.setClosing(true);
        this.notifyAllListenersOfClosing();
        if (!this.canBeSaved()) {
            this.cleanUp();
            return true;
        }
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.frame, "Save changes before closing?  ", this.getImageTitle(), 3, null, 1);
        int option = jopf.show();
        if (option == 0) {
            this.closeOnSave = true;
            this.saveViewer(false);
            return true;
        }
        if (option == 1) {
            this.cleanUp();
            return true;
        }
        this.setClosing(false);
        return false;
    }

    public void closeAssociatedWindow(String aDescription) {
        this.windowManager.closeAssociatedWindow(aDescription);
    }

    public boolean containsIndex(Coordinate coor) {
        return coor.xInt >= 0 && coor.xInt < this.volume.getXDim() && coor.yInt >= 0 && coor.yInt < this.volume.getYDim() && coor.zInt >= 0 && coor.zInt < this.volume.getZDim();
    }

    public synchronized void continueScript() {
        this.scriptWaiting = false;
        this.notifyAll();
    }

    public double convertCoordinateOriginMainX(double loc) {
        int sliceDir = this.getMainSliceDirection();
        if (sliceDir == 0 || sliceDir == 1) {
            if ((this.mango.getImageIndexOrigin() & 1) == 1) {
                return (double)this.getXDim() - loc - 1.0;
            }
            return loc;
        }
        if ((this.mango.getImageIndexOrigin() & 2) == 2) {
            return (double)this.getYDim() - loc - 1.0;
        }
        return loc;
    }

    public double convertCoordinateOriginMainY(double loc) {
        int sliceDir = this.getMainSliceDirection();
        if (sliceDir == 1 || sliceDir == 2) {
            if ((this.mango.getImageIndexOrigin() & 4) == 4) {
                return (double)this.getZDim() - loc - 1.0;
            }
            return loc;
        }
        if ((this.mango.getImageIndexOrigin() & 2) == 2) {
            return (double)this.getYDim() - loc - 1.0;
        }
        return loc;
    }

    public int convertCoordinateOriginX(int xLoc) {
        return SliceViewer.convertCoordinateOriginX(xLoc, this.getXDim());
    }

    public int convertCoordinateOriginY(int yLoc) {
        return SliceViewer.convertCoordinateOriginY(yLoc, this.getYDim());
    }

    public int convertCoordinateOriginZ(int zLoc) {
        return SliceViewer.convertCoordinateOriginZ(zLoc, this.getZDim());
    }

    public void convertIndexToWorldCoordinate(Coordinate coor) {
        this.volData.convertIndexToWorldCoordinate(coor);
    }

    public void convertWorldToIndexCoordinate(Coordinate coor) {
        this.volData.convertWorldToIndexCoordinate(coor);
    }

    public void coordinateTypeSelectionChanged(boolean forceSurfaceUpdate) {
        this.reconcileOverlayTimeseries();
        if (this.crosssection.getParentFrame() != null) {
            this.crosssection.updateCrosssection();
        }
        if (this.timeseries.getParentFrame() != null) {
            this.timeseries.updateTimeseries();
        }
        if (this.transformManualPanel != null) {
            this.transformManualPanel.updateViewer(false);
        }
        if (!this.toolBox.isWorldMode() && this.volume.isWorldSpaceOnly()) {
            this.setOrientationCertainty(0);
            this.setViewOptionOrientation(true);
        } else {
            this.setOrientationCertainty(this.volume.getOrientationCertainty());
        }
        if (this.surfaceRender != null) {
            this.updateSurface();
            this.updateSurfaceTransform(forceSurfaceUpdate);
        }
    }

    @Override
    public void copyCompleted(boolean success, String message) {
        if (success) {
            if (this.clearROIAfterCopy) {
                this.doClearROI(false, true);
                this.clearROIAfterCopy = false;
            }
        } else {
            this.showErrorDialog(message, "ROI Clipboard Error");
        }
    }

    public JButton createColorPickerButton(MangoColorSelectedListener listener, boolean showUsedOnly) {
        return new MangoColorButton(this, listener, showUsedOnly);
    }

    @Deprecated
    public void createWebpage(String saveLocation, String title, boolean useOverlays, boolean useAtlas, boolean useKioskMode, boolean outputSingleFile) {
        this.createWebpage(saveLocation, title, useOverlays, useAtlas, false, useKioskMode, outputSingleFile);
    }

    public void createWebpage(String saveLocation, String title, boolean useOverlays, boolean useAtlas, boolean useSurfaces, boolean useKioskMode, boolean outputSingleFile) {
        int numSurfaces;
        WebpageImageImpl baseImage = new WebpageImageImpl(this.getBaseScreenVolume());
        Vector<WebpageImageImpl> overlayImages = new Vector<WebpageImageImpl>();
        OverlayManager overlayManager = this.getOverlayManager();
        int numOverlays = overlayManager.getNumInStack();
        if (numOverlays > 0) {
            ScreenVolume[] overlays;
            for (ScreenVolume overlay : overlays = overlayManager.getAllOverlays()) {
                if (overlay == null) continue;
                boolean parametric = overlay.isParametric();
                boolean negative = overlay.isNegative();
                if (parametric && negative) continue;
                ScreenVolume parametricPartner = Webpage.findParametricPartner(overlays, overlay);
                WebpageImageImpl ip = new WebpageImageImpl(overlay, parametricPartner);
                overlayImages.add(ip);
            }
        }
        Vector<WebpageSurfaceImpl> surfacePanels = new Vector<WebpageSurfaceImpl>();
        if (this.surfaceRender != null && (numSurfaces = this.surfaceRender.getSurfaces().length) > 0) {
            for (Surface surface : this.surfaceRender.getSurfaces()) {
                surfacePanels.add(new WebpageSurfaceImpl(surface));
            }
        }
        Webpage.doCreateWebpage(this, saveLocation, baseImage, overlayImages, surfacePanels, true, useOverlays, useSurfaces, this.mango.getToolBox().isWorldMode(), this.isShowingOrientation(), !this.isVoxelDisplayMode(), true, this.isSingleSliceMode(), useKioskMode, false, true, outputSingleFile, title, null, useAtlas, this.mango.getToolBox().getCurrentAtlas(), true, this.isShowingRuler(), this.isRadiologicalMode(), true, false, false);
    }

    public void deassociateWindow(ViewerAssociated window) {
        this.windowManager.deassociate(window);
    }

    public boolean decrement(final int direction) {
        final boolean[] value = new boolean[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                value[0] = SliceViewer.this.decrementSlice(direction);
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
        return value[0];
    }

    public void decrementROIToolSize() {
        if (this.mango.getROIToolSize() > 0) {
            this.mango.decreaseROIToolSize();
            this.mainImage.updateStructureElement();
            if (this.mainImage.isPressed()) {
                this.mainImage.doROIFill();
            }
            this.mainImage.repaint();
        }
    }

    public boolean decrementSlice(int sliceTypeVal) {
        boolean baseImageIsCurrent;
        int sliceType = sliceTypeVal;
        if (sliceTypeVal == -1) {
            sliceType = this.getMainSliceDirection();
            this.recordAction("decrement", new String[]{this.getScriptObjectName() + ".sliceDirection"});
        } else {
            this.recordAction("decrement", new String[]{String.valueOf(sliceType)});
        }
        boolean didIncrement = false;
        boolean hasBaseImageTimeseries = this.getScreenVolume().getVolume().getNumTimepoints() > 1;
        boolean hasOverlayTimeseries = this.hasOverlayTimeseries();
        boolean bl = baseImageIsCurrent = this.getScreenVolume() == this.getCurrentScreenVolume();
        if (sliceType == 3) {
            ScreenVolume refTimeseries;
            if (this.isNavigationDisabled()) {
                return false;
            }
            if (baseImageIsCurrent && hasBaseImageTimeseries) {
                didIncrement = this.getCurrentScreenVolume().getVolume().getCurrentTimepoint() > 0;
                if (didIncrement) {
                    this.getScreenVolume().getVolume().setCurrentTimepoint(this.getScreenVolume().getVolume().getCurrentTimepoint() - 1);
                    this.updateSyncSeries();
                }
            } else if (hasOverlayTimeseries && (didIncrement = (refTimeseries = this.findTopOverlayTimeseries()).getVolume().getCurrentTimepoint() > 0)) {
                refTimeseries.getVolume().setCurrentTimepoint(refTimeseries.getVolume().getCurrentTimepoint() - 1);
                this.reconcileOverlayTimeseries(refTimeseries);
            }
            if (didIncrement) {
                this.toolBox.setMouseLabelInfoIncrement(3, 0);
                if (this.frame != null) {
                    this.updateWindowTitle();
                }
                if (this.crosssection.getParentFrame() != null) {
                    this.crosssection.updateCrosssection();
                }
                if (this.timeseries.getParentFrame() != null) {
                    this.timeseries.setCurrentIndex(this.getCurrentScreenVolume().getVolume().getCurrentTimepoint());
                }
                if (this.clusterAnalysis != null) {
                    this.clusterAnalysis.overlayTimepointChanged();
                }
                this.forceImageUpdate();
                this.updateScreenSlices();
                this.updateSurface();
                this.updateSurfaceColorAtTimepoint();
                if (this.roiManager.isUsing4dROI()) {
                    this.updateROISlices();
                }
            }
        } else {
            if (sliceType == 0) {
                if (this.axialImage.isDragging()) {
                    this.axialImage.updateSetShape();
                }
                if (didIncrement = this.axialImage.decrementCurrentSlice()) {
                    this.coronalImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.axialImage.getCurrentSlice(), true, false, true);
                    this.sagittalImage.setCrosshairPosition(this.coronalImage.getCurrentSlice(), this.axialImage.getCurrentSlice(), true, false, true);
                    this.toolBox.setMouseLabelInfoIncrement(sliceType, -1);
                }
            } else if (sliceType == 1) {
                if (this.coronalImage.isDragging()) {
                    this.coronalImage.updateSetShape();
                }
                if (didIncrement = this.coronalImage.decrementCurrentSlice()) {
                    this.axialImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.coronalImage.getCurrentSlice(), true, false, true);
                    this.sagittalImage.setCrosshairPosition(this.coronalImage.getCurrentSlice(), this.axialImage.getCurrentSlice(), true, false, true);
                    this.toolBox.setMouseLabelInfoIncrement(sliceType, -1);
                }
            } else if (sliceType == 2) {
                if (this.sagittalImage.isDragging()) {
                    this.sagittalImage.updateSetShape();
                }
                if (didIncrement = this.sagittalImage.decrementCurrentSlice()) {
                    this.axialImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.coronalImage.getCurrentSlice(), true, false, true);
                    this.coronalImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.axialImage.getCurrentSlice(), true, false, true);
                    this.toolBox.setMouseLabelInfoIncrement(sliceType, -1);
                }
            } else if (sliceType == 3 && (didIncrement = this.volume.getCurrentTimepoint() > 0)) {
                this.setCurrentTimepoint(this.volume.getCurrentTimepoint() - 1, this.volume);
                if (this.crosssection.getParentFrame() != null) {
                    this.crosssection.updateCrosssection();
                }
            }
            this.updateSurface();
            this.updateSync();
        }
        this.toolBox.updateMouseLabelInfo();
        return didIncrement;
    }

    public void deleteAction(boolean sameThread) {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Delete")});
        if (this.hasActivePolyLine()) {
            this.clearPolyLine();
        } else if (this.isEditingLOI()) {
            this.deleteLOIPoint();
        } else {
            this.doClear(sameThread);
        }
    }

    public void deleteROI(ROI roi) {
        this.doDeleteROI(roi, true);
    }

    public void deselectAll() {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Deselect All")});
        this.deselectAllPOIs();
        this.deselectAllLOIs();
        this.deselectAllROIs();
        this.mango.updateMenus();
        this.repaint();
    }

    public void disposeVolumeManager() {
        this.setClosing(true);
        this.notifyAllListenersOfClosing();
        this.cleanUp();
    }

    public void doActionAllSliceStats() {
        this.recordAction("runAllSliceStats", new String[]{this.getScriptSliceDirection(this.getMainSliceDirection())});
        SliceStatOp op = new SliceStatOp(this, this.getCurrentVolume());
        op.calculateAllSliceStatsAsync(this.mainImage.getSliceDirection(), this);
    }

    public void doActionAllSliceStatsROI() {
        int sliceStatsDirection = this.mainImage.getSliceDirection();
        this.recordAction("runAllSliceStatsROI", new String[]{this.getScriptSliceDirection(sliceStatsDirection), this.getScriptObjectName() + ".roiData.selectedMask", "True", "True", "True"}, true);
        this.runAllSliceStatsROIPoints(sliceStatsDirection, true);
        this.runAllSliceStatsROILines(sliceStatsDirection, true);
        if (this.hasSelectedROIs()) {
            SliceStatROIOp op = new SliceStatROIOp(this, this.getCurrentVolume(), this.roiManager.getBuffer(), this.roiManager.getBuffer().getSelected(), this.roiManager);
            op.calculateAllSliceStatsAsync(sliceStatsDirection, this);
        }
    }

    public void doActionAllVolumeStats() {
        this.recordAction("runAllVolumeStats");
        VolumeStatOp op = new VolumeStatOp(this, this.getCurrentVolume());
        op.calculateAllVolumesStatsAsync(this);
    }

    public void doActionAllVolumeStatsROI() {
        this.recordAction("runAllVolumeStatsROI", new String[]{this.getScriptObjectName() + ".roiData.selectedMask", "True", "True", "True"}, true);
        this.runAllVolumeStatsROIPoints(true);
        this.runAllVolumeStatsROILines(true);
        if (this.hasSelectedROIs()) {
            VolumeStatROIOp op = new VolumeStatROIOp(this, this.getCurrentVolume(), this.roiManager.getBuffer(), this.roiManager.getBuffer().getSelected(), this.roiManager);
            op.calculateAllVolumesStatsAsync(this);
        }
    }

    public void doActionCalculation(String input, int selectionArea, boolean outputNewImage, boolean allSeriesPoints, boolean roiSlicesOnly) {
        this.recordAction("runOperation", new String[]{"\"" + input + "\"", String.valueOf(selectionArea), outputNewImage ? "True" : "False", allSeriesPoints ? "True" : "False", roiSlicesOnly ? "True" : "False"});
        ImageCalcExpressionImpl expression = new ImageCalcExpressionImpl(input, this, selectionArea, allSeriesPoints, roiSlicesOnly);
        if (outputNewImage) {
            this.mango.addViewer(expression, true);
        } else {
            this.doOperationImage(expression, true);
        }
    }

    public void doActionHistogramGenerateROIs(final Histogram histogram, final boolean useBounds) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (SliceViewer.this.isMultiSliceMode()) {
                    SliceViewer.this.startIndeterminateProgressBar();
                }
                if (SliceViewer.this.isMultiSliceMode()) {
                    if (useBounds) {
                        SliceViewer.this.recordAction("runGenerateHistogramWithinROI", new String[]{SliceViewer.this.getScriptObjectName() + ".histogramAnalysis", SliceViewer.this.getScriptObjectName() + ".roiData.availableMask"}, true);
                        SliceViewer.this.runGenerateHistogramWithinROI(histogram, SliceViewer.this.roiManager.getAvailableMask());
                    } else {
                        SliceViewer.this.recordAction("runGenerateHistogramROI", new String[]{SliceViewer.this.getScriptObjectName() + ".histogramAnalysis"});
                        SliceViewer.this.runGenerateHistogramROI(histogram);
                    }
                } else if (useBounds) {
                    SliceViewer.this.recordAction("runGenerateHistogramWithinROISlice", new String[]{SliceViewer.this.getScriptSliceDirection(SliceViewer.this.getMainSliceDirection()), SliceViewer.this.getScriptSliceNumber(SliceViewer.this.getMainSliceNumber()), SliceViewer.this.getScriptObjectName() + ".histogramAnalysis", SliceViewer.this.getScriptObjectName() + ".roiData.availableMask"}, true);
                    SliceViewer.this.runGenerateHistogramWithinROISlice(SliceViewer.this.getMainSliceDirection(), SliceViewer.this.getMainSliceNumber(), histogram, SliceViewer.this.roiManager.getAvailableMask());
                } else {
                    SliceViewer.this.recordAction("runGenerateHistogramROISlice", new String[]{SliceViewer.this.getScriptSliceDirection(SliceViewer.this.getMainSliceDirection()), SliceViewer.this.getScriptSliceNumber(SliceViewer.this.getMainSliceNumber()), SliceViewer.this.getScriptObjectName() + ".histogramAnalysis"}, true);
                    SliceViewer.this.runGenerateHistogramROISlice(SliceViewer.this.getMainSliceDirection(), SliceViewer.this.getMainSliceNumber(), histogram);
                }
                if (SliceViewer.this.isMultiSliceMode()) {
                    SliceViewer.this.endIndeterminateProgressBar();
                }
            }
        });
        workThread.start();
    }

    public void doActionSliceStats() {
        int sliceStatsDirection = this.mainImage.getSliceDirection();
        int sliceStatsCurrentSlice = this.mainImage.getCurrentSlice();
        this.recordAction("runSliceStats", new String[]{this.getScriptSliceDirection(sliceStatsDirection), this.getScriptSliceNumber(sliceStatsCurrentSlice)});
        Volume vol = this.getCurrentVolume();
        SliceStatOp op = new SliceStatOp(this, vol);
        Analysis stat = null;
        stat = sliceStatsDirection == 0 ? op.process(new ImageBounds(0, this.volume.getXDim() - 1, 0, this.volume.getYDim() - 1, sliceStatsCurrentSlice, sliceStatsCurrentSlice)) : (sliceStatsDirection == 1 ? op.process(new ImageBounds(0, this.volume.getXDim() - 1, sliceStatsCurrentSlice, sliceStatsCurrentSlice, 0, this.volume.getZDim() - 1)) : op.process(new ImageBounds(sliceStatsCurrentSlice, sliceStatsCurrentSlice, 0, this.volume.getYDim() - 1, 0, this.volume.getZDim() - 1)));
        if (stat != null) {
            this.operationFinished(stat, vol);
        }
    }

    public void doActionSliceStatsROI() {
        int sliceStatsDirection = this.mainImage.getSliceDirection();
        int sliceStatsCurrentSlice = this.mainImage.getCurrentSlice();
        this.recordAction("runSliceStatsROI", new String[]{this.getScriptSliceDirection(sliceStatsDirection), this.getScriptSliceNumber(sliceStatsCurrentSlice), this.getScriptObjectName() + ".roiData.selectedMask", "True", "True", "True"});
        this.runSliceStatsROIPoints(sliceStatsDirection, sliceStatsCurrentSlice, true);
        this.runSliceStatsROILines(sliceStatsDirection, sliceStatsCurrentSlice, true);
        if (this.hasSelectedROIs()) {
            Volume vol = this.getCurrentVolume();
            SliceStatROIOp op = new SliceStatROIOp(this, vol, this.roiManager.getBuffer(), this.roiManager.getBuffer().getSelected(), this.roiManager);
            Map<Long, Analysis> results = null;
            results = sliceStatsDirection == 0 ? op.process(new ImageBounds(0, this.volume.getXDim() - 1, 0, this.volume.getYDim() - 1, sliceStatsCurrentSlice, sliceStatsCurrentSlice)) : (sliceStatsDirection == 1 ? op.process(new ImageBounds(0, this.volume.getXDim() - 1, sliceStatsCurrentSlice, sliceStatsCurrentSlice, 0, this.volume.getZDim() - 1)) : op.process(new ImageBounds(sliceStatsCurrentSlice, sliceStatsCurrentSlice, 0, this.volume.getYDim() - 1, 0, this.volume.getZDim() - 1)));
            this.operationFinished(results, vol);
        }
    }

    public void doActionTimeseriesStats() {
        this.recordAction("runSeriesStats");
        Volume vol = this.getCurrentVolume();
        SeriesStatOp op = new SeriesStatOp(this, vol);
        OperationBuilder<Analysis> builder = new OperationBuilder<Analysis>(this, op);
        builder.runAsynchronously(this);
    }

    public void doActionTimeseriesStatsROI() {
        this.recordAction("runSeriesStatsROI", new String[]{this.getScriptObjectName() + ".roiData.selectedMask", "True", "True", "True"});
        this.runSeriesStatsROIPoints(true);
        this.runSeriesStatsROILines(true);
        if (this.hasSelectedROIs()) {
            SeriesStatROIOp op = new SeriesStatROIOp(this, this.getCurrentVolume(), this.roiManager.getBuffer(), this.roiManager.getBuffer().getSelected(), this.roiManager);
            OperationBuilder<Map<Long, Analysis>> builder = new OperationBuilder<Map<Long, Analysis>>(this, op);
            builder.runAsynchronously(this);
        }
    }

    public void doActionVolumeStats() {
        this.recordAction("runVolumeStats");
        Volume vol = this.getCurrentVolume();
        VolumeStatOp op = new VolumeStatOp(this, vol);
        OperationBuilder<Analysis> builder = new OperationBuilder<Analysis>(this, op);
        builder.runAsynchronously(this);
    }

    public void doActionVolumeStatsROI() {
        this.recordAction("runVolumeStatsROI", new String[]{this.getScriptObjectName() + ".roiData.selectedMask", "True", "True", "True"});
        this.runVolumeStatsROIPoints(true);
        this.runVolumeStatsROILines(true);
        if (this.hasSelectedROIs()) {
            VolumeStatROIOp op = new VolumeStatROIOp(this, this.getCurrentVolume(), this.roiManager.getBuffer(), this.roiManager.getBuffer().getSelected(), this.roiManager);
            OperationBuilder<Map<Long, Analysis>> builder = new OperationBuilder<Map<Long, Analysis>>(this, op);
            builder.runAsynchronously(this);
        }
    }

    public void doAddMoreROIColors() {
        this.recordAction("addMoreROIColors");
        this.startIndeterminateProgressBar();
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.roiManager.increaseColors();
                SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SliceViewer.this.toolBox.showROIColorPicker();
                    }
                });
            }
        });
        workThread.start();
    }

    public void doClickMenuItem(String name) {
        JMenuItem mi = this.getViewerFrame().getViewerMenu().getMenuItem(name);
        if (mi == null && this.surfaceRender != null) {
            mi = this.surfaceRender.getFrame().getMenuItem(name);
        }
        if (mi == null && this.projection != null) {
            mi = this.projection.getMenuItem(name);
        }
        if (mi != null) {
            mi.doClick();
        } else {
            AppLogger.warn((String)"Could not find that menu item!");
        }
    }

    public void doConvexHull(double minResultVal, double maxResultVal, boolean isPercentMax, boolean excludeZero, boolean within, long withinMask, boolean doRange, boolean isSeriesVal, boolean isDynamicThreshold) {
        boolean isSeries = isSeriesVal;
        boolean isVOIMode = this.toolBox.isVOIMode();
        double imageMax = this.getCurrentVolume().getImageMax();
        double minResult = minResultVal;
        double maxResult = maxResultVal;
        if (isPercentMax && !isDynamicThreshold) {
            minResult = imageMax * (minResult / 100.0);
            maxResult = imageMax * (maxResult / 100.0);
        }
        isSeries |= this.roiManager.isUsing4dROI();
        if (isVOIMode) {
            if (within) {
                this.recordAction("runConvexHullROI", new String[]{this.getScriptObjectName() + ".roiData.selectedMask", this.getScriptObjectName() + ".roiColor"}, true);
            } else {
                this.recordAction("runThresholdToConvexHullROI", new String[]{String.valueOf(minResultVal), ScriptUtils.convertBoolean(isPercentMax), ScriptUtils.convertBoolean(excludeZero), ScriptUtils.convertBoolean(isSeries), ScriptUtils.convertBoolean(isDynamicThreshold)}, true);
            }
            this.roiManager.makeConvexHullROI(minResult, maxResult, excludeZero, within, withinMask, this.roiManager.getCurrentROI(), doRange, isSeries, isDynamicThreshold);
        } else {
            if (within) {
                this.recordAction("runConvexHullROISlice", new String[]{this.getScriptSliceDirection(this.getMainSliceDirection()), this.getScriptSliceNumber(this.getMainSliceNumber()), this.getScriptObjectName() + ".roiData.selectedMask", this.getScriptObjectName() + ".roiColor"}, true);
            } else {
                this.recordAction("runThresholdToConvexHullROISlice", new String[]{String.valueOf(minResultVal), this.getScriptSliceDirection(this.getMainSliceDirection()), this.getScriptSliceNumber(this.getMainSliceNumber()), ScriptUtils.convertBoolean(isPercentMax), ScriptUtils.convertBoolean(excludeZero), ScriptUtils.convertBoolean(isSeries), ScriptUtils.convertBoolean(isDynamicThreshold)}, true);
            }
            this.roiManager.runConvexHullROI(this.getMainSliceNumber(), this.getMainSliceDirection(), minResult, maxResult, excludeZero, within, withinMask, this.roiManager.getCurrentROI(), doRange, isSeries, isDynamicThreshold);
        }
    }

    public void doConvexHull(ROI roi, boolean sameThread) {
        this.resetAllClipboardsUndo();
        this.recordAction("runConvexHull", new String[]{this.getScriptObjectName() + ".roiData.allROIs"}, true);
        if (roi instanceof Mask) {
            this.doConvexHull(1L << roi.getColor(), roi.getColor(), false, sameThread);
        } else if (roi instanceof LOIShape) {
            this.convexHullLOI((LOIShape)roi);
        }
        this.updateViewer();
    }

    public void doCopy(boolean sameThread) {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Copy")});
        this.resetAllClipboardsContents();
        if (this.hasSelectedPOIs()) {
            this.copyPOI();
        }
        if (this.hasSelectedLOIs()) {
            this.copyLOI();
        }
        if (this.hasSelectedROIs()) {
            this.copyROI(sameThread);
        }
        this.mango.updateMenus();
        this.repaint();
    }

    public void doCut(boolean sameThread) {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Cut")});
        this.resetAllClipboardsContents();
        if (this.hasSelectedPOIs()) {
            this.cutPOI();
        }
        if (this.hasSelectedLOIs()) {
            this.cutLOI();
        }
        if (this.hasSelectedROIs()) {
            this.cutROI(sameThread);
        }
        this.mango.updateMenus();
        this.repaint();
    }

    public void doDeleteROI(ROI roi, boolean sameThread) {
        this.recordAction("deleteROI", new String[]{this.getScriptObjectName() + ".roiData.allROIs"}, true);
        this.resetAllClipboardsUndo();
        if (roi instanceof Mask) {
            if (this.isMultiSliceMode()) {
                this.roiManager.clear(1L << roi.getColor(), true, sameThread);
            } else {
                int sliceDirection = this.getMainSliceDirection();
                Volume volume = this.getVolume();
                int zMin = 0;
                int yMin = 0;
                int xMin = 0;
                int xMax = volume.getXDim();
                int yMax = volume.getYDim();
                int zMax = volume.getZDim();
                if (sliceDirection == 0) {
                    zMin = zMax = this.roiManager.getSelectedSlice(sliceDirection);
                } else if (sliceDirection == 1) {
                    yMin = yMax = this.roiManager.getSelectedSlice(sliceDirection);
                } else if (sliceDirection == 2) {
                    xMin = xMax = this.roiManager.getSelectedSlice(sliceDirection);
                }
                this.roiManager.clear(xMin, xMax, yMin, yMax, zMin, zMax, 1L << roi.getColor(), true, sameThread);
            }
        } else if (roi instanceof LOIShape) {
            if (this.loiManagerAxial.containsLOI((LOIShape)roi)) {
                this.loiManagerAxial.removeLOI((LOIShape)roi, true);
            } else if (this.loiManagerCoronal.containsLOI((LOIShape)roi)) {
                this.loiManagerCoronal.removeLOI((LOIShape)roi, true);
            } else if (this.loiManagerSagittal.containsLOI((LOIShape)roi)) {
                this.loiManagerSagittal.removeLOI((LOIShape)roi, true);
            }
        } else if (roi instanceof POI) {
            this.poiManager.removePOI((POI)roi, true, true);
        }
        this.updateViewer();
    }

    public void doDilate2D(int sliceNum, int sliceDirection, int kernel, long mask) {
        this.recordAction("runDilateROISlice", new String[]{this.getScriptSliceDirection(sliceDirection), this.getScriptSliceNumber(sliceNum), String.valueOf(mask), String.valueOf(kernel)}, true);
        this.roiManager.runDilate2D(sliceNum, sliceDirection, kernel, mask);
    }

    public void doDilate3D(int kernel, long mask) {
        this.recordAction("runDilateROI", new String[]{String.valueOf(mask), String.valueOf(kernel)}, true);
        this.roiManager.runDilate3D(kernel, mask);
    }

    public void doErode2D(int sliceNum, int sliceDirection, int kernel, long mask) {
        this.recordAction("runErodeROISlice", new String[]{this.getScriptSliceDirection(sliceDirection), this.getScriptSliceNumber(sliceNum), String.valueOf(mask), String.valueOf(kernel)}, true);
        this.roiManager.runErode2D(sliceNum, sliceDirection, kernel, mask);
    }

    public void doErode3D(int kernel, long mask) {
        this.recordAction("runErodeROI", new String[]{String.valueOf(mask), String.valueOf(kernel)}, true);
        this.roiManager.runErode3D(kernel, mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadImage(URI uri, Header header, DICOM[] dicoms, URI[] dicomFiles, ByteBuffer[] buffersVal, ImageCalcExpression op, Volume copyVol, ImageBounds copyBounds, boolean sameThread) {
        ByteBuffer[] buffers = buffersVal;
        try {
            this.startIndeterminateProgressBar();
            boolean isLocalFile = FileUtilities.uriIsFile((URI)uri);
            URI loadingURI = uri;
            this.setLoadedURI(loadingURI);
            this.makeROIGZIPFile();
            this.volume = new Volume();
            this.volume.setUser(this);
            this.volume.addListener(this);
            this.volume.setLabelListener(this);
            if (isLocalFile) {
                File localFile = new File(uri);
                if (header != null) {
                    if (buffers != null) {
                        this.isTempImage = true;
                        this.volume.setHeader(header, false, buffers);
                    } else if (op != null) {
                        this.startOperation = op;
                        this.roiManager = ((SliceViewer)op.getOriginatingManager()).getROIManager();
                        buffers = Image.makeBuffers(header.getImageDimensions().getNumVoxelsVolume() * 4, header.getImageDimensions().getTimepoints());
                        this.isTempImage = true;
                        this.volume.setHeader(header, false, buffers);
                    } else if (copyVol != null && copyBounds != null) {
                        buffers = null;
                        ByteBuffer byteBuffer = copyVol.copyImage(localFile, copyBounds);
                        if (byteBuffer != null) {
                            buffers = new ByteBuffer[]{byteBuffer};
                        }
                        this.isTempImage = true;
                        this.volume.setHeader(header, false, buffers);
                    } else {
                        this.isTempImage = true;
                        this.volume.setHeader(header, false, null);
                        this.volume.doReadFiles();
                    }
                } else if (dicoms != null) {
                    this.isTempImage = true;
                    this.volume.readDICOM(dicoms);
                } else if (dicomFiles != null) {
                    this.volume.readDICOMFiles(dicomFiles);
                } else {
                    loadingURI = this.volume.readHeader(this.getLoadedURI());
                    this.setLoadedURI(loadingURI);
                    int numTimepoints = this.volume.getNumTimepoints();
                    if (!sameThread && numTimepoints > 1 && this.volume.supportsTimeseriesSelection()) {
                        this.showTimeseriesSelectionDialog(this.volume, numTimepoints);
                    }
                    if (sameThread) {
                        this.volume.setForceLoadInThead(true);
                    }
                    this.volume.doReadFiles();
                }
            } else if (dicomFiles != null) {
                this.volume.readDICOMFiles(dicomFiles);
            } else {
                this.volume.readFiles(loadingURI);
            }
            this.volume.readLabelData();
            this.setLoadedURI(loadingURI);
            this.volume.setProgressBarListener(this.toolBox);
            this.setOrientationCertainty(this.volume.getOrientationCertainty());
            this.setLongestDim();
            this.baseScreenVolume = new ScreenVolume(this.volume, this.getLoadedURI(), "Grayscale", true);
            this.applyImageOptions(FileUtilities.getName((URI)this.getLoadedURI()), this.baseScreenVolume);
            boolean isEDT = EventQueue.isDispatchThread();
            VolumeRangeOp rangeOp = new VolumeRangeOp(this, this.volume);
            OperationBuilder<Range> builder = new OperationBuilder<Range>(this, rangeOp);
            Range range = builder.runSynchronously();
            this.volume.updateMaxMin(range.getMax(), range.getMin());
            this.initializeViewer(isEDT || sameThread);
        }
        catch (InvalidHeaderException ex) {
            AppLogger.info((Throwable)ex);
            this.mango.showErrorDialog(TEXT_PROBLEM_LOADING_IMAGE_FILE + ex.getMessage(), TEXT_IMAGE_LOAD_FAILED);
            this.volumeLoaded(false);
        }
        catch (VolumeIOException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog("Problem loading image file!\nCheck permissions!", TEXT_IMAGE_LOAD_FAILED);
            this.volumeLoaded(false);
        }
        catch (IndexOutOfBoundsException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog(TEXT_PROBLEM_LOADING_IMAGE_FILE, TEXT_IMAGE_LOAD_FAILED);
            this.volumeLoaded(false);
        }
        catch (OutOfMemoryError err) {
            AppLogger.error((Throwable)err);
            this.mango.showOutOfMemoryMessage();
            this.volumeLoaded(false);
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.info((Throwable)ex);
            this.mango.showErrorDialog(TEXT_PROBLEM_LOADING_IMAGE_FILE + ex.getMessage(), TEXT_IMAGE_LOAD_FAILED);
            this.volumeLoaded(false);
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            this.mango.showErrorDialog(TEXT_PROBLEM_LOADING_IMAGE_FILE + ex.getMessage(), TEXT_IMAGE_LOAD_FAILED);
            this.volumeLoaded(false);
        }
        finally {
            this.endIndeterminateProgressBar();
        }
    }

    public void doMagicWandPreserve(Point aPoint) {
        if (this.roiManager != null && this.roiManager.hasROI(this.roiManager.getCurrentROI())) {
            this.doSelectedComponentRemove2D(aPoint, false);
        }
    }

    public void doMagicWandRemove(Point aPoint) {
        if (this.roiManager != null && this.roiManager.hasROI(this.roiManager.getCurrentROI())) {
            this.doSelectedComponentRemove2D(aPoint, true);
        }
    }

    public void doOperationFilterImage(AbstractFilter filter) {
        if (this.volume.isOperationInProgress()) {
            return;
        }
        this.prepareFilter();
        this.recordAction("runFilter", new String[]{ScriptUtils.convertString(filter.getName())});
        FilterOp filterOp = new FilterOp(this, this);
        filterOp.processFilter(filter, this.filterBuffer);
    }

    public void doPaste(boolean sameThread) {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Paste")});
        boolean canPastePOI = Mango.getClipboardPoi().canPaste();
        boolean canPasteLOI = Mango.getClipboardLoi().canPaste();
        boolean canPasteROI = Mango.getClipboardRoi().canPaste();
        long copyMask = 0L;
        if (Mango.getClipboardPoi().hasContents() && canPastePOI) {
            copyMask = Mango.getClipboardPoi().getCopyMask();
        }
        if (Mango.getClipboardLoi().hasContents() && canPasteLOI) {
            copyMask |= Mango.getClipboardLoi().getCopyMask();
        }
        if (Mango.getClipboardRoi().hasContents() && canPasteROI) {
            copyMask |= Mango.getClipboardRoi().getCopyMask();
        }
        int colorsUsed = 0;
        for (int ctr = 0; ctr < this.roiManager.getBuffer().getMaximumColors(); ++ctr) {
            if ((copyMask >>> ctr & 1L) != 1L) continue;
            ++colorsUsed;
        }
        int pasteColor = this.roiManager.getCurrentROI();
        if (colorsUsed > 1) {
            if (Mango.getClipboardPoi().hasContents() && canPastePOI) {
                Mango.getClipboardPoi().setPasteColorAsCopyColor();
            }
            if (Mango.getClipboardLoi().hasContents() && canPasteLOI) {
                Mango.getClipboardLoi().setPasteColorAsCopyColor();
            }
        } else {
            if (Mango.getClipboardPoi().hasContents() && canPastePOI) {
                Mango.getClipboardPoi().setPasteColor(pasteColor);
            }
            if (Mango.getClipboardLoi().hasContents() && canPasteLOI) {
                Mango.getClipboardLoi().setPasteColor(pasteColor);
            }
        }
        if (Mango.getClipboardPoi().hasContents() && canPastePOI) {
            this.pastePOI();
        }
        if (Mango.getClipboardLoi().hasContents() && canPasteLOI) {
            this.pasteLOI();
        }
        if (Mango.getClipboardRoi().hasContents() && canPasteROI) {
            this.pasteROI(sameThread);
        }
        this.mango.updateMenus();
        this.repaint();
    }

    public void doRedo(boolean sameThread) {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Redo")});
        if (this.hasRedoPOI()) {
            this.poiManager.redo();
        }
        if (this.hasRedoLOI()) {
            if (this.loiManagerAxial.hasRedo()) {
                this.loiManagerAxial.redoLOI();
            }
            if (this.loiManagerCoronal.hasRedo()) {
                this.loiManagerCoronal.redoLOI();
            }
            if (this.loiManagerSagittal.hasRedo()) {
                this.loiManagerSagittal.redoLOI();
            }
        }
        if (this.roiManager.hasRedo()) {
            this.doUndoROI(sameThread);
        }
        this.deselectAll();
        this.repaint();
    }

    public void doRemoveAllOverlays() {
        this.recordAction("removeAllOverlays");
        ScreenVolume[] allScreenVolumes = this.overlayManager.getAllOverlays();
        for (int ctr = allScreenVolumes.length - 1; ctr >= 0; --ctr) {
            if (allScreenVolumes[ctr] == null) continue;
            allScreenVolumes[ctr].getVolume().removeListener(this);
            this.overlayManager.removeOverlay(allScreenVolumes[ctr]);
        }
        this.updateOverlays();
        this.setCurrentOverlay(0);
        this.toolBox.updateOverlayButton();
        this.toolBox.updateOverlayPopupMenu();
        this.toolBox.updateSlider();
        this.clearOverlayData();
        this.updateScreenSlices();
        this.updateSurface();
    }

    public void doSaveOverlays(boolean sameThread) {
        this.recordAction("saveOverlays");
        this.saveOverlays(sameThread);
    }

    public void showSaveROIDialog() {
        File oldFile = this.getLoadedFile();
        String fileName = oldFile.getName();
        File newFile = null;
        newFile = fileName.indexOf(46) != -1 ? new File(oldFile.getParent(), fileName.substring(0, fileName.indexOf(46)) + "_roi") : new File(oldFile.getParent(), fileName + "_roi");
        SaveROIPanel saveROIPanel = new SaveROIPanel(this);
        File selectedFile = SaveFileDialog.showSaveFileChooserWithAccessory(this.getFrame(), this.getSaveDirectory(), newFile.getName(), saveROIPanel);
        if (selectedFile != null) {
            this.doSaveROI(selectedFile, saveROIPanel.getColor(), false);
            this.mango.setLastAccessedDirectory(selectedFile.getParent());
        }
    }

    public void doSaveROI(File selectedFileVal, int selectedSaveIndex, boolean sameThread) {
        if (selectedSaveIndex != -1) {
            this.recordAction("saveSingleROI", new String[]{this.getScriptObjectName() + ".makeFilename(\"." + "nii" + ".gz" + "\")", String.valueOf(selectedSaveIndex)}, true);
        } else {
            this.recordAction("saveROI", new String[]{this.getScriptObjectName() + ".makeFilename(\"." + "nii" + ".gz" + "\")"}, true);
        }
        this.saveROI(selectedFileVal, selectedSaveIndex, sameThread);
    }

    public void doSelectAll() {
        this.recordAction("selectAll");
        this.selectAllPOIs();
        this.selectAllLOIs();
        this.selectAllROIs();
        this.mango.updateMenus();
        this.repaint();
    }

    public void doSelectedComponentCopy2D(Point aPoint) {
        this.roiManager.selectedComponenCopy2D(aPoint, this.mainImage.getSliceDirection(), this.mainImage.getCurrentSlice());
    }

    public void doSelectedComponentCopy3D(Point aPoint) {
        int sliceDirection = this.mainImage.getSliceDirection();
        Coordinate coor = null;
        coor = sliceDirection == 0 ? new Coordinate((double)aPoint.x, (double)aPoint.y, (double)this.mainImage.getCurrentSlice()) : (sliceDirection == 1 ? new Coordinate((double)aPoint.x, (double)this.mainImage.getCurrentSlice(), (double)aPoint.y) : new Coordinate((double)this.mainImage.getCurrentSlice(), (double)aPoint.x, (double)aPoint.y));
        this.roiManager.selectedComponentCopy3D(coor);
    }

    public void doSelectedComponentDilate2D(Point aPoint, boolean isSmart, double min, double max) {
        this.roiManager.selectedComponenDilate2D(aPoint, this.mainImage.getSliceDirection(), this.mainImage.getCurrentSlice(), isSmart, min, max);
    }

    public void doSelectedComponentDilate3D(Point aPoint, boolean isSmart, double min, double max) {
        int sliceDirection = this.mainImage.getSliceDirection();
        Coordinate coor = null;
        coor = sliceDirection == 0 ? new Coordinate((double)aPoint.x, (double)aPoint.y, (double)this.mainImage.getCurrentSlice()) : (sliceDirection == 1 ? new Coordinate((double)aPoint.x, (double)this.mainImage.getCurrentSlice(), (double)aPoint.y) : new Coordinate((double)this.mainImage.getCurrentSlice(), (double)aPoint.x, (double)aPoint.y));
        this.roiManager.selectedComponentDilate3D(coor, isSmart, min, max);
    }

    public void doSelectedComponentErode2D(Point aPoint, boolean isSmart, double min, double max) {
        this.roiManager.selectedComponenErode2D(aPoint, this.mainImage.getSliceDirection(), this.mainImage.getCurrentSlice(), isSmart, min, max);
    }

    public void doSelectedComponentErode3D(Point aPoint, boolean isSmart, double min, double max) {
        int sliceDirection = this.mainImage.getSliceDirection();
        Coordinate coor = null;
        coor = sliceDirection == 0 ? new Coordinate((double)aPoint.x, (double)aPoint.y, (double)this.mainImage.getCurrentSlice()) : (sliceDirection == 1 ? new Coordinate((double)aPoint.x, (double)this.mainImage.getCurrentSlice(), (double)aPoint.y) : new Coordinate((double)this.mainImage.getCurrentSlice(), (double)aPoint.x, (double)aPoint.y));
        this.roiManager.selectedComponentErode3D(coor, isSmart, min, max);
    }

    public void doSelectedComponentRemove2D(Point aPoint, boolean removeThis) {
        this.roiManager.selectedComponentRemove2D(aPoint, this.mainImage.getSliceDirection(), this.mainImage.getCurrentSlice(), removeThis);
    }

    public void doSelectedComponentRemove3D(Point aPoint, boolean removeThis) {
        int sliceDirection = this.mainImage.getSliceDirection();
        Coordinate coor = null;
        coor = sliceDirection == 0 ? new Coordinate((double)aPoint.x, (double)aPoint.y, (double)this.mainImage.getCurrentSlice()) : (sliceDirection == 1 ? new Coordinate((double)aPoint.x, (double)this.mainImage.getCurrentSlice(), (double)aPoint.y) : new Coordinate((double)this.mainImage.getCurrentSlice(), (double)aPoint.x, (double)aPoint.y));
        this.roiManager.selectedComponentRemove3D(coor, removeThis);
    }

    public void doSelectedComponentValues2D(Point aPoint, boolean isSmartVal, double minVal, double maxVal) {
        boolean isSmart = isSmartVal;
        double min = minVal;
        double max = maxVal;
        Coordinate coor = null;
        coor = this.mainImage.getSliceDirection() == 0 ? new Coordinate((double)aPoint.x, (double)aPoint.y, (double)this.mainImage.getCurrentSlice()) : (this.mainImage.getSliceDirection() == 1 ? new Coordinate((double)aPoint.x, (double)this.mainImage.getCurrentSlice(), (double)aPoint.y) : new Coordinate((double)this.mainImage.getCurrentSlice(), (double)aPoint.x, (double)aPoint.y));
        VolumeData volData = new VolumeData(this);
        double current = volData.getValue(coor.xInt, coor.yInt, coor.zInt);
        if (!isSmart) {
            isSmart = true;
            min = current - this.mango.getMagicWandRange();
            max = current + this.mango.getMagicWandRange();
        }
        this.roiManager.selectedComponentValues2D(aPoint, this.mainImage.getSliceDirection(), this.mainImage.getCurrentSlice(), isSmart, min, max);
    }

    public void doSelectedComponentValues3D(Point aPoint, boolean isSmartVal, double minVal, double maxVal) {
        boolean isSmart = isSmartVal;
        double min = minVal;
        double max = maxVal;
        int sliceDirection = this.mainImage.getSliceDirection();
        Coordinate coor = null;
        coor = sliceDirection == 0 ? new Coordinate((double)aPoint.x, (double)aPoint.y, (double)this.mainImage.getCurrentSlice()) : (sliceDirection == 1 ? new Coordinate((double)aPoint.x, (double)this.mainImage.getCurrentSlice(), (double)aPoint.y) : new Coordinate((double)this.mainImage.getCurrentSlice(), (double)aPoint.x, (double)aPoint.y));
        VolumeData volData = new VolumeData(this);
        double current = volData.getValue(coor.xInt, coor.yInt, coor.zInt);
        if (!isSmart) {
            isSmart = true;
            min = current - this.mango.getMagicWandRange();
            max = current + this.mango.getMagicWandRange();
        }
        this.roiManager.selectedComponentValues3D(coor, isSmart, min, max);
    }

    public void doShrinkWrap2D(int sliceDirection, int slice, double threshMin, long mask, int output, boolean isDynamicThreshold) {
        this.recordAction("runShrinkWrapROISlice", new String[]{this.getScriptSliceDirection(sliceDirection), this.getScriptSliceNumber(slice), String.valueOf(mask), String.valueOf(output)}, true);
        this.roiManager.shrinkWrap2D(slice, sliceDirection, threshMin, Double.MAX_VALUE, true, mask, output, true, false, isDynamicThreshold, false);
    }

    public void doShrinkWrap3D(double threshMin, long mask, int output, boolean isDynamicThreshold) {
        this.recordAction("runShrinkWrapROI", new String[]{String.valueOf(mask), String.valueOf(output)}, true);
        this.roiManager.runShrinkWrap3D(threshMin, Double.MAX_VALUE, this.getCurrentVolume(), true, mask, output, true, false, isDynamicThreshold);
    }

    public void doSticky() {
        this.frame.doAllStickies();
    }

    public boolean doSurfaceCutPlaneShrinkWrap() {
        return this.surfaceRender != null && (!this.surfaceRender.isUsingShaders() || this.surfaceRender.isBaseSurfaceTransparent());
    }

    public void doUndo(boolean sameThread) {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Undo")});
        if (this.hasUndoPOI()) {
            this.poiManager.undo();
        }
        if (this.hasUndoLOI()) {
            if (this.loiManagerAxial.hasUndo()) {
                this.loiManagerAxial.undoLOI();
            }
            if (this.loiManagerCoronal.hasUndo()) {
                this.loiManagerCoronal.undoLOI();
            }
            if (this.loiManagerSagittal.hasUndo()) {
                this.loiManagerSagittal.undoLOI();
            }
        }
        if (this.roiManager.hasUndo()) {
            this.doUndoROI(sameThread);
        }
        this.deselectAll();
        this.updateViewer();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        try {
            FileNode[] nodes = (FileNode[])dtde.getTransferable().getTransferData(NodesTransferable.getDataFlavor());
            if (nodes == null) {
                dtde.rejectDrag();
                return;
            }
            boolean foundImage = false;
            for (FileNode node : nodes) {
                if (node.getHeaderInfo() != null) {
                    foundImage = true;
                    break;
                }
                if (node.getSurfaceInfo() == null) continue;
                foundImage = true;
                break;
            }
            if (!foundImage) {
                dtde.rejectDrag();
            }
        }
        catch (UnsupportedFlavorException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            FileNode[] nodes = (FileNode[])dtde.getTransferable().getTransferData(NodesTransferable.getDataFlavor());
            this.createDropSet(nodes);
            dtde.acceptDrop(3);
        }
        catch (UnsupportedFlavorException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            dtde.dropComplete(true);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void editNotes() {
        String currentNotes = "";
        String temp = this.volume.getImageDescription(this.getSliceNumberInSliceDirection());
        if (temp != null) {
            currentNotes = currentNotes + temp;
        }
        currentNotes = currentNotes.trim();
        JTextArea text = new JTextArea(4, 40);
        text.setText(currentNotes);
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        JScrollPane scroller = new JScrollPane(text);
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.add((Component)scroller, "Center");
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.getViewerFrame(), (Object)textPanel, "Edit Notes", -1);
        int selection = jopf.show();
        if (selection == 0) {
            String notes = text.getText();
            this.recordAction("setNotes", new String[]{ScriptUtils.convertString(notes)}, true);
            this.setNotes(notes);
        }
    }

    public void editOrigin() {
        String[] input;
        Coordinate coor = this.getCurrentCoordinate(this.baseScreenVolume, null, null, false, true, false);
        Coordinate oldImageOrigin = this.getCurrentCoordinate(this.baseScreenVolume, this.baseScreenVolume.getOrigin(), null, false, true, false);
        Coordinate oldWorldOrigin = this.getCurrentCoordinate(this.baseScreenVolume, this.baseScreenVolume.getOrigin(), null, false, true, false);
        EditOriginDialog dialog = new EditOriginDialog(this.isWorldMode(), new String[]{String.valueOf(oldImageOrigin.xInt), String.valueOf(oldImageOrigin.yInt), String.valueOf(oldImageOrigin.zInt)}, new String[]{String.valueOf(oldWorldOrigin.xInt), String.valueOf(oldWorldOrigin.yInt), String.valueOf(oldWorldOrigin.zInt)}, new String[]{FORMATTER.format(coor.xDbl), FORMATTER.format(coor.yDbl), FORMATTER.format(coor.zDbl)});
        boolean isApplet = this.mango.isApplet();
        MangoFocusableOptionPane jopf = null;
        jopf = isApplet ? new MangoFocusableOptionPane((MangoFocusableOptionPaneUser)((Object)Mango.getMangoApplet()), (Object)dialog, "Edit Origin", -1) : new MangoFocusableOptionPane(this.getFrame(), (Object)dialog, "Edit Origin", -1);
        int selection = jopf.show();
        if (selection == 0 && (input = dialog.getResult()) != null) {
            this.recordAction("setOrigin", new String[]{this.getScriptObjectName() + ".currentPosition"}, true);
            Coordinate result = null;
            try {
                result = new Coordinate(Double.parseDouble(input[0]), Double.parseDouble(input[1]), Double.parseDouble(input[2]));
            }
            catch (NumberFormatException ex) {
                AppLogger.error((Throwable)ex);
                result = null;
            }
            if (result != null) {
                this.setOrigin(result);
            }
        }
    }

    public void editPixel() {
        ScreenVolume screenVol = this.getBaseScreenVolume();
        Volume vol = screenVol.getVolume();
        Coordinate currentCoor = this.getCurrentCoordinate(screenVol, null, null, false, true, false);
        int tVal = vol.getCurrentTimepoint();
        double currentVal = vol.getRawVoxelValueAtIndex(currentCoor.xInt, currentCoor.yInt, currentCoor.zInt, tVal);
        String answer = (String)JOptionPane.showInputDialog(this, "Value of voxel = ", "Edit Voxel", -1, null, null, String.valueOf(currentVal));
        if (StringUtils.isNotBlank((CharSequence)answer)) {
            try {
                double newVal = Double.parseDouble(answer);
                this.recordAction("setVoxelValue", new String[]{this.getScriptObjectName() + ".currentPosition", this.getScriptObjectName() + ".baseVolume" + ".currentSeriesPoint", String.valueOf(newVal)}, true);
                this.setVoxelValue(currentCoor, tVal, newVal);
            }
            catch (NumberFormatException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }

    public void endIndeterminateProgressBar() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (SliceViewer.this.pbIndeterminate != null) {
                    SliceViewer.this.pbIndeterminate.setValue(100);
                }
            }
        };
        SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
    }

    public Point findCenterRelativeToScreen(Dimension size) {
        return DisplayUtils.getCenterDialogLocation(this.frame, size);
    }

    public Point findCenterRelativeToViewer(Dimension size) {
        return DisplayUtils.getCenterDialogLocationRelative(this.frame, size);
    }

    public Rectangle findCurrentDisplayBounds() {
        return DisplayUtils.findBoundsOfDisplay(DisplayUtils.findCurrentDisplayIndex(this.frame));
    }

    public Insets findCurrentDisplayInsets() {
        return DisplayUtils.findInsetsOfDisplay(DisplayUtils.findCurrentDisplayIndex(this.frame));
    }

    public Dimension findCurrentDisplaySize() {
        return DisplayUtils.findSizeOfDisplay(DisplayUtils.findCurrentDisplayIndex(this.frame));
    }

    public Point findGoodPluginWindowLocation(Dimension nextSize) {
        return DisplayUtils.getNextWindowLocation(this.frame, nextSize, null);
    }

    public ScreenVolume findOverlay(Volume vol) {
        ScreenVolume[] overlays = this.overlayManager.getAllOverlays();
        if (overlays != null) {
            for (ScreenVolume overlay : overlays) {
                if (overlay == null || overlay.getVolume() != vol) continue;
                return overlay;
            }
        }
        return null;
    }

    @Override
    public Method findRecordableMethod(String name, int numArgs) {
        try {
            Method[] methods;
            for (Method method : methods = VolumeManager.class.getMethods()) {
                Class<?>[] paramTypes = method.getParameterTypes();
                int numParamTypes = paramTypes.length;
                if (!method.getName().equals(name) || numArgs != numParamTypes) continue;
                return method;
            }
        }
        catch (SecurityException ex) {
            AppLogger.error((Throwable)ex);
        }
        return null;
    }

    public void flipAlongAxis(int sliceDirection) {
        this.recordAction("flipOrientation", new String[]{this.getScriptObjectName() + ".currentVolume", String.valueOf(sliceDirection)});
        if (sliceDirection == 2) {
            this.volume.flipLR();
        } else if (sliceDirection == 1) {
            this.volume.flipAP();
        } else if (sliceDirection == 0) {
            this.volume.flipSI();
        }
        if (this.transformManualPanel != null && this.transformManualPanel.isVisible()) {
            this.showTransformManualPanel();
        }
        this.forceImageUpdate();
        this.updateScreenSlices();
        this.repaint();
    }

    public void flipAlongAxis(Volume vol, int sliceDirection) {
        this.recordAction("flipOrientation", new String[]{this.getScriptObjectName() + ".currentVolume", String.valueOf(sliceDirection)});
        if (vol != null) {
            if (sliceDirection == 2) {
                vol.flipLR();
            } else if (sliceDirection == 1) {
                vol.flipAP();
            } else if (sliceDirection == 0) {
                vol.flipSI();
            }
        }
        this.updateScreenSlices();
        this.repaint();
    }

    public void flipOrientation(ImageVolume volume, int sliceDirection) {
        if (volume == this.volume) {
            this.flipAlongAxis(sliceDirection);
        } else {
            this.flipAlongAxis((Volume)volume, sliceDirection);
        }
    }

    public void forceDispose() {
        this.setClosing(true);
        this.cleanUp(true);
    }

    public void forceHistogramUpdate() {
        if (this.axialImage != null) {
            this.axialImage.needsHistogramUpdate();
        }
        if (this.coronalImage != null) {
            this.coronalImage.needsHistogramUpdate();
        }
        if (this.sagittalImage != null) {
            this.sagittalImage.needsHistogramUpdate();
        }
    }

    public void forceImageUpdate() {
        if (this.axialImage != null) {
            this.axialImage.needsImageUpdate();
        }
        if (this.coronalImage != null) {
            this.coronalImage.needsImageUpdate();
        }
        if (this.sagittalImage != null) {
            this.sagittalImage.needsImageUpdate();
        }
    }

    public void frameCreated() {
        if (!this.isActive()) {
            this.setAsCurrentViewer();
        }
        this.toolBox.setEnabledItems(true, true);
        if (this.toolBox.isGlobal()) {
            this.toolBox.updateGlobalState(this.baseScreenVolume.getScreenMin(), this.baseScreenVolume.getScreenMax());
        }
        this.mango.loadNextViewer();
    }

    public void frameToFront() {
        this.frame.toFront();
    }

    public ViewerAssociated[] getAllAssociatedWindows() {
        if (this.windowManager != null) {
            return this.windowManager.getAllViewerAssociatedWindows();
        }
        return null;
    }

    public Line[] getAllSelectedLOIs() {
        LOIShape[] shapes;
        int ctr;
        Vector<LOIShape> allLOIs = new Vector<LOIShape>();
        LOIManager[] allManagers = new LOIManager[]{this.loiManagerAxial, this.loiManagerCoronal, this.loiManagerSagittal};
        int mainSliceDirection = this.getMainSliceDirection();
        int mainSlice = this.getMainSliceNumber();
        LOIManager firstManager = allManagers[mainSliceDirection];
        for (ctr = mainSlice; ctr < firstManager.getSlices(); ++ctr) {
            shapes = firstManager.getAllSelectedInSlice(ctr);
            if (shapes == null) continue;
            for (LOIShape shape : shapes) {
                allLOIs.add(shape);
            }
        }
        for (ctr = 0; ctr < mainSlice; ++ctr) {
            shapes = firstManager.getAllSelectedInSlice(ctr);
            if (shapes == null) continue;
            for (LOIShape shape : shapes) {
                allLOIs.add(shape);
            }
        }
        ++mainSliceDirection;
        LOIManager secondManager = allManagers[mainSliceDirection %= 3];
        for (int ctr2 = 0; ctr2 < secondManager.getSlices(); ++ctr2) {
            LOIShape[] shapes2 = secondManager.getAllSelectedInSlice(ctr2);
            if (shapes2 == null) continue;
            for (LOIShape shape : shapes2) {
                allLOIs.add(shape);
            }
        }
        ++mainSliceDirection;
        LOIManager thirdManager = allManagers[mainSliceDirection %= 3];
        for (int ctr3 = 0; ctr3 < thirdManager.getSlices(); ++ctr3) {
            LOIShape[] shapes3 = thirdManager.getAllSelectedInSlice(ctr3);
            if (shapes3 == null) continue;
            for (LOIShape shape : shapes3) {
                allLOIs.add(shape);
            }
        }
        Line[] allLOIsArray = null;
        if (allLOIs.size() > 0) {
            allLOIsArray = allLOIs.toArray(new Line[allLOIs.size()]);
        }
        return allLOIsArray;
    }

    public List<ROI> getAllSelectedROIs() {
        ArrayList<ROI> rois = new ArrayList<ROI>();
        rois.addAll(this.poiManager.getSelectedPoints());
        rois.addAll(this.loiManagerAxial.getSelectedLines());
        rois.addAll(this.loiManagerCoronal.getSelectedLines());
        rois.addAll(this.loiManagerSagittal.getSelectedLines());
        rois.addAll(this.roiManager.getSelectedMasks());
        return rois;
    }

    public String getAllShapeLabelsForColor(int colorIndex) {
        StringBuffer sb = new StringBuffer("<html>");
        sb.append(this.loiManagerAxial.getAllLabelsForColor(colorIndex)).append(this.loiManagerCoronal.getAllLabelsForColor(colorIndex)).append(this.loiManagerSagittal.getAllLabelsForColor(colorIndex)).append("</html>");
        return sb.toString();
    }

    public ViewerController[] getAllViewerControllers(boolean includeSelf) {
        ViewerController[] controllers = null;
        SliceViewer[] viewers = Mango.getAllSliceViewers(this, includeSelf);
        if (viewers != null) {
            controllers = new ViewerController[viewers.length];
            for (int ctr = 0; ctr < controllers.length; ++ctr) {
                controllers[ctr] = viewers[ctr];
            }
        }
        return controllers;
    }

    public Atlas getAtlas() {
        return this.toolBox.getCurrentAtlas();
    }

    public Atlas getAtlas(String atlasName) {
        return this.toolBox.getAtlas(atlasName);
    }

    public ScreenSlice getAxialScreenSlice() {
        return this.axialImage;
    }

    @Override
    public int getAxialSliceNumber() {
        return this.axialImage.getCurrentSlice();
    }

    public MangoImage getBaseImage() {
        return this.getBaseMangoImage();
    }

    public MangoImage getBaseMangoImage() {
        ImageTransform[] indexTransforms = null;
        boolean numIndex = true;
        indexTransforms = new ImageTransform[1];
        for (int ctr = 0; ctr < 1; ++ctr) {
            indexTransforms[ctr] = this.volume.getIndexImageTransform(ctr);
        }
        ImageTransform[] worldTransforms = null;
        boolean numWorld = true;
        worldTransforms = new ImageTransform[1];
        for (int ctr = 0; ctr < 1; ++ctr) {
            worldTransforms[ctr] = this.volume.getWorldImageTransform(ctr);
        }
        return new MangoImage((ImageVolume)this.volume, this.volume.getImageDimensions(), this.volume.getVoxelDimensions(), this.volume.getImageType(), this.volume.getImageRange(), this.volume.getImageDescription(), this.volume.getFormatSpecificInfo(), this.volume.getOrigin(), this.volume.getOriginNative(), indexTransforms, (ScreenImage)this.baseScreenVolume, this.getLoadedFile(), this.volume.getOrientationString());
    }

    public ScreenVolume getBaseScreenVolume() {
        return this.baseScreenVolume;
    }

    public Volume getBaseVolume() {
        return this.baseScreenVolume.getVolume();
    }

    @Override
    public File getCaptureDir() {
        return this.getLoadedFile().getParentFile();
    }

    @Override
    public String getCaptureName() {
        String name = this.getLoadedFile().getName();
        if (name.indexOf(46) != -1) {
            name = name.substring(0, name.indexOf(46));
        }
        return name;
    }

    @Override
    public String getCaptureType() {
        return "main";
    }

    public ClusterAnalysisTool getClusterAnalysis() {
        return this.clusterAnalysis;
    }

    public ClusterROIAnalysisTool getClusterROIAnalysis() {
        return this.clusterROIAnalysis;
    }

    public boolean isContainsMouse() {
        return this.containsMouse;
    }

    public int getCoordinateType() {
        return this.toolBox.getCoordinateType();
    }

    public ScreenSlice getCoronalScreenSlice() {
        return this.coronalImage;
    }

    @Override
    public int getCoronalSliceNumber() {
        return this.coronalImage.getCurrentSlice();
    }

    public Crosssection getCrosssection() {
        return this.crosssection;
    }

    public Coordinate getCurrentCoordinate() {
        return this.getCurrentCoordinate(null, null);
    }

    public Coordinate getCurrentCoordinate(Coordinate coor) {
        return this.getCurrentCoordinate(coor, null);
    }

    public Coordinate getCurrentCoordinate(Coordinate coor, Coordinate coorNew) {
        return this.getCurrentCoordinate(this.baseScreenVolume, coor, coorNew);
    }

    public Coordinate getCurrentCoordinate(ScreenVolume aScreenVol, Coordinate coor, Coordinate coorNew, boolean useDouble) {
        return this.getCurrentCoordinate(aScreenVol, coor, coorNew, useDouble, false, false);
    }

    public Coordinate getCurrentCoordinate(ScreenVolume aScreenVol, Coordinate coor, Coordinate coorNew, boolean useDouble, boolean forceIndex, boolean forceWorld) {
        Coordinate coorReturn;
        int labelType = this.toolBox.getCoordinateType();
        if (forceIndex) {
            labelType = 0;
        } else if (forceWorld) {
            labelType = 4;
        }
        Coordinate coordinate = coorReturn = coorNew == null ? new Coordinate() : coorNew;
        if (this.volume.isInitialized()) {
            double zLoc;
            double yLoc;
            double xLoc;
            if (coor == null) {
                xLoc = this.sagittalImage.getCurrentSlice();
                yLoc = this.coronalImage.getCurrentSlice();
                zLoc = this.axialImage.getCurrentSlice();
            } else if (useDouble) {
                xLoc = coor.xDbl;
                yLoc = coor.yDbl;
                zLoc = coor.zDbl;
            } else {
                xLoc = coor.xInt;
                yLoc = coor.yInt;
                zLoc = coor.zInt;
            }
            Coordinate originImage = null;
            if (aScreenVol != null) {
                originImage = aScreenVol.getOrigin();
            }
            if ((labelType & 2) != 0 || (labelType & 4) != 0) {
                coorReturn.setValues((xLoc - (double)originImage.xInt) * this.volume.getXSize(), ((double)originImage.yInt - yLoc) * this.volume.getYSize(), ((double)originImage.zInt - zLoc) * this.volume.getZSize());
            } else {
                coorReturn.setValues(xLoc, yLoc, zLoc);
            }
        }
        return coorReturn;
    }

    public Line getCurrentCrosssectionShape() {
        return this.crosssection.getCurrentShape();
    }

    public Coordinate getCurrentIndex() {
        return this.getCurrentIndex(null);
    }

    public Coordinate getCurrentIndex(Coordinate coor) {
        return this.getCurrentCoordinate(this.baseScreenVolume, null, coor, false, true, false);
    }

    public int getCurrentIndexTransformIndex() {
        return this.volume.getCurrentIndexTransformIndex();
    }

    public int getCurrentOverlayIndex() {
        if (this.isCurrentVolumeOverlay()) {
            return this.overlayManager.getIndex(this.currentScreenVolume);
        }
        return -1;
    }

    public Coordinate getCurrentPosition() {
        return this.getCurrentIndex();
    }

    @Deprecated
    public int getCurrentROI() {
        return this.roiManager.getCurrentROI();
    }

    public ScreenVolume getCurrentScreenVolume() {
        return this.currentScreenVolume;
    }

    @Override
    public LabelManager getCurrentSeriesLabelManager() {
        return this.getCurrentVolume();
    }

    public int getCurrentSliceNativeOrder() {
        if (this.sliceOrderingIsForwardOrientation()) {
            return this.getSliceNumberInSliceDirection();
        }
        return this.getVolume().getNumSlices() - this.getSliceNumberInSliceDirection() - 1;
    }

    @Override
    public int getCurrentTimepoint() {
        return this.getCurrentScreenVolume().getVolume().getCurrentTimepoint();
    }

    public Transform getCurrentTransform() {
        return this.volume.getWorldTransform(0);
    }

    @Deprecated
    public int getCurrentTransformIndex() {
        return this.baseScreenVolume.isUsingTransform() ? 1 : 0;
    }

    public Volume getCurrentVolume() {
        if (this.currentScreenVolume != null) {
            return this.currentScreenVolume.getVolume();
        }
        return null;
    }

    public Coordinate getCurrentWorldPosition() {
        return this.getCurrentWorldCoordinate(null);
    }

    public int getCurrentWorldTransformIndex() {
        return this.volume.getCurrentWorldTransformIndex();
    }

    public Point getCursorPosition() {
        Point point = null;
        if (this.mainImage != null && this.mainImage.containsMouse()) {
            point = this.mainImage.getCurrentCursorPosition();
        }
        return point;
    }

    public Mango getExecutive() {
        return this.mango;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public int getFrameState() {
        return this.frame.getState();
    }

    public HistogramPanel getHistogram() {
        return this.histogram;
    }

    public Histogram getHistogramAnalysis() {
        return this.histogram.makeStat();
    }

    public int getHistogramOverlayCode() {
        return this.histogram.getCurrentOverlayCode();
    }

    public ImageDimensions getImageDimensions() {
        return this.volume.getImageDimensions();
    }

    public ImageInfoDialog getImageInfo() {
        return this.imageInfo;
    }

    public Coordinate getImageOrigin() {
        return this.volume.getOrigin();
    }

    public String getImageTitle() {
        return this.getImageTitle(this.baseScreenVolume);
    }

    public File getLibDir() {
        return Platform.getLibDir();
    }

    public File getLoadedFile() {
        if (FileUtilities.uriIsFile((URI)this.loadedURI)) {
            if (this.loadedURI.isAbsolute()) {
                return new File(this.loadedURI);
            }
            return new File(this.loadedURI.toString());
        }
        return new File(this.loadedURI.toString());
    }

    public URI getLoadedURI() {
        return this.loadedURI;
    }

    public URI getLoadedURI(ImageVolume volume) {
        ScreenVolume screenVol = this.findVolume(volume);
        if (screenVol != null) {
            return screenVol.getURI();
        }
        return null;
    }

    public LogicalAnalysisTool getLogicalManager() {
        return this.logicalManager;
    }

    @Override
    public LOIManager getLOIManagerAxial() {
        return this.loiManagerAxial;
    }

    @Override
    public LOIManager getLOIManagerCoronal() {
        return this.loiManagerCoronal;
    }

    public LOIManager getLOIManagerMain() {
        int sliceDirection = this.getMainSliceDirection();
        if (sliceDirection == 0) {
            return this.loiManagerAxial;
        }
        if (sliceDirection == 1) {
            return this.loiManagerCoronal;
        }
        return this.loiManagerSagittal;
    }

    @Override
    public LOIManager getLOIManagerSagittal() {
        return this.loiManagerSagittal;
    }

    public int getLongestDim() {
        return this.longestDim;
    }

    public double getLongestDimSize() {
        return this.longestDimSize;
    }

    public int getLowerLeftSliceNumber() {
        return this.lowerImageLeft.getCurrentSlice();
    }

    public int getLowerLeftSliceType() {
        if (this.lowerImageLeft == this.axialImage) {
            return 0;
        }
        if (this.lowerImageLeft == this.coronalImage) {
            return 1;
        }
        return 2;
    }

    public int getLowerRightSliceNumber() {
        return this.lowerImageRight.getCurrentSlice();
    }

    public int getLowerRightSliceType() {
        if (this.lowerImageRight == this.axialImage) {
            return 0;
        }
        if (this.lowerImageRight == this.coronalImage) {
            return 1;
        }
        return 2;
    }

    public BufferedImage getMainImage() {
        return this.mainImage.getImage();
    }

    public BufferedImage getMainImage(boolean exclude) {
        return this.mainImage.getImage(exclude);
    }

    public BufferedImage getMainImage(BufferedImage bi, int aSlice) {
        return this.mainImage.getImage(bi, aSlice);
    }

    public BufferedImage getMainImage(BufferedImage bi, int aSlice, boolean exclude) {
        return this.mainImage.getImage(bi, aSlice, exclude);
    }

    public BufferedImage getMainImage(BufferedImage bi, int aSlice, int time, boolean exclude) {
        this.volume.setCurrentTimepoint(time);
        return this.mainImage.getImage(bi, aSlice, exclude);
    }

    public LOIManager getMainImageLOIManager() {
        if (this.mainImage.getSliceDirection() == 0) {
            return this.loiManagerAxial;
        }
        if (this.mainImage.getSliceDirection() == 1) {
            return this.loiManagerCoronal;
        }
        return this.loiManagerSagittal;
    }

    public ScreenSlice getMainScreenSlice() {
        return this.mainImage;
    }

    public int getMainSliceDirection() {
        return this.mainImage.getSliceDirection();
    }

    public int getMainSliceNumber() {
        return this.mainImage.getCurrentSlice();
    }

    public int getMainSlicePosition() {
        return this.getMainSliceNumber();
    }

    public int getMainSliceType() {
        if (this.mainImage == this.axialImage) {
            return 0;
        }
        if (this.mainImage == this.coronalImage) {
            return 1;
        }
        return 2;
    }

    public int getMainSliceX() {
        return this.mainImage.getXdim();
    }

    public int getMainSliceY() {
        return this.mainImage.getYdim();
    }

    public String getManagerTitle() {
        return this.getImageTitle();
    }

    public Mango getMango() {
        return this.mango;
    }

    @Deprecated
    public MangoData getMangoData() {
        Vector<ScreenImage> vec = this.overlayManager.getScreenImages();
        vec.insertElementAt(this.getBaseScreenVolume(), 0);
        ScreenImage[] images = vec.toArray(new ScreenImage[vec.size()]);
        return new MangoData(this.getBaseMangoImage(), this.getOverlayMangoImages(), images, (ROIData)this.getMangoROI());
    }

    public MangoROI getMangoROI() {
        return new MangoROI((ROIMaskManager)this.roiManager, new ShapesManager[]{this.loiManagerAxial, this.loiManagerCoronal, this.loiManagerSagittal}, new ShapesSpecialManager[]{this.loiManagerAxialP, this.loiManagerCoronalP, this.loiManagerSagittalP}, (PointsManager)this.poiManager, (PointsSpecialManager)this.poiManagerSpecial);
    }

    @Override
    public String getMangoVersion() {
        return this.mango.getVersion();
    }

    public EditTransformTool getManualTransformPanel() {
        return this.transformManualPanel;
    }

    public int getMaxROIColors() {
        return this.roiManager.getMaximumColors();
    }

    public String getName(ImageVolume volume) {
        return this.getImageTitle(this.findVolume(volume));
    }

    public int getNativeSliceDirection() {
        char sliceDir = this.volume.getOrientationString().charAt(2);
        if (sliceDir == 'X') {
            return 2;
        }
        if (sliceDir == 'Y') {
            return 1;
        }
        return 0;
    }

    public LOIShape getNextShape(int startSlice, int startDirection, LOIShape shape, int color) {
        LOIShape nextShape = null;
        if (startDirection == 0) {
            nextShape = shape != null ? this.loiManagerAxial.getNextShape(startSlice, shape) : this.loiManagerAxial.getFirstShape(color);
            if (nextShape == null) {
                nextShape = this.loiManagerCoronal.getFirstShape(color);
            }
            if (nextShape == null) {
                nextShape = this.loiManagerSagittal.getFirstShape(color);
            }
            if (nextShape == null) {
                nextShape = this.loiManagerAxial.getFirstShape(color);
            }
        } else if (startDirection == 1) {
            nextShape = shape != null ? this.loiManagerCoronal.getNextShape(startSlice, shape) : this.loiManagerCoronal.getFirstShape(color);
            if (nextShape == null) {
                nextShape = this.loiManagerSagittal.getFirstShape(color);
            }
            if (nextShape == null) {
                nextShape = this.loiManagerAxial.getFirstShape(color);
            }
            if (nextShape == null) {
                nextShape = this.loiManagerCoronal.getFirstShape(color);
            }
        } else if (startDirection == 2) {
            nextShape = shape != null ? this.loiManagerSagittal.getNextShape(startSlice, shape) : this.loiManagerSagittal.getFirstShape(color);
            if (nextShape == null) {
                nextShape = this.loiManagerAxial.getFirstShape(color);
            }
            if (nextShape == null) {
                nextShape = this.loiManagerCoronal.getFirstShape(color);
            }
            if (nextShape == null) {
                nextShape = this.loiManagerSagittal.getFirstShape(color);
            }
        }
        return nextShape;
    }

    public String getNiceImageTitle() {
        String name = this.getImageTitle(this.currentScreenVolume);
        if (name.length() > 25) {
            name = name.substring(0, 25) + "...";
        }
        return name;
    }

    public int getNumOverlays() {
        if (this.overlayManager != null) {
            return this.overlayManager.getNumInStack();
        }
        return 0;
    }

    public int getOrientationCertainty() {
        return this.orientationCertainty;
    }

    public Coordinate getOrigin() {
        return this.volume.getOrigin();
    }

    public MangoImage[] getOverlayImages() {
        return this.getOverlayMangoImages();
    }

    public OverlayManager getOverlayManager() {
        return this.overlayManager;
    }

    public MangoImage[] getOverlayMangoImages() {
        MangoImage[] overlayMangos = null;
        int numOverlays = this.getNumOverlays();
        if (numOverlays > 0) {
            overlayMangos = new MangoImage[numOverlays];
            for (int ctr = 0; ctr < numOverlays; ++ctr) {
                Volume currentVol = this.overlayManager.getOverlay(ctr).getVolume();
                File file = null;
                URI uri = this.overlayManager.getOverlay(ctr).getURI();
                if (uri != null) {
                    file = new File(uri);
                }
                overlayMangos[ctr] = new MangoImage((ImageVolume)currentVol, currentVol.getImageDimensions(), currentVol.getVoxelDimensions(), currentVol.getImageType(), currentVol.getImageRange(), currentVol.getImageDescription(), currentVol.getFormatSpecificInfo(), currentVol.getOrigin(), currentVol.getOriginNative(), null, (ScreenImage)this.overlayManager.getOverlay(ctr), file, currentVol.getOrientationString());
            }
        }
        return overlayMangos;
    }

    public List<ImageVolume> getOverlays() {
        ScreenVolume[] screenVolumes;
        ArrayList<ImageVolume> overlays = new ArrayList<ImageVolume>();
        for (ScreenVolume screenVolume : screenVolumes = this.overlayManager.getAllOverlays()) {
            if (screenVolume == null) continue;
            overlays.add(screenVolume.getImageVolume());
        }
        return overlays;
    }

    public int getPanAmountX() {
        return this.panAmountX;
    }

    public int getPanAmountY() {
        return this.panAmountY;
    }

    public int getPanAmountZ() {
        return this.panAmountZ;
    }

    @Override
    public POIManager getPOIManager() {
        return this.poiManager;
    }

    public Point getPositionRelativeToMainSlice(Point point) {
        SwingUtilities.convertPointToScreen(point, this.mainImage);
        return point;
    }

    public ProgressBarListener getProgressBarListener() {
        return this.getToolBox();
    }

    public ProjectionFrame getProjection() {
        return this.projection;
    }

    public ProjectionManager getProjectionManager() {
        return this.projection.getProjectionView();
    }

    public MangoROI getROI() {
        return this.getMangoROI();
    }

    public int getRoiColor() {
        return this.roiManager.getCurrentROI();
    }

    @Deprecated
    public int getROIColor() {
        return this.roiManager.getCurrentROI();
    }

    public ROIInspectorTool getROICounts() {
        return this.roiInspector;
    }

    public ROIData getRoiData() {
        return this.getMangoROI();
    }

    public File getROIGZIPFile() {
        return this.roiFileGZIP;
    }

    @Override
    public ROIManager getROIManager() {
        return this.roiManager;
    }

    public int getROIMode() {
        return ROIManager.ROI_TYPES.get(this.toolBox.getROIEditMode());
    }

    public int getROITool() {
        return this.getROIMode();
    }

    public int getROIToolSize() {
        return (int)((double)this.mango.getROIToolSize() * this.mango.getRoiToolSizeMultiplier() + 0.5);
    }

    public ScreenSlice getSagittalScreenSlice() {
        return this.sagittalImage;
    }

    @Override
    public int getSagittalSliceNumber() {
        return this.sagittalImage.getCurrentSlice();
    }

    public String getSaveDirectory() {
        File loadedFile = this.getLoadedFile();
        File dirFile = loadedFile.getParentFile();
        if (dirFile.exists()) {
            return dirFile.toString();
        }
        return this.mango.getLoadFileDirectory();
    }

    public double getScreenRatio() {
        if (this.toolBox.isGlobal()) {
            return this.toolBox.getGlobalScreenRatio();
        }
        return this.baseScreenVolume.getScreenRatio();
    }

    public ScreenSlice getScreenSlice(int direction) {
        if (direction == 0) {
            return this.getAxialScreenSlice();
        }
        if (direction == 1) {
            return this.getCoronalScreenSlice();
        }
        return this.getSagittalScreenSlice();
    }

    public double getScreenSliceMax() {
        if (this.toolBox.isGlobal()) {
            return this.toolBox.getScreenMax();
        }
        return this.baseScreenVolume.getScreenMax();
    }

    public double getScreenSliceMin() {
        if (this.toolBox.isGlobal()) {
            return this.toolBox.getScreenMin();
        }
        return this.baseScreenVolume.getScreenMin();
    }

    public AffineTransform getScreenTransform(int dir) {
        if (dir == 0) {
            return this.axialImage.getFinalTransform();
        }
        if (dir == 1) {
            return this.coronalImage.getFinalTransform();
        }
        if (dir == 2) {
            return this.sagittalImage.getFinalTransform();
        }
        return null;
    }

    public ScreenVolume getScreenVolume() {
        return this.getBaseScreenVolume();
    }

    @Override
    public String getScriptObjectName() {
        return this.recordableName;
    }

    public Object getScriptResult() {
        return this.scriptResult;
    }

    public long getSelectedROIMaskInCurrentSlice() {
        int sliceStatsDirection = this.mainImage.getSliceDirection();
        int sliceStatsCurrentSlice = this.mainImage.getCurrentSlice();
        if (sliceStatsDirection == 0) {
            return this.roiManager.getSelectedMaskInRange(0, this.volume.getXDim() - 1, 0, this.volume.getYDim() - 1, sliceStatsCurrentSlice, sliceStatsCurrentSlice);
        }
        if (sliceStatsDirection == 1) {
            return this.roiManager.getSelectedMaskInRange(0, this.volume.getXDim() - 1, sliceStatsCurrentSlice, sliceStatsCurrentSlice, 0, this.volume.getZDim() - 1);
        }
        return this.roiManager.getSelectedMaskInRange(sliceStatsCurrentSlice, sliceStatsCurrentSlice, 0, this.volume.getYDim() - 1, 0, this.volume.getZDim() - 1);
    }

    public int getShapeCount(int colorIndex) {
        int ctr;
        int count = 0;
        for (ctr = 0; ctr < this.volume.getZDim(); ++ctr) {
            count += this.loiManagerAxial.getCount(ctr, colorIndex);
        }
        for (ctr = 0; ctr < this.volume.getYDim(); ++ctr) {
            count += this.loiManagerCoronal.getCount(ctr, colorIndex);
        }
        for (ctr = 0; ctr < this.volume.getXDim(); ++ctr) {
            count += this.loiManagerSagittal.getCount(ctr, colorIndex);
        }
        return count;
    }

    public int getSliceDirection() {
        return this.mainImage.getSliceDirection();
    }

    public int getSliceNumber() {
        return this.mainImage.getCurrentSlice();
    }

    public int getSliceNumberInSliceDirection() {
        char sliceDir = this.volume.getOrientationString().charAt(2);
        int sliceNum = 0;
        sliceNum = sliceDir == 'X' ? this.sagittalImage.getCurrentSlice() : (sliceDir == 'Y' ? this.coronalImage.getCurrentSlice() : this.axialImage.getCurrentSlice());
        return sliceNum;
    }

    public Point getStartLocation() {
        return this.startLocation;
    }

    public Dimension getStartSize() {
        return this.startSize;
    }

    public SurfaceManager getSurfaceManager() {
        return this.surfaceRender;
    }

    public SurfaceViewer getSurfaceRender() {
        return this.surfaceRender;
    }

    public SurfaceViewer getSurfaceRenderer() {
        return this.surfaceRender;
    }

    public double getSurfaceThreshold() {
        if (this.surfaceRender != null && this.surfaceRender.isInitialized()) {
            return this.surfaceRender.getThreshold();
        }
        return this.getScreenVolume().getDynamicScreenMin();
    }

    @Override
    public File getTempDir() {
        return Platform.getTempDir();
    }

    public Timeseries getTimeseries() {
        return this.timeseries;
    }

    public Toolbox getToolBox() {
        return this.toolBox;
    }

    public double getToolboxMax() {
        return (double)this.baseScreenVolume.getMaxLUT() / this.baseScreenVolume.getScreenRatio() + this.baseScreenVolume.getScreenMin();
    }

    public double getToolboxMin() {
        return (double)this.baseScreenVolume.getMinLUT() / this.baseScreenVolume.getScreenRatio() + this.baseScreenVolume.getScreenMin();
    }

    public long getUsedROIs() {
        return this.roiManager.getBuffer().getUsed();
    }

    public String getVersion() {
        return this.getMangoVersion();
    }

    public Container getViewerContainer() {
        return this.frame;
    }

    public ViewerFrame getViewerFrame() {
        return this.frame;
    }

    public Point getViewerLocation() {
        return this.frame.getLocation();
    }

    public Dimension getViewerSize() {
        return this.getPreferredSize();
    }

    public Volume getVolume() {
        return this.volume;
    }

    public ImageVolume getVolume(int index) {
        if (index == 0) {
            return this.getBaseVolume();
        }
        return this.overlayManager.getOverlay(index - 1).getVolume();
    }

    public double getVolumeDisplayAlpha(ImageVolume volume) {
        return this.findVolume(volume).getAlpha();
    }

    public String getVolumeDisplayColorTable(ImageVolume volume) {
        return this.findVolume(volume).getLookupTableManager().getName();
    }

    public double getVolumeDisplayRangeMax(ImageVolume volume) {
        return this.findVolume(volume).getScreenMax();
    }

    public double getVolumeDisplayRangeMin(ImageVolume volume) {
        return this.findVolume(volume).getScreenMin();
    }

    public int getVolumeIndex(ImageVolume volume) {
        if (volume == this.getBaseVolume()) {
            return 0;
        }
        return this.overlayManager.getIndex((Volume)volume) + 1;
    }

    public List<ImageVolume> getVolumes() {
        List<ImageVolume> volumes = this.getOverlays();
        volumes.add(0, this.volume);
        return volumes;
    }

    public VoxelDimensions getVoxelDimensions() {
        return this.volume.getVoxelDimensions();
    }

    public int getXDim() {
        return this.volume.getXDim();
    }

    @Override
    public int getXDim(int sliceDirection) {
        if (sliceDirection == 0) {
            return this.getXDim();
        }
        if (sliceDirection == 1) {
            return this.getXDim();
        }
        return this.getYDim();
    }

    public double getXSize() {
        return this.volume.getXSize();
    }

    @Override
    public double getXSize(int sliceDirection) {
        if (sliceDirection == 0) {
            return this.getXSize();
        }
        if (sliceDirection == 1) {
            return this.getXSize();
        }
        return this.getYSize();
    }

    public int getYDim() {
        return this.volume.getYDim();
    }

    @Override
    public int getYDim(int sliceDirection) {
        if (sliceDirection == 0) {
            return this.getYDim();
        }
        if (sliceDirection == 1) {
            return this.getZDim();
        }
        return this.getZDim();
    }

    public double getYSize() {
        return this.volume.getYSize();
    }

    @Override
    public double getYSize(int sliceDirection) {
        if (sliceDirection == 0) {
            return this.getYSize();
        }
        if (sliceDirection == 1) {
            return this.getZSize();
        }
        return this.getZSize();
    }

    public int getZDim() {
        return this.volume.getZDim();
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public double getZoomFactorPrevious() {
        return this.zoomFactorPrevious;
    }

    public int getZoomLocationX() {
        return this.zoomLocX;
    }

    public int getZoomLocationY() {
        return this.zoomLocY;
    }

    public int getZoomLocationZ() {
        return this.zoomLocZ;
    }

    public String getZoomString() {
        return FORMATTER.format(this.zoomFactor * 100.0);
    }

    public double getZSize() {
        return this.volume.getZSize();
    }

    public boolean hasActivePolyLine() {
        return this.mainImage.hasActivePolyLine();
    }

    public boolean hasOverlays() {
        return this.overlayManager.getNumInStack() > 0;
    }

    public boolean hasOverlayTimeseries() {
        ScreenVolume[] overlays = this.overlayManager.getAllOverlays();
        if (overlays != null) {
            for (ScreenVolume overlay : overlays) {
                if (overlay == null || overlay.getVolume().getNumTimepoints() <= 1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRedo() {
        return this.hasRedoPOI() || this.hasRedoLOI() || this.hasRedoROI();
    }

    public boolean hasSelected() {
        return this.hasSelectedPOIs() || this.hasSelectedLOIs() || this.hasSelectedROIs();
    }

    public boolean hasSelectedLOIs() {
        return this.loiManagerAxial.hasSelectedShapes() || this.loiManagerCoronal.hasSelectedShapes() || this.loiManagerSagittal.hasSelectedShapes();
    }

    public boolean hasSelectedPOIs() {
        return this.poiManager.hasSelected();
    }

    public boolean hasSelectedROIs() {
        if (this.toolBox.isVOIMode() && this.roiManager.hasSelected()) {
            return true;
        }
        return !this.toolBox.isVOIMode() && this.hasSelectedROIInCurrentSlice() && this.roiManager.isSelectedSlice(this.mainImage.getCurrentSlice(), this.mainImage.getSliceDirection());
    }

    public boolean hasTimeseries() {
        return this.volume.getNumTimepoints() > 1 || this.hasOverlayTimeseries();
    }

    public boolean hasUndo() {
        return this.hasUndoPOI() || this.hasUndoLOI() || this.hasUndoROI();
    }

    public void importROI(URI externalROIFile, boolean forceWorld) {
        try {
            String description;
            boolean isMangoROIByFile;
            Header roiHeader = new Header(externalROIFile);
            ImageType it = roiHeader.getImageType();
            ImageDimensions id = roiHeader.getImageDimensions();
            new Orientation(roiHeader.getOrientationString(), id, roiHeader.getVoxelDimensions(), roiHeader.getOrigin());
            boolean bl = isMangoROIByFile = roiHeader.hasExtension(NIFTI.getHeaderExtensionMagicNumberOld()[0]) || roiHeader.hasExtension(NIFTI.getHeaderExtensionMagicNumber1()[0]);
            if (!isMangoROIByFile && (description = roiHeader.getImageDescription().getDescription()) != null) {
                isMangoROIByFile = description.startsWith("Mango ROI");
            }
            this.importROI(externalROIFile, forceWorld, isMangoROIByFile &= it.getNumBytesPerVoxel() == 1, false);
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    public void importROI(URI uri, boolean forceWorld, boolean isMangoROI) {
        this.importROI(uri, forceWorld, isMangoROI, false);
    }

    @Override
    public void importROICompleted(Volume importVolume, final Coordinate firstCoordFound) {
        if (importVolume != null) {
            importVolume.clearImage();
        }
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                if (firstCoordFound != null && !firstCoordFound.isAllZeros()) {
                    SliceViewer.this.setCurrentCoordinate(firstCoordFound, true, 0);
                    if (firstCoordFound instanceof Coordinate4D) {
                        int timepoint = ((Coordinate4D)firstCoordFound).seriesPoint;
                        SliceViewer.this.setCurrentTimepoint(timepoint);
                    }
                }
                SliceViewer.this.updateViewer();
            }
        });
    }

    public boolean increment(final int direction) {
        final boolean[] value = new boolean[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                value[0] = SliceViewer.this.incrementSlice(direction);
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
        return value[0];
    }

    public void incrementROIToolSize() {
        this.mango.increaseROIToolSize();
        this.mainImage.updateStructureElement();
        if (this.mainImage.isPressed()) {
            this.mainImage.doROIFill();
        }
        this.mainImage.repaint();
    }

    public boolean incrementSlice(int sliceTypeVal) {
        boolean baseImageIsCurrent;
        int sliceType = sliceTypeVal;
        if (sliceTypeVal == -1) {
            sliceType = this.getMainSliceDirection();
            this.recordAction("increment", new String[]{this.getScriptObjectName() + ".sliceDirection"});
        } else {
            this.recordAction("increment", new String[]{String.valueOf(sliceType)});
        }
        boolean didIncrement = false;
        boolean hasBaseImageTimeseries = this.getScreenVolume().getVolume().getNumTimepoints() > 1;
        boolean hasOverlayTimeseries = this.hasOverlayTimeseries();
        boolean bl = baseImageIsCurrent = this.getScreenVolume() == this.getCurrentScreenVolume();
        if (sliceType == 3) {
            ScreenVolume refTimeseries;
            if (this.isNavigationDisabled()) {
                return false;
            }
            if (baseImageIsCurrent && hasBaseImageTimeseries) {
                didIncrement = this.getCurrentScreenVolume().getVolume().getCurrentTimepoint() < this.getCurrentScreenVolume().getVolume().getNumTimepoints() - 1;
                if (didIncrement) {
                    this.getScreenVolume().getVolume().setCurrentTimepoint(this.getScreenVolume().getVolume().getCurrentTimepoint() + 1);
                    this.updateSyncSeries();
                }
            } else if (hasOverlayTimeseries && (refTimeseries = this.findTopOverlayTimeseries()) != null && (didIncrement = refTimeseries.getVolume().getCurrentTimepoint() < refTimeseries.getVolume().getNumTimepoints() - 1)) {
                refTimeseries.getVolume().setCurrentTimepoint(refTimeseries.getVolume().getCurrentTimepoint() + 1);
                this.reconcileOverlayTimeseries(refTimeseries);
            }
            if (didIncrement) {
                this.toolBox.setMouseLabelInfoIncrement(3, 0);
                if (this.frame != null) {
                    this.updateWindowTitle();
                }
                if (this.crosssection.getParentFrame() != null) {
                    this.crosssection.updateCrosssection();
                }
                if (this.timeseries.getParentFrame() != null) {
                    this.timeseries.setCurrentIndex(this.getCurrentScreenVolume().getVolume().getCurrentTimepoint());
                }
                if (this.clusterAnalysis != null) {
                    this.clusterAnalysis.overlayTimepointChanged();
                }
                this.forceImageUpdate();
                this.updateScreenSlices();
                this.updateSurface();
                this.updateSurfaceColorAtTimepoint();
                if (this.roiManager.isUsing4dROI()) {
                    this.updateROISlices();
                }
            }
        } else {
            if (sliceType == 0) {
                if (this.axialImage.isDragging()) {
                    this.axialImage.updateSetShape();
                }
                if (didIncrement = this.axialImage.incrementCurrentSlice()) {
                    this.coronalImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.axialImage.getCurrentSlice(), true, false, true);
                    this.sagittalImage.setCrosshairPosition(this.coronalImage.getCurrentSlice(), this.axialImage.getCurrentSlice(), true, false, true);
                    this.toolBox.setMouseLabelInfoIncrement(sliceType, 1);
                }
            } else if (sliceType == 1) {
                if (this.coronalImage.isDragging()) {
                    this.coronalImage.updateSetShape();
                }
                if (didIncrement = this.coronalImage.incrementCurrentSlice()) {
                    this.axialImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.coronalImage.getCurrentSlice(), true, false, true);
                    this.sagittalImage.setCrosshairPosition(this.coronalImage.getCurrentSlice(), this.axialImage.getCurrentSlice(), true, false, true);
                    this.toolBox.setMouseLabelInfoIncrement(sliceType, 1);
                }
            } else if (sliceType == 2) {
                if (this.sagittalImage.isDragging()) {
                    this.sagittalImage.updateSetShape();
                }
                if (didIncrement = this.sagittalImage.incrementCurrentSlice()) {
                    this.axialImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.coronalImage.getCurrentSlice(), true, false, true);
                    this.coronalImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.axialImage.getCurrentSlice(), true, false, true);
                    this.toolBox.setMouseLabelInfoIncrement(sliceType, 1);
                }
            } else if (sliceType == 3 && (didIncrement = this.volume.getCurrentTimepoint() < this.volume.getNumTimepoints() - 1)) {
                this.setCurrentTimepoint(this.volume.getCurrentTimepoint() + 1, this.volume);
                if (this.crosssection.getParentFrame() != null) {
                    this.crosssection.updateCrosssection();
                }
            }
            this.updateSurface();
            this.updateSync();
        }
        this.toolBox.updateMouseLabelInfo();
        return didIncrement;
    }

    public void initializeCurrentROI() {
        this.roiManager.initCurrentROI();
        this.updateROISlices();
    }

    public boolean initializeGroupOverlay() {
        ScreenVolume[] overlays = this.overlayManager.getAllOverlays();
        ScreenVolume current = this.currentScreenVolume;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        int minLUT = 0;
        int maxLUT = 0;
        boolean found = false;
        for (ScreenVolume overlay : overlays) {
            if (overlay == null || overlay != current) continue;
            min = overlay.getScreenMin();
            max = overlay.getScreenMax();
            minLUT = overlay.getLookupTableManager().getMinLUT();
            maxLUT = overlay.getLookupTableManager().getMaxLUT();
            found = true;
        }
        if (!found) {
            for (ScreenVolume overlay : overlays) {
                if (overlay == null) continue;
                min = overlay.getScreenMin();
                max = overlay.getScreenMax();
                minLUT = overlay.getLookupTableManager().getMinLUT();
                maxLUT = overlay.getLookupTableManager().getMaxLUT();
                found = true;
                break;
            }
        }
        if (found) {
            this.setOverlayGroupScreenMin(min);
            this.setOverlayGroupScreenMax(max);
            this.updateOverlayGroupLUT(maxLUT, minLUT);
        }
        this.clearOverlayData();
        this.updateViewer();
        return found;
    }

    @Override
    public boolean isActive() {
        if (Platform.isApplet()) {
            return true;
        }
        return this.frame.isActive();
    }

    public boolean isARGB() {
        return this.volume.isARGB();
    }

    public boolean isCleared() {
        return this.isCleared;
    }

    public boolean isClosing() {
        return this.isClosing;
    }

    public boolean isCoordinateMode() {
        return this.toolBox.getCoordinateType() == 2;
    }

    public boolean isCurrentVolumeOverlay() {
        return this.getCurrentScreenVolume().isOverlay();
    }

    public boolean isCurrentVolumeSeries() {
        return this.getCurrentVolume().getNumTimepoints() > 1;
    }

    public boolean isCurrentVolumeUsingTransform() {
        return this.getCurrentScreenVolume().isUsingTransform();
    }

    public boolean isDead() {
        return this.isDead;
    }

    public boolean isEditingDisabled() {
        return this.isEditingDisabled;
    }

    public boolean isEditingLOI() {
        return this.mainImage.isEditingLOI();
    }

    public boolean isFrameActive() {
        return this.frame.isActive();
    }

    public boolean isHistogramUsingROI() {
        HistogramTool histogramFrame = (HistogramTool)this.histogram.getParentFrame();
        if (histogramFrame != null && histogramFrame.isVisible()) {
            return histogramFrame.isUsingROI();
        }
        return false;
    }

    public boolean isImageLoaded() {
        return this.imageLoaded;
    }

    public boolean isInWorkingState() {
        return this.isNavigationDisabled() || this.isVolumeWillBeReloaded() || this.roiManager.isEditingDisabled() || this.volume.isOperationInProgress() || this.surfaceRender != null && this.surfaceRender.isBuilding();
    }

    public boolean isLOIMode() {
        return (ROIManager.ROI_TYPES.get(this.toolBox.getROIEditMode()) & 0x180) == 384;
    }

    public boolean isMultiSliceMode() {
        return this.toolBox.isVOIMode();
    }

    public boolean isNavigationDisabled() {
        return this.navigationDisabled;
    }

    public boolean isOrthoSliceMode() {
        return this.orthoSliceMode;
    }

    public boolean isOrthoWide() {
        return this.orthoWide;
    }

    public boolean isPOIMode() {
        return (ROIManager.ROI_TYPES.get(this.toolBox.getROIEditMode()) & 0x200) == 512;
    }

    public boolean isRadiologicalMode() {
        return this.mango.isRadiologicalMode();
    }

    public boolean isReady() {
        return this.isViewerInitialized() && this.isImageLoaded() && this.hasVolume() && this.volume.isInitialized();
    }

    public boolean isRetinaDisplay() {
        return Mango.isRetinaDisplayMode() && Platform.isRetinaCapable();
    }

    public boolean isRGB() {
        return this.volume.isRGB();
    }

    public boolean isROIDrawMode() {
        return (ROIManager.ROI_TYPES.get(this.toolBox.getROIEditMode()) & 4) != 0;
    }

    public boolean isROIEllipseMode() {
        return (ROIManager.ROI_TYPES.get(this.toolBox.getROIEditMode()) & 2) != 0;
    }

    public boolean isROIEmpty() {
        return (!this.roiManager.getBuffer().hasBuffer() || this.roiManager.getBuffer().isEmpty()) && !this.loiManagersHaveShapes() && !this.poiManager.hasPoints();
    }

    public boolean isROIMagicWandMode() {
        return (ROIManager.ROI_TYPES.get(this.toolBox.getROIEditMode()) & 0x400) != 0;
    }

    public boolean isROIMagicWandModeCopy() {
        return (ROIManager.ROI_TYPES.get(this.toolBox.getROIEditMode()) & 0x8400) == 33792;
    }

    public boolean isROIMagicWandModeDelete() {
        return (ROIManager.ROI_TYPES.get(this.toolBox.getROIEditMode()) & 0xC00) == 3072;
    }

    public boolean isROIMagicWandModeDilate() {
        return (ROIManager.ROI_TYPES.get(this.toolBox.getROIEditMode()) & 0x4400) == 17408;
    }

    public boolean isROIMagicWandModeErode() {
        return (ROIManager.ROI_TYPES.get(this.toolBox.getROIEditMode()) & 0x2400) == 9216;
    }

    public boolean isROIMagicWandModePreserve() {
        return (ROIManager.ROI_TYPES.get(this.toolBox.getROIEditMode()) & 0x1400) == 5120;
    }

    public boolean isROIMode() {
        return ROIManager.ROI_TYPES.get(this.toolBox.getROIEditMode()) != 0;
    }

    public boolean isROIPolyLineMode() {
        return (ROIManager.ROI_TYPES.get(this.toolBox.getROIEditMode()) & 0x80) == 128;
    }

    public boolean isROIRealShapeMode() {
        return (ROIManager.ROI_TYPES.get(this.toolBox.getROIEditMode()) & 0x40) != 0;
    }

    public boolean isROIToolMode() {
        int currentTool = ROIManager.ROI_TYPES.get(this.toolBox.getROIEditMode());
        if ((currentTool & 0x10) != 0) {
            return true;
        }
        if ((currentTool & 8) != 0) {
            return true;
        }
        return (currentTool & 0x20) != 0;
    }

    public boolean isScrollwheelDirectionFlip() {
        return this.scrollwheelDirectionFlip;
    }

    public boolean isScrollwheelSlices() {
        return this.scrollwheelSlices;
    }

    public boolean isSelected(ScreenSlice image, int sliceNum, int sliceDirection, int roiNum) {
        if (this.toolBox.isVOIMode() && this.roiManager.isSelected(roiNum)) {
            return true;
        }
        return !this.toolBox.isVOIMode() && image == this.mainImage && this.roiManager.isSelected(roiNum, sliceNum, sliceDirection);
    }

    public boolean isShowingAllOverlay() {
        return this.showAllOverlay;
    }

    public boolean isShowingAngle() {
        return this.showLineAngle;
    }

    public boolean isShowingCrosssection() {
        return this.crosssection.getParentFrame() != null;
    }

    public boolean isShowingCurrentOverlay() {
        return this.showCurrentOverlay;
    }

    public boolean isShowingDicomOverlay() {
        return this.showDicomOverlay;
    }

    public boolean isShowingLabels() {
        return this.showLabels;
    }

    public boolean isShowingLowerCrosshairs() {
        return this.showLowerCrosshairs;
    }

    public boolean isShowingMainCrosshairs() {
        return this.showMainCrosshairs;
    }

    public boolean isShowingOrientation() {
        return this.showOrientation;
    }

    @Override
    public boolean isShowingROI() {
        return !this.hideROI && (this.showROIEdge || this.showROIMask);
    }

    public boolean isShowingROIEdge() {
        return this.showROIEdge;
    }

    public boolean isShowingROIMask() {
        return this.showROIMask;
    }

    public boolean isShowingROIStats() {
        return this.showROISliceStats;
    }

    public boolean isShowingRuler() {
        return this.showLineLength;
    }

    public boolean isSingleSliceMode() {
        return this.singleSliceMode;
    }

    public boolean isSpecialNavFunctionPrimed() {
        return this.specialNavFunctionPrimed;
    }

    public boolean isStopPainting() {
        return this.stopPainting;
    }

    public boolean isTempImage() {
        return this.isTempImage;
    }

    public boolean isUpdatingPolyline() {
        return this.mainImage.isUpdatingPolyline();
    }

    public boolean isUsingTransform() {
        return this.baseScreenVolume.isUsingTransform();
    }

    public boolean isViewerHideROI() {
        return this.hideROI;
    }

    public boolean isViewerInitialized() {
        return this.viewerInitialized;
    }

    public boolean isVolumeDisplayHidden(ImageVolume volume) {
        return this.findVolume(volume).isHidden();
    }

    public boolean isVolumeDisplayNegative(ImageVolume volume) {
        return this.findVolume(volume).isNegative();
    }

    public boolean isVolumeOverlay(ImageVolume volume) {
        return this.baseScreenVolume.getVolume() != volume;
    }

    public boolean isVolumeUsingTransform(ImageVolume volume) {
        if (this.baseScreenVolume.getVolume() == volume) {
            return this.baseScreenVolume.isUsingTransform();
        }
        if (this.overlayManager.getIndex((Volume)volume) != -1) {
            return this.overlayManager.getOverlay((Volume)volume).isUsingTransform();
        }
        return false;
    }

    public boolean isVolumeWillBeReloaded() {
        return this.volumeWillBeReloaded;
    }

    public boolean isVoxelDisplayMode() {
        return this.voxelDisplayMode;
    }

    public boolean isWorldMode() {
        return this.toolBox.isWorldMode();
    }

    public boolean isZooming() {
        return this.zoomFactor > 1.0;
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        int keyCode = ke.getKeyCode();
        char keyChar = ke.getKeyChar();
        if (this.toolBox.isTextFieldMinTouched()) {
            if (keyCode == 10) {
                this.toolBox.updateTextFieldValues();
            } else if (keyCode == 8 || keyCode == 127) {
                this.toolBox.deleteTextFieldMinText();
            } else if (keyCode == 37) {
                this.toolBox.moveTextFieldMinCursor(true);
            } else if (keyCode == 39) {
                this.toolBox.moveTextFieldMinCursor(false);
            } else if (Character.isLetterOrDigit(keyChar) || keyChar == '.' || keyChar == '-') {
                this.toolBox.addTextFieldMinText(String.valueOf(ke.getKeyChar()));
            }
            ke.consume();
        } else if (this.toolBox.isTextFieldMaxTouched()) {
            if (keyCode == 10) {
                this.toolBox.updateTextFieldValues();
            } else if (keyCode == 8 || keyCode == 127) {
                this.toolBox.deleteTextFieldMaxText();
            } else if (keyCode == 37) {
                this.toolBox.moveTextFieldMaxCursor(true);
            } else if (keyCode == 39) {
                this.toolBox.moveTextFieldMaxCursor(false);
            } else if (Character.isLetterOrDigit(keyChar) || keyChar == '.' || keyChar == '-') {
                this.toolBox.addTextFieldMaxText(String.valueOf(ke.getKeyChar()));
            }
            ke.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if (this.toolBox.isTextFieldMinTouched()) {
            ke.consume();
        } else if (this.toolBox.isTextFieldMaxTouched()) {
            ke.consume();
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void labelChanged() {
        this.setShowLabels(true);
        this.updateViewer();
        this.updateWindowTitle();
        this.updateFrameMenu();
        if (this.roiInspector != null && this.roiInspector.isVisible()) {
            this.roiInspector.updateLabels();
        }
    }

    public void loadImage(final URI uri, final Header header, final DICOM[] dicoms, final URI[] dicomFiles, final ByteBuffer[] buffers, final ImageCalcExpression op, final Volume copyVol, final ImageBounds copyBounds) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.doLoadImage(uri, header, dicoms, dicomFiles, buffers, op, copyVol, copyBounds, false);
            }
        }, "OrthogonalViewer.loadImage() Thread");
        workThread.start();
    }

    public void loadOverlay(final URI uri, final String lutName, final boolean isParametric) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.doLoadOverlay(uri, lutName, isParametric, false);
            }
        }, "OrthogonalViewer.loadOverlay() Thread");
        workThread.start();
    }

    protected void applyImageOptions(String name, ScreenVolume sv) {
    }

    public void loadOverlayScreenVolume(Volume overlayVolume, URI file, String lutNameVal, SliceViewer viwerToClose, boolean isParametric, boolean isNegative) {
        String lutName = lutNameVal;
        overlayVolume.addListener(this);
        overlayVolume.setProgressBarListener(this.toolBox);
        if (isParametric) {
            lutName = isNegative ? "Overlay (Negatives)" : "Overlay (Positives)";
        }
        ScreenVolume overlay = new ScreenVolume(overlayVolume, file, lutName, false);
        this.applyImageOptions(FileUtilities.getName((URI)file), overlay);
        overlay.setParametricState(isParametric);
        overlay.setNegativeState(isNegative);
        overlay.setViewerToClose(viwerToClose);
        this.initializeOverlay(overlay);
    }

    public void loadROI(String openLocation) {
        this.loadROI(new File(openLocation).toURI(), true);
    }

    public void loadROI(URI externalROIFile, boolean sameThread) {
        this.recordAction("loadROI", new String[]{ScriptUtils.convertString(new File(externalROIFile).toString())}, true);
        try {
            this.setViewerHideROI(false);
            String roiFilename = FileUtilities.getName((URI)externalROIFile);
            if (roiFilename.endsWith(".roi.gz")) {
                this.readOldROIFormat(externalROIFile, sameThread);
            } else {
                Header roiHeader = new Header(externalROIFile);
                ImageDimensions id = roiHeader.getImageDimensions();
                new Orientation(roiHeader.getOrientationString(), id, roiHeader.getVoxelDimensions(), roiHeader.getOrigin());
                int xDim = id.getX();
                int yDim = id.getY();
                int zDim = id.getZ();
                boolean sameDims = xDim == this.getXDim() && yDim == this.getYDim() && zDim == this.getZDim();
                ImageType it = roiHeader.getImageType();
                int datatype = it.getByteType();
                boolean isMangoROIFile = false;
                String description = roiHeader.getImageDescription().getDescription();
                if (description != null) {
                    isMangoROIFile = description.startsWith("Mango ROI");
                }
                boolean loadAsMangoROI = isMangoROIFile &= datatype == 3;
                if (loadAsMangoROI &= sameDims) {
                    this.loadMangoROI(externalROIFile, sameThread);
                } else {
                    this.importROI(externalROIFile, false, isMangoROIFile, sameThread);
                }
            }
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    @Override
    public void loadROICompleted(Volume loadVolume, final Coordinate firstCoordFound, String metadata, boolean roiManagerWasEmpty, boolean singleColor, boolean sameThread) {
        boolean poiManagerEmpty;
        if (loadVolume != null) {
            loadVolume.clearImage();
        }
        boolean loiManagerAxialEmpty = !this.loiManagerAxial.hasShapes();
        boolean loiManagerCoronalEmpty = !this.loiManagerCoronal.hasShapes();
        boolean loiManagerSagittalEmpty = !this.loiManagerSagittal.hasShapes();
        boolean bl = poiManagerEmpty = !this.poiManager.hasPoints();
        if (StringUtils.isNotBlank((CharSequence)metadata)) {
            try {
                Metadata.readMetadata(this, singleColor, metadata);
            }
            catch (ParserConfigurationException e) {
                AppLogger.error((Throwable)e);
            }
            catch (SAXException e) {
                AppLogger.error((Throwable)e);
            }
            catch (IOException e) {
                AppLogger.error((Throwable)e);
            }
        }
        if (this.roiManager.hasLabels() || this.loiManagerAxial.hasLabels() || this.loiManagerCoronal.hasLabels() || this.loiManagerSagittal.hasLabels() || this.poiManager.hasLabels()) {
            this.labelChanged();
        }
        if (roiManagerWasEmpty) {
            this.roiManager.setDirty(false);
        }
        if (loiManagerAxialEmpty) {
            this.loiManagerAxial.setDirty(false);
        }
        if (loiManagerCoronalEmpty) {
            this.loiManagerCoronal.setDirty(false);
        }
        if (loiManagerSagittalEmpty) {
            this.loiManagerSagittal.setDirty(false);
        }
        if (poiManagerEmpty) {
            this.poiManager.setDirty(false);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (firstCoordFound != null && !firstCoordFound.isAllZeros()) {
                    SliceViewer.this.setCurrentCoordinate(firstCoordFound, true, 0);
                    if (firstCoordFound instanceof Coordinate4D) {
                        int timepoint = ((Coordinate4D)firstCoordFound).seriesPoint;
                        SliceViewer.this.setCurrentTimepoint(timepoint);
                    }
                }
                if (SliceViewer.this.timeseries.getParentFrame() != null && SliceViewer.this.roiManager.getNumUsed() == 1) {
                    SliceViewer.this.roiManager.selectAll();
                    ((TimeseriesTool)SliceViewer.this.timeseries.getParentFrame()).roiChanged(SliceViewer.this.roiManager.getROI(SliceViewer.this.roiManager.getHighestUsedIndex()));
                }
                SliceViewer.this.updateWindowTitle();
                SliceViewer.this.updateFrameMenu();
            }
        };
        SwingWidgetUtilities.invokeLaterSafely((Runnable)runnable);
    }

    public void loadROIURL(String url, boolean forceImport, boolean forceWorld) {
        try {
            URI uri = new URL(url).toURI();
            if (forceImport) {
                this.importROI(uri, forceWorld);
            } else {
                this.loadROI(uri, false);
            }
        }
        catch (URISyntaxException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (MalformedURLException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    public SurfaceManager loadSurface(String openLocation) {
        SurfaceReader sr = new SurfaceReader();
        SurfaceIOListener listener = new SurfaceIOListener(){

            @Override
            public void surfaceFileRead(boolean success, Surface[] surfaces, Vector<Shape> shapes, String message) {
                SliceViewer.this.buildSurface(surfaces, shapes);
            }

            @Override
            public void surfaceFileWritten(boolean success, File file, String message) {
            }
        };
        sr.doReadFile(new File(openLocation), this, listener, true, null);
        return this.surfaceRender;
    }

    @Override
    public void logicalCalculationFinished(AnalysisImpl stat) {
        this.mango.getResultsManager().addStatistic(this, this.getVolume(), stat);
    }

    public void logToConsole(String message) {
        AppLogger.info((String)message);
    }

    public int lookupDefaultBlue(int index) {
        return LookupTableManager.DEFAULT_LUT.lookupBlue(index);
    }

    public int lookupDefaultGreen(int index) {
        return LookupTableManager.DEFAULT_LUT.lookupGreen(index);
    }

    public int lookupDefaultRed(int index) {
        return LookupTableManager.DEFAULT_LUT.lookupRed(index);
    }

    public String makeFilename(String ext) {
        URI uri = this.getLoadedURI();
        File outputFile = null;
        int index = 1;
        do {
            String suffix = "";
            if (index > 1) {
                suffix = String.valueOf(index);
            }
            if (FileUtilities.uriIsFile((URI)uri)) {
                File file = new File(uri);
                if (StringUtils.isBlank((CharSequence)ext)) {
                    outputFile = file.getParentFile();
                } else {
                    File dir = file.getParentFile();
                    String filename = FileUtilities.removeExtension((String)file.getName());
                    filename = filename + suffix;
                    filename = filename + ext;
                    outputFile = new File(dir, filename);
                }
            } else {
                File dir = Platform.getDesktopDir();
                String filename = FileUtilities.removeExtension((String)FileUtilities.getName((URI)uri));
                filename = filename + suffix;
                filename = filename + ext;
                outputFile = new File(dir, filename);
            }
            ++index;
        } while (outputFile.exists() || outputFile.isDirectory());
        return outputFile.toString();
    }

    public ImageVolume makeNewVolume() {
        return new Volume();
    }

    public BufferedImage makePluginOverlay(int sliceDirection) {
        BufferedImage bi = null;
        if (sliceDirection == 0) {
            bi = this.axialImage.addPluginOverlay();
        } else if (sliceDirection == 1) {
            bi = this.coronalImage.addPluginOverlay();
        } else if (sliceDirection == 2) {
            bi = this.sagittalImage.addPluginOverlay();
        }
        return bi;
    }

    public ProgressMeter makeProgressMeter() {
        return new edu.uthscsa.ric.mango.components.progressbar.ProgressBar(this.toolBox, "");
    }

    @Deprecated
    public ProgressMeter makeProgressMeter(String text) {
        return new ProgressBar(this.toolBox, text);
    }

    public void makeSeriesStatImage() {
        TimeseriesStatsDialog dialog = new TimeseriesStatsDialog(this.volume);
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.getViewerFrame(), (Object)dialog, "Make Statistical Image from Series", -1);
        int selection = jopf.show();
        if (selection == 0) {
            int start = 0;
            int end = 0;
            int group = 0;
            try {
                start = Integer.parseInt(dialog.getStart());
            }
            catch (NumberFormatException ex) {
                AppLogger.info((Throwable)ex);
                return;
            }
            try {
                end = Integer.parseInt(dialog.getEnd());
            }
            catch (NumberFormatException ex) {
                AppLogger.info((Throwable)ex);
                return;
            }
            try {
                group = Integer.parseInt(dialog.getGroup());
            }
            catch (NumberFormatException ex) {
                AppLogger.info((Throwable)ex);
                return;
            }
            if (start <= 0) {
                start = 1;
            }
            if (end > this.volume.getNumTimepoints()) {
                end = this.volume.getNumTimepoints();
            }
            --start;
            --end;
            int seriesType = -1;
            boolean isSum = dialog.isSum();
            boolean isMean = dialog.isMean();
            boolean isMax = dialog.isMax();
            boolean isMin = dialog.isMin();
            boolean isStdev = dialog.isStdev();
            if (isSum) {
                seriesType = 0;
            } else if (isMean) {
                seriesType = 1;
            } else if (isMax) {
                seriesType = 2;
            } else if (isMin) {
                seriesType = 3;
            } else if (isStdev) {
                seriesType = 4;
            }
            this.recordAction("runOperationSeriesStatistic", new String[]{String.valueOf(start), String.valueOf(end), String.valueOf(group), String.valueOf(seriesType)}, true);
            this.mango.addViewer(new ImageCalcExpressionImpl(this, start, end, group, seriesType), true);
        }
    }

    public void moveToCenter() {
        this.recordAction("setCurrentPosition", new String[]{this.getScriptObjectName() + ".baseVolume.center"});
        this.setCurrentCoordinate(new Coordinate((double)((int)Math.floor((double)this.volume.getXDim() / 2.0)), (double)((int)Math.floor((double)this.volume.getYDim() / 2.0)), (double)((int)Math.floor((double)this.volume.getZDim() / 2.0))), true, -1);
        this.updateSync();
        this.updateWindowTitle();
        this.toolBox.updateMouseLabelOutOfBounds();
        this.updateSurface();
    }

    public void moveToOrigin() {
        this.recordAction("setCurrentPosition", new String[]{this.getScriptObjectName() + ".baseVolume.origin"});
        this.setCurrentCoordinate(this.baseScreenVolume.getOrigin(), true, -1);
        this.updateSync();
        this.updateWindowTitle();
        this.toolBox.updateMouseLabelOutOfBounds();
        this.updateSurface();
    }

    public void notifyOverlayListenersOfChange() {
        ScreenVolume[] overlays;
        for (ScreenVolume overlay : overlays = this.overlayManager.getAllOverlays()) {
            if (overlay == null) continue;
            overlay.notifyListenersOfChange(false);
        }
    }

    @Override
    public void operationFinished(final Object result, final ImageVolume volume) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (result == null) {
                    SliceViewer.this.volumeChanged();
                    SliceViewer.this.volumeOperationCompleted(true, SliceViewer.this.getBaseVolume());
                    SliceViewer.this.updateViewer();
                } else if (result instanceof Analysis) {
                    SliceViewer.this.mango.getResultsManager().addStatistic(SliceViewer.this, (Volume)volume, (AnalysisImpl)result);
                } else if (result instanceof List) {
                    List list = (List)result;
                    if (list.get(0) instanceof AnalysisImpl) {
                        SliceViewer.this.mango.getResultsManager().addStatistic(SliceViewer.this, (Volume)volume, list);
                    }
                } else if (result instanceof Map) {
                    ArrayList<AnalysisImpl> list = new ArrayList<AnalysisImpl>(((Map)result).values());
                    SliceViewer.this.mango.getResultsManager().addStatistic(SliceViewer.this, (Volume)volume, list);
                }
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public boolean overlayCanBeSaved() {
        ScreenVolume[] screenVolumes;
        for (ScreenVolume screenVolume : screenVolumes = this.overlayManager.getAllOverlays()) {
            if (screenVolume == null) continue;
            Volume volume = screenVolume.getVolume();
            if (!FileUtilities.uriIsFile((URI)screenVolume.getURI())) continue;
            File volumeFile = new File(screenVolume.getURI());
            if (!volume.isDirty() || volume.cannotBeOverwritten() || !volume.isWritable(volumeFile)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.stopPainting) {
            return;
        }
        super.paintComponent(g);
    }

    public boolean passesClusterRejection(int overlayIndex, int xLoc, int yLoc, int slice, int sliceDirection) {
        if (this.clusterAnalysis != null) {
            if (sliceDirection == 0) {
                return this.clusterAnalysis.isVoxelValid(xLoc, yLoc, slice, overlayIndex);
            }
            if (sliceDirection == 1) {
                return this.clusterAnalysis.isVoxelValid(xLoc, slice, yLoc, overlayIndex);
            }
            return this.clusterAnalysis.isVoxelValid(slice, xLoc, yLoc, overlayIndex);
        }
        return true;
    }

    @Override
    public void pasteCompleted(boolean success, String message) {
        if (!this.toolBox.isVOIMode()) {
            this.roiManager.setSelectedSlice(this.getMainSliceNumber(), this.getMainSliceDirection());
        }
        this.roiManager.setDirty(true);
        this.updateROISlices();
        this.repaint();
    }

    public synchronized void pauseScriptForUserInput() {
        if (this.mango.isPlayingScript()) {
            this.scriptWaiting = true;
            this.mango.getToolBox().pauseScriptThread();
            while (this.scriptWaiting) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    AppLogger.error((Throwable)ex);
                }
            }
        }
    }

    public void pluginOperationCompleted() {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!SliceViewer.this.isCleared()) {
                    SliceViewer.this.updateViewer();
                }
            }
        });
    }

    @Override
    public void pointAdded(POI point) {
        this.pointAdded(point, true);
    }

    @Override
    public void pointChanged(POI point) {
    }

    @Override
    public void pointChangingStopped(POI point) {
        if (this.timeseries.getParentFrame() != null) {
            ((TimeseriesTool)this.timeseries.getParentFrame()).roiChanged(point);
        }
        if (this.surfaceRender != null && this.surfaceRender.isSyncingShapes()) {
            this.surfaceRender.updateROIPoint(point);
        }
    }

    @Override
    public void pointDeleted(POI point) {
        this.pointDeleted(point, true);
    }

    @Override
    public void pointLabelChanged(POI point) {
        if (this.roiInspector != null && this.roiInspector.isVisible()) {
            this.roiInspector.updateLabels();
        }
    }

    @Override
    public void pointSelectionChanged() {
        if (this.timeseries.getParentFrame() != null) {
            ((TimeseriesTool)this.timeseries.getParentFrame()).selectionChanged();
        }
    }

    public void quickROIColorKeyPressed() {
        if (!this.mainImage.isDragging() && !this.mainImage.isPressed()) {
            this.roiManager.selectNextUsedROIColor();
            this.toolBox.updateCurrentState();
            this.updateViewer();
        }
    }

    public void quickROIToolKeyPressed(boolean shiftDown) {
        if (!this.mainImage.isDragging() && !this.mainImage.isPressed()) {
            if (shiftDown) {
                this.toolBox.setROIEditMode(this.mango.getNextRecentTool());
            } else if (this.toolBox.getROIEditMode() == this.mango.getQuickKeyFirst()) {
                this.toolBox.setROIEditMode(this.mango.getQuickKeySecond());
                this.mango.setRecentTool(this.mango.getQuickKeySecond());
            } else {
                this.toolBox.setROIEditMode(this.mango.getQuickKeyFirst());
                this.mango.setRecentTool(this.mango.getQuickKeyFirst());
            }
            this.mango.clearActivePolylines();
            this.mainImage.updateStructureElement();
            this.mainImage.updateCursor();
            this.repaint();
        }
    }

    public void quickROIVisibleKeyPressed() {
        this.setViewerHideROI(!this.isViewerHideROI());
        this.updateViewer();
        this.updateSurface();
    }

    public void quickThresholdKeyPressed(boolean shiftDown) {
        if (shiftDown) {
            if (this.isMultiSliceMode() && this.hasSelectedROIs()) {
                this.doFillInsideROI();
            } else if (!this.isMultiSliceMode() && this.hasSelectedROIInCurrentSlice()) {
                this.doFillInsideROI();
            }
        } else if (this.isMultiSliceMode() && this.hasSelectedROIs()) {
            this.doFillOutsideROI();
        } else if (!this.isMultiSliceMode() && this.hasSelectedROIInCurrentSlice()) {
            this.doFillOutsideROI();
        }
    }

    public void readSurface(File file) {
        SurfaceReader sr = new SurfaceReader();
        sr.readFile(file, this, this, true);
    }

    @Override
    public void recordAction(String name) {
        this.recordAction(name, null);
    }

    @Override
    public void recordAction(String name, String[] argValues) {
        this.recordAction(name, argValues, false, this);
    }

    @Override
    public void recordAction(String name, String[] argValues, boolean forceNeedsUserInput) {
        this.recordAction(name, argValues, forceNeedsUserInput, this);
    }

    @Override
    public void recordAction(String name, String[] argValues, boolean forceNeedsUserInput, Recordable recordable) {
        if (this.viewerInitialized) {
            this.mango.recordAction(name, argValues, forceNeedsUserInput, recordable);
        }
    }

    public void recordPluginAction(String pluginName, String ... args) {
        this.recordAction("runPlugin", new String[]{ScriptUtils.convertString(pluginName), ScriptUtils.convertArray(args)});
    }

    public void reload() {
        this.reloadImage(this.getLoadedURI(), null);
    }

    public void reloadImage() {
        this.volumeWillBeReloaded = true;
        this.recordAction("reload");
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.startIndeterminateProgressBar();
                SliceViewer.this.reloadImage(SliceViewer.this.getLoadedURI(), null);
                SliceViewer.this.endIndeterminateProgressBar();
            }
        }, "BasicViewer.reloadImage() Thread");
        workThread.start();
    }

    public void removeAllOverlays() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.doRemoveAllOverlays();
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCurrentVolumeListener(CurrentVolumeListener listener) {
        List<CurrentVolumeListener> list = this.currentVolumeListeners;
        synchronized (list) {
            this.currentVolumeListeners.remove(listener);
        }
    }

    public void removeLineFromSurface(LOIShape loi) {
        if (loi == null) {
            return;
        }
        if (loi.getSliceDirection() == 0) {
            this.loiManagerAxial.removeLOI(loi, false);
        } else if (loi.getSliceDirection() == 1) {
            this.loiManagerCoronal.removeLOI(loi, false);
        } else {
            this.loiManagerSagittal.removeLOI(loi, false);
        }
        this.shapeDeleted(loi, false);
    }

    public void removeListener(ViewerListener aListener) {
        this.listeners.remove(aListener);
    }

    public void removeMouseListener(MouseListener ml, int sliceDir) {
        if (sliceDir == 0) {
            this.axialImage.removeMouseListener(ml);
        } else if (sliceDir == 1) {
            this.coronalImage.removeMouseListener(ml);
        } else if (sliceDir == 2) {
            this.sagittalImage.removeMouseListener(ml);
        }
    }

    public void removeMouseMotionListener(MouseMotionListener ml, int sliceDir) {
        if (sliceDir == 0) {
            this.axialImage.removeMouseMotionListener(ml);
        } else if (sliceDir == 1) {
            this.coronalImage.removeMouseMotionListener(ml);
        } else if (sliceDir == 2) {
            this.sagittalImage.removeMouseMotionListener(ml);
        }
    }

    public void removeOverlay(final ImageVolume volume) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ScreenVolume screenVol = SliceViewer.this.findOverlay((Volume)volume);
                if (screenVol != null) {
                    SliceViewer.this.removeOverlay(screenVol);
                    SliceViewer.this.mango.getToolBox().updateAfterRemoveVolume();
                    SliceViewer.this.clearOverlayData();
                    SliceViewer.this.updateViewer();
                    SliceViewer.this.mango.getToolBox().updateSurfaceTextures();
                }
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void removeOverlay(int overlayIndex) {
        this.removeOverlay(this.overlayManager.getOverlay(overlayIndex));
    }

    @Deprecated
    public void removePluginOverlays() {
        AppLogger.warn((String)"removePluginOverlay() is deprecated");
    }

    public void removePluginOverlay(BufferedImage pluginOverlay, int sliceDirection) {
        if (sliceDirection == 0) {
            this.axialImage.removePluginOverlay(pluginOverlay);
        } else if (sliceDirection == 1) {
            this.coronalImage.removePluginOverlay(pluginOverlay);
        } else if (sliceDirection == 2) {
            this.sagittalImage.removePluginOverlay(pluginOverlay);
        }
    }

    public void removePointFromSurface(POI poi) {
        this.poiManager.removePOI(poi, true, false);
        this.pointDeleted(poi, false);
    }

    public void removeSliceDirectionListener(SliceDirectionListener sliceDirectionListener) {
        WeakReference<SliceDirectionListener> found = null;
        for (WeakReference<SliceDirectionListener> wf : this.sliceDirectionListeners) {
            SliceDirectionListener sdl = (SliceDirectionListener)wf.get();
            if (sdl != sliceDirectionListener) continue;
            found = wf;
            break;
        }
        if (found != null) {
            this.sliceDirectionListeners.remove(found);
        }
    }

    public void removeSliceListener(SliceListener sl, int sliceDirection) {
        if (sliceDirection == 0) {
            this.axialImage.removeSliceListener(sl);
        } else if (sliceDirection == 1) {
            this.coronalImage.removeSliceListener(sl);
        } else if (sliceDirection == 2) {
            this.sagittalImage.removeSliceListener(sl);
        }
    }

    public void removeTopOverlay() {
        int index = this.overlayManager.getNumInStack() - 1;
        if (index >= 0) {
            this.removeOverlay(index);
        }
    }

    public void reorderSurfaceOverlays() {
        if (this.surfaceRender != null && this.surfaceRender.isInitialized() && this.surfaceRender.isVisible() && this.surfaceRender.isFrameVisible()) {
            this.surfaceRender.reorderSurfaceOverlays();
        }
    }

    @Override
    public void resetAllClipboardsUndo() {
        this.roiManager.resetClipboards();
        this.loiManagerAxial.resetClipboards();
        this.loiManagerCoronal.resetClipboards();
        this.loiManagerSagittal.resetClipboards();
        this.poiManager.resetClipboards();
    }

    public boolean roiCanBeSaved(boolean saveAs) {
        if (this.roiManager != null && (saveAs || this.roiFileGZIP != null) && (this.roiManager.isDirty() || this.hasDirtyLOIManager() || this.poiManager.isDirty())) {
            return true;
        }
        return saveAs && this.canWriteROIFile();
    }

    @Override
    public void roiHasChanged(final ROI roi, String message, final long changedMask, final int changedSlice) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.updateScreenSlices();
                SliceViewer.this.updateFrameMenu();
                SliceViewer.this.updateROISlices();
                SliceViewer.this.repaint();
                if (SliceViewer.this.surfaceRender != null && changedSlice != -2) {
                    if (changedSlice == -1 || Long.bitCount(changedMask) > 1) {
                        SliceViewer.this.surfaceRender.updateROIShape(changedMask, -1, SliceViewer.this.getMainSliceDirection());
                    } else {
                        SliceViewer.this.surfaceRender.updateROIShape(changedMask, changedSlice, SliceViewer.this.getMainSliceDirection());
                    }
                }
                if (SliceViewer.this.timeseries.getParentFrame() != null) {
                    ((TimeseriesTool)SliceViewer.this.timeseries.getParentFrame()).roiChanged(roi);
                }
                if (SliceViewer.this.imageCalc != null && SliceViewer.this.imageCalc.getFrame().isVisible()) {
                    SliceViewer.this.imageCalc.updateROIOptions();
                }
                if (SliceViewer.this.roiInspector != null && SliceViewer.this.roiInspector.isVisible()) {
                    SliceViewer.this.roiInspector.updateCounts();
                }
                if (!(SliceViewer.this.roiManager.getUsedMask() != 0L || SliceViewer.this.roiFileGZIP != null && SliceViewer.this.roiFileGZIP.exists())) {
                    SliceViewer.this.roiManager.setDirty(false);
                    SliceViewer.this.updateWindowTitle();
                }
                SliceViewer.this.updateSelectedBoundsAndHandles();
            }
        };
        SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
    }

    @Override
    public void roiSaved(final boolean success, final File file) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.roiManagerWillBeSaved = false;
                if (success) {
                    SliceViewer.this.roiManager.setAsSaved();
                    SliceViewer.this.loiManagerAxial.setDirty(false);
                    SliceViewer.this.loiManagerCoronal.setDirty(false);
                    SliceViewer.this.loiManagerSagittal.setDirty(false);
                    SliceViewer.this.poiManager.setDirty(false);
                    SliceViewer.this.updateWindowTitle();
                    SliceViewer.this.updateFrameMenu();
                    if (SliceViewer.this.closeOnSave) {
                        SliceViewer.this.cleanUp();
                    }
                } else {
                    SliceViewer.this.setClosing(false);
                    SliceViewer.this.mango.clearIsExiting();
                }
                SliceViewer.this.mango.updateImageBrowser(file);
            }
        };
        SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
    }

    @Override
    public void roiSelectionHasChanged() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (SliceViewer.this.timeseries.getParentFrame() != null) {
                    ((TimeseriesTool)SliceViewer.this.timeseries.getParentFrame()).selectionChanged();
                }
                if (SliceViewer.this.imageCalc != null && SliceViewer.this.imageCalc.getFrame().isVisible()) {
                    SliceViewer.this.imageCalc.updateROIOptions();
                }
                SliceViewer.this.updateScreenSlices();
                SliceViewer.this.updateFrameMenu();
                SliceViewer.this.updateROISlices();
                SliceViewer.this.repaint();
            }
        };
        SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
    }

    @Override
    public void roiSeriesStatusChanged() {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.updateFrameMenu();
            }
        });
    }

    public void runAddROI(Coordinate coor, double size, boolean sphere) {
        int sizeX = (int)Math.round(size / this.volume.getXSize());
        int sizeY = (int)Math.round(size / this.volume.getYSize());
        int sizeZ = (int)Math.round(size / this.volume.getZSize());
        this.roiManager.runAddShape(coor, sizeX, sizeY, sizeZ, size, !sphere, sphere);
    }

    public void runAddROISlice(int sliceDirection, Coordinate coor, double size, boolean circle) {
        int sizeX = (int)Math.round(size / this.volume.getXSize());
        int sizeY = (int)Math.round(size / this.volume.getYSize());
        int sizeZ = (int)Math.round(size / this.volume.getZSize());
        this.roiManager.addShape2D(coor, sliceDirection, sizeX, sizeY, sizeZ, size, !circle, circle);
    }

    public List<Analysis> runAllSliceStats(int sliceDirection) {
        SliceStatOp op = new SliceStatOp(this, this.getCurrentVolume());
        return op.calculateAllSliceStatsSync(sliceDirection, this);
    }

    public List<Analysis> runAllSliceStatsROI(int sliceDirection, long roiMask, boolean includePointsAndLines, boolean onlySelectedPoints, boolean onlySelectedLines) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        if (includePointsAndLines) {
            stats.addAll(this.runAllSliceStatsROIPoints(sliceDirection, onlySelectedPoints));
            stats.addAll(this.runAllSliceStatsROILines(sliceDirection, onlySelectedLines));
        }
        if (this.hasSelectedROIs()) {
            SliceStatROIOp op = new SliceStatROIOp(this, this.getCurrentVolume(), this.roiManager.getBuffer(), roiMask, this.roiManager);
            stats.addAll(op.calculateAllSliceStatsSync(sliceDirection, this));
        }
        return stats;
    }

    public List<Analysis> runAllVolumeStats() {
        VolumeStatOp op = new VolumeStatOp(this, this.getCurrentVolume());
        return op.calculateAllVolumesStatsSync(this);
    }

    public List<Analysis> runAllVolumeStatsROI(long roiMask, boolean includePointsAndLines, boolean onlySelectedPoints, boolean onlySelectedLines) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        if (includePointsAndLines) {
            stats.addAll(this.runAllVolumeStatsROIPoints(onlySelectedPoints));
            stats.addAll(this.runAllVolumeStatsROILines(onlySelectedLines));
        }
        if (this.hasSelectedROIs()) {
            VolumeStatROIOp op = new VolumeStatROIOp(this, this.getCurrentVolume(), this.roiManager.getBuffer(), roiMask, this.roiManager);
            stats.addAll(op.calculateAllVolumesStatsSync(this));
        }
        return stats;
    }

    public void runCloseROI(long roiMask, int kernel) {
        this.roiManager.runClose3D(kernel, roiMask);
    }

    public void runCloseROISlice(int sliceDirection, int sliceNum, long roiMask, int kernel) {
        this.roiManager.runClose2D(sliceNum, sliceDirection, kernel, roiMask);
    }

    public List<Cluster> runClusterAnalysis(ImageVolume volume, double threshold) {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        ScreenVolume overlay = this.findOverlay((Volume)volume);
        if (overlay != null) {
            ClusterOperations.findCluster(this, overlay, threshold);
            Vector<ClusterStat> stats = ClusterOperations.analyzeClusters(this, overlay.getVolume(), overlay.getClusterData());
            for (ClusterStat stat : stats) {
                clusters.add(new ClusterImpl(stat.makeAnalysis(overlay), overlay.getVolume()));
            }
            ClusterAnalysisPanel.printClusters(this, overlay, stats.size(), stats);
        }
        return clusters;
    }

    public List<Cluster> runComponentAnalysisROI(int roiColor) {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        ScreenVolume overlay = this.getCurrentScreenVolume();
        ClusterOperations.findClusterROI(this, roiColor);
        Vector<ClusterStat> stats = ClusterOperations.analyzeClusters(this, overlay.getVolume(), this.roiManager.getClusterData(roiColor));
        for (ClusterStat stat : stats) {
            clusters.add(new ClusterImpl(stat.makeAnalysis(overlay), overlay.getVolume()));
        }
        ClusterROIAnalysisPanel.printClusters(this, overlay, stats.size(), roiColor, stats);
        return clusters;
    }

    public void runComponentSplitROI(int roiColorIndex, int numberOfVoxelsThreshold) {
        String label = (this.roiManager.getLabel(roiColorIndex, "") + " " + "Cluster").trim();
        ClusterOperations.makeROIOfCluster(this.roiManager, this.roiManager.getClusterData(roiColorIndex), numberOfVoxelsThreshold, AbstractROIBuffer.getMasks()[roiColorIndex], label);
    }

    public void runConvexHull(ROI roi) {
        this.doConvexHull(roi, true);
    }

    public void runConvexHullROI(long roiMask, int roiOutputColorIndex) {
        this.roiManager.runConvexHull(Double.MAX_VALUE, Double.MAX_VALUE, false, true, roiMask, roiOutputColorIndex, false, this.roiManager.isUsing4dROI(), false);
    }

    public void runConvexHullROISlice(int sliceDirection, int sliceNumber, long roiMask, int roiOutputColorIndex) {
        this.roiManager.runConvexHullROI(sliceNumber, sliceDirection, Double.MAX_VALUE, Double.MAX_VALUE, false, true, roiMask, roiOutputColorIndex, false, this.roiManager.isUsing4dROI(), false);
    }

    public double[] runCrosssectionMM(Line line, final double step) {
        this.showCrosssectionTool();
        if (line != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    CrosssectionTool frame = (CrosssectionTool)SliceViewer.this.crosssection.getParentFrame();
                    if (frame != null) {
                        frame.setCurrentState(true, step);
                    }
                }
            };
            SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
            this.crosssection.setCurrentLine(line);
            LineOps op = new LineOps(this);
            return op.getValues(line, false, -1.0);
        }
        return CollectionUtilities.EMPTY_DOUBLE_ARRAY;
    }

    public double[] runCrosssectionVoxels(Line line) {
        if (line != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    CrosssectionTool frame = (CrosssectionTool)SliceViewer.this.crosssection.getParentFrame();
                    if (frame != null) {
                        frame.setCurrentState(false);
                    }
                }
            };
            SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
            this.crosssection.setCurrentLine(line);
            LineOps op = new LineOps(this);
            return op.getValues(line, false, -1.0);
        }
        return CollectionUtilities.EMPTY_DOUBLE_ARRAY;
    }

    public void runDilateROI(long roiMask, int kernel) {
        this.roiManager.runDilate3D(kernel, roiMask);
    }

    public void runDilateROISlice(int sliceDirection, int sliceNum, long roiMask, int kernel) {
        this.roiManager.runDilate2D(sliceNum, sliceDirection, kernel, roiMask);
    }

    public void runErodeROI(long roiMask, int kernel) {
        this.roiManager.runErode3D(kernel, roiMask);
    }

    public void runErodeROISlice(int sliceDirection, int sliceNum, long roiMask, int kernel) {
        this.roiManager.runErode2D(sliceNum, sliceDirection, kernel, roiMask);
    }

    public void runFilter(String name) {
        this.prepareFilter();
        FilterOp filterOp = new FilterOp(this, this);
        AbstractFilter filter = FilterManager.getFilter(name);
        if (filter != null) {
            filterOp.runFilter(filter, null, this.filterBuffer, true, false);
        }
    }

    public void runGenerateClusterROI(ImageVolume volume, int numberOfVoxelsThreshold) {
        ScreenVolume overlay = this.findOverlay((Volume)volume);
        if (overlay != null) {
            ClusterOperations.makeROIOfCluster(this.roiManager, overlay.getClusterData(), numberOfVoxelsThreshold, 0L, null);
        }
    }

    public void runGenerateHistogramROI(Histogram hist) {
        List selectedColors = hist.getSelectedColors();
        for (Integer selectedHistogramColor : selectedColors) {
            double[] mins = hist.getBinRangeMinimums();
            double[] maxs = hist.getBinRangeMaximums();
            int minIndex = hist.getSelectedBinStartIndex(selectedHistogramColor.intValue());
            int maxIndex = hist.getSelectedBinEndIndex(selectedHistogramColor.intValue());
            if (minIndex == -1 || maxIndex == -1) continue;
            double threshMin = mins[minIndex];
            double threshMax = maxs[maxIndex];
            this.roiManager.doMakeBoundRangeROI(this.roiManager.getImageBounds(), threshMin, threshMax, false, 0L, selectedHistogramColor);
        }
    }

    public void runGenerateHistogramROISlice(int sliceDirection, int sliceNumber, Histogram hist) {
        List selectedColors = hist.getSelectedColors();
        for (Integer selectedHistogramColor : selectedColors) {
            double[] mins = hist.getBinRangeMinimums();
            double[] maxs = hist.getBinRangeMaximums();
            int minIndex = hist.getSelectedBinStartIndex(selectedHistogramColor.intValue());
            int maxIndex = hist.getSelectedBinEndIndex(selectedHistogramColor.intValue());
            if (minIndex == -1 || maxIndex == -1) continue;
            double threshMin = mins[minIndex];
            double threshMax = maxs[maxIndex];
            this.roiManager.makeBoundRangeROI(sliceNumber, sliceDirection, threshMin, threshMax, false, 0L, selectedHistogramColor);
        }
    }

    public void runGenerateHistogramWithinROI(Histogram hist, long roiMask) {
        List selectedColors = hist.getSelectedColors();
        for (Integer selectedHistogramColor : selectedColors) {
            double[] mins = hist.getBinRangeMinimums();
            double[] maxs = hist.getBinRangeMaximums();
            int minIndex = hist.getSelectedBinStartIndex(selectedHistogramColor.intValue());
            int maxIndex = hist.getSelectedBinEndIndex(selectedHistogramColor.intValue());
            if (minIndex == -1 || maxIndex == -1) continue;
            double threshMin = mins[minIndex];
            double threshMax = maxs[maxIndex];
            this.roiManager.doMakeBoundRangeROI(this.roiManager.getImageBounds(), threshMin, threshMax, true, roiMask, selectedHistogramColor);
        }
    }

    public void runGenerateHistogramWithinROISlice(int sliceDirection, int sliceNumber, Histogram hist, long roiMask) {
        List selectedColors = hist.getSelectedColors();
        for (Integer selectedHistogramColor : selectedColors) {
            double[] mins = hist.getBinRangeMinimums();
            double[] maxs = hist.getBinRangeMaximums();
            int minIndex = hist.getSelectedBinStartIndex(selectedHistogramColor.intValue());
            int maxIndex = hist.getSelectedBinEndIndex(selectedHistogramColor.intValue());
            if (minIndex == -1 || maxIndex == -1) continue;
            double threshMin = mins[minIndex];
            double threshMax = maxs[maxIndex];
            this.roiManager.makeBoundRangeROI(sliceNumber, sliceDirection, threshMin, threshMax, true, roiMask, selectedHistogramColor);
        }
    }

    public void runGenerateLogicalROI(List<ImageVolume> volumes) {
        Logical logical = new Logical(null);
        for (ImageVolume vol : volumes) {
            logical.addOverlay((Volume)vol);
        }
        this.roiManager.doMakeLogicalROI(logical, new ImageBounds(0, this.volume.getXDim() - 1, 0, this.volume.getYDim() - 1, 0, this.volume.getZDim() - 1));
    }

    public Histogram runHistogram(final int numBins, final double min, final double max, final boolean excludeZero, final boolean integerMode) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                HistogramTool frame = SliceViewer.this.histogram.getHistogramDialog();
                if (frame != null) {
                    frame.setCurrentState(numBins, min, max, excludeZero, integerMode, false);
                }
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
        return this.histogram.updateStatsSync(numBins, min, max, false, true, excludeZero, integerMode, -1L);
    }

    public Histogram runHistogramROI(final int numBins, final double min, final double max, long roiMask, final boolean excludeZero, final boolean integerMode) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                HistogramTool frame = SliceViewer.this.histogram.getHistogramDialog();
                if (frame != null) {
                    frame.setCurrentState(numBins, min, max, excludeZero, integerMode, true);
                }
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
        return this.histogram.updateStatsSync(numBins, min, max, true, true, excludeZero, integerMode, roiMask);
    }

    public Analysis runLogicalAnalysis(List<ImageVolume> volumes) {
        Logical logical = new Logical(null);
        for (ImageVolume vol : volumes) {
            logical.addOverlay((Volume)vol);
        }
        LogicalOperations op = new LogicalOperations(this, this);
        AnalysisImpl stat = op.doAnalyze(logical, 0, this.volume.getXDim() - 1, 0, this.volume.getYDim() - 1, 0, this.volume.getZDim() - 1);
        this.logicalCalculationFinished(stat);
        return stat;
    }

    public void runOpenROI(long roiMask, int kernel) {
        this.roiManager.runOpen3D(kernel, roiMask);
    }

    public void runOpenROISlice(int sliceDirection, int sliceNum, long roiMask, int kernel) {
        this.roiManager.runOpen2D(sliceNum, sliceDirection, kernel, roiMask);
    }

    public VolumeManager runOperation(String expression, int selectionArea, boolean outputNewImage, boolean allSeriesPoints, boolean roiSlicesOnly) {
        ImageCalcExpressionImpl op = new ImageCalcExpressionImpl(expression, this, selectionArea, allSeriesPoints, roiSlicesOnly);
        if (outputNewImage) {
            return this.mango.addViewer(op, false);
        }
        this.doOperationImage(op, false);
        return this;
    }

    public void runOperationROILogic(String expression, int roiOutputColorIndex) {
        String operationString = ROIOperationTreeNode.makeReplacements(expression, this.roiManager);
        ROIOperationTreeNode startNode = ROIOperationTreeNode.makeOperationTree(operationString);
        if (startNode != null) {
            startNode.setOriginalOperation(expression);
            if (this.isMultiSliceMode()) {
                this.doOperationROI(startNode, roiOutputColorIndex, true);
            } else {
                this.doOperationROI(startNode, roiOutputColorIndex, this.getMainSliceNumber(), this.getMainSliceDirection(), true);
            }
        }
    }

    @ParameterNameAnnotation(names={"startingSeriesIndex", "endingSeriesIndex", "seriesGroupSize", "statisticType"})
    public VolumeManager runOperationSeriesStatistic(int startingSeriesIndex, int endingSeriesIndex, int seriesGroupSize, int statisticType) {
        return this.mango.addViewer(new ImageCalcExpressionImpl(this, startingSeriesIndex, endingSeriesIndex, seriesGroupSize, statisticType), false);
    }

    public Object runPlugin(String name, String[] args) {
        if (Mango.isScriptablePlugin(name)) {
            ScriptablePlugin sp = (ScriptablePlugin)Mango.findPlugin(name);
            return sp.doOperation((MangoContext)this.mango, (VolumeManager)this, false, args);
        }
        Mango.usePlugin(this, name);
        return null;
    }

    public void runPropagateROISlice(int sliceDirection, int sliceNumber, int startSlice, int endSlice, long roiMask, int roiOutputColorIndex) {
        this.roiManager.runPropagate(sliceDirection, sliceNumber, startSlice, endSlice, roiMask, roiOutputColorIndex);
    }

    public boolean runRangeToROI(double min, double max, boolean percentMax, boolean excludeZero, boolean makeSeriesROI, boolean seriesUsesDynamicThreshold) {
        double threshMin = min;
        double threshMax = max;
        if (percentMax) {
            Volume vol = this.getCurrentVolume();
            vol.updateMaxMin(vol.findRangeSeries());
            double imageMax = vol.getImageMax();
            threshMin = imageMax * (min / 100.0);
            threshMax = imageMax * (max / 100.0);
        }
        return this.roiManager.runRangeROI(threshMin, threshMax, excludeZero, makeSeriesROI, seriesUsesDynamicThreshold);
    }

    public boolean runRangeToROISlice(double min, double max, int sliceDirection, int sliceNumber, boolean percentMax, boolean excludeZero, boolean makeSeriesROI, boolean seriesUsesDynamicThreshold) {
        double threshMin = min;
        double threshMax = max;
        if (percentMax) {
            Volume vol = this.getCurrentVolume();
            vol.updateMaxMin(vol.findRangeSeries());
            double imageMax = vol.getImageMax();
            threshMin = imageMax * (min / 100.0);
            threshMax = imageMax * (max / 100.0);
        }
        return this.roiManager.runRangeROI(sliceNumber, sliceDirection, threshMin, threshMax, excludeZero, makeSeriesROI, seriesUsesDynamicThreshold);
    }

    public void runRankFilter(int size, int rankType, int filterType) {
        this.prepareFilter();
        AbstractFilterRank filter = null;
        if (filterType == 1) {
            filter = new FilterRankTime(rankType, size);
        } else if (filterType == 2) {
            filter = new FilterRankSlice(rankType, size);
        } else if (filterType == 4) {
            filter = new FilterRankVolume(rankType, size);
        }
        if (filter != null) {
            FilterOp filterOp = new FilterOp(this, this);
            filterOp.runRankfilter(filter, this.filterBuffer);
        }
    }

    public void runReflectROI(int sliceDirection, int axis, boolean vertical, boolean includePointsAndLines, boolean onlySelectedLines, boolean onlySelectedPoints) {
        if (includePointsAndLines) {
            this.poiManager.reflectPOIs(sliceDirection, vertical, axis, this.roiManager.getCurrentROI(), onlySelectedPoints);
            this.getLOIManagerMain().reflect(axis, vertical, this.roiManager.getCurrentROI(), onlySelectedLines);
        }
        this.roiManager.runReflection(sliceDirection, axis, vertical);
    }

    public void runReflectROISlice(int sliceDirection, int sliceNumber, int axis, boolean vertical, boolean includePointsAndLines, boolean onlySelectedLines, boolean onlySelectedPoints) {
        if (includePointsAndLines) {
            this.poiManager.reflectSlicePOIs(sliceDirection, sliceNumber, vertical, axis, this.roiManager.getCurrentROI(), onlySelectedPoints);
            this.getLOIManagerMain().reflectSlice(axis, vertical, sliceNumber, this.roiManager.getCurrentROI(), onlySelectedLines);
        }
        this.roiManager.runReflectSlice(sliceNumber, sliceDirection, axis, vertical);
    }

    public void runScript(String scriptName) {
        ScriptManager.runScriptSilently(scriptName, this.mango, this);
    }

    public List<Analysis> runSeriesROI(ROI roi) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        if (roi != null) {
            this.timeseries.setCurrentROI(roi);
            int numTimepoints = this.getCurrentScreenVolume().getVolume().getNumTimepoints();
            for (int ctr = 0; ctr < numTimepoints; ++ctr) {
                stats.add(roi.getStats(ctr));
            }
        }
        return stats;
    }

    public Analysis runSeriesStats() {
        Volume vol = this.getCurrentVolume();
        SeriesStatOp op = new SeriesStatOp(this, vol);
        OperationBuilder<Analysis> builder = new OperationBuilder<Analysis>(this, op);
        Analysis analysis = builder.runSynchronously();
        this.operationFinished(analysis, builder.getVolume());
        return analysis;
    }

    public List<Analysis> runSeriesStatsROI(long roiMask, boolean includePointsAndLines, boolean onlySelectedPoints, boolean onlySelectedLines) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        if (includePointsAndLines) {
            stats.addAll(this.runSeriesStatsROIPoints(onlySelectedPoints));
            stats.addAll(this.runSeriesStatsROILines(onlySelectedLines));
        }
        if (this.hasSelectedROIs()) {
            Volume vol = this.getCurrentVolume();
            SeriesStatROIOp op = new SeriesStatROIOp(this, vol, this.roiManager.getBuffer(), roiMask, this.roiManager);
            OperationBuilder<Map<Long, Analysis>> builder = new OperationBuilder<Map<Long, Analysis>>(this, op);
            Map<Long, Analysis> results = builder.runSynchronously();
            this.operationFinished(results, vol);
            stats.addAll(new ArrayList<Analysis>(results.values()));
        }
        return stats;
    }

    public void runShrinkWrapROI(double threshold, long roiMask, int roiOutputColorIndex, boolean percentMax, boolean seriesUsesDynamicThreshold) {
        double threshMin = threshold;
        if (percentMax) {
            Volume vol = this.getCurrentVolume();
            vol.updateMaxMin(vol.findRangeSeries());
            double imageMax = vol.getImageMax();
            threshMin = imageMax * (threshold / 100.0);
        }
        this.roiManager.runShrinkWrap3D(threshMin, Double.MAX_VALUE, this.getCurrentVolume(), true, roiMask, roiOutputColorIndex, false, this.roiManager.isUsing4dROI(), seriesUsesDynamicThreshold);
    }

    public void runShrinkWrapROI(long roiMask, int roiOutputColorIndex) {
        this.roiManager.runShrinkWrap3D(-1.7976931348623157E308, Double.MAX_VALUE, this.getCurrentVolume(), true, roiMask, roiOutputColorIndex, false, this.roiManager.isUsing4dROI(), false);
    }

    public void runShrinkWrapROIAllSlices(double threshold, int sliceDirection, long roiMask, int roiOutputColorIndex, boolean percentMax, boolean seriesUsesDynamicThreshold) {
        double threshMin = threshold;
        if (percentMax) {
            Volume vol = this.getCurrentVolume();
            vol.updateMaxMin(vol.findRangeSeries());
            double imageMax = vol.getImageMax();
            threshMin = imageMax * (threshold / 100.0);
        }
        this.roiManager.shrinkWrap2D(-1, sliceDirection, threshMin, Double.MAX_VALUE, true, roiMask, roiOutputColorIndex, false, this.roiManager.isUsing4dROI(), seriesUsesDynamicThreshold, true);
    }

    public void runShrinkWrapROIAllSlices(int sliceDirection, long roiMask, int roiOutputColorIndex) {
        this.roiManager.shrinkWrap2D(-1, sliceDirection, -1.7976931348623157E308, Double.MAX_VALUE, true, roiMask, roiOutputColorIndex, false, this.roiManager.isUsing4dROI(), false, true);
    }

    public void runShrinkWrapROISlice(double threshold, int sliceDirection, int sliceNumber, long roiMask, int roiOutputColorIndex, boolean percentMax, boolean seriesUsesDynamicThreshold) {
        double threshMin = threshold;
        if (percentMax) {
            Volume vol = this.getCurrentVolume();
            vol.updateMaxMin(vol.findRangeSeries());
            double imageMax = vol.getImageMax();
            threshMin = imageMax * (threshold / 100.0);
        }
        this.roiManager.shrinkWrap2D(sliceNumber, sliceDirection, threshMin, Double.MAX_VALUE, true, roiMask, roiOutputColorIndex, false, this.roiManager.isUsing4dROI(), seriesUsesDynamicThreshold, true);
    }

    public void runShrinkWrapROISlice(int sliceDirection, int sliceNumber, long roiMask, int roiOutputColorIndex) {
        this.roiManager.shrinkWrap2D(sliceNumber, sliceDirection, -1.7976931348623157E308, Double.MAX_VALUE, true, roiMask, roiOutputColorIndex, false, this.roiManager.isUsing4dROI(), false, true);
    }

    public Analysis runSliceStats(int sliceDirection, int sliceNumber) {
        Volume vol = this.getCurrentVolume();
        SliceStatOp op = new SliceStatOp(this, vol);
        Analysis stat = null;
        stat = sliceDirection == 0 ? op.process(new ImageBounds(0, this.volume.getXDim() - 1, 0, this.volume.getYDim() - 1, sliceNumber, sliceNumber)) : (sliceDirection == 1 ? op.process(new ImageBounds(0, this.volume.getXDim() - 1, sliceNumber, sliceNumber, 0, this.volume.getZDim() - 1)) : op.process(new ImageBounds(sliceNumber, sliceNumber, 0, this.volume.getYDim() - 1, 0, this.volume.getZDim() - 1)));
        if (stat != null) {
            this.operationFinished(stat, vol);
        }
        return stat;
    }

    public List<Analysis> runSliceStatsROI(int sliceDirection, int sliceNumber, long roiMask, boolean includePointsAndLines, boolean onlySelectedPoints, boolean onlySelectedLines) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        int sliceStatsDirection = sliceDirection;
        int sliceStatsCurrentSlice = sliceNumber;
        if (includePointsAndLines) {
            stats.addAll(this.runSliceStatsROIPoints(sliceStatsDirection, sliceStatsCurrentSlice, onlySelectedPoints));
            stats.addAll(this.runSliceStatsROILines(sliceStatsDirection, sliceStatsCurrentSlice, onlySelectedLines));
        }
        if (roiMask != 0L) {
            Volume vol = this.getCurrentVolume();
            Map<Long, Analysis> results = null;
            SliceStatROIOp op = new SliceStatROIOp(this, vol, this.roiManager.getBuffer(), roiMask, this.roiManager);
            results = sliceStatsDirection == 0 ? op.process(new ImageBounds(0, this.volume.getXDim() - 1, 0, this.volume.getYDim() - 1, sliceStatsCurrentSlice, sliceStatsCurrentSlice)) : (sliceStatsDirection == 1 ? op.process(new ImageBounds(0, this.volume.getXDim() - 1, sliceStatsCurrentSlice, sliceStatsCurrentSlice, 0, this.volume.getZDim() - 1)) : op.process(new ImageBounds(sliceStatsCurrentSlice, sliceStatsCurrentSlice, 0, this.volume.getYDim() - 1, 0, this.volume.getZDim() - 1)));
            stats.addAll(new ArrayList<Analysis>(results.values()));
            this.operationFinished(results, vol);
        }
        return stats;
    }

    public void runSmooth(ROI roi) {
        this.resetAllClipboardsUndo();
        this.recordAction("runSmooth", new String[]{this.getScriptObjectName() + ".roiData.allROIs"}, true);
        if (roi instanceof LOIShape) {
            this.smoothLOI((LOIShape)roi);
        }
        this.updateViewer();
    }

    public Analysis runStat(ROI roi) {
        this.recordAction("runStat", new String[]{this.getScriptObjectName() + ".roiData.allROIs"}, true);
        Analysis stats = roi.getStats(this.getCurrentVolume().getCurrentSeriesPoint());
        ArrayList<AnalysisImpl> list = new ArrayList<AnalysisImpl>();
        list.add((AnalysisImpl)stats);
        this.operationFinished(list, this.getCurrentVolume());
        return stats;
    }

    public void runThresholdToConvexHullROI(double threshold, boolean percentMax, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        double threshMin = threshold;
        if (percentMax) {
            Volume vol = this.getCurrentVolume();
            vol.updateMaxMin(vol.findRangeSeries());
            double imageMax = vol.getImageMax();
            threshMin = imageMax * (threshold / 100.0);
        }
        this.roiManager.runConvexHull(threshMin, Double.MAX_VALUE, excludeZero, false, 0L, 0, false, isSeries, isDynamicThreshold);
    }

    public void runThresholdToConvexHullROISlice(double threshold, int sliceDirection, int sliceNum, boolean percentMax, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        double threshMin = threshold;
        if (percentMax) {
            Volume vol = this.getCurrentVolume();
            vol.updateMaxMin(vol.findRangeSeries());
            double imageMax = vol.getImageMax();
            threshMin = imageMax * (threshold / 100.0);
        }
        this.roiManager.runConvexHullROI(sliceNum, sliceDirection, threshMin, Double.MAX_VALUE, excludeZero, false, 0L, 0, false, isSeries, isDynamicThreshold);
    }

    public boolean runThresholdToROI(double threshold, boolean percentMax, boolean excludeZero, boolean makeSeriesROI, boolean seriesUsesDynamicThreshold) {
        double threshMin = threshold;
        if (percentMax) {
            Volume vol = this.getCurrentVolume();
            vol.updateMaxMin(vol.findRangeSeries());
            double imageMax = vol.getImageMax();
            threshMin = imageMax * (threshold / 100.0);
        }
        this.roiManager.updateROIBufferSeries(makeSeriesROI);
        return this.roiManager.runThresholdROI(threshMin, excludeZero, makeSeriesROI, seriesUsesDynamicThreshold);
    }

    public boolean runThresholdToROISlice(double threshold, int sliceDirection, int sliceNumber, boolean percentMax, boolean excludeZero, boolean makeSeriesROI, boolean seriesUsesDynamicThreshold) {
        double threshMin = threshold;
        if (percentMax) {
            Volume vol = this.getCurrentVolume();
            vol.updateMaxMin(vol.findRangeSeries());
            double imageMax = vol.getImageMax();
            threshMin = imageMax * (threshold / 100.0);
        }
        this.roiManager.updateROIBufferSeries(makeSeriesROI);
        return this.roiManager.runThresholdROI(sliceNumber, sliceDirection, threshMin, excludeZero, makeSeriesROI, seriesUsesDynamicThreshold);
    }

    public boolean runThresholdToShrinkWrapROI(double threshold, boolean percentMax, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        double threshMin = threshold;
        if (percentMax) {
            Volume vol = this.getCurrentVolume();
            vol.updateMaxMin(vol.findRangeSeries());
            double imageMax = vol.getImageMax();
            threshMin = imageMax * (threshold / 100.0);
        }
        return this.roiManager.runShrinkWrap3D(threshMin, Double.MAX_VALUE, this.getCurrentVolume(), false, this.roiManager.getBuffer().getSelected(), this.roiManager.getCurrentROI(), excludeZero, isSeries, isDynamicThreshold);
    }

    public boolean runThresholdToShrinkWrapROIAllSlices(double threshold, int sliceDirection, boolean percentMax, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        double threshMin = threshold;
        if (percentMax) {
            Volume vol = this.getCurrentVolume();
            vol.updateMaxMin(vol.findRangeSeries());
            double imageMax = vol.getImageMax();
            threshMin = imageMax * (threshold / 100.0);
        }
        return this.roiManager.shrinkWrap2D(-1, sliceDirection, threshMin, Double.MAX_VALUE, false, this.roiManager.getBuffer().getSelected(), this.roiManager.getCurrentROI(), excludeZero, isSeries, isDynamicThreshold, true);
    }

    public boolean runThresholdToShrinkWrapROISlice(double threshold, int sliceDirection, int sliceNumber, boolean percentMax, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        double threshMin = threshold;
        if (percentMax) {
            Volume vol = this.getCurrentVolume();
            vol.updateMaxMin(vol.findRangeSeries());
            double imageMax = vol.getImageMax();
            threshMin = imageMax * (threshold / 100.0);
        }
        return this.roiManager.shrinkWrap2D(sliceNumber, sliceDirection, threshMin, Double.MAX_VALUE, false, this.roiManager.getBuffer().getSelected(), this.roiManager.getCurrentROI(), excludeZero, isSeries, isDynamicThreshold, true);
    }

    public Analysis runVolumeStats() {
        Volume vol = this.getCurrentVolume();
        VolumeStatOp op = new VolumeStatOp(this, vol);
        OperationBuilder<Analysis> builder = new OperationBuilder<Analysis>(this, op);
        Analysis analysis = builder.runSynchronously();
        this.operationFinished(analysis, builder.getVolume());
        return analysis;
    }

    public List<Analysis> runVolumeStatsROI(long roiMask, boolean includePointsAndLines, boolean onlySelectedPoints, boolean onlySelectedLines) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        if (includePointsAndLines) {
            stats.addAll(this.runVolumeStatsROIPoints(onlySelectedPoints));
            stats.addAll(this.runVolumeStatsROILines(onlySelectedLines));
        }
        if (roiMask != 0L) {
            Volume vol = this.getCurrentVolume();
            VolumeStatROIOp op = new VolumeStatROIOp(this, vol, this.roiManager.getBuffer(), roiMask, this.roiManager);
            OperationBuilder<Map<Long, Analysis>> builder = new OperationBuilder<Map<Long, Analysis>>(this, op);
            Map<Long, Analysis> results = builder.runSynchronously();
            this.operationFinished(results, vol);
            stats.addAll(new ArrayList<Analysis>(results.values()));
        }
        return stats;
    }

    public void save() {
        if (this.canBeSaved()) {
            this.saveViewer(true);
        }
    }

    public void saveAs(String saveLocation, String headerFormat, int datatype, int numBytes, boolean littleEndian, boolean compress, int xMin, int xMax, int yMin, int yMax, int zMin, int zMax, int tMin, int tMax, double xSize, double ySize, double zSize, double tSize, String orientation, boolean applyTransform, boolean applyOverlay, boolean overlayThreshold, boolean overlayMix, int interpolation, boolean applyDataScales, boolean fitPrecision, boolean maintainZero) {
        if (fitPrecision || overlayThreshold) {
            ScreenVolume sv = this.getBaseScreenVolume();
            sv.getVolume().updateMaxMin(sv.getVolume().findRangeSeries());
        }
        ImageBounds ib = new ImageBounds(xMin, xMax, yMin, yMax, zMin, zMax);
        ib.setRangeT(tMin, tMax);
        this.saveImageAs(new File(saveLocation), applyTransform ? 1 : 0, applyOverlay ? this.getCurrentOverlayIndex() + 1 : 0, orientation, new ImageType(numBytes, datatype, numBytes * 8, littleEndian), headerFormat, applyDataScales, interpolation == 0, interpolation == 1, interpolation == 2, overlayThreshold, overlayMix, compress, fitPrecision, maintainZero, ib, xSize, ySize, zSize, tSize, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(String text, String extension) {
        File oldFile = this.getLoadedFile();
        String fileName = oldFile.getName();
        File selectedFile = null;
        File startFile = null;
        startFile = fileName.indexOf(46) != -1 ? new File(oldFile.getParent(), fileName.substring(0, fileName.indexOf(46)) + extension) : new File(oldFile.getParent(), fileName + extension);
        selectedFile = this.mango.makeSaveFileChooser(this.getSaveDirectory(), startFile.getName());
        if (selectedFile != null) {
            try (PrintWriter writer = null;){
                writer = new PrintWriter(new BufferedWriter(new FileWriter(selectedFile)));
                writer.println(text);
            }
        }
    }

    public boolean saveImageAs(File file, int transformIndex, int overlayIndex, String orientation, ImageType itNew, String otherFormatName, boolean applyDataScales, boolean nearestNeighbor, boolean trilinear, boolean sync, boolean threshold, boolean mix, boolean compress, boolean fitPrecision, boolean maintainZero, ImageBounds ib, double resliceX, double resliceY, double resliceZ, double resliceT, boolean sameThread) {
        this.recordAction("saveAs", new String[]{this.getScriptObjectName() + ".makeFilename(\"." + FileUtilities.getFullExtension((File)file) + "\")", ScriptUtils.convertString(otherFormatName), String.valueOf(itNew.getByteType()), String.valueOf(itNew.getNumBytesPerVoxel()), ScriptUtils.convertBoolean(itNew.isLittleEndian()), ScriptUtils.convertBoolean(compress), String.valueOf(ib.getMinX()), String.valueOf(ib.getMaxX()), String.valueOf(ib.getMinY()), String.valueOf(ib.getMaxY()), String.valueOf(ib.getMinZ()), String.valueOf(ib.getMaxZ()), String.valueOf(ib.getMinT()), String.valueOf(ib.getMaxT()), String.valueOf(resliceX), String.valueOf(resliceY), String.valueOf(resliceZ), String.valueOf(resliceT), ScriptUtils.convertString(orientation), ScriptUtils.convertBoolean(transformIndex != 0), ScriptUtils.convertBoolean(overlayIndex != 0), ScriptUtils.convertBoolean(threshold), ScriptUtils.convertBoolean(mix), String.valueOf(FileSaveAsChooser.getInterpolationCode(nearestNeighbor, trilinear, sync)), ScriptUtils.convertBoolean(applyDataScales), ScriptUtils.convertBoolean(fitPrecision), ScriptUtils.convertBoolean(maintainZero)}, true);
        try {
            boolean dimsChanged;
            this.setNavigationDisabled(true);
            this.volumeWillBeSaved = true;
            boolean bl = dimsChanged = ib.getMinX() != 0 || ib.getMinY() != 0 || ib.getMinZ() != 0 || ib.getMaxX() != this.volume.getXDim() - 1 || ib.getMaxY() != this.volume.getYDim() - 1 || ib.getMaxZ() != this.volume.getZDim() - 1;
            if (dimsChanged && this.surfaceRender != null) {
                this.axialImage.clearTextureData();
                this.coronalImage.clearTextureData();
                this.sagittalImage.clearTextureData();
                this.surfaceRender.getFrame().dispose();
                this.surfaceRender = null;
            }
            boolean overwrite = file.equals(this.getLoadedFile());
            ScreenVolume overlay = null;
            if (overlayIndex > 0) {
                overlay = this.overlayManager.getOverlay(overlayIndex - 1);
            }
            double overlayThreshold = 0.0;
            if (overlay != null) {
                overlayThreshold = Math.abs(overlay.getScreenMin());
            }
            this.setLoadedURI(file.toURI());
            this.volume.setDisplayValues(this.baseScreenVolume.getScreenMax(), this.baseScreenVolume.getScreenMin());
            itNew.setCompressionType(compress ? 1 : 0);
            this.volume.saveLabelData(this.getMangoVersion());
            this.volume.writeFilesAs(file, itNew, transformIndex, orientation, this.baseScreenVolume.getOrigin(), overwrite, otherFormatName, applyDataScales, this.isWorldMode(), overlay, true, 0, nearestNeighbor, trilinear, sync, threshold, overlayThreshold, mix, fitPrecision, maintainZero, ib, resliceX, resliceY, resliceZ, resliceT, sameThread);
        }
        catch (VolumeIOException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog("Problem saving image file!\nCheck write permissions!", ERROR_TITLE_SAVE);
            this.volumeSaved(this.volume, false, false, null, null, false, false);
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog(PROBLEM_SAVING_IMAGE_FILE + ex.getMessage(), ERROR_TITLE_SAVE);
            this.volumeSaved(this.volume, false, false, null, null, false, false);
        }
        catch (ParserConfigurationException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog(PROBLEM_SAVING_IMAGE_FILE + ex.getMessage(), ERROR_TITLE_SAVE);
            this.volumeSaved(this.volume, false, false, null, null, false, false);
        }
        catch (TransformerException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog(PROBLEM_SAVING_IMAGE_FILE + ex.getMessage(), ERROR_TITLE_SAVE);
            this.volumeSaved(this.volume, false, false, null, null, false, false);
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog(PROBLEM_SAVING_IMAGE_FILE + ex.getMessage(), ERROR_TITLE_SAVE);
            this.volumeSaved(this.volume, false, false, null, null, false, false);
        }
        return this.imageSaved;
    }

    public void saveOverlays() {
        if (this.overlayCanBeSaved()) {
            this.overlayWillBeSaved = true;
            this.saveOverlays(true);
        }
    }

    public void saveROI(String saveLocation) {
        if (this.roiCanBeSaved(true)) {
            this.saveROI(new File(saveLocation), -1, true);
        }
    }

    public void saveSingleROI(String saveLocation, int index) {
        if (this.roiCanBeSaved(true)) {
            this.saveROI(new File(saveLocation), index, true);
        }
    }

    public void saveViewer(boolean sameThread) {
        this.recordAction("save");
        this.volumeWillBeSaved = this.volume.isDirty() && this.volume.isWritable(this.getLoadedFile()) && !this.volume.cannotBeOverwritten() || this.volume.hasDirtyHeader() && !this.volume.hasDirtyImage() && this.volume.isWritable(this.getLoadedFile());
        this.roiManagerWillBeSaved = this.roiCanBeSaved(false);
        this.overlayWillBeSaved = this.overlayCanBeSaved();
        if (this.volumeWillBeSaved) {
            this.saveVolume(sameThread);
        } else if (this.overlayWillBeSaved) {
            this.saveOverlays(sameThread);
        } else if (this.roiManagerWillBeSaved) {
            this.saveROI(null, -1, sameThread);
        }
    }

    public void select(final ROI roi, final boolean select) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (roi instanceof Mask) {
                    int index = roi.getColor();
                    if (SliceViewer.this.isMultiSliceMode()) {
                        SliceViewer.this.roiManager.setSelectedState(index, select);
                    } else {
                        SliceViewer.this.roiManager.setSelectedState(index, SliceViewer.this.getSliceNumber(), SliceViewer.this.getSliceDirection(), select);
                    }
                } else if (roi instanceof LOIShape) {
                    LOIShape line = (LOIShape)roi;
                    line.setSelectedState(select);
                } else if (roi instanceof POI) {
                    POI poi = (POI)roi;
                    poi.setSelectedState(select);
                }
                SliceViewer.this.updateViewer();
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void selectAll() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.doSelectAll();
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void selectCoordinate() {
        if (this.volume != null) {
            String[] input;
            Coordinate coor;
            boolean showTimepointSelection;
            SelectCoordinateDialog dialog = null;
            boolean bl = showTimepointSelection = this.getCurrentScreenVolume().getVolume().getNumTimepoints() > 1;
            if (this.isWorldMode()) {
                coor = this.getCurrentCoordinate();
                dialog = showTimepointSelection ? new SelectCoordinateDialog(TEXT_GO_TO_COORDINATE, new String[]{"X", "Y", "Z", "Series Point"}, true, new String[]{FORMATTER.format(coor.xDbl), FORMATTER.format(coor.yDbl), FORMATTER.format(coor.zDbl), String.valueOf(this.getCurrentScreenVolume().getVolume().getCurrentTimepoint() + 1)}, 6) : new SelectCoordinateDialog(TEXT_GO_TO_COORDINATE, new String[]{"X", "Y", "Z"}, true, new String[]{FORMATTER.format(coor.xDbl), FORMATTER.format(coor.yDbl), FORMATTER.format(coor.zDbl)}, 6);
            } else {
                coor = this.getCurrentIndex();
                dialog = showTimepointSelection ? new SelectCoordinateDialog(TEXT_GO_TO_COORDINATE, new String[]{"X", "Y", "Z", "Series Point"}, true, new String[]{String.valueOf(this.convertCoordinateOriginX(coor.xInt)), String.valueOf(this.convertCoordinateOriginY(coor.yInt)), String.valueOf(this.convertCoordinateOriginZ(coor.zInt)), String.valueOf(this.getCurrentScreenVolume().getVolume().getCurrentTimepoint() + 1)}, 6) : new SelectCoordinateDialog(TEXT_GO_TO_COORDINATE, new String[]{"X", "Y", "Z"}, true, new String[]{String.valueOf(this.convertCoordinateOriginX(coor.xInt)), String.valueOf(this.convertCoordinateOriginY(coor.yInt)), String.valueOf(this.convertCoordinateOriginZ(coor.zInt))}, 6);
            }
            MangoFocusableOptionPane jopf = null;
            boolean isApplet = this.mango.isApplet();
            jopf = isApplet ? new MangoFocusableOptionPane((MangoFocusableOptionPaneUser)((Object)Mango.getMangoApplet()), (Object)dialog, TEXT_GO_TO_COORDINATE, -1) : new MangoFocusableOptionPane(this.getFrame(), (Object)dialog, TEXT_GO_TO_COORDINATE, -1);
            int selection = jopf.show();
            if (selection == 0 && (input = dialog.getResults()) != null) {
                try {
                    this.recordAction("setCurrentPosition", new String[]{null});
                    if (this.isWorldMode()) {
                        this.setCurrentCoordinate(new Coordinate(Double.parseDouble(input[0]), Double.parseDouble(input[1]), Double.parseDouble(input[2])));
                    } else {
                        this.setCurrentCoordinate(new Coordinate((double)this.convertCoordinateOriginX((int)Double.parseDouble(input[0])), (double)this.convertCoordinateOriginY((int)Double.parseDouble(input[1])), (double)this.convertCoordinateOriginZ((int)Double.parseDouble(input[2]))));
                    }
                }
                catch (NumberFormatException ex) {
                    AppLogger.error((Throwable)ex);
                }
                if (showTimepointSelection) {
                    int currentTimepoint = this.getCurrentTimepoint();
                    try {
                        currentTimepoint = Integer.parseInt(input[3]);
                    }
                    catch (NumberFormatException ex) {
                        AppLogger.error((Throwable)ex);
                    }
                    if (currentTimepoint < 1) {
                        currentTimepoint = 1;
                    } else if (currentTimepoint > this.getCurrentScreenVolume().getVolume().getNumTimepoints()) {
                        currentTimepoint = this.getCurrentScreenVolume().getVolume().getNumTimepoints();
                    }
                    this.setCurrentTimepoint(currentTimepoint - 1, this.getCurrentScreenVolume().getVolume());
                }
                this.updateSync();
            }
            this.updateSurface();
            this.updateSurfaceColorAtTimepoint();
            this.updateWindowTitle();
        }
    }

    public void selectMenuOption(final String name) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (name.equals("Histogram")) {
                    SliceViewer.this.showHistogramTool(false);
                } else if (name.equals("Cross-section")) {
                    SliceViewer.this.showCrosssectionTool();
                } else if (name.equals("Series")) {
                    SliceViewer.this.showSeriesTool();
                } else if (name.equals("Find Overlay Clusters")) {
                    SliceViewer.this.showClusterAnalysisTool();
                } else if (name.equals("Find ROI Components")) {
                    SliceViewer.this.showROIComponentAnalysisTool();
                } else if (name.equals("Transform...")) {
                    SliceViewer.this.showTransformManualPanel();
                } else if (name.equals("Maximize")) {
                    SliceViewer.this.selectWindowMenuOptionMaximize();
                } else if (name.equals("Dock")) {
                    SliceViewer.this.selectWindowMenuOptionMinimize();
                } else if (name.equals("Zoom In")) {
                    SliceViewer.this.selectWindowMenuOptionZoomIn();
                } else if (name.equals("Zoom Out")) {
                    SliceViewer.this.selectWindowMenuOptionZoomOut();
                } else if (name.equals("Image Info")) {
                    SliceViewer.this.showImageInfoDialog();
                } else if (name.equals("Show File")) {
                    SliceViewer.this.showFile();
                } else if (name.equals("Remove Overlays")) {
                    SliceViewer.this.removeAllOverlays();
                } else if (name.equals("Select All")) {
                    SliceViewer.this.doSelectAll();
                } else if (name.equals("Deselect All")) {
                    SliceViewer.this.deselectAll();
                } else if (name.equals("Copy")) {
                    SliceViewer.this.doCopy(true);
                } else if (name.equals("Delete")) {
                    SliceViewer.this.deleteAction(true);
                } else if (name.equals("Cut")) {
                    SliceViewer.this.doCut(true);
                } else if (name.equals("Paste")) {
                    SliceViewer.this.doPaste(true);
                } else if (name.equals("Undo")) {
                    SliceViewer.this.doUndo(true);
                } else if (name.equals("Redo")) {
                    SliceViewer.this.doRedo(true);
                } else {
                    SliceViewer.this.doClickMenuItem(name);
                }
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void selectWindowMenuOptionMaximize() {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Maximize")});
        this.frame.maximize();
    }

    public void selectWindowMenuOptionMinimize() {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Dock")});
        this.frame.setState(1);
    }

    public void selectWindowMenuOptionZoomIn() {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Zoom In")});
        this.frame.incrementFrameSize();
    }

    public void selectWindowMenuOptionZoomOut() {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Zoom Out")});
        this.frame.decrementFrameSize();
    }

    @Override
    public void seriesLabelEditingDone() {
        this.removeSeriesLabelEditor();
        this.requestFocus();
    }

    @Override
    public boolean seriesLabelEditorDecremented() {
        return this.decrementSlice(3);
    }

    @Override
    public boolean seriesLabelEditorIncremented() {
        return this.incrementSlice(3);
    }

    public void setAltKeyMode(boolean on) {
        if (on) {
            if (!this.isROIMode()) {
                this.toolBox.setSelectionMode(2);
                this.setSpecialNavFunctionPrimed(true);
            }
        } else {
            this.clearKeyboardMode();
        }
        if (this.viewerSyncer.isZoom()) {
            Mango.updateAllViewers();
        } else {
            this.updateViewer();
        }
    }

    public void setAltShiftKeyMode(boolean on) {
        if (on) {
            if (!this.isROIMode()) {
                this.toolBox.setSelectionMode(3);
                this.setSpecialNavFunctionPrimed(true);
            }
        } else {
            this.clearKeyboardMode();
        }
        if (this.viewerSyncer.isZoom()) {
            Mango.updateAllViewers();
        } else {
            this.updateViewer();
        }
    }

    public void setAsDead() {
        this.isDead = true;
    }

    public void setAsTemp() {
        this.isTempImage = true;
    }

    public void setAxialSliceNumber(int sliceNum) {
        this.axialImage.setCurrentSlice(sliceNum);
        this.coronalImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
        this.sagittalImage.setCrosshairPosition(this.coronalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
    }

    public void setCaptureSize(int val) {
    }

    public void setCleared(boolean bool) {
        this.isCleared = bool;
    }

    public void setClosing(boolean bool) {
        this.isClosing = bool;
    }

    public void setContainsMouse(boolean bool) {
        this.containsMouse = bool;
    }

    @Deprecated
    public void setCoordinateSpace(int index) {
        this.setOrientationOption(this.volume, index);
    }

    public void setCoordinateType(int type) {
        this.toolBox.updateCoordinate(type);
    }

    public void setCoronalSliceNumber(int sliceNum) {
        this.coronalImage.setCurrentSlice(sliceNum);
        this.axialImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.coronalImage.getCurrentSlice());
        this.sagittalImage.setCrosshairPosition(this.coronalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
    }

    public void setCurrentCoordinate(Coordinate coor) {
        this.setCurrentCoordinate(coor, false, -1);
    }

    public void setCurrentCoordinate(Coordinate coor, boolean indexOnly, int labelTypeVal) {
        if (coor == null || this.axialImage == null || this.coronalImage == null || this.sagittalImage == null || this.isNavigationDisabled()) {
            return;
        }
        int labelType = labelTypeVal;
        if (labelType == -1) {
            labelType = this.toolBox.getCoordinateType();
        }
        if (labelType == 0 || indexOnly) {
            boolean axi = this.axialImage.setCurrentSlice((int)Math.round(coor.zDbl));
            boolean cor = this.coronalImage.setCurrentSlice((int)Math.round(coor.yDbl));
            boolean sag = this.sagittalImage.setCurrentSlice((int)Math.round(coor.xDbl));
            if (cor && sag) {
                this.axialImage.setCrosshairPosition((int)Math.round(coor.xDbl), (int)Math.round(coor.yDbl));
            }
            if (axi && sag) {
                this.coronalImage.setCrosshairPosition((int)Math.round(coor.xDbl), (int)Math.round(coor.zDbl));
            }
            if (axi && cor) {
                this.sagittalImage.setCrosshairPosition((int)Math.round(coor.yDbl), (int)Math.round(coor.zDbl));
            }
        } else {
            Coordinate origin = this.baseScreenVolume.getOrigin();
            boolean axi = this.axialImage.setCurrentSlice((int)Math.round((double)origin.zInt - coor.zDbl / this.volume.getZSize()));
            boolean cor = this.coronalImage.setCurrentSlice((int)Math.round((double)origin.yInt - coor.yDbl / this.volume.getYSize()));
            boolean sag = this.sagittalImage.setCurrentSlice((int)Math.round(coor.xDbl / this.volume.getXSize() + (double)origin.xInt));
            if (cor && sag) {
                this.axialImage.setCrosshairPosition((int)Math.round(coor.xDbl / this.volume.getXSize() + (double)origin.xInt), (int)Math.round((double)origin.yInt - coor.yDbl / this.volume.getYSize()));
            }
            if (axi && sag) {
                this.coronalImage.setCrosshairPosition((int)Math.round(coor.xDbl / this.volume.getXSize() + (double)origin.xInt), (int)Math.round((double)origin.zInt - coor.zDbl / this.volume.getZSize()));
            }
            if (axi && cor) {
                this.sagittalImage.setCrosshairPosition((int)Math.round((double)origin.yInt - coor.yDbl / this.volume.getYSize()), (int)Math.round((double)origin.zInt - coor.zDbl / this.volume.getZSize()));
            }
        }
        this.updateScreenSliceTransforms();
        this.updateSurface();
        this.toolBox.updateMouseLabelInfo();
    }

    public void setCurrentIndex(Coordinate coor) {
        this.setCurrentCoordinate(coor, true, 0);
    }

    public void setCurrentOverlay(Volume vol) {
        if (!this.mango.isCurrentViewer(this)) {
            this.setAsCurrentViewer();
        }
        int index = this.overlayManager.getIndex(vol);
        this.toolBox.doOverlayButtonChosen(index + 1);
    }

    public void setCurrentPanLocation(int xLoc, int yLoc, int sliceDirection) {
        if (this.zoomFactor > 1.0) {
            if (sliceDirection == 0) {
                this.panAmountX += xLoc - this.panLocX;
                this.panAmountY += yLoc - this.panLocY;
                this.panAmountZ = 0;
            } else if (sliceDirection == 1) {
                this.panAmountX += xLoc - this.panLocX;
                this.panAmountY = 0;
                this.panAmountZ += yLoc - this.panLocZ;
            } else if (sliceDirection == 2) {
                this.panAmountX = 0;
                this.panAmountY += xLoc - this.panLocY;
                this.panAmountZ += yLoc - this.panLocZ;
            }
            this.axialImage.updateTransforms();
            this.coronalImage.updateTransforms();
            this.sagittalImage.updateTransforms();
            this.updateViewer();
        }
    }

    public void setCurrentPosition(final Coordinate coor) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.setCurrentIndex(coor);
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentScreenVolume(ScreenVolume screenVolume) {
        this.currentScreenVolume = screenVolume;
        ArrayList<CurrentVolumeListener> copy = null;
        List<CurrentVolumeListener> list = this.currentVolumeListeners;
        synchronized (list) {
            copy = new ArrayList<CurrentVolumeListener>(this.currentVolumeListeners);
            for (CurrentVolumeListener listener : copy) {
                listener.currentVolumeChanged();
            }
        }
    }

    public void setCurrentSeriesPoint(final int seriesIndex) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.setCurrentTimepoint(seriesIndex);
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void setCurrentTimepoint(int val) {
        this.setCurrentTimepoint(val, null);
    }

    public void setCurrentTimepoint(int val, ImageVolume iv) {
        Volume volume = null;
        this.recordAction("setCurrentSeriesPoint", new String[]{String.valueOf(val)});
        volume = iv == null ? this.getCurrentScreenVolume().getVolume() : (Volume)iv;
        if (val >= 0 && val < volume.getNumTimepoints()) {
            volume.setCurrentTimepoint(val);
            if (this.getBaseVolume() != volume) {
                this.reconcileOverlayTimeseries(this.findOverlay(volume));
            }
            this.forceImageUpdate();
            this.updateScreenSlices();
            if (this.roiManager.isUsing4dROI()) {
                this.updateROISlices();
            }
            this.updateSyncSeries();
            this.toolBox.setMouseLabelInfoIncrement(3, 0);
        }
    }

    public void setCurrentVolumeIndex(final int index) {
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.mango.getToolBox().doOverlayButtonChosen(index);
            }
        });
    }

    public void setDisplayRangeToImageRange(ImageVolume volume, boolean entireSeries) {
        if (this.toolBox.isGlobal() && this.findOverlay((Volume)volume).isBaseImage()) {
            this.toolBox.updateGlobalRange();
        } else {
            Volume vol = (Volume)volume;
            Range op = entireSeries ? vol.findRangeSeries() : vol.findRangeVolume();
            ScreenVolume screenVol = this.findOverlay(vol);
            vol.updateMaxMin(screenVol != null ? screenVol : this.baseScreenVolume, op, true);
        }
    }

    public void setHistogramAlpha(int val) {
        this.axialImage.setHistogramAlpha(val);
        this.coronalImage.setHistogramAlpha(val);
        this.sagittalImage.setHistogramAlpha(val);
    }

    public void setHistogramOverlayState(boolean bool) {
        this.axialImage.setHistogramState(bool);
        this.coronalImage.setHistogramState(bool);
        this.sagittalImage.setHistogramState(bool);
    }

    public void setImageLoaded(boolean bool) {
        this.imageLoaded = bool;
    }

    @Deprecated
    public void setImageOrigin(Coordinate coor) {
        this.volume.setOrigin(coor);
    }

    public void setLabel(ROI roi, String label) {
        this.recordAction("setLabel", new String[]{this.getScriptObjectName() + ".roiData.allROIs", ScriptUtils.convertString(label)}, true);
        if (roi instanceof Mask) {
            this.roiManager.setLabel(roi.getColor(), label);
        } else if (roi instanceof LOIShape) {
            LOIShape line = (LOIShape)roi;
            line.setName(label);
            int dir = line.getSliceDirection();
            if (dir == 0) {
                this.getLOIManagerAxial().setDirty(true);
            } else if (dir == 1) {
                this.getLOIManagerCoronal().setDirty(true);
            } else if (dir == 2) {
                this.getLOIManagerSagittal().setDirty(true);
            }
            this.labelChanged();
        } else if (roi instanceof POI) {
            POI point = (POI)roi;
            point.setName(label);
            this.getPOIManager().setDirty(true);
            this.labelChanged();
        }
        this.setShowLabels(true);
    }

    public void setLoadedURI(URI uri) {
        this.loadedURI = uri;
    }

    public void setLowerLeftSliceNumber(int sliceNum) {
        this.lowerImageLeft.setCurrentSlice(sliceNum);
        if (this.getLowerLeftSliceType() == 0) {
            this.coronalImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
            this.sagittalImage.setCrosshairPosition(this.coronalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
        } else if (this.getLowerLeftSliceType() == 1) {
            this.axialImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.coronalImage.getCurrentSlice());
            this.sagittalImage.setCrosshairPosition(this.coronalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
        } else if (this.getLowerLeftSliceType() == 2) {
            this.axialImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.coronalImage.getCurrentSlice());
            this.coronalImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
        }
    }

    public void setLowerRightSliceNumber(int sliceNum) {
        this.lowerImageRight.setCurrentSlice(sliceNum);
        if (this.getLowerRightSliceType() == 0) {
            this.coronalImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
            this.sagittalImage.setCrosshairPosition(this.coronalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
        } else if (this.getLowerRightSliceType() == 1) {
            this.axialImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.coronalImage.getCurrentSlice());
            this.sagittalImage.setCrosshairPosition(this.coronalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
        } else if (this.getLowerRightSliceType() == 2) {
            this.axialImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.coronalImage.getCurrentSlice());
            this.coronalImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
        }
    }

    public void setMainSliceDirection(int sliceType) {
        if (this.mainImage.getSliceDirection() != sliceType) {
            boolean mainShow = this.mainImage.isShowCrosshairs();
            boolean leftShow = this.lowerImageLeft.isShowCrosshairs();
            boolean rightShow = this.lowerImageLeft.isShowCrosshairs();
            if (sliceType == 0) {
                this.mainImage = this.axialImage;
                this.lowerImageLeft = this.coronalImage;
                this.lowerImageRight = this.sagittalImage;
            } else if (sliceType == 1) {
                this.mainImage = this.coronalImage;
                this.lowerImageLeft = this.sagittalImage;
                this.lowerImageRight = this.axialImage;
            } else {
                this.mainImage = this.sagittalImage;
                this.lowerImageLeft = this.axialImage;
                this.lowerImageRight = this.coronalImage;
            }
            this.mainImage.setShowCrosshairs(mainShow);
            this.lowerImageLeft.setShowCrosshairs(leftShow);
            this.lowerImageRight.setShowCrosshairs(rightShow);
            this.mainImage.setMainImageState(true, false, false);
            this.lowerImageLeft.setMainImageState(false, true, false);
            this.lowerImageRight.setMainImageState(false, false, true);
            this.calculateScreenSliceTransforms();
            this.toolBox.updateMouseLabelOutOfBounds();
            this.calculateScreenSliceTransforms();
            this.updateScreenSlices();
            this.updateROISlices();
            this.repaint();
        }
    }

    public boolean setMainSliceNumber(int sliceNum) {
        boolean changed = false;
        if (sliceNum != this.mainImage.getCurrentSlice() && (changed = this.mainImage.setCurrentSlice(sliceNum))) {
            if (this.getMainSliceType() == 0) {
                this.coronalImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
                this.sagittalImage.setCrosshairPosition(this.coronalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
            } else if (this.getMainSliceType() == 1) {
                this.axialImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.coronalImage.getCurrentSlice());
                this.sagittalImage.setCrosshairPosition(this.coronalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
            } else if (this.getMainSliceType() == 2) {
                this.axialImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.coronalImage.getCurrentSlice());
                this.coronalImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
            }
            this.repaint();
            this.updateSync();
        }
        return changed;
    }

    public void setMainSlicePosition(int sliceNum) {
        this.setMainSliceNumber(sliceNum);
    }

    public void setMenuOption(final String name, final boolean value) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (name.equals("Orientation")) {
                    SliceViewer.this.setViewOptionOrientation(value);
                } else if (name.equals("Ruler")) {
                    SliceViewer.this.setViewOptionRuler(value);
                } else if (name.equals("Angle")) {
                    SliceViewer.this.setViewOptionAngle(value);
                } else if (name.equals("Main Crosshairs")) {
                    SliceViewer.this.setViewOptionMainCrosshairs(value);
                } else if (name.equals("Lower Crosshairs")) {
                    SliceViewer.this.setViewOptionLowerCrosshairs(value);
                } else if (name.equals("ROI Edge")) {
                    SliceViewer.this.setViewOptionROIEdge(value);
                } else if (name.equals("ROI Mask")) {
                    SliceViewer.this.setViewOptionROIMask(value);
                } else if (name.equals("ROI Slice Stats")) {
                    SliceViewer.this.setViewOptionROIStats(value);
                } else if (name.equals("Labels")) {
                    SliceViewer.this.setViewOptionLabels(value);
                } else if (name.equals("Current Overlay")) {
                    SliceViewer.this.setViewOptionShowCurrentOverlay(value);
                } else if (name.equals("All Overlays")) {
                    SliceViewer.this.setViewOptionShowAllOverlays(value);
                } else if (name.equals("Slice")) {
                    SliceViewer.this.setViewOptionDisplaySlice();
                } else if (name.equals("Orthogonal (Wide)")) {
                    SliceViewer.this.setViewOptionDisplayOrthoWide();
                } else if (name.equals("Orthogonal (Tall)")) {
                    SliceViewer.this.setViewOptionDisplayOrthoTall();
                } else {
                    SliceViewer.this.doClickMenuItem(name);
                }
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void setMetaKeyMode(boolean on) {
        if (on) {
            if (!this.isROIMode()) {
                this.toolBox.setSelectionMode(1);
                this.setSpecialNavFunctionPrimed(true);
            }
        } else {
            this.clearKeyboardMode();
        }
    }

    public void setNavigationDisabled(boolean bool) {
        this.navigationDisabled = bool;
    }

    public void setNavigationDisabledState(boolean bool) {
        this.setNavigationDisabled(bool);
    }

    public void setNotes(String text) {
        this.volume.setImageDescription(text);
        this.updateViewer();
    }

    public void setOrientationCertainty(int val) {
        this.orientationCertainty = val;
    }

    public void setOrigin(Coordinate origin) {
        this.volume.setOrigin(origin);
        this.volData.updateOrigin();
    }

    public void setOriginalSliceNumber(int sliceNum) {
        char sliceDir = this.volume.getOrientationString().charAt(2);
        if (sliceDir == 'X') {
            this.setSagittalSliceNumber(sliceNum);
        } else if (sliceDir == 'Y') {
            this.setCoronalSliceNumber(sliceNum);
        } else {
            this.setAxialSliceNumber(sliceNum);
        }
        this.updateViewer();
    }

    public void setOriginTo(Coordinate coor) {
        this.volume.setOrigin(coor);
    }

    public void setOrthoWide(boolean orthoWide) {
        this.orthoWide = orthoWide;
    }

    public void setOverlayGroupScreenMax(double val) {
        ScreenVolume[] overlays;
        for (ScreenVolume overlay : overlays = this.overlayManager.getAllOverlays()) {
            if (overlay == null) continue;
            overlay.setScreenMax(val);
        }
    }

    public void setOverlayGroupScreenMin(double val) {
        ScreenVolume[] overlays;
        for (ScreenVolume overlay : overlays = this.overlayManager.getAllOverlays()) {
            if (overlay == null) continue;
            overlay.setScreenMin(val);
        }
    }

    public void setPanAmountX(int val) {
        this.panAmountX = val;
    }

    public void setPanAmountY(int val) {
        this.panAmountY = val;
    }

    public void setPanAmountZ(int val) {
        this.panAmountZ = val;
    }

    public void setPixelMode(boolean on) {
        this.voxelDisplayMode = on;
        this.forceImageUpdate();
        this.updateScreenSlices();
    }

    public void setPreviewPosition(int startX, int sizeX, int startY, int sizeY, int startZ, int sizeZ, double sliceSizeX, double sliceSizeY, double sliceSizeZ) {
        double xSize = this.volume.getXSize();
        double ySize = this.volume.getYSize();
        double zSize = this.volume.getZSize();
        int xStart = (int)Math.round((double)startX * sliceSizeX / xSize);
        int yStart = (int)Math.round((double)startY * sliceSizeY / ySize);
        int zStart = (int)Math.round((double)startZ * sliceSizeZ / zSize);
        int xEnd = xStart + (int)Math.round((double)sizeX * sliceSizeX / xSize);
        int yEnd = yStart + (int)Math.round((double)sizeY * sliceSizeY / ySize);
        int zEnd = zStart + (int)Math.round((double)sizeZ * sliceSizeZ / zSize);
        this.axialImage.setPreviewPosition(xStart, xEnd, yStart, yEnd, sliceSizeX);
        this.coronalImage.setPreviewPosition(xStart, xEnd, zStart, zEnd, sliceSizeZ);
        this.sagittalImage.setPreviewPosition(yStart, yEnd, zStart, zEnd, sliceSizeY);
    }

    public void setProjection(ProjectionFrame projection) {
        this.projection = projection;
    }

    public void setRoiColor(final int color) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.setROIColor(color);
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void setROIColor(int num) {
        if (num >= 0 && num < this.roiManager.getMaximumColors()) {
            this.roiManager.setCurrentROI(num);
            this.updateViewer();
        }
        this.toolBox.updateMangoColorButton();
    }

    public void setROIFile(URI uri) {
        if (FileUtilities.uriIsFile((URI)uri)) {
            this.roiFileGZIP = new File(uri);
        }
    }

    public void setROITool(int num) {
        this.toolBox.setROIEditMode(num);
    }

    public void setSagittalSliceNumber(int sliceNum) {
        this.sagittalImage.setCurrentSlice(sliceNum);
        this.axialImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.coronalImage.getCurrentSlice());
        this.coronalImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
    }

    public void setSaveAsAfterRangeUpdate(FileSaveAsChooser fsac) {
        this.saveAsAfterRangeUpdate = fsac;
    }

    public void setScriptObjectName(String recordableName) {
        this.recordableName = recordableName;
    }

    public void setScriptResult(Object scriptResult) {
        this.scriptResult = scriptResult;
    }

    public void setScrollwheelDirectionFlip(boolean scrollwheelDirectionFlip) {
        this.scrollwheelDirectionFlip = scrollwheelDirectionFlip;
    }

    public void setScrollwheelslices(boolean bool) {
        this.scrollwheelSlices = bool;
    }

    public void setSelectedCoordinateSpaceTransform(ImageVolume iv, int val) {
        ((Volume)iv).setSelectedCoordinateSpaceTransform(val);
        if (iv == this.volume) {
            this.getBaseScreenVolume().getOrigin().setValues(this.volume.getOrigin());
        } else {
            ScreenVolume sv = this.findOverlay((Volume)iv);
            if (sv != null) {
                sv.getOrigin().setValues(this.volume.getOrigin());
            }
        }
    }

    public void setShiftKeyMode(boolean on) {
        if (on) {
            if (!this.isROIMode()) {
                this.toolBox.setSelectionMode(4);
                this.setSpecialNavFunctionPrimed(true);
            }
        } else {
            this.clearKeyboardMode();
        }
    }

    public void setShowAllOverlay(boolean bool) {
        this.showAllOverlay = bool;
    }

    public void setShowCrosssectionMarker(boolean bool) {
        this.axialImage.setShowCrosssectionMarker(bool);
        this.coronalImage.setShowCrosssectionMarker(bool);
        this.sagittalImage.setShowCrosssectionMarker(bool);
        this.mainImage.repaint();
    }

    public void setShowCurrentOverlay(boolean bool) {
        this.showCurrentOverlay = bool;
    }

    public void setShowDicomOverlay(boolean showDicomOverlay) {
        this.setViewOptionDicomOverlay(showDicomOverlay);
    }

    public void setShowHistogram(boolean bool) {
        this.axialImage.setShowHistogram(bool);
        this.coronalImage.setShowHistogram(bool);
        this.sagittalImage.setShowHistogram(bool);
    }

    @Override
    public void setShowLabels(boolean showLabels) {
        this.setViewOptionLabels(showLabels);
    }

    public void setShowLowerCrosshairs(boolean bool) {
        this.setViewOptionLowerCrosshairs(bool);
    }

    public void setShowMainCrosshairs(boolean bool) {
        this.setViewOptionMainCrosshairs(bool);
    }

    public void setShowPreview(boolean bool) {
        this.axialImage.setShowPreview(bool);
        this.coronalImage.setShowPreview(bool);
        this.sagittalImage.setShowPreview(bool);
    }

    @Override
    public void setShowROI(boolean bool) {
        this.setViewOptionROIEdge(bool);
    }

    public void setSliceDirection(final int sliceType) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.setMainSliceDirection(sliceType);
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public boolean setSliceNumber(final int sliceNum) {
        final boolean[] changed = new boolean[1];
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                changed[0] = SliceViewer.this.setMainSliceNumber(sliceNum);
            }
        });
        return changed[0];
    }

    public void setSmallROIToolSize(boolean on) {
        if (on) {
            this.mango.setRoiToolSizeMultiplier(0.25);
            this.mainImage.updateStructureElement();
            if (this.mainImage.isPressed()) {
                this.mainImage.doROIFill();
            }
            this.mainImage.repaint();
        } else {
            this.mango.setRoiToolSizeMultiplier(1.0);
            this.mainImage.updateStructureElement();
            if (this.mainImage.isPressed()) {
                this.mainImage.doROIFill();
            }
            this.mainImage.repaint();
        }
    }

    public void setSpecialNavFunctionPrimed(boolean specialNavFunctionPrimed) {
        this.specialNavFunctionPrimed = specialNavFunctionPrimed;
    }

    public final void setStartLocation(Point startLocation) {
        this.startLocation = startLocation;
    }

    public void setStartPanLocation(int xLoc, int yLoc, int sliceDirection) {
        if (this.zoomFactor > 1.0) {
            if (sliceDirection == 0) {
                this.panLocX = xLoc;
                this.panLocY = yLoc;
                this.panLocZ = this.getAxialSliceNumber();
            } else if (sliceDirection == 1) {
                this.panLocX = xLoc;
                this.panLocY = this.getCoronalSliceNumber();
                this.panLocZ = yLoc;
            } else if (sliceDirection == 2) {
                this.panLocX = this.getSagittalSliceNumber();
                this.panLocY = xLoc;
                this.panLocZ = yLoc;
            }
        }
    }

    public final void setStartSize(Dimension startSize) {
        this.startSize = startSize;
    }

    public void setStopPaintingState(boolean bool) {
        this.stopPainting = bool;
    }

    public void setSurfaceTextureImage(BufferedImage bia, BufferedImage bic, BufferedImage bis) {
        this.axialImage.setTextureImage(bia);
        this.coronalImage.setTextureImage(bic);
        this.sagittalImage.setTextureImage(bis);
    }

    public void setToMultiSliceMode() {
        this.singleSliceMode = false;
        this.orthoSliceMode = false;
        this.orthoWide = false;
        this.setShowMainCrosshairs(false);
        this.mainImage.setShowCrosshairs(false);
        this.frame.changeSize(this.frame.getWidth());
        this.calculateScreenSliceTransforms();
        this.updateViewer();
    }

    public void setTransformManualPanel(EditTransformTool panel) {
        this.transformManualPanel = panel;
    }

    public void setTransformMode(final boolean transform) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.getBaseScreenVolume().setUsingTransform(transform);
                SliceViewer.this.mango.getToolBox().updateAfterTransformModeChange();
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void setViewerHideROI(boolean bool) {
        this.hideROI = bool;
    }

    public void setViewerLocation(Point aPoint) {
        this.frame.setLocation(aPoint.x, aPoint.y);
    }

    public void setViewerSize(int val) {
        this.frame.changeSize(val);
    }

    public void setViewOptionAngle(boolean show) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Angle"), ScriptUtils.convertBoolean(show)});
        if (show) {
            if (this.angleShape == null) {
                Line2D.Double startLine = new Line2D.Double(0.0, 0.0, 1.0, 1.0);
                this.angleShape = new LOIOrthogonal(startLine.getPathIterator(null), 0, 4, this, this);
                this.angleShape.getPoints().add(new Point(2, 2));
                this.initializeAngle();
                this.axialImage.setAngleShape(this.angleShape);
                this.coronalImage.setAngleShape(this.angleShape);
                this.sagittalImage.setAngleShape(this.angleShape);
            }
            this.angleShape.setSliceDirection(this.getMainSliceDirection());
        }
        this.showLineAngle = show;
        this.axialImage.setShowLineAngle(this.showLineAngle);
        this.coronalImage.setShowLineAngle(this.showLineAngle);
        this.sagittalImage.setShowLineAngle(this.showLineAngle);
        this.repaint();
    }

    public void setViewOptionDicomOverlay(boolean showDicomOverlay) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Annotations"), ScriptUtils.convertBoolean(showDicomOverlay)});
        this.showDicomOverlay = showDicomOverlay;
        this.mango.setViewDicomOverlay(showDicomOverlay);
        this.clearDicomOverlay();
        this.updateViewer();
    }

    public void setViewOptionDisplayOrthoTall() {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Orthogonal (Tall)"), "True"});
        int size = 0;
        size = this.orthoWide ? this.getHeight() : this.getWidth();
        this.singleSliceMode = false;
        this.orthoSliceMode = true;
        this.orthoWide = false;
        this.mango.setViewMode(0);
        this.frame.changeSize(size);
        this.calculateScreenSliceTransforms();
        this.updateViewer();
    }

    public void setViewOptionDisplayOrthoWide() {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Orthogonal (Wide)"), "True"});
        this.singleSliceMode = false;
        this.orthoSliceMode = false;
        this.orthoWide = true;
        this.mango.setViewMode(1);
        this.frame.changeSize(this.frame.getWidth());
        this.calculateScreenSliceTransforms();
        this.updateViewer();
    }

    public void setViewOptionDisplaySlice() {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Slice"), "True"});
        int size = 0;
        size = this.orthoWide ? this.getHeight() : this.getWidth();
        this.singleSliceMode = true;
        this.orthoSliceMode = false;
        this.orthoWide = false;
        this.mango.setViewMode(2);
        this.frame.changeSize(size);
        this.calculateScreenSliceTransforms();
        this.updateViewer();
    }

    public void setViewOptionLabels(boolean showLabels) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Labels"), ScriptUtils.convertBoolean(showLabels)});
        this.showLabels = showLabels;
        this.mango.setViewLabels(showLabels);
        this.updateViewer();
    }

    public void setViewOptionLowerCrosshairs(boolean showLowerCrosshairs) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Lower Crosshairs"), ScriptUtils.convertBoolean(showLowerCrosshairs)});
        this.showLowerCrosshairs = showLowerCrosshairs;
        this.lowerImageLeft.setShowCrosshairs(showLowerCrosshairs);
        this.lowerImageRight.setShowCrosshairs(showLowerCrosshairs);
        this.mango.setViewLowerCrosshairs(showLowerCrosshairs);
        this.repaint();
    }

    public void setViewOptionMainCrosshairs(boolean showMainCrosshairs) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Main Crosshairs"), ScriptUtils.convertBoolean(showMainCrosshairs)});
        this.showMainCrosshairs = showMainCrosshairs;
        this.mainImage.setShowCrosshairs(showMainCrosshairs);
        this.mango.setViewMainCrosshairs(showMainCrosshairs);
        this.repaint();
    }

    public void setViewOptionOrientation(boolean showOrientation) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Orientation"), ScriptUtils.convertBoolean(showOrientation)});
        this.showOrientation = showOrientation;
        this.axialImage.setShowOrientation(showOrientation);
        this.coronalImage.setShowOrientation(showOrientation);
        this.sagittalImage.setShowOrientation(showOrientation);
        this.mango.setViewOrientation(showOrientation);
        this.repaint();
    }

    public void setViewOptionROIEdge(boolean showROIEdge) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("ROI Edge"), ScriptUtils.convertBoolean(showROIEdge)});
        this.showROIEdge = showROIEdge;
        this.mango.setViewROIEdge(showROIEdge);
        if (showROIEdge) {
            this.hideROI = false;
        }
        this.updateViewer();
        this.updateSurface();
    }

    public void setViewOptionROIMask(boolean showROIMask) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("ROI Mask"), ScriptUtils.convertBoolean(showROIMask)});
        this.showROIMask = showROIMask;
        this.mango.setViewROIMask(showROIMask);
        if (showROIMask) {
            this.hideROI = false;
        }
        this.updateViewer();
        this.updateSurface();
    }

    public void setViewOptionROIStats(boolean showROISliceStats) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("ROI Slice Stats"), ScriptUtils.convertBoolean(showROISliceStats)});
        this.showROISliceStats = showROISliceStats;
        this.mango.setViewROIStats(showROISliceStats);
        this.updateViewer();
    }

    public void setViewOptionRuler(boolean show) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Ruler"), ScriptUtils.convertBoolean(show)});
        if (show) {
            if (this.rulerShape == null) {
                Line2D.Double startLine = new Line2D.Double(0.0, 0.0, 1.0, 1.0);
                this.rulerShape = new LOIOrthogonal(startLine.getPathIterator(null), 0, 5, this, this);
                this.initializeRuler();
                this.axialImage.setRulerShape(this.rulerShape);
                this.coronalImage.setRulerShape(this.rulerShape);
                this.sagittalImage.setRulerShape(this.rulerShape);
            }
            this.rulerShape.setSliceDirection(this.getMainSliceDirection());
        }
        this.showLineLength = show;
        this.axialImage.setShowLineLength(this.showLineLength);
        this.coronalImage.setShowLineLength(this.showLineLength);
        this.sagittalImage.setShowLineLength(this.showLineLength);
        this.repaint();
    }

    public void setViewOptionShowAllOverlays(boolean showAllOverlay) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("All Overlays"), ScriptUtils.convertBoolean(showAllOverlay)});
        this.setShowOverlay(false, showAllOverlay);
    }

    public void setViewOptionShowCurrentOverlay(boolean showCurrentOverlay) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Current Overlay"), ScriptUtils.convertBoolean(showCurrentOverlay)});
        this.setShowOverlay(showCurrentOverlay, false);
    }

    public void setVolume(Volume volume) {
        if (this.volume != null) {
            this.volume = volume;
            volume.setUser(this);
            volume.addListener(this);
            volume.setLabelListener(this);
            URI loadingURI = null;
            try {
                loadingURI = File.createTempFile("temp", null, Platform.getTempDir()).toURI();
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
            try {
                volume.readLabelData();
            }
            catch (UnsupportedEncodingException ex) {
                AppLogger.error((Throwable)ex);
            }
            this.setLoadedURI(loadingURI);
            volume.setProgressBarListener(this.toolBox);
            this.setOrientationCertainty(volume.getOrientationCertainty());
            this.setLongestDim();
            this.baseScreenVolume = new ScreenVolume(volume, this.getLoadedURI(), "Grayscale", true);
            VolumeRangeOp rangeOp = new VolumeRangeOp(this, volume);
            OperationBuilder<Range> builder = new OperationBuilder<Range>(this, rangeOp);
            Range range = builder.runSynchronously();
            volume.updateMaxMin(range.getMax(), range.getMin());
            this.initializeViewer(true);
        } else {
            AppLogger.error((String)"volume already exists!");
        }
    }

    public void setVolumeDisplayAlpha(final ImageVolume volume, final double alpha) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.toolBox.setAlpha(SliceViewer.this.findOverlay((Volume)volume), alpha);
                SliceViewer.this.updateViewer();
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void setVolumeDisplayColorTable(final ImageVolume volume, final String colorTable) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ScreenVolume screenVol = SliceViewer.this.findOverlay((Volume)volume);
                if (screenVol == null) {
                    screenVol = SliceViewer.this.getBaseScreenVolume();
                }
                if (screenVol == SliceViewer.this.getBaseScreenVolume()) {
                    SliceViewer.this.mango.getToolBox().doOverlayButtonChosen(0);
                } else {
                    SliceViewer.this.mango.getToolBox().doOverlayButtonChosen(SliceViewer.this.overlayManager.getIndex(screenVol) + 1);
                }
                SliceViewer.this.toolBox.setLUT(colorTable);
                SliceViewer.this.updateViewer();
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void setVolumeDisplayHidden(final ImageVolume volume, final boolean hidden) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ScreenVolume screenVol = SliceViewer.this.findOverlay((Volume)volume);
                screenVol.setHidden(hidden);
                SliceViewer.this.toolBox.updateHidden();
                SliceViewer.this.updateViewer();
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void setVolumeDisplayIndex(final ImageVolume volume, final int index) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (volume != SliceViewer.this.getBaseVolume()) {
                    ScreenVolume screenVol = SliceViewer.this.findOverlay((Volume)volume);
                    SliceViewer.this.overlayManager.setOverlayIndex(screenVol, index - 1);
                    SliceViewer.this.setCurrentScreenVolume(screenVol);
                    screenVol.setHidden(false);
                    SliceViewer.this.mango.getToolBox().updateAfterOverlayIndexChange();
                }
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void setVolumeDisplayRange(final ImageVolume volume, final double screenMin, final double screenMax) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ScreenVolume screenVol = SliceViewer.this.findOverlay((Volume)volume);
                if (screenVol == null) {
                    screenVol = SliceViewer.this.getBaseScreenVolume();
                }
                screenVol.setScreenMin(screenMin);
                screenVol.setScreenMax(screenMax);
                SliceViewer.this.toolBox.updateTextFields();
                SliceViewer.this.updateViewer();
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void setVoxelDisplayMode(boolean voxelDisplayMode) {
        this.voxelDisplayMode = voxelDisplayMode;
    }

    public void setVoxelValue(Coordinate coor, int seriesPoint, double value) {
        this.volume.putVoxelValueAtIndex(coor.xInt, coor.yInt, coor.zInt, seriesPoint, value);
        if (value > this.baseScreenVolume.getScreenMax()) {
            this.baseScreenVolume.setScreenMax(value);
        } else if (value < this.baseScreenVolume.getScreenMin()) {
            this.baseScreenVolume.setScreenMin(value);
        }
        this.volume.setImageAsDirty();
        this.forceImageUpdate();
        this.updateViewer();
    }

    public void setZoomFactor(double originalVal, boolean sync) {
        double val = originalVal;
        if (val > 10.0) {
            val = 10.0;
        } else if (val < 1.0) {
            val = 1.0;
        }
        if (!MathUtilities.essentiallyEqual((double)this.zoomFactor, (double)val)) {
            this.zoomFactor = val;
            if (this.zoomFactor == 1.0) {
                this.panAmountZ = 0;
                this.panAmountY = 0;
                this.panAmountX = 0;
                this.zoomFactorPrevious = 1.0;
            }
            this.forceImageUpdate();
            this.axialImage.updateTransforms();
            this.coronalImage.updateTransforms();
            this.sagittalImage.updateTransforms();
            this.updateViewer();
            this.updateROISlices();
            this.repaint();
        }
        if (sync && this.viewerSyncer.isZoom()) {
            this.viewerSyncer.syncZoom(this);
        }
    }

    public void setZoomFactorPrevious(double val) {
        this.zoomFactorPrevious = val;
    }

    public void setZoomLocation(int xLoc, int yLoc, int sliceDirection) {
        if (this.zoomFactor == 1.0) {
            if (sliceDirection == 0) {
                this.zoomLocX = xLoc;
                this.zoomLocY = yLoc;
                this.zoomLocZ = this.getAxialSliceNumber();
            } else if (sliceDirection == 1) {
                this.zoomLocX = xLoc;
                this.zoomLocY = this.getCoronalSliceNumber();
                this.zoomLocZ = yLoc;
            } else if (sliceDirection == 2) {
                this.zoomLocX = this.getSagittalSliceNumber();
                this.zoomLocY = xLoc;
                this.zoomLocZ = yLoc;
            }
            this.axialImage.updateTransforms();
            this.coronalImage.updateTransforms();
            this.sagittalImage.updateTransforms();
        }
    }

    public void setZoomLocation() {
        if (this.zoomFactor == 1.0) {
            Coordinate coor = this.getCurrentIndex();
            this.zoomLocX = coor.xInt;
            this.zoomLocY = coor.yInt;
            this.zoomLocZ = coor.zInt;
        }
    }

    @Override
    public void shapeAdded(LOIShape shape) {
        this.shapeAdded(shape, true);
    }

    @Override
    public void shapeChanged(LOIShape aShape) {
        if (this.crosssection.getParentFrame() != null) {
            this.crosssection.shapeChanged(aShape);
        }
        if (this.timeseries.getParentFrame() != null) {
            ((TimeseriesTool)this.timeseries.getParentFrame()).roiChanged(aShape);
        }
        if (this.surfaceRender != null && this.surfaceRender.isSyncingShapes()) {
            this.surfaceRender.updateROILine(aShape);
        }
    }

    @Override
    public void shapeDeleted(LOIShape shape) {
        this.shapeDeleted(shape, true);
    }

    @Override
    public void shapeLabelChanged(LOIShape shape) {
        if (this.roiInspector != null && this.roiInspector.isVisible()) {
            this.roiInspector.updateLabels();
        }
    }

    @Override
    public void shapeSelectionChanged() {
        if (this.crosssection.getParentFrame() != null) {
            this.crosssection.shapeSelectionChanged();
        }
        if (this.timeseries.getParentFrame() != null) {
            ((TimeseriesTool)this.timeseries.getParentFrame()).selectionChanged();
        }
    }

    public void showAddROIDialog() {
        AddROIDialog dialog = new AddROIDialog(this);
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.getViewerFrame(), (Object)dialog, "Add ROI", -1);
        int selection = jopf.show();
        if (selection == 0) {
            this.doActionAddShapeROI(dialog.getShapeSize(), dialog.isCube(), dialog.isSphere());
            String labelText = dialog.getLabelText();
            if (StringUtils.isNotBlank((CharSequence)labelText)) {
                this.setLabel(this.roiManager.getROI(this.roiManager.getCurrentROI()), labelText);
            }
        }
    }

    public void showCloseROIDialog() {
        SimpleDialog dialog = new SimpleDialog(TEXT_SIZE, String.valueOf(this.getROIManager().getKernelSize()));
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.getViewerFrame(), (Object)dialog, "Close ROI", 3);
        int selection = jopf.show();
        if (selection == 0) {
            try {
                int kernel = Integer.parseInt(dialog.getResult());
                kernel = kernel / 2 * 2 + 1;
                this.getROIManager().setKernelSize(kernel);
                if (this.isMultiSliceMode()) {
                    this.doActionCloseSelected3D(kernel);
                } else {
                    this.doActionClose2D(this.getMainSliceNumber(), this.getMainSliceDirection(), kernel);
                }
            }
            catch (NumberFormatException ex) {
                AppLogger.info((Throwable)ex);
            }
        }
    }

    public void showClusterAnalysisTool() {
        ClusterAnalysisTool ca = this.getClusterAnalysis();
        if (ca == null) {
            ca = this.makeClusterAnalysis();
        }
        ca.setVisible(true);
        ca.toFront();
    }

    public void showCrosssectionTool() {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Cross-section")});
        Crosssection crosssection = this.getCrosssection();
        if (crosssection != null) {
            JFrame dialog = crosssection.getParentFrame();
            if (dialog == null) {
                new CrosssectionTool(this.mango, this);
            } else {
                dialog.toFront();
            }
        }
    }

    public void showDilateDialog() {
        SimpleDialog dialog = new SimpleDialog(TEXT_SIZE, String.valueOf(this.getROIManager().getKernelSize()));
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.getViewerFrame(), (Object)dialog, "Dilate ROI", 3);
        int selection = jopf.show();
        if (selection == 0) {
            try {
                int kernel = Integer.parseInt(dialog.getResult());
                kernel = kernel / 2 * 2 + 1;
                this.getROIManager().setKernelSize(kernel);
                if (this.isMultiSliceMode()) {
                    this.doActionDilateSelected3D(kernel);
                } else {
                    this.doActionDilateSelected2D(this.getMainSliceNumber(), this.getMainSliceDirection(), kernel);
                }
            }
            catch (NumberFormatException ex) {
                AppLogger.info((Throwable)ex);
            }
        }
    }

    public void showErodeDialog() {
        SimpleDialog dialog = new SimpleDialog(TEXT_SIZE, String.valueOf(this.getROIManager().getKernelSize()));
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.getViewerFrame(), (Object)dialog, "Erode ROI", 3);
        int selection = jopf.show();
        if (selection == 0) {
            try {
                int kernel = Integer.parseInt(dialog.getResult());
                kernel = kernel / 2 * 2 + 1;
                this.getROIManager().setKernelSize(kernel);
                if (this.isMultiSliceMode()) {
                    this.doActionErodeSelected3D(kernel);
                } else {
                    this.doActionErodeSelected2D(this.getMainSliceNumber(), this.getMainSliceDirection(), kernel);
                }
            }
            catch (NumberFormatException ex) {
                AppLogger.info((Throwable)ex);
            }
        }
    }

    @Override
    public void showErrorDialog(String message, String title) {
        this.mango.showErrorDialog(message, title);
    }

    public void showErrorMessage(String message, String title) {
        this.showErrorDialog(message, title);
    }

    public void showFile() {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Show File")});
        URI uri = this.getCurrentScreenVolume().getURI();
        if (FileUtilities.uriIsFile((URI)uri)) {
            DesktopUtilities.revealAndSelect((File)new File(uri));
        }
    }

    public void showHistogramTool(boolean runAuto) {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Histogram")});
        HistogramPanel histogram = this.getHistogram();
        if (histogram != null) {
            HistogramTool dialog = (HistogramTool)histogram.getParentFrame();
            if (dialog == null) {
                new HistogramTool(this.mango, this, runAuto);
            } else {
                dialog.toFront();
                if (runAuto) {
                    dialog.run();
                }
            }
        }
    }

    public void showImageCalculatorDialog() {
        VolumeManager[] openVolumesList = this.mango.getCompatibleOpenVolumeManagers(64, this);
        if (this.imageCalc != null) {
            this.imageCalc.getFrame().setVisible(false);
            this.imageCalc.getFrame().dispose();
            this.imageCalc = null;
        }
        this.imageCalc = new ImageCalculatorTool(this.mango, this, openVolumesList);
    }

    public void showImageInfoDialog() {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Image Info")});
        if (this.imageInfo == null) {
            this.imageInfo = new ImageInfoDialog(this, this.getScreenVolume());
        }
        this.imageInfo.setVisible(true);
    }

    public void showLayoutTool(boolean silent) {
        this.layout = new Layout(this.mango, this, silent);
    }

    public void showLogicalManager(boolean preventProcessOnOpen) {
        LogicalAnalysisTool logicalManager = this.getLogicalManager();
        if (logicalManager == null) {
            logicalManager = this.makeLogicalManager();
        }
        logicalManager.setPreventProcessOnOpen(preventProcessOnOpen);
        logicalManager.setVisible(true);
        logicalManager.toFront();
    }

    public void showOpenROIDialog() {
        SimpleDialog dialog = new SimpleDialog(TEXT_SIZE, String.valueOf(this.getROIManager().getKernelSize()));
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.getViewerFrame(), (Object)dialog, "Open ROI", 3);
        int selection = jopf.show();
        if (selection == 0) {
            try {
                int kernel = Integer.parseInt(dialog.getResult());
                kernel = kernel / 2 * 2 + 1;
                this.getROIManager().setKernelSize(kernel);
                if (this.isMultiSliceMode()) {
                    this.doActionOpenSelected3D(kernel);
                } else {
                    this.doActionOpen2D(this.getMainSliceNumber(), this.getMainSliceDirection(), kernel);
                }
            }
            catch (NumberFormatException ex) {
                AppLogger.info((Throwable)ex);
            }
        }
    }

    public void showOverlayOntoDialog() {
        SliceViewer[] compatible = Mango.getAllSliceViewers(this, false);
        OverlayOntoDialog dialog = new OverlayOntoDialog(this, compatible);
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.getViewerFrame(), dialog, "Overlay Onto", -1, null);
        int selection = jopf.show();
        if (selection == 0) {
            this.recordAction("addOverlayOnto", new String[]{null, ScriptUtils.convertString(dialog.getLookupTable())}, true);
            SliceViewer baseViewer = dialog.getViewer();
            if (baseViewer != null) {
                baseViewer.frameToFront();
                baseViewer.loadOverlayScreenVolume(this.getVolume(), this.getLoadedURI(), dialog.getLookupTable(), dialog.isCloseViewerSelected() ? this : null, false, false);
            }
        }
    }

    public void showPropagateROIDialog() {
        int sliceDirection = this.getMainSliceDirection();
        int sliceIndex = this.getMainSlicePosition();
        int slices = 0;
        if (sliceDirection == 0) {
            slices = this.getVolume().getImageDimensions().getZ();
        } else if (sliceDirection == 1) {
            slices = this.getVolume().getImageDimensions().getY();
        } else if (sliceDirection == 2) {
            slices = this.getVolume().getImageDimensions().getX();
        }
        PropagateROIDialog dialog = new PropagateROIDialog(slices, sliceIndex, sliceDirection);
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.getViewerFrame(), (Object)dialog, "Propagate ROI", 3);
        int selection = jopf.show();
        if (selection == 0) {
            this.doActionPropogateROI(dialog.getStartSlice(), dialog.getEndSlice());
        }
    }

    public void showRankFilterDialog() {
        RankFilterDialog dialog = new RankFilterDialog();
        MangoFocusableOptionPane jopf = null;
        jopf = this.mango.isApplet() ? new MangoFocusableOptionPane((MangoFocusableOptionPaneUser)((Object)Mango.getMangoApplet()), (Object)dialog, TEXT_RANK_FILTER, -1) : new MangoFocusableOptionPane(this.getFrame(), (Object)dialog, TEXT_RANK_FILTER, -1);
        int selection = jopf.show(true);
        if (selection == 0) {
            int rankType = dialog.getRankType();
            int dimType = dialog.getDimensionType();
            String sizeText = dialog.getSizeString();
            int size = 0;
            try {
                size = Integer.parseInt(sizeText);
                if (size < 0) {
                    size *= -1;
                }
                if (size % 2 == 0) {
                    ++size;
                }
            }
            catch (NumberFormatException ex) {
                AppLogger.info((Throwable)ex);
            }
            if (size >= 3) {
                AbstractFilterRank filter = null;
                if (dimType == 1) {
                    filter = new FilterRankTime(rankType, size);
                } else if (dimType == 2) {
                    filter = new FilterRankSlice(rankType, size);
                } else if (dimType == 4) {
                    filter = new FilterRankVolume(rankType, size);
                }
                this.doOperationRankFilterImage(filter);
            }
        }
    }

    public void showReflectDialog() {
        ReflectROIDialog dialog = new ReflectROIDialog(this);
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.getViewerFrame(), (Object)dialog, "Reflect ROI", -1);
        int selection = jopf.show();
        if (selection == 0) {
            if (this.isMultiSliceMode()) {
                this.doActionReflection(dialog.isVertical());
            } else {
                this.doActionReflectionSlice(dialog.isVertical());
            }
        }
    }

    public void showROIComponentAnalysisTool() {
        ClusterROIAnalysisTool ca = this.getClusterROIAnalysis();
        if (ca == null) {
            ca = this.makeClusterROIAnalysis();
        }
        ca.setVisible(true);
        ca.toFront();
    }

    public void showROIInspector() {
        ROIInspectorTool roiCounts = this.getROICounts();
        if (roiCounts == null) {
            roiCounts = this.makeROICounts();
        }
        roiCounts.setVisible(true);
        roiCounts.toFront();
    }

    public void showROILogicCalculator() {
        final ROICalculatorDialog dialog = new ROICalculatorDialog(this);
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.getViewerFrame(), dialog, "ROI Logic Calculator", -1, null);
        final JOptionPane jop = jopf.getJOptionPane();
        JButton buttonOk = new JButton("Done");
        buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jop.setValue(0);
                jop.setVisible(false);
            }
        });
        JButton buttonCalculate = new JButton("Calculate");
        buttonCalculate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (SliceViewer.this.isInWorkingState()) {
                    return;
                }
                String input = dialog.getResults();
                if (StringUtils.isNotBlank((CharSequence)input)) {
                    SliceViewer.this.recordAction("runOperationROILogic", new String[]{ScriptUtils.convertString(input), String.valueOf(dialog.getROIColor())}, true);
                    String operationString = input;
                    operationString = ROIOperationTreeNode.makeReplacements(operationString, SliceViewer.this.roiManager);
                    int operatorCountCode = ROIOperationTreeNode.hasValidNumOperators(operationString);
                    if (operatorCountCode > 0) {
                        SliceViewer.this.showErrorDialog("An operator is missing in that expression!", SliceViewer.TEXT_ROI_OPERATION_FAILED);
                    } else if (operatorCountCode < 0) {
                        SliceViewer.this.showErrorDialog("An operand is missing in that expression!", SliceViewer.TEXT_ROI_OPERATION_FAILED);
                    } else if (!ROIOperationTreeNode.isValidString(operationString)) {
                        SliceViewer.this.showErrorDialog("Invalid characters found in expression!", SliceViewer.TEXT_ROI_OPERATION_FAILED);
                    } else if (!ROIOperationTreeNode.hasValidParentheses(operationString)) {
                        SliceViewer.this.showErrorDialog("Not all parentheses close in that expression!", SliceViewer.TEXT_ROI_OPERATION_FAILED);
                    } else {
                        ROIOperationTreeNode startNode = ROIOperationTreeNode.makeOperationTree(operationString);
                        boolean isValid = ROIOperationTreeNode.isValidStartNode(startNode);
                        if (startNode == null || !isValid) {
                            SliceViewer.this.showErrorDialog("Could not process that expression!", SliceViewer.TEXT_ROI_OPERATION_FAILED);
                        } else {
                            startNode.setOriginalOperation(input);
                            if (SliceViewer.this.isMultiSliceMode()) {
                                SliceViewer.this.doOperationROI(startNode, dialog.getROIColor(), false);
                            } else {
                                SliceViewer.this.doOperationROI(startNode, dialog.getROIColor(), SliceViewer.this.getMainSliceNumber(), SliceViewer.this.getMainSliceDirection(), false);
                            }
                        }
                    }
                }
            }
        });
        Object[] options = new Object[]{buttonOk, buttonCalculate};
        jopf.setOptions(options);
        jopf.setInitialValue(buttonCalculate);
        jopf.show(true);
    }

    public void showROIStaticLabelDialog() {
        EditROILabelDialog dialog = new EditROILabelDialog(this, this.roiManager.getLabels(), 0);
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.getViewerFrame(), dialog, "Edit ROI Labels", -1, null);
        jopf.setFocusableItem(dialog);
        int selection = jopf.show();
        if (selection == 0) {
            dialog.saveLabels();
            this.roiManager.setDirty(true);
            this.labelChanged();
            this.updateViewer();
        }
    }

    public void showSeriesTool() {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Series")});
        Timeseries timeseries = this.getTimeseries();
        if (timeseries != null) {
            JFrame dialog = timeseries.getParentFrame();
            if (dialog == null) {
                new TimeseriesTool(this.mango, this);
            } else {
                dialog.toFront();
            }
        }
    }

    public void showShrinkWrapROIDialog() {
        ScreenVolume screenVol = this.getCurrentScreenVolume();
        double min = (double)screenVol.getMinLUT() / screenVol.getScreenRatio() + screenVol.getScreenMin();
        ShrinkWrapDialog dialog = new ShrinkWrapDialog(this, FORMATTER.format(min));
        MangoFocusableOptionPane optionPane = new MangoFocusableOptionPane(this.getViewerFrame(), (Object)dialog, "Shrink Wrap", -1);
        optionPane.setFocusableItem(dialog);
        int selection = optionPane.show();
        if (selection == 0) {
            double minResult = dialog.isThreshold() ? Double.parseDouble(dialog.getMin()) : -1.7976931348623157E308;
            double maxResult = Double.MAX_VALUE;
            boolean isRange = false;
            boolean isShrinkWrap = true;
            boolean isConvexHull = false;
            boolean isPercentMax = dialog.isPercentMax();
            boolean isExcludeZero = false;
            boolean isSeries = this.roiManager.isUsing4dROI();
            boolean isDynamicThreshold = dialog.isDynamicThreshold();
            int direction = dialog.getSliceDirection();
            this.roiManager.updateROIBufferSeries(isSeries);
            this.doThresholdToROI(minResult, Double.MAX_VALUE, false, true, false, isPercentMax, false, isSeries, isDynamicThreshold, direction, true, null);
        }
    }

    public void showSnapshotDialog() {
        new Snapshot(this, this);
    }

    public void showThresholdToROIDialog() {
        ScreenVolume screenVol = this.getCurrentScreenVolume();
        double min = (double)screenVol.getMinLUT() / screenVol.getScreenRatio() + screenVol.getScreenMin();
        double max = (double)screenVol.getMaxLUT() / screenVol.getScreenRatio() + screenVol.getScreenMin();
        ThresholdToROIDialog dialog = new ThresholdToROIDialog(this, FORMATTER.format(min), FORMATTER.format(max), true, true);
        MangoFocusableOptionPane optionPane = new MangoFocusableOptionPane(this.getViewerFrame(), (Object)dialog, "Threshold to ROI", -1);
        dialog.setDialog(optionPane);
        optionPane.setFocusableItem(dialog);
        int selection = optionPane.show();
        if (selection == 0) {
            double minResult = Double.parseDouble(dialog.getMin());
            double maxResult = dialog.isRange() ? Double.parseDouble(dialog.getMax()) : Double.MAX_VALUE;
            boolean isRange = dialog.isRange();
            boolean isShrinkWrap = dialog.isShrinkWrap();
            boolean isConvexHull = dialog.isConvexHull();
            boolean isPercentMax = dialog.isPercentMax();
            boolean isExcludeZero = dialog.isExcludeZero();
            boolean isSeries = dialog.isSeries();
            boolean isDynamicThreshold = dialog.isDynamicThreshold();
            int direction = dialog.getSliceDirection();
            String labelText = dialog.getLabelText();
            this.roiManager.updateROIBufferSeries(isSeries);
            this.doThresholdToROI(minResult, maxResult, isRange, isShrinkWrap, isConvexHull, isPercentMax, isExcludeZero, isSeries, isDynamicThreshold, direction, false, labelText);
        }
    }

    public void showTransformManualPanel() {
        this.baseScreenVolume.setUsingTransform(true);
        if (this.transformManualPanel == null) {
            this.transformManualPanel = new EditTransformTool(this.mango, this);
        }
        this.transformManualPanel.reconcileWithViewerTransformState();
        this.transformManualPanel.updateViewer(false);
        this.transformManualPanel.setVisible(true);
        this.transformManualPanel.toFront();
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Transform...")});
        this.mango.getToolBox().reconcileTransformButton();
    }

    @Override
    public void showWarningDialog(String message, String title) {
        this.mango.showWarningDialog(message, title);
    }

    public void showWarningMessage(String message, String title) {
        this.showWarningDialog(message, title);
    }

    public void startIndeterminateProgressBar() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (SliceViewer.this.pbIndeterminate != null) {
                    SliceViewer.this.pbIndeterminate.setValue(100);
                }
                SliceViewer.this.pbIndeterminate = new edu.uthscsa.ric.mango.components.progressbar.ProgressBar(SliceViewer.this.toolBox, "");
                SliceViewer.this.pbIndeterminate.init(0, 0, 100);
                SliceViewer.this.pbIndeterminate.setValue(1);
                SliceViewer.this.pbIndeterminate.setIndeterminateMode(true);
            }
        };
        SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
    }

    @Override
    public void surfaceFileRead(final boolean success, final Surface[] surfaces, final Vector<Shape> shapes, final String message) {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                if (success) {
                    SliceViewer.this.buildSurface(surfaces, shapes);
                } else {
                    SliceViewer.this.showErrorDialog(message, "Surface Import Error");
                }
            }
        });
    }

    @Override
    public void surfaceFileWritten(boolean success, File file, String message) {
    }

    public void toFront() {
        this.frame.toFront();
    }

    public void toggleSliceViews(boolean ccw) {
        if (this.isNavigationDisabled()) {
            return;
        }
        this.mango.clearActivePolylines();
        boolean mainShow = this.mainImage.isShowCrosshairs();
        boolean leftShow = this.lowerImageLeft.isShowCrosshairs();
        boolean rightShow = this.lowerImageLeft.isShowCrosshairs();
        if (!ccw) {
            ScreenSlice tempScreenSlice = this.mainImage;
            this.mainImage = this.lowerImageLeft;
            this.lowerImageLeft = this.lowerImageRight;
            this.lowerImageRight = tempScreenSlice;
            this.mainImage.setShowCrosshairs(mainShow);
            this.lowerImageLeft.setShowCrosshairs(leftShow);
            this.lowerImageRight.setShowCrosshairs(rightShow);
        } else {
            ScreenSlice tempScreenSlice = this.lowerImageLeft;
            this.lowerImageLeft = this.mainImage;
            this.mainImage = this.lowerImageRight;
            this.lowerImageRight = tempScreenSlice;
            this.mainImage.setShowCrosshairs(mainShow);
            this.lowerImageLeft.setShowCrosshairs(leftShow);
            this.lowerImageRight.setShowCrosshairs(rightShow);
        }
        this.recordAction("setSliceDirection", new String[]{String.valueOf(this.mainImage.getSliceDirection())});
        this.mainImage.setMainImageState(true, false, false);
        this.lowerImageLeft.setMainImageState(false, true, false);
        this.lowerImageRight.setMainImageState(false, false, true);
        if (this.isShowingRuler()) {
            this.rulerShape.setSliceDirection(this.getMainSliceDirection());
        }
        if (this.isShowingAngle()) {
            this.angleShape.setSliceDirection(this.getMainSliceDirection());
        }
        this.updateSync();
        this.toolBox.updateMouseLabelOutOfBounds();
        this.calculateScreenSliceTransforms();
        this.updateScreenSlices();
        this.updateROISlices();
        this.crosssection.shapeSelectionChanged();
        this.updateSurface();
        this.repaint();
        this.mango.setMainSliceDirection(this.mainImage.getSliceDirection());
        this.notifySliceDirectionListeners();
    }

    @Override
    public String toString() {
        return this.getImageTitle();
    }

    public void transform(ImageVolume volume, double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23, double m30, double m31, double m32, double m33) {
        double[][] mat = new double[4][4];
        mat[0][0] = m00;
        mat[0][1] = m01;
        mat[0][2] = m02;
        mat[0][3] = m03;
        mat[1][0] = m10;
        mat[1][1] = m11;
        mat[1][2] = m12;
        mat[1][3] = m13;
        mat[2][0] = m20;
        mat[2][1] = m21;
        mat[2][2] = m22;
        mat[2][3] = m23;
        mat[3][0] = m30;
        mat[3][1] = m31;
        mat[3][2] = m32;
        mat[3][3] = m33;
        ((Volume)volume).getImageTransform().updateTransform(mat);
        ScreenVolume screenVol = this.findOverlay((Volume)volume);
        if (screenVol != null) {
            this.addTransformPost();
            screenVol.setUsingTransform(!Transform.isIdentity(mat));
            this.updateViewer();
        }
    }

    public void translate(int xTrans, int yTrans) {
        if (this.mainImage.canTranslate() && !this.toolBox.isProgressBarShowing() && !this.isInWorkingState()) {
            this.resetAllClipboardsUndo();
            this.poiManager.translate(this.getMainSliceNumber(), this.getMainSliceDirection(), xTrans, yTrans, this.roiManager.getCurrentROI());
            int sd = this.getMainSliceDirection();
            if (sd == 0) {
                this.loiManagerAxial.translate(this.getMainSliceNumber(), xTrans, yTrans, this.roiManager.getCurrentROI());
            } else if (sd == 1) {
                this.loiManagerCoronal.translate(this.getMainSliceNumber(), xTrans, yTrans, this.roiManager.getCurrentROI());
            } else if (sd == 2) {
                this.loiManagerSagittal.translate(this.getMainSliceNumber(), xTrans, yTrans, this.roiManager.getCurrentROI());
            }
            boolean didOperation = this.mainImage.incrementShape(xTrans, yTrans, this.roiManager.getCurrentROI());
            if (!didOperation) {
                this.updateViewer();
            }
        }
    }

    public void updateActivePlanes(boolean updateSurface) {
        this.updateActivePlanes(false, updateSurface);
    }

    public void updateAllAccelerators(String[] actions) {
        ProjectionViewerMenu menu;
        SurfaceViewerMenu menu2;
        SurfaceFrame surfaceFrame;
        ViewerMenu aMenu;
        ViewerFrame aFrame = this.getViewerFrame();
        if (aFrame != null && (aMenu = this.frame.getViewerMenu()) != null) {
            aMenu.updateAllAccelerators(actions);
        }
        if (this.surfaceRender != null && (surfaceFrame = this.surfaceRender.getFrame()) != null && (menu2 = surfaceFrame.getMenu()) != null) {
            menu2.updateAllAccelerators(actions);
        }
        if (this.projection != null && (menu = this.projection.getMenu()) != null) {
            menu.updateAllAccelerators(actions);
        }
    }

    @Override
    public void updateAllLines() {
        if (this.surfaceRender != null && this.surfaceRender.isSyncingShapes()) {
            LOIShape[][] axialShapes = this.loiManagerAxial.getAll();
            LOIShape[][] coronalShapes = this.loiManagerCoronal.getAll();
            LOIShape[][] sagittalShapes = this.loiManagerSagittal.getAll();
            Vector<LOIShape> allShapes = new Vector<LOIShape>();
            for (LOIShape[] axialShape : axialShapes) {
                if (axialShape == null) continue;
                for (LOIShape element : axialShape) {
                    allShapes.add(element);
                }
            }
            for (LOIShape[] coronalShape : coronalShapes) {
                if (coronalShape == null) continue;
                for (LOIShape element : coronalShape) {
                    allShapes.add(element);
                }
            }
            for (LOIShape[] sagittalShape : sagittalShapes) {
                if (sagittalShape == null) continue;
                for (LOIShape element : sagittalShape) {
                    allShapes.add(element);
                }
            }
            this.surfaceRender.updateAllROILines(allShapes.toArray(new LOIShape[allShapes.size()]));
        }
    }

    @Override
    public void updateAllPoints() {
        if (this.surfaceRender != null && this.surfaceRender.isSyncingShapes()) {
            this.surfaceRender.updateAllROIPoints(this.poiManager.getAllPOIs());
        }
    }

    public void updateAllViewers() {
        Mango.updateAllViewers();
    }

    public void updateCrosshairSelection(ScreenSlice aImage) {
        if (aImage == this.axialImage) {
            this.coronalImage.setCurrentSlice(aImage.getCurrentY());
            this.sagittalImage.setCurrentSlice(aImage.getCurrentX());
            this.coronalImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
            this.sagittalImage.setCrosshairPosition(this.coronalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
        } else if (aImage == this.coronalImage) {
            this.axialImage.setCurrentSlice(aImage.getCurrentY());
            this.sagittalImage.setCurrentSlice(aImage.getCurrentX());
            this.axialImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.coronalImage.getCurrentSlice());
            this.sagittalImage.setCrosshairPosition(this.coronalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
        } else {
            this.axialImage.setCurrentSlice(aImage.getCurrentY());
            this.coronalImage.setCurrentSlice(aImage.getCurrentX());
            this.axialImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.coronalImage.getCurrentSlice());
            this.coronalImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
        }
        this.updateSync();
    }

    public void updateCrosssection(Point2D aPoint, boolean isMM, int direction) {
        this.axialImage.updateCrosssectionMarker(aPoint, isMM, direction);
        this.coronalImage.updateCrosssectionMarker(aPoint, isMM, direction);
        this.sagittalImage.updateCrosssectionMarker(aPoint, isMM, direction);
        this.mainImage.repaint();
    }

    public void updateFrameMenu() {
        if (this.frame != null) {
            this.frame.updateMenu();
        }
    }

    public void updateHistogram() {
        this.axialImage.updateHistogram();
        this.coronalImage.updateHistogram();
        this.sagittalImage.updateHistogram();
    }

    public void updateImageRange() {
        this.recordAction("setDisplayRangeToImageRange", new String[]{this.getScriptObjectName() + ".currentVolume", ScriptUtils.convertBoolean(false)});
        if (this.toolBox.isGlobal()) {
            if (this.currentScreenVolume.isBaseImage()) {
                this.toolBox.updateGlobalRange();
            } else {
                this.currentScreenVolume.getVolume().findRangeVolumeAsync(this.currentScreenVolume);
            }
        } else {
            this.currentScreenVolume.getVolume().findRangeVolumeAsync(this.currentScreenVolume);
        }
    }

    public void updateMainImageCursor() {
        if (this.mainImage != null) {
            this.mainImage.updateCursor();
        }
    }

    public void updateOverlayGroupLUT(int max, int min) {
        ScreenVolume[] overlays;
        for (ScreenVolume overlay : overlays = this.overlayManager.getAllOverlays()) {
            if (overlay == null) continue;
            overlay.getLookupTableManager().updateLUT(max, min);
        }
    }

    public void updateRadiologicalMode() {
        this.axialImage.updateLabelPositions();
        this.axialImage.updateFinalTransform();
        this.coronalImage.updateLabelPositions();
        this.coronalImage.updateFinalTransform();
        this.sagittalImage.updateLabelPositions();
        this.sagittalImage.updateFinalTransform();
    }

    public void updateRange() {
        this.updateRange(this.baseScreenVolume);
    }

    public void updateRange(ScreenImage si) {
        ScreenVolume sv = (ScreenVolume)si;
        if (this.toolBox.isGlobal()) {
            if (sv.isBaseImage()) {
                this.toolBox.updateGlobalRange();
            } else {
                sv.getVolume().updateMaxMin(sv, sv.getVolume().findRangeSeries());
            }
        } else {
            sv.getVolume().updateMaxMin(sv, sv.getVolume().findRangeSeries());
        }
    }

    public void updateROISlices() {
        this.updateROISlices(false);
    }

    public void updateScreenRatio() {
        if (this.toolBox.isGlobal()) {
            this.toolBox.setGlobalScreenRatio(255.0 / (this.toolBox.getScreenMax() - this.toolBox.getScreenMin()));
        } else {
            this.baseScreenVolume.updateScreenRatio();
        }
    }

    public void updateScreenSlices() {
        if (this.isViewerInitialized()) {
            this.axialImage.updateScreenSlice();
            this.coronalImage.updateScreenSlice();
            this.sagittalImage.updateScreenSlice();
        }
        this.repaint();
    }

    public void updateScreenSliceTransforms() {
        this.axialImage.updateTransforms();
        this.coronalImage.updateTransforms();
        this.sagittalImage.updateTransforms();
        this.repaint();
    }

    public void updateSeriesRange() {
        this.recordAction("setDisplayRangeToImageRange", new String[]{this.getScriptObjectName() + ".currentVolume", ScriptUtils.convertBoolean(true)});
        if (this.toolBox.isGlobal()) {
            if (this.currentScreenVolume.isBaseImage()) {
                this.toolBox.updateGlobalRange();
            } else {
                this.currentScreenVolume.getVolume().findRangeSeriesAsync(this.currentScreenVolume);
            }
        } else {
            this.currentScreenVolume.getVolume().findRangeSeriesAsync(this.currentScreenVolume);
        }
    }

    public void updateSurface() {
        if (this.surfaceRender != null && this.surfaceRender.isInitialized() && this.surfaceRender.isVisible() && this.surfaceRender.isFrameVisible()) {
            this.updateActivePlanes(false);
            this.updateSurfaceTransform(false);
            this.surfaceRender.updateModelClips();
            this.updateSurfaceTextures(false);
            this.surfaceRender.updateSurface();
        }
    }

    public void updateSurfaceColor(Color colMin, Color colMax) {
        if (this.surfaceRender != null && this.surfaceRender.isInitialized() && this.surfaceRender.isVisible() && this.surfaceRender.isFrameVisible()) {
            this.surfaceRender.setColor(colMin, colMax);
            this.surfaceRender.overlayChanged(null, false);
        }
    }

    public void updateSurfaceColors() {
        if (this.surfaceRender != null && this.surfaceRender.isInitialized() && this.surfaceRender.isVisible() && this.surfaceRender.isFrameVisible()) {
            this.surfaceRender.overlayChanged(null, false);
        }
    }

    public void updateSurfaceTextures(boolean updateScreenSlicesVal) {
        boolean updateScreenSlices = updateScreenSlicesVal;
        int obliqueDirection = -1;
        if (this.surfaceRender != null && this.surfaceRender.isInitialized() && this.surfaceRender.isVisible() && this.surfaceRender.isFrameVisible()) {
            obliqueDirection = this.surfaceRender.getObliqueCutPlaneDirection();
        }
        if (updateScreenSlices |= obliqueDirection != -1) {
            if (obliqueDirection == 0) {
                this.axialImage.updateScreenSlice(this.axialImage.getCurrentSlice(), this.surfaceRender.getObliqueCutPlaneTransform(), true);
            } else {
                this.axialImage.updateScreenSlice(true);
            }
            if (obliqueDirection == 1) {
                this.coronalImage.updateScreenSlice(this.coronalImage.getCurrentSlice(), this.surfaceRender.getObliqueCutPlaneTransform(), true);
            } else {
                this.coronalImage.updateScreenSlice(true);
            }
            if (obliqueDirection == 2) {
                this.sagittalImage.updateScreenSlice(this.sagittalImage.getCurrentSlice(), this.surfaceRender.getObliqueCutPlaneTransform(), true);
            } else {
                this.sagittalImage.updateScreenSlice(true);
            }
        }
        if (this.surfaceRender != null && this.surfaceRender.isInitialized() && this.surfaceRender.isVisible() && this.surfaceRender.isFrameVisible()) {
            this.surfaceRender.updateTextures(this.axialImage.getTextureImage(), this.coronalImage.getTextureImage(), this.sagittalImage.getTextureImage());
        }
        if (updateScreenSlices) {
            if (obliqueDirection == 0) {
                this.axialImage.updateScreenSlice(false);
            }
            if (obliqueDirection == 1) {
                this.coronalImage.updateScreenSlice(false);
            }
            if (obliqueDirection == 2) {
                this.sagittalImage.updateScreenSlice(false);
            }
        }
    }

    public void updateSync() {
        if (this.viewerSyncer.getType() == 2) {
            this.viewerSyncer.sync(this, this.getCurrentCoordinate(), this.toolBox.getCoordinateType());
        } else if (this.viewerSyncer.getType() == 1) {
            this.viewerSyncer.syncMain(this, this.toolBox.getCoordinateType());
        }
    }

    public void updateSyncZoom() {
        this.viewerSyncer.syncZoom(this);
    }

    public void updateSyncSeries() {
        if (this.viewerSyncer.getType() == 2) {
            this.viewerSyncer.syncSeries(this, this.getBaseVolume().getCurrentTimepoint());
        }
    }

    public void updateToolBox() {
        this.toolBox.updateCurrentState();
        this.toolBox.updateFocusState();
    }

    public void updateToolBoxSlice(int sliceType, int difference) {
        this.toolBox.setMouseLabelInfoIncrement(sliceType, difference);
    }

    public void updateTransformManualPanel() {
        if (this.transformManualPanel != null) {
            this.transformManualPanel.reconcileWithViewerTransformState();
        }
    }

    public void updateTransformMode() {
        this.updateOverlaySensitiveData();
        this.updateSurface();
        this.updateScreenSlices();
        this.updateFrameMenu();
    }

    public void updateViewer() {
        if (!this.isCleared) {
            this.forceImageUpdate();
            this.updateScreenSlices();
            this.updateROISlices();
            this.repaint();
        }
    }

    public void updateVOIMode() {
        this.roiManager.setSelectedSlice(this.axialImage.getCurrentSlice(), 0);
        this.roiManager.setSelectedSlice(this.coronalImage.getCurrentSlice(), 1);
        this.roiManager.setSelectedSlice(this.sagittalImage.getCurrentSlice(), 2);
        this.updateROISlices();
        this.repaint();
        this.updateFrameMenu();
    }

    public void updateWindowTitle() {
        if (!this.isClosing()) {
            Volume currentVol = this.getCurrentVolume();
            String prefix = "";
            String suffix = "";
            String timeStr = "";
            String nameSuffix = "";
            if (this.volumeCanBeSaved()) {
                prefix = "[";
                suffix = "]";
                this.frame.getRootPane().putClientProperty(WINDOW_DOCUMENT_MODIFIED, Boolean.TRUE);
            } else if (this.overlayCanBeSaved()) {
                prefix = "<";
                suffix = ">";
                this.frame.getRootPane().putClientProperty(WINDOW_DOCUMENT_MODIFIED, Boolean.TRUE);
            } else if (this.roiCanBeSaved(false)) {
                prefix = "(";
                suffix = ")";
                this.frame.getRootPane().putClientProperty(WINDOW_DOCUMENT_MODIFIED, Boolean.TRUE);
            } else {
                this.frame.getRootPane().putClientProperty(WINDOW_DOCUMENT_MODIFIED, Boolean.FALSE);
            }
            String name = this.getNiceImageTitle();
            if (name != null && currentVol != null && this.frame != null) {
                if (currentVol.getNumTimepoints() > 1) {
                    if (this.toolBox.isWorldMode() && !currentVol.isForceDisplayIndex() || currentVol.isForceDisplayWorld()) {
                        timeStr = FORMATTER.format(currentVol.getRealTimeOffset(currentVol.getCurrentTimepoint())) + " " + currentVol.getTimeUnitString();
                        timeStr = " (" + timeStr + ")";
                    } else if (currentVol.isLoadedSeriesAsSubset()) {
                        int totalLoaded = currentVol.getNumTimepoints() == currentVol.getNumLoadedVolumes() ? currentVol.getSeriesOffsetOriginalRange() : currentVol.getNumLoadedVolumes() + currentVol.getSeriesOffset() + 1 - 1;
                        timeStr = " (" + (currentVol.getSeriesOffset() + currentVol.getCurrentTimepoint() + 1) + " of " + totalLoaded + ")";
                    } else {
                        timeStr = " (" + (currentVol.getCurrentTimepoint() + 1) + " of " + Math.min(currentVol.getNumTimepoints(), currentVol.getNumLoadedVolumes()) + ")";
                    }
                } else if (currentVol.isLoadedSeriesAsSinglePoint()) {
                    nameSuffix = "-" + (currentVol.getSeriesOffset() + 1);
                }
                String bookmarkLabel = this.volume.findLoggedLabelByCoordinate(this.getCurrentIndex());
                if (bookmarkLabel != null) {
                    name = name + " @ " + bookmarkLabel;
                }
            }
            this.frame.setTitle(prefix + name + nameSuffix + suffix + timeStr);
        }
    }

    public void useTransform(boolean use) {
        this.baseScreenVolume.setUsingTransform(use);
        this.updateTransformMode();
        this.mango.getToolBox().updateCurrentState();
        this.updateViewer();
    }

    @Override
    public void volumeChanged() {
        if (this.isReady()) {
            this.updateWindowTitle();
            this.updateFrameMenu();
        }
    }

    @Override
    public void volumeChanged(final Volume aVolume, final boolean forceUpdate) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (SliceViewer.this.isImageLoaded() && (forceUpdate || aVolume != SliceViewer.this.volume) && aVolume.isInitialized()) {
                    SliceViewer.this.forceImageUpdate();
                    SliceViewer.this.updateScreenSlices();
                    SliceViewer.this.updateSurfaceColorAtTimepoint();
                }
                SliceViewer.this.updateFrameMenu();
            }
        };
        SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
    }

    @Override
    public void volumeDataLoaded(final int volIndex) {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                if (SliceViewer.this.isImageLoaded()) {
                    if (SliceViewer.this.frame != null) {
                        SliceViewer.this.updateWindowTitle();
                        SliceViewer.this.updateFrameMenu();
                    }
                    if (!SliceViewer.this.checkRangeForBackgroundLoad) {
                        SliceViewer.this.checkRangeForBackgroundLoad = true;
                        if (SliceViewer.this.volume.getDisplayMax() > SliceViewer.this.volume.getDisplayMin()) {
                            SliceViewer.this.baseScreenVolume.setScreenMin(SliceViewer.this.volume.getDisplayMin());
                            SliceViewer.this.baseScreenVolume.setScreenMax(SliceViewer.this.volume.getDisplayMax());
                            SliceViewer.this.baseScreenVolume.updateScreenRatio();
                            SliceViewer.this.toolBox.updateCurrentState();
                        } else {
                            SliceViewer.this.updateImageRange();
                        }
                    } else if (SliceViewer.this.volume.getCurrentTimepoint() <= volIndex && !SliceViewer.this.updatedPostLoadTimeseries) {
                        SliceViewer.this.updatedPostLoadTimeseries = true;
                        SliceViewer.this.updateScreenSlices();
                    }
                }
            }
        });
    }

    @Override
    public void volumeLoaded(boolean success) {
        this.volumeLoaded(success, false);
    }

    @Override
    public void volumeOperationCompleted(final boolean success, final Volume vol) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (success) {
                    SliceViewer.this.forceImageUpdate();
                    if (SliceViewer.this.startOperation != null) {
                        if (SliceViewer.this.toolBox.isGlobal()) {
                            if (vol == SliceViewer.this.volume) {
                                SliceViewer.this.toolBox.updateGlobalRange();
                                SliceViewer.this.updateViewer();
                            } else {
                                vol.findRangeVolumeAsync(SliceViewer.this.currentScreenVolume);
                            }
                        } else {
                            vol.findRangeVolumeAsync(SliceViewer.this.currentScreenVolume);
                        }
                        SliceViewer.this.startOperation = null;
                        SliceViewer.this.initializeROIManager();
                    } else {
                        vol.findRangeVolumeAsync(SliceViewer.this.currentScreenVolume);
                    }
                } else {
                    SliceViewer.this.showErrorDialog("Problem with that operation!", SliceViewer.ERROR_TITLE_OPERATION);
                }
                SliceViewer.this.updateFrameMenu();
            }
        };
        SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
    }

    @Override
    public void volumeRangeChanged(final Volume aVolume, final Object source, boolean sameThread) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.forceImageUpdate();
                if (aVolume == SliceViewer.this.volume) {
                    if (SliceViewer.this.saveAsAfterRangeUpdate != null) {
                        SliceViewer.this.saveImageAs(SliceViewer.this.saveAsAfterRangeUpdate.getSaveAsFile(), SliceViewer.this.saveAsAfterRangeUpdate.getSelectedTransform(), SliceViewer.this.saveAsAfterRangeUpdate.getSelectedOverlay(), SliceViewer.this.saveAsAfterRangeUpdate.getOrientation(), SliceViewer.this.saveAsAfterRangeUpdate.getSelectedFileImageType(), SliceViewer.this.saveAsAfterRangeUpdate.getSelectedFileHeaderType(), SliceViewer.this.saveAsAfterRangeUpdate.isApplyDataScales(), SliceViewer.this.saveAsAfterRangeUpdate.isNearestNeighbor(), SliceViewer.this.saveAsAfterRangeUpdate.isTrilinear(), SliceViewer.this.saveAsAfterRangeUpdate.isSinc(), SliceViewer.this.saveAsAfterRangeUpdate.isThreshold(), SliceViewer.this.saveAsAfterRangeUpdate.isMix(), SliceViewer.this.saveAsAfterRangeUpdate.isCompress(), SliceViewer.this.saveAsAfterRangeUpdate.isUsingFitPrecision(), SliceViewer.this.saveAsAfterRangeUpdate.isMaintainZero(), SliceViewer.this.saveAsAfterRangeUpdate.getSelectedImageBounds(), SliceViewer.this.saveAsAfterRangeUpdate.getSelectedSizeX(), SliceViewer.this.saveAsAfterRangeUpdate.getSelectedSizeY(), SliceViewer.this.saveAsAfterRangeUpdate.getSelectedSizeZ(), SliceViewer.this.saveAsAfterRangeUpdate.getSelectedSizeT(), false);
                        SliceViewer.this.saveAsAfterRangeUpdate = null;
                    } else if (SliceViewer.this.isImageLoaded()) {
                        if (SliceViewer.this.volume.isInitialized()) {
                            SliceViewer.this.reinitializeScreenValues();
                            SliceViewer.this.updateSurface();
                        }
                        if (SliceViewer.this.crosssection.getParentFrame() != null) {
                            SliceViewer.this.crosssection.updateCrosssection();
                        }
                        if (SliceViewer.this.timeseries.getParentFrame() != null) {
                            SliceViewer.this.timeseries.updateTimeseries();
                        }
                    } else {
                        SliceViewer.this.initializeViewer();
                    }
                } else if (source instanceof OverlayLoadItem) {
                    SliceViewer.this.loadOverlayLoadItem((OverlayLoadItem)source);
                } else {
                    ScreenVolume sourceScreenVol = (ScreenVolume)source;
                    ScreenVolume aScreenVol = SliceViewer.this.overlayManager.getOverlay(aVolume);
                    if (aScreenVol != null && aScreenVol.isLoaded()) {
                        SliceViewer.this.reinitializeOverlay(aScreenVol);
                    } else {
                        SliceViewer.this.initializeOverlay(sourceScreenVol);
                    }
                }
                SliceViewer.this.updateFrameMenu();
            }
        };
        if (sameThread) {
            SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runner);
        } else {
            SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
        }
    }

    @Override
    public void volumeReloaded(final boolean success) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (success) {
                    SliceViewer.this.useTransform(false);
                    SliceViewer.this.setCurrentOverlay(0);
                    SliceViewer.this.reinitializeViewer();
                    if (SliceViewer.this.volume.getDisplayMax() > SliceViewer.this.volume.getDisplayMin()) {
                        SliceViewer.this.baseScreenVolume.setScreenMin(SliceViewer.this.volume.getDisplayMin());
                        SliceViewer.this.baseScreenVolume.setScreenMax(SliceViewer.this.volume.getDisplayMax());
                    } else {
                        SliceViewer.this.baseScreenVolume.setScreenMin(SliceViewer.this.volume.getImageMin());
                        SliceViewer.this.baseScreenVolume.setScreenMax(SliceViewer.this.volume.getImageMax());
                    }
                    SliceViewer.this.baseScreenVolume.setURI(SliceViewer.this.getLoadedURI());
                    SliceViewer.this.updateTransformMode();
                    SliceViewer.this.toolBox.updateCurrentState();
                    SliceViewer.this.updateViewer();
                    SliceViewer.this.mango.updateImageBrowser(SliceViewer.this.getLoadedFile());
                }
                SliceViewer.this.endIndeterminateProgressBar();
                SliceViewer.this.updateFrameMenu();
                SliceViewer.this.volumeWillBeReloaded = false;
                SliceViewer.this.mango.loadNextViewer();
            }
        };
        SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
    }

    @Override
    public void volumeRevertedToSaved(final boolean success) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (success) {
                    SliceViewer.this.volume.setUser(SliceViewer.this);
                    SliceViewer.this.volume.setProgressBarListener(SliceViewer.this.toolBox);
                    if (SliceViewer.this.volume.getDisplayMax() > SliceViewer.this.volume.getDisplayMin()) {
                        SliceViewer.this.baseScreenVolume.setScreenMin(SliceViewer.this.volume.getDisplayMin());
                        SliceViewer.this.baseScreenVolume.setScreenMax(SliceViewer.this.volume.getDisplayMax());
                    } else {
                        SliceViewer.this.baseScreenVolume.setScreenMin(SliceViewer.this.volume.getImageMin());
                        SliceViewer.this.baseScreenVolume.setScreenMax(SliceViewer.this.volume.getImageMax());
                    }
                    SliceViewer.this.baseScreenVolume.updateScreenRatio();
                    SliceViewer.this.updateScreenSlices();
                    SliceViewer.this.toolBox.updateCurrentState();
                    if (SliceViewer.this.baseScreenVolume.getScreenMax() <= SliceViewer.this.baseScreenVolume.getScreenMin()) {
                        SliceViewer.this.volume.findRangeVolumeAsync(SliceViewer.this.baseScreenVolume);
                    } else {
                        SliceViewer.this.revertingToSaved = false;
                    }
                } else {
                    SliceViewer.this.revertingToSaved = false;
                }
                SliceViewer.this.endIndeterminateProgressBar();
                SliceViewer.this.updateWindowTitle();
                SliceViewer.this.updateFrameMenu();
                SliceViewer.this.setNavigationDisabled(false);
                if (SliceViewer.this.loadNextAfterRevert) {
                    SliceViewer.this.mango.loadNextViewer();
                    SliceViewer.this.loadNextAfterRevert = false;
                }
            }
        };
        SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
    }

    @Override
    public void volumeSaved(Volume vol, boolean success, boolean doReload, final edu.uthscsa.ric.mango.components.progressbar.ProgressBar pb, Volume overlayToClear, boolean isCopy, boolean sameThread) {
        boolean reload = doReload & !isCopy;
        this.closeOnSave &= !isCopy;
        this.isTempImage = false;
        this.volumeWillBeSaved = false;
        this.volumeWillBeReloaded = reload & success;
        this.overlayWillBeSaved &= vol == this.volume || this.findNextOverlayToSave(vol) != null;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.setNavigationDisabled(false);
                if (pb != null) {
                    pb.setIndeterminateMode(false);
                    pb.setValue(pb.getMax());
                }
                SliceViewer.this.endIndeterminateProgressBar();
            }
        };
        if (sameThread) {
            SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
        } else {
            SwingWidgetUtilities.invokeLaterSafely((Runnable)runnable);
        }
        if (success) {
            if (this.overlayWillBeSaved) {
                if (vol == this.volume) {
                    this.saveOverlays(sameThread);
                } else {
                    this.saveNextOverlay(this.findNextOverlayToSave(vol), sameThread);
                }
            } else if (this.roiManagerWillBeSaved) {
                this.saveROI(null, -1, sameThread);
            } else if (this.closeOnSave) {
                this.cleanUp();
            } else if (this.volumeWillBeReloaded) {
                this.mango.addToRecentFilesList(this.getLoadedFile().toURI());
                if (overlayToClear != null) {
                    this.removeOverlay(this.overlayManager.getOverlay(overlayToClear));
                }
                this.reloadImage(this.getLoadedURI(), pb);
            } else {
                this.mango.updateImageBrowser(this.getLoadedFile());
            }
        } else {
            this.mango.clearIsExiting();
            this.showErrorDialog("There was a problem saving the image!", "Error");
        }
        runnable = new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.updateFrameMenu();
                SliceViewer.this.frame.updateSeriesManager();
            }
        };
        if (sameThread) {
            SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
        } else {
            SwingWidgetUtilities.invokeLaterSafely((Runnable)runnable);
        }
    }

    @Override
    public void volumeTimepointChanged(Volume volume) {
        if (!this.toolBox.isUsingFixedTimeseriesRange() && this.baseScreenVolume.getVolume() == volume) {
            ImageBounds ib = this.getMainScreenSliceBounds();
            ib.setRangeT(volume.getCurrentTimepoint(), volume.getCurrentTimepoint());
            Range op = volume.findRangeInBounds(ib);
            double[] range = Volume.findDisplayRange(op.getMax());
            this.baseScreenVolume.setScreenMin(range[0]);
            this.baseScreenVolume.setScreenMax(range[1]);
            this.baseScreenVolume.updateScreenRatio();
            this.toolBox.updateCurrentState();
        }
        if (this.frame != null) {
            this.frame.updateLabelSeriesEditor();
            this.frame.updateSeriesManager();
            this.updateFrameMenu();
        }
        this.roiManager.setBufferSeriesIndex(volume.getCurrentTimepoint());
        if (this.clusterROIAnalysis != null && this.roiManager.hasClusterData() && this.roiManager.isUsing4dROI()) {
            this.clusterROIAnalysis.roiTimepointChanged();
            this.updateROISlices();
        }
        this.updateViewer();
        this.updateSurfaceColorAtTimepoint();
    }

    @Override
    public void volumeTransformChanged(Volume aVolume) {
        if (this.transformManualPanel != null) {
            this.transformManualPanel.reconcileWithViewerTransformState();
        }
        if (aVolume == this.volume) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    SliceViewer.this.updateSurfaceTransform(true);
                }
            };
            SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
        }
        this.updateFrameMenu();
    }

    @Override
    public void volumeTransformLoaded() {
        this.useTransform(true);
        if (this.transformManualPanel != null) {
            this.updateTransformManualPanel();
            this.transformManualPanel.resetSliderTextFields();
        }
    }

    @Override
    public void willAddMoreROIColors(final int colorMaxNew) {
        this.endIndeterminateProgressBar();
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.histogram.increaseColors(colorMaxNew);
                SliceViewer.this.updateHistogram();
                SliceViewer.this.axialImage.updateROIMaxColors(colorMaxNew);
                SliceViewer.this.coronalImage.updateROIMaxColors(colorMaxNew);
                SliceViewer.this.sagittalImage.updateROIMaxColors(colorMaxNew);
                SliceViewer.this.updateViewer();
            }
        });
    }

    public void windowLevelChanged(int contrastChange, int brightnessChange) {
        if (this.isRGB()) {
            this.toolBox.adjustSliderValues(brightnessChange, contrastChange);
        } else if (this.toolBox.isGlobal()) {
            double maxFinal;
            double minFinal;
            double range = this.toolBox.getGlobalScreenMax() - this.toolBox.getGlobalScreenMin();
            double step = range * 0.01;
            if (Math.abs(contrastChange) > Math.abs(brightnessChange)) {
                minFinal = this.toolBox.getGlobalScreenMin() + step * (double)Math.signum(contrastChange) * (double)Math.max(1, Math.abs(contrastChange / 10));
                maxFinal = this.toolBox.getGlobalScreenMax() + -1.0 * step * (double)Math.signum(contrastChange) * (double)Math.max(1, Math.abs(contrastChange / 10));
                if (maxFinal <= minFinal) {
                    minFinal = this.toolBox.getGlobalScreenMin();
                    maxFinal = this.toolBox.getGlobalScreenMin();
                }
            } else {
                minFinal = this.toolBox.getGlobalScreenMin() + step * (double)Math.signum(brightnessChange) * (double)Math.max(1, Math.abs(brightnessChange / 10));
                maxFinal = this.toolBox.getGlobalScreenMax() + step * (double)Math.signum(brightnessChange) * (double)Math.max(1, Math.abs(brightnessChange / 10));
            }
            this.toolBox.setGlobalRange(minFinal, maxFinal);
        } else {
            double maxFinal;
            double minFinal;
            double range = this.baseScreenVolume.getImageMax() - this.baseScreenVolume.getImageMin();
            double step = range * 0.01;
            if (Math.abs(contrastChange) > Math.abs(brightnessChange)) {
                minFinal = this.baseScreenVolume.getScreenMin() + step * (double)Math.signum(contrastChange) * (double)Math.max(1, Math.abs(contrastChange / 10));
                maxFinal = this.baseScreenVolume.getScreenMax() + -1.0 * step * (double)Math.signum(contrastChange) * (double)Math.max(1, Math.abs(contrastChange / 10));
                if (maxFinal <= minFinal) {
                    minFinal = this.baseScreenVolume.getScreenMin();
                    maxFinal = this.baseScreenVolume.getScreenMin();
                }
            } else {
                minFinal = this.baseScreenVolume.getScreenMin() + step * (double)Math.signum(brightnessChange) * (double)Math.max(1, Math.abs(brightnessChange / 10));
                maxFinal = this.baseScreenVolume.getScreenMax() + step * (double)Math.signum(brightnessChange) * (double)Math.max(1, Math.abs(brightnessChange / 10));
            }
            this.baseScreenVolume.setScreenMin(minFinal);
            this.baseScreenVolume.setScreenMax(maxFinal);
        }
        this.toolBox.updateTextFields();
        this.forceImageUpdate();
        this.updateScreenSlices();
    }

    protected void setCurrentCoordinate(Coordinate coor, int labelType) {
        this.setCurrentCoordinate(coor, false, labelType);
    }

    protected void setMainCoordinate(double xLoc, double yLoc) {
        if (this.getMainSliceDirection() == 0) {
            this.setCurrentCoordinate(new Coordinate(xLoc / this.getXSize(), yLoc / this.getYSize(), (double)this.getMainSliceNumber()), false, 0);
        } else if (this.getMainSliceDirection() == 1) {
            this.setCurrentCoordinate(new Coordinate(xLoc / this.getXSize(), (double)this.getMainSliceNumber(), yLoc / this.getZSize()), false, 0);
        } else if (this.getMainSliceDirection() == 2) {
            this.setCurrentCoordinate(new Coordinate((double)this.getMainSliceNumber(), xLoc / this.getYSize(), yLoc / this.getZSize()), false, 0);
        }
    }

    protected void setMainCoordinate(int xLoc, int yLoc) {
        if (this.getMainSliceDirection() == 0) {
            this.setCurrentCoordinate(new Coordinate((double)xLoc, (double)yLoc, (double)this.getMainSliceNumber()), false, 0);
        } else if (this.getMainSliceDirection() == 1) {
            this.setCurrentCoordinate(new Coordinate((double)xLoc, (double)this.getMainSliceNumber(), (double)yLoc), false, 0);
        } else if (this.getMainSliceDirection() == 2) {
            this.setCurrentCoordinate(new Coordinate((double)this.getMainSliceNumber(), (double)xLoc, (double)yLoc), false, 0);
        }
    }

    protected void addToFrame() {
        this.addKeyListener(this);
        KeyboardMap.createKeyboardMap(this, this);
        this.frame = new ViewerFrame(this.mango, this);
        this.frame.initialize();
        this.updateSync();
        this.requestFocusInWindow();
        this.mango.updateAllFunctionHotKeys();
        int certainty = this.getOrientationCertainty();
        if (certainty == 0) {
            this.setViewOptionOrientation(true);
        }
    }

    private boolean allForcedWorldTimeMode() {
        boolean allForced = true;
        ScreenVolume[] overlays = this.overlayManager.getAllOverlays();
        if (overlays != null) {
            for (ScreenVolume overlay : overlays) {
                if (overlay == null || overlay.getVolume().getNumTimepoints() <= 1) continue;
                allForced &= overlay.getVolume().isForceDisplayWorld();
            }
        }
        return allForced;
    }

    private void buildSurface(Surface[] surfaces, Vector<Shape> shapes) {
        if (this.surfaceRender == null) {
            this.surfaceRender = new SurfaceViewer(this);
            this.surfaceRender.setSurfaceFromFile(surfaces, shapes);
        } else {
            this.surfaceRender.getFrame().setVisible(true);
            this.surfaceRender.setSurfaceFromFile(surfaces, shapes);
        }
        this.mango.updateAllFunctionHotKeys();
        this.mango.loadNextViewer();
    }

    private boolean canWriteROIFile() {
        return this.roiManager.getBuffer().hasBuffer() && this.roiManager.getBuffer().getUsed() != 0L || this.loiManagersHaveBeenUsed() || this.poiManager.isUsed();
    }

    private void cleanUp() {
        this.cleanUp(false);
    }

    private void cleanUp(boolean force) {
        try {
            if (this.frame != null) {
                this.frame.setTitle("Closing...");
            }
            AppLogger.info((String)("Image [" + this.getImageTitle() + "] closed"));
            if (this.pbIndeterminate != null) {
                this.pbIndeterminate.setIndeterminateMode(false);
                this.pbIndeterminate.setValue(100);
                this.pbIndeterminate = null;
            }
            if ((this.toolBox.isTextFieldMinTouched() || this.toolBox.isTextFieldMaxTouched()) && this == this.toolBox.getCurrentViewer() && (this.frame.getState() & 1) == 0) {
                this.toolBox.updateTextFields();
            }
            if (this.windowManager != null) {
                this.windowManager.closeAllAssociatedWindows();
                this.windowManager.clear();
                this.windowManager = null;
            }
            this.baseScreenVolume.clear();
            this.volume.removeListener(this);
            if (this.overlayManager != null) {
                ScreenVolume[] allOverlays;
                for (ScreenVolume allOverlay : allOverlays = this.overlayManager.getAllOverlays()) {
                    if (allOverlay == null) continue;
                    allOverlay.getVolume().removeListener(this);
                    allOverlay.clear();
                }
            }
            this.volume.stopBackgroundLoading();
            this.mango.removeViewer(this);
            this.clear();
            this.roiFileGZIP = null;
            this.setLoadedURI(null);
            this.toolBox = null;
            if (this.mango.isExiting() && !force) {
                this.mango.closeNextViewer();
            }
            this.mango = null;
            JVMUtilities.clearGarbage();
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
            try {
                this.clear();
                this.mango.removeViewer(this);
            }
            catch (Exception ex2) {
                AppLogger.error((Throwable)ex2);
            }
        }
    }

    private void clear() {
        try {
            try {
                this.isCleared = true;
                if (this.volume != null) {
                    this.volume.clear(false);
                    this.volume = null;
                }
                if (this.roiManager != null) {
                    this.roiManager.clear();
                    this.roiManager = null;
                }
                if (this.axialImage != null) {
                    this.axialImage.clear();
                }
                if (this.coronalImage != null) {
                    this.coronalImage.clear();
                }
                if (this.sagittalImage != null) {
                    this.sagittalImage.clear();
                }
                this.histogram = null;
                this.crosssection = null;
                this.timeseries = null;
                this.roiInspector = null;
                this.clusterAnalysis = null;
                this.clusterROIAnalysis = null;
                this.logicalManager = null;
                this.lowerImageRight = null;
                this.lowerImageLeft = null;
                this.mainImage = null;
                this.sagittalImage = null;
                this.coronalImage = null;
                this.axialImage = null;
                if (this.overlayManager != null) {
                    this.overlayManager.clear();
                    this.overlayManager = null;
                }
            }
            catch (Exception ex) {
                AppLogger.error((Throwable)ex);
            }
            if (this.viewerSyncer != null) {
                this.viewerSyncer.removeViewer(this);
                this.viewerSyncer = null;
            }
            this.setStartLocation(null);
            this.setStartSize(null);
            if (this.listeners != null) {
                this.listeners.clear();
                this.listeners = null;
            }
            if (this.sliceDirectionListeners != null) {
                this.sliceDirectionListeners.clear();
                this.sliceDirectionListeners = null;
            }
            this.surfaceRender = null;
            if (this.frame != null) {
                this.frame.clear();
                this.frame = null;
            }
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    private void clearDicomOverlay() {
        this.axialImage.clearDicomOverlay();
        this.coronalImage.clearDicomOverlay();
        this.sagittalImage.clearDicomOverlay();
    }

    private void convexHullLOI(LOIShape loi) {
        if (this.loiManagerAxial.containsLOI(loi)) {
            this.loiManagerAxial.convexHull(loi);
        } else if (this.loiManagerCoronal.containsLOI(loi)) {
            this.loiManagerCoronal.convexHull(loi);
        } else if (this.loiManagerSagittal.containsLOI(loi)) {
            this.loiManagerSagittal.convexHull(loi);
        }
        this.repaint();
    }

    private void copyLOI() {
        Mango.getClipboardLoi().copy(this.loiManagerAxial, this.loiManagerCoronal, this.loiManagerSagittal, this.isMultiSliceMode());
    }

    private void copyPOI() {
        Mango.getClipboardPoi().copy(this.poiManager, this.volume.getZDim(), this.volume.getXSize(), this.volume.getYSize(), this.volume.getZSize(), !this.isMultiSliceMode(), this.getMainSliceDirection(), this.getMainSliceNumber());
    }

    private void copyROI(boolean sameThread) {
        this.roiManager.copy(sameThread);
    }

    private void createDropSet(FileNode[] nodes) {
        TreeSet<Object> loadSet = new TreeSet<Object>(new StringComparator());
        if (nodes != null) {
            for (FileNode node : nodes) {
                if (node.getHeaderInfo() != null) {
                    boolean isROI = node.getHeaderInfo().isRoi();
                    LoadItem li = new LoadItem(node.getFile());
                    li.setOverlay(!isROI);
                    li.setRoi(isROI);
                    li.setBaseImage(this);
                    loadSet.add(li);
                    continue;
                }
                if (node.getSurfaceInfo() == null) continue;
                LoadItem li = new LoadItem(node.getFile());
                li.setSurface(true);
                li.setBaseImage(this);
                loadSet.add(li);
            }
        }
        if (loadSet.size() > 0) {
            this.toFront();
            this.mango.addToLoadSet(loadSet);
        }
    }

    private void cutLOI() {
        if (this.hasSelectedLOIs()) {
            this.copyLOI();
            this.doClearLOI();
        }
        this.repaint();
    }

    private void cutPOI() {
        if (this.hasSelectedPOIs()) {
            this.copyPOI();
            this.doClearPOI();
        }
        this.repaint();
    }

    private void cutROI(boolean sameThread) {
        if (this.hasSelectedROIs()) {
            if (sameThread) {
                this.copyROI(true);
                this.doClearROI(true, true);
            } else {
                this.clearROIAfterCopy = true;
                this.copyROI(false);
            }
        }
    }

    private void deleteLOIPoint() {
        if (!this.isEditingDisabled()) {
            this.mainImage.deleteLOIPoint();
        }
    }

    private void deselectAllLOIs() {
        this.loiManagerAxial.deselectAll();
        this.loiManagerCoronal.deselectAll();
        this.loiManagerSagittal.deselectAll();
        this.shapeSelectionChanged();
        this.repaint();
    }

    private void deselectAllPOIs() {
        this.poiManager.deselectAll();
        if (this.timeseries.getParentFrame() != null) {
            ((TimeseriesTool)this.timeseries.getParentFrame()).selectionChanged();
        }
    }

    private void deselectAllROIs() {
        this.roiManager.deselectAll();
        this.updateROISlices();
        this.repaint();
    }

    public void doActionAddShapeROI(double size, boolean isCube, boolean isSphere) {
        if (size <= 0.0) {
            return;
        }
        int sizeX = (int)Math.round(size / this.volume.getXSize());
        int sizeY = (int)Math.round(size / this.volume.getYSize());
        int sizeZ = (int)Math.round(size / this.volume.getZSize());
        if (this.isMultiSliceMode()) {
            this.recordAction("runAddROI", new String[]{this.getScriptObjectName() + ".currentPosition", String.valueOf(size), ScriptUtils.convertBoolean(isSphere)}, true);
            this.roiManager.addShape(this.getCurrentIndex(), sizeX, sizeY, sizeZ, size, isCube, isSphere);
        } else {
            this.recordAction("runAddROISlice", new String[]{this.getScriptSliceDirection(this.getMainSliceDirection()), this.getScriptObjectName() + ".currentPosition", String.valueOf(size), ScriptUtils.convertBoolean(isSphere)}, true);
            this.roiManager.addShape2D(this.getCurrentIndex(), this.mainImage.getSliceDirection(), sizeX, sizeY, sizeZ, size, isCube, isSphere);
        }
    }

    private void doActionClose2D(int sliceNum, int sliceDirection, int kernel) {
        this.recordAction("runCloseROISlice", new String[]{this.getScriptSliceDirection(sliceDirection), this.getScriptSliceNumber(sliceNum), this.getScriptObjectName() + ".roiData.selectedMask", String.valueOf(kernel)}, true);
        this.roiManager.close2D(sliceNum, sliceDirection, kernel, this.roiManager.getBuffer().getSelected());
    }

    private void doActionCloseSelected3D(int kernel) {
        this.recordAction("runCloseROI", new String[]{this.getScriptObjectName() + ".roiData.selectedMask", String.valueOf(kernel)});
        this.roiManager.close3D(kernel, this.roiManager.getBuffer().getSelected());
    }

    private void doActionDilateSelected2D(int sliceNum, int sliceDirection, int kernel) {
        this.recordAction("runDilateROISlice", new String[]{this.getScriptSliceDirection(sliceDirection), this.getScriptSliceNumber(sliceNum), this.getScriptObjectName() + ".roiData.selectedMask", String.valueOf(kernel)}, true);
        this.roiManager.dilate2D(sliceNum, sliceDirection, kernel, this.roiManager.getBuffer().getSelected());
    }

    private void doActionDilateSelected3D(int kernel) {
        this.recordAction("runDilateROI", new String[]{this.getScriptObjectName() + ".roiData.selectedMask", String.valueOf(kernel)});
        this.roiManager.dilate3D(kernel, this.roiManager.getBuffer().getSelected());
    }

    private void doActionErodeSelected2D(int sliceNum, int sliceDirection, int kernel) {
        this.recordAction("runErodeROISlice", new String[]{this.getScriptSliceDirection(sliceDirection), this.getScriptSliceNumber(sliceNum), this.getScriptObjectName() + ".roiData.selectedMask", String.valueOf(kernel)}, true);
        this.roiManager.erode2D(sliceNum, sliceDirection, kernel, this.roiManager.getBuffer().getSelected());
    }

    private void doActionErodeSelected3D(int kernel) {
        this.recordAction("runErodeROI", new String[]{this.getScriptObjectName() + ".roiData.selectedMask", String.valueOf(kernel)});
        this.roiManager.erode3D(kernel, this.roiManager.getBuffer().getSelected());
    }

    private void doActionOpen2D(int sliceNum, int sliceDirection, int kernel) {
        this.recordAction("runOpenROISlice", new String[]{this.getScriptSliceDirection(sliceDirection), this.getScriptSliceNumber(sliceNum), this.getScriptObjectName() + ".roiData.selectedMask", String.valueOf(kernel)}, true);
        this.roiManager.open2D(sliceNum, sliceDirection, kernel, this.roiManager.getBuffer().getSelected());
    }

    private void doActionOpenSelected3D(int kernel) {
        this.recordAction("runOpenROI", new String[]{this.getScriptObjectName() + ".roiData.selectedMask", String.valueOf(kernel)});
        this.roiManager.open3D(kernel, this.roiManager.getBuffer().getSelected());
    }

    private void doActionPropogateROI(int startSlice, int endSlice) {
        this.recordAction("runPropagateROISlice", new String[]{this.getScriptSliceDirection(this.getMainSliceDirection()), this.getScriptSliceNumber(this.getMainSliceNumber()), this.getScriptSliceNumber(startSlice), this.getScriptSliceNumber(endSlice), this.getScriptObjectName() + ".roiData.selectedMask", this.getScriptObjectName() + ".roiColor"}, true);
        this.roiManager.propagate(this.mainImage.getSliceDirection(), this.mainImage.getCurrentSlice(), startSlice, endSlice, this.roiManager.getSelectedMask(), this.roiManager.getCurrentROI());
    }

    private void doActionRangeROI(double minResultVal, double maxResultVal, boolean isPercentMax, boolean excludeZero, boolean allSeriesPoints, boolean isDynamicThreshold) {
        double imageMax = this.getCurrentVolume().getImageMax();
        double minResult = minResultVal;
        double maxResult = maxResultVal;
        if (isPercentMax && !isDynamicThreshold) {
            minResult = imageMax * (minResult / 100.0);
            maxResult = imageMax * (maxResult / 100.0);
        }
        this.recordAction("runRangeToROI", new String[]{String.valueOf(minResultVal), String.valueOf(maxResultVal), ScriptUtils.convertBoolean(isPercentMax), ScriptUtils.convertBoolean(excludeZero), ScriptUtils.convertBoolean(allSeriesPoints), ScriptUtils.convertBoolean(isDynamicThreshold)}, true);
        this.roiManager.makeRangeROI(minResult, maxResult, excludeZero, allSeriesPoints, isDynamicThreshold);
    }

    private void doActionRangeROISlice(int sliceNum, int sliceDirection, double minResultVal, double maxResultVal, boolean isPercentMax, boolean excludeZero, boolean allSeriesPoints, boolean isDynamicThreshold) {
        double imageMax = this.getCurrentVolume().getImageMax();
        double minResult = minResultVal;
        double maxResult = maxResultVal;
        if (isPercentMax && !isDynamicThreshold) {
            minResult = imageMax * (minResult / 100.0);
            maxResult = imageMax * (maxResult / 100.0);
        }
        this.recordAction("runRangeToROISlice", new String[]{String.valueOf(minResultVal), String.valueOf(maxResultVal), this.getScriptSliceDirection(sliceDirection), this.getScriptSliceNumber(sliceNum), ScriptUtils.convertBoolean(isPercentMax), ScriptUtils.convertBoolean(excludeZero), ScriptUtils.convertBoolean(allSeriesPoints), ScriptUtils.convertBoolean(isDynamicThreshold)}, true);
        this.roiManager.makeRangeROI(sliceNum, sliceDirection, minResult, maxResult, excludeZero, allSeriesPoints, isDynamicThreshold);
    }

    private void doActionReflection(boolean vertical) {
        this.resetAllClipboardsContents();
        int sliceDirection = this.mainImage.getSliceDirection();
        int axis = vertical ? this.mainImage.getCurrentX() : this.mainImage.getCurrentY();
        int currentColor = this.roiManager.getCurrentROI();
        this.recordAction("runReflectROI", new String[]{this.getScriptSliceDirection(sliceDirection), String.valueOf(axis), ScriptUtils.convertBoolean(vertical), "True", "True", "True"}, true);
        if (this.hasSelectedPOIs()) {
            this.poiManager.reflectPOIs(sliceDirection, vertical, axis, currentColor, true);
        }
        if (this.hasSelectedLOIs()) {
            this.getLOIManagerMain().reflect(axis, vertical, currentColor, true);
        }
        this.repaint();
        if (this.hasSelectedROIs()) {
            this.roiManager.reflect(sliceDirection, axis, vertical);
        }
    }

    private void doActionReflectionSlice(boolean vertical) {
        this.resetAllClipboardsContents();
        int sliceDirection = this.mainImage.getSliceDirection();
        int sliceNumber = this.mainImage.getCurrentSlice();
        int axis = vertical ? this.mainImage.getCurrentX() : this.mainImage.getCurrentY();
        int currentColor = this.roiManager.getCurrentROI();
        this.recordAction("runReflectROISlice", new String[]{this.getScriptSliceDirection(sliceDirection), this.getScriptSliceNumber(sliceNumber), String.valueOf(axis), ScriptUtils.convertBoolean(vertical), "True", "True", "True"}, true);
        if (this.hasSelectedPOIs()) {
            this.poiManager.reflectSlicePOIs(sliceDirection, sliceNumber, vertical, axis, currentColor, true);
        }
        if (this.hasSelectedLOIs()) {
            this.getLOIManagerMain().reflectSlice(axis, vertical, sliceNumber, currentColor, true);
        }
        this.repaint();
        if (this.hasSelectedROIs()) {
            this.roiManager.runReflectSlice(sliceNumber, sliceDirection, axis, vertical);
        }
    }

    private void doActionShrinkWrap2D(int sliceDirection, double minResultVal, double maxResultVal, boolean within, boolean isPercentMax, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        double imageMax = this.getCurrentVolume().getImageMax();
        double minResult = minResultVal;
        double maxResult = maxResultVal;
        if (isPercentMax && !isDynamicThreshold) {
            minResult = imageMax * (minResult / 100.0);
            maxResult = imageMax * (maxResult / 100.0);
        }
        if (within) {
            this.recordAction("runShrinkWrapROISlice", new String[]{String.valueOf(minResultVal), this.getScriptSliceDirection(sliceDirection), this.getScriptSliceNumber(this.getMainSliceNumber()), this.getScriptObjectName() + ".roiData.selectedMask", this.getScriptObjectName() + ".roiColor", ScriptUtils.convertBoolean(isPercentMax), ScriptUtils.convertBoolean(isDynamicThreshold)}, true);
        } else {
            this.recordAction("runThresholdToShrinkWrapROISlice", new String[]{String.valueOf(minResultVal), this.getScriptSliceDirection(sliceDirection), this.getScriptSliceNumber(this.getMainSliceNumber()), ScriptUtils.convertBoolean(isPercentMax), ScriptUtils.convertBoolean(excludeZero), ScriptUtils.convertBoolean(isSeries), ScriptUtils.convertBoolean(isDynamicThreshold)}, true);
        }
        this.roiManager.shrinkWrap2D(this.mainImage.getCurrentSlice(), sliceDirection, minResult, maxResult, within, this.roiManager.getBuffer().getSelected(), this.roiManager.getCurrentROI(), excludeZero, isSeries, isDynamicThreshold, false);
    }

    private void doActionShrinkWrap2DAllSlices(int sliceDirection, double minResultVal, double maxResultVal, boolean within, boolean isPercentMax, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        double imageMax = this.getCurrentVolume().getImageMax();
        double minResult = minResultVal;
        double maxResult = maxResultVal;
        if (isPercentMax && !isDynamicThreshold) {
            minResult = imageMax * (minResult / 100.0);
            maxResult = imageMax * (maxResult / 100.0);
        }
        if (within) {
            this.recordAction("runShrinkWrapROIAllSlices", new String[]{String.valueOf(minResultVal), this.getScriptSliceDirection(sliceDirection), this.getScriptObjectName() + ".roiData.selectedMask", this.getScriptObjectName() + ".roiColor", ScriptUtils.convertBoolean(isPercentMax), ScriptUtils.convertBoolean(isDynamicThreshold)}, true);
        } else {
            this.recordAction("runThresholdToShrinkWrapROIAllSlices", new String[]{String.valueOf(minResultVal), this.getScriptSliceDirection(sliceDirection), ScriptUtils.convertBoolean(isPercentMax), ScriptUtils.convertBoolean(excludeZero), ScriptUtils.convertBoolean(isSeries), ScriptUtils.convertBoolean(isDynamicThreshold)}, true);
        }
        this.roiManager.shrinkWrap2D(-1, sliceDirection, minResult, maxResult, within, this.roiManager.getBuffer().getSelected(), this.roiManager.getCurrentROI(), excludeZero, isSeries, isDynamicThreshold, false);
    }

    private void doActionShrinkWrap3D(double minResultVal, double maxResultVal, boolean within, boolean isPercentMax, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        double imageMax = this.getCurrentVolume().getImageMax();
        double minResult = minResultVal;
        double maxResult = maxResultVal;
        if (isPercentMax && !isDynamicThreshold) {
            minResult = imageMax * (minResult / 100.0);
            maxResult = imageMax * (maxResult / 100.0);
        }
        if (within) {
            this.recordAction("runShrinkWrapROI", new String[]{String.valueOf(minResultVal), this.getScriptObjectName() + ".roiData.selectedMask", this.getScriptObjectName() + ".roiColor", ScriptUtils.convertBoolean(isPercentMax), ScriptUtils.convertBoolean(isDynamicThreshold)}, true);
        } else {
            this.recordAction("runThresholdToShrinkWrapROI", new String[]{String.valueOf(minResultVal), ScriptUtils.convertBoolean(isPercentMax), ScriptUtils.convertBoolean(excludeZero), ScriptUtils.convertBoolean(isSeries), ScriptUtils.convertBoolean(isDynamicThreshold)}, true);
        }
        this.roiManager.shrinkWrap3D(minResult, maxResult, this.getCurrentVolume(), within, this.roiManager.getBuffer().getSelected(), this.roiManager.getCurrentROI(), excludeZero, isSeries, isDynamicThreshold);
    }

    private void doActionThresholdROI(double minResultVal, boolean isPercentMax, boolean excludeZero, boolean allSeriesPoints, boolean isDynamicThreshold) {
        double imageMax = this.getCurrentVolume().getImageMax();
        double minResult = minResultVal;
        if (isPercentMax && !isDynamicThreshold) {
            minResult = imageMax * (minResult / 100.0);
        }
        this.recordAction("runThresholdToROI", new String[]{String.valueOf(minResultVal), ScriptUtils.convertBoolean(isPercentMax), ScriptUtils.convertBoolean(excludeZero), ScriptUtils.convertBoolean(allSeriesPoints), ScriptUtils.convertBoolean(isDynamicThreshold)}, true);
        this.roiManager.makeThresholdROI(minResult, excludeZero, allSeriesPoints, isDynamicThreshold);
    }

    private void doActionThresholdROISlice(int sliceNum, int sliceDirection, double minResultVal, boolean isPercentMax, boolean excludeZero, boolean allSeriesPoints, boolean isDynamicThreshold) {
        double imageMax = this.getCurrentVolume().getImageMax();
        double minResult = minResultVal;
        if (isPercentMax && !isDynamicThreshold) {
            minResult = imageMax * (minResult / 100.0);
        }
        this.recordAction("runThresholdToROISlice", new String[]{String.valueOf(minResultVal), this.getScriptSliceDirection(sliceDirection), this.getScriptSliceNumber(sliceNum), ScriptUtils.convertBoolean(isPercentMax), ScriptUtils.convertBoolean(excludeZero), ScriptUtils.convertBoolean(allSeriesPoints), ScriptUtils.convertBoolean(isDynamicThreshold)}, true);
        this.roiManager.makeThresholdROI(sliceNum, sliceDirection, minResult, excludeZero, allSeriesPoints, isDynamicThreshold);
    }

    private void doClear(boolean sameThread) {
        this.resetAllClipboardsUndo();
        if (this.hasSelectedPOIs()) {
            this.doClearPOI();
        }
        if (this.hasSelectedLOIs()) {
            this.doClearLOI();
        }
        if (this.hasSelectedROIs()) {
            this.doClearROI(sameThread, false);
        }
        this.mango.updateMenus();
        this.repaint();
    }

    private void doClearLOI() {
        if (this.isMultiSliceMode()) {
            this.loiManagerAxial.clearSelectedLOIs();
            this.loiManagerCoronal.clearSelectedLOIs();
            this.loiManagerSagittal.clearSelectedLOIs();
        } else {
            this.mainImage.getLOIManager().clearSelectedLOIsInSlice(this.getMainSliceNumber());
        }
        this.repaint();
    }

    private void doClearPOI() {
        if (this.isMultiSliceMode()) {
            this.poiManager.removeSelectedPOIs();
        } else {
            this.poiManager.removeSelectedPOIsInSlice(this.getMainSliceNumber(), this.getMainSliceDirection());
        }
        this.repaint();
        if (this.timeseries.getParentFrame() != null) {
            ((TimeseriesTool)this.timeseries.getParentFrame()).selectionChanged();
        }
    }

    private void doClearROI(boolean sameThread, boolean forceClear) {
        if (!this.isEditingDisabled() || forceClear) {
            if (this.toolBox.isVOIMode()) {
                if (sameThread) {
                    this.roiManager.doClearSelected(true);
                } else {
                    this.roiManager.clearSelected(true);
                }
            } else {
                int sliceDirection = this.mainImage.getSliceDirection();
                int zMin = 0;
                int yMin = 0;
                int xMin = 0;
                int xMax = this.volume.getXDim();
                int yMax = this.volume.getYDim();
                int zMax = this.volume.getZDim();
                if (sliceDirection == 0) {
                    zMin = zMax = this.roiManager.getSelectedSlice(sliceDirection);
                } else if (sliceDirection == 1) {
                    yMin = yMax = this.roiManager.getSelectedSlice(sliceDirection);
                } else if (sliceDirection == 2) {
                    xMin = xMax = this.roiManager.getSelectedSlice(sliceDirection);
                }
                this.roiManager.clearSelected(xMin, xMax, yMin, yMax, zMin, zMax, true, sameThread);
            }
        }
    }

    private void doConvexHull(long mask, int output, boolean isDynamicThreshold, boolean sameThread) {
        boolean isVOIMode = this.toolBox.isVOIMode();
        if (isVOIMode) {
            if (sameThread) {
                this.roiManager.runConvexHull(0.0, 0.0, true, true, mask, output, false, false, isDynamicThreshold);
            } else {
                this.roiManager.makeConvexHullROI(0.0, 0.0, true, true, mask, output, false, false, isDynamicThreshold);
            }
        } else {
            this.roiManager.runConvexHullROI(this.getMainSliceNumber(), this.getMainSliceDirection(), 0.0, 0.0, true, true, mask, output, false, false, isDynamicThreshold);
        }
    }

    private void doFillInsideROI() {
        StringBuffer input = new StringBuffer("0");
        this.recordAction("runOperation", new String[]{ScriptUtils.convertString(input.toString()), String.valueOf(2), "False", "False", "False"});
        ImageCalcExpressionImpl op = new ImageCalcExpressionImpl(input.toString(), this, 2, false, false);
        this.doOperationImage(op, true);
    }

    private void doFillOutsideROI() {
        StringBuffer input = new StringBuffer("0");
        this.recordAction("runOperation", new String[]{ScriptUtils.convertString(input.toString()), String.valueOf(3), "False", "False", "False"});
        ImageCalcExpressionImpl op = new ImageCalcExpressionImpl(input.toString(), this, 3, false, false);
        this.doOperationImage(op, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doImportROI(URI uri, final boolean forceWorld, final boolean isMangoROI, boolean sameThread) {
        try {
            this.startIndeterminateProgressBar();
            this.navigationDisabled = true;
            final Volume importVolume = new Volume();
            importVolume.setReadOnly(isMangoROI);
            importVolume.setUser(this);
            importVolume.readFiles(uri);
            this.navigationDisabled = false;
            this.endIndeterminateProgressBar();
            this.roiManager.makeROIBuffer();
            if (sameThread) {
                this.roiManager.doImportROI(importVolume, forceWorld, isMangoROI);
            } else {
                SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SliceViewer.this.roiManager.importROI(importVolume, forceWorld, isMangoROI);
                    }
                });
            }
        }
        catch (InvalidHeaderException ex) {
            this.endIndeterminateProgressBar();
            AppLogger.error((Throwable)ex);
            this.showErrorDialog("Problem loading image file!\n" + ex.getMessage(), TEXT_IMAGE_LOAD_FAILED);
        }
        catch (OutOfMemoryError err) {
            AppLogger.error((Throwable)err);
            this.mango.showOutOfMemoryMessage();
            this.endIndeterminateProgressBar();
        }
        catch (VolumeIOException ex) {
            this.endIndeterminateProgressBar();
            AppLogger.error((Throwable)ex);
            this.showErrorDialog("Problem loading image file!\n" + ex.getMessage(), TEXT_IMAGE_LOAD_FAILED);
        }
        finally {
            this.navigationDisabled = false;
            this.mango.loadNextViewer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadMangoROI(URI externalROIFile, boolean sameThread) {
        this.setROIFile(externalROIFile);
        try {
            this.startIndeterminateProgressBar();
            this.navigationDisabled = true;
            final Volume roiVol = new Volume();
            roiVol.setReadOnly(true);
            roiVol.setUser(this);
            roiVol.readFiles(externalROIFile);
            byte[] vectorData = roiVol.getExtension();
            String xmlStr = null;
            if (vectorData != null && vectorData.length > 0) {
                boolean hasShapes;
                ByteBuffer vecBuffer = ByteBuffer.wrap(vectorData);
                vecBuffer.order(roiVol.getImageType().isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                boolean readOldMetaData = false;
                int poiStart = 8;
                vecBuffer.position(8);
                int poiSize = vecBuffer.getInt();
                int loiAxialStart = 8 + poiSize + 4;
                vecBuffer.position(loiAxialStart);
                int loiAxialSize = vecBuffer.getInt();
                int loiCoronalStart = loiAxialStart + loiAxialSize + 4;
                vecBuffer.position(loiCoronalStart);
                int loiCoronalSize = vecBuffer.getInt();
                int loiSagittalStart = loiCoronalStart + loiCoronalSize + 4;
                vecBuffer.position(loiSagittalStart);
                int loiSagittalSize = vecBuffer.getInt();
                int labelStaticStart = loiSagittalStart + loiSagittalSize + 4;
                vecBuffer.position(labelStaticStart);
                int labelStaticSize = 0;
                int remaining = vecBuffer.limit() - vecBuffer.position();
                if (remaining >= 4) {
                    labelStaticSize = vecBuffer.getInt();
                }
                if (poiSize > 0) {
                    readOldMetaData = true;
                    byte[] poiData = new byte[poiSize];
                    System.arraycopy(vectorData, 12, poiData, 0, poiData.length);
                    boolean hasPoints = this.poiManager.hasPoints();
                    this.poiManager.putData(poiData);
                    this.poiManager.setDirty(hasPoints);
                }
                if (loiAxialSize > 0) {
                    readOldMetaData = true;
                    byte[] loiAxialData = new byte[loiAxialSize];
                    System.arraycopy(vectorData, loiAxialStart + 4, loiAxialData, 0, loiAxialData.length);
                    hasShapes = this.loiManagerAxial.hasShapes();
                    this.loiManagerAxial.putData(loiAxialData);
                    this.loiManagerAxial.setDirty(hasShapes);
                }
                if (loiCoronalSize > 0) {
                    readOldMetaData = true;
                    byte[] loiCoronalData = new byte[loiCoronalSize];
                    System.arraycopy(vectorData, loiCoronalStart + 4, loiCoronalData, 0, loiCoronalData.length);
                    hasShapes = this.loiManagerCoronal.hasShapes();
                    this.loiManagerCoronal.putData(loiCoronalData);
                    this.loiManagerCoronal.setDirty(hasShapes);
                }
                if (loiSagittalSize > 0) {
                    readOldMetaData = true;
                    byte[] loiSagittalData = new byte[loiSagittalSize];
                    System.arraycopy(vectorData, loiSagittalStart + 4, loiSagittalData, 0, loiSagittalData.length);
                    hasShapes = this.loiManagerSagittal.hasShapes();
                    this.loiManagerSagittal.putData(loiSagittalData);
                    this.loiManagerSagittal.setDirty(hasShapes);
                }
                if (labelStaticSize > 0) {
                    readOldMetaData = true;
                    byte[] labelData = new byte[labelStaticSize];
                    System.arraycopy(vectorData, labelStaticStart + 4, labelData, 0, labelData.length);
                    this.roiManager.setLabelData(labelData);
                }
                if (!readOldMetaData) {
                    int headerSize = 28;
                    int xmlSize = vectorData.length - 28;
                    byte[] xmlData = new byte[xmlSize];
                    System.arraycopy(vectorData, 28, xmlData, 0, xmlSize);
                    xmlStr = new String(xmlData, "utf-8");
                }
            }
            this.navigationDisabled = false;
            this.endIndeterminateProgressBar();
            if (sameThread) {
                this.roiManager.doLoadROI(roiVol, xmlStr, true);
            } else {
                final String xmlStrF = xmlStr;
                SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SliceViewer.this.roiManager.loadROI(roiVol, xmlStrF);
                    }
                });
            }
        }
        catch (OutOfMemoryError err) {
            this.endIndeterminateProgressBar();
            AppLogger.error((Throwable)err);
            this.mango.showOutOfMemoryMessage();
            this.navigationDisabled = false;
        }
        catch (UnsupportedEncodingException ex) {
            this.endIndeterminateProgressBar();
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog("Problem loading ROI!\n" + ex.getMessage(), TITLE_ROI_LOAD_FAILED);
            this.navigationDisabled = false;
        }
        catch (InvalidHeaderException ex) {
            this.endIndeterminateProgressBar();
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog("Problem loading ROI!\n" + ex.getMessage(), TITLE_ROI_LOAD_FAILED);
            this.navigationDisabled = false;
        }
        catch (VolumeIOException ex) {
            this.endIndeterminateProgressBar();
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog("Problem loading ROI!\n" + ex.getMessage(), TITLE_ROI_LOAD_FAILED);
            this.navigationDisabled = false;
        }
        finally {
            this.mango.loadNextViewer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadOverlay(URI uriVal, String lutName, boolean isParametric, boolean sameThread) {
        URI uri = uriVal;
        try {
            this.setNavigationDisabled(true);
            this.startIndeterminateProgressBar();
            boolean isLocalFile = FileUtilities.uriIsFile((URI)uri);
            Volume overlayVolume = new Volume();
            overlayVolume.setUser(this);
            overlayVolume.addListener(this);
            overlayVolume.setLabelListener(this);
            if (isLocalFile) {
                uri = overlayVolume.readHeader(uri);
                int numTimepoints = overlayVolume.getNumTimepoints();
                if (!sameThread && numTimepoints > 1 && overlayVolume.supportsTimeseriesSelection()) {
                    this.showTimeseriesSelectionDialog(overlayVolume, numTimepoints);
                }
                overlayVolume.doReadFiles();
            } else {
                overlayVolume.readFiles(uri);
            }
            overlayVolume.readLabelData();
            if (overlayVolume.getImageMax() > overlayVolume.getImageMin()) {
                this.loadOverlayLoadItem(new OverlayLoadItem(overlayVolume, isParametric, uri, lutName));
            } else if (sameThread) {
                overlayVolume.updateMaxMin(overlayVolume.findRangeSeries());
                this.loadOverlayLoadItem(new OverlayLoadItem(overlayVolume, isParametric, uri, lutName));
            } else {
                overlayVolume.findRangeVolumeAsync(new OverlayLoadItem(overlayVolume, isParametric, uri, lutName));
            }
        }
        catch (InvalidHeaderException ex) {
            AppLogger.info((Throwable)ex);
            this.mango.showErrorDialog(TEXT_PROBLEM_LOADING_IMAGE_FILE + ex.getMessage(), TEXT_IMAGE_LOAD_FAILED);
        }
        catch (VolumeIOException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog("Problem loading image file!\nCheck permissions!", TEXT_IMAGE_LOAD_FAILED);
        }
        catch (OutOfMemoryError err) {
            AppLogger.error((Throwable)err);
            this.mango.showOutOfMemoryMessage();
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.info((Throwable)ex);
            this.mango.showErrorDialog(TEXT_PROBLEM_LOADING_IMAGE_FILE + ex.getMessage(), TEXT_IMAGE_LOAD_FAILED);
        }
        finally {
            this.endIndeterminateProgressBar();
            this.setNavigationDisabled(false);
        }
    }

    private void doOperationImage(ImageCalcExpression expression, boolean newThread) {
        CalcOp op = new CalcOp(Mango.getInstance(), this, expression);
        if (this.isMultiSliceMode()) {
            if (newThread) {
                OperationBuilder<Void> builder = new OperationBuilder<Void>(this, op);
                builder.runAsynchronously(this);
            } else {
                OperationBuilder<Void> builder = new OperationBuilder<Void>(this, op);
                builder.runSynchronously();
                this.updateViewer();
            }
        } else {
            int sliceDirection = this.getMainSliceDirection();
            int zMin = 0;
            int yMin = 0;
            int xMin = 0;
            int xMax = this.volume.getXDim() - 1;
            int yMax = this.volume.getYDim() - 1;
            int zMax = this.volume.getZDim() - 1;
            if (sliceDirection == 0) {
                zMin = zMax = this.mainImage.getCurrentSlice();
            } else if (sliceDirection == 1) {
                yMin = yMax = this.mainImage.getCurrentSlice();
            } else if (sliceDirection == 2) {
                xMin = xMax = this.mainImage.getCurrentSlice();
            }
            if (op.testProcessValidity()) {
                op.process(new ImageBounds(xMin, xMax, yMin, yMax, zMin, zMax));
                this.operationFinished(null, this.volume);
            } else {
                this.showErrorMessage("Problem running that operation!", "Operation Error");
            }
        }
    }

    private void doOperationRankFilterImage(AbstractFilterRank filter) {
        if (this.volume.isOperationInProgress()) {
            return;
        }
        this.prepareFilter();
        this.recordAction("runRankFilter", new String[]{String.valueOf(filter.getSize()), String.valueOf(filter.getRankType()), String.valueOf(filter.getFilterType())});
        FilterOp filterOp = new FilterOp(this, this);
        filterOp.processRankFilter(filter, this.filterBuffer);
    }

    private void doOperationROI(ROIOperationTreeNode op, int color, boolean sameThread) {
        this.roiManager.setCurrentROI(color);
        this.roiManager.operationROI(op, sameThread);
    }

    private void doOperationROI(ROIOperationTreeNode op, int color, int sliceNum, int sliceDirection, boolean sameThread) {
        this.roiManager.setCurrentROI(color);
        this.roiManager.operationROI(op, sliceNum, sliceDirection, sameThread);
    }

    private void doOperationTimeStats(boolean newThread) {
        if (this.volume.isOperationInProgress()) {
            return;
        }
        if (this.startOperation == null) {
            return;
        }
        CalcSeriesOp calcOp = new CalcSeriesOp(this, this);
        if (newThread) {
            calcOp.processOperationSeriesStat(this.startOperation);
        } else {
            calcOp.runOperationSeriesStat(this.startOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReadOldROIFormat(URI externalROIFile) {
        this.setROIFile(externalROIFile);
        this.roiManager.makeROIBuffer();
        BufferedInputStream input = null;
        byte[] buffer = new byte[2048];
        try {
            int totalBytesRead;
            int bytesRead;
            this.startIndeterminateProgressBar();
            this.navigationDisabled = true;
            input = FileUtilities.getInputStream((URI)externalROIFile, (boolean)true);
            byte[] poiSizeBytes = new byte[4];
            for (totalBytesRead = bytesRead = input.read(poiSizeBytes); totalBytesRead < poiSizeBytes.length; totalBytesRead += bytesRead) {
                bytesRead = input.read(poiSizeBytes, totalBytesRead, poiSizeBytes.length - totalBytesRead);
            }
            ByteBuffer poiSizeBuffer = ByteBuffer.wrap(poiSizeBytes);
            int poiSize = poiSizeBuffer.getInt();
            if (poiSize > 0) {
                byte[] poiBytes = new byte[poiSize];
                for (totalBytesRead = bytesRead = input.read(poiBytes); totalBytesRead < poiSize; totalBytesRead += bytesRead) {
                    bytesRead = input.read(poiBytes, totalBytesRead, poiSize - totalBytesRead);
                }
                this.poiManager.putData(poiBytes);
            }
            byte[] loiSizeBytes = new byte[12];
            for (totalBytesRead = bytesRead = input.read(loiSizeBytes); totalBytesRead < loiSizeBytes.length; totalBytesRead += bytesRead) {
                bytesRead = input.read(loiSizeBytes, totalBytesRead, loiSizeBytes.length - totalBytesRead);
            }
            ByteBuffer loiSizeBuffer = ByteBuffer.wrap(loiSizeBytes);
            int axialLOISize = loiSizeBuffer.getInt();
            int coronalLOISize = loiSizeBuffer.getInt();
            int sagittalLOISize = loiSizeBuffer.getInt();
            if (axialLOISize > 0) {
                byte[] axialBytes = new byte[axialLOISize];
                for (totalBytesRead = bytesRead = input.read(axialBytes); totalBytesRead < axialLOISize; totalBytesRead += bytesRead) {
                    bytesRead = input.read(axialBytes, totalBytesRead, axialLOISize - totalBytesRead);
                }
                this.loiManagerAxial.putData(axialBytes);
            }
            if (coronalLOISize > 0) {
                byte[] coronalBytes = new byte[coronalLOISize];
                for (totalBytesRead = bytesRead = input.read(coronalBytes); totalBytesRead < coronalLOISize; totalBytesRead += bytesRead) {
                    bytesRead = input.read(coronalBytes, totalBytesRead, coronalLOISize - totalBytesRead);
                }
                this.loiManagerCoronal.putData(coronalBytes);
            }
            if (sagittalLOISize > 0) {
                byte[] sagittalBytes = new byte[sagittalLOISize];
                for (totalBytesRead = bytesRead = input.read(sagittalBytes); totalBytesRead < sagittalLOISize; totalBytesRead += bytesRead) {
                    bytesRead = input.read(sagittalBytes, totalBytesRead, sagittalLOISize - totalBytesRead);
                }
                this.loiManagerSagittal.putData(sagittalBytes);
            }
            if ((bytesRead = input.read(buffer)) != -1) {
                this.roiManager.makeROIBuffer();
                AbstractROIBuffer roiBuffer = this.roiManager.getBuffer();
                long bytesReadTotal = 0L;
                int fileDims = (this.volume.getXDim() + 1) * (this.volume.getYDim() + 1) * (this.volume.getZDim() + 1);
                long roiMask = 0L;
                block21: while (bytesRead != -1) {
                    for (int ctr = 0; ctr < bytesRead; ++ctr) {
                        roiMask |= (long)buffer[ctr];
                        int offset = (int)(bytesReadTotal + (long)ctr);
                        if (offset >= fileDims) {
                            bytesReadTotal = -1L;
                            break block21;
                        }
                        roiBuffer.putCurrent(offset, buffer[ctr] & 0xFF);
                    }
                    bytesReadTotal += (long)bytesRead;
                    bytesRead = input.read(buffer);
                }
                if (bytesReadTotal != (long)fileDims) {
                    throw new IllegalStateException("ROI file size does not match image size!");
                }
                int maxColors = this.roiManager.getMaximumColors();
                if (roiBuffer != null) {
                    int ctr;
                    for (ctr = 0; ctr < maxColors; ++ctr) {
                        if ((roiMask >> ctr & 1L) != 1L) continue;
                        this.roiManager.initROI(ctr);
                    }
                    for (ctr = 0; ctr < maxColors && (roiMask >> ctr & 1L) != 1L; ++ctr) {
                    }
                    this.roiManager.setCurrentROI(ctr % maxColors);
                }
            }
        }
        catch (IllegalStateException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog("Problem loading ROI file!\n" + ex.getMessage(), TITLE_ROI_LOAD_FAILED);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog("Problem loading ROI file!\n" + ex.getMessage(), TITLE_ROI_LOAD_FAILED);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
            this.importROICompleted(null, null);
            this.navigationDisabled = false;
            this.endIndeterminateProgressBar();
            this.mango.loadNextViewer();
        }
    }

    private void doSaveROI(File selectedFileVal, int selectedSaveIndex) {
        File selectedFile = selectedFileVal;
        if (selectedFile == null) {
            selectedFile = this.roiFileGZIP;
            if (selectedFile == null) {
                this.makeROIGZIPFile();
                selectedFile = this.roiFileGZIP;
            }
        } else {
            this.roiFileGZIP = selectedFile;
        }
        String ext = ".nii.gz";
        String filename = selectedFile.getName();
        if (!filename.endsWith(".nii.gz")) {
            selectedFile = this.roiFileGZIP = new File(this.roiFileGZIP.getParent(), this.roiFileGZIP.getName() + "." + "nii" + ".gz");
        }
        if (this.isROIEmpty()) {
            if (this.roiFileGZIP.exists()) {
                FileUtilities.delete((File)this.roiFileGZIP);
            }
            this.roiSaved(true, null);
            return;
        }
        File file = selectedFile;
        if (this.canWriteROIFile()) {
            this.setNavigationDisabled(true);
            this.roiManager.doSaveROI(file, selectedSaveIndex);
            this.setNavigationDisabled(false);
        }
    }

    private void doThresholdToROI(double minResult, double maxResult, boolean isRange, boolean isShrinkWrap, boolean isConvexHull, boolean isPercentMax, boolean isExcludeZero, boolean isSeries, boolean isDynamicThreshold, int direction, boolean shrinkWrapROI, String labelText) {
        if (isConvexHull) {
            this.doConvexHull(minResult, maxResult, isPercentMax, isExcludeZero, false, this.getROIManager().getBuffer().getSelected(), isRange, isSeries, isDynamicThreshold);
        } else if (isRange) {
            if (isShrinkWrap) {
                if (this.isMultiSliceMode()) {
                    if (direction == 0) {
                        this.doActionShrinkWrap2DAllSlices(0, minResult, maxResult, shrinkWrapROI, isPercentMax, isExcludeZero, isSeries, isDynamicThreshold);
                    } else if (direction == 1) {
                        this.doActionShrinkWrap2DAllSlices(1, minResult, maxResult, shrinkWrapROI, isPercentMax, isExcludeZero, isSeries, isDynamicThreshold);
                    } else if (direction == 2) {
                        this.doActionShrinkWrap2DAllSlices(2, minResult, maxResult, shrinkWrapROI, isPercentMax, isExcludeZero, isSeries, isDynamicThreshold);
                    } else {
                        this.doActionShrinkWrap3D(minResult, maxResult, shrinkWrapROI, isPercentMax, isExcludeZero, isSeries, isDynamicThreshold);
                    }
                } else {
                    this.doActionShrinkWrap2D(direction, minResult, maxResult, shrinkWrapROI, isPercentMax, isExcludeZero, isSeries, isDynamicThreshold);
                }
            } else if (this.isMultiSliceMode()) {
                this.doActionRangeROI(minResult, maxResult, isPercentMax, isExcludeZero, isSeries, isDynamicThreshold);
            } else {
                this.doActionRangeROISlice(this.getMainSliceNumber(), this.getMainSliceDirection(), minResult, maxResult, isPercentMax, isExcludeZero, isSeries, isDynamicThreshold);
            }
        } else if (isShrinkWrap) {
            if (this.isMultiSliceMode()) {
                if (direction == 0) {
                    this.doActionShrinkWrap2DAllSlices(0, minResult, Double.MAX_VALUE, shrinkWrapROI, isPercentMax, isExcludeZero, isSeries, isDynamicThreshold);
                } else if (direction == 1) {
                    this.doActionShrinkWrap2DAllSlices(1, minResult, Double.MAX_VALUE, shrinkWrapROI, isPercentMax, isExcludeZero, isSeries, isDynamicThreshold);
                } else if (direction == 2) {
                    this.doActionShrinkWrap2DAllSlices(2, minResult, Double.MAX_VALUE, shrinkWrapROI, isPercentMax, isExcludeZero, isSeries, isDynamicThreshold);
                } else {
                    this.doActionShrinkWrap3D(minResult, Double.MAX_VALUE, shrinkWrapROI, isPercentMax, isExcludeZero, isSeries, isDynamicThreshold);
                }
            } else {
                this.doActionShrinkWrap2D(direction, minResult, Double.MAX_VALUE, shrinkWrapROI, isPercentMax, isExcludeZero, isSeries, isDynamicThreshold);
            }
        } else if (this.isMultiSliceMode()) {
            this.doActionThresholdROI(minResult, isPercentMax, isExcludeZero, isSeries, isDynamicThreshold);
        } else {
            this.doActionThresholdROISlice(this.getMainSliceNumber(), this.getMainSliceDirection(), minResult, isPercentMax, isExcludeZero, isSeries, isDynamicThreshold);
        }
        if (StringUtils.isNotBlank((CharSequence)labelText)) {
            this.setLabel(this.roiManager.getROI(this.roiManager.getCurrentROI()), labelText);
        }
    }

    private void doUndoROI(boolean sameThread) {
        this.roiManager.undoROI(sameThread);
    }

    private void doVolumeLoaded(boolean success, boolean sameThread) {
        this.setImageLoaded(success);
        if (this.isImageLoaded()) {
            AddImageDialog.setLastViewerParams(this.volume.getImageDimensions(), this.volume.getVoxelDimensions(), this.volume.getImageType(), this.volume.getOrientationString());
            this.addToFrame();
            if (this.frame != null) {
                this.frame.updateSeriesManager();
            }
            AppLogger.info((String)("Image [" + this.getImageTitle() + "] loaded"));
            if (this.startOperation != null) {
                this.endIndeterminateProgressBar();
                if (this.startOperation.getType() == 1) {
                    this.doOperationTimeStats(!sameThread);
                } else {
                    this.doOperationImage(this.startOperation, !sameThread);
                }
            }
        } else if (!this.mango.isApplet()) {
            this.notifyAllListenersOfClosing();
            this.clear();
            this.mango.removeViewer(this);
            this.mango.loadNextViewer();
            this.mango = null;
        }
    }

    private ScreenVolume findFirstOverlayTimeseries() {
        ScreenVolume[] overlays = this.overlayManager.getAllOverlays();
        if (overlays != null) {
            for (ScreenVolume overlay : overlays) {
                if (overlay == null || overlay.getVolume().getNumTimepoints() <= 1) continue;
                return overlay;
            }
        }
        return null;
    }

    private Volume findNextOverlayToSave(Volume lastSavedOverlayVol) {
        ScreenVolume[] screenVolumes = this.overlayManager.getAllOverlays();
        boolean found = lastSavedOverlayVol == null;
        for (ScreenVolume overlayScreenVol : screenVolumes) {
            if (overlayScreenVol == null) continue;
            if (found) {
                Volume overlayVol = overlayScreenVol.getVolume();
                File overlayFile = new File(overlayScreenVol.getURI());
                if (!overlayVol.isDirty() || overlayVol.cannotBeOverwritten() || !overlayVol.isWritable(overlayFile)) continue;
                return overlayVol;
            }
            if (overlayScreenVol.getVolume() != lastSavedOverlayVol) continue;
            found = true;
        }
        return null;
    }

    private ScreenVolume findTopOverlayTimeseries() {
        if (this.getCurrentScreenVolume() == this.getScreenVolume()) {
            return this.findFirstOverlayTimeseries();
        }
        if (this.getCurrentScreenVolume().getVolume().getNumTimepoints() > 1) {
            return this.getCurrentScreenVolume();
        }
        return this.findFirstOverlayTimeseries();
    }

    private ScreenVolume findVolume(ImageVolume volume) {
        ScreenVolume screenVol = this.findOverlay((Volume)volume);
        if (screenVol == null) {
            screenVol = this.getBaseScreenVolume();
        }
        return screenVol;
    }

    private Coordinate getCurrentCoordinate(ScreenVolume aScreenVol, Coordinate coor, Coordinate coorNew) {
        return this.getCurrentCoordinate(aScreenVol, coor, coorNew, false);
    }

    private Coordinate getCurrentWorldCoordinate(Coordinate coor) {
        return this.getCurrentCoordinate(this.baseScreenVolume, null, coor, false, false, true);
    }

    private String getImageTitle(ScreenVolume sv) {
        String name = null;
        if (sv.getVolume() != null && StringUtils.isBlank((CharSequence)(name = sv.getVolume().getTitle()))) {
            name = StringUtilities.makeNiceImageName((String)FileUtilities.getName((URI)sv.getURI()));
        }
        return name;
    }

    private ImageBounds getMainScreenSliceBounds() {
        ImageBounds ib = null;
        int sliceDirection = this.getMainSliceDirection();
        if (sliceDirection == 0) {
            ib = new ImageBounds(0, this.getXDim() - 1, 0, this.getYDim() - 1, this.getMainSliceNumber(), this.getMainSliceNumber());
        } else if (sliceDirection == 1) {
            ib = new ImageBounds(0, this.getXDim() - 1, this.getMainSliceNumber(), this.getMainSliceNumber(), 0, this.getZDim() - 1);
        } else if (sliceDirection == 1) {
            ib = new ImageBounds(this.getMainSliceNumber(), this.getMainSliceNumber(), 0, this.getYDim() - 1, 0, this.getZDim() - 1);
        }
        return ib;
    }

    private String getScriptSliceDirection(int sliceDirection) {
        if (sliceDirection == this.getMainSliceDirection()) {
            return this.getScriptObjectName() + ".sliceDirection";
        }
        return String.valueOf(sliceDirection);
    }

    private String getScriptSliceNumber(int sliceNumber) {
        if (sliceNumber == this.getMainSliceNumber()) {
            return this.getScriptObjectName() + ".sliceNumber";
        }
        return this.getScriptObjectName() + ".sliceNumber" + " - " + (this.getMainSliceNumber() - sliceNumber);
    }

    protected void getTransformParameters(ScreenSlice image, AffineTransform transform, double width, boolean lower) {
        double scaleY;
        double scaleX;
        double bigScale;
        double d = bigScale = lower ? 2.0 : 1.0;
        if (image.getXmm() > image.getYmm()) {
            scaleX = width / (double)this.getLongestDim() / bigScale * (image.getXSize() / this.getLongestDimSize());
            scaleY = width / (double)this.getLongestDim() * image.getYXratio() / bigScale * (image.getXSize() / this.getLongestDimSize());
        } else {
            scaleX = width / (double)this.getLongestDim() * image.getXYratio() / bigScale * (image.getYSize() / this.getLongestDimSize());
            scaleY = width / (double)this.getLongestDim() / bigScale * (image.getYSize() / this.getLongestDimSize());
        }
        double transX = (width / bigScale - (double)image.getXdim() * scaleX) / 2.0;
        double transY = (width / bigScale - (double)image.getYdim() * scaleY) / 2.0;
        transform.setTransform(scaleX, 0.0, 0.0, scaleY, transX, transY);
    }

    private boolean hasDirtyLOIManager() {
        return this.loiManagerAxial.isDirty() || this.loiManagerCoronal.isDirty() || this.loiManagerSagittal.isDirty();
    }

    private boolean hasRedoLOI() {
        if (this.loiManagerAxial.hasRedo()) {
            return true;
        }
        if (this.loiManagerCoronal.hasRedo()) {
            return true;
        }
        return this.loiManagerSagittal.hasRedo();
    }

    private boolean hasRedoPOI() {
        return this.poiManager.hasRedo();
    }

    private boolean hasRedoROI() {
        return this.roiManager.hasRedo();
    }

    private boolean hasSelectedROIInCurrentSlice() {
        int sliceStatsDirection = this.mainImage.getSliceDirection();
        int sliceStatsCurrentSlice = this.mainImage.getCurrentSlice();
        if (sliceStatsDirection == 0) {
            return this.roiManager.hasSelectedInRange(0, this.volume.getXDim() - 1, 0, this.volume.getYDim() - 1, sliceStatsCurrentSlice, sliceStatsCurrentSlice);
        }
        if (sliceStatsDirection == 1) {
            return this.roiManager.hasSelectedInRange(0, this.volume.getXDim() - 1, sliceStatsCurrentSlice, sliceStatsCurrentSlice, 0, this.volume.getZDim() - 1);
        }
        return this.roiManager.hasSelectedInRange(sliceStatsCurrentSlice, sliceStatsCurrentSlice, 0, this.volume.getYDim() - 1, 0, this.volume.getZDim() - 1);
    }

    private boolean hasUndoLOI() {
        if (this.loiManagerAxial.hasUndo()) {
            return true;
        }
        if (this.loiManagerCoronal.hasUndo()) {
            return true;
        }
        return this.loiManagerSagittal.hasUndo();
    }

    private boolean hasUndoPOI() {
        return this.poiManager.hasUndo();
    }

    private boolean hasUndoROI() {
        return this.roiManager.hasUndo();
    }

    private boolean hasVolume() {
        return this.volume != null;
    }

    private void importROI(final URI uri, final boolean forceWorld, final boolean isMangoROI, final boolean sameThread) {
        if (sameThread) {
            this.doImportROI(uri, forceWorld, isMangoROI, sameThread);
        } else {
            Thread workThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    SliceViewer.this.doImportROI(uri, forceWorld, isMangoROI, sameThread);
                }
            });
            workThread.start();
        }
    }

    private void initializeAngle() {
        Vector<Point> axialPoints = this.angleShape.getAxialPoints();
        Point point = new Point();
        point.x = (int)((double)this.getXDim(0) * 0.25);
        point.y = (int)((double)this.getYDim(0) * 0.25);
        axialPoints.add(point);
        point = new Point();
        point.x = (int)((double)this.getXDim(0) * 0.75);
        point.y = (int)((double)this.getYDim(0) * 0.5);
        axialPoints.add(point);
        point = new Point();
        point.x = (int)((double)this.getXDim(0) * 0.25);
        point.y = (int)((double)this.getYDim(0) * 0.75);
        axialPoints.add(point);
        Vector<Point> coronalPoints = this.angleShape.getCoronalPoints();
        point = new Point();
        point.x = (int)((double)this.getXDim(1) * 0.25);
        point.y = (int)((double)this.getYDim(1) * 0.25);
        coronalPoints.add(point);
        point = new Point();
        point.x = (int)((double)this.getXDim(1) * 0.75);
        point.y = (int)((double)this.getYDim(1) * 0.5);
        coronalPoints.add(point);
        point = new Point();
        point.x = (int)((double)this.getXDim(1) * 0.25);
        point.y = (int)((double)this.getYDim(1) * 0.75);
        coronalPoints.add(point);
        Vector<Point> sagittalPoints = this.angleShape.getSagittalPoints();
        point = new Point();
        point.x = (int)((double)this.getXDim(2) * 0.25);
        point.y = (int)((double)this.getYDim(2) * 0.25);
        sagittalPoints.add(point);
        point = new Point();
        point.x = (int)((double)this.getXDim(2) * 0.75);
        point.y = (int)((double)this.getYDim(2) * 0.5);
        sagittalPoints.add(point);
        point = new Point();
        point.x = (int)((double)this.getXDim(2) * 0.25);
        point.y = (int)((double)this.getYDim(2) * 0.75);
        sagittalPoints.add(point);
    }

    private void initializeLOIManagers() {
        this.loiManagerAxial = new LOIManager(this.volume.getZDim(), 0, this, this);
        this.loiManagerCoronal = new LOIManager(this.volume.getYDim(), 1, this, this);
        this.loiManagerSagittal = new LOIManager(this.volume.getXDim(), 2, this, this);
        this.axialImage.setLOIManager(this.loiManagerAxial, this.loiManagerCoronal, this.loiManagerSagittal);
        this.coronalImage.setLOIManager(this.loiManagerCoronal, this.loiManagerSagittal, this.loiManagerAxial);
        this.sagittalImage.setLOIManager(this.loiManagerSagittal, this.loiManagerAxial, this.loiManagerCoronal);
        this.loiManagerAxialP = new LOISpecialManager(this.volume.getZDim(), 0, this, this);
        this.loiManagerCoronalP = new LOISpecialManager(this.volume.getYDim(), 1, this, this);
        this.loiManagerSagittalP = new LOISpecialManager(this.volume.getXDim(), 2, this, this);
        this.axialImage.setLOISpecialManager(this.loiManagerAxialP);
        this.coronalImage.setLOISpecialManager(this.loiManagerCoronalP);
        this.sagittalImage.setLOISpecialManager(this.loiManagerSagittalP);
    }

    private void initializeOverlay(ScreenVolume overlay) {
        this.initializeOverlay(overlay, false, 0.0, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeOverlay(ScreenVolume overlay, boolean explicit, double minVal, double maxVal) {
        double min = minVal;
        double max = maxVal;
        try {
            if (this.toolBox.isOverlayGroup()) {
                if (this.toolBox.isGlobal()) {
                    SliceViewer[] viewers = Mango.getAllSliceViewers();
                    boolean found = false;
                    block3: for (int ctr = 0; ctr < viewers.length; ++ctr) {
                        SliceViewer aViewer = viewers[ctr];
                        OverlayManager aManager = aViewer.overlayManager;
                        int numOverlays = aManager.getNumInStack();
                        if (numOverlays <= 0) continue;
                        ScreenVolume[] overlays = aManager.getAllOverlays();
                        for (int ctrIn = 0; ctrIn < overlays.length; ++ctrIn) {
                            if (overlays[ctrIn] == null || overlays[ctrIn].isNegative() ^ overlay.isNegative()) continue;
                            min = overlays[ctrIn].getScreenMin();
                            max = overlays[ctrIn].getScreenMax();
                            found = true;
                            break block3;
                        }
                    }
                    if (!found) {
                        overlay.setNegativeState(overlay.getVolume().updateDisplayRangeBasedOnImageRange(overlay.isNegative()));
                        min = overlay.getVolume().getDisplayMin();
                        max = overlay.getVolume().getDisplayMax();
                    }
                } else {
                    int numOverlays = this.overlayManager.getNumInStack();
                    if (numOverlays > 0) {
                        ScreenVolume[] overlays = this.overlayManager.getAllOverlays();
                        for (int ctr = 0; ctr < overlays.length; ++ctr) {
                            if (overlays[ctr] == null || overlays[ctr].isNegative() ^ overlay.isNegative()) continue;
                            min = overlays[ctr].getScreenMin();
                            max = overlays[ctr].getScreenMax();
                            break;
                        }
                    } else {
                        overlay.setNegativeState(overlay.getVolume().updateDisplayRangeBasedOnImageRange(overlay.isNegative()));
                        min = overlay.getVolume().getDisplayMin();
                        max = overlay.getVolume().getDisplayMax();
                    }
                }
            } else if (!explicit) {
                double gMin = overlay.getVolume().getImageMin();
                double gMax = overlay.getVolume().getImageMax();
                double dMin = overlay.getVolume().getDisplayMin();
                double dMax = overlay.getVolume().getDisplayMax();
                if (overlay.isNegative() || dMax <= dMin || dMin == gMin && dMax == gMax || dMin < 0.0 && dMax > 0.0) {
                    overlay.setNegativeState(overlay.getVolume().updateDisplayRangeBasedOnImageRange(overlay.isNegative()));
                }
                min = overlay.getVolume().getDisplayMin();
                max = overlay.getVolume().getDisplayMax();
            }
            overlay.setScreenMin(min);
            overlay.setScreenMax(max);
            if (overlay.isBinary() && (overlay.getLookupTableManager().getName().equals("Red Overlay") || overlay.getLookupTableManager().getName().equals("Green Overlay") || overlay.getLookupTableManager().getName().equals("Blue Overlay"))) {
                overlay.getLookupTableManager().swapForBinaryColorTable();
            }
            this.resetOverlayTimeseries();
            this.overlayManager.addOverlay(overlay);
            this.currentScreenVolume = this.overlayManager.getOverlay(this.overlayManager.getNumInStack() - 1);
            this.updateOverlays();
            overlay.updateScreenRatio();
            this.toolBox.updateCurrentState();
            if (this.isShowingCurrentOverlay()) {
                this.overlayManager.hideAll();
                int currentOverlay = this.getCurrentOverlayIndex();
                if (currentOverlay >= 0) {
                    this.overlayManager.getOverlay(currentOverlay).setHidden(false);
                }
            }
            this.toolBox.updateOverlayPopupMenu();
            this.toolBox.updateOverlayButton();
            this.clearOverlayData();
            this.updateViewer();
            Object obj = overlay.getViewerToClose();
            SliceViewer closingViewer = null;
            if (obj != null) {
                closingViewer = (SliceViewer)obj;
            }
            if (closingViewer != null) {
                closingViewer.close();
                overlay.setViewerToClose(null);
            }
            this.updateSurface();
            if (this.frame != null) {
                this.frame.updateSeriesManager();
            }
            if (this.currentScreenVolume.getVolume().isWorldSpaceOnly()) {
                this.mango.setWorldMode(true);
            }
        }
        finally {
            this.mango.loadNextViewer();
        }
    }

    private void initializePOIManager() {
        this.poiManager = new POIManager(this.volume.getXDim(), this.volume.getYDim(), this.volume.getZDim(), this.volume.getXSize(), this.volume.getYSize(), this.volume.getZSize(), this, this);
        this.poiManagerSpecial = new POISpecialManager(this.volume.getXDim(), this.volume.getYDim(), this.volume.getZDim(), this, this);
        this.axialImage.setPOIManager(this.poiManager, this.poiManagerSpecial);
        this.coronalImage.setPOIManager(this.poiManager, this.poiManagerSpecial);
        this.sagittalImage.setPOIManager(this.poiManager, this.poiManagerSpecial);
    }

    private void initializeROIManager() {
        if (this.startOperation == null || this.startOperation.getType() == 1) {
            this.roiManager = new ROIManager(this, this, this.mango.getEditClipboard(), this.volume.getXDim(), this.volume.getYDim(), this.volume.getZDim());
            this.roiManager.setLabelListener(this);
        }
    }

    private void initializeRuler() {
        Vector<Point> axialPoints = this.rulerShape.getAxialPoints();
        Point point = new Point();
        point.x = (int)((double)this.getXDim(0) * 0.25);
        point.y = (int)((double)this.getYDim(0) * 0.25);
        axialPoints.add(point);
        point = new Point();
        point.x = (int)((double)this.getXDim(0) * 0.75);
        point.y = (int)((double)this.getYDim(0) * 0.75);
        axialPoints.add(point);
        Vector<Point> coronalPoints = this.rulerShape.getCoronalPoints();
        point = new Point();
        point.x = (int)((double)this.getXDim(1) * 0.25);
        point.y = (int)((double)this.getYDim(1) * 0.25);
        coronalPoints.add(point);
        point = new Point();
        point.x = (int)((double)this.getXDim(1) * 0.75);
        point.y = (int)((double)this.getYDim(1) * 0.75);
        coronalPoints.add(point);
        Vector<Point> sagittalPoints = this.rulerShape.getSagittalPoints();
        point = new Point();
        point.x = (int)((double)this.getXDim(2) * 0.25);
        point.y = (int)((double)this.getYDim(2) * 0.25);
        sagittalPoints.add(point);
        point = new Point();
        point.x = (int)((double)this.getXDim(2) * 0.75);
        point.y = (int)((double)this.getYDim(2) * 0.75);
        sagittalPoints.add(point);
    }

    private void initializeViewer() {
        this.initializeViewer(false);
    }

    private void initializeViewer(boolean sameThread) {
        this.volume.updateDisplayRangeToImageRange();
        this.currentScreenVolume = this.baseScreenVolume;
        this.volData = new VolumeData(this, this.volume);
        this.baseScreenVolume.setScreenMin(this.volume.getDisplayMin());
        this.baseScreenVolume.setScreenMax(this.volume.getDisplayMax());
        this.overlayManager = new OverlayManager();
        this.axialImage = new ScreenSlice(this);
        this.coronalImage = new ScreenSlice(this);
        this.sagittalImage = new ScreenSlice(this);
        this.initializeViewOptions();
        if (this.volume.getImageDimensions().getSlices() == 1) {
            this.singleSliceMode = true;
            this.orthoSliceMode = false;
            this.orthoWide = false;
            String orientation = this.volume.getOrientationString();
            if (orientation.charAt(2) == 'X') {
                this.mainImage = this.sagittalImage;
                this.lowerImageLeft = this.axialImage;
                this.lowerImageRight = this.coronalImage;
            } else if (orientation.charAt(2) == 'Y') {
                this.mainImage = this.coronalImage;
                this.lowerImageLeft = this.sagittalImage;
                this.lowerImageRight = this.axialImage;
            } else if (orientation.charAt(2) == 'Z') {
                this.mainImage = this.axialImage;
                this.lowerImageLeft = this.coronalImage;
                this.lowerImageRight = this.sagittalImage;
            }
        }
        this.mainImage.setMainImageState(true, false, false);
        this.lowerImageLeft.setMainImageState(false, true, false);
        this.lowerImageRight.setMainImageState(false, false, true);
        this.axialImage.setInitData(this.volume, this.overlayManager.getAllOverlays(), this.volume.getXDim(), this.volume.getYDim(), this.getLongestDim(), this.volume.getZDim(), this.volume.getXSize(), this.volume.getYSize(), this.volume.getZSize(), this.getLongestDimSize(), 0);
        this.coronalImage.setInitData(this.volume, this.overlayManager.getAllOverlays(), this.volume.getXDim(), this.volume.getZDim(), this.getLongestDim(), this.volume.getYDim(), this.volume.getXSize(), this.volume.getZSize(), this.volume.getYSize(), this.getLongestDimSize(), 1);
        this.sagittalImage.setInitData(this.volume, this.overlayManager.getAllOverlays(), this.volume.getYDim(), this.volume.getZDim(), this.getLongestDim(), this.volume.getXDim(), this.volume.getYSize(), this.volume.getZSize(), this.volume.getXSize(), this.getLongestDimSize(), 2);
        this.axialImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.coronalImage.getCurrentSlice());
        this.coronalImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
        this.sagittalImage.setCrosshairPosition(this.coronalImage.getCurrentSlice(), this.axialImage.getCurrentSlice());
        this.mainImage.setShowCrosshairs(this.isShowingMainCrosshairs());
        this.lowerImageLeft.setShowCrosshairs(this.isShowingLowerCrosshairs());
        this.lowerImageRight.setShowCrosshairs(this.isShowingLowerCrosshairs());
        this.axialImage.setShowLineLength(this.isShowingRuler());
        this.coronalImage.setShowLineLength(this.isShowingRuler());
        this.sagittalImage.setShowLineLength(this.isShowingRuler());
        this.axialImage.setShowLineAngle(this.isShowingAngle());
        this.coronalImage.setShowLineAngle(this.isShowingAngle());
        this.sagittalImage.setShowLineAngle(this.isShowingAngle());
        this.axialImage.setShowOrientation(this.isShowingOrientation());
        this.coronalImage.setShowOrientation(this.isShowingOrientation());
        this.sagittalImage.setShowOrientation(this.isShowingOrientation());
        this.updateShowOverlay();
        this.initializeROIManager();
        this.initializeLOIManagers();
        this.initializePOIManager();
        this.histogram = new HistogramPanel(this);
        this.crosssection = new Crosssection(this);
        this.timeseries = new Timeseries(this);
        this.setVisible(true);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.setBackground(MangoStyle.COLOR_BACKGROUND);
        this.setLayout(new OverlayLayout(this));
        this.add(this.lowerImageLeft);
        this.add(this.lowerImageRight);
        this.add(this.mainImage);
        this.validate();
        this.calculateScreenSliceTransforms();
        this.viewerInitialized = true;
        this.updateTransformMode();
        this.updatelutManager();
        this.windowManager = new ViewerWindowManager(this);
        this.volumeLoaded(true, sameThread);
        if (this.startOperation == null) {
            this.endIndeterminateProgressBar();
        }
        if ((this.volume.isWorldSpaceOnly() || this.getBaseVolume().needsWorldMode()) && !this.mango.isWorldMode()) {
            this.mango.setWorldMode(true);
        }
    }

    private void initializeViewOptions() {
        if (this.mango.getMainSliceDirection() == 0) {
            this.mainImage = this.axialImage;
            this.lowerImageLeft = this.coronalImage;
            this.lowerImageRight = this.sagittalImage;
        } else if (this.mango.getMainSliceDirection() == 1) {
            this.mainImage = this.coronalImage;
            this.lowerImageLeft = this.sagittalImage;
            this.lowerImageRight = this.axialImage;
        } else {
            this.mainImage = this.sagittalImage;
            this.lowerImageLeft = this.axialImage;
            this.lowerImageRight = this.coronalImage;
        }
        this.setViewOptionROIMask(this.mango.isViewROIMask());
        this.setViewOptionROIEdge(this.mango.isViewROIEdge());
        this.setViewOptionROIStats(this.mango.isViewROIStats());
        this.setShowLabels(this.mango.isViewLabels());
        this.setScrollwheelslices(this.mango.isScrollwheelSlices());
        this.setScrollwheelDirectionFlip(this.mango.isScrollwheelDirectionFlip());
        this.singleSliceMode = this.mango.getViewMode() == 2;
        this.orthoSliceMode = this.mango.getViewMode() == 0;
        this.orthoWide = this.mango.getViewMode() == 1;
        this.setShowMainCrosshairs(this.mango.isViewMainCrosshairs());
        this.setShowLowerCrosshairs(this.mango.isViewLowerCrosshairs());
        this.setViewOptionOrientation(this.mango.isViewOrientation());
        this.setShowCurrentOverlay(this.mango.isViewOverlayCurrent());
        this.setShowAllOverlay(!this.mango.isViewOverlayCurrent());
    }

    private void loadMangoROI(final URI externalROIFile, final boolean sameThread) {
        if (sameThread) {
            this.doLoadMangoROI(externalROIFile, sameThread);
        } else {
            Thread workThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    SliceViewer.this.doLoadMangoROI(externalROIFile, sameThread);
                }
            });
            workThread.start();
        }
    }

    protected boolean isImageParametric(String name) {
        return false;
    }

    private void loadOverlayLoadItem(OverlayLoadItem loadItem) {
        Volume overlayVolume = loadItem.getVolume();
        URI overlayURI = loadItem.getUri();
        String lutName = loadItem.getLutName();
        boolean isParametric = loadItem.isParametric();
        this.loadOverlayScreenVolume(overlayVolume, overlayURI, lutName, null, isParametric |= this.isImageParametric(FileUtilities.getName((URI)overlayURI)), false);
        if (isParametric) {
            this.loadOverlayScreenVolume(overlayVolume, overlayURI, lutName, null, isParametric, true);
        }
    }

    private boolean loiManagersHaveBeenUsed() {
        return this.loiManagerAxial.isUsed() || this.loiManagerCoronal.isUsed() || this.loiManagerSagittal.isUsed();
    }

    private boolean loiManagersHaveShapes() {
        return this.loiManagerAxial.hasShapes() || this.loiManagerCoronal.hasShapes() || this.loiManagerSagittal.hasShapes();
    }

    private ClusterAnalysisTool makeClusterAnalysis() {
        this.clusterAnalysis = new ClusterAnalysisTool(this.mango, this);
        this.associateWindow(this.clusterAnalysis);
        return this.clusterAnalysis;
    }

    private ClusterROIAnalysisTool makeClusterROIAnalysis() {
        this.clusterROIAnalysis = new ClusterROIAnalysisTool(this);
        this.associateWindow(this.clusterROIAnalysis);
        return this.clusterROIAnalysis;
    }

    private File makeFile(String suffix, String ext) {
        File returnFile = null;
        if (this.getLoadedFile() != null) {
            returnFile = this.makeFile(this.getLoadedFile().getName(), suffix, ext);
        }
        return returnFile;
    }

    private File makeFile(String fileName, String suffix, String ext) {
        File returnFile = null;
        if (this.getLoadedFile() != null) {
            String fileDir = this.getLoadedFile().getParent();
            File directory = this.getLoadedFile().getParentFile();
            boolean canCreate = FileUtilities.writeTest((File)directory);
            if (!canCreate) {
                fileDir = Platform.getDesktopDir().toString();
            }
            returnFile = fileName.indexOf(46) != -1 ? new File(fileDir, fileName.substring(0, fileName.indexOf(46)) + suffix + ext) : new File(fileDir, fileName + suffix + ext);
            int ctr = 2;
            while (returnFile.exists()) {
                returnFile = fileName.indexOf(46) != -1 ? new File(fileDir, fileName.substring(0, fileName.indexOf(46)) + suffix + ctr + ext) : new File(fileDir, fileName + suffix + ctr + ext);
                ++ctr;
            }
        }
        return returnFile;
    }

    private void makeFilterBuffers() {
        ImageDimensions id = this.volume.getImageDimensions();
        int sliceSize = id.getNumVoxelsSlice();
        this.filterBuffer = new FilterBuffer(this.volume, sliceSize, this.volume.getWorkBuffers(), this.volume.getVolumeIntercept());
    }

    private LogicalAnalysisTool makeLogicalManager() {
        this.logicalManager = new LogicalAnalysisTool(this.mango, this);
        this.associateWindow(this.logicalManager);
        return this.logicalManager;
    }

    private ROIInspectorTool makeROICounts() {
        this.roiInspector = new ROIInspectorTool(this.mango, this);
        this.associateWindow(this.roiInspector);
        return this.roiInspector;
    }

    private void makeROIGZIPFile() {
        if (!this.isTempImage && !this.mango.isApplet()) {
            this.roiFileGZIP = this.makeFile("_roi", ".nii.gz");
        }
    }

    private void notifyAllListenersOfClosing() {
        Enumeration<ViewerListener> en = this.listeners.elements();
        while (en.hasMoreElements()) {
            ViewerListener vl = en.nextElement();
            vl.viewerClosing(this);
        }
    }

    private void notifySliceDirectionListeners() {
        for (WeakReference<SliceDirectionListener> wf : this.sliceDirectionListeners) {
            SliceDirectionListener sdl = (SliceDirectionListener)wf.get();
            if (sdl == null) continue;
            sdl.sliceDirectionChanged(this.mainImage.getSliceDirection());
        }
    }

    private void pasteLOI() {
        Mango.getClipboardLoi().paste(this.loiManagerAxial, this.loiManagerCoronal, this.loiManagerSagittal);
        this.deselectAllLOIs();
        this.repaint();
    }

    private void pastePOI() {
        this.poiManager.deselectAll();
        Mango.getClipboardPoi().paste(this.poiManager);
        this.repaint();
    }

    private void pasteROI(boolean sameThread) {
        Mango.getClipboardRoi().setCurrentUser(this);
        this.roiManager.deselectAll();
        this.roiManager.paste(sameThread);
    }

    private void pointAdded(POI point, boolean updateSurface) {
        if (this.roiInspector != null && this.roiInspector.isVisible()) {
            this.roiInspector.updateCounts();
        }
        if (updateSurface && this.surfaceRender != null && this.surfaceRender.isSyncingShapes()) {
            this.surfaceRender.addMarker(point);
            this.updateSurface();
        }
    }

    private void pointDeleted(POI point, boolean updateSurface) {
        if (this.roiInspector != null && this.roiInspector.isVisible()) {
            this.roiInspector.updateCounts();
        }
        if (updateSurface && this.surfaceRender != null && this.surfaceRender.isSyncingShapes()) {
            this.surfaceRender.deleteROIPoint(point);
        }
    }

    private void prepareFilter() {
        if (this.filterBuffer == null) {
            this.makeFilterBuffers();
        }
        if (!this.filterBuffer.isInitialized()) {
            this.filterBuffer.initialize();
        }
    }

    private void readOldROIFormat(final URI externalROIFile, boolean sameThread) {
        if (sameThread) {
            this.doReadOldROIFormat(externalROIFile);
        } else {
            Thread workThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    SliceViewer.this.doReadOldROIFormat(externalROIFile);
                }
            });
            workThread.start();
        }
    }

    private void reconcileOverlayTimeseries() {
        this.reconcileOverlayTimeseries(this.findTopOverlayTimeseries());
    }

    private void reconcileOverlayTimeseries(ScreenVolume refTimeseries) {
        if (this.hasOverlayTimeseries()) {
            if (this.isWorldMode() && this.allForcedWorldTimeMode()) {
                this.setOverlaysTimepoint(refTimeseries.getVolume().getTimeframe() * (double)refTimeseries.getVolume().getCurrentTimepoint());
            } else {
                this.setOverlaysTimepoint(refTimeseries.getVolume().getCurrentTimepoint());
            }
        }
    }

    private void reinitializeOverlay(ScreenVolume overlay) {
        overlay.setScreenMin(overlay.getVolume().getImageMin());
        overlay.setScreenMax(overlay.getVolume().getImageMax());
        if (this.toolBox.isOverlayGroup()) {
            this.setOverlayGroupScreenMin(overlay.getVolume().getImageMin());
            this.setOverlayGroupScreenMax(overlay.getVolume().getImageMax());
            if (this.toolBox.isGlobal()) {
                Mango.initializeGroupOverlay(this);
            }
        }
        overlay.updateScreenRatio();
        this.toolBox.updateCurrentState();
        this.clearOverlayData();
        this.updateScreenSlices();
    }

    private void reinitializeScreenValues() {
        this.baseScreenVolume.getLookupTableManager().initLUT();
        this.baseScreenVolume.setScreenMin(this.volume.getImageMin());
        this.baseScreenVolume.setScreenMax(this.volume.getImageMax());
        this.baseScreenVolume.updateScreenRatio();
        this.toolBox.updateCurrentState();
        if (this.isViewerInitialized()) {
            this.volume.setDisplayValues(this.baseScreenVolume.getScreenMax(), this.baseScreenVolume.getScreenMin());
            if (!this.revertingToSaved && !this.volumeWillBeReloaded) {
                this.volume.setHeaderAsDirty();
            }
        }
        this.revertingToSaved = false;
        this.updateScreenSlices();
        this.repaint();
    }

    private void reinitializeViewer() {
        boolean dimensionsChanged;
        this.setOrientationCertainty(this.volume.getOrientationCertainty());
        this.setLongestDim();
        boolean mainCrosshairsShow = this.mainImage.isShowCrosshairs();
        boolean lowerCrosshairsShow = this.lowerImageRight.isShowCrosshairs();
        this.axialImage.setInitData(this.volume, this.overlayManager.getAllOverlays(), this.volume.getXDim(), this.volume.getYDim(), this.getLongestDim(), this.volume.getZDim(), this.volume.getXSize(), this.volume.getYSize(), this.volume.getZSize(), this.getLongestDimSize(), 0);
        this.coronalImage.setInitData(this.volume, this.overlayManager.getAllOverlays(), this.volume.getXDim(), this.volume.getZDim(), this.getLongestDim(), this.volume.getYDim(), this.volume.getXSize(), this.volume.getZSize(), this.volume.getYSize(), this.getLongestDimSize(), 1);
        this.sagittalImage.setInitData(this.volume, this.overlayManager.getAllOverlays(), this.volume.getYDim(), this.volume.getZDim(), this.getLongestDim(), this.volume.getXDim(), this.volume.getYSize(), this.volume.getZSize(), this.volume.getXSize(), this.getLongestDimSize(), 2);
        this.setShowMainCrosshairs(mainCrosshairsShow);
        this.setShowLowerCrosshairs(lowerCrosshairsShow);
        this.mainImage.setShowCrosshairs(mainCrosshairsShow);
        this.lowerImageRight.setShowCrosshairs(lowerCrosshairsShow);
        this.lowerImageLeft.setShowCrosshairs(lowerCrosshairsShow);
        this.calculateScreenSliceTransforms();
        this.axialImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.coronalImage.getCurrentSlice(), true, true, true);
        this.coronalImage.setCrosshairPosition(this.sagittalImage.getCurrentSlice(), this.axialImage.getCurrentSlice(), true, true, true);
        this.sagittalImage.setCrosshairPosition(this.coronalImage.getCurrentSlice(), this.axialImage.getCurrentSlice(), true, true, true);
        boolean bl = dimensionsChanged = this.roiManager.getXDim() != this.volume.getXDim() + 1 || this.roiManager.getYDim() != this.volume.getYDim() + 1 || this.roiManager.getZDim() != this.volume.getZDim() + 1;
        if (dimensionsChanged) {
            this.initializeROIManager();
            this.initializeLOIManagers();
            this.initializePOIManager();
        }
        this.axialImage.updateOverlays();
        this.coronalImage.updateOverlays();
        this.sagittalImage.updateOverlays();
        this.updateHistogram();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadImage(URI file, edu.uthscsa.ric.mango.components.progressbar.ProgressBar pb) {
        try {
            if (pb != null) {
                pb.setIndeterminateMode(true);
            }
            this.volumeWillBeReloaded = true;
            this.filterBuffer = null;
            this.volume.clear(true);
            this.volume.preload();
            this.volume.setUser(this);
            this.volume.addListener(this);
            this.volume.setLabelListener(this);
            URI loadingURI = this.volume.readHeader(file);
            this.setLoadedURI(loadingURI);
            this.volume.doReadFiles();
            this.volume.readLabelData();
            this.volume.setProgressBarListener(this.toolBox);
            if (this.volume.getImageMax() <= this.volume.getImageMin()) {
                this.volume.updateMaxMin(this.volume.findRangeSeries());
            }
            this.volume.updateDisplayRangeToImageRange();
            this.volumeReloaded(true);
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
            this.showErrorDialog("Problem loading image file!", TEXT_IMAGE_LOAD_FAILED);
            this.volumeReloaded(false);
        }
        catch (VolumeIOException ex) {
            AppLogger.error((Throwable)ex);
            this.showErrorDialog("Problem loading image file!", TEXT_IMAGE_LOAD_FAILED);
            this.volumeReloaded(false);
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
            this.showErrorDialog("Problem loading image file!", TEXT_IMAGE_LOAD_FAILED);
            this.volumeReloaded(false);
        }
        finally {
            if (pb != null) {
                pb.setIndeterminateMode(false);
                pb.setValue(pb.getMax());
            }
        }
    }

    private void removeOverlay(ScreenVolume overlay) {
        if (overlay != null) {
            overlay.getVolume().removeListener(this);
            int overlayIndex = this.overlayManager.getIndex(overlay);
            if (overlayIndex != -1) {
                this.overlayManager.removeOverlay(overlay);
                this.updateOverlays();
                this.setCurrentOverlay(overlayIndex);
                this.updateShowOverlay();
                this.toolBox.updateOverlayButton();
                this.toolBox.updateOverlayPopupMenu();
                this.toolBox.updateSlider();
                this.clearOverlayData();
                this.updateScreenSlices();
                this.updateSurface();
            }
        }
    }

    private void removeSeriesLabelEditor() {
        this.frame.removeSeriesLabelEditor();
    }

    private void resetAllClipboardsContents() {
        Mango.getClipboardRoi().reset();
        Mango.getClipboardLoi().reset();
        Mango.getClipboardPoi().reset();
    }

    private void resetOverlayTimeseries() {
        this.setOverlaysTimepoint(0);
    }

    private List<Analysis> runAllSliceStatsROILines(int sliceDirection, boolean onlySelected) {
        ArrayList<Analysis> stats;
        block7: {
            block8: {
                block6: {
                    stats = new ArrayList<Analysis>();
                    if (sliceDirection != 0) break block6;
                    for (int ctr = 0; ctr < this.volume.getZDim(); ++ctr) {
                        if (!this.loiManagerAxial.hasShapes(ctr)) continue;
                        for (LOIShape shape = this.loiManagerAxial.getShape(ctr); shape != null; shape = shape.getNext()) {
                            if (onlySelected && !shape.isSelected()) continue;
                            Volume vol = this.getCurrentVolume();
                            LineStatROIOp op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                            Analysis result = op.process(shape, 0, this.volume.getCurrentTimepoint());
                            this.operationFinished(result, vol);
                            stats.add(result);
                        }
                    }
                    break block7;
                }
                if (sliceDirection != 1) break block8;
                for (int ctr = 0; ctr < this.volume.getYDim(); ++ctr) {
                    if (!this.loiManagerCoronal.hasShapes(ctr)) continue;
                    for (LOIShape shape = this.loiManagerCoronal.getShape(ctr); shape != null; shape = shape.getNext()) {
                        if (onlySelected && !shape.isSelected()) continue;
                        Volume vol = this.getCurrentVolume();
                        LineStatROIOp op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                        Analysis result = op.process(shape, 0, this.volume.getCurrentTimepoint());
                        this.operationFinished(result, vol);
                        stats.add(result);
                    }
                }
                break block7;
            }
            if (sliceDirection != 2) break block7;
            for (int ctr = 0; ctr < this.volume.getXDim(); ++ctr) {
                if (!this.loiManagerSagittal.hasShapes(ctr)) continue;
                for (LOIShape shape = this.loiManagerSagittal.getShape(ctr); shape != null; shape = shape.getNext()) {
                    if (onlySelected && !shape.isSelected()) continue;
                    Volume vol = this.getCurrentVolume();
                    LineStatROIOp op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                    Analysis result = op.process(shape, 0, this.volume.getCurrentTimepoint());
                    this.operationFinished(result, vol);
                    stats.add(result);
                }
            }
        }
        return stats;
    }

    private List<Analysis> runAllSliceStatsROIPoints(int sliceDirection, boolean onlySelected) {
        ArrayList<Analysis> stats;
        block7: {
            block8: {
                block6: {
                    stats = new ArrayList<Analysis>();
                    if (sliceDirection != 0) break block6;
                    for (int ctr = 0; ctr < this.volume.getZDim(); ++ctr) {
                        for (POI poi = this.poiManager.getPOIs(ctr, 0); poi != null; poi = poi.getNextAxial()) {
                            if (onlySelected && !poi.isSelected()) continue;
                            Volume vol = this.getCurrentVolume();
                            PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                            Analysis result = op.process(poi, this.getCurrentVolume().getCurrentTimepoint());
                            this.operationFinished(result, vol);
                        }
                    }
                    break block7;
                }
                if (sliceDirection != 1) break block8;
                for (int ctr = 0; ctr < this.volume.getYDim(); ++ctr) {
                    for (POI poi = this.poiManager.getPOIs(ctr, 1); poi != null; poi = poi.getNextCoronal()) {
                        if (onlySelected && !poi.isSelected()) continue;
                        Volume vol = this.getCurrentVolume();
                        PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                        Analysis result = op.process(poi, this.getCurrentVolume().getCurrentTimepoint());
                        this.operationFinished(result, vol);
                    }
                }
                break block7;
            }
            if (sliceDirection != 2) break block7;
            for (int ctr = 0; ctr < this.volume.getXDim(); ++ctr) {
                for (POI poi = this.poiManager.getPOIs(ctr, 2); poi != null; poi = poi.getNextSagittal()) {
                    if (onlySelected && !poi.isSelected()) continue;
                    Volume vol = this.getCurrentVolume();
                    PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                    Analysis result = op.process(poi, this.getCurrentVolume().getCurrentTimepoint());
                    this.operationFinished(result, vol);
                }
            }
        }
        return stats;
    }

    private List<Analysis> runAllVolumeStatsROILines(boolean onlySelected) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        int numTimepoints = this.volume.getNumTimepoints();
        for (int ctrT = 0; ctrT < numTimepoints; ++ctrT) {
            Analysis result;
            LineStatROIOp op;
            Volume vol;
            LOIShape shape;
            int ctr;
            for (ctr = 0; ctr < this.volume.getZDim(); ++ctr) {
                if (!this.loiManagerAxial.hasShapes(ctr)) continue;
                for (shape = this.loiManagerAxial.getShape(ctr); shape != null; shape = shape.getNext()) {
                    if (onlySelected && !shape.isSelected()) continue;
                    vol = this.getCurrentVolume();
                    op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                    result = op.process(shape, 0, ctrT);
                    this.operationFinished(result, vol);
                    stats.add(result);
                }
            }
            for (ctr = 0; ctr < this.volume.getYDim(); ++ctr) {
                if (!this.loiManagerCoronal.hasShapes(ctr)) continue;
                for (shape = this.loiManagerCoronal.getShape(ctr); shape != null; shape = shape.getNext()) {
                    if (onlySelected && !shape.isSelected()) continue;
                    vol = this.getCurrentVolume();
                    op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                    result = op.process(shape, 1, ctrT);
                    this.operationFinished(result, vol);
                    stats.add(result);
                }
            }
            for (ctr = 0; ctr < this.volume.getXDim(); ++ctr) {
                if (!this.loiManagerSagittal.hasShapes(ctr)) continue;
                for (shape = this.loiManagerSagittal.getShape(ctr); shape != null; shape = shape.getNext()) {
                    if (onlySelected && !shape.isSelected()) continue;
                    vol = this.getCurrentVolume();
                    op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                    result = op.process(shape, 2, ctrT);
                    this.operationFinished(result, vol);
                    stats.add(result);
                }
            }
        }
        return stats;
    }

    private List<Analysis> runAllVolumeStatsROIPoints(boolean onlySelected) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        int numTimepoints = this.volume.getNumTimepoints();
        int sliceStatsDirection = this.mainImage.getSliceDirection();
        for (int ctrT = 0; ctrT < numTimepoints; ++ctrT) {
            Analysis result;
            PointStatROIOp op;
            Volume vol;
            POI poi;
            int ctr;
            if (sliceStatsDirection == 0) {
                for (ctr = 0; ctr < this.volume.getZDim(); ++ctr) {
                    for (poi = this.poiManager.getPOIs(ctr, 0); poi != null; poi = poi.getNextAxial()) {
                        if (onlySelected && !poi.isSelected()) continue;
                        vol = this.getCurrentVolume();
                        op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                        result = op.process(poi, ctrT);
                        this.operationFinished(result, vol);
                    }
                }
                continue;
            }
            if (sliceStatsDirection == 1) {
                for (ctr = 0; ctr < this.volume.getYDim(); ++ctr) {
                    for (poi = this.poiManager.getPOIs(ctr, 1); poi != null; poi = poi.getNextCoronal()) {
                        if (onlySelected && !poi.isSelected()) continue;
                        vol = this.getCurrentVolume();
                        op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                        result = op.process(poi, ctrT);
                        this.operationFinished(result, vol);
                    }
                }
                continue;
            }
            if (sliceStatsDirection != 2) continue;
            for (ctr = 0; ctr < this.volume.getXDim(); ++ctr) {
                for (poi = this.poiManager.getPOIs(ctr, 2); poi != null; poi = poi.getNextSagittal()) {
                    if (onlySelected && !poi.isSelected()) continue;
                    vol = this.getCurrentVolume();
                    op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                    result = op.process(poi, ctrT);
                    this.operationFinished(result, vol);
                }
            }
        }
        return stats;
    }

    private List<Analysis> runSeriesStatsROILines(boolean onlySelected) {
        AnalysisImpl result;
        LineStatROIOp op;
        Volume vol;
        LOIShape shape;
        int ctr;
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        for (ctr = 0; ctr < this.volume.getZDim(); ++ctr) {
            if (!this.loiManagerAxial.hasShapes(ctr)) continue;
            for (shape = this.loiManagerAxial.getShape(ctr); shape != null; shape = shape.getNext()) {
                if (onlySelected && !shape.isSelected()) continue;
                vol = this.getCurrentVolume();
                op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                result = op.calculateSeriesLineROI(shape, 0);
                this.operationFinished(result, vol);
                stats.add(result);
            }
        }
        for (ctr = 0; ctr < this.volume.getYDim(); ++ctr) {
            if (!this.loiManagerCoronal.hasShapes(ctr)) continue;
            for (shape = this.loiManagerCoronal.getShape(ctr); shape != null; shape = shape.getNext()) {
                if (onlySelected && !shape.isSelected()) continue;
                vol = this.getCurrentVolume();
                op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                result = op.calculateSeriesLineROI(shape, 1);
                this.operationFinished(result, vol);
                stats.add(result);
            }
        }
        for (ctr = 0; ctr < this.volume.getXDim(); ++ctr) {
            if (!this.loiManagerSagittal.hasShapes(ctr)) continue;
            for (shape = this.loiManagerSagittal.getShape(ctr); shape != null; shape = shape.getNext()) {
                if (onlySelected && !shape.isSelected()) continue;
                vol = this.getCurrentVolume();
                op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                result = op.calculateSeriesLineROI(shape, 2);
                this.operationFinished(result, vol);
                stats.add(result);
            }
        }
        return stats;
    }

    private List<Analysis> runSeriesStatsROIPoints(boolean onlySelected) {
        ArrayList<Analysis> stats;
        block7: {
            int sliceStatsDirection;
            block8: {
                block6: {
                    stats = new ArrayList<Analysis>();
                    sliceStatsDirection = this.mainImage.getSliceDirection();
                    if (sliceStatsDirection != 0) break block6;
                    for (int ctr = 0; ctr < this.volume.getZDim(); ++ctr) {
                        for (POI poi = this.poiManager.getPOIs(ctr, 0); poi != null; poi = poi.getNextAxial()) {
                            if (onlySelected && !poi.isSelected()) continue;
                            Volume vol = this.getCurrentVolume();
                            PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                            Analysis result = op.calculateSeriesPointROI(poi);
                            this.operationFinished(result, vol);
                            stats.add(result);
                        }
                    }
                    break block7;
                }
                if (sliceStatsDirection != 1) break block8;
                for (int ctr = 0; ctr < this.volume.getYDim(); ++ctr) {
                    for (POI poi = this.poiManager.getPOIs(ctr, 1); poi != null; poi = poi.getNextCoronal()) {
                        if (onlySelected && !poi.isSelected()) continue;
                        Volume vol = this.getCurrentVolume();
                        PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                        Analysis result = op.calculateSeriesPointROI(poi);
                        this.operationFinished(result, vol);
                        stats.add(result);
                    }
                }
                break block7;
            }
            if (sliceStatsDirection != 2) break block7;
            for (int ctr = 0; ctr < this.volume.getXDim(); ++ctr) {
                for (POI poi = this.poiManager.getPOIs(ctr, 2); poi != null; poi = poi.getNextSagittal()) {
                    if (onlySelected && !poi.isSelected()) continue;
                    Volume vol = this.getCurrentVolume();
                    PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                    Analysis result = op.calculateSeriesPointROI(poi);
                    this.operationFinished(result, vol);
                    stats.add(result);
                }
            }
        }
        return stats;
    }

    private List<Analysis> runSliceStatsROILines(int sliceStatsDirection, int sliceStatsCurrentSlice, boolean onlySelected) {
        ArrayList<Analysis> stats;
        block5: {
            block6: {
                block4: {
                    stats = new ArrayList<Analysis>();
                    if (sliceStatsDirection != 0) break block4;
                    if (!this.loiManagerAxial.hasShapes(sliceStatsCurrentSlice)) break block5;
                    for (LOIShape shape = this.loiManagerAxial.getShape(sliceStatsCurrentSlice); shape != null; shape = shape.getNext()) {
                        if (onlySelected && !shape.isSelected()) continue;
                        Volume vol = this.getCurrentVolume();
                        LineStatROIOp op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                        Analysis result = op.process(shape, 0, this.volume.getCurrentTimepoint());
                        this.operationFinished(result, vol);
                        stats.add(result);
                    }
                    break block5;
                }
                if (sliceStatsDirection != 1) break block6;
                if (!this.loiManagerCoronal.hasShapes(sliceStatsCurrentSlice)) break block5;
                for (LOIShape shape = this.loiManagerCoronal.getShape(sliceStatsCurrentSlice); shape != null; shape = shape.getNext()) {
                    if (onlySelected && !shape.isSelected()) continue;
                    Volume vol = this.getCurrentVolume();
                    LineStatROIOp op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                    Analysis result = op.process(shape, 1, this.volume.getCurrentTimepoint());
                    this.operationFinished(result, vol);
                    stats.add(result);
                }
                break block5;
            }
            if (sliceStatsDirection == 2 && this.loiManagerSagittal.hasShapes(sliceStatsCurrentSlice)) {
                for (LOIShape shape = this.loiManagerSagittal.getShape(sliceStatsCurrentSlice); shape != null; shape = shape.getNext()) {
                    if (onlySelected && !shape.isSelected()) continue;
                    Volume vol = this.getCurrentVolume();
                    LineStatROIOp op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                    Analysis result = op.process(shape, 2, this.volume.getCurrentTimepoint());
                    this.operationFinished(result, vol);
                    stats.add(result);
                }
            }
        }
        return stats;
    }

    private List<Analysis> runSliceStatsROIPoints(int sliceStatsDirection, int sliceStatsCurrentSlice, boolean onlySelected) {
        ArrayList<Analysis> stats;
        block4: {
            block5: {
                block3: {
                    stats = new ArrayList<Analysis>();
                    if (sliceStatsDirection != 0) break block3;
                    for (POI poi = this.poiManager.getPOIs(sliceStatsCurrentSlice, 0); poi != null; poi = poi.getNextAxial()) {
                        if (onlySelected && !poi.isSelected()) continue;
                        Volume vol = this.getCurrentVolume();
                        PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                        Analysis result = op.process(poi, this.getCurrentVolume().getCurrentTimepoint());
                        this.operationFinished(result, vol);
                    }
                    break block4;
                }
                if (sliceStatsDirection != 1) break block5;
                for (POI poi = this.poiManager.getPOIs(sliceStatsCurrentSlice, 1); poi != null; poi = poi.getNextCoronal()) {
                    if (onlySelected && !poi.isSelected()) continue;
                    Volume vol = this.getCurrentVolume();
                    PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                    Analysis result = op.process(poi, this.getCurrentVolume().getCurrentTimepoint());
                    this.operationFinished(result, vol);
                }
                break block4;
            }
            if (sliceStatsDirection != 2) break block4;
            for (POI poi = this.poiManager.getPOIs(sliceStatsCurrentSlice, 2); poi != null; poi = poi.getNextSagittal()) {
                if (onlySelected && !poi.isSelected()) continue;
                Volume vol = this.getCurrentVolume();
                PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                Analysis result = op.process(poi, this.getCurrentVolume().getCurrentTimepoint());
                this.operationFinished(result, vol);
            }
        }
        return stats;
    }

    private List<Analysis> runVolumeStatsROILines(boolean onlySelected) {
        Analysis result;
        LineStatROIOp op;
        Volume vol;
        LOIShape shape;
        int ctr;
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        for (ctr = 0; ctr < this.volume.getZDim(); ++ctr) {
            if (!this.loiManagerAxial.hasShapes(ctr)) continue;
            for (shape = this.loiManagerAxial.getShape(ctr); shape != null; shape = shape.getNext()) {
                if (onlySelected && !shape.isSelected()) continue;
                vol = this.getCurrentVolume();
                op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                result = op.process(shape, 0, this.volume.getCurrentTimepoint());
                this.operationFinished(result, vol);
                stats.add(result);
            }
        }
        for (ctr = 0; ctr < this.volume.getYDim(); ++ctr) {
            if (!this.loiManagerCoronal.hasShapes(ctr)) continue;
            for (shape = this.loiManagerCoronal.getShape(ctr); shape != null; shape = shape.getNext()) {
                if (onlySelected && !shape.isSelected()) continue;
                vol = this.getCurrentVolume();
                op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                result = op.process(shape, 1, this.volume.getCurrentTimepoint());
                this.operationFinished(result, vol);
                stats.add(result);
            }
        }
        for (ctr = 0; ctr < this.volume.getXDim(); ++ctr) {
            if (!this.loiManagerSagittal.hasShapes(ctr)) continue;
            for (shape = this.loiManagerSagittal.getShape(ctr); shape != null; shape = shape.getNext()) {
                if (onlySelected && !shape.isSelected()) continue;
                vol = this.getCurrentVolume();
                op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                result = op.process(shape, 2, this.volume.getCurrentTimepoint());
                this.operationFinished(result, vol);
                stats.add(result);
            }
        }
        return stats;
    }

    private List<Analysis> runVolumeStatsROIPoints(boolean onlySelected) {
        ArrayList<Analysis> stats;
        block7: {
            int sliceStatsDirection;
            block8: {
                block6: {
                    stats = new ArrayList<Analysis>();
                    sliceStatsDirection = this.mainImage.getSliceDirection();
                    if (sliceStatsDirection != 0) break block6;
                    for (int ctr = 0; ctr < this.volume.getZDim(); ++ctr) {
                        for (POI poi = this.poiManager.getPOIs(ctr, 0); poi != null; poi = poi.getNextAxial()) {
                            if (onlySelected && !poi.isSelected()) continue;
                            Volume vol = this.getCurrentVolume();
                            PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                            Analysis result = op.process(poi, this.getCurrentVolume().getCurrentTimepoint());
                            this.operationFinished(result, vol);
                        }
                    }
                    break block7;
                }
                if (sliceStatsDirection != 1) break block8;
                for (int ctr = 0; ctr < this.volume.getYDim(); ++ctr) {
                    for (POI poi = this.poiManager.getPOIs(ctr, 1); poi != null; poi = poi.getNextCoronal()) {
                        if (onlySelected && !poi.isSelected()) continue;
                        Volume vol = this.getCurrentVolume();
                        PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                        Analysis result = op.process(poi, this.getCurrentVolume().getCurrentTimepoint());
                        this.operationFinished(result, vol);
                    }
                }
                break block7;
            }
            if (sliceStatsDirection != 2) break block7;
            for (int ctr = 0; ctr < this.volume.getXDim(); ++ctr) {
                for (POI poi = this.poiManager.getPOIs(ctr, 2); poi != null; poi = poi.getNextSagittal()) {
                    if (onlySelected && !poi.isSelected()) continue;
                    Volume vol = this.getCurrentVolume();
                    PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                    Analysis result = op.process(poi, this.getCurrentVolume().getCurrentTimepoint());
                    this.operationFinished(result, vol);
                }
            }
        }
        return stats;
    }

    private void saveNextOverlay(Volume overlayVol, boolean sameThread) {
        ScreenVolume overlayScreenVol = this.overlayManager.getOverlay(overlayVol);
        File overlayFile = new File(overlayScreenVol.getURI());
        try {
            this.startIndeterminateProgressBar();
            overlayVol.setDisplayValues(overlayScreenVol.getScreenMax(), overlayScreenVol.getScreenMin());
            overlayVol.saveLabelData(this.getMangoVersion());
            overlayVol.writeFiles(overlayFile, sameThread);
        }
        catch (VolumeIOException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog("Problem saving image file!\nCheck write permissions!", ERROR_TITLE_SAVE);
            this.volumeSaved(overlayVol, false, false, null, null, false, sameThread);
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog(PROBLEM_SAVING_IMAGE_FILE + ex.getMessage(), ERROR_TITLE_SAVE);
            this.volumeSaved(overlayVol, false, false, null, null, false, sameThread);
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog(PROBLEM_SAVING_IMAGE_FILE + ex.getMessage(), ERROR_TITLE_SAVE);
            this.volumeSaved(overlayVol, false, false, null, null, false, sameThread);
        }
        catch (ParserConfigurationException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog(PROBLEM_SAVING_IMAGE_FILE + ex.getMessage(), ERROR_TITLE_SAVE);
            this.volumeSaved(overlayVol, false, false, null, null, false, sameThread);
        }
        catch (TransformerException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog(PROBLEM_SAVING_IMAGE_FILE + ex.getMessage(), ERROR_TITLE_SAVE);
            this.volumeSaved(overlayVol, false, false, null, null, false, sameThread);
        }
    }

    private void saveOverlays(boolean sameThread) {
        this.overlayWillBeSaved = true;
        this.saveNextOverlay(this.findNextOverlayToSave(null), sameThread);
    }

    private void saveROI(final File selectedFileVal, final int selectedSaveIndex, boolean sameThread) {
        if (sameThread) {
            this.doSaveROI(selectedFileVal, selectedSaveIndex);
        } else {
            Thread workThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    SliceViewer.this.doSaveROI(selectedFileVal, selectedSaveIndex);
                }
            }, "OrthogonalViewer.writeROI() Thread");
            workThread.start();
        }
    }

    private void saveVolume(boolean sameThread) {
        try {
            this.startIndeterminateProgressBar();
            this.volume.setDisplayValues(this.baseScreenVolume.getScreenMax(), this.baseScreenVolume.getScreenMin());
            this.volume.saveLabelData(this.getMangoVersion());
            this.volume.writeFiles(this.getLoadedFile(), sameThread);
        }
        catch (VolumeIOException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog("Problem saving image file!\nCheck write permissions!", ERROR_TITLE_SAVE);
            this.volumeSaved(this.volume, false, false, null, null, false, sameThread);
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog(PROBLEM_SAVING_IMAGE_FILE + ex.getMessage(), ERROR_TITLE_SAVE);
            this.volumeSaved(this.volume, false, false, null, null, false, sameThread);
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog(PROBLEM_SAVING_IMAGE_FILE + ex.getMessage(), ERROR_TITLE_SAVE);
            this.volumeSaved(this.volume, false, false, null, null, false, sameThread);
        }
        catch (ParserConfigurationException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog(PROBLEM_SAVING_IMAGE_FILE + ex.getMessage(), ERROR_TITLE_SAVE);
            this.volumeSaved(this.volume, false, false, null, null, false, sameThread);
        }
        catch (TransformerException ex) {
            AppLogger.error((Throwable)ex);
            this.mango.showErrorDialog(PROBLEM_SAVING_IMAGE_FILE + ex.getMessage(), ERROR_TITLE_SAVE);
            this.volumeSaved(this.volume, false, false, null, null, false, sameThread);
        }
    }

    private void selectAllLOIs() {
        this.loiManagerAxial.selectAll();
        this.loiManagerCoronal.selectAll();
        this.loiManagerSagittal.selectAll();
        this.shapeSelectionChanged();
        this.repaint();
    }

    private void selectAllPOIs() {
        this.poiManager.selectAll();
        if (this.timeseries.getParentFrame() != null) {
            ((TimeseriesTool)this.timeseries.getParentFrame()).selectionChanged();
        }
    }

    private void selectAllROIs() {
        if (this.roiManager.hasROI()) {
            this.roiManager.setSelectedSlice(this.axialImage.getCurrentSlice(), 0);
            this.roiManager.setSelectedSlice(this.coronalImage.getCurrentSlice(), 1);
            this.roiManager.setSelectedSlice(this.sagittalImage.getCurrentSlice(), 2);
            if (this.toolBox.isVOIMode()) {
                this.roiManager.selectAll();
            } else {
                int sliceDirection = this.mainImage.getSliceDirection();
                int currentSlice = this.mainImage.getCurrentSlice();
                if (sliceDirection == 0) {
                    this.roiManager.selectAllInRange(0, this.volume.getXDim() - 1, 0, this.volume.getYDim() - 1, currentSlice, currentSlice);
                } else if (sliceDirection == 1) {
                    this.roiManager.selectAllInRange(0, this.volume.getXDim() - 1, currentSlice, currentSlice, 0, this.volume.getZDim() - 1);
                } else {
                    this.roiManager.selectAllInRange(currentSlice, currentSlice, 0, this.volume.getYDim() - 1, 0, this.volume.getZDim() - 1);
                }
            }
            this.updateROISlices();
            this.repaint();
        }
    }

    private void setAsCurrentViewer() {
        if (this.toolBox != null && this.mango != null) {
            this.toolBox.setCurrentViewer(this);
            this.mango.setCurrentViewer(this);
            this.toolBox.updateFocusState();
            this.repaint();
        }
    }

    private void setCurrentOverlay(int index) {
        this.currentScreenVolume = index > 0 ? this.overlayManager.getOverlay(index - 1) : this.baseScreenVolume;
        this.toolBox.updateOverlayButton();
    }

    private void setLongestDim() {
        this.longestDim = this.volume.getXDim();
        this.longestDimSize = this.volume.getXSize();
        if ((double)this.volume.getYDim() * this.volume.getYSize() > (double)this.longestDim * this.longestDimSize) {
            this.longestDim = this.volume.getYDim();
            this.longestDimSize = this.volume.getYSize();
        }
        if ((double)this.volume.getZDim() * this.volume.getZSize() > (double)this.longestDim * this.longestDimSize) {
            this.longestDim = this.volume.getZDim();
            this.longestDimSize = this.volume.getZSize();
        }
    }

    private void setOverlaysTimepoint(double time) {
        ScreenVolume[] overlays = this.overlayManager.getAllOverlays();
        if (overlays != null) {
            for (ScreenVolume overlay : overlays) {
                if (overlay == null || overlay.getVolume().getNumTimepoints() <= 1) continue;
                overlay.getVolume().setCurrentTimepoint(time);
            }
        }
    }

    private void setOverlaysTimepoint(int index) {
        ScreenVolume[] overlays = this.overlayManager.getAllOverlays();
        if (overlays != null) {
            for (ScreenVolume overlay : overlays) {
                if (overlay == null || overlay.getVolume().getNumTimepoints() <= 1) continue;
                overlay.getVolume().setCurrentTimepoint(index);
            }
        }
    }

    private void setShowOverlay(boolean showCurrentOverlay, boolean showAllOverlay) {
        this.showCurrentOverlay = showCurrentOverlay;
        this.showAllOverlay = showAllOverlay;
        this.updateShowOverlay();
        this.toolBox.updateOverlayPopupMenu();
        this.toolBox.updateOverlayButton();
        this.clearOverlayData();
        this.updateScreenSlices();
        this.mango.setViewOverlayCurrent(showCurrentOverlay);
        Mango.getInstance().getToolBox().updateSurfaceTextures();
    }

    private void shapeAdded(LOIShape shape, boolean updateSurface) {
        if (this.roiInspector != null && this.roiInspector.isVisible()) {
            this.roiInspector.updateCounts();
        }
        if (updateSurface && this.surfaceRender != null && this.surfaceRender.isSyncingShapes()) {
            this.surfaceRender.addMarkerLine(shape);
        }
    }

    private void shapeDeleted(LOIShape shape, boolean updateSurface) {
        if (this.roiInspector != null && this.roiInspector.isVisible()) {
            this.roiInspector.updateCounts();
        }
        if (updateSurface && this.surfaceRender != null && this.surfaceRender.isSyncingShapes()) {
            this.surfaceRender.deleteROILine(shape);
        }
    }

    private void showTimeseriesSelectionDialog(Volume vol, int numTimepoints) {
        boolean isApplet = this.mango.isApplet();
        if (!isApplet) {
            TimepointSelectionDialog dialog = new TimepointSelectionDialog(numTimepoints);
            MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.getFrame(), (Object)dialog, "Multiple Volumes Found", -1, null, 2, (Object[])new String[]{"OK"}, (Object)"OK");
            jopf.show();
            if (dialog.isSingleSelection()) {
                int timepointToLoad = dialog.getSingleTimepoint();
                vol.setTimeseriesToSingleVolume(timepointToLoad, numTimepoints);
            } else if (dialog.isMultipleSelection()) {
                int minTimepoint = dialog.getTimepointMin();
                int maxTimepoint = dialog.getTimepointMax();
                int rangeTimepoints = maxTimepoint - minTimepoint + 1;
                if (rangeTimepoints < numTimepoints) {
                    vol.setTimeseriesToMultipleVolumes(minTimepoint, maxTimepoint, numTimepoints);
                }
            }
            vol.setForceDisplayIndex(dialog.isForceDisplayIndex());
            vol.setForceDisplayWorld(dialog.isForceDisplayWorld());
        }
    }

    private boolean sliceOrderingIsForwardOrientation() {
        char sliceDir = this.volume.getOrientationString().charAt(2);
        char sliceSense = this.volume.getOrientationString().charAt(5);
        if (sliceDir == 'X') {
            return sliceSense == '+';
        }
        if (sliceDir == 'Y') {
            return sliceSense == '-';
        }
        return sliceSense == '-';
    }

    private void smoothLOI(LOIShape loi) {
        if (this.loiManagerAxial.containsLOI(loi)) {
            this.loiManagerAxial.smoothLine(loi);
        } else if (this.loiManagerCoronal.containsLOI(loi)) {
            this.loiManagerCoronal.smoothLine(loi);
        } else if (this.loiManagerSagittal.containsLOI(loi)) {
            this.loiManagerSagittal.smoothLine(loi);
        }
        this.repaint();
    }

    private void updateActivePlanes(boolean force, boolean updateSurface) {
        if (force || this.surfaceRender != null && this.surfaceRender.isInitialized() && this.surfaceRender.isVisible() && this.surfaceRender.isFrameVisible()) {
            this.surfaceRender.updateActivePlanes(this.sagittalImage.getCurrentSlice(), this.coronalImage.getCurrentSlice(), this.axialImage.getCurrentSlice(), this.getMainSliceDirection(), updateSurface);
        }
    }

    private void updatelutManager() {
        LookupTableManager lutManager = this.baseScreenVolume.getLookupTableManager();
        lutManager.updateLUT(lutManager.getMaxLUT(), lutManager.getMinLUT(), true);
        this.repaint();
    }

    private void updateOverlays() {
        this.axialImage.updateOverlays();
        this.coronalImage.updateOverlays();
        this.sagittalImage.updateOverlays();
    }

    private void updateOverlaySensitiveData() {
        if (this.timeseries.getParentFrame() != null) {
            this.timeseries.clear();
            this.timeseries.updateTimeseries();
        }
        if (this.crosssection.getParentFrame() != null) {
            this.crosssection.clear();
            this.crosssection.updateCrosssection();
        }
        if (this.histogram.getParentFrame() != null) {
            this.histogram.getHistogramDialog().setUserMin(this.getCurrentScreenVolume().getScreenMin());
            this.histogram.getHistogramDialog().setUserMax(this.getCurrentScreenVolume().getScreenMax());
            this.histogram.setSelectedScreenVolumeIndex(this.getCurrentOverlayIndex());
        }
        this.getROIManager().setBufferSeriesIndex(this.getCurrentScreenVolume().getVolume().getCurrentTimepoint());
        this.updateROISlices();
        if (this.frame != null) {
            this.frame.updateLabelSeriesEditor();
        }
    }

    private void updateROISlices(boolean preUpdateOnly) {
        if (this.isViewerInitialized()) {
            boolean has = this.roiManager.hasROI();
            boolean hasCurrent = this.roiManager.hasROI(this.roiManager.getCurrentROI());
            this.axialImage.setROIState(has, hasCurrent);
            this.coronalImage.setROIState(has, hasCurrent);
            this.sagittalImage.setROIState(has, hasCurrent);
            if (!preUpdateOnly) {
                this.updateScreenSliceROIBuffers();
            }
        }
    }

    private void updateScreenSliceROIBuffers() {
        this.axialImage.updateROIShape();
        this.coronalImage.updateROIShape();
        this.sagittalImage.updateROIShape();
    }

    private void updateSelectedBoundsAndHandles() {
        this.axialImage.updateSelectedBoundsAndHandles();
        this.coronalImage.updateSelectedBoundsAndHandles();
        this.sagittalImage.updateSelectedBoundsAndHandles();
    }

    private void updateShowOverlay() {
        this.overlayManager.hideAll();
        if (this.showCurrentOverlay) {
            int currentOverlay = this.getCurrentOverlayIndex();
            if (currentOverlay >= 0) {
                this.overlayManager.getOverlay(currentOverlay).setHidden(false);
            }
        } else if (this.showAllOverlay) {
            this.overlayManager.showAll();
        }
    }

    private void updateSurfaceColorAtTimepoint() {
        if (this.surfaceRender != null && this.surfaceRender.isInitialized() && this.surfaceRender.isVisible() && this.surfaceRender.isFrameVisible()) {
            this.surfaceRender.updateSurfaceColorAtTimepoint();
        }
    }

    private void updateSurfaceTransform(boolean forceUpdate) {
        if (this.surfaceRender != null && this.surfaceRender.isInitialized() && this.surfaceRender.isVisible() && this.surfaceRender.isFrameVisible()) {
            if (this.isUsingTransform()) {
                this.surfaceRender.updateTransform(this.getCurrentTransform().getMatrixCopyInverse(), forceUpdate);
            } else {
                this.surfaceRender.updateTransform(null, forceUpdate);
            }
        }
    }

    private boolean volumeCanBeSaved() {
        boolean success = false;
        if (this.volume != null && !this.isTempImage && !this.isRGB() && !this.volume.isLoadedSeriesAsSinglePoint() && !this.volume.isLoadedSeriesAsSubset() && (this.volume.isDirty() && this.volume.isWritable(this.getLoadedFile()) && !this.volume.cannotBeOverwritten() || this.volume.hasDirtyHeader() && !this.volume.hasDirtyImage() && this.volume.isWritable(this.getLoadedFile()))) {
            success = true;
        }
        return success;
    }

    private void volumeLoaded(final boolean success, final boolean sameThread) {
        if (sameThread) {
            this.doVolumeLoaded(success, sameThread);
        } else {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    SliceViewer.this.doVolumeLoaded(success, sameThread);
                }
            };
            SwingWidgetUtilities.invokeLaterSafely((Runnable)runner);
        }
    }

    public void saveWithName(String saveLocation) {
        File file = new File(saveLocation);
        this.loadedURI = file.toURI();
        ReadableHeader header = this.volume.getReadableHeader();
        if (header != null && header instanceof WritableHeader) {
            WritableHeader headerWritable = (WritableHeader)header;
            File imageFile = headerWritable.formatImageFile(file);
            this.volume.setImageFileName(imageFile.getName());
        }
        this.save();
    }

    public double getZoomStored() {
        return this.zoomStored;
    }

    public void setZoomStored(double zoomStored) {
        this.zoomStored = zoomStored;
    }

    public void zoomToggle() {
        if (this.isZooming()) {
            this.setZoomStored(this.getZoomFactor());
            this.setZoomFactor(1.0, true);
        } else {
            this.setZoomFactor(this.getZoomStored(), true);
            this.setZoomFactorPrevious(this.getZoomStored());
        }
    }

    public void logPoint(Coordinate coordinate, String des) {
        Volume vol = this.getCurrentVolume();
        Coordinate4D coor = new Coordinate4D((double)coordinate.xInt, (double)coordinate.yInt, (double)coordinate.zInt, vol.getCurrentSeriesPoint());
        PointStatROIOp op = new PointStatROIOp(this, vol, this.getROIManager().getBuffer());
        double result = op.process(coor, vol.getCurrentTimepoint());
        Mango.getInstance().getResultsManager().addPoint(this, vol, coor, result, des);
    }

    public void addBookmark(Coordinate coord, String label) {
        this.volume.addBookmark(coord, label);
    }

    public void setOrientationOption(final ImageVolume volume, final int index) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SliceViewer.this.setSelectedCoordinateSpaceTransform(volume, index);
                SliceViewer.this.mango.getToolBox().updateCoordinate(4);
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }
}

