/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerprojection.window;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.progressbar.ProgressBar;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.viewerprojection.ProjectionData;
import edu.uthscsa.ric.mango.viewerprojection.ProjectionViewer;
import edu.uthscsa.ric.mango.viewerprojection.components.projectionmanager.ProjectionManager;
import edu.uthscsa.ric.mango.viewerprojection.menus.ProjectionViewerMenu;
import edu.uthscsa.ric.mango.viewerprojection.operations.building.BuildProjectionParameters;
import edu.uthscsa.ric.mango.viewerprojection.operations.building.ProjectionBuilder;
import edu.uthscsa.ric.mango.viewerprojection.operations.building.ProjectionBuilderListener;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.mango.viewerslice.keyboard.KeyboardMap;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.volume.Volume;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class ProjectionFrame
extends JFrame
implements ViewerAssociated,
ProjectionBuilderListener,
ComponentListener {
    private ProjectionManager projectionManager;
    private ProjectionViewerMenu menu;
    private ProjectionViewer proj;
    private int heightDecorationSize;
    private int widthDecorationSize;
    private boolean sync;
    private final BuildProjectionParameters params;
    private final Mango mango;
    private final SliceViewer viewer;
    private static final long serialVersionUID = 1L;
    public static final Font MENU_FONT = new Font("SansSerif", 0, 11);
    public static final String NAME = "Projection";
    public static final double INCREMENT_FACTOR = 0.1;
    public static final int INNER_PAD = 4;
    public static final int MINIMUM_WIDTH = 250;

    public ProjectionFrame(Mango mango, SliceViewer viewer, BuildProjectionParameters params) {
        this.mango = mango;
        this.viewer = viewer;
        this.params = params;
    }

    public void addProjectionManager() {
        if (this.projectionManager == null) {
            this.projectionManager = new ProjectionManager(this.proj);
            this.getContentPane().add((Component)this.projectionManager, "South");
            this.validate();
            this.pack();
        }
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
        if (this.proj.isSticky()) {
            this.proj.getViewer().doSticky();
        }
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        this.proj.updateScreenTransform(Math.min(this.getSize().width, this.getSize().height));
        this.proj.updateDisplay();
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    public void decrementSize() {
        this.doNewSize(this.checkSize((int)Math.round((double)this.getSize().width - (double)this.getSize().width * 0.1)), false);
    }

    @Override
    public String getDescription() {
        return NAME;
    }

    public ProjectionViewer getProjectionView() {
        return this.proj;
    }

    @Override
    public SliceViewer getViewer() {
        return this.viewer;
    }

    @Override
    public JFrame getWindow() {
        return this;
    }

    public void incrementSize() {
        this.doNewSize(this.checkSize((int)Math.round((double)this.getSize().width + (double)this.getSize().width * 0.1)), false);
    }

    public void maximize() {
        this.doNewSize(this.checkSize(Integer.MAX_VALUE), false);
        this.setLocation(new Point(this.getLocation().x, DisplayUtils.findInsetsOfDisplay((int)DisplayUtils.findCurrentDisplayIndex((Component)this)).top));
    }

    @Override
    public void projectionsCompleted(final ProjectionData pd, final BuildProjectionParameters params) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProjectionFrame.this.buildFinished(pd, params);
            }
        };
        if (this.sync) {
            SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
        } else {
            SwingWidgetUtilities.invokeLaterSafely((Runnable)runnable);
        }
    }

    public void startBuild(boolean sameThread) {
        this.sync = sameThread;
        ProgressBar progressBar = new ProgressBar(this.viewer.getMango().getToolBox(), "Building Projection");
        progressBar.setForceStart();
        ProjectionBuilder pb = new ProjectionBuilder(this.viewer, this.params);
        pb.project(progressBar, this, sameThread);
    }

    private void buildFinished(ProjectionData pd, BuildProjectionParameters params) {
        float dataMax = pd.getMax();
        float dataMin = pd.getMin();
        float diff = dataMax - dataMin;
        float rangeMax = (float)((double)dataMax - (double)diff * 0.25);
        float rangeMin = (float)((double)dataMin + (double)diff * 0.25);
        if (params.rankType == 0) {
            rangeMax = dataMax;
            rangeMin = (float)((double)dataMin + (double)diff * 0.5);
        } else if (params.rankType == 1) {
            rangeMax = dataMax;
            rangeMin = dataMin;
        } else if (params.rankType == 2) {
            rangeMax = (float)((double)dataMax - (double)diff * 0.5);
            rangeMin = dataMin;
        }
        this.createGUI(params);
        this.proj.setDefaultMin(rangeMin);
        this.proj.setDefaultMax(rangeMax);
        this.proj.getOptions().setMin(rangeMin);
        this.proj.getOptions().setMax(rangeMax);
        this.viewer.updateViewer();
        this.proj.setData(pd);
        this.setVisible(true);
        this.toFront();
        this.repaint();
        this.updateProjectionManager();
    }

    public void updateProjectionManager() {
        this.projectionManager.updateProjectionManager();
    }

    private void changeSize(int width) {
        this.doNewSize(this.checkSize(width), false);
    }

    private int checkSize(int currentWidthVal) {
        int currentWidth = currentWidthVal;
        int displayIndex = DisplayUtils.findCurrentDisplayIndex(this);
        Dimension displaySize = DisplayUtils.findSizeOfDisplay(displayIndex);
        Insets displayInsets = DisplayUtils.findInsetsOfDisplay(displayIndex);
        int displayHeight = displaySize.height - (displayInsets.top + displayInsets.bottom);
        int maxWidth = displayHeight - this.heightDecorationSize + 8;
        if (currentWidth > maxWidth) {
            currentWidth = maxWidth;
        } else if (currentWidth < 250) {
            currentWidth = 250;
        }
        return currentWidth;
    }

    private void createGUI(BuildProjectionParameters params) {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        Volume vol = this.viewer.getVolume();
        int xDim = (int)Math.round((double)vol.getXDim() * (vol.getXSize() / (double)params.resX));
        int yDim = (int)Math.round((double)vol.getYDim() * (vol.getYSize() / (double)params.resY));
        int zDim = (int)Math.round((double)vol.getZDim() * (vol.getZSize() / (double)params.resZ));
        double xSize = params.resX;
        double ySize = params.resY;
        double zSize = params.resZ;
        if (params.planeOfProjection == 0) {
            this.proj = new ProjectionViewer(this.viewer, xDim, yDim, xSize, ySize, params.axisOfRotation == 1, this);
        } else if (params.planeOfProjection == 1) {
            this.proj = new ProjectionViewer(this.viewer, xDim, zDim, xSize, ySize, params.axisOfRotation == 2, this);
        } else if (params.planeOfProjection == 2) {
            this.proj = new ProjectionViewer(this.viewer, yDim, zDim, ySize, zSize, params.axisOfRotation == 2, this);
        }
        mainPanel.add(this.proj);
        this.setTitle("Projection: " + this.viewer.getImageTitle());
        this.getContentPane().add((Component)mainPanel, "Center");
        this.setBackground(this.mango.getPanelOutsideColor());
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent we) {
                if (ProjectionFrame.this.proj != null) {
                    Mango.getInstance().setCurrentViewer(ProjectionFrame.this.proj.getViewer());
                    Mango.getInstance().getToolBox().updateFocusState();
                    Mango.getInstance().getToolBox().updateEnabledItems();
                }
            }

            @Override
            public void windowClosed(WindowEvent we) {
            }

            @Override
            public void windowClosing(WindowEvent we) {
                if (!ProjectionFrame.this.viewer.getMango().isApplet()) {
                    ProjectionFrame.this.viewer.getViewerFrame().removeStickyWindow(ProjectionFrame.this.proj);
                }
            }

            @Override
            public void windowDeactivated(WindowEvent we) {
                Mango.getInstance().getToolBox().updateTextFields();
                Mango.getInstance().getToolBox().closePopups();
            }

            @Override
            public void windowDeiconified(WindowEvent we) {
                Mango.getInstance().getToolBox().setState(0);
                Mango.getInstance().getToolBox().toFront();
                Mango.getInstance().getToolBox().updateFocusState();
                Mango.getInstance().getToolBox().updateEnabledItems();
            }

            @Override
            public void windowIconified(WindowEvent we) {
                Mango.getInstance().getToolBox().updateFocusState();
                Mango.getInstance().getToolBox().updateEnabledItems();
            }

            @Override
            public void windowOpened(WindowEvent arg0) {
            }
        });
        this.addComponentListener(this);
        this.addProjectionManager();
        this.menu = new ProjectionViewerMenu(this.proj);
        this.setJMenuBar(this.menu.create());
        int size = this.viewer.isOrthoWide() ? this.viewer.getViewerSize().height : this.viewer.getViewerSize().width;
        this.setResizable(false);
        this.doNewSize(size, true);
        this.changeSize(size);
        this.setIconImage(MangoStyle.ICON_APP.getImage());
        this.validate();
        this.setLocation(DisplayUtils.getNextWindowLocation(this.viewer.getViewerContainer(), this.getSize(), null, this.mango.isApplet()));
        if (this.viewer.getViewerFrame() != null) {
            this.viewer.getViewerFrame().addStickyWindow(this.proj);
        }
        KeyboardMap.createKeyboardMap(this.getRootPane(), this.viewer);
        this.viewer.associateWindow(this);
        this.proj.requestFocusInWindow();
        this.proj.requestFocus();
    }

    private void doNewSize(int currentWidth, boolean doPack) {
        if (doPack) {
            this.pack();
            this.heightDecorationSize = this.getSize().height;
            this.widthDecorationSize = this.getInsets().left + this.getInsets().right;
        } else {
            this.setSize(new Dimension(currentWidth + this.widthDecorationSize, currentWidth + this.heightDecorationSize - 8));
        }
    }

    public JMenuItem getMenuItem(String string) {
        return this.menu.getMenuItem(string);
    }

    public ProjectionViewerMenu getMenu() {
        return this.menu;
    }
}

