/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerprojection.operations.building;

import Jama.Matrix;
import edu.uthscsa.ric.mango.components.progressbar.ProgressBar;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerprojection.ProjectionData;
import edu.uthscsa.ric.mango.viewerprojection.operations.building.BuildProjectionParameters;
import edu.uthscsa.ric.mango.viewerprojection.operations.building.ProjectionBuilderListener;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.RankSearch;
import edu.uthscsa.ric.volume.ImageTransform;
import edu.uthscsa.ric.volume.Transform;
import edu.uthscsa.ric.volume.Volume;
import java.util.List;
import java.util.Vector;

public class ProjectionBuilder {
    private ProgressBar progressBar;
    private ProjectionBuilderListener listener;
    private float minVal;
    private float maxVal;
    private float[][] allProjections;
    private int numProjections;
    private final BuildProjectionParameters params;
    private final VolumeManager viewer;
    private final double xSize;
    private final double ySize;
    private final double zSize;
    private final int xDim;
    private final int yDim;
    private final int zDim;
    public static final int SMOOTHNESS_THRESHOLD = 3;
    public static final List<Integer> FRAME_INCREMENTS = CollectionUtilities.immutable((Integer[])new Integer[]{20, 10, 5, 2, 1});

    public ProjectionBuilder(VolumeManager viewer, BuildProjectionParameters params) {
        this.viewer = viewer;
        this.params = params;
        Volume vol = (Volume)viewer.getBaseVolume();
        this.minVal = Float.MAX_VALUE;
        this.maxVal = Float.MIN_VALUE;
        this.xDim = (int)Math.round((double)vol.getXDim() * (vol.getXSize() / (double)params.resX));
        this.yDim = (int)Math.round((double)vol.getYDim() * (vol.getYSize() / (double)params.resY));
        this.zDim = (int)Math.round((double)vol.getZDim() * (vol.getZSize() / (double)params.resZ));
        this.xSize = params.resX;
        this.ySize = params.resY;
        this.zSize = params.resZ;
    }

    public synchronized void project(ProgressBar progressBar, ProjectionBuilderListener listener, boolean sameThread) {
        this.progressBar = progressBar;
        this.listener = listener;
        if (this.params.smoothness < 3) {
            Transform.setGlobalNearestNeighborState(true);
        }
        int increment = FRAME_INCREMENTS.get(this.params.smoothness);
        this.numProjections = 180 / increment;
        this.allProjections = new float[this.numProjections][];
        int numProcessorsTotal = Platform.PROCESSOR_COUNT;
        int maxThreads = 8;
        int numProcessors = Math.min(numProcessorsTotal, 8);
        int numProcessesPerThread = this.numProjections / numProcessors;
        int numProcessesPerThreadRemainder = this.numProjections % numProcessors;
        if (progressBar != null) {
            progressBar.init(0, 0, this.numProjections);
            progressBar.setForceStart();
        }
        int projectionIndex = 0;
        for (int ctr = 0; ctr < numProcessors; ++ctr) {
            int start = projectionIndex;
            int end = projectionIndex + numProcessesPerThread;
            if (numProcessesPerThreadRemainder > 0) {
                ++end;
                --numProcessesPerThreadRemainder;
            }
            ProjectionThread workThread = new ProjectionThread(this, start, end, increment);
            if (sameThread) {
                workThread.doRun();
            } else {
                workThread.start();
            }
            projectionIndex = end;
        }
    }

    protected BuildProjectionParameters getParams() {
        return this.params;
    }

    private synchronized void addProjection(float[] projection, float min, float max, int index) {
        this.allProjections[index] = projection;
        int numCompleted = 0;
        for (float[] allProjection : this.allProjections) {
            if (allProjection == null) continue;
            ++numCompleted;
        }
        if (this.progressBar != null) {
            this.progressBar.setValue(numCompleted);
        }
        if (min < this.minVal) {
            this.minVal = min;
        }
        if (max > this.maxVal) {
            this.maxVal = max;
        }
        if (numCompleted == this.numProjections) {
            ProjectionData pd = new ProjectionData();
            Vector<float[]> allProjectionsVec = new Vector<float[]>();
            for (float[] allProjection : this.allProjections) {
                allProjectionsVec.add(allProjection);
            }
            pd.setData(allProjectionsVec);
            pd.setMax(this.maxVal);
            pd.setMin(this.minVal);
            Transform.setGlobalNearestNeighborState(false);
            if (this.listener != null) {
                this.listener.projectionsCompleted(pd, this.params);
            }
        }
    }

    class ProjectionThread
    extends Thread {
        private final ProjectionBuilder builder;
        private final ImageTransform imageTrans;
        private final Matrix sizeThis;
        private final int start;
        private final int end;
        private final int increment;
        private final double[][] transform;
        private final double[][] rotation;
        private final double[][] tempTrans;
        private final double[][] tempTrans2;
        private final double[][] center;
        private final double[][] centerInverse;
        private final double[][] imageTransform;

        protected ProjectionThread(ProjectionBuilder builder, int start, int end, int increment) {
            this.builder = builder;
            this.start = start * increment;
            this.end = end * increment;
            this.increment = increment;
            this.transform = new double[4][4];
            this.rotation = new double[4][4];
            this.tempTrans = new double[4][4];
            this.tempTrans2 = new double[4][4];
            this.center = new double[4][4];
            this.centerInverse = new double[4][4];
            Volume vol = (Volume)ProjectionBuilder.this.viewer.getBaseVolume();
            double[][] sizeThisArray = new double[4][4];
            sizeThisArray[0][0] = 1.0 / vol.getXSize();
            sizeThisArray[1][1] = 1.0 / vol.getYSize();
            sizeThisArray[2][2] = 1.0 / vol.getZSize();
            sizeThisArray[3][3] = 1.0;
            this.sizeThis = new Matrix(sizeThisArray);
            this.updateCenterTransforms();
            this.clearTransforms();
            this.imageTransform = new Matrix(((Volume)ProjectionBuilder.this.viewer.getBaseVolume()).getIndexImageTransform(0).getMatrixCopy()).inverse().getArray();
            this.imageTrans = ((Volume)ProjectionBuilder.this.viewer.getBaseVolume()).createTransform(new Matrix(this.transform));
        }

        @Override
        public void run() {
            this.doRun();
        }

        public void doRun() {
            block40: {
                float max;
                float min;
                Volume vol;
                block41: {
                    block39: {
                        vol = (Volume)ProjectionBuilder.this.viewer.getBaseVolume();
                        min = Float.MAX_VALUE;
                        max = Float.MIN_VALUE;
                        if (((ProjectionBuilder)ProjectionBuilder.this).params.planeOfProjection != 2) break block39;
                        for (int ctr = this.start; ctr < this.end; ctr += this.increment) {
                            if (((ProjectionBuilder)ProjectionBuilder.this).params.axisOfRotation == 2) {
                                this.transform(false, false, true, ctr);
                            } else if (((ProjectionBuilder)ProjectionBuilder.this).params.axisOfRotation == 1) {
                                this.transform(false, true, false, ctr);
                            }
                            float[] data = new float[ProjectionBuilder.this.zDim * ProjectionBuilder.this.yDim];
                            float[] current = new float[ProjectionBuilder.this.xDim];
                            for (int ctrY = 0; ctrY < ProjectionBuilder.this.zDim; ++ctrY) {
                                int rowIndex = ctrY * ProjectionBuilder.this.yDim;
                                for (int ctrX = 0; ctrX < ProjectionBuilder.this.yDim; ++ctrX) {
                                    int index = rowIndex + ctrX;
                                    for (int ctrSlice = 0; ctrSlice < ProjectionBuilder.this.xDim; ++ctrSlice) {
                                        current[ctrSlice] = (float)vol.getVoxelValueAtMM((double)ctrSlice * ProjectionBuilder.this.xSize, (double)ctrX * ProjectionBuilder.this.ySize, (double)ctrY * ProjectionBuilder.this.zSize, vol.getCurrentTimepoint(), this.imageTrans);
                                    }
                                    if (((ProjectionBuilder)ProjectionBuilder.this).params.rankType == 0) {
                                        data[index] = RankSearch.searchMax((float[])current);
                                    } else if (((ProjectionBuilder)ProjectionBuilder.this).params.rankType == 1) {
                                        data[index] = RankSearch.sortAndSearchMedian((float[])current);
                                    } else if (((ProjectionBuilder)ProjectionBuilder.this).params.rankType == 2) {
                                        data[index] = RankSearch.searchMinNonZero((float[])current);
                                    }
                                    if (data[index] != 0.0f && data[index] < min) {
                                        min = data[index];
                                    }
                                    if (!(data[index] > max)) continue;
                                    max = data[index];
                                }
                            }
                            this.builder.addProjection(data, min, max, ctr / this.increment);
                        }
                        break block40;
                    }
                    if (((ProjectionBuilder)ProjectionBuilder.this).params.planeOfProjection != 1) break block41;
                    for (int ctr = this.start; ctr < this.end; ctr += this.increment) {
                        if (((ProjectionBuilder)ProjectionBuilder.this).params.axisOfRotation == 2) {
                            this.transform(false, false, true, ctr);
                        } else if (((ProjectionBuilder)ProjectionBuilder.this).params.axisOfRotation == 0) {
                            this.transform(true, false, false, ctr);
                        }
                        float[] data = new float[ProjectionBuilder.this.zDim * ProjectionBuilder.this.xDim];
                        float[] current = new float[ProjectionBuilder.this.yDim];
                        for (int ctrY = 0; ctrY < ProjectionBuilder.this.zDim; ++ctrY) {
                            int rowIndex = ctrY * ProjectionBuilder.this.xDim;
                            for (int ctrX = 0; ctrX < ProjectionBuilder.this.xDim; ++ctrX) {
                                int index = rowIndex + ctrX;
                                for (int ctrSlice = 0; ctrSlice < ProjectionBuilder.this.yDim; ++ctrSlice) {
                                    current[ctrSlice] = (float)vol.getVoxelValueAtMM((double)ctrX * ProjectionBuilder.this.xSize, (double)ctrSlice * ProjectionBuilder.this.ySize, (double)ctrY * ProjectionBuilder.this.zSize, vol.getCurrentTimepoint(), this.imageTrans);
                                }
                                if (((ProjectionBuilder)ProjectionBuilder.this).params.rankType == 0) {
                                    data[index] = RankSearch.searchMax((float[])current);
                                } else if (((ProjectionBuilder)ProjectionBuilder.this).params.rankType == 1) {
                                    data[index] = RankSearch.sortAndSearchMedian((float[])current);
                                } else if (((ProjectionBuilder)ProjectionBuilder.this).params.rankType == 2) {
                                    data[index] = RankSearch.searchMinNonZero((float[])current);
                                }
                                if (data[index] != 0.0f && data[index] < min) {
                                    min = data[index];
                                }
                                if (!(data[index] > max)) continue;
                                max = data[index];
                            }
                        }
                        this.builder.addProjection(data, min, max, ctr / this.increment);
                    }
                    break block40;
                }
                if (((ProjectionBuilder)ProjectionBuilder.this).params.planeOfProjection != 0) break block40;
                for (int ctr = this.start; ctr < this.end; ctr += this.increment) {
                    if (((ProjectionBuilder)ProjectionBuilder.this).params.axisOfRotation == 0) {
                        this.transform(true, false, false, ctr);
                    } else if (((ProjectionBuilder)ProjectionBuilder.this).params.axisOfRotation == 1) {
                        this.transform(false, true, false, ctr);
                    }
                    float[] data = new float[ProjectionBuilder.this.xDim * ProjectionBuilder.this.yDim];
                    float[] current = new float[ProjectionBuilder.this.zDim];
                    for (int ctrY = 0; ctrY < ProjectionBuilder.this.yDim; ++ctrY) {
                        int rowIndex = ctrY * ProjectionBuilder.this.xDim;
                        for (int ctrX = 0; ctrX < ProjectionBuilder.this.xDim; ++ctrX) {
                            int index = rowIndex + ctrX;
                            for (int ctrSlice = 0; ctrSlice < ProjectionBuilder.this.zDim; ++ctrSlice) {
                                current[ctrSlice] = (float)vol.getVoxelValueAtMM((double)ctrX * ProjectionBuilder.this.xSize, (double)ctrY * ProjectionBuilder.this.ySize, (double)ctrSlice * ProjectionBuilder.this.zSize, vol.getCurrentTimepoint(), this.imageTrans);
                            }
                            if (((ProjectionBuilder)ProjectionBuilder.this).params.rankType == 0) {
                                data[index] = RankSearch.searchMax((float[])current);
                            } else if (((ProjectionBuilder)ProjectionBuilder.this).params.rankType == 1) {
                                data[index] = RankSearch.sortAndSearchMedian((float[])current);
                            } else if (((ProjectionBuilder)ProjectionBuilder.this).params.rankType == 2) {
                                data[index] = RankSearch.searchMinNonZero((float[])current);
                            }
                            if (data[index] != 0.0f && data[index] < min) {
                                min = data[index];
                            }
                            if (!(data[index] > max)) continue;
                            max = data[index];
                        }
                    }
                    this.builder.addProjection(data, min, max, ctr / this.increment);
                }
            }
        }

        private void clearTransforms() {
            for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    if (ctrOut == ctrIn) {
                        this.transform[ctrOut][ctrIn] = 1.0;
                        this.rotation[ctrOut][ctrIn] = 1.0;
                        continue;
                    }
                    this.transform[ctrOut][ctrIn] = 0.0;
                    this.rotation[ctrOut][ctrIn] = 0.0;
                }
            }
        }

        private void transform(boolean rotX, boolean rotY, boolean rotZ, int degrees) {
            int ctrIn;
            int ctrOut;
            double sinTheta;
            double cosTheta;
            double theta;
            if (rotX) {
                theta = (double)degrees * Math.PI / 180.0;
                cosTheta = Math.cos(theta);
                sinTheta = Math.sin(theta);
                this.rotation[1][1] = cosTheta;
                this.rotation[1][2] = sinTheta;
                this.rotation[2][1] = -1.0 * sinTheta;
                this.rotation[2][2] = cosTheta;
            }
            if (rotY) {
                theta = (double)degrees * Math.PI / 180.0;
                cosTheta = Math.cos(theta);
                sinTheta = Math.sin(theta);
                this.rotation[0][0] = cosTheta;
                this.rotation[0][2] = -1.0 * sinTheta;
                this.rotation[2][0] = sinTheta;
                this.rotation[2][2] = cosTheta;
            }
            if (rotZ) {
                theta = (double)degrees * Math.PI / 180.0;
                cosTheta = Math.cos(theta);
                sinTheta = Math.sin(theta);
                this.rotation[0][0] = cosTheta;
                this.rotation[0][1] = sinTheta;
                this.rotation[1][0] = -1.0 * sinTheta;
                this.rotation[1][1] = cosTheta;
            }
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.tempTrans[ctrOut][ctrIn] = this.centerInverse[ctrOut][0] * this.rotation[0][ctrIn] + this.centerInverse[ctrOut][1] * this.rotation[1][ctrIn] + this.centerInverse[ctrOut][2] * this.rotation[2][ctrIn] + this.centerInverse[ctrOut][3] * this.rotation[3][ctrIn];
                }
            }
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.tempTrans2[ctrOut][ctrIn] = this.tempTrans[ctrOut][0] * this.center[0][ctrIn] + this.tempTrans[ctrOut][1] * this.center[1][ctrIn] + this.tempTrans[ctrOut][2] * this.center[2][ctrIn] + this.tempTrans[ctrOut][3] * this.center[3][ctrIn];
                }
            }
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.transform[ctrOut][ctrIn] = this.tempTrans2[ctrOut][0] * this.imageTransform[0][ctrIn] + this.tempTrans2[ctrOut][1] * this.imageTransform[1][ctrIn] + this.tempTrans2[ctrOut][2] * this.imageTransform[2][ctrIn] + this.tempTrans2[ctrOut][3] * this.imageTransform[3][ctrIn];
                }
            }
            double[][] array = this.sizeThis.times(new Matrix(this.transform).inverse()).times(this.sizeThis.inverse()).getArrayCopy();
            this.imageTrans.updateTransform(array);
        }

        private void updateCenterTransforms() {
            Volume vol = (Volume)ProjectionBuilder.this.viewer.getBaseVolume();
            int xDim = vol.getXDim();
            int yDim = vol.getYDim();
            int zDim = vol.getZDim();
            double xSize = vol.getXSize();
            double ySize = vol.getYSize();
            double zSize = vol.getZSize();
            int axialPos = zDim / 2;
            int coronalPos = yDim / 2;
            int sagittalPos = xDim / 2;
            this.center[3][3] = 1.0;
            this.center[2][2] = 1.0;
            this.center[1][1] = 1.0;
            this.center[0][0] = 1.0;
            this.center[0][3] = (double)(-1 * sagittalPos) * xSize;
            this.center[1][3] = (double)(-1 * coronalPos) * ySize;
            this.center[2][3] = (double)(-1 * axialPos) * zSize;
            this.centerInverse[3][3] = 1.0;
            this.centerInverse[2][2] = 1.0;
            this.centerInverse[1][1] = 1.0;
            this.centerInverse[0][0] = 1.0;
            this.centerInverse[0][3] = (double)sagittalPos * xSize;
            this.centerInverse[1][3] = (double)coronalPos * ySize;
            this.centerInverse[2][3] = (double)axialPos * zSize;
        }
    }
}

