/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerprojection.menus;

import edu.uthscsa.ric.mango.MangoPreferences;
import edu.uthscsa.ric.mango.components.menus.MangoCheckBoxMenuItem;
import edu.uthscsa.ric.mango.components.menus.MangoMenu;
import edu.uthscsa.ric.mango.components.menus.MangoMenuItem;
import edu.uthscsa.ric.mango.viewerprojection.ProjectionViewer;
import edu.uthscsa.ric.mango.viewerprojection.menus.ProjectionViewerMenuAction;
import edu.uthscsa.ric.utilities.AppLogger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.commons.lang3.StringUtils;

public class ProjectionViewerMenu
implements MenuListener {
    private JCheckBoxMenuItem animate;
    private JCheckBoxMenuItem windowMenuSticky;
    private final ProjectionViewer projView;
    private final int fontSize;
    static final Map<String, JMenuItem> MENU_ACTION_MAP = new TreeMap<String, JMenuItem>();
    static final Map<String, JMenuItem> MENU_NAME_MAP = new TreeMap<String, JMenuItem>();

    public ProjectionViewerMenu(ProjectionViewer projView) {
        this.projView = projView;
        this.fontSize = 11;
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this.updateMenu();
    }

    public JMenuBar create() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.setBorder(BorderFactory.createLineBorder((Color)UIManager.get("MenuItem.background")));
        MangoMenu projectionMenu = new MangoMenu("Projection", this.fontSize, false);
        projectionMenu.addMenuListener(this);
        projectionMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        menuBar.add(projectionMenu);
        MangoMenuItem projectionOptions = new MangoMenuItem(new ProjectionViewerMenuAction("Options...", this.projView), "Options (Projection)", this.fontSize, false);
        projectionMenu.add(projectionOptions);
        this.animate = new MangoCheckBoxMenuItem(new ProjectionViewerMenuAction("Animate", this.projView), "Animate (Projection)", this.fontSize, false);
        projectionMenu.add(this.animate);
        projectionMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        MangoMenuItem projectionSnapshot = new MangoMenuItem(new ProjectionViewerMenuAction("Create Snapshot...", this.projView), null, this.fontSize, false);
        projectionMenu.add(projectionSnapshot);
        MangoMenuItem projectionVideo = new MangoMenuItem(new ProjectionViewerMenuAction("Create Video...", this.projView), "Create Video... (Projection)", this.fontSize, false);
        projectionMenu.add(projectionVideo);
        projectionMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        MangoMenu windowMenu = new MangoMenu("Window", this.fontSize, true);
        menuBar.add(windowMenu);
        windowMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        MangoMenuItem windowMenuMaximize = new MangoMenuItem(new ProjectionViewerMenuAction("Maximize", this.projView), "Projection - Maximize Window", this.fontSize, false);
        windowMenu.add(windowMenuMaximize);
        MangoMenuItem windowMenuMinimize = new MangoMenuItem(new ProjectionViewerMenuAction("Dock", this.projView), null, this.fontSize, false);
        windowMenuMinimize.setAccelerator(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        windowMenu.add(windowMenuMinimize);
        windowMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        MangoMenuItem windowMenuZoomIn = new MangoMenuItem(new ProjectionViewerMenuAction("Zoom In", this.projView), null, this.fontSize, false);
        windowMenuZoomIn.setAccelerator(KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        windowMenu.add(windowMenuZoomIn);
        MangoMenuItem windowMenuZoomOut = new MangoMenuItem(new ProjectionViewerMenuAction("Zoom Out", this.projView), null, this.fontSize, false);
        windowMenuZoomOut.setAccelerator(KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        windowMenu.add(windowMenuZoomOut);
        windowMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.windowMenuSticky = new MangoCheckBoxMenuItem(new ProjectionViewerMenuAction("Stick to Slice Viewer", this.projView), "Sticky Window (Projection)", this.fontSize, false);
        windowMenu.add(this.windowMenuSticky);
        windowMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        windowMenu.addMenuListener(this);
        this.updateMenu();
        this.createMenuItemMap();
        return menuBar;
    }

    private void updateMenu() {
        this.animate.setSelected(this.projView.getOptions().isAnimating());
        this.windowMenuSticky.setSelected(this.projView.isSticky());
    }

    private void createMenuItemMap() {
        Field[] allFields;
        for (Field field : allFields = this.getClass().getDeclaredFields()) {
            String text;
            if (!field.getType().isAssignableFrom(JMenuItem.class)) continue;
            JMenuItem item = null;
            try {
                item = (JMenuItem)field.get(this);
            }
            catch (IllegalArgumentException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                AppLogger.error((Throwable)ex);
            }
            if (item == null) continue;
            String name = item.getName();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                MENU_ACTION_MAP.put(name, item);
            }
            if (!StringUtils.isNotBlank((CharSequence)(text = item.getText()))) continue;
            MENU_NAME_MAP.put(text, item);
        }
    }

    private void clearAllAccelerators() {
        Collection<JMenuItem> items = MENU_ACTION_MAP.values();
        for (JMenuItem item : items) {
            item.setAccelerator(null);
        }
    }

    public void updateAllAccelerators(String[] actions) {
        this.clearAllAccelerators();
        for (int ctr = 0; ctr < actions.length; ++ctr) {
            String actionLabel = actions[ctr];
            JMenuItem item = MENU_ACTION_MAP.get(actionLabel);
            if (item == null) continue;
            item.setAccelerator(KeyStroke.getKeyStroke(MangoPreferences.FUNCTION_KEY_CODES.get(ctr), 0));
        }
    }

    public JMenuItem getMenuItem(String action) {
        JMenuItem item = MENU_ACTION_MAP.get(action);
        if (item == null) {
            item = MENU_NAME_MAP.get(action);
        }
        return item;
    }
}

