/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerprojection.components.projectionmanager;

import edu.uthscsa.ric.mango.viewerprojection.ProjectionViewer;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProjectionManager
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private final ProjectionViewer viewer;
    private JSlider slider;
    private boolean initialized;
    private boolean freezeState;

    public ProjectionManager(ProjectionViewer viewer) {
        this.viewer = viewer;
        this.createUI();
    }

    private void createUI() {
        this.slider = new JSlider();
        this.slider.setPaintTicks(true);
        this.slider.setSnapToTicks(true);
        this.slider.addChangeListener(this);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.slider);
    }

    public void updateProjectionManager() {
        this.freezeState = true;
        int num = this.viewer.getNumFrames();
        this.slider.setMaximum(num - 1);
        if (num > 25) {
            this.slider.setMajorTickSpacing(5);
            this.slider.setMinorTickSpacing(1);
        } else {
            this.slider.setMajorTickSpacing(1);
        }
        if (this.initialized) {
            this.slider.setValue(this.viewer.getProjectionIndex() % num);
        } else {
            this.initialized = true;
            this.slider.setValue(0);
        }
        this.freezeState = false;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (!this.freezeState) {
            if (this.viewer.getProjectionIndex() != this.slider.getValue()) {
                this.viewer.setProjectionIndex(this.slider.getValue());
            }
            this.viewer.stopAnimatingQuietly();
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

