/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.plugin.imageloaders.talairachloader;

import edu.uthscsa.ric.mango.ImageLoader;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.VoxelDimensions;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class TalairachLoader
implements ImageLoader,
ActionListener {
    private JComboBox<String> label;
    private JComboBox<String> level;
    private JPanel panel;
    private String[][] labels;
    private boolean initialized;
    private static int labelIndex;
    private static int levelIndex;
    private static final String PLUGIN_NAME = "Talairach Loader";
    public static final String MIN_MANGO_SUPPORTED = "2.5";
    public static final String PLUGIN_URL = "http://rii.uthscsa.edu/mango/plugin_talload.html";
    public static final String VERSION = "1.1";

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateLabels();
    }

    public byte[] getData() {
        return new byte[0];
    }

    public JPanel getImageSelectionPanel(JButton loadButton) {
        return this.getSelectionPanel();
    }

    public InputStream getInputStream() {
        return null;
    }

    public String getMinimumVersionSupported() {
        return MIN_MANGO_SUPPORTED;
    }

    public JPanel getOverlaySelectionPanel(String imageName, ImageDimensions id, VoxelDimensions vd, JButton loadButton) {
        return this.getSelectionPanel();
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    public URL getPluginURL() {
        try {
            return new URL(PLUGIN_URL);
        }
        catch (MalformedURLException ex) {
            AppLogger.warn((Throwable)ex);
            return null;
        }
    }

    public JPanel getROISelectionPanel(String imageName, ImageDimensions id, VoxelDimensions vd, JButton loadButton) {
        return this.getSelectionPanel();
    }

    public String getSelectedAbsolutePath() {
        int space;
        if (!this.initialized) {
            this.init();
        }
        String name = this.level.getSelectedItem() + "_" + this.label.getSelectedItem();
        TalairachLoader.setLastUsedValues(this.level.getSelectedIndex(), this.label.getSelectedIndex());
        do {
            if ((space = name.indexOf(32)) == -1) continue;
            name = name.substring(0, space) + "_" + name.substring(space + 1);
        } while (space != -1);
        return "http://www.talairach.org/nii/gzip/" + name + ".nii.gzip";
    }

    public static void setLastUsedValues(int levelIndex, int labelIndex) {
        TalairachLoader.levelIndex = levelIndex;
        TalairachLoader.labelIndex = labelIndex;
    }

    public String getSelectedRelativePath() {
        return null;
    }

    public String getVersion() {
        return VERSION;
    }

    public boolean hasNewerVersion() {
        return false;
    }

    public boolean isImportingInWorldSpace() {
        return true;
    }

    public boolean isImportingROI() {
        return true;
    }

    public boolean isParametricOverlay() {
        return false;
    }

    public boolean isPublic() {
        return false;
    }

    public boolean isSaveable() {
        return false;
    }

    private JPanel getSelectionPanel() {
        if (!this.initialized) {
            this.init();
        }
        return this.panel;
    }

    private void init() {
        this.labels = new String[5][];
        this.labels[0] = new String[]{"Left Brainstem", "Left Cerebellum", "Left Cerebrum", "Inter-Hemispheric", "Right Brainstem", "Right Cerebellum", "Right Cerebrum"};
        this.labels[1] = new String[]{"Anterior Lobe", "Frontal Lobe", "Frontal-Temporal Space", "Limbic Lobe", "Medulla", "Midbrain", "Occipital Lobe", "Parietal Lobe", "Pons", "Posterior Lobe", "Sub-lobar", "Temporal Lobe"};
        this.labels[2] = new String[]{"Angular Gyrus", "Anterior Cingulate", "Caudate", "Cerebellar Lingual", "Cerebellar Tonsil", "Cingulate Gyrus", "Claustrum", "Culmen", "Culmen of Vermis", "Cuneus", "Declive", "Declive of Vermis", "Extra-Nuclear", "Fastigium", "Fourth Ventricle", "Fusiform Gyrus", "Inferior Frontal Gyrus", "Inferior Occipital Gyrus", "Inferior Parietal Lobule", "Inferior Semi-Lunar Lobule", "Inferior Temporal Gyrus", "Insula", "Lateral Ventricle", "Lentiform Nucleus", "Lingual Gyrus", "Medial Frontal Gyrus", "Middle Frontal Gyrus", "Middle Occipital Gyrus", "Middle Temporal Gyrus", "Nodule", "Orbital Gyrus", "Paracentral Lobule", "Parahippocampal Gyrus", "Postcentral Gyrus", "Posterior Cingulate", "Precentral Gyrus", "Precuneus", "Pyramis", "Pyramis of Vermis", "Rectal Gyrus", "Sub-Gyral", "Subcallosal Gyrus", "Superior Frontal Gyrus", "Superior Occipital Gyrus", "Superior Parietal Lobule", "Superior Temporal Gyrus", "Supramarginal Gyrus", "Thalamus", "Third Ventricle", "Transverse Temporal Gyrus", "Tuber", "Tuber of Vermis", "Uncus", "Uvula", "Uvula of Vermis"};
        this.labels[3] = new String[]{"Cerebro-Spinal Fluid", "Gray Matter", "White Matter"};
        this.labels[4] = new String[]{"Amygdala", "Anterior Commissure", "Anterior Nucleus", "Brodmann area 1", "Brodmann area 2", "Brodmann area 3", "Brodmann area 4", "Brodmann area 5", "Brodmann area 6", "Brodmann area 7", "Brodmann area 8", "Brodmann area 9", "Brodmann area 10", "Brodmann area 11", "Brodmann area 13", "Brodmann area 17", "Brodmann area 18", "Brodmann area 19", "Brodmann area 20", "Brodmann area 21", "Brodmann area 22", "Brodmann area 23", "Brodmann area 24", "Brodmann area 25", "Brodmann area 27", "Brodmann area 28", "Brodmann area 29", "Brodmann area 30", "Brodmann area 31", "Brodmann area 32", "Brodmann area 33", "Brodmann area 34", "Brodmann area 35", "Brodmann area 36", "Brodmann area 37", "Brodmann area 38", "Brodmann area 39", "Brodmann area 40", "Brodmann area 41", "Brodmann area 42", "Brodmann area 43", "Brodmann area 44", "Brodmann area 45", "Brodmann area 46", "Brodmann area 47", "Caudate Body", "Caudate Head", "Caudate Tail", "Corpus Callosum", "Dentate", "Hippocampus", "Hypothalamus", "Lateral Dorsal Nucleus", "Lateral Geniculum Body", "Lateral Globus Pallidus", "Lateral Posterior Nucleus", "Mammillary Body", "Medial Dorsal Nucleus", "Medial Geniculum Body", "Medial Globus Pallidus", "Midline Nucleus", "Optic Tract", "Pulvinar", "Putamen", "Red Nucleus", "Substania Nigra", "Subthalamic Nucleus", "Ventral Anterior Nucleus", "Ventral Lateral Nucleus", "Ventral Posterior Lateral Nucleus", "Ventral Posterior Medial Nucleus"};
        this.level = new JComboBox<String>(new String[]{"Hemisphere", "Lobe", "Gyrus", "Tissue", "Cell"});
        this.label = new JComboBox();
        this.level.addActionListener(this);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.add(this.level);
        this.panel.add(this.label);
        this.initialized = true;
        this.level.setSelectedIndex(levelIndex);
        this.label.setSelectedIndex(labelIndex);
    }

    private void updateLabels() {
        if (this.initialized) {
            this.label.setModel(new DefaultComboBoxModel<String>(this.labels[this.level.getSelectedIndex()]));
        }
    }
}

