/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.platform;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Properties;

public final class Platform {
    private static String archOS;
    private static String jarDir;
    private static String javaHome;
    private static String fslPath;
    private static boolean isRetinaCapable;
    private static boolean is64BitMacOS;
    private static boolean applet;
    private static boolean sandboxed;
    private static boolean system64Bit;
    public static final long BIT32_MODE_MAX_DIRECT = 0x60000000L;
    public static final long BIT64_MODE_MAX_DIRECT = 0x200000000L;
    public static final String APP_MAC = "/Applications/Mango.app/Contents/MacOS/Mango";
    public static final String APP_UNIX;
    public static final String APP_WINDOWS;
    public static final String ARCH_JAVA;
    public static final String ATLAS_LOCATION_MAC = "/Library/Application Support/Mango/Atlases";
    public static final String ATLAS_LOCATION_UNIX = "/Mango/Atlases";
    public static final String ATLAS_LOCATION_WINDOWS = "\\Application Data\\Mango\\Atlases";
    public static final String FILTER_LOCATION_MAC = "/Library/Application Support/Mango/Filters";
    public static final String FILTER_LOCATION_UNIX = "/Mango/Filters";
    public static final String FILTER_LOCATION_WINDOWS = "\\Application Data\\Mango\\Filters";
    public static final String FSL_ATLAS_PATH_DEFAULT = "/usr/local/fsl/data/atlases";
    public static final String JAVA_VENDOR;
    public static final String JAVA_VERSION;
    public static final String LIBRARY_LOCATION_MAC = "/Library/Application Support/Mango/Library";
    public static final String LIBRARY_LOCATION_UNIX = "/Mango/Library";
    public static final String LIBRARY_LOCATION_WINDOWS = "\\Application Data\\Mango\\Library";
    public static final String LOG_DIR_MAC = "/Library/Logs";
    public static final String LOG_DIR_UNIX = "/Mango";
    public static final String LOG_DIR_WINDOWS = "\\Application Data\\Mango";
    public static final String LUT_LOCATION_MAC = "/Library/Application Support/Mango/LUTs";
    public static final String LUT_LOCATION_UNIX = "/Mango/LUTs";
    public static final String LUT_LOCATION_WINDOWS = "\\Application Data\\Mango\\LUTs";
    public static final String OS;
    public static final String PLUGIN_LOCATION_MAC = "/Library/Application Support/Mango/Plugins";
    public static final String PLUGIN_LOCATION_UNIX = "/Mango/Plugins";
    public static final String PLUGIN_LOCATION_WINDOWS = "\\Application Data\\Mango\\Plugins";
    public static final String SCRIPT_LOCATION_MAC = "/Library/Application Support/Mango/Scripts";
    public static final String SCRIPT_LOCATION_UNIX = "/Mango/Scripts";
    public static final String SCRIPT_LOCATION_WINDOWS = "\\Application Data\\Mango\\Scripts";
    public static final String PLUGIN_UNSUPPORTED_LOCATION_MAC = "/Library/Application Support/Mango/Plugins/Unsupported";
    public static final String PLUGIN_UNSUPPORTED_LOCATION_UNIX = "/Mango/Plugins/Unsupported";
    public static final String PLUGIN_UNSUPPORTED_LOCATION_WINDOWS = "\\Application Data\\Mango\\Plugins\\Unsupported";
    public static final String PREFERENCES_LOCATION_MAC = "/Library/Preferences/";
    public static final String PREFERENCES_LOCATION_UNIX = "/Mango";
    public static final String PREFERENCES_LOCATION_WINDOWS = "\\Application Data\\Mango";
    public static final String PREFERENCES_NAME = "Mango Preferences";
    public static final String SETTINGS_LOCATION_MAC = "/Library/Application Support/Mango/Settings";
    public static final String SETTINGS_LOCATION_UNIX = "/Mango/Settings";
    public static final String SETTINGS_LOCATION_WINDOWS = "\\Application Data\\Mango\\Settings";
    public static final String TEMP_DIR_MAC = "/Documents/MangoTempData";
    public static final String TEMP_DIR_UNIX = "/Mango/MangoTempData";
    public static final String TEMP_DIR_WINDOWS = "\\MangoTempData";
    public static final String VERSION;
    public static final String WINDOWS_EXE_DIR_PROPERTY = "windows.exedir";
    public static final List<String> BOURNE_COMPATIBLE_INIT_FILES;
    public static final List<String> CSHELL_COMPATIBLE_INIT_FILES;
    public static final boolean JAVA6;
    public static final boolean JAVA7;
    public static final boolean JAVA8;
    public static final boolean JAVA64BIT_DETECTED;
    public static final boolean LINUX;
    public static final boolean MAC;
    public static final boolean MODE_64_BIT;
    public static final boolean OSX_LEOPARD;
    public static final boolean OSX_TIGER;
    public static final boolean TOGGLE_64_BIT_CAPABLE;
    public static final boolean UNIX;
    public static final boolean WINDOWS;
    public static final int PROCESSOR_COUNT;
    public static final String VANILLA_PROPERTY_FILE = "vanilla.properties";
    public static final String VANILLA_PROPERTY_KEY = "vanilla";
    public static final boolean VANILLA;

    private Platform() {
    }

    public static String getArchOS() {
        return archOS;
    }

    public static File getAtlasDir() {
        File file = null;
        if (MAC) {
            file = new File(Platform.getHomeDirectory() + ATLAS_LOCATION_MAC, "");
        } else if (WINDOWS) {
            file = new File(Platform.getHomeDirectory() + ATLAS_LOCATION_WINDOWS, "");
        } else if (UNIX) {
            file = new File(Platform.getHomeDirectory() + ATLAS_LOCATION_UNIX, "");
        }
        return file;
    }

    public static File getDesktopDir() {
        File desktop = null;
        if (MAC) {
            desktop = new File(Platform.getHomeDirectory() + "/Desktop");
        } else if (WINDOWS) {
            desktop = new File(Platform.getHomeDirectory() + "\\Desktop");
        } else if (UNIX) {
            desktop = new File(Platform.getHomeDirectory() + "/Desktop");
        }
        return desktop;
    }

    public static File getFiltersDir() {
        File filterDir = null;
        if (MAC) {
            filterDir = new File(Platform.getHomeDirectory() + FILTER_LOCATION_MAC, "");
        } else if (WINDOWS) {
            filterDir = new File(Platform.getHomeDirectory() + FILTER_LOCATION_WINDOWS, "");
        } else if (UNIX) {
            filterDir = new File(Platform.getHomeDirectory() + FILTER_LOCATION_UNIX, "");
        }
        return filterDir;
    }

    public static String getHomeDirectory() {
        if (applet) {
            return "";
        }
        if (WINDOWS) {
            return Platform.findWindowsHomeDirectory();
        }
        return System.getProperty("user.home", "~");
    }

    public static String getJarDirectory() {
        return jarDir;
    }

    public static File getLibDir() {
        File libDir = null;
        if (MAC) {
            libDir = new File(Platform.getHomeDirectory(), LIBRARY_LOCATION_MAC);
        } else if (WINDOWS) {
            libDir = new File(Platform.getHomeDirectory(), LIBRARY_LOCATION_WINDOWS);
        } else if (UNIX) {
            libDir = new File(Platform.getHomeDirectory(), LIBRARY_LOCATION_UNIX);
        }
        return libDir;
    }

    public static File getLogDir() {
        File logDir = null;
        if (MAC) {
            logDir = new File(Platform.getHomeDirectory(), LOG_DIR_MAC);
        } else if (WINDOWS) {
            logDir = new File(Platform.getHomeDirectory(), "\\Application Data\\Mango");
        } else if (UNIX) {
            logDir = new File(Platform.getHomeDirectory(), "/Mango");
        }
        return logDir;
    }

    public static File getLUTDir() {
        File lutDir = null;
        if (MAC) {
            lutDir = new File(Platform.getHomeDirectory() + LUT_LOCATION_MAC, "");
        } else if (WINDOWS) {
            lutDir = new File(Platform.getHomeDirectory() + LUT_LOCATION_WINDOWS, "");
        } else if (UNIX) {
            lutDir = new File(Platform.getHomeDirectory() + LUT_LOCATION_UNIX, "");
        }
        return lutDir;
    }

    public static File getPluginDir() {
        File file = null;
        if (MAC) {
            file = new File(Platform.getHomeDirectory() + PLUGIN_LOCATION_MAC, "");
        } else if (WINDOWS) {
            file = new File(Platform.getHomeDirectory() + PLUGIN_LOCATION_WINDOWS, "");
        } else if (UNIX) {
            file = new File(Platform.getHomeDirectory() + PLUGIN_LOCATION_UNIX, "");
        }
        return file;
    }

    public static File getScriptsDir() {
        File file = null;
        if (MAC) {
            file = new File(Platform.getHomeDirectory() + SCRIPT_LOCATION_MAC, "");
        } else if (WINDOWS) {
            file = new File(Platform.getHomeDirectory() + SCRIPT_LOCATION_WINDOWS, "");
        } else if (UNIX) {
            file = new File(Platform.getHomeDirectory() + SCRIPT_LOCATION_UNIX, "");
        }
        return file;
    }

    public static File getPreferencesFile() {
        File prefFile = null;
        if (MAC) {
            prefFile = new File(Platform.getHomeDirectory() + PREFERENCES_LOCATION_MAC, PREFERENCES_NAME);
        } else if (WINDOWS) {
            prefFile = new File(Platform.getHomeDirectory() + "\\Application Data\\Mango", PREFERENCES_NAME);
        } else if (UNIX) {
            prefFile = new File(Platform.getHomeDirectory() + "/Mango", PREFERENCES_NAME);
        }
        return prefFile;
    }

    public static File getSettingsDir() {
        File lutDir = null;
        if (MAC) {
            lutDir = new File(Platform.getHomeDirectory() + SETTINGS_LOCATION_MAC, "");
        } else if (WINDOWS) {
            lutDir = new File(Platform.getHomeDirectory() + SETTINGS_LOCATION_WINDOWS, "");
        } else if (UNIX) {
            lutDir = new File(Platform.getHomeDirectory() + SETTINGS_LOCATION_UNIX, "");
        }
        return lutDir;
    }

    public static File getTempDir() {
        if (MAC) {
            return new File(Platform.getHomeDirectory(), TEMP_DIR_MAC);
        }
        if (WINDOWS) {
            return new File(Platform.getHomeDirectory(), TEMP_DIR_WINDOWS);
        }
        if (UNIX) {
            return new File(Platform.getHomeDirectory(), TEMP_DIR_UNIX);
        }
        return null;
    }

    public static File getUnsupportedPluginDir() {
        File file = null;
        if (MAC) {
            file = new File(Platform.getHomeDirectory() + PLUGIN_UNSUPPORTED_LOCATION_MAC, "");
        } else if (WINDOWS) {
            file = new File(Platform.getHomeDirectory() + PLUGIN_UNSUPPORTED_LOCATION_WINDOWS, "");
        } else if (UNIX) {
            file = new File(Platform.getHomeDirectory() + PLUGIN_UNSUPPORTED_LOCATION_UNIX, "");
        }
        return file;
    }

    public static boolean isRetinaCapable() {
        return isRetinaCapable;
    }

    private static void setArchOS(String archOS) {
        Platform.archOS = archOS;
    }

    private static String findWindowsHomeDirectory() {
        try {
            File userHome = new File(System.getProperty("user.home", ""));
            if (userHome.exists()) {
                return userHome.getCanonicalPath();
            }
            String homeDrive = System.getenv("HOMEDRIVE");
            String homePath = System.getenv("HOMEPATH");
            File homeDrivePath = new File(homeDrive + "\\" + homePath);
            if (homeDrivePath.exists()) {
                return homeDrivePath.getCanonicalPath();
            }
            File vistaHome = new File("C:\\Users\\" + System.getProperty("user.name"));
            if (vistaHome.exists()) {
                return vistaHome.getCanonicalPath();
            }
            File xpHome = new File("C:\\Documents and Settings\\" + System.getProperty("user.name"));
            if (xpHome.exists()) {
                return xpHome.getCanonicalPath();
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        return Platform.getJarDirectory();
    }

    public static boolean isApplet() {
        return applet;
    }

    public static boolean isSandboxed() {
        return sandboxed;
    }

    public static void setSandboxed(boolean sandboxed) {
        Platform.sandboxed = sandboxed;
    }

    public static long getMaxDirectMemory() {
        if (MODE_64_BIT) {
            return 0x200000000L;
        }
        return 0x60000000L;
    }

    public static long getUsedDirectMemory() {
        long usedBytes = -1L;
        Field field = null;
        try {
            Class<?> bitsClass = Class.forName("java.nio.Bits");
            field = bitsClass.getDeclaredField("reservedMemory");
            if (field != null) {
                field.setAccessible(true);
                Object obj = field.get(null);
                if (obj instanceof Long) {
                    usedBytes = (Long)obj;
                }
            }
        }
        catch (NoSuchFieldException ex) {
            AppLogger.warn((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            AppLogger.warn((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            AppLogger.warn((Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            AppLogger.warn((Throwable)ex);
        }
        return usedBytes;
    }

    public static String getJavaHome() {
        return javaHome;
    }

    public static String getFslPath() {
        return fslPath;
    }

    public static String getDefaultMetaKeyName() {
        if (MAC) {
            return "Command";
        }
        return "Control";
    }

    public static boolean isSystem64Bit() {
        return system64Bit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ARCH_JAVA = System.getProperty("os.arch", "").toLowerCase();
        JAVA_VENDOR = System.getProperty("java.vendor", "");
        JAVA_VERSION = System.getProperty("java.version", "");
        OS = System.getProperty("os.name", "").toUpperCase();
        VERSION = System.getProperty("os.version", "").toUpperCase();
        BOURNE_COMPATIBLE_INIT_FILES = CollectionUtilities.immutable((String[])new String[]{".bash_profile", ".bashrc", ".profile", ".kshrc", ".zshrc"});
        CSHELL_COMPATIBLE_INIT_FILES = CollectionUtilities.immutable((String[])new String[]{".cshrc", ".tcshrc"});
        JAVA6 = JAVA_VERSION.startsWith("1.6");
        JAVA7 = JAVA_VERSION.startsWith("1.7");
        JAVA8 = JAVA_VERSION.startsWith("1.8");
        JAVA64BIT_DETECTED = ARCH_JAVA.indexOf("64") != -1;
        LINUX = OS.indexOf("LINUX") != -1;
        MAC = OS.indexOf("MAC") != -1;
        MODE_64_BIT = JAVA64BIT_DETECTED && Runtime.getRuntime().maxMemory() > 1000000000L;
        OSX_LEOPARD = VERSION.trim().startsWith("10.5");
        OSX_TIGER = VERSION.trim().startsWith("10.4");
        UNIX = OS.indexOf("LINUX") != -1 || OS.indexOf("SUNOS") != -1 || OS.indexOf("SOLARIS") != -1 || OS.indexOf("AIX") != -1 || OS.indexOf("UNIX") != -1 || OS.indexOf("FREEBSD") != -1 || OS.indexOf("IRIX") != -1;
        WINDOWS = OS.indexOf("WINDOWS") != -1;
        PROCESSOR_COUNT = Runtime.getRuntime().availableProcessors();
        try {
            Class.forName("edu.uthscsa.ric.mango.applet.MangoApplet");
            applet = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!applet) {
            javaHome = System.getProperty("java.home", "");
        }
        archOS = ARCH_JAVA;
        if (!applet) {
            String line;
            Process proc;
            BufferedReader input;
            if (MAC) {
                input = null;
                try {
                    proc = Runtime.getRuntime().exec("sysctl hw");
                    input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    while ((line = input.readLine()) != null) {
                        if (line.length() <= 0 || line.indexOf("cpu64bit_capable") == -1 || !line.trim().endsWith("1")) continue;
                        is64BitMacOS = true;
                        Platform.setArchOS("x86_64");
                        break;
                    }
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException ex) {
                        AppLogger.warn((Throwable)ex);
                    }
                }
                system64Bit |= is64BitMacOS;
            } else if (WINDOWS) {
                input = null;
                try {
                    proc = Runtime.getRuntime().exec("reg query HKEY_LOCAL_MACHINE\\HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0");
                    input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    while ((line = input.readLine()) != null) {
                        if (!(line = line.trim().toLowerCase()).startsWith("identifier")) continue;
                        if (line.indexOf("64") == -1) break;
                        Platform.setArchOS("x86_64");
                    }
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException ex) {
                        AppLogger.warn((Throwable)ex);
                    }
                }
            } else if (LINUX) {
                input = null;
                try {
                    proc = Runtime.getRuntime().exec("uname -m -p");
                    input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    while ((line = input.readLine()) != null) {
                        if (line.length() <= 0) continue;
                        Platform.setArchOS(line.toLowerCase());
                        break;
                    }
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException ex) {
                        AppLogger.warn((Throwable)ex);
                    }
                }
            }
        }
        TOGGLE_64_BIT_CAPABLE = system64Bit = Platform.getArchOS().indexOf("x86_64") != -1 || Platform.getArchOS().indexOf("x86-64") != -1 || Platform.getArchOS().indexOf("x64") != -1 || Platform.getArchOS().indexOf("amd64") != -1 || Platform.getArchOS().indexOf("ia64") != -1 || Platform.getArchOS().indexOf("ppc64") != -1 || Platform.getArchOS().indexOf("Intel64") != -1;
        String foundPath = null;
        if (!applet && (MAC || UNIX)) {
            String line;
            Process proc;
            ProcessBuilder pb;
            BufferedReader input;
            for (String element : BOURNE_COMPATIBLE_INIT_FILES) {
                input = null;
                try {
                    pb = new ProcessBuilder(new String[0]);
                    pb.directory(new File(Platform.getHomeDirectory()));
                    pb.command("cat", element);
                    proc = pb.start();
                    input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    while ((line = input.readLine()) != null) {
                        if (line.length() <= 0 || line.indexOf("FSLDIR=") == -1) continue;
                        int equalsIndex = line.indexOf(61);
                        foundPath = line.substring(equalsIndex + 1).trim() + "/data/atlases";
                    }
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException ex) {
                        AppLogger.warn((Throwable)ex);
                    }
                }
                if (foundPath == null) continue;
                break;
            }
            if (foundPath == null) {
                for (String element : CSHELL_COMPATIBLE_INIT_FILES) {
                    input = null;
                    try {
                        pb = new ProcessBuilder(new String[0]);
                        pb.directory(new File(Platform.getHomeDirectory()));
                        pb.command("cat", element);
                        proc = pb.start();
                        input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        while ((line = input.readLine()) != null) {
                            if (line.length() <= 0 || line.indexOf("setenv FSLDIR") == -1) continue;
                            int startIndex = line.indexOf("FSLDIR") + 6;
                            foundPath = line.substring(startIndex).trim() + "/data/atlases";
                        }
                    }
                    catch (IOException ex) {
                        AppLogger.warn((Throwable)ex);
                    }
                    finally {
                        try {
                            if (input != null) {
                                input.close();
                            }
                        }
                        catch (IOException ex) {
                            AppLogger.warn((Throwable)ex);
                        }
                    }
                    if (foundPath == null) continue;
                    break;
                }
            }
        }
        fslPath = foundPath != null ? foundPath : FSL_ATLAS_PATH_DEFAULT;
        if (!applet) {
            try {
                URI jarURI = Platform.class.getProtectionDomain().getCodeSource().getLocation().toURI();
                if (jarURI.getScheme().equals("file")) {
                    jarDir = new File(Platform.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
                }
            }
            catch (URISyntaxException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        APP_UNIX = Platform.getJarDirectory() + "/mango";
        APP_WINDOWS = Platform.getJarDirectory() + "/Mango.exe";
        if (MAC && !applet) {
            Object obj = Toolkit.getDefaultToolkit().getDesktopProperty("apple.awt.contentScaleFactor");
            if (obj != null) {
                if (obj instanceof Float) {
                    Float f = (Float)obj;
                    int scale = f.intValue();
                    isRetinaCapable = scale == 2;
                }
            } else {
                try {
                    GraphicsDevice graphicsDevice;
                    Field field;
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    if (!ge.isHeadlessInstance() && (field = (graphicsDevice = ge.getDefaultScreenDevice()).getClass().getDeclaredField("scale")) != null) {
                        field.setAccessible(true);
                        Object scale = field.get(graphicsDevice);
                        if (scale instanceof Integer && (Integer)scale == 2) {
                            isRetinaCapable = true;
                        }
                    }
                }
                catch (NoSuchFieldException ex) {
                    AppLogger.error((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    AppLogger.error((Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    AppLogger.error((Throwable)ex);
                }
            }
        }
        Properties props = new Properties();
        InputStream is = null;
        boolean vanilla = false;
        try {
            is = Mango.class.getResourceAsStream(VANILLA_PROPERTY_FILE);
            if (is != null) {
                props.load(is);
                vanilla = Boolean.parseBoolean((String)props.get(VANILLA_PROPERTY_KEY));
            }
        }
        catch (IOException ex) {
            AppLogger.warn((Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    AppLogger.error((Throwable)ex);
                }
            }
        }
        VANILLA = vanilla;
    }
}

