/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.platform;

import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.utilities.AppLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public final class FireFoxFix {
    public static final File LOCATION = new File(Platform.getHomeDirectory() + "/Library/Application Support/FireFox/Profiles/");
    public static final String FILENAME = "user.js";
    public static final String PREF = "user_pref(\"network.protocol-handler.expose.mango\", false);";

    private FireFoxFix() {
    }

    public static void fixIt() {
        try {
            File[] files;
            if (Platform.MAC && LOCATION.exists() && (files = LOCATION.listFiles()) != null) {
                for (File file : files) {
                    File fileToWrite;
                    if (!file.isDirectory() || (fileToWrite = new File(file, FILENAME)).exists()) continue;
                    FireFoxFix.writeFile(fileToWrite);
                }
            }
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    private static void writeFile(File file) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
            writer.println(PREF);
        }
        catch (Exception ex) {
            AppLogger.warn((Throwable)ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }
}

