/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.menus;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.window.ToolboxAssociated;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.StringUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AboutDialog
extends JFrame
implements ToolboxAssociated {
    private BufferedImage image;
    private RescaleOp imageOp;
    private final SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
    public static final String DESCRIPTION = "About Mango";
    public static final long serialVersionUID = 1L;

    public AboutDialog(final Mango mango) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                AboutDialog.this.setVisible(false);
            }
        });
        JLabel titleLabel = new JLabel("Mango " + mango.getVersionDescriptor());
        titleLabel.setFont(new Font("SansSerif", 1, 24));
        JLabel versionLabel = new JLabel("Version: " + mango.getVersion() + " (" + mango.getBuildNumber() + ")");
        versionLabel.setFont(new Font("SansSerif", 1, 12));
        JLabel dateLabel = new JLabel(mango.getBuildDate());
        dateLabel.setFont(new Font("SansSerif", 1, 12));
        JLabel javaLabel = new JLabel("JRE: " + Platform.JAVA_VERSION + " (" + (Platform.JAVA64BIT_DETECTED ? "64-bit" : "32-bit") + ")");
        javaLabel.setFont(new Font("SansSerif", 1, 12));
        JLabel javaPluginLabel = new JLabel("Java Plugin: " + (mango.isPlugin2() ? "Version 2" : "Version 1"));
        javaPluginLabel.setFont(new Font("SansSerif", 1, 12));
        String memoryString = "Memory: " + StringUtilities.makeNiceFileSizeString((long)Runtime.getRuntime().maxMemory()) + " (" + StringUtilities.makeNiceFileSizeString((long)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())) + " used)";
        JLabel memoryLabel = new JLabel(memoryString);
        memoryLabel.setFont(new Font("SansSerif", 1, 12));
        JLabel osLabel = new JLabel("OS: " + Platform.OS + " " + Platform.VERSION);
        osLabel.setFont(new Font("SansSerif", 1, 12));
        JLabel platformLabel = new JLabel("Platform: " + Platform.getArchOS());
        platformLabel.setFont(new Font("SansSerif", 1, 12));
        JLabel linkLabel = new JLabel("<html>Website: <a href=\"http://rii.uthscsa.edu/mango/\">http://rii.uthscsa.edu/mango/</a></html>");
        linkLabel.setFont(new Font("SansSerif", 0, 10));
        linkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                mango.openURL("http://rii.uthscsa.edu/mango/");
            }
        });
        JLabel textLabel1 = new JLabel("Jack L. Lancaster, Ph.D., Michael J. Martinez");
        textLabel1.setFont(new Font("SansSerif", 0, 10));
        JLabel textLabel2 = new JLabel("<html>&copy; " + this.yearFormat.format(new Date()) + " <a href=\"http://rii.uthscsa.edu/\">Research Imaging Institute</a>, UTHSCSA</html>");
        textLabel2.setFont(new Font("SansSerif", 0, 10));
        textLabel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                mango.openURL("http://rii.uthscsa.edu");
            }
        });
        BufferedImage img = null;
        try {
            img = ImageIO.read(Mango.class.getResource("images/mango_icon_app.png"));
            int width = img.getWidth(null);
            int height = img.getHeight(null);
            this.image = new BufferedImage(width, height, 2);
            Graphics g = this.image.getGraphics();
            g.drawImage(img, 0, 0, null);
            float[] scales = new float[]{1.0f, 1.0f, 1.0f, 0.75f};
            float[] offsets = new float[4];
            this.imageOp = new RescaleOp(scales, offsets, null);
        }
        catch (Exception ex) {
            AppLogger.warn((Throwable)ex);
        }
        JPanel mainPanelIn = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics gph) {
                super.paintComponent(gph);
                if (AboutDialog.this.image != null) {
                    Graphics2D g2d = (Graphics2D)gph;
                    g2d.drawImage(AboutDialog.this.image, AboutDialog.this.imageOp, this.getWidth() - AboutDialog.this.image.getWidth(), 5);
                }
            }
        };
        mainPanelIn.setLayout(new BoxLayout(mainPanelIn, 1));
        mainPanelIn.add(titleLabel);
        mainPanelIn.add(versionLabel);
        mainPanelIn.add(dateLabel);
        if (mango.isApplet()) {
            mainPanelIn.add(Box.createVerticalStrut(10));
            mainPanelIn.add(javaLabel);
            mainPanelIn.add(javaPluginLabel);
            mainPanelIn.add(memoryLabel);
            mainPanelIn.add(osLabel);
            mainPanelIn.add(platformLabel);
        }
        mainPanelIn.add(Box.createVerticalStrut(10));
        mainPanelIn.add(linkLabel);
        mainPanelIn.add(Box.createVerticalStrut(6));
        mainPanelIn.add(textLabel1);
        mainPanelIn.add(textLabel2);
        mainPanelIn.setBackground(new Color(0xEEEEEE));
        mainPanelIn.setBorder(BorderFactory.createEmptyBorder(10, 15, 15, 15));
        this.setIconImage(MangoStyle.ICON_APP.getImage());
        this.setBackground(Color.WHITE);
        this.setContentPane(mainPanelIn);
        this.setResizable(false);
        this.validate();
        this.pack();
        if (mango.isApplet()) {
            this.setLocation(DisplayUtils.getCenterDialogLocation(Mango.getMangoApplet(), this.getSize()));
        } else {
            this.setLocation(DisplayUtils.getCenterDialogLocation(mango.getToolBox(), this.getSize()));
        }
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public JFrame getWindow() {
        return this;
    }
}

