/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.stats;

import edu.uthscsa.ric.mango.dialogs.stats.Result;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.SeriesDefaultLabels;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import java.lang.ref.WeakReference;
import org.apache.commons.lang3.StringUtils;

public class Statistic
implements Result {
    private boolean addBorder;
    private final AnalysisImpl analysis;
    private final Coordinate viewerOrigin;
    private final String viewerName;
    private final String description;
    private final WeakReference<SliceViewer> viewer;
    private final WeakReference<Volume> volume;
    private final double sizeX;
    private final double sizeY;
    private final double sizeZ;
    private final int xDim;
    private final int yDim;
    private final int zDim;
    private final int seriesPoint;

    protected Statistic(AnalysisImpl analysis, SliceViewer viewer, Volume volume) {
        this.analysis = analysis;
        this.viewer = new WeakReference<SliceViewer>(viewer);
        this.volume = new WeakReference<Volume>(volume);
        this.viewerName = viewer.toString();
        this.viewerOrigin = viewer.getOrigin();
        this.sizeX = viewer.getVolume().getXSize();
        this.sizeY = viewer.getVolume().getYSize();
        this.sizeZ = viewer.getVolume().getZSize();
        this.xDim = viewer.getVolume().getXDim();
        this.yDim = viewer.getVolume().getYDim();
        this.zDim = viewer.getVolume().getZDim();
        this.description = this.makeDescription();
        this.seriesPoint = this.makeSeriesPoint();
    }

    public AnalysisImpl getAnalysis() {
        return this.analysis;
    }

    @Override
    public double getSizeX() {
        return this.sizeX;
    }

    @Override
    public double getSizeY() {
        return this.sizeY;
    }

    @Override
    public double getSizeZ() {
        return this.sizeZ;
    }

    public SliceViewer getViewer() {
        return (SliceViewer)this.viewer.get();
    }

    public String getViewerName() {
        return this.viewerName;
    }

    @Override
    public Coordinate getViewerOrigin() {
        return this.viewerOrigin;
    }

    @Override
    public final Volume getVolume() {
        return (Volume)this.volume.get();
    }

    @Override
    public int getXDim() {
        return this.xDim;
    }

    @Override
    public int getYDim() {
        return this.yDim;
    }

    @Override
    public int getZDim() {
        return this.zDim;
    }

    @Override
    public boolean isAddBorder() {
        return this.addBorder;
    }

    @Override
    public boolean isDisplayGotoButton() {
        if (this.getAnalysis().getType() == 7) {
            return false;
        }
        return !this.isViewerClosed();
    }

    public boolean isViewerClosed() {
        SliceViewer msv = (SliceViewer)this.viewer.get();
        if (msv == null) {
            return true;
        }
        return msv.isCleared();
    }

    public void setAddBorder(boolean addBorder) {
        this.addBorder = addBorder;
    }

    private String makeDescription() {
        String des = this.getAnalysis().getDescription();
        String seriesLabel = "";
        Volume vol = this.getVolume();
        Coordinate4D coordinate = this.getAnalysis().getMaxCoordinate();
        if (coordinate != null && this.getAnalysis().getType() != 4 && this.getAnalysis().getType() != 7 && vol != null && vol.isInitialized() && vol.getNumTimepoints() > 1) {
            seriesLabel = vol.getLabel(coordinate.getSeriesPoint(), SeriesDefaultLabels.getDefaultLabel(coordinate.getSeriesPoint(), vol));
        }
        if (StringUtils.isNotBlank((CharSequence)seriesLabel)) {
            des = des + " (" + seriesLabel + ")";
        }
        return des;
    }

    private int makeSeriesPoint() {
        if (this.getAnalysis().getType() != 4 && this.getAnalysis().getType() != 7) {
            Coordinate4D coordinate = this.getAnalysis().getMaxCoordinate();
            return coordinate.getSeriesPoint();
        }
        return 0;
    }

    public int getSeriesPoint() {
        return this.seriesPoint;
    }

    public String getDescription() {
        return this.description;
    }
}

