/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.stats;

import edu.uthscsa.ric.mango.dialogs.stats.Result;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class RowNumberTable
extends JTable
implements ChangeListener,
PropertyChangeListener {
    private final JTable main;
    private static final long serialVersionUID = 1L;
    public static final int COL_WIDTH = 40;

    public RowNumberTable(JTable table) {
        this.main = table;
        this.main.addPropertyChangeListener(this);
        this.setFocusable(false);
        this.setAutoCreateColumnsFromModel(false);
        this.setSelectionModel(this.main.getSelectionModel());
        TableColumn column = new TableColumn();
        column.setHeaderValue(" ");
        this.addColumn(column);
        column.setCellRenderer(new RowNumberRenderer());
        this.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container c = this.getParent();
        if (c instanceof JViewport) {
            JViewport viewport = (JViewport)c;
            viewport.addChangeListener(this);
        }
    }

    @Override
    public int getRowCount() {
        return this.main.getRowCount();
    }

    @Override
    public int getRowHeight(int row) {
        int rowHeight = this.main.getRowHeight(row);
        if (rowHeight != super.getRowHeight(row)) {
            super.setRowHeight(row, rowHeight);
        }
        return rowHeight;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return Integer.toString(row + 1);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("selectionModel".equals(e.getPropertyName())) {
            this.setSelectionModel(this.main.getSelectionModel());
        }
        if ("rowHeight".equals(e.getPropertyName())) {
            this.repaint();
        }
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JViewport viewport = (JViewport)e.getSource();
        JScrollPane scrollPane = (JScrollPane)viewport.getParent();
        scrollPane.getVerticalScrollBar().setValue(viewport.getViewPosition().y);
    }

    private class RowNumberRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        public RowNumberRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            Result stat = (Result)RowNumberTable.this.main.getValueAt(row, col);
            if (stat.isAddBorder()) {
                this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            } else {
                this.setBorder(BorderFactory.createLineBorder(Color.WHITE));
            }
            cell.setBackground(Color.LIGHT_GRAY);
            cell.setForeground(Color.DARK_GRAY);
            return cell;
        }
    }
}

