/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.stats;

import edu.uthscsa.ric.mango.dialogs.stats.Result;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public final class ButtonColumn
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
ActionListener,
MouseListener {
    private Border focusBorder;
    private Object editorValue;
    private boolean isButtonColumnEditor;
    private int mnemonic;
    private final Action action;
    private final Border originalBorder;
    private final JButton editButton;
    private final JButton renderButton;
    private final JTable table;
    private static final long serialVersionUID = 1L;

    public ButtonColumn(JTable table, Action action, int column) {
        this.table = table;
        this.action = action;
        this.renderButton = new BasicArrowButton(7);
        this.editButton = new BasicArrowButton(7);
        this.editButton.setFocusPainted(false);
        this.editButton.addActionListener(this);
        this.originalBorder = this.editButton.getBorder();
        this.setFocusBorder(BorderFactory.createLineBorder(Color.GRAY));
        TableColumnModel columnModel = table.getColumnModel();
        columnModel.getColumn(column).setCellRenderer(this);
        columnModel.getColumn(column).setCellEditor(this);
        table.addMouseListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int row = this.table.convertRowIndexToModel(this.table.getEditingRow());
        this.fireEditingStopped();
        ActionEvent event = new ActionEvent(this.table, 1001, String.valueOf(row));
        this.action.actionPerformed(event);
    }

    @Override
    public Object getCellEditorValue() {
        return this.editorValue;
    }

    public Border getFocusBorder() {
        return this.focusBorder;
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Result result = (Result)value;
        if (!result.isDisplayGotoButton()) {
            return null;
        }
        this.editorValue = value;
        return this.editButton;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(value instanceof Result)) {
            return null;
        }
        Result result = (Result)value;
        if (!result.isDisplayGotoButton()) {
            return null;
        }
        if (hasFocus) {
            this.renderButton.setBorder(this.focusBorder);
        } else {
            this.renderButton.setBorder(this.originalBorder);
        }
        return this.renderButton;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.table.isEditing() && this.table.getCellEditor() == this) {
            this.isButtonColumnEditor = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isButtonColumnEditor && this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.isButtonColumnEditor = false;
    }

    public void setFocusBorder(Border focusBorder) {
        this.focusBorder = focusBorder;
        this.editButton.setBorder(focusBorder);
    }

    public void setMnemonic(int mnemonic) {
        this.mnemonic = mnemonic;
        this.renderButton.setMnemonic(mnemonic);
        this.editButton.setMnemonic(mnemonic);
    }
}

