/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.snapshot;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPane;
import edu.uthscsa.ric.mango.core.Capturable;
import edu.uthscsa.ric.mango.dialogs.modal.file.SaveFileDialog;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.DesktopUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Snapshot
extends JFrame
implements ActionListener {
    private JButton snapshotButton;
    private JRadioButton desktopButton;
    private JTextField snapshotText;
    private JButton playFileButton;
    private JButton showFileButton;
    private final Capturable capturable;
    private final SliceViewer viewer;
    private static final long serialVersionUID = 1L;
    public static final String ACTION_PLAY = "ACTION_PLAY";
    public static final String ACTION_SHOW = "ACTION_SHOW";
    public static final String ACTION_TAKE = "ACTION_TAKE";
    public static final String ACTION_LOCATION = "ACTION_LOCATION";
    public static final String ACTION_SELECT_FILE = "ACTION_SELECT_FILE";
    public static final String EXTENSION = ".png";
    public static final String NAME = "Create Snapshot";
    public static final int PADDING = 8;

    public Snapshot(SliceViewer viewer, Capturable capturable) {
        this.viewer = viewer;
        this.capturable = capturable;
        this.createUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals(ACTION_TAKE)) {
            this.capture();
        } else if (command.equalsIgnoreCase(ACTION_LOCATION)) {
            this.updateSnapshotFileText();
            this.updateEnabled();
        } else if (command.equals(ACTION_PLAY)) {
            this.play();
        } else if (command.equals(ACTION_SHOW)) {
            this.showFile();
        } else if (command.equals(ACTION_SELECT_FILE)) {
            this.editSaveFile();
            this.updateEnabled();
        }
    }

    private void editSaveFile() {
        File snapshotFile = new File(this.snapshotText.getText());
        File saveFile = SaveFileDialog.showSaveFileChooser(this, snapshotFile.getParent(), snapshotFile.getName());
        if (saveFile != null) {
            this.snapshotText.setText(saveFile.toString());
        }
        this.updateEnabled();
    }

    private void play() {
        DesktopUtilities.openFile((File)new File(this.snapshotText.getText()));
    }

    private void showFile() {
        DesktopUtilities.revealAndSelect((File)new File(this.snapshotText.getText()));
    }

    private void capture() {
        File file = FileUtilities.replaceExtension((File)new File(this.snapshotText.getText()), (String)EXTENSION);
        if (file.exists()) {
            MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this, (Object)"<html>This file already exists and will be overwritten.</html>", "Warning: File Exists", 2, null, 2, (Object[])new String[]{"Continue", "Cancel"}, (Object)"Cancel");
            jopf.show();
            String returnValue = jopf.getReturnOption();
            if (returnValue.equals("Cancel")) {
                return;
            }
        }
        Snapshot.takeSnapshot(file.toString(), this.capturable);
        this.capturable.recordAction("captureSnapshot", new String[]{this.viewer.getScriptObjectName() + ".makeFilename(\"" + EXTENSION + "\")"}, true);
        this.updateEnabled();
    }

    public static void takeSnapshot(String location, Capturable capturable) {
        BufferedImage image = capturable.captureImage();
        File file = FileUtilities.replaceExtension((File)new File(location), (String)EXTENSION);
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (Exception ex) {
            AppLogger.warn((Throwable)ex);
        }
    }

    public void takeSnapshot() {
        this.capture();
    }

    private void createUI() {
        JLabel locationLabel = new JLabel("Location: ");
        this.desktopButton = new JRadioButton("Desktop");
        this.desktopButton.addActionListener(this);
        this.desktopButton.setActionCommand(ACTION_LOCATION);
        JRadioButton imageButton = new JRadioButton("Image Folder");
        imageButton.addActionListener(this);
        imageButton.setActionCommand(ACTION_LOCATION);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.desktopButton);
        bg.add(imageButton);
        if (Mango.getInstance().isCaptureToDesktop()) {
            this.desktopButton.setSelected(true);
        } else {
            imageButton.setSelected(true);
        }
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 0));
        optionsPanel.add(locationLabel);
        optionsPanel.add(this.desktopButton);
        optionsPanel.add(imageButton);
        optionsPanel.add(Box.createHorizontalGlue());
        JLabel fileLabel = new JLabel("File: ");
        KeyAdapter kl = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                Snapshot.this.updateEnabled();
            }
        };
        this.snapshotText = new MangoTextField("", 25, kl, false, true);
        this.snapshotText.setMinimumSize(this.snapshotText.getPreferredSize());
        this.snapshotText.setMaximumSize(this.snapshotText.getPreferredSize());
        JButton snapshotFileSelectButton = new JButton("Select...");
        snapshotFileSelectButton.setActionCommand(ACTION_SELECT_FILE);
        snapshotFileSelectButton.addActionListener(this);
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BoxLayout(filePanel, 0));
        filePanel.add(fileLabel);
        filePanel.add(this.snapshotText);
        filePanel.add(Box.createHorizontalGlue());
        filePanel.add(snapshotFileSelectButton);
        this.playFileButton = new JButton("Open Snapshot");
        this.playFileButton.setActionCommand(ACTION_PLAY);
        this.playFileButton.addActionListener(this);
        this.showFileButton = new JButton("Show File");
        this.showFileButton.setActionCommand(ACTION_SHOW);
        this.showFileButton.addActionListener(this);
        this.snapshotButton = new JButton("Take", MangoStyle.ICON_CAMERA.get(0));
        this.snapshotButton.setPressedIcon(MangoStyle.ICON_CAMERA.get(1));
        this.snapshotButton.addActionListener(this);
        this.snapshotButton.setActionCommand(ACTION_TAKE);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(this.playFileButton);
        buttonPanel.add(this.showFileButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.snapshotButton);
        JLabel infoLabel = new JLabel("<html><center>Takes a snapshot of the " + this.capturable.getCaptureType() + " view.  Take faster snapshots<br />using " + Platform.getDefaultMetaKeyName() + "-p or the Toolbox camera button.</center></html>", 0);
        infoLabel.setForeground(Color.GRAY);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 0));
        infoPanel.add(infoLabel);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        mainPanel.add(optionsPanel);
        mainPanel.add(Box.createVerticalStrut(8));
        mainPanel.add(filePanel);
        mainPanel.add(Box.createVerticalStrut(8));
        mainPanel.add(buttonPanel);
        mainPanel.add(Box.createVerticalStrut(8));
        mainPanel.add(infoPanel);
        mainPanel.add(Box.createVerticalStrut(8));
        this.getContentPane().add((Component)mainPanel, "Center");
        this.setTitle("Create Snapshot: " + this.viewer.getImageTitle());
        this.viewer.associatePluginWindow(NAME, this);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocation(this.viewer.findGoodPluginWindowLocation(this.getSize()));
        this.setResizable(false);
        this.setVisible(true);
        this.snapshotButton.requestFocusInWindow();
        this.updateSnapshotFileText();
        this.updateEnabled();
    }

    private File makeSnapshotFile() {
        String filename = this.viewer.getImageTitle() + EXTENSION;
        File imageDir = this.desktopButton.isSelected() ? Platform.getDesktopDir() : this.viewer.getLoadedFile().getParentFile();
        File file = new File(imageDir, filename);
        return FileUtilities.findUniqueFilename((File)file);
    }

    private void updateSnapshotFileText() {
        this.snapshotText.setText(this.makeSnapshotFile().toString());
    }

    private void updateEnabled() {
        File snapshotFile = new File(this.snapshotText.getText());
        this.playFileButton.setEnabled(snapshotFile.exists());
        this.showFileButton.setEnabled(snapshotFile.exists());
    }
}

