/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.visualization.surface.primitives.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;

public class SurfaceShapeInput
extends AbstractInput
implements ActionListener {
    private final VolumeManager manager;
    private MangoComboBox<Shape> selectBox;
    private JCheckBox currentCoordinateBox;
    private final boolean allowCurrentPoint;
    private final boolean pointsOnly;
    private static final long serialVersionUID = 1L;

    public SurfaceShapeInput(String name, VolumeManager manager) {
        super(name);
        this.manager = manager;
        this.allowCurrentPoint = false;
        this.pointsOnly = false;
        this.createUI();
    }

    protected SurfaceShapeInput(String name, VolumeManager manager, boolean allowCurrentPoint, boolean pointsOnly) {
        super(name);
        this.manager = manager;
        this.allowCurrentPoint = allowCurrentPoint;
        this.pointsOnly = pointsOnly;
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String question = StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        ArrayList shapes = new ArrayList();
        shapes.addAll(this.manager.getSurfaceManager().getPoints());
        if (!this.pointsOnly) {
            shapes.addAll(this.manager.getSurfaceManager().getLines());
        }
        question = question + " [options: " + StringUtils.join(shapes, (String)", ") + "]?";
        this.ask(question);
    }

    private void createGUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel(StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName()) + ": "));
        ArrayList shapes = new ArrayList();
        shapes.addAll(this.manager.getSurfaceManager().getPoints());
        if (!this.pointsOnly) {
            shapes.addAll(this.manager.getSurfaceManager().getLines());
        }
        this.selectBox = new MangoComboBox<Shape>((T[])shapes.toArray(new Shape[shapes.size()]));
        this.add(this.selectBox);
        this.currentCoordinateBox = new JCheckBox("Current Coordinate");
        if (this.allowCurrentPoint) {
            this.currentCoordinateBox.setSelected(false);
            this.currentCoordinateBox.addActionListener(this);
            this.add(this.currentCoordinateBox);
        }
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            ArrayList shapes = new ArrayList();
            shapes.addAll(this.manager.getSurfaceManager().getPoints());
            if (!this.pointsOnly) {
                shapes.addAll(this.manager.getSurfaceManager().getLines());
            }
            ArrayList<String> shapeStrings = new ArrayList<String>();
            for (Shape shape : shapes) {
                shapeStrings.add(shape.toString());
            }
            while (!shapeStrings.contains(line.trim())) {
                this.createCLI();
                line = sc.nextLine();
            }
            sc.close();
            for (Shape shape : shapes) {
                if (!line.equals(shape.toString())) continue;
                return shape;
            }
            return null;
        }
        return this.currentCoordinateBox.isSelected() ? null : this.selectBox.getSelectedItem();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.selectBox.setEnabled(!this.currentCoordinateBox.isSelected());
    }
}

