/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.visualization.surface.primitives.Surface;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;

public class SurfaceInput
extends AbstractInput
implements ActionListener {
    private final VolumeManager manager;
    private JCheckBox allSurfaces;
    private MangoComboBox<Surface> selectBox;
    private final boolean allowMultiple;
    private static final long serialVersionUID = 1L;

    public SurfaceInput(String name, VolumeManager manager) {
        super(name);
        this.manager = manager;
        this.allowMultiple = false;
        this.createUI();
    }

    public SurfaceInput(String name, VolumeManager manager, boolean allowMultiple) {
        super(name);
        this.manager = manager;
        this.allowMultiple = allowMultiple;
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String question = StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        Surface[] surfaces = this.manager.getSurfaceManager().getSurfaces();
        ArrayList<String> surfaceStrings = new ArrayList<String>();
        for (Surface surface : surfaces) {
            surfaceStrings.add(surface.toString());
        }
        if (this.allowMultiple) {
            surfaceStrings.add(0, "all");
        }
        question = question + " [options: " + StringUtils.join(surfaceStrings, (String)", ") + "]?";
        this.ask(question);
    }

    private void createGUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel(StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName()) + ": "));
        this.selectBox = new MangoComboBox<Surface>((T[])this.manager.getSurfaceManager().getSurfaces());
        this.add(this.selectBox);
        this.allSurfaces = new JCheckBox("All");
        if (this.allowMultiple) {
            this.selectBox.setEnabled(false);
            this.allSurfaces.setSelected(true);
            this.allSurfaces.addActionListener(this);
            this.add(this.allSurfaces);
        }
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            Surface[] surfaces = this.manager.getSurfaceManager().getSurfaces();
            ArrayList<String> surfaceStrings = new ArrayList<String>();
            for (Surface surface : surfaces) {
                surfaceStrings.add(surface.toString());
            }
            if (this.allowMultiple) {
                surfaceStrings.add(0, "all");
            }
            while (!surfaceStrings.contains(line.trim())) {
                this.createCLI();
                line = sc.nextLine();
            }
            sc.close();
            if (line.equals("all")) {
                return null;
            }
            for (Surface surface : surfaces) {
                if (!line.equals(surface.toString())) continue;
                return surface;
            }
            return null;
        }
        return this.allSurfaces.isSelected() ? null : this.selectBox.getSelectedItem();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.selectBox.setEnabled(!this.allSurfaces.isSelected());
    }
}

