/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import java.util.List;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;

public class RotationAxisInput
extends AbstractInput {
    private MangoComboBox<String> selectBox;
    private final VolumeManager manager;
    private final int arg;
    private static final List<String> OPTIONS = CollectionUtilities.immutable((String[])new String[]{"About X", "About Y", "About Z"});
    private static final long serialVersionUID = 1L;

    public RotationAxisInput(String name, int arg, VolumeManager manager) {
        super(name);
        this.arg = arg;
        this.manager = manager;
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String question = StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        question = question + " (default: " + OPTIONS.get(this.arg) + ") [options: " + StringUtils.join(OPTIONS, (String)", ") + "]?";
        this.ask(question);
    }

    private void createGUI() {
        this.selectBox = new MangoComboBox<String>((T[])OPTIONS.toArray(new String[OPTIONS.size()]));
        if (this.arg == -1) {
            this.selectBox.setSelectedIndex(this.manager.getSliceDirection());
        } else {
            this.selectBox.setSelectedIndex(this.arg);
        }
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel(StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName()) + ": "));
        this.add(this.selectBox);
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            while (!OPTIONS.contains(line.trim()) && !StringUtils.isBlank((CharSequence)line)) {
                this.createCLI();
                line = sc.nextLine();
            }
            sc.close();
            if (StringUtils.isBlank((CharSequence)line)) {
                return this.arg;
            }
            return OPTIONS.indexOf(line);
        }
        return this.selectBox.getSelectedIndex();
    }
}

